# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 498-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53188);
 script_bugtraq_id(10244);
 script_cve_id("CVE-2004-0421");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 498-1 (libpng, libpng3)";
 script_name(name);

 desc = "The remote host is missing an update to libpng, libpng3
announced via advisory DSA 498-1.

Steve Grubb discovered a problem in the Portable Network Graphics
library libpng which is utilised in several applications.  When
processing a broken PNG image, the error handling routine will access
memory that is out of bounds when creating an error message.
Depending on machine architecture, bounds checking and other
protective measures, this problem could cause the program to crash if
a defective or intentionally prepared PNG image file is handled by
libpng.

This could be used as a denial of service attack against various
programs that link against this library.  The following commands will
show you which packages utilise this library and whose programs should
probably restarted after an upgrade:

apt-cache showpkg libpng2
apt-cache showpkg libpng3

The following security matrix explains which package versions will
contain a correction.

Package      stable (woody)          unstable (sid)
libpng     1.0.12-3.woody.5          1.0.15-5
libpng3    1.2.1-1.1.woody.5         1.2.5.0-6

We recommend that you upgrade your libpng and related packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20498-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 498-1 (libpng, libpng3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpng2", ver:"1.0.12-3.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2-dev", ver:"1.0.12-3.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng-dev", ver:"1.2.1-1.1.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.1-1.1.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
