#
#VID 214e8e07-d369-11dd-b800-001b77d09812
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 214e8e07-d369-11dd-b800-001b77d09812
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63092);
 script_bugtraq_id(32682);
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: vinagre";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: vinagre

=====

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.coresecurity.com/content/vinagre-format-string
http://ftp.gnome.org/pub/GNOME/sources/vinagre/0.5/vinagre-0.5.2.news
http://www.vuxml.org/freebsd/214e8e07-d369-11dd-b800-001b77d09812.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: vinagre";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"vinagre");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.2")<0) {
    security_note(0, data:"Package vinagre version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
