###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_media_obj_remote_code_exec_vuln_dec09_win.nasl 6219 2009-12-15 10:30:34Z dec $
#
# Adobe Reader/Acrobat Multimeda Doc.media.newPlayer Remote Code Execution Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901096);
  script_version("$Revision: 8142 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4324");
  script_bugtraq_id(37331);
  script_name("Adobe Reader/Acrobat Multimeda Doc.media.newPlayer Remote Code Execution Vulnerability (Win)");
  desc = "
  Overview: This host is installed with Adobe Reader/Acrobat and is prone to
  Doc.media.newPlayer Remote Code Execution vulnerability.

  Vulnerability Insight:
  There exists a flaw in the JavaScript module doc.media object while sending
  a null argument to the newPlayer() method as the exploitation method makes
  use of a vpointer that has not been initialized.

  Impact Level: System

  Affected Software/OS:
  Adobe Acrobat version 9.2.0 and prior.
  Adobe Acrobat version 9.2.0 and prior.

  Workaround:
  Disable JavaScript execution from the Adobe Acrobat/Reader product
  configuration menu settings.

  Fix: Adobe Acrobat/Reader version 9.3.2 or later,
  For updates refer, http://www.adobe.com

  References:
  http://www.f-secure.com/weblog/archives/00001836.html
  http://extraexploit.blogspot.com/search/label/CVE-2009-4324
  http://www.shadowserver.org/wiki/pmwiki.php/Calendar/20091214
  http://blogs.adobe.com/psirt/2009/12/new_adobe_reader_and_acrobat_v.html
  http://downloads.securityfocus.com/vulnerabilities/exploits/adobe_media_newplayer.rb
  http://vrt-sourcefire.blogspot.com/2009/12/adobe-reader-medianewplayer-analysis.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Adobe Reader/Acrobat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_adobe_prdts_detect_win.nasl");
  script_require_keys("Adobe/Acrobat/Win/Ver", "Adobe/Reader/Win/Ver");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

readerVer = get_kb_item("Adobe/Reader/Win/Ver");
if(readerVer != NULL)
{
  # Check for Adobe Reader version 9.x to 9.2.0
  if(version_is_less_equal(version:readerVer, test_version:"9.2.0"))
  {
    security_hole(0);
  }
}

acrobatVer = get_kb_item("Adobe/Acrobat/Win/Ver");
if(acrobatVer != NULL)
{
  # Check for Adobe Acrobat version 9.x to 9.2.0
  if(version_is_less_equal(version:acrobatVer, test_version:"9.2.0")){
    security_hole(0);
  }
}
