###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dm_filemanager_detect.nasl 2869 2009-07-13 17:52:24Z jul $
#
# DM FileManager Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800818);
  script_version("Revision: 1.1");
  script_tag(name:"risk_factor", value:"None");
  script_name("DM FileManager Version Detection");
  desc = "

  Overview: This script detects the installed version of DM FileManager and
  DM Albums and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set Version of DM FileManager in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

dmfPort = get_http_port(default:80);
if(!dmfPort){
  dmfPort = 80;
}

if(!get_port_state(dmfPort)){
  exit(0);
}


foreach dir1 (make_list("/dm-filemanager", "/dmf", "/", cgi_dirs()))
{
  sndReq1 = http_get(item:string(dir1 + "/login.php"), port:dmfPort);
  rcvRes1 = http_send_recv(port:dmfPort, data:sndReq1);

  if(rcvRes1 =~ "<title>Log In - DM FileManager" &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes1))
  {
    dmfVer = eregmatch(pattern:"DM FileManager[^?]+v([0-9]\.[0-9.]+)",
                       string:rcvRes1);
    if(dmfVer[1] != NULL)
    {
      set_kb_item(name:"www/" + dmfPort + "/DM-FileManager",
                  value:dmfVer[1] + " under " + dir1);
      security_note(data:"DM FileManager version " + dmfVer[1] + " running at" + 
                         " location " + dir1 + " was detected on the host");
    }

    foreach dir2 (make_list("/dm-albums", "/albums"))
    {
      sndReq2 = http_get(item:dir1 + dir2 + "/readme.txt", port:dmfPort);
      rcvRes2 = http_send_recv(data:sndReq2, port:dmfPort);

      if("DM Albums" >< rcvRes2 &&
         egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes2))
      {
        dmaVer = eregmatch(pattern:"Stable tag: ([0-9.]+)", string:rcvRes2);
        if(dmaVer[1] != NULL)
        {
          set_kb_item(name:"www/" + dmfPort + "/DM-Albums",
                      value:dmaVer[1] + " under " + dir2);
          security_note(data:"DM Albums version " + dmaVer[1] + " running at" + 
                         " location " + dir2 + " was detected on the host");

        }
      }
    }
  }
}
