###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpmyadmin_pmd_pdf_xss_vuln.nasl 405 2008-10-29 16:16:24Z oct $
#
# phpMyAdmin pmd_pdf.php Cross Site Scripting Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800301);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-4775");
  script_bugtraq_id(31928);
  script_name("phpMyAdmin pmd_pdf.php Cross Site Scripting Vulnerability");
  desc = "

  Overview: This host is running phpMyAdmin and is prone to cross site scripting
  vulnerability.

  Vulnerability Insight:
  Input passed to the 'db' parameter in pmd_pdf.php file is not properly
  sanitised before returning to the user.

  Impact:
  Allows execution of arbitrary HTML and script code, and steal cookie-based
  authentication credentials.

  Impact Level: System

  Affected Software/OS:
  phpMyAdmin phpMyAdmin versions 3.0.1 and prior on all running platform.

  Fix: Upgrade to phpMyAdmin 3.0.1.1 or later

  References:
  http://secunia.com/advisories/32449/
  http://seclists.org/bugtraq/2008/Oct/0199.html

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:H/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of phpMyAdmin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

phpVer = eregmatch(pattern:"[0-9.]+", string:get_kb_item("www/" + port + "/phpMyAdmin"));
if(phpVer){
  # Grep for version 3.0.1 and prior
  if(version_is_less_equal(version:phpVer[0], test_version:"3.0.1")){
    security_warning(port);
  }
}
