##################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  Released under the GNU GPL v2
#  Ref: JeiAr   - GulfTech Security Research Team
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
#
#
#################################################################################

if(description)
{
  script_id(16316);
  script_cve_id("CVE-2004-1825");
  script_bugtraq_id(9890);
  script_version ("$Revision: 7517 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_name("Mambo Site Server index.php mos_change_template XSS");
  desc = "
  An attacker may use the installed version of Mambo Site Server to
  perform a cross site scripting attack on this host.
  Solution: Upgrade at least to version 4.5 1.0.4
  Risk factor : Medium";

  script_description(desc);
  script_summary("Determine if Mambo Site Server is vulnerable to xss attack");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_copyright("This script is Copyright (C) 2005 David Maciejak");
  script_dependencie("mambo_detect.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}


mambVer= get_kb_item(string("www/", port, "/mambo_mos"));
if(!mambVer){
  exit(0);
}

matches = eregmatch(string:mambVer, pattern:"^(.+) under (/.*)$");
if(!matches){
  exit(0);
}

dir = matches[2];
url = string(dir, "/index.php?mos_change_template=<script>foo</script>");
req = http_get(item:url, port:port);
resp = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
if(!resp){
  exit(0);
}

if('<form action="/index.php?mos_change_template=<script>foo</script>' >< resp)
   security_warning(port);
