###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_media_player_classic_midi_iof_vuln.nasl 4800 2009-09-17 13:45:54Z sep $
#
# Gabset Media Player Classic Integer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900948);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3201");
  script_bugtraq_id(36333);
  script_name("Gabset Media Player Classic Integer Overflow Vulnerability");
  desc = "
  Overview: This host is installed with Gabset Media Player Classic and is
  prone to Integer Overflow vulnerability.

  Vulnerability Insight:
  An integer overflow occurs when processing specially crafted MIDI (.mid) files
  containg a malformed header.

  Impact:
  Successful exploitation allows the attacker to execute arbitrary codes and may
  crash the player.

  Impact Level: Application

  Affected Software/OS:
  Gabset Media Player Classic 6.4.9 and prior on Windows.

  Fix: No solution or patch is available as on 17th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/guliverkli/

  References:
  http://en.securitylab.ru/nvd/385461.php

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Gabset Media Player Classic");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_media_player_classic_detect.nasl");
  script_require_keys("MediaPlayerClassic/Ver");
  exit(0);
}


include("version_func.inc");

mpcVer = get_kb_item("MediaPlayerClassic/Ver");
if(!mpcVer) {
  exit(0);
}

if(version_is_less_equal(version:mpcVer, test_version:"6.4.9")){
  security_warning(0);
}
