#ifndef __NAPT_IPACKAGEDETAILS_H_2025_01_01
#define __NAPT_IPACKAGEDETAILS_H_2025_01_01

#include <QString>
#include <list>

using namespace std;

namespace NApt {

/** Access to the package information that should be shown
 *  when requesting to see the package detaills.
 *
 *  Package details should not be shown in tabular ui, because fetching this
 *  information is an expansive operation.
 *  If you need data available here in a tabular ui, please move it to IPackage
 */
class IPackageDetails {
public:
    IPackageDetails() = default;
    virtual ~IPackageDetails() = default;

    virtual QString longDescription() const = 0;

    virtual QString essential() const = 0;
    virtual QString priority() const = 0;
    virtual QString section() const = 0;
    virtual QString installedSize() const = 0;
    virtual QString maintainer() const = 0;

    virtual QString replaces() const = 0;
    virtual QString provides() const = 0;
    virtual QString preDepends() const = 0;
    virtual QString depends() const = 0;
    virtual QString recommends() const = 0;
    virtual QString suggests() const = 0;
    virtual QString conflicts() const = 0;
    virtual QString breaks() const = 0;

    virtual QString size() const = 0;
    virtual QString md5sum() const = 0;
    virtual QString conffiles() const = 0;

    virtual QString filename() const = 0;
    virtual QString source() const = 0;

    virtual QString homepage() const = 0;

    virtual uint getSize() const = 0;
    virtual uint getInstalledSize() const = 0;



    typedef list< pair<uint, uint> > BorderList;
    /** @brief This function returns a list of the packages contained in the string.
        *
        * It is based on some simple parsing rules and might fail if the text is not
        * formatted as expected. See the source for details (the list is assumed to
        * have the form like the dependencies)
        * @returns a list of the packages in the current string. The pairs contain
        * the first char and the one after the last for the package.
        */
    static BorderList getPackageList(const QString& s);
};

}

#endif // __NAPT_IPACKAGEDETAILS_H_2025_01_01
