// -*- c++ -*-
/*=========================================================================

  Program:   Visualization Toolkit
  Module:    pqNetCDFPanel.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/*-------------------------------------------------------------------------
  Copyright 2009 Sandia Corporation.
  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
  the U.S. Government retains certain rights in this software.
-------------------------------------------------------------------------*/

#ifndef __pqNetCDFPanel_h
#define __pqNetCDFPanel_h

#include "pqAutoGeneratedObjectPanel.h"

class QComboBox;
class pqTreeWidget;

/// Custom panel for the default netCDF reader.  This panel adds and modifies
/// the auto generated panel to allow the user to only select variables that
/// have the same dimensions.
class PQCOMPONENTS_EXPORT pqNetCDFPanel : public pqAutoGeneratedObjectPanel
{
  Q_OBJECT;
  typedef pqAutoGeneratedObjectPanel Superclass;

public:
  pqNetCDFPanel(pqProxy *proxy, QWidget *p);
  virtual ~pqNetCDFPanel();

public slots:
  void updateVariableStatusEntries();

protected:
  QComboBox *Dimensions;
  pqTreeWidget *Variables;

private:
  pqNetCDFPanel(const pqNetCDFPanel &); // Not implemented
  void operator=(const pqNetCDFPanel&); // Not implemented

  class DimensionMapType;
  DimensionMapType *DimensionMap;
};

#endif //__pqNetCDFPanel_h
