[![Build & Tests](https://github.com/pencil2d/pencil/actions/workflows/ci.yml/badge.svg)](https://github.com/pencil2d/pencil/actions/workflows/ci.yml)

# Pencil2D Animation

**Pencil2D** is a free and open source animation/drawing software for Windows, macOS, Linux, and FreeBSD. It lets you create traditional hand-drawn animation (cartoon) using both bitmap and vector graphics.

Pencil2D is a community-driven project developed entirely by volunteers and we are always looking for more helping hands! There are many different ways to contribute, so anyone can help regardless of their background. For more information, please see the [Contributing](#contributing) section below.

Don’t forget to check out our official website: <https://www.pencil2d.org/>

### User Showcase

[![2022 User Showcase](http://img.youtube.com/vi/ma52j9B1kEM/hqdefault.jpg)](https://www.youtube.com/watch?v=ma52j9B1kEM)

_User Showcase Reel 2022_

## Download

### Pencil2D 0.6.6 (17 Feb 2021)

Download Pencil2D from the [Official Website][p2d-download] or [Github releases][gh-release].

[p2d-download]: https://www.pencil2d.org/download/
[gh-release]: https://github.com/pencil2d/pencil/releases

### Nightly Builds

Nightly builds are the bleeding edge versions of Pencil2D, which contains the most recent fixes and features. They are not as stable as the official releases, but they are a great way to test the latest features and help us find bugs.

[Download Nightly Buildls](https://www.pencil2d.org/download/nightly/)

## Using Pencil2D

Pencil2D comes with a Quick Reference that you can use to familiarize yourself with the tools and functions at your disposal. You can access it through the main menu: Help > Quick Reference Guide.

We encourage you to visit our [User Manual][user-man] for a quick guide for novice users, then play around with the program – it's fun!

[user-man]: https://www.pencil2d.org/doc/user-manual.html

After you feel a little more comfortable with the basics, check out these [tutorials][pencil-tutorials] provided by Pencil developers and users. While some of these resources might reference previous versions of Pencil2D, the underlying concepts are still the same.

[pencil-tutorials]: https://www.pencil2d.org/doc/tutorials.html

If you encounter difficulty or have additional questions, we have a large community of users who are glad to help out. View the [FAQ][p2d-faq] on our website or visit our [discussion forums][p2d-discussion] to post a new question.

[p2d-faq]: https://www.pencil2d.org/doc/faq.html
[p2d-discussion]: https://discuss.pencil2d.org/c/support/5

## Contributing

Interested in contributing to Pencil2D? There are many ways to help. Take a look at our issues and see what you can help out with, check out the developer guide, or help out with making Pencil2D available to more people by contributing to translation.

* [Issue Tracker](https://github.com/pencil2d/pencil/issues) - Report bugs or request features.
* [Developer Guide](https://dev.pencil2d.org/) - Learn how to compile Pencil2D yourself.
* [Transifex](https://www.transifex.com/pencil2d/) - You can help translate Pencil2D, too.
* [Documentation contributions](https://www.pencil2d.org/doc/CONTRIBUTING) - Contributing to documentation.

## Source Code

* GitHub: <https://github.com/pencil2d/pencil> (Primary)
* Bitbucket: <https://bitbucket.org/chchwy/pencil2d> (Mirror)
* GitLab: <https://gitlab.com/chchwy/pencil2d> (Mirror 2)
