/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSWorkerLocation_h
#define JSWorkerLocation_h

#if ENABLE(WORKERS)

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObjectWithGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class WorkerLocation;

class JSWorkerLocation : public JSDOMWrapper {
    typedef JSDOMWrapper Base;
public:
    JSWorkerLocation(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<WorkerLocation>);
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    WorkerLocation* impl() const { return m_impl.get(); }

private:
    RefPtr<WorkerLocation> m_impl;
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSWorkerLocationOwner : public JSC::WeakHandleOwner {
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, WorkerLocation*)
{
    DEFINE_STATIC_LOCAL(JSWorkerLocationOwner, jsWorkerLocationOwner, ());
    return &jsWorkerLocationOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, WorkerLocation*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, WorkerLocation*);
WorkerLocation* toWorkerLocation(JSC::JSValue);

class JSWorkerLocationPrototype : public JSC::JSObjectWithGlobalObject {
    typedef JSC::JSObjectWithGlobalObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
    JSWorkerLocationPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure) : JSC::JSObjectWithGlobalObject(globalData, globalObject, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWorkerLocationPrototypeFunctionToString(JSC::ExecState*);
// Attributes

JSC::JSValue jsWorkerLocationHref(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationProtocol(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationHost(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationHostname(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationPort(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationPathname(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationSearch(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationHash(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWorkerLocationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(WORKERS)

#endif
