--TEST--
DateTime: negative
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$canonicalBson = hex2bin('10000000096100C33CE7B9BDFFFFFF00');
$canonicalExtJson = '{"a" : {"$date" : {"$numberLong" : "-284643869501"}}}';
$relaxedExtJson = '{"a" : {"$date" : {"$numberLong" : "-284643869501"}}}';

// Canonical BSON -> Native -> Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// Canonical BSON -> Canonical extJSON
echo json_canonicalize(toCanonicalExtendedJSON($canonicalBson)), "\n";

// Canonical BSON -> Relaxed extJSON
echo json_canonicalize(toRelaxedExtendedJSON($canonicalBson)), "\n";

// Canonical extJSON -> Canonical BSON
echo bin2hex(fromJSON($canonicalExtJson)), "\n";

// Relaxed extJSON -> BSON -> Relaxed extJSON
echo json_canonicalize(toRelaxedExtendedJSON(fromJSON($relaxedExtJson))), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
10000000096100c33ce7b9bdffffff00
{"a":{"$date":{"$numberLong":"-284643869501"}}}
{"a":{"$date":{"$numberLong":"-284643869501"}}}
10000000096100c33ce7b9bdffffff00
{"a":{"$date":{"$numberLong":"-284643869501"}}}
===DONE===