/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __VERIFICATION__
#define __VERIFICATION__

#include <src/global/global.h>

typedef struct verification CONTENEUR(Verification);

#include <src/donnees/general/general.h>
#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/flux/processusflux.h>
#include <src/donnees/commandes/actioncommande.h>
#include <src/donnees/commandes/commande.h>
#include <src/problemes/verbeux/verbeux.h>

struct verification
{
	STOCKAGE(ActionFlux) actionverification;
	//Action sur les flux grant la
	//vrification.
	STOCKAGE_SCALAIRE(Texte) message;
	//Message des commandes #warning et
	//#error.
};
/* Structure utilise pour les besoin internes de la
 * vrification des flux. Les champs de cette structure
 * seront utiliss directement.
 * La structure general doit tre connue globalement.
 */

Resultat verification_initialisation(TRAVAIL(Verification) verification);
/* Cre un structure de vrification de flux.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation
 * choue.
 */

Resultat verification_verification(TRAVAIL(General) general);
/* Vrifie les flux, en gnrant un problme
 *  chaque commande mal place.
 * Les commandes #warning et #error sont galement traites.
 * Enfin, une dfragmentation des flux est faite.
 */

Resultat verification_copie(TRAVAIL(Verification) verification , TRAVAIL(Verification) copie);
/* Ralise une copie d'une structure de vrification de flux.
 * Renvoie RESULTAT_ERREUR si verification est NULL.
 * Si *copie est non NULL, la copie est dtruite.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation
 * choue.
 */

Resultat verification_destruction(TRAVAIL(Verification) verification);
/* Dtruit une structure de vrification de flux.
 */

#endif
