/*
 *   Copyright (C) 2008 Schutz Sacha <istdasklar@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.*/
#include "kfortunoid.h"
#include <QPainter>
#include <QFontMetrics>
#include <QSizeF>
#include <QFile> 
#include <plasma/svg.h>
#include <plasma/theme.h>
#include <KProcess>
#include <QDebug> 
#include <QGraphicsLinearLayout>
#include <QMessageBox>
#include <QLabel>
#include <QTimer>
#include <Plasma/Animator>
#include <plasma/widgets/pushbutton.h>
#include <QTextCodec>
#include <KConfigDialog>
#include <KStandardDirs>
#include <KConfigGroup>

 KFortunoid:: KFortunoid(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
{
  
    //setBackgroundHints(NoBackground);
    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    m_delay = 2;
    m_arguments=QString();
    m_showBg=true;
    m_font=QFont();
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    m_color = Qt::white;
    m_labelQuote = new  Plasma::Label;
    m_quote=i18n("no quote");
    m_pathFortune=i18n("fortune not found");
   
    m_timer = new QTimer(this);
    connect(m_timer,SIGNAL(timeout()), this, SLOT(setNewQuote()));
}
 
  KFortunoid::~ KFortunoid()
{
    if (hasFailedToLaunch()) {
        // Do some cleanup here
    } else {
        // Save settings
    }
}
 
void  KFortunoid::init()
{
    QProcess * e = new QProcess;
    e->start("whereis -b fortune");
    e->waitForFinished();
    m_pathFortune=e->readAll();
    m_pathFortune.replace("fortune: ", "");
    m_pathFortune.replace("\n", "");

    if (!QFile::exists(m_pathFortune))
    {
    setFailedToLaunch(true,i18n("Cannot find")+m_pathFortune);
    return;
    }

    QGraphicsLinearLayout*  mainLayout = new QGraphicsLinearLayout(Qt::Horizontal);
    m_labelQuote->nativeWidget()->setAlignment(Qt::AlignCenter);
    mainLayout->addItem(m_labelQuote);
    setLayout(mainLayout);
    resize(400, 200);
    readData();
    refresh();
 

} 
void  KFortunoid::paintInterface(QPainter *p,
        const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
   p->setRenderHint(QPainter::SmoothPixmapTransform);
   p->setRenderHint(QPainter::Antialiasing);
}
 //====================================================================
void KFortunoid::setNewQuote()
{
  //Use Qprocess because Kprocess cannot retrieve me the quote !

    qDebug()<<"color:"<<m_color;

    QProcess * pa = new QProcess;
    pa->start(m_pathFortune+" "+m_arguments);
    pa->waitForFinished();
    m_quote =pa->readAll();
    m_labelQuote->nativeWidget()->setFont(m_font);
    m_labelQuote->setText("<font color=\""+m_color.name()+"\">"+m_quote+"</font>" );

   

}
//======================================================================
  void KFortunoid::constraintsEvent(Plasma::Constraints constraints)
{
  if (constraints & Plasma::FormFactorConstraint) 
  {
  if ( m_showBg==false) setBackgroundHints(NoBackground);
  if ( m_showBg==true)  setBackgroundHints(DefaultBackground);
  }
}
//)====================================================================
void KFortunoid:: createConfigurationInterface(KConfigDialog *parent)
{

    m_settings = new FortunoidSettings;
    parent->addPage(m_settings, i18n("Fortunoid Seetings"), KStandardDirs::locate("icon", "oxygen/scalable/apps/accessories-text-editor.svgz"));
    
    readData();
    m_settings->checkBoxBg->setChecked(m_showBg);
    m_settings->spinBoxDelay->setValue(m_delay);
    m_settings->lineEditArguments->setText(m_arguments);
    m_settings->FontRequester->setFont(m_font);
    m_settings->lineEditPath->setText(m_pathFortune);
    m_settings->kcolorbutton->setColor(m_color);


    connect(parent, SIGNAL(applyClicked()), this, SLOT(configAccepted()));
    connect(parent, SIGNAL(okClicked()), this, SLOT(configAccepted()));

}

//========================================================================
void KFortunoid::configAccepted()
{
    writeData();
    emit configNeedsSaving();
    refresh();
}

//==================================================================================

void KFortunoid::refresh()
{
    if (!m_showBg)
      setBackgroundHints(NoBackground);

    else
      setBackgroundHints(DefaultBackground);

    m_timer->start(m_delay*1000);
    setNewQuote();
    update();
}

//=======================================================================================
void KFortunoid::readData()
{
    KConfigGroup cg = config();

   m_arguments = cg.readEntry("arguments", QString());
   m_delay = cg.readEntry("delay", 2000);
   m_font = cg.readEntry("font", QFont());
   m_showBg= cg.readEntry("showBg", true);
   QColor c(Qt::white);
   m_color.setNamedColor(cg.readEntry("color",c.name()));

}
//==========================================================================================
void KFortunoid::writeData()
{
    m_showBg= m_settings->checkBoxBg->isChecked();
    m_delay = m_settings->spinBoxDelay->value();
    m_arguments = m_settings->lineEditArguments->text();
    m_font = m_settings->FontRequester->font();
    m_color=m_settings->kcolorbutton->color();

  
   KConfigGroup cg = config();
   cg.writeEntry("arguments", m_arguments);
   cg.writeEntry("delay", m_delay);
   cg.writeEntry("font", m_font);
   cg.writeEntry("showBg", m_showBg);
   
   cg.writeEntry("color",m_color.name());





}
#include "kfortunoid.moc"