//----------------------------------------------------------------------------------------
/*!
    \file       hyperlink_dialog.h        
    \modified                            
    \copyright  (c) Robert O'Connor ( rob@medicalmnemonics.com )    
    \licence    GPL
    \brief      Describes hyperlink_dialog class    
    \author     Robert O'Connor
    \date       2002/01/03    
 */  
// RCS-ID:      $Id: hyperlink_dialog.h,v 1.12 2003/03/17 17:43:20 robertoconnor Exp $
//----------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------
// Begin single inclusion of this .h file condition
//----------------------------------------------------------------------------------------

#ifndef _HYPERLINK_DIALOG_H_
#define _HYPERLINK_DIALOG_H_

//----------------------------------------------------------------------------------------
// GCC interface
//----------------------------------------------------------------------------------------

#if defined(__GNUG__) && ! defined(__APPLE__)
    #pragma interface "hyperlink_dialog.h"
#endif

//----------------------------------------------------------------------------------------
// Shared defines
//----------------------------------------------------------------------------------------

#include "plucker_defines.h"

//----------------------------------------------------------------------------------------
// Begin feature removal condition
//----------------------------------------------------------------------------------------

#if ( setupUSE_INTEGRATED_HTML_EDITOR )

//----------------------------------------------------------------------------------------
// Headers
//----------------------------------------------------------------------------------------

#include "wx/dialog.h"

//----------------------------------------------------------------------------------------
// Class definition: hyperlink_dialog
//----------------------------------------------------------------------------------------

//! A dialog for a "a href=" tag for the HTML editor.
class hyperlink_dialog : public wxDialog
{

public:

    //! Constructor.
    /*!
        \param parent The parent window.
     */
    hyperlink_dialog( wxWindow* parent );

    //! Destructor
    ~hyperlink_dialog();

    //! Gets the tag strings generated by the dialog, ready to insert by parent
    /*!
        \param starting_text The text to place at the start of parent's selected text.
        \param ending_text The text to place at the end of parent's selected text.
     */
    void transfer_to( wxString& starting_text, 
                      wxString& ending_text 
                    );
    
private:

    void on_update_ui_url_radiobutton( wxUpdateUIEvent& event );  
    void on_url_button( wxCommandEvent& event );  
    void on_update_ui_file_radiobutton( wxUpdateUIEvent& event ); 
    void on_file_button( wxCommandEvent& event );  
    
    void on_update_ui_maxdepth_checkbox( wxUpdateUIEvent& event );
    void on_update_ui_url_pattern_checkbox( wxUpdateUIEvent& event );
    void on_update_ui_images_depth_checkbox( wxUpdateUIEvent& event );
    void on_update_ui_images_maximum_width_checkbox( wxUpdateUIEvent& event );
    void on_update_ui_images_maximum_height_checkbox( wxUpdateUIEvent& event );
    
    void on_help_button( wxCommandEvent& event );
    //Override base class functions
    void OnOK( wxCommandEvent& event );
    
    wxString m_starting_text;
    wxString m_ending_text;
    
    DECLARE_EVENT_TABLE()    
    
};

//----------------------------------------------------------------------------------------
// End feature removal condition
//----------------------------------------------------------------------------------------

#endif // setupUSE_INTEGRATED_HTML_EDITOR 

//----------------------------------------------------------------------------------------
// End single inclusion of this .h file condition
//----------------------------------------------------------------------------------------

#endif  //_HYPERLINK_DIALOG_H_

