;; unicode-chars.el --- table of Unicode characters
;;
;; Author:    David Aspinall
;; unicode-chars.el,v 12.1 2012/08/16 14:20:10 da Exp
;;
;; Adapted from Norman Walsh's unichars.el (iso8879 names removed)
;;
;; The names are standard, see
;; http://www.unicode.org/unicode/standard/standard.html
;; http://www.unicode.org/Public/UNIDATA

(defvar unicode-chars-alist
  '(;Unicode name  Codept
    ("NULL" . #x000000)
    ("START OF HEADING" . #x000001)
    ("START OF TEXT" . #x000002)
    ("END OF TEXT" . #x000003)
    ("END OF TRANSMISSION" . #x000004)
    ("ENQUIRY" . #x000005)
    ("ACKNOWLEDGE" . #x000006)
    ("BELL" . #x000007)
    ("BACKSPACE" . #x000008)
    ("CHARACTER TABULATION" . #x000009)
    ("LINE FEED (LF)" . #x00000a)
    ("LINE TABULATION" . #x00000b)
    ("FORM FEED (FF)" . #x00000c)
    ("CARRIAGE RETURN (CR)" . #x00000d)
    ("SHIFT OUT" . #x00000e)
    ("SHIFT IN" . #x00000f)
    ("DATA LINK ESCAPE" . #x000010)
    ("DEVICE CONTROL ONE" . #x000011)
    ("DEVICE CONTROL TWO" . #x000012)
    ("DEVICE CONTROL THREE" . #x000013)
    ("DEVICE CONTROL FOUR" . #x000014)
    ("NEGATIVE ACKNOWLEDGE" . #x000015)
    ("SYNCHRONOUS IDLE" . #x000016)
    ("END OF TRANSMISSION BLOCK;" . #x000017)
    ("CANCEL" . #x000018)
    ("END OF MEDIUM" . #x000019)
    ("SUBSTITUTE" . #x00001a)
    ("ESCAPE" . #x00001b)
    ("INFORMATION SEPARATOR FOUR" . #x00001c)
    ("INFORMATION SEPARATOR THREE" . #x00001d)
    ("INFORMATION SEPARATOR TWO" . #x00001e)
    ("INFORMATION SEPARATOR ONE" . #x00001f)
    ("SPACE" . #x000020)
    ("EXCLAMATION MARK" . #x000021)
    ("QUOTATION MARK" . #x000022)
    ("NUMBER SIGN" . #x000023)
    ("DOLLAR SIGN" . #x000024)
    ("PERCENT SIGN" . #x000025)
    ("AMPERSAND" . #x000026)
    ("APOSTROPHE" . #x000027)
    ("LEFT PARENTHESIS" . #x000028)
    ("RIGHT PARENTHESIS" . #x000029)
    ("ASTERISK" . #x00002a)
    ("PLUS SIGN" . #x00002b)
    ("COMMA" . #x00002c)
    ("HYPHEN-MINUS" . #x00002d)
    ("FULL STOP" . #x00002e)
    ("SOLIDUS" . #x00002f)
    ("DIGIT ZERO" . #x000030)
    ("DIGIT ONE" . #x000031)
    ("DIGIT TWO" . #x000032)
    ("DIGIT THREE" . #x000033)
    ("DIGIT FOUR" . #x000034)
    ("DIGIT FIVE" . #x000035)
    ("DIGIT SIX" . #x000036)
    ("DIGIT SEVEN" . #x000037)
    ("DIGIT EIGHT" . #x000038)
    ("DIGIT NINE" . #x000039)
    ("COLON" . #x00003a)
    ("SEMICOLON" . #x00003b)
    ("LESS-THAN SIGN" . #x00003c)
    ("EQUALS SIGN" . #x00003d)
    ("GREATER-THAN SIGN" . #x00003e)
    ("QUESTION MARK" . #x00003f)
    ("COMMERCIAL AT" . #x000040)
    ("LATIN CAPITAL LETTER A" . #x000041)
    ("LATIN CAPITAL LETTER B" . #x000042)
    ("LATIN CAPITAL LETTER C" . #x000043)
    ("LATIN CAPITAL LETTER D" . #x000044)
    ("LATIN CAPITAL LETTER E" . #x000045)
    ("LATIN CAPITAL LETTER F" . #x000046)
    ("LATIN CAPITAL LETTER G" . #x000047)
    ("LATIN CAPITAL LETTER H" . #x000048)
    ("LATIN CAPITAL LETTER I" . #x000049)
    ("LATIN CAPITAL LETTER J" . #x00004a)
    ("LATIN CAPITAL LETTER K" . #x00004b)
    ("LATIN CAPITAL LETTER L" . #x00004c)
    ("LATIN CAPITAL LETTER M" . #x00004d)
    ("LATIN CAPITAL LETTER N" . #x00004e)
    ("LATIN CAPITAL LETTER O" . #x00004f)
    ("LATIN CAPITAL LETTER P" . #x000050)
    ("LATIN CAPITAL LETTER Q" . #x000051)
    ("LATIN CAPITAL LETTER R" . #x000052)
    ("LATIN CAPITAL LETTER S" . #x000053)
    ("LATIN CAPITAL LETTER T" . #x000054)
    ("LATIN CAPITAL LETTER U" . #x000055)
    ("LATIN CAPITAL LETTER V" . #x000056)
    ("LATIN CAPITAL LETTER W" . #x000057)
    ("LATIN CAPITAL LETTER X" . #x000058)
    ("LATIN CAPITAL LETTER Y" . #x000059)
    ("LATIN CAPITAL LETTER Z" . #x00005a)
    ("LEFT SQUARE BRACKET" . #x00005b)
    ("REVERSE SOLIDUS" . #x00005c)
    ("RIGHT SQUARE BRACKET" . #x00005d)
    ("CIRCUMFLEX ACCENT" . #x00005e)
    ("LOW LINE" . #x00005f)
    ("GRAVE ACCENT" . #x000060)
    ("LATIN SMALL LETTER A" . #x000061)
    ("LATIN SMALL LETTER B" . #x000062)
    ("LATIN SMALL LETTER C" . #x000063)
    ("LATIN SMALL LETTER D" . #x000064)
    ("LATIN SMALL LETTER E" . #x000065)
    ("LATIN SMALL LETTER F" . #x000066)
    ("LATIN SMALL LETTER G" . #x000067)
    ("LATIN SMALL LETTER H" . #x000068)
    ("LATIN SMALL LETTER I" . #x000069)
    ("LATIN SMALL LETTER J" . #x00006a)
    ("LATIN SMALL LETTER K" . #x00006b)
    ("LATIN SMALL LETTER L" . #x00006c)
    ("LATIN SMALL LETTER M" . #x00006d)
    ("LATIN SMALL LETTER N" . #x00006e)
    ("LATIN SMALL LETTER O" . #x00006f)
    ("LATIN SMALL LETTER P" . #x000070)
    ("LATIN SMALL LETTER Q" . #x000071)
    ("LATIN SMALL LETTER R" . #x000072)
    ("LATIN SMALL LETTER S" . #x000073)
    ("LATIN SMALL LETTER T" . #x000074)
    ("LATIN SMALL LETTER U" . #x000075)
    ("LATIN SMALL LETTER V" . #x000076)
    ("LATIN SMALL LETTER W" . #x000077)
    ("LATIN SMALL LETTER X" . #x000078)
    ("LATIN SMALL LETTER Y" . #x000079)
    ("LATIN SMALL LETTER Z" . #x00007a)
    ("LEFT CURLY BRACKET" . #x00007b)
    ("VERTICAL LINE" . #x00007c)
    ("RIGHT CURLY BRACKET" . #x00007d)
    ("TILDE" . #x00007e)
    ("DELETE" . #x00007f)
    ("BREAK PERMITTED HERE" . #x000082)
    ("NO BREAK HERE" . #x000083)
    ("NEXT LINE (NEL)" . #x000085)
    ("START OF SELECTED AREA" . #x000086)
    ("END OF SELECTED AREA" . #x000087)
    ("CHARACTER TABULATION SET" . #x000088)
    ("CHARACTER TABULATION WITH JUSTIFICATION" . #x000089)
    ("LINE TABULATION SET" . #x00008a)
    ("PARTIAL LINE FORWARD" . #x00008b)
    ("PARTIAL LINE BACKWARD" . #x00008c)
    ("REVERSE LINE FEED" . #x00008d)
    ("SINGLE SHIFT TWO" . #x00008e)
    ("SINGLE SHIFT THREE" . #x00008f)
    ("DEVICE CONTROL STRING" . #x000090)
    ("PRIVATE USE ONE" . #x000091)
    ("PRIVATE USE TWO" . #x000092)
    ("SET TRANSMIT STATE" . #x000093)
    ("CANCEL CHARACTER" . #x000094)
    ("MESSAGE WAITING" . #x000095)
    ("START OF GUARDED AREA" . #x000096)
    ("END OF GUARDED AREA" . #x000097)
    ("START OF STRING" . #x000098)
    ("SINGLE CHARACTER INTRODUCER" . #x00009a)
    ("CONTROL SEQUENCE INTRODUCER" . #x00009b)
    ("STRING TERMINATOR" . #x00009c)
    ("OPERATING SYSTEM COMMAND" . #x00009d)
    ("PRIVACY MESSAGE" . #x00009e)
    ("APPLICATION PROGRAM COMMAND" . #x00009f)
    ("NO-BREAK SPACE" . #x0000a0)
    ("INVERTED EXCLAMATION MARK" . #x0000a1)
    ("CENT SIGN" . #x0000a2)
    ("POUND SIGN" . #x0000a3)
    ("CURRENCY SIGN" . #x0000a4)
    ("YEN SIGN" . #x0000a5)
    ("BROKEN BAR" . #x0000a6)
    ("SECTION SIGN" . #x0000a7)
    ("DIAERESIS" . #x0000a8)
    ("COPYRIGHT SIGN" . #x0000a9)
    ("FEMININE ORDINAL INDICATOR" . #x0000aa)
    ("LEFT-POINTING DOUBLE ANGLE QUOTATION MARK" . #x0000ab)
    ("NOT SIGN" . #x0000ac)
    ("SOFT HYPHEN" . #x0000ad)
    ("REGISTERED SIGN" . #x0000ae)
    ("MACRON" . #x0000af)
    ("DEGREE SIGN" . #x0000b0)
    ("PLUS-MINUS SIGN" . #x0000b1)
    ("SUPERSCRIPT TWO" . #x0000b2)
    ("SUPERSCRIPT THREE" . #x0000b3)
    ("ACUTE ACCENT" . #x0000b4)
    ("MICRO SIGN" . #x0000b5)
    ("PILCROW SIGN" . #x0000b6)
    ("MIDDLE DOT" . #x0000b7)
    ("CEDILLA" . #x0000b8)
    ("SUPERSCRIPT ONE" . #x0000b9)
    ("MASCULINE ORDINAL INDICATOR" . #x0000ba)
    ("RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK" . #x0000bb)
    ("VULGAR FRACTION ONE QUARTER" . #x0000bc)
    ("VULGAR FRACTION ONE HALF" . #x0000bd)
    ("VULGAR FRACTION THREE QUARTERS" . #x0000be)
    ("INVERTED QUESTION MARK" . #x0000bf)
    ("LATIN CAPITAL LETTER A WITH GRAVE" . #x0000c0)
    ("LATIN CAPITAL LETTER A WITH ACUTE" . #x0000c1)
    ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX" . #x0000c2)
    ("LATIN CAPITAL LETTER A WITH TILDE" . #x0000c3)
    ("LATIN CAPITAL LETTER A WITH DIAERESIS" . #x0000c4)
    ("LATIN CAPITAL LETTER A WITH RING ABOVE" . #x0000c5)
    ("LATIN CAPITAL LETTER AE" . #x0000c6)
    ("LATIN CAPITAL LETTER C WITH CEDILLA" . #x0000c7)
    ("LATIN CAPITAL LETTER E WITH GRAVE" . #x0000c8)
    ("LATIN CAPITAL LETTER E WITH ACUTE" . #x0000c9)
    ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX" . #x0000ca)
    ("LATIN CAPITAL LETTER E WITH DIAERESIS" . #x0000cb)
    ("LATIN CAPITAL LETTER I WITH GRAVE" . #x0000cc)
    ("LATIN CAPITAL LETTER I WITH ACUTE" . #x0000cd)
    ("LATIN CAPITAL LETTER I WITH CIRCUMFLEX" . #x0000ce)
    ("LATIN CAPITAL LETTER I WITH DIAERESIS" . #x0000cf)
    ("LATIN CAPITAL LETTER ETH" . #x0000d0)
    ("LATIN CAPITAL LETTER N WITH TILDE" . #x0000d1)
    ("LATIN CAPITAL LETTER O WITH GRAVE" . #x0000d2)
    ("LATIN CAPITAL LETTER O WITH ACUTE" . #x0000d3)
    ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX" . #x0000d4)
    ("LATIN CAPITAL LETTER O WITH TILDE" . #x0000d5)
    ("LATIN CAPITAL LETTER O WITH DIAERESIS" . #x0000d6)
    ("MULTIPLICATION SIGN" . #x0000d7)
    ("LATIN CAPITAL LETTER O WITH STROKE" . #x0000d8)
    ("LATIN CAPITAL LETTER U WITH GRAVE" . #x0000d9)
    ("LATIN CAPITAL LETTER U WITH ACUTE" . #x0000da)
    ("LATIN CAPITAL LETTER U WITH CIRCUMFLEX" . #x0000db)
    ("LATIN CAPITAL LETTER U WITH DIAERESIS" . #x0000dc)
    ("LATIN CAPITAL LETTER Y WITH ACUTE" . #x0000dd)
    ("LATIN CAPITAL LETTER THORN" . #x0000de)
    ("LATIN SMALL LETTER SHARP S" . #x0000df)
    ("LATIN SMALL LETTER A WITH GRAVE" . #x0000e0)
    ("LATIN SMALL LETTER A WITH ACUTE" . #x0000e1)
    ("LATIN SMALL LETTER A WITH CIRCUMFLEX" . #x0000e2)
    ("LATIN SMALL LETTER A WITH TILDE" . #x0000e3)
    ("LATIN SMALL LETTER A WITH DIAERESIS" . #x0000e4)
    ("LATIN SMALL LETTER A WITH RING ABOVE" . #x0000e5)
    ("LATIN SMALL LETTER AE" . #x0000e6)
    ("LATIN SMALL LETTER C WITH CEDILLA" . #x0000e7)
    ("LATIN SMALL LETTER E WITH GRAVE" . #x0000e8)
    ("LATIN SMALL LETTER E WITH ACUTE" . #x0000e9)
    ("LATIN SMALL LETTER E WITH CIRCUMFLEX" . #x0000ea)
    ("LATIN SMALL LETTER E WITH DIAERESIS" . #x0000eb)
    ("LATIN SMALL LETTER I WITH GRAVE" . #x0000ec)
    ("LATIN SMALL LETTER I WITH ACUTE" . #x0000ed)
    ("LATIN SMALL LETTER I WITH CIRCUMFLEX" . #x0000ee)
    ("LATIN SMALL LETTER I WITH DIAERESIS" . #x0000ef)
    ("LATIN SMALL LETTER ETH" . #x0000f0)
    ("LATIN SMALL LETTER N WITH TILDE" . #x0000f1)
    ("LATIN SMALL LETTER O WITH GRAVE" . #x0000f2)
    ("LATIN SMALL LETTER O WITH ACUTE" . #x0000f3)
    ("LATIN SMALL LETTER O WITH CIRCUMFLEX" . #x0000f4)
    ("LATIN SMALL LETTER O WITH TILDE" . #x0000f5)
    ("LATIN SMALL LETTER O WITH DIAERESIS" . #x0000f6)
    ("DIVISION SIGN" . #x0000f7)
    ("LATIN SMALL LETTER O WITH STROKE" . #x0000f8)
    ("LATIN SMALL LETTER U WITH GRAVE" . #x0000f9)
    ("LATIN SMALL LETTER U WITH ACUTE" . #x0000fa)
    ("LATIN SMALL LETTER U WITH CIRCUMFLEX" . #x0000fb)
    ("LATIN SMALL LETTER U WITH DIAERESIS" . #x0000fc)
    ("LATIN SMALL LETTER Y WITH ACUTE" . #x0000fd)
    ("LATIN SMALL LETTER THORN" . #x0000fe)
    ("LATIN SMALL LETTER Y WITH DIAERESIS" . #x0000ff)
    ("LATIN CAPITAL LETTER A WITH MACRON" . #x000100)
    ("LATIN SMALL LETTER A WITH MACRON" . #x000101)
    ("LATIN CAPITAL LETTER A WITH BREVE" . #x000102)
    ("LATIN SMALL LETTER A WITH BREVE" . #x000103)
    ("LATIN CAPITAL LETTER A WITH OGONEK" . #x000104)
    ("LATIN SMALL LETTER A WITH OGONEK" . #x000105)
    ("LATIN CAPITAL LETTER C WITH ACUTE" . #x000106)
    ("LATIN SMALL LETTER C WITH ACUTE" . #x000107)
    ("LATIN CAPITAL LETTER C WITH CIRCUMFLEX" . #x000108)
    ("LATIN SMALL LETTER C WITH CIRCUMFLEX" . #x000109)
    ("LATIN CAPITAL LETTER C WITH DOT ABOVE" . #x00010a)
    ("LATIN SMALL LETTER C WITH DOT ABOVE" . #x00010b)
    ("LATIN CAPITAL LETTER C WITH CARON" . #x00010c)
    ("LATIN SMALL LETTER C WITH CARON" . #x00010d)
    ("LATIN CAPITAL LETTER D WITH CARON" . #x00010e)
    ("LATIN SMALL LETTER D WITH CARON" . #x00010f)
    ("LATIN CAPITAL LETTER D WITH STROKE" . #x000110)
    ("LATIN SMALL LETTER D WITH STROKE" . #x000111)
    ("LATIN CAPITAL LETTER E WITH MACRON" . #x000112)
    ("LATIN SMALL LETTER E WITH MACRON" . #x000113)
    ("LATIN CAPITAL LETTER E WITH BREVE" . #x000114)
    ("LATIN SMALL LETTER E WITH BREVE" . #x000115)
    ("LATIN CAPITAL LETTER E WITH DOT ABOVE" . #x000116)
    ("LATIN SMALL LETTER E WITH DOT ABOVE" . #x000117)
    ("LATIN CAPITAL LETTER E WITH OGONEK" . #x000118)
    ("LATIN SMALL LETTER E WITH OGONEK" . #x000119)
    ("LATIN CAPITAL LETTER E WITH CARON" . #x00011a)
    ("LATIN SMALL LETTER E WITH CARON" . #x00011b)
    ("LATIN CAPITAL LETTER G WITH CIRCUMFLEX" . #x00011c)
    ("LATIN SMALL LETTER G WITH CIRCUMFLEX" . #x00011d)
    ("LATIN CAPITAL LETTER G WITH BREVE" . #x00011e)
    ("LATIN SMALL LETTER G WITH BREVE" . #x00011f)
    ("LATIN CAPITAL LETTER G WITH DOT ABOVE" . #x000120)
    ("LATIN SMALL LETTER G WITH DOT ABOVE" . #x000121)
    ("LATIN CAPITAL LETTER G WITH CEDILLA" . #x000122)
    ("LATIN SMALL LETTER G WITH CEDILLA" . #x000123)
    ("LATIN CAPITAL LETTER H WITH CIRCUMFLEX" . #x000124)
    ("LATIN SMALL LETTER H WITH CIRCUMFLEX" . #x000125)
    ("LATIN CAPITAL LETTER H WITH STROKE" . #x000126)
    ("LATIN SMALL LETTER H WITH STROKE" . #x000127)
    ("LATIN CAPITAL LETTER I WITH TILDE" . #x000128)
    ("LATIN SMALL LETTER I WITH TILDE" . #x000129)
    ("LATIN CAPITAL LETTER I WITH MACRON" . #x00012a)
    ("LATIN SMALL LETTER I WITH MACRON" . #x00012b)
    ("LATIN CAPITAL LETTER I WITH BREVE" . #x00012c)
    ("LATIN SMALL LETTER I WITH BREVE" . #x00012d)
    ("LATIN CAPITAL LETTER I WITH OGONEK" . #x00012e)
    ("LATIN SMALL LETTER I WITH OGONEK" . #x00012f)
    ("LATIN CAPITAL LETTER I WITH DOT ABOVE" . #x000130)
    ("LATIN SMALL LETTER DOTLESS I" . #x000131)
    ("LATIN CAPITAL LIGATURE IJ" . #x000132)
    ("LATIN SMALL LIGATURE IJ" . #x000133)
    ("LATIN CAPITAL LETTER J WITH CIRCUMFLEX" . #x000134)
    ("LATIN SMALL LETTER J WITH CIRCUMFLEX" . #x000135)
    ("LATIN CAPITAL LETTER K WITH CEDILLA" . #x000136)
    ("LATIN SMALL LETTER K WITH CEDILLA" . #x000137)
    ("LATIN SMALL LETTER KRA" . #x000138)
    ("LATIN CAPITAL LETTER L WITH ACUTE" . #x000139)
    ("LATIN SMALL LETTER L WITH ACUTE" . #x00013a)
    ("LATIN CAPITAL LETTER L WITH CEDILLA" . #x00013b)
    ("LATIN SMALL LETTER L WITH CEDILLA" . #x00013c)
    ("LATIN CAPITAL LETTER L WITH CARON" . #x00013d)
    ("LATIN SMALL LETTER L WITH CARON" . #x00013e)
    ("LATIN CAPITAL LETTER L WITH MIDDLE DOT" . #x00013f)
    ("LATIN SMALL LETTER L WITH MIDDLE DOT" . #x000140)
    ("LATIN CAPITAL LETTER L WITH STROKE" . #x000141)
    ("LATIN SMALL LETTER L WITH STROKE" . #x000142)
    ("LATIN CAPITAL LETTER N WITH ACUTE" . #x000143)
    ("LATIN SMALL LETTER N WITH ACUTE" . #x000144)
    ("LATIN CAPITAL LETTER N WITH CEDILLA" . #x000145)
    ("LATIN SMALL LETTER N WITH CEDILLA" . #x000146)
    ("LATIN CAPITAL LETTER N WITH CARON" . #x000147)
    ("LATIN SMALL LETTER N WITH CARON" . #x000148)
    ("LATIN SMALL LETTER N PRECEDED BY APOSTROPHE" . #x000149)
    ("LATIN CAPITAL LETTER ENG" . #x00014a)
    ("LATIN SMALL LETTER ENG" . #x00014b)
    ("LATIN CAPITAL LETTER O WITH MACRON" . #x00014c)
    ("LATIN SMALL LETTER O WITH MACRON" . #x00014d)
    ("LATIN CAPITAL LETTER O WITH BREVE" . #x00014e)
    ("LATIN SMALL LETTER O WITH BREVE" . #x00014f)
    ("LATIN CAPITAL LETTER O WITH DOUBLE ACUTE" . #x000150)
    ("LATIN SMALL LETTER O WITH DOUBLE ACUTE" . #x000151)
    ("LATIN CAPITAL LIGATURE OE" . #x000152)
    ("LATIN SMALL LIGATURE OE" . #x000153)
    ("LATIN CAPITAL LETTER R WITH ACUTE" . #x000154)
    ("LATIN SMALL LETTER R WITH ACUTE" . #x000155)
    ("LATIN CAPITAL LETTER R WITH CEDILLA" . #x000156)
    ("LATIN SMALL LETTER R WITH CEDILLA" . #x000157)
    ("LATIN CAPITAL LETTER R WITH CARON" . #x000158)
    ("LATIN SMALL LETTER R WITH CARON" . #x000159)
    ("LATIN CAPITAL LETTER S WITH ACUTE" . #x00015a)
    ("LATIN SMALL LETTER S WITH ACUTE" . #x00015b)
    ("LATIN CAPITAL LETTER S WITH CIRCUMFLEX" . #x00015c)
    ("LATIN SMALL LETTER S WITH CIRCUMFLEX" . #x00015d)
    ("LATIN CAPITAL LETTER S WITH CEDILLA" . #x00015e)
    ("LATIN SMALL LETTER S WITH CEDILLA" . #x00015f)
    ("LATIN CAPITAL LETTER S WITH CARON" . #x000160)
    ("LATIN SMALL LETTER S WITH CARON" . #x000161)
    ("LATIN CAPITAL LETTER T WITH CEDILLA" . #x000162)
    ("LATIN SMALL LETTER T WITH CEDILLA" . #x000163)
    ("LATIN CAPITAL LETTER T WITH CARON" . #x000164)
    ("LATIN SMALL LETTER T WITH CARON" . #x000165)
    ("LATIN CAPITAL LETTER T WITH STROKE" . #x000166)
    ("LATIN SMALL LETTER T WITH STROKE" . #x000167)
    ("LATIN CAPITAL LETTER U WITH TILDE" . #x000168)
    ("LATIN SMALL LETTER U WITH TILDE" . #x000169)
    ("LATIN CAPITAL LETTER U WITH MACRON" . #x00016a)
    ("LATIN SMALL LETTER U WITH MACRON" . #x00016b)
    ("LATIN CAPITAL LETTER U WITH BREVE" . #x00016c)
    ("LATIN SMALL LETTER U WITH BREVE" . #x00016d)
    ("LATIN CAPITAL LETTER U WITH RING ABOVE" . #x00016e)
    ("LATIN SMALL LETTER U WITH RING ABOVE" . #x00016f)
    ("LATIN CAPITAL LETTER U WITH DOUBLE ACUTE" . #x000170)
    ("LATIN SMALL LETTER U WITH DOUBLE ACUTE" . #x000171)
    ("LATIN CAPITAL LETTER U WITH OGONEK" . #x000172)
    ("LATIN SMALL LETTER U WITH OGONEK" . #x000173)
    ("LATIN CAPITAL LETTER W WITH CIRCUMFLEX" . #x000174)
    ("LATIN SMALL LETTER W WITH CIRCUMFLEX" . #x000175)
    ("LATIN CAPITAL LETTER Y WITH CIRCUMFLEX" . #x000176)
    ("LATIN SMALL LETTER Y WITH CIRCUMFLEX" . #x000177)
    ("LATIN CAPITAL LETTER Y WITH DIAERESIS" . #x000178)
    ("LATIN CAPITAL LETTER Z WITH ACUTE" . #x000179)
    ("LATIN SMALL LETTER Z WITH ACUTE" . #x00017a)
    ("LATIN CAPITAL LETTER Z WITH DOT ABOVE" . #x00017b)
    ("LATIN SMALL LETTER Z WITH DOT ABOVE" . #x00017c)
    ("LATIN CAPITAL LETTER Z WITH CARON" . #x00017d)
    ("LATIN SMALL LETTER Z WITH CARON" . #x00017e)
    ("LATIN SMALL LETTER LONG S" . #x00017f)
    ("LATIN SMALL LETTER B WITH STROKE" . #x000180)
    ("LATIN CAPITAL LETTER B WITH HOOK" . #x000181)
    ("LATIN CAPITAL LETTER B WITH TOPBAR" . #x000182)
    ("LATIN SMALL LETTER B WITH TOPBAR" . #x000183)
    ("LATIN CAPITAL LETTER TONE SIX" . #x000184)
    ("LATIN SMALL LETTER TONE SIX" . #x000185)
    ("LATIN CAPITAL LETTER OPEN O" . #x000186)
    ("LATIN CAPITAL LETTER C WITH HOOK" . #x000187)
    ("LATIN SMALL LETTER C WITH HOOK" . #x000188)
    ("LATIN CAPITAL LETTER AFRICAN D" . #x000189)
    ("LATIN CAPITAL LETTER D WITH HOOK" . #x00018a)
    ("LATIN CAPITAL LETTER D WITH TOPBAR" . #x00018b)
    ("LATIN SMALL LETTER D WITH TOPBAR" . #x00018c)
    ("LATIN SMALL LETTER TURNED DELTA" . #x00018d)
    ("LATIN CAPITAL LETTER REVERSED E" . #x00018e)
    ("LATIN CAPITAL LETTER SCHWA" . #x00018f)
    ("LATIN CAPITAL LETTER OPEN E" . #x000190)
    ("LATIN CAPITAL LETTER F WITH HOOK" . #x000191)
    ("LATIN SMALL LETTER F WITH HOOK" . #x000192)
    ("LATIN CAPITAL LETTER G WITH HOOK" . #x000193)
    ("LATIN CAPITAL LETTER GAMMA" . #x000194)
    ("LATIN SMALL LETTER HV" . #x000195)
    ("LATIN CAPITAL LETTER IOTA" . #x000196)
    ("LATIN CAPITAL LETTER I WITH STROKE" . #x000197)
    ("LATIN CAPITAL LETTER K WITH HOOK" . #x000198)
    ("LATIN SMALL LETTER K WITH HOOK" . #x000199)
    ("LATIN SMALL LETTER L WITH BAR" . #x00019a)
    ("LATIN SMALL LETTER LAMBDA WITH STROKE" . #x00019b)
    ("LATIN CAPITAL LETTER TURNED M" . #x00019c)
    ("LATIN CAPITAL LETTER N WITH LEFT HOOK" . #x00019d)
    ("LATIN SMALL LETTER N WITH LONG RIGHT LEG" . #x00019e)
    ("LATIN CAPITAL LETTER O WITH MIDDLE TILDE" . #x00019f)
    ("LATIN CAPITAL LETTER O WITH HORN" . #x0001a0)
    ("LATIN SMALL LETTER O WITH HORN" . #x0001a1)
    ("LATIN CAPITAL LETTER OI" . #x0001a2)
    ("LATIN SMALL LETTER OI" . #x0001a3)
    ("LATIN CAPITAL LETTER P WITH HOOK" . #x0001a4)
    ("LATIN SMALL LETTER P WITH HOOK" . #x0001a5)
    ("LATIN LETTER YR" . #x0001a6)
    ("LATIN CAPITAL LETTER TONE TWO" . #x0001a7)
    ("LATIN SMALL LETTER TONE TWO" . #x0001a8)
    ("LATIN CAPITAL LETTER ESH" . #x0001a9)
    ("LATIN LETTER REVERSED ESH LOOP" . #x0001aa)
    ("LATIN SMALL LETTER T WITH PALATAL HOOK" . #x0001ab)
    ("LATIN CAPITAL LETTER T WITH HOOK" . #x0001ac)
    ("LATIN SMALL LETTER T WITH HOOK" . #x0001ad)
    ("LATIN CAPITAL LETTER T WITH RETROFLEX HOOK" . #x0001ae)
    ("LATIN CAPITAL LETTER U WITH HORN" . #x0001af)
    ("LATIN SMALL LETTER U WITH HORN" . #x0001b0)
    ("LATIN CAPITAL LETTER UPSILON" . #x0001b1)
    ("LATIN CAPITAL LETTER V WITH HOOK" . #x0001b2)
    ("LATIN CAPITAL LETTER Y WITH HOOK" . #x0001b3)
    ("LATIN SMALL LETTER Y WITH HOOK" . #x0001b4)
    ("LATIN CAPITAL LETTER Z WITH STROKE" . #x0001b5)
    ("LATIN SMALL LETTER Z WITH STROKE" . #x0001b6)
    ("LATIN CAPITAL LETTER EZH" . #x0001b7)
    ("LATIN CAPITAL LETTER EZH REVERSED" . #x0001b8)
    ("LATIN SMALL LETTER EZH REVERSED" . #x0001b9)
    ("LATIN SMALL LETTER EZH WITH TAIL" . #x0001ba)
    ("LATIN LETTER TWO WITH STROKE" . #x0001bb)
    ("LATIN CAPITAL LETTER TONE FIVE" . #x0001bc)
    ("LATIN SMALL LETTER TONE FIVE" . #x0001bd)
    ("LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE" . #x0001be)
    ("LATIN LETTER WYNN" . #x0001bf)
    ("LATIN LETTER DENTAL CLICK" . #x0001c0)
    ("LATIN LETTER LATERAL CLICK" . #x0001c1)
    ("LATIN LETTER ALVEOLAR CLICK" . #x0001c2)
    ("LATIN LETTER RETROFLEX CLICK" . #x0001c3)
    ("LATIN CAPITAL LETTER DZ WITH CARON" . #x0001c4)
    ("LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON" . #x0001c5)
    ("LATIN SMALL LETTER DZ WITH CARON" . #x0001c6)
    ("LATIN CAPITAL LETTER LJ" . #x0001c7)
    ("LATIN CAPITAL LETTER L WITH SMALL LETTER J" . #x0001c8)
    ("LATIN SMALL LETTER LJ" . #x0001c9)
    ("LATIN CAPITAL LETTER NJ" . #x0001ca)
    ("LATIN CAPITAL LETTER N WITH SMALL LETTER J" . #x0001cb)
    ("LATIN SMALL LETTER NJ" . #x0001cc)
    ("LATIN CAPITAL LETTER A WITH CARON" . #x0001cd)
    ("LATIN SMALL LETTER A WITH CARON" . #x0001ce)
    ("LATIN CAPITAL LETTER I WITH CARON" . #x0001cf)
    ("LATIN SMALL LETTER I WITH CARON" . #x0001d0)
    ("LATIN CAPITAL LETTER O WITH CARON" . #x0001d1)
    ("LATIN SMALL LETTER O WITH CARON" . #x0001d2)
    ("LATIN CAPITAL LETTER U WITH CARON" . #x0001d3)
    ("LATIN SMALL LETTER U WITH CARON" . #x0001d4)
    ("LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON" . #x0001d5)
    ("LATIN SMALL LETTER U WITH DIAERESIS AND MACRON" . #x0001d6)
    ("LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE" . #x0001d7)
    ("LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE" . #x0001d8)
    ("LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON" . #x0001d9)
    ("LATIN SMALL LETTER U WITH DIAERESIS AND CARON" . #x0001da)
    ("LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE" . #x0001db)
    ("LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE" . #x0001dc)
    ("LATIN SMALL LETTER TURNED E" . #x0001dd)
    ("LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON" . #x0001de)
    ("LATIN SMALL LETTER A WITH DIAERESIS AND MACRON" . #x0001df)
    ("LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON" . #x0001e0)
    ("LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON" . #x0001e1)
    ("LATIN CAPITAL LETTER AE WITH MACRON" . #x0001e2)
    ("LATIN SMALL LETTER AE WITH MACRON" . #x0001e3)
    ("LATIN CAPITAL LETTER G WITH STROKE" . #x0001e4)
    ("LATIN SMALL LETTER G WITH STROKE" . #x0001e5)
    ("LATIN CAPITAL LETTER G WITH CARON" . #x0001e6)
    ("LATIN SMALL LETTER G WITH CARON" . #x0001e7)
    ("LATIN CAPITAL LETTER K WITH CARON" . #x0001e8)
    ("LATIN SMALL LETTER K WITH CARON" . #x0001e9)
    ("LATIN CAPITAL LETTER O WITH OGONEK" . #x0001ea)
    ("LATIN SMALL LETTER O WITH OGONEK" . #x0001eb)
    ("LATIN CAPITAL LETTER O WITH OGONEK AND MACRON" . #x0001ec)
    ("LATIN SMALL LETTER O WITH OGONEK AND MACRON" . #x0001ed)
    ("LATIN CAPITAL LETTER EZH WITH CARON" . #x0001ee)
    ("LATIN SMALL LETTER EZH WITH CARON" . #x0001ef)
    ("LATIN SMALL LETTER J WITH CARON" . #x0001f0)
    ("LATIN CAPITAL LETTER DZ" . #x0001f1)
    ("LATIN CAPITAL LETTER D WITH SMALL LETTER Z" . #x0001f2)
    ("LATIN SMALL LETTER DZ" . #x0001f3)
    ("LATIN CAPITAL LETTER G WITH ACUTE" . #x0001f4)
    ("LATIN SMALL LETTER G WITH ACUTE" . #x0001f5)
    ("LATIN CAPITAL LETTER HWAIR" . #x0001f6)
    ("LATIN CAPITAL LETTER WYNN" . #x0001f7)
    ("LATIN CAPITAL LETTER N WITH GRAVE" . #x0001f8)
    ("LATIN SMALL LETTER N WITH GRAVE" . #x0001f9)
    ("LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE" . #x0001fa)
    ("LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE" . #x0001fb)
    ("LATIN CAPITAL LETTER AE WITH ACUTE" . #x0001fc)
    ("LATIN SMALL LETTER AE WITH ACUTE" . #x0001fd)
    ("LATIN CAPITAL LETTER O WITH STROKE AND ACUTE" . #x0001fe)
    ("LATIN SMALL LETTER O WITH STROKE AND ACUTE" . #x0001ff)
    ("LATIN CAPITAL LETTER A WITH DOUBLE GRAVE" . #x000200)
    ("LATIN SMALL LETTER A WITH DOUBLE GRAVE" . #x000201)
    ("LATIN CAPITAL LETTER A WITH INVERTED BREVE" . #x000202)
    ("LATIN SMALL LETTER A WITH INVERTED BREVE" . #x000203)
    ("LATIN CAPITAL LETTER E WITH DOUBLE GRAVE" . #x000204)
    ("LATIN SMALL LETTER E WITH DOUBLE GRAVE" . #x000205)
    ("LATIN CAPITAL LETTER E WITH INVERTED BREVE" . #x000206)
    ("LATIN SMALL LETTER E WITH INVERTED BREVE" . #x000207)
    ("LATIN CAPITAL LETTER I WITH DOUBLE GRAVE" . #x000208)
    ("LATIN SMALL LETTER I WITH DOUBLE GRAVE" . #x000209)
    ("LATIN CAPITAL LETTER I WITH INVERTED BREVE" . #x00020a)
    ("LATIN SMALL LETTER I WITH INVERTED BREVE" . #x00020b)
    ("LATIN CAPITAL LETTER O WITH DOUBLE GRAVE" . #x00020c)
    ("LATIN SMALL LETTER O WITH DOUBLE GRAVE" . #x00020d)
    ("LATIN CAPITAL LETTER O WITH INVERTED BREVE" . #x00020e)
    ("LATIN SMALL LETTER O WITH INVERTED BREVE" . #x00020f)
    ("LATIN CAPITAL LETTER R WITH DOUBLE GRAVE" . #x000210)
    ("LATIN SMALL LETTER R WITH DOUBLE GRAVE" . #x000211)
    ("LATIN CAPITAL LETTER R WITH INVERTED BREVE" . #x000212)
    ("LATIN SMALL LETTER R WITH INVERTED BREVE" . #x000213)
    ("LATIN CAPITAL LETTER U WITH DOUBLE GRAVE" . #x000214)
    ("LATIN SMALL LETTER U WITH DOUBLE GRAVE" . #x000215)
    ("LATIN CAPITAL LETTER U WITH INVERTED BREVE" . #x000216)
    ("LATIN SMALL LETTER U WITH INVERTED BREVE" . #x000217)
    ("LATIN CAPITAL LETTER S WITH COMMA BELOW" . #x000218)
    ("LATIN SMALL LETTER S WITH COMMA BELOW" . #x000219)
    ("LATIN CAPITAL LETTER T WITH COMMA BELOW" . #x00021a)
    ("LATIN SMALL LETTER T WITH COMMA BELOW" . #x00021b)
    ("LATIN CAPITAL LETTER YOGH" . #x00021c)
    ("LATIN SMALL LETTER YOGH" . #x00021d)
    ("LATIN CAPITAL LETTER H WITH CARON" . #x00021e)
    ("LATIN SMALL LETTER H WITH CARON" . #x00021f)
    ("LATIN CAPITAL LETTER N WITH LONG RIGHT LEG" . #x000220)
    ("LATIN CAPITAL LETTER OU" . #x000222)
    ("LATIN SMALL LETTER OU" . #x000223)
    ("LATIN CAPITAL LETTER Z WITH HOOK" . #x000224)
    ("LATIN SMALL LETTER Z WITH HOOK" . #x000225)
    ("LATIN CAPITAL LETTER A WITH DOT ABOVE" . #x000226)
    ("LATIN SMALL LETTER A WITH DOT ABOVE" . #x000227)
    ("LATIN CAPITAL LETTER E WITH CEDILLA" . #x000228)
    ("LATIN SMALL LETTER E WITH CEDILLA" . #x000229)
    ("LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON" . #x00022a)
    ("LATIN SMALL LETTER O WITH DIAERESIS AND MACRON" . #x00022b)
    ("LATIN CAPITAL LETTER O WITH TILDE AND MACRON" . #x00022c)
    ("LATIN SMALL LETTER O WITH TILDE AND MACRON" . #x00022d)
    ("LATIN CAPITAL LETTER O WITH DOT ABOVE" . #x00022e)
    ("LATIN SMALL LETTER O WITH DOT ABOVE" . #x00022f)
    ("LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON" . #x000230)
    ("LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON" . #x000231)
    ("LATIN CAPITAL LETTER Y WITH MACRON" . #x000232)
    ("LATIN SMALL LETTER Y WITH MACRON" . #x000233)
    ("LATIN SMALL LETTER TURNED A" . #x000250)
    ("LATIN SMALL LETTER ALPHA" . #x000251)
    ("LATIN SMALL LETTER TURNED ALPHA" . #x000252)
    ("LATIN SMALL LETTER B WITH HOOK" . #x000253)
    ("LATIN SMALL LETTER OPEN O" . #x000254)
    ("LATIN SMALL LETTER C WITH CURL" . #x000255)
    ("LATIN SMALL LETTER D WITH TAIL" . #x000256)
    ("LATIN SMALL LETTER D WITH HOOK" . #x000257)
    ("LATIN SMALL LETTER REVERSED E" . #x000258)
    ("LATIN SMALL LETTER SCHWA" . #x000259)
    ("LATIN SMALL LETTER SCHWA WITH HOOK" . #x00025a)
    ("LATIN SMALL LETTER OPEN E" . #x00025b)
    ("LATIN SMALL LETTER REVERSED OPEN E" . #x00025c)
    ("LATIN SMALL LETTER REVERSED OPEN E WITH HOOK" . #x00025d)
    ("LATIN SMALL LETTER CLOSED REVERSED OPEN E" . #x00025e)
    ("LATIN SMALL LETTER DOTLESS J WITH STROKE" . #x00025f)
    ("LATIN SMALL LETTER G WITH HOOK" . #x000260)
    ("LATIN SMALL LETTER SCRIPT G" . #x000261)
    ("LATIN LETTER SMALL CAPITAL G" . #x000262)
    ("LATIN SMALL LETTER GAMMA" . #x000263)
    ("LATIN SMALL LETTER RAMS HORN" . #x000264)
    ("LATIN SMALL LETTER TURNED H" . #x000265)
    ("LATIN SMALL LETTER H WITH HOOK" . #x000266)
    ("LATIN SMALL LETTER HENG WITH HOOK" . #x000267)
    ("LATIN SMALL LETTER I WITH STROKE" . #x000268)
    ("LATIN SMALL LETTER IOTA" . #x000269)
    ("LATIN LETTER SMALL CAPITAL I" . #x00026a)
    ("LATIN SMALL LETTER L WITH MIDDLE TILDE" . #x00026b)
    ("LATIN SMALL LETTER L WITH BELT" . #x00026c)
    ("LATIN SMALL LETTER L WITH RETROFLEX HOOK" . #x00026d)
    ("LATIN SMALL LETTER LEZH" . #x00026e)
    ("LATIN SMALL LETTER TURNED M" . #x00026f)
    ("LATIN SMALL LETTER TURNED M WITH LONG LEG" . #x000270)
    ("LATIN SMALL LETTER M WITH HOOK" . #x000271)
    ("LATIN SMALL LETTER N WITH LEFT HOOK" . #x000272)
    ("LATIN SMALL LETTER N WITH RETROFLEX HOOK" . #x000273)
    ("LATIN LETTER SMALL CAPITAL N" . #x000274)
    ("LATIN SMALL LETTER BARRED O" . #x000275)
    ("LATIN LETTER SMALL CAPITAL OE" . #x000276)
    ("LATIN SMALL LETTER CLOSED OMEGA" . #x000277)
    ("LATIN SMALL LETTER PHI" . #x000278)
    ("LATIN SMALL LETTER TURNED R" . #x000279)
    ("LATIN SMALL LETTER TURNED R WITH LONG LEG" . #x00027a)
    ("LATIN SMALL LETTER TURNED R WITH HOOK" . #x00027b)
    ("LATIN SMALL LETTER R WITH LONG LEG" . #x00027c)
    ("LATIN SMALL LETTER R WITH TAIL" . #x00027d)
    ("LATIN SMALL LETTER R WITH FISHHOOK" . #x00027e)
    ("LATIN SMALL LETTER REVERSED R WITH FISHHOOK" . #x00027f)
    ("LATIN LETTER SMALL CAPITAL R" . #x000280)
    ("LATIN LETTER SMALL CAPITAL INVERTED R" . #x000281)
    ("LATIN SMALL LETTER S WITH HOOK" . #x000282)
    ("LATIN SMALL LETTER ESH" . #x000283)
    ("LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK" . #x000284)
    ("LATIN SMALL LETTER SQUAT REVERSED ESH" . #x000285)
    ("LATIN SMALL LETTER ESH WITH CURL" . #x000286)
    ("LATIN SMALL LETTER TURNED T" . #x000287)
    ("LATIN SMALL LETTER T WITH RETROFLEX HOOK" . #x000288)
    ("LATIN SMALL LETTER U BAR" . #x000289)
    ("LATIN SMALL LETTER UPSILON" . #x00028a)
    ("LATIN SMALL LETTER V WITH HOOK" . #x00028b)
    ("LATIN SMALL LETTER TURNED V" . #x00028c)
    ("LATIN SMALL LETTER TURNED W" . #x00028d)
    ("LATIN SMALL LETTER TURNED Y" . #x00028e)
    ("LATIN LETTER SMALL CAPITAL Y" . #x00028f)
    ("LATIN SMALL LETTER Z WITH RETROFLEX HOOK" . #x000290)
    ("LATIN SMALL LETTER Z WITH CURL" . #x000291)
    ("LATIN SMALL LETTER EZH" . #x000292)
    ("LATIN SMALL LETTER EZH WITH CURL" . #x000293)
    ("LATIN LETTER GLOTTAL STOP" . #x000294)
    ("LATIN LETTER PHARYNGEAL VOICED FRICATIVE" . #x000295)
    ("LATIN LETTER INVERTED GLOTTAL STOP" . #x000296)
    ("LATIN LETTER STRETCHED C" . #x000297)
    ("LATIN LETTER BILABIAL CLICK" . #x000298)
    ("LATIN LETTER SMALL CAPITAL B" . #x000299)
    ("LATIN SMALL LETTER CLOSED OPEN E" . #x00029a)
    ("LATIN LETTER SMALL CAPITAL G WITH HOOK" . #x00029b)
    ("LATIN LETTER SMALL CAPITAL H" . #x00029c)
    ("LATIN SMALL LETTER J WITH CROSSED-TAIL" . #x00029d)
    ("LATIN SMALL LETTER TURNED K" . #x00029e)
    ("LATIN LETTER SMALL CAPITAL L" . #x00029f)
    ("LATIN SMALL LETTER Q WITH HOOK" . #x0002a0)
    ("LATIN LETTER GLOTTAL STOP WITH STROKE" . #x0002a1)
    ("LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE" . #x0002a2)
    ("LATIN SMALL LETTER DZ DIGRAPH" . #x0002a3)
    ("LATIN SMALL LETTER DEZH DIGRAPH" . #x0002a4)
    ("LATIN SMALL LETTER DZ DIGRAPH WITH CURL" . #x0002a5)
    ("LATIN SMALL LETTER TS DIGRAPH" . #x0002a6)
    ("LATIN SMALL LETTER TESH DIGRAPH" . #x0002a7)
    ("LATIN SMALL LETTER TC DIGRAPH WITH CURL" . #x0002a8)
    ("LATIN SMALL LETTER FENG DIGRAPH" . #x0002a9)
    ("LATIN SMALL LETTER LS DIGRAPH" . #x0002aa)
    ("LATIN SMALL LETTER LZ DIGRAPH" . #x0002ab)
    ("LATIN LETTER BILABIAL PERCUSSIVE" . #x0002ac)
    ("LATIN LETTER BIDENTAL PERCUSSIVE" . #x0002ad)
    ("MODIFIER LETTER SMALL H" . #x0002b0)
    ("MODIFIER LETTER SMALL H WITH HOOK" . #x0002b1)
    ("MODIFIER LETTER SMALL J" . #x0002b2)
    ("MODIFIER LETTER SMALL R" . #x0002b3)
    ("MODIFIER LETTER SMALL TURNED R" . #x0002b4)
    ("MODIFIER LETTER SMALL TURNED R WITH HOOK" . #x0002b5)
    ("MODIFIER LETTER SMALL CAPITAL INVERTED R" . #x0002b6)
    ("MODIFIER LETTER SMALL W" . #x0002b7)
    ("MODIFIER LETTER SMALL Y" . #x0002b8)
    ("MODIFIER LETTER PRIME" . #x0002b9)
    ("MODIFIER LETTER DOUBLE PRIME" . #x0002ba)
    ("MODIFIER LETTER TURNED COMMA" . #x0002bb)
    ("MODIFIER LETTER APOSTROPHE" . #x0002bc)
    ("MODIFIER LETTER REVERSED COMMA" . #x0002bd)
    ("MODIFIER LETTER RIGHT HALF RING" . #x0002be)
    ("MODIFIER LETTER LEFT HALF RING" . #x0002bf)
    ("MODIFIER LETTER GLOTTAL STOP" . #x0002c0)
    ("MODIFIER LETTER REVERSED GLOTTAL STOP" . #x0002c1)
    ("MODIFIER LETTER LEFT ARROWHEAD" . #x0002c2)
    ("MODIFIER LETTER RIGHT ARROWHEAD" . #x0002c3)
    ("MODIFIER LETTER UP ARROWHEAD" . #x0002c4)
    ("MODIFIER LETTER DOWN ARROWHEAD" . #x0002c5)
    ("MODIFIER LETTER CIRCUMFLEX ACCENT" . #x0002c6)
    ("CARON" . #x0002c7)
    ("MODIFIER LETTER VERTICAL LINE" . #x0002c8)
    ("MODIFIER LETTER MACRON" . #x0002c9)
    ("MODIFIER LETTER ACUTE ACCENT" . #x0002ca)
    ("MODIFIER LETTER GRAVE ACCENT" . #x0002cb)
    ("MODIFIER LETTER LOW VERTICAL LINE" . #x0002cc)
    ("MODIFIER LETTER LOW MACRON" . #x0002cd)
    ("MODIFIER LETTER LOW GRAVE ACCENT" . #x0002ce)
    ("MODIFIER LETTER LOW ACUTE ACCENT" . #x0002cf)
    ("MODIFIER LETTER TRIANGULAR COLON" . #x0002d0)
    ("MODIFIER LETTER HALF TRIANGULAR COLON" . #x0002d1)
    ("MODIFIER LETTER CENTRED RIGHT HALF RING" . #x0002d2)
    ("MODIFIER LETTER CENTRED LEFT HALF RING" . #x0002d3)
    ("MODIFIER LETTER UP TACK" . #x0002d4)
    ("MODIFIER LETTER DOWN TACK" . #x0002d5)
    ("MODIFIER LETTER PLUS SIGN" . #x0002d6)
    ("MODIFIER LETTER MINUS SIGN" . #x0002d7)
    ("BREVE" . #x0002d8)
    ("DOT ABOVE" . #x0002d9)
    ("RING ABOVE" . #x0002da)
    ("OGONEK" . #x0002db)
    ("SMALL TILDE" . #x0002dc)
    ("DOUBLE ACUTE ACCENT" . #x0002dd)
    ("MODIFIER LETTER RHOTIC HOOK" . #x0002de)
    ("MODIFIER LETTER CROSS ACCENT" . #x0002df)
    ("MODIFIER LETTER SMALL GAMMA" . #x0002e0)
    ("MODIFIER LETTER SMALL L" . #x0002e1)
    ("MODIFIER LETTER SMALL S" . #x0002e2)
    ("MODIFIER LETTER SMALL X" . #x0002e3)
    ("MODIFIER LETTER SMALL REVERSED GLOTTAL STOP" . #x0002e4)
    ("MODIFIER LETTER EXTRA-HIGH TONE BAR" . #x0002e5)
    ("MODIFIER LETTER HIGH TONE BAR" . #x0002e6)
    ("MODIFIER LETTER MID TONE BAR" . #x0002e7)
    ("MODIFIER LETTER LOW TONE BAR" . #x0002e8)
    ("MODIFIER LETTER EXTRA-LOW TONE BAR" . #x0002e9)
    ("MODIFIER LETTER YIN DEPARTING TONE MARK" . #x0002ea)
    ("MODIFIER LETTER YANG DEPARTING TONE MARK" . #x0002eb)
    ("MODIFIER LETTER VOICING" . #x0002ec)
    ("MODIFIER LETTER UNASPIRATED" . #x0002ed)
    ("MODIFIER LETTER DOUBLE APOSTROPHE" . #x0002ee)
    ("COMBINING GRAVE ACCENT" . #x000300)
    ("COMBINING ACUTE ACCENT" . #x000301)
    ("COMBINING CIRCUMFLEX ACCENT" . #x000302)
    ("COMBINING TILDE" . #x000303)
    ("COMBINING MACRON" . #x000304)
    ("COMBINING OVERLINE" . #x000305)
    ("COMBINING BREVE" . #x000306)
    ("COMBINING DOT ABOVE" . #x000307)
    ("COMBINING DIAERESIS" . #x000308)
    ("COMBINING HOOK ABOVE" . #x000309)
    ("COMBINING RING ABOVE" . #x00030a)
    ("COMBINING DOUBLE ACUTE ACCENT" . #x00030b)
    ("COMBINING CARON" . #x00030c)
    ("COMBINING VERTICAL LINE ABOVE" . #x00030d)
    ("COMBINING DOUBLE VERTICAL LINE ABOVE" . #x00030e)
    ("COMBINING DOUBLE GRAVE ACCENT" . #x00030f)
    ("COMBINING CANDRABINDU" . #x000310)
    ("COMBINING INVERTED BREVE" . #x000311)
    ("COMBINING TURNED COMMA ABOVE" . #x000312)
    ("COMBINING COMMA ABOVE" . #x000313)
    ("COMBINING REVERSED COMMA ABOVE" . #x000314)
    ("COMBINING COMMA ABOVE RIGHT" . #x000315)
    ("COMBINING GRAVE ACCENT BELOW" . #x000316)
    ("COMBINING ACUTE ACCENT BELOW" . #x000317)
    ("COMBINING LEFT TACK BELOW" . #x000318)
    ("COMBINING RIGHT TACK BELOW" . #x000319)
    ("COMBINING LEFT ANGLE ABOVE" . #x00031a)
    ("COMBINING HORN" . #x00031b)
    ("COMBINING LEFT HALF RING BELOW" . #x00031c)
    ("COMBINING UP TACK BELOW" . #x00031d)
    ("COMBINING DOWN TACK BELOW" . #x00031e)
    ("COMBINING PLUS SIGN BELOW" . #x00031f)
    ("COMBINING MINUS SIGN BELOW" . #x000320)
    ("COMBINING PALATALIZED HOOK BELOW" . #x000321)
    ("COMBINING RETROFLEX HOOK BELOW" . #x000322)
    ("COMBINING DOT BELOW" . #x000323)
    ("COMBINING DIAERESIS BELOW" . #x000324)
    ("COMBINING RING BELOW" . #x000325)
    ("COMBINING COMMA BELOW" . #x000326)
    ("COMBINING CEDILLA" . #x000327)
    ("COMBINING OGONEK" . #x000328)
    ("COMBINING VERTICAL LINE BELOW" . #x000329)
    ("COMBINING BRIDGE BELOW" . #x00032a)
    ("COMBINING INVERTED DOUBLE ARCH BELOW" . #x00032b)
    ("COMBINING CARON BELOW" . #x00032c)
    ("COMBINING CIRCUMFLEX ACCENT BELOW" . #x00032d)
    ("COMBINING BREVE BELOW" . #x00032e)
    ("COMBINING INVERTED BREVE BELOW" . #x00032f)
    ("COMBINING TILDE BELOW" . #x000330)
    ("COMBINING MACRON BELOW" . #x000331)
    ("COMBINING LOW LINE" . #x000332)
    ("COMBINING DOUBLE LOW LINE" . #x000333)
    ("COMBINING TILDE OVERLAY" . #x000334)
    ("COMBINING SHORT STROKE OVERLAY" . #x000335)
    ("COMBINING LONG STROKE OVERLAY" . #x000336)
    ("COMBINING SHORT SOLIDUS OVERLAY" . #x000337)
    ("COMBINING LONG SOLIDUS OVERLAY" . #x000338)
    ("COMBINING RIGHT HALF RING BELOW" . #x000339)
    ("COMBINING INVERTED BRIDGE BELOW" . #x00033a)
    ("COMBINING SQUARE BELOW" . #x00033b)
    ("COMBINING SEAGULL BELOW" . #x00033c)
    ("COMBINING X ABOVE" . #x00033d)
    ("COMBINING VERTICAL TILDE" . #x00033e)
    ("COMBINING DOUBLE OVERLINE" . #x00033f)
    ("COMBINING GRAVE TONE MARK" . #x000340)
    ("COMBINING ACUTE TONE MARK" . #x000341)
    ("COMBINING GREEK PERISPOMENI" . #x000342)
    ("COMBINING GREEK KORONIS" . #x000343)
    ("COMBINING GREEK DIALYTIKA TONOS" . #x000344)
    ("COMBINING GREEK YPOGEGRAMMENI" . #x000345)
    ("COMBINING BRIDGE ABOVE" . #x000346)
    ("COMBINING EQUALS SIGN BELOW" . #x000347)
    ("COMBINING DOUBLE VERTICAL LINE BELOW" . #x000348)
    ("COMBINING LEFT ANGLE BELOW" . #x000349)
    ("COMBINING NOT TILDE ABOVE" . #x00034a)
    ("COMBINING HOMOTHETIC ABOVE" . #x00034b)
    ("COMBINING ALMOST EQUAL TO ABOVE" . #x00034c)
    ("COMBINING LEFT RIGHT ARROW BELOW" . #x00034d)
    ("COMBINING UPWARDS ARROW BELOW" . #x00034e)
    ("COMBINING GRAPHEME JOINER" . #x00034f)
    ("COMBINING DOUBLE TILDE" . #x000360)
    ("COMBINING DOUBLE INVERTED BREVE" . #x000361)
    ("COMBINING DOUBLE RIGHTWARDS ARROW BELOW" . #x000362)
    ("COMBINING LATIN SMALL LETTER A" . #x000363)
    ("COMBINING LATIN SMALL LETTER E" . #x000364)
    ("COMBINING LATIN SMALL LETTER I" . #x000365)
    ("COMBINING LATIN SMALL LETTER O" . #x000366)
    ("COMBINING LATIN SMALL LETTER U" . #x000367)
    ("COMBINING LATIN SMALL LETTER C" . #x000368)
    ("COMBINING LATIN SMALL LETTER D" . #x000369)
    ("COMBINING LATIN SMALL LETTER H" . #x00036a)
    ("COMBINING LATIN SMALL LETTER M" . #x00036b)
    ("COMBINING LATIN SMALL LETTER R" . #x00036c)
    ("COMBINING LATIN SMALL LETTER T" . #x00036d)
    ("COMBINING LATIN SMALL LETTER V" . #x00036e)
    ("COMBINING LATIN SMALL LETTER X" . #x00036f)
    ("GREEK NUMERAL SIGN" . #x000374)
    ("GREEK LOWER NUMERAL SIGN" . #x000375)
    ("GREEK YPOGEGRAMMENI" . #x00037a)
    ("GREEK QUESTION MARK" . #x00037e)
    ("GREEK TONOS" . #x000384)
    ("GREEK DIALYTIKA TONOS" . #x000385)
    ("GREEK CAPITAL LETTER ALPHA WITH TONOS" . #x000386)
    ("GREEK ANO TELEIA" . #x000387)
    ("GREEK CAPITAL LETTER EPSILON WITH TONOS" . #x000388)
    ("GREEK CAPITAL LETTER ETA WITH TONOS" . #x000389)
    ("GREEK CAPITAL LETTER IOTA WITH TONOS" . #x00038a)
    ("GREEK CAPITAL LETTER OMICRON WITH TONOS" . #x00038c)
    ("GREEK CAPITAL LETTER UPSILON WITH TONOS" . #x00038e)
    ("GREEK CAPITAL LETTER OMEGA WITH TONOS" . #x00038f)
    ("GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" . #x000390)
    ("GREEK CAPITAL LETTER ALPHA" . #x000391)
    ("GREEK CAPITAL LETTER BETA" . #x000392)
    ("GREEK CAPITAL LETTER GAMMA" . #x000393)
    ("GREEK CAPITAL LETTER DELTA" . #x000394)
    ("GREEK CAPITAL LETTER EPSILON" . #x000395)
    ("GREEK CAPITAL LETTER ZETA" . #x000396)
    ("GREEK CAPITAL LETTER ETA" . #x000397)
    ("GREEK CAPITAL LETTER THETA" . #x000398)
    ("GREEK CAPITAL LETTER IOTA" . #x000399)
    ("GREEK CAPITAL LETTER KAPPA" . #x00039a)
    ("GREEK CAPITAL LETTER LAMDA" . #x00039b)
    ("GREEK CAPITAL LETTER MU" . #x00039c)
    ("GREEK CAPITAL LETTER NU" . #x00039d)
    ("GREEK CAPITAL LETTER XI" . #x00039e)
    ("GREEK CAPITAL LETTER OMICRON" . #x00039f)
    ("GREEK CAPITAL LETTER PI" . #x0003a0)
    ("GREEK CAPITAL LETTER RHO" . #x0003a1)
    ("GREEK CAPITAL LETTER SIGMA" . #x0003a3)
    ("GREEK CAPITAL LETTER TAU" . #x0003a4)
    ("GREEK CAPITAL LETTER UPSILON" . #x0003a5)
    ("GREEK CAPITAL LETTER PHI" . #x0003a6)
    ("GREEK CAPITAL LETTER CHI" . #x0003a7)
    ("GREEK CAPITAL LETTER PSI" . #x0003a8)
    ("GREEK CAPITAL LETTER OMEGA" . #x0003a9)
    ("GREEK CAPITAL LETTER IOTA WITH DIALYTIKA" . #x0003aa)
    ("GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA" . #x0003ab)
    ("GREEK SMALL LETTER ALPHA WITH TONOS" . #x0003ac)
    ("GREEK SMALL LETTER EPSILON WITH TONOS" . #x0003ad)
    ("GREEK SMALL LETTER ETA WITH TONOS" . #x0003ae)
    ("GREEK SMALL LETTER IOTA WITH TONOS" . #x0003af)
    ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS" . #x0003b0)
    ("GREEK SMALL LETTER ALPHA" . #x0003b1)
    ("GREEK SMALL LETTER BETA" . #x0003b2)
    ("GREEK SMALL LETTER GAMMA" . #x0003b3)
    ("GREEK SMALL LETTER DELTA" . #x0003b4)
    ("GREEK SMALL LETTER EPSILON" . #x0003b5)
    ("GREEK SMALL LETTER ZETA" . #x0003b6)
    ("GREEK SMALL LETTER ETA" . #x0003b7)
    ("GREEK SMALL LETTER THETA" . #x0003b8)
    ("GREEK SMALL LETTER IOTA" . #x0003b9)
    ("GREEK SMALL LETTER KAPPA" . #x0003ba)
    ("GREEK SMALL LETTER LAMDA" . #x0003bb)
    ("GREEK SMALL LETTER MU" . #x0003bc)
    ("GREEK SMALL LETTER NU" . #x0003bd)
    ("GREEK SMALL LETTER XI" . #x0003be)
    ("GREEK SMALL LETTER OMICRON" . #x0003bf)
    ("GREEK SMALL LETTER PI" . #x0003c0)
    ("GREEK SMALL LETTER RHO" . #x0003c1)
    ("GREEK SMALL LETTER FINAL SIGMA" . #x0003c2)
    ("GREEK SMALL LETTER SIGMA" . #x0003c3)
    ("GREEK SMALL LETTER TAU" . #x0003c4)
    ("GREEK SMALL LETTER UPSILON" . #x0003c5)
    ("GREEK SMALL LETTER PHI" . #x0003c6)
    ("GREEK SMALL LETTER CHI" . #x0003c7)
    ("GREEK SMALL LETTER PSI" . #x0003c8)
    ("GREEK SMALL LETTER OMEGA" . #x0003c9)
    ("GREEK SMALL LETTER IOTA WITH DIALYTIKA" . #x0003ca)
    ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA" . #x0003cb)
    ("GREEK SMALL LETTER OMICRON WITH TONOS" . #x0003cc)
    ("GREEK SMALL LETTER UPSILON WITH TONOS" . #x0003cd)
    ("GREEK SMALL LETTER OMEGA WITH TONOS" . #x0003ce)
    ("GREEK BETA SYMBOL" . #x0003d0)
    ("GREEK THETA SYMBOL" . #x0003d1)
    ("GREEK UPSILON WITH HOOK SYMBOL" . #x0003d2)
    ("GREEK UPSILON WITH ACUTE AND HOOK SYMBOL" . #x0003d3)
    ("GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL" . #x0003d4)
    ("GREEK PHI SYMBOL" . #x0003d5)
    ("GREEK PI SYMBOL" . #x0003d6)
    ("GREEK KAI SYMBOL" . #x0003d7)
    ("GREEK LETTER ARCHAIC KOPPA" . #x0003d8)
    ("GREEK SMALL LETTER ARCHAIC KOPPA" . #x0003d9)
    ("GREEK LETTER STIGMA" . #x0003da)
    ("GREEK SMALL LETTER STIGMA" . #x0003db)
    ("GREEK LETTER DIGAMMA" . #x0003dc)
    ("GREEK SMALL LETTER DIGAMMA" . #x0003dd)
    ("GREEK LETTER KOPPA" . #x0003de)
    ("GREEK SMALL LETTER KOPPA" . #x0003df)
    ("GREEK LETTER SAMPI" . #x0003e0)
    ("GREEK SMALL LETTER SAMPI" . #x0003e1)
    ("COPTIC CAPITAL LETTER SHEI" . #x0003e2)
    ("COPTIC SMALL LETTER SHEI" . #x0003e3)
    ("COPTIC CAPITAL LETTER FEI" . #x0003e4)
    ("COPTIC SMALL LETTER FEI" . #x0003e5)
    ("COPTIC CAPITAL LETTER KHEI" . #x0003e6)
    ("COPTIC SMALL LETTER KHEI" . #x0003e7)
    ("COPTIC CAPITAL LETTER HORI" . #x0003e8)
    ("COPTIC SMALL LETTER HORI" . #x0003e9)
    ("COPTIC CAPITAL LETTER GANGIA" . #x0003ea)
    ("COPTIC SMALL LETTER GANGIA" . #x0003eb)
    ("COPTIC CAPITAL LETTER SHIMA" . #x0003ec)
    ("COPTIC SMALL LETTER SHIMA" . #x0003ed)
    ("COPTIC CAPITAL LETTER DEI" . #x0003ee)
    ("COPTIC SMALL LETTER DEI" . #x0003ef)
    ("GREEK KAPPA SYMBOL" . #x0003f0)
    ("GREEK RHO SYMBOL" . #x0003f1)
    ("GREEK LUNATE SIGMA SYMBOL" . #x0003f2)
    ("GREEK LETTER YOT" . #x0003f3)
    ("GREEK CAPITAL THETA SYMBOL" . #x0003f4)
    ("GREEK LUNATE EPSILON SYMBOL" . #x0003f5)
    ("GREEK REVERSED LUNATE EPSILON SYMBOL" . #x0003f6)
    ("CYRILLIC CAPITAL LETTER IE WITH GRAVE" . #x000400)
    ("CYRILLIC CAPITAL LETTER IO" . #x000401)
    ("CYRILLIC CAPITAL LETTER DJE" . #x000402)
    ("CYRILLIC CAPITAL LETTER GJE" . #x000403)
    ("CYRILLIC CAPITAL LETTER UKRAINIAN IE" . #x000404)
    ("CYRILLIC CAPITAL LETTER DZE" . #x000405)
    ("CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I" . #x000406)
    ("CYRILLIC CAPITAL LETTER YI" . #x000407)
    ("CYRILLIC CAPITAL LETTER JE" . #x000408)
    ("CYRILLIC CAPITAL LETTER LJE" . #x000409)
    ("CYRILLIC CAPITAL LETTER NJE" . #x00040a)
    ("CYRILLIC CAPITAL LETTER TSHE" . #x00040b)
    ("CYRILLIC CAPITAL LETTER KJE" . #x00040c)
    ("CYRILLIC CAPITAL LETTER I WITH GRAVE" . #x00040d)
    ("CYRILLIC CAPITAL LETTER SHORT U" . #x00040e)
    ("CYRILLIC CAPITAL LETTER DZHE" . #x00040f)
    ("CYRILLIC CAPITAL LETTER A" . #x000410)
    ("CYRILLIC CAPITAL LETTER BE" . #x000411)
    ("CYRILLIC CAPITAL LETTER VE" . #x000412)
    ("CYRILLIC CAPITAL LETTER GHE" . #x000413)
    ("CYRILLIC CAPITAL LETTER DE" . #x000414)
    ("CYRILLIC CAPITAL LETTER IE" . #x000415)
    ("CYRILLIC CAPITAL LETTER ZHE" . #x000416)
    ("CYRILLIC CAPITAL LETTER ZE" . #x000417)
    ("CYRILLIC CAPITAL LETTER I" . #x000418)
    ("CYRILLIC CAPITAL LETTER SHORT I" . #x000419)
    ("CYRILLIC CAPITAL LETTER KA" . #x00041a)
    ("CYRILLIC CAPITAL LETTER EL" . #x00041b)
    ("CYRILLIC CAPITAL LETTER EM" . #x00041c)
    ("CYRILLIC CAPITAL LETTER EN" . #x00041d)
    ("CYRILLIC CAPITAL LETTER O" . #x00041e)
    ("CYRILLIC CAPITAL LETTER PE" . #x00041f)
    ("CYRILLIC CAPITAL LETTER ER" . #x000420)
    ("CYRILLIC CAPITAL LETTER ES" . #x000421)
    ("CYRILLIC CAPITAL LETTER TE" . #x000422)
    ("CYRILLIC CAPITAL LETTER U" . #x000423)
    ("CYRILLIC CAPITAL LETTER EF" . #x000424)
    ("CYRILLIC CAPITAL LETTER HA" . #x000425)
    ("CYRILLIC CAPITAL LETTER TSE" . #x000426)
    ("CYRILLIC CAPITAL LETTER CHE" . #x000427)
    ("CYRILLIC CAPITAL LETTER SHA" . #x000428)
    ("CYRILLIC CAPITAL LETTER SHCHA" . #x000429)
    ("CYRILLIC CAPITAL LETTER HARD SIGN" . #x00042a)
    ("CYRILLIC CAPITAL LETTER YERU" . #x00042b)
    ("CYRILLIC CAPITAL LETTER SOFT SIGN" . #x00042c)
    ("CYRILLIC CAPITAL LETTER E" . #x00042d)
    ("CYRILLIC CAPITAL LETTER YU" . #x00042e)
    ("CYRILLIC CAPITAL LETTER YA" . #x00042f)
    ("CYRILLIC SMALL LETTER A" . #x000430)
    ("CYRILLIC SMALL LETTER BE" . #x000431)
    ("CYRILLIC SMALL LETTER VE" . #x000432)
    ("CYRILLIC SMALL LETTER GHE" . #x000433)
    ("CYRILLIC SMALL LETTER DE" . #x000434)
    ("CYRILLIC SMALL LETTER IE" . #x000435)
    ("CYRILLIC SMALL LETTER ZHE" . #x000436)
    ("CYRILLIC SMALL LETTER ZE" . #x000437)
    ("CYRILLIC SMALL LETTER I" . #x000438)
    ("CYRILLIC SMALL LETTER SHORT I" . #x000439)
    ("CYRILLIC SMALL LETTER KA" . #x00043a)
    ("CYRILLIC SMALL LETTER EL" . #x00043b)
    ("CYRILLIC SMALL LETTER EM" . #x00043c)
    ("CYRILLIC SMALL LETTER EN" . #x00043d)
    ("CYRILLIC SMALL LETTER O" . #x00043e)
    ("CYRILLIC SMALL LETTER PE" . #x00043f)
    ("CYRILLIC SMALL LETTER ER" . #x000440)
    ("CYRILLIC SMALL LETTER ES" . #x000441)
    ("CYRILLIC SMALL LETTER TE" . #x000442)
    ("CYRILLIC SMALL LETTER U" . #x000443)
    ("CYRILLIC SMALL LETTER EF" . #x000444)
    ("CYRILLIC SMALL LETTER HA" . #x000445)
    ("CYRILLIC SMALL LETTER TSE" . #x000446)
    ("CYRILLIC SMALL LETTER CHE" . #x000447)
    ("CYRILLIC SMALL LETTER SHA" . #x000448)
    ("CYRILLIC SMALL LETTER SHCHA" . #x000449)
    ("CYRILLIC SMALL LETTER HARD SIGN" . #x00044a)
    ("CYRILLIC SMALL LETTER YERU" . #x00044b)
    ("CYRILLIC SMALL LETTER SOFT SIGN" . #x00044c)
    ("CYRILLIC SMALL LETTER E" . #x00044d)
    ("CYRILLIC SMALL LETTER YU" . #x00044e)
    ("CYRILLIC SMALL LETTER YA" . #x00044f)
    ("CYRILLIC SMALL LETTER IE WITH GRAVE" . #x000450)
    ("CYRILLIC SMALL LETTER IO" . #x000451)
    ("CYRILLIC SMALL LETTER DJE" . #x000452)
    ("CYRILLIC SMALL LETTER GJE" . #x000453)
    ("CYRILLIC SMALL LETTER UKRAINIAN IE" . #x000454)
    ("CYRILLIC SMALL LETTER DZE" . #x000455)
    ("CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I" . #x000456)
    ("CYRILLIC SMALL LETTER YI" . #x000457)
    ("CYRILLIC SMALL LETTER JE" . #x000458)
    ("CYRILLIC SMALL LETTER LJE" . #x000459)
    ("CYRILLIC SMALL LETTER NJE" . #x00045a)
    ("CYRILLIC SMALL LETTER TSHE" . #x00045b)
    ("CYRILLIC SMALL LETTER KJE" . #x00045c)
    ("CYRILLIC SMALL LETTER I WITH GRAVE" . #x00045d)
    ("CYRILLIC SMALL LETTER SHORT U" . #x00045e)
    ("CYRILLIC SMALL LETTER DZHE" . #x00045f)
    ("CYRILLIC CAPITAL LETTER OMEGA" . #x000460)
    ("CYRILLIC SMALL LETTER OMEGA" . #x000461)
    ("CYRILLIC CAPITAL LETTER YAT" . #x000462)
    ("CYRILLIC SMALL LETTER YAT" . #x000463)
    ("CYRILLIC CAPITAL LETTER IOTIFIED E" . #x000464)
    ("CYRILLIC SMALL LETTER IOTIFIED E" . #x000465)
    ("CYRILLIC CAPITAL LETTER LITTLE YUS" . #x000466)
    ("CYRILLIC SMALL LETTER LITTLE YUS" . #x000467)
    ("CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS" . #x000468)
    ("CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS" . #x000469)
    ("CYRILLIC CAPITAL LETTER BIG YUS" . #x00046a)
    ("CYRILLIC SMALL LETTER BIG YUS" . #x00046b)
    ("CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS" . #x00046c)
    ("CYRILLIC SMALL LETTER IOTIFIED BIG YUS" . #x00046d)
    ("CYRILLIC CAPITAL LETTER KSI" . #x00046e)
    ("CYRILLIC SMALL LETTER KSI" . #x00046f)
    ("CYRILLIC CAPITAL LETTER PSI" . #x000470)
    ("CYRILLIC SMALL LETTER PSI" . #x000471)
    ("CYRILLIC CAPITAL LETTER FITA" . #x000472)
    ("CYRILLIC SMALL LETTER FITA" . #x000473)
    ("CYRILLIC CAPITAL LETTER IZHITSA" . #x000474)
    ("CYRILLIC SMALL LETTER IZHITSA" . #x000475)
    ("CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" . #x000476)
    ("CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" . #x000477)
    ("CYRILLIC CAPITAL LETTER UK" . #x000478)
    ("CYRILLIC SMALL LETTER UK" . #x000479)
    ("CYRILLIC CAPITAL LETTER ROUND OMEGA" . #x00047a)
    ("CYRILLIC SMALL LETTER ROUND OMEGA" . #x00047b)
    ("CYRILLIC CAPITAL LETTER OMEGA WITH TITLO" . #x00047c)
    ("CYRILLIC SMALL LETTER OMEGA WITH TITLO" . #x00047d)
    ("CYRILLIC CAPITAL LETTER OT" . #x00047e)
    ("CYRILLIC SMALL LETTER OT" . #x00047f)
    ("CYRILLIC CAPITAL LETTER KOPPA" . #x000480)
    ("CYRILLIC SMALL LETTER KOPPA" . #x000481)
    ("CYRILLIC THOUSANDS SIGN" . #x000482)
    ("COMBINING CYRILLIC TITLO" . #x000483)
    ("COMBINING CYRILLIC PALATALIZATION" . #x000484)
    ("COMBINING CYRILLIC DASIA PNEUMATA" . #x000485)
    ("COMBINING CYRILLIC PSILI PNEUMATA" . #x000486)
    ("COMBINING CYRILLIC HUNDRED THOUSANDS SIGN" . #x000488)
    ("COMBINING CYRILLIC MILLIONS SIGN" . #x000489)
    ("CYRILLIC CAPITAL LETTER SHORT I WITH TAIL" . #x00048a)
    ("CYRILLIC SMALL LETTER SHORT I WITH TAIL" . #x00048b)
    ("CYRILLIC CAPITAL LETTER SEMISOFT SIGN" . #x00048c)
    ("CYRILLIC SMALL LETTER SEMISOFT SIGN" . #x00048d)
    ("CYRILLIC CAPITAL LETTER ER WITH TICK" . #x00048e)
    ("CYRILLIC SMALL LETTER ER WITH TICK" . #x00048f)
    ("CYRILLIC CAPITAL LETTER GHE WITH UPTURN" . #x000490)
    ("CYRILLIC SMALL LETTER GHE WITH UPTURN" . #x000491)
    ("CYRILLIC CAPITAL LETTER GHE WITH STROKE" . #x000492)
    ("CYRILLIC SMALL LETTER GHE WITH STROKE" . #x000493)
    ("CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK" . #x000494)
    ("CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK" . #x000495)
    ("CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER" . #x000496)
    ("CYRILLIC SMALL LETTER ZHE WITH DESCENDER" . #x000497)
    ("CYRILLIC CAPITAL LETTER ZE WITH DESCENDER" . #x000498)
    ("CYRILLIC SMALL LETTER ZE WITH DESCENDER" . #x000499)
    ("CYRILLIC CAPITAL LETTER KA WITH DESCENDER" . #x00049a)
    ("CYRILLIC SMALL LETTER KA WITH DESCENDER" . #x00049b)
    ("CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE" . #x00049c)
    ("CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE" . #x00049d)
    ("CYRILLIC CAPITAL LETTER KA WITH STROKE" . #x00049e)
    ("CYRILLIC SMALL LETTER KA WITH STROKE" . #x00049f)
    ("CYRILLIC CAPITAL LETTER BASHKIR KA" . #x0004a0)
    ("CYRILLIC SMALL LETTER BASHKIR KA" . #x0004a1)
    ("CYRILLIC CAPITAL LETTER EN WITH DESCENDER" . #x0004a2)
    ("CYRILLIC SMALL LETTER EN WITH DESCENDER" . #x0004a3)
    ("CYRILLIC CAPITAL LIGATURE EN GHE" . #x0004a4)
    ("CYRILLIC SMALL LIGATURE EN GHE" . #x0004a5)
    ("CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK" . #x0004a6)
    ("CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK" . #x0004a7)
    ("CYRILLIC CAPITAL LETTER ABKHASIAN HA" . #x0004a8)
    ("CYRILLIC SMALL LETTER ABKHASIAN HA" . #x0004a9)
    ("CYRILLIC CAPITAL LETTER ES WITH DESCENDER" . #x0004aa)
    ("CYRILLIC SMALL LETTER ES WITH DESCENDER" . #x0004ab)
    ("CYRILLIC CAPITAL LETTER TE WITH DESCENDER" . #x0004ac)
    ("CYRILLIC SMALL LETTER TE WITH DESCENDER" . #x0004ad)
    ("CYRILLIC CAPITAL LETTER STRAIGHT U" . #x0004ae)
    ("CYRILLIC SMALL LETTER STRAIGHT U" . #x0004af)
    ("CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE" . #x0004b0)
    ("CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE" . #x0004b1)
    ("CYRILLIC CAPITAL LETTER HA WITH DESCENDER" . #x0004b2)
    ("CYRILLIC SMALL LETTER HA WITH DESCENDER" . #x0004b3)
    ("CYRILLIC CAPITAL LIGATURE TE TSE" . #x0004b4)
    ("CYRILLIC SMALL LIGATURE TE TSE" . #x0004b5)
    ("CYRILLIC CAPITAL LETTER CHE WITH DESCENDER" . #x0004b6)
    ("CYRILLIC SMALL LETTER CHE WITH DESCENDER" . #x0004b7)
    ("CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE" . #x0004b8)
    ("CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE" . #x0004b9)
    ("CYRILLIC CAPITAL LETTER SHHA" . #x0004ba)
    ("CYRILLIC SMALL LETTER SHHA" . #x0004bb)
    ("CYRILLIC CAPITAL LETTER ABKHASIAN CHE" . #x0004bc)
    ("CYRILLIC SMALL LETTER ABKHASIAN CHE" . #x0004bd)
    ("CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER" . #x0004be)
    ("CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER" . #x0004bf)
    ("CYRILLIC LETTER PALOCHKA" . #x0004c0)
    ("CYRILLIC CAPITAL LETTER ZHE WITH BREVE" . #x0004c1)
    ("CYRILLIC SMALL LETTER ZHE WITH BREVE" . #x0004c2)
    ("CYRILLIC CAPITAL LETTER KA WITH HOOK" . #x0004c3)
    ("CYRILLIC SMALL LETTER KA WITH HOOK" . #x0004c4)
    ("CYRILLIC CAPITAL LETTER EL WITH TAIL" . #x0004c5)
    ("CYRILLIC SMALL LETTER EL WITH TAIL" . #x0004c6)
    ("CYRILLIC CAPITAL LETTER EN WITH HOOK" . #x0004c7)
    ("CYRILLIC SMALL LETTER EN WITH HOOK" . #x0004c8)
    ("CYRILLIC CAPITAL LETTER EN WITH TAIL" . #x0004c9)
    ("CYRILLIC SMALL LETTER EN WITH TAIL" . #x0004ca)
    ("CYRILLIC CAPITAL LETTER KHAKASSIAN CHE" . #x0004cb)
    ("CYRILLIC SMALL LETTER KHAKASSIAN CHE" . #x0004cc)
    ("CYRILLIC CAPITAL LETTER EM WITH TAIL" . #x0004cd)
    ("CYRILLIC SMALL LETTER EM WITH TAIL" . #x0004ce)
    ("CYRILLIC CAPITAL LETTER A WITH BREVE" . #x0004d0)
    ("CYRILLIC SMALL LETTER A WITH BREVE" . #x0004d1)
    ("CYRILLIC CAPITAL LETTER A WITH DIAERESIS" . #x0004d2)
    ("CYRILLIC SMALL LETTER A WITH DIAERESIS" . #x0004d3)
    ("CYRILLIC CAPITAL LIGATURE A IE" . #x0004d4)
    ("CYRILLIC SMALL LIGATURE A IE" . #x0004d5)
    ("CYRILLIC CAPITAL LETTER IE WITH BREVE" . #x0004d6)
    ("CYRILLIC SMALL LETTER IE WITH BREVE" . #x0004d7)
    ("CYRILLIC CAPITAL LETTER SCHWA" . #x0004d8)
    ("CYRILLIC SMALL LETTER SCHWA" . #x0004d9)
    ("CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS" . #x0004da)
    ("CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS" . #x0004db)
    ("CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS" . #x0004dc)
    ("CYRILLIC SMALL LETTER ZHE WITH DIAERESIS" . #x0004dd)
    ("CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS" . #x0004de)
    ("CYRILLIC SMALL LETTER ZE WITH DIAERESIS" . #x0004df)
    ("CYRILLIC CAPITAL LETTER ABKHASIAN DZE" . #x0004e0)
    ("CYRILLIC SMALL LETTER ABKHASIAN DZE" . #x0004e1)
    ("CYRILLIC CAPITAL LETTER I WITH MACRON" . #x0004e2)
    ("CYRILLIC SMALL LETTER I WITH MACRON" . #x0004e3)
    ("CYRILLIC CAPITAL LETTER I WITH DIAERESIS" . #x0004e4)
    ("CYRILLIC SMALL LETTER I WITH DIAERESIS" . #x0004e5)
    ("CYRILLIC CAPITAL LETTER O WITH DIAERESIS" . #x0004e6)
    ("CYRILLIC SMALL LETTER O WITH DIAERESIS" . #x0004e7)
    ("CYRILLIC CAPITAL LETTER BARRED O" . #x0004e8)
    ("CYRILLIC SMALL LETTER BARRED O" . #x0004e9)
    ("CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS" . #x0004ea)
    ("CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS" . #x0004eb)
    ("CYRILLIC CAPITAL LETTER E WITH DIAERESIS" . #x0004ec)
    ("CYRILLIC SMALL LETTER E WITH DIAERESIS" . #x0004ed)
    ("CYRILLIC CAPITAL LETTER U WITH MACRON" . #x0004ee)
    ("CYRILLIC SMALL LETTER U WITH MACRON" . #x0004ef)
    ("CYRILLIC CAPITAL LETTER U WITH DIAERESIS" . #x0004f0)
    ("CYRILLIC SMALL LETTER U WITH DIAERESIS" . #x0004f1)
    ("CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE" . #x0004f2)
    ("CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE" . #x0004f3)
    ("CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS" . #x0004f4)
    ("CYRILLIC SMALL LETTER CHE WITH DIAERESIS" . #x0004f5)
    ("CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS" . #x0004f8)
    ("CYRILLIC SMALL LETTER YERU WITH DIAERESIS" . #x0004f9)
    ("EN QUAD" . #x002000)
    ("EM QUAD" . #x002001)
    ("EN SPACE" . #x002002)
    ("EM SPACE" . #x002003)
    ("THREE-PER-EM SPACE" . #x002004)
    ("FOUR-PER-EM SPACE" . #x002005)
    ("SIX-PER-EM SPACE" . #x002006)
    ("FIGURE SPACE" . #x002007)
    ("PUNCTUATION SPACE" . #x002008)
    ("THIN SPACE" . #x002009)
    ("HAIR SPACE" . #x00200a)
    ("ZERO WIDTH SPACE" . #x00200b)
    ("ZERO WIDTH NON-JOINER" . #x00200c)
    ("ZERO WIDTH JOINER" . #x00200d)
    ("LEFT-TO-RIGHT MARK" . #x00200e)
    ("RIGHT-TO-LEFT MARK" . #x00200f)
    ("HYPHEN" . #x002010)
    ("NON-BREAKING HYPHEN" . #x002011)
    ("FIGURE DASH" . #x002012)
    ("EN DASH" . #x002013)
    ("EM DASH" . #x002014)
    ("HORIZONTAL BAR" . #x002015)
    ("DOUBLE VERTICAL LINE" . #x002016)
    ("DOUBLE LOW LINE" . #x002017)
    ("LEFT SINGLE QUOTATION MARK" . #x002018)
    ("RIGHT SINGLE QUOTATION MARK" . #x002019)
    ("SINGLE LOW-9 QUOTATION MARK" . #x00201a)
    ("SINGLE HIGH-REVERSED-9 QUOTATION MARK" . #x00201b)
    ("LEFT DOUBLE QUOTATION MARK" . #x00201c)
    ("RIGHT DOUBLE QUOTATION MARK" . #x00201d)
    ("DOUBLE LOW-9 QUOTATION MARK" . #x00201e)
    ("DOUBLE HIGH-REVERSED-9 QUOTATION MARK" . #x00201f)
    ("DAGGER" . #x002020)
    ("DOUBLE DAGGER" . #x002021)
    ("BULLET" . #x002022)
    ("TRIANGULAR BULLET" . #x002023)
    ("ONE DOT LEADER" . #x002024)
    ("TWO DOT LEADER" . #x002025)
    ("HORIZONTAL ELLIPSIS" . #x002026)
    ("HYPHENATION POINT" . #x002027)
    ("LINE SEPARATOR" . #x002028)
    ("PARAGRAPH SEPARATOR" . #x002029)
    ("LEFT-TO-RIGHT EMBEDDING" . #x00202a)
    ("RIGHT-TO-LEFT EMBEDDING" . #x00202b)
    ("POP DIRECTIONAL FORMATTING" . #x00202c)
    ("LEFT-TO-RIGHT OVERRIDE" . #x00202d)
    ("RIGHT-TO-LEFT OVERRIDE" . #x00202e)
    ("NARROW NO-BREAK SPACE" . #x00202f)
    ("PER MILLE SIGN" . #x002030)
    ("PER TEN THOUSAND SIGN" . #x002031)
    ("PRIME" . #x002032)
    ("DOUBLE PRIME" . #x002033)
    ("TRIPLE PRIME" . #x002034)
    ("REVERSED PRIME" . #x002035)
    ("REVERSED DOUBLE PRIME" . #x002036)
    ("REVERSED TRIPLE PRIME" . #x002037)
    ("CARET" . #x002038)
    ("SINGLE LEFT-POINTING ANGLE QUOTATION MARK" . #x002039)
    ("SINGLE RIGHT-POINTING ANGLE QUOTATION MARK" . #x00203a)
    ("REFERENCE MARK" . #x00203b)
    ("DOUBLE EXCLAMATION MARK" . #x00203c)
    ("INTERROBANG" . #x00203d)
    ("OVERLINE" . #x00203e)
    ("UNDERTIE" . #x00203f)
    ("CHARACTER TIE" . #x002040)
    ("CARET INSERTION POINT" . #x002041)
    ("ASTERISM" . #x002042)
    ("HYPHEN BULLET" . #x002043)
    ("FRACTION SLASH" . #x002044)
    ("LEFT SQUARE BRACKET WITH QUILL" . #x002045)
    ("RIGHT SQUARE BRACKET WITH QUILL" . #x002046)
    ("DOUBLE QUESTION MARK" . #x002047)
    ("QUESTION EXCLAMATION MARK" . #x002048)
    ("EXCLAMATION QUESTION MARK" . #x002049)
    ("TIRONIAN SIGN ET" . #x00204a)
    ("REVERSED PILCROW SIGN" . #x00204b)
    ("BLACK LEFTWARDS BULLET" . #x00204c)
    ("BLACK RIGHTWARDS BULLET" . #x00204d)
    ("LOW ASTERISK" . #x00204e)
    ("REVERSED SEMICOLON" . #x00204f)
    ("CLOSE UP" . #x002050)
    ("TWO ASTERISKS ALIGNED VERTICALLY" . #x002051)
    ("COMMERCIAL MINUS SIGN" . #x002052)
    ("QUADRUPLE PRIME" . #x002057)
    ("MEDIUM MATHEMATICAL SPACE" . #x00205f)
    ("WORD JOINER" . #x002060)
    ("FUNCTION APPLICATION" . #x002061)
    ("INVISIBLE TIMES" . #x002062)
    ("INVISIBLE SEPARATOR" . #x002063)
    ("INHIBIT SYMMETRIC SWAPPING" . #x00206a)
    ("ACTIVATE SYMMETRIC SWAPPING" . #x00206b)
    ("INHIBIT ARABIC FORM SHAPING" . #x00206c)
    ("ACTIVATE ARABIC FORM SHAPING" . #x00206d)
    ("NATIONAL DIGIT SHAPES" . #x00206e)
    ("NOMINAL DIGIT SHAPES" . #x00206f)
    ("SUPERSCRIPT ZERO" . #x002070)
    ("SUPERSCRIPT LATIN SMALL LETTER I" . #x002071)
    ("SUPERSCRIPT FOUR" . #x002074)
    ("SUPERSCRIPT FIVE" . #x002075)
    ("SUPERSCRIPT SIX" . #x002076)
    ("SUPERSCRIPT SEVEN" . #x002077)
    ("SUPERSCRIPT EIGHT" . #x002078)
    ("SUPERSCRIPT NINE" . #x002079)
    ("SUPERSCRIPT PLUS SIGN" . #x00207a)
    ("SUPERSCRIPT MINUS" . #x00207b)
    ("SUPERSCRIPT EQUALS SIGN" . #x00207c)
    ("SUPERSCRIPT LEFT PARENTHESIS" . #x00207d)
    ("SUPERSCRIPT RIGHT PARENTHESIS" . #x00207e)
    ("SUPERSCRIPT LATIN SMALL LETTER N" . #x00207f)
    ("SUBSCRIPT ZERO" . #x002080)
    ("SUBSCRIPT ONE" . #x002081)
    ("SUBSCRIPT TWO" . #x002082)
    ("SUBSCRIPT THREE" . #x002083)
    ("SUBSCRIPT FOUR" . #x002084)
    ("SUBSCRIPT FIVE" . #x002085)
    ("SUBSCRIPT SIX" . #x002086)
    ("SUBSCRIPT SEVEN" . #x002087)
    ("SUBSCRIPT EIGHT" . #x002088)
    ("SUBSCRIPT NINE" . #x002089)
    ("SUBSCRIPT PLUS SIGN" . #x00208a)
    ("SUBSCRIPT MINUS" . #x00208b)
    ("SUBSCRIPT EQUALS SIGN" . #x00208c)
    ("SUBSCRIPT LEFT PARENTHESIS" . #x00208d)
    ("SUBSCRIPT RIGHT PARENTHESIS" . #x00208e)
    ("EURO-CURRENCY SIGN" . #x0020a0)
    ("COLON SIGN" . #x0020a1)
    ("CRUZEIRO SIGN" . #x0020a2)
    ("FRENCH FRANC SIGN" . #x0020a3)
    ("LIRA SIGN" . #x0020a4)
    ("MILL SIGN" . #x0020a5)
    ("NAIRA SIGN" . #x0020a6)
    ("PESETA SIGN" . #x0020a7)
    ("RUPEE SIGN" . #x0020a8)
    ("WON SIGN" . #x0020a9)
    ("NEW SHEQEL SIGN" . #x0020aa)
    ("DONG SIGN" . #x0020ab)
    ("EURO SIGN" . #x0020ac)
    ("KIP SIGN" . #x0020ad)
    ("TUGRIK SIGN" . #x0020ae)
    ("DRACHMA SIGN" . #x0020af)
    ("GERMAN PENNY SIGN" . #x0020b0)
    ("PESO SIGN" . #x0020b1)
    ("COMBINING LEFT HARPOON ABOVE" . #x0020d0)
    ("COMBINING RIGHT HARPOON ABOVE" . #x0020d1)
    ("COMBINING LONG VERTICAL LINE OVERLAY" . #x0020d2)
    ("COMBINING SHORT VERTICAL LINE OVERLAY" . #x0020d3)
    ("COMBINING ANTICLOCKWISE ARROW ABOVE" . #x0020d4)
    ("COMBINING CLOCKWISE ARROW ABOVE" . #x0020d5)
    ("COMBINING LEFT ARROW ABOVE" . #x0020d6)
    ("COMBINING RIGHT ARROW ABOVE" . #x0020d7)
    ("COMBINING RING OVERLAY" . #x0020d8)
    ("COMBINING CLOCKWISE RING OVERLAY" . #x0020d9)
    ("COMBINING ANTICLOCKWISE RING OVERLAY" . #x0020da)
    ("COMBINING THREE DOTS ABOVE" . #x0020db)
    ("COMBINING FOUR DOTS ABOVE" . #x0020dc)
    ("COMBINING ENCLOSING CIRCLE" . #x0020dd)
    ("COMBINING ENCLOSING SQUARE" . #x0020de)
    ("COMBINING ENCLOSING DIAMOND" . #x0020df)
    ("COMBINING ENCLOSING CIRCLE BACKSLASH" . #x0020e0)
    ("COMBINING LEFT RIGHT ARROW ABOVE" . #x0020e1)
    ("COMBINING ENCLOSING SCREEN" . #x0020e2)
    ("COMBINING ENCLOSING KEYCAP" . #x0020e3)
    ("COMBINING ENCLOSING UPWARD POINTING TRIANGLE" . #x0020e4)
    ("COMBINING REVERSE SOLIDUS OVERLAY" . #x0020e5)
    ("COMBINING DOUBLE VERTICAL STROKE OVERLAY" . #x0020e6)
    ("COMBINING ANNUITY SYMBOL" . #x0020e7)
    ("COMBINING TRIPLE UNDERDOT" . #x0020e8)
    ("COMBINING WIDE BRIDGE ABOVE" . #x0020e9)
    ("COMBINING LEFTWARDS ARROW OVERLAY" . #x0020ea)
    ("ACCOUNT OF" . #x002100)
    ("ADDRESSED TO THE SUBJECT" . #x002101)
    ("DOUBLE-STRUCK CAPITAL C" . #x002102)
    ("DEGREE CELSIUS" . #x002103)
    ("CENTRE LINE SYMBOL" . #x002104)
    ("CARE OF" . #x002105)
    ("CADA UNA" . #x002106)
    ("EULER CONSTANT" . #x002107)
    ("SCRUPLE" . #x002108)
    ("DEGREE FAHRENHEIT" . #x002109)
    ("SCRIPT SMALL G" . #x00210a)
    ("SCRIPT CAPITAL H" . #x00210b)
    ("BLACK-LETTER CAPITAL H" . #x00210c)
    ("DOUBLE-STRUCK CAPITAL H" . #x00210d)
    ("PLANCK CONSTANT" . #x00210e)
    ("PLANCK CONSTANT OVER TWO PI" . #x00210f)
    ("SCRIPT CAPITAL I" . #x002110)
    ("BLACK-LETTER CAPITAL I" . #x002111)
    ("SCRIPT CAPITAL L" . #x002112)
    ("SCRIPT SMALL L" . #x002113)
    ("L B BAR SYMBOL" . #x002114)
    ("DOUBLE-STRUCK CAPITAL N" . #x002115)
    ("NUMERO SIGN" . #x002116)
    ("SOUND RECORDING COPYRIGHT" . #x002117)
    ("SCRIPT CAPITAL P" . #x002118)
    ("DOUBLE-STRUCK CAPITAL P" . #x002119)
    ("DOUBLE-STRUCK CAPITAL Q" . #x00211a)
    ("SCRIPT CAPITAL R" . #x00211b)
    ("BLACK-LETTER CAPITAL R" . #x00211c)
    ("DOUBLE-STRUCK CAPITAL R" . #x00211d)
    ("PRESCRIPTION TAKE" . #x00211e)
    ("RESPONSE" . #x00211f)
    ("SERVICE MARK" . #x002120)
    ("TELEPHONE SIGN" . #x002121)
    ("TRADE MARK SIGN" . #x002122)
    ("VERSICLE" . #x002123)
    ("DOUBLE-STRUCK CAPITAL Z" . #x002124)
    ("OUNCE SIGN" . #x002125)
    ("OHM SIGN" . #x002126)
    ("INVERTED OHM SIGN" . #x002127)
    ("BLACK-LETTER CAPITAL Z" . #x002128)
    ("TURNED GREEK SMALL LETTER IOTA" . #x002129)
    ("KELVIN SIGN" . #x00212a)
    ("ANGSTROM SIGN" . #x00212b)
    ("SCRIPT CAPITAL B" . #x00212c)
    ("BLACK-LETTER CAPITAL C" . #x00212d)
    ("ESTIMATED SYMBOL" . #x00212e)
    ("SCRIPT SMALL E" . #x00212f)
    ("SCRIPT CAPITAL E" . #x002130)
    ("SCRIPT CAPITAL F" . #x002131)
    ("TURNED CAPITAL F" . #x002132)
    ("SCRIPT CAPITAL M" . #x002133)
    ("SCRIPT SMALL O" . #x002134)
    ("ALEF SYMBOL" . #x002135)
    ("BET SYMBOL" . #x002136)
    ("GIMEL SYMBOL" . #x002137)
    ("DALET SYMBOL" . #x002138)
    ("INFORMATION SOURCE" . #x002139)
    ("ROTATED CAPITAL Q" . #x00213a)
    ("DOUBLE-STRUCK SMALL GAMMA" . #x00213d)
    ("DOUBLE-STRUCK CAPITAL GAMMA" . #x00213e)
    ("DOUBLE-STRUCK CAPITAL PI" . #x00213f)
    ("DOUBLE-STRUCK N-ARY SUMMATION" . #x002140)
    ("TURNED SANS-SERIF CAPITAL G" . #x002141)
    ("TURNED SANS-SERIF CAPITAL L" . #x002142)
    ("REVERSED SANS-SERIF CAPITAL L" . #x002143)
    ("TURNED SANS-SERIF CAPITAL Y" . #x002144)
    ("DOUBLE-STRUCK ITALIC CAPITAL D" . #x002145)
    ("DOUBLE-STRUCK ITALIC SMALL D" . #x002146)
    ("DOUBLE-STRUCK ITALIC SMALL E" . #x002147)
    ("DOUBLE-STRUCK ITALIC SMALL I" . #x002148)
    ("DOUBLE-STRUCK ITALIC SMALL J" . #x002149)
    ("PROPERTY LINE" . #x00214a)
    ("TURNED AMPERSAND" . #x00214b)
    ("VULGAR FRACTION ONE THIRD" . #x002153)
    ("VULGAR FRACTION TWO THIRDS" . #x002154)
    ("VULGAR FRACTION ONE FIFTH" . #x002155)
    ("VULGAR FRACTION TWO FIFTHS" . #x002156)
    ("VULGAR FRACTION THREE FIFTHS" . #x002157)
    ("VULGAR FRACTION FOUR FIFTHS" . #x002158)
    ("VULGAR FRACTION ONE SIXTH" . #x002159)
    ("VULGAR FRACTION FIVE SIXTHS" . #x00215a)
    ("VULGAR FRACTION ONE EIGHTH" . #x00215b)
    ("VULGAR FRACTION THREE EIGHTHS" . #x00215c)
    ("VULGAR FRACTION FIVE EIGHTHS" . #x00215d)
    ("VULGAR FRACTION SEVEN EIGHTHS" . #x00215e)
    ("FRACTION NUMERATOR ONE" . #x00215f)
    ("ROMAN NUMERAL ONE" . #x002160)
    ("ROMAN NUMERAL TWO" . #x002161)
    ("ROMAN NUMERAL THREE" . #x002162)
    ("ROMAN NUMERAL FOUR" . #x002163)
    ("ROMAN NUMERAL FIVE" . #x002164)
    ("ROMAN NUMERAL SIX" . #x002165)
    ("ROMAN NUMERAL SEVEN" . #x002166)
    ("ROMAN NUMERAL EIGHT" . #x002167)
    ("ROMAN NUMERAL NINE" . #x002168)
    ("ROMAN NUMERAL TEN" . #x002169)
    ("ROMAN NUMERAL ELEVEN" . #x00216a)
    ("ROMAN NUMERAL TWELVE" . #x00216b)
    ("ROMAN NUMERAL FIFTY" . #x00216c)
    ("ROMAN NUMERAL ONE HUNDRED" . #x00216d)
    ("ROMAN NUMERAL FIVE HUNDRED" . #x00216e)
    ("ROMAN NUMERAL ONE THOUSAND" . #x00216f)
    ("SMALL ROMAN NUMERAL ONE" . #x002170)
    ("SMALL ROMAN NUMERAL TWO" . #x002171)
    ("SMALL ROMAN NUMERAL THREE" . #x002172)
    ("SMALL ROMAN NUMERAL FOUR" . #x002173)
    ("SMALL ROMAN NUMERAL FIVE" . #x002174)
    ("SMALL ROMAN NUMERAL SIX" . #x002175)
    ("SMALL ROMAN NUMERAL SEVEN" . #x002176)
    ("SMALL ROMAN NUMERAL EIGHT" . #x002177)
    ("SMALL ROMAN NUMERAL NINE" . #x002178)
    ("SMALL ROMAN NUMERAL TEN" . #x002179)
    ("SMALL ROMAN NUMERAL ELEVEN" . #x00217a)
    ("SMALL ROMAN NUMERAL TWELVE" . #x00217b)
    ("SMALL ROMAN NUMERAL FIFTY" . #x00217c)
    ("SMALL ROMAN NUMERAL ONE HUNDRED" . #x00217d)
    ("SMALL ROMAN NUMERAL FIVE HUNDRED" . #x00217e)
    ("SMALL ROMAN NUMERAL ONE THOUSAND" . #x00217f)
    ("ROMAN NUMERAL ONE THOUSAND C D" . #x002180)
    ("ROMAN NUMERAL FIVE THOUSAND" . #x002181)
    ("ROMAN NUMERAL TEN THOUSAND" . #x002182)
    ("ROMAN NUMERAL REVERSED ONE HUNDRED" . #x002183)
    ("LEFTWARDS ARROW" . #x002190)
    ("UPWARDS ARROW" . #x002191)
    ("RIGHTWARDS ARROW" . #x002192)
    ("DOWNWARDS ARROW" . #x002193)
    ("LEFT RIGHT ARROW" . #x002194)
    ("UP DOWN ARROW" . #x002195)
    ("NORTH WEST ARROW" . #x002196)
    ("NORTH EAST ARROW" . #x002197)
    ("SOUTH EAST ARROW" . #x002198)
    ("SOUTH WEST ARROW" . #x002199)
    ("LEFTWARDS ARROW WITH STROKE" . #x00219a)
    ("RIGHTWARDS ARROW WITH STROKE" . #x00219b)
    ("LEFTWARDS WAVE ARROW" . #x00219c)
    ("RIGHTWARDS WAVE ARROW" . #x00219d)
    ("LEFTWARDS TWO HEADED ARROW" . #x00219e)
    ("UPWARDS TWO HEADED ARROW" . #x00219f)
    ("RIGHTWARDS TWO HEADED ARROW" . #x0021a0)
    ("DOWNWARDS TWO HEADED ARROW" . #x0021a1)
    ("LEFTWARDS ARROW WITH TAIL" . #x0021a2)
    ("RIGHTWARDS ARROW WITH TAIL" . #x0021a3)
    ("LEFTWARDS ARROW FROM BAR" . #x0021a4)
    ("UPWARDS ARROW FROM BAR" . #x0021a5)
    ("RIGHTWARDS ARROW FROM BAR" . #x0021a6)
    ("DOWNWARDS ARROW FROM BAR" . #x0021a7)
    ("UP DOWN ARROW WITH BASE" . #x0021a8)
    ("LEFTWARDS ARROW WITH HOOK" . #x0021a9)
    ("RIGHTWARDS ARROW WITH HOOK" . #x0021aa)
    ("LEFTWARDS ARROW WITH LOOP" . #x0021ab)
    ("RIGHTWARDS ARROW WITH LOOP" . #x0021ac)
    ("LEFT RIGHT WAVE ARROW" . #x0021ad)
    ("LEFT RIGHT ARROW WITH STROKE" . #x0021ae)
    ("DOWNWARDS ZIGZAG ARROW" . #x0021af)
    ("UPWARDS ARROW WITH TIP LEFTWARDS" . #x0021b0)
    ("UPWARDS ARROW WITH TIP RIGHTWARDS" . #x0021b1)
    ("DOWNWARDS ARROW WITH TIP LEFTWARDS" . #x0021b2)
    ("DOWNWARDS ARROW WITH TIP RIGHTWARDS" . #x0021b3)
    ("RIGHTWARDS ARROW WITH CORNER DOWNWARDS" . #x0021b4)
    ("DOWNWARDS ARROW WITH CORNER LEFTWARDS" . #x0021b5)
    ("ANTICLOCKWISE TOP SEMICIRCLE ARROW" . #x0021b6)
    ("CLOCKWISE TOP SEMICIRCLE ARROW" . #x0021b7)
    ("NORTH WEST ARROW TO LONG BAR" . #x0021b8)
    ("LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR" . #x0021b9)
    ("ANTICLOCKWISE OPEN CIRCLE ARROW" . #x0021ba)
    ("CLOCKWISE OPEN CIRCLE ARROW" . #x0021bb)
    ("LEFTWARDS HARPOON WITH BARB UPWARDS" . #x0021bc)
    ("LEFTWARDS HARPOON WITH BARB DOWNWARDS" . #x0021bd)
    ("UPWARDS HARPOON WITH BARB RIGHTWARDS" . #x0021be)
    ("UPWARDS HARPOON WITH BARB LEFTWARDS" . #x0021bf)
    ("RIGHTWARDS HARPOON WITH BARB UPWARDS" . #x0021c0)
    ("RIGHTWARDS HARPOON WITH BARB DOWNWARDS" . #x0021c1)
    ("DOWNWARDS HARPOON WITH BARB RIGHTWARDS" . #x0021c2)
    ("DOWNWARDS HARPOON WITH BARB LEFTWARDS" . #x0021c3)
    ("RIGHTWARDS ARROW OVER LEFTWARDS ARROW" . #x0021c4)
    ("UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW" . #x0021c5)
    ("LEFTWARDS ARROW OVER RIGHTWARDS ARROW" . #x0021c6)
    ("LEFTWARDS PAIRED ARROWS" . #x0021c7)
    ("UPWARDS PAIRED ARROWS" . #x0021c8)
    ("RIGHTWARDS PAIRED ARROWS" . #x0021c9)
    ("DOWNWARDS PAIRED ARROWS" . #x0021ca)
    ("LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON" . #x0021cb)
    ("RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON" . #x0021cc)
    ("LEFTWARDS DOUBLE ARROW WITH STROKE" . #x0021cd)
    ("LEFT RIGHT DOUBLE ARROW WITH STROKE" . #x0021ce)
    ("RIGHTWARDS DOUBLE ARROW WITH STROKE" . #x0021cf)
    ("LEFTWARDS DOUBLE ARROW" . #x0021d0)
    ("UPWARDS DOUBLE ARROW" . #x0021d1)
    ("RIGHTWARDS DOUBLE ARROW" . #x0021d2)
    ("DOWNWARDS DOUBLE ARROW" . #x0021d3)
    ("LEFT RIGHT DOUBLE ARROW" . #x0021d4)
    ("UP DOWN DOUBLE ARROW" . #x0021d5)
    ("NORTH WEST DOUBLE ARROW" . #x0021d6)
    ("NORTH EAST DOUBLE ARROW" . #x0021d7)
    ("SOUTH EAST DOUBLE ARROW" . #x0021d8)
    ("SOUTH WEST DOUBLE ARROW" . #x0021d9)
    ("LEFTWARDS TRIPLE ARROW" . #x0021da)
    ("RIGHTWARDS TRIPLE ARROW" . #x0021db)
    ("LEFTWARDS SQUIGGLE ARROW" . #x0021dc)
    ("RIGHTWARDS SQUIGGLE ARROW" . #x0021dd)
    ("UPWARDS ARROW WITH DOUBLE STROKE" . #x0021de)
    ("DOWNWARDS ARROW WITH DOUBLE STROKE" . #x0021df)
    ("LEFTWARDS DASHED ARROW" . #x0021e0)
    ("UPWARDS DASHED ARROW" . #x0021e1)
    ("RIGHTWARDS DASHED ARROW" . #x0021e2)
    ("DOWNWARDS DASHED ARROW" . #x0021e3)
    ("LEFTWARDS ARROW TO BAR" . #x0021e4)
    ("RIGHTWARDS ARROW TO BAR" . #x0021e5)
    ("LEFTWARDS WHITE ARROW" . #x0021e6)
    ("UPWARDS WHITE ARROW" . #x0021e7)
    ("RIGHTWARDS WHITE ARROW" . #x0021e8)
    ("DOWNWARDS WHITE ARROW" . #x0021e9)
    ("UPWARDS WHITE ARROW FROM BAR" . #x0021ea)
    ("UPWARDS WHITE ARROW ON PEDESTAL" . #x0021eb)
    ("UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR" . #x0021ec)
    ("UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR" . #x0021ed)
    ("UPWARDS WHITE DOUBLE ARROW" . #x0021ee)
    ("UPWARDS WHITE DOUBLE ARROW ON PEDESTAL" . #x0021ef)
    ("RIGHTWARDS WHITE ARROW FROM WALL" . #x0021f0)
    ("NORTH WEST ARROW TO CORNER" . #x0021f1)
    ("SOUTH EAST ARROW TO CORNER" . #x0021f2)
    ("UP DOWN WHITE ARROW" . #x0021f3)
    ("RIGHT ARROW WITH SMALL CIRCLE" . #x0021f4)
    ("DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW" . #x0021f5)
    ("THREE RIGHTWARDS ARROWS" . #x0021f6)
    ("LEFTWARDS ARROW WITH VERTICAL STROKE" . #x0021f7)
    ("RIGHTWARDS ARROW WITH VERTICAL STROKE" . #x0021f8)
    ("LEFT RIGHT ARROW WITH VERTICAL STROKE" . #x0021f9)
    ("LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE" . #x0021fa)
    ("RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE" . #x0021fb)
    ("LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE" . #x0021fc)
    ("LEFTWARDS OPEN-HEADED ARROW" . #x0021fd)
    ("RIGHTWARDS OPEN-HEADED ARROW" . #x0021fe)
    ("LEFT RIGHT OPEN-HEADED ARROW" . #x0021ff)
    ("FOR ALL" . #x002200)
    ("COMPLEMENT" . #x002201)
    ("PARTIAL DIFFERENTIAL" . #x002202)
    ("THERE EXISTS" . #x002203)
    ("THERE DOES NOT EXIST" . #x002204)
    ("EMPTY SET" . #x002205)
    ("INCREMENT" . #x002206)
    ("NABLA" . #x002207)
    ("ELEMENT OF" . #x002208)
    ("NOT AN ELEMENT OF" . #x002209)
    ("SMALL ELEMENT OF" . #x00220a)
    ("CONTAINS AS MEMBER" . #x00220b)
    ("DOES NOT CONTAIN AS MEMBER" . #x00220c)
    ("SMALL CONTAINS AS MEMBER" . #x00220d)
    ("END OF PROOF" . #x00220e)
    ("N-ARY PRODUCT" . #x00220f)
    ("N-ARY COPRODUCT" . #x002210)
    ("N-ARY SUMMATION" . #x002211)
    ("MINUS SIGN" . #x002212)
    ("MINUS-OR-PLUS SIGN" . #x002213)
    ("DOT PLUS" . #x002214)
    ("DIVISION SLASH" . #x002215)
    ("SET MINUS" . #x002216)
    ("ASTERISK OPERATOR" . #x002217)
    ("RING OPERATOR" . #x002218)
    ("BULLET OPERATOR" . #x002219)
    ("SQUARE ROOT" . #x00221a)
    ("CUBE ROOT" . #x00221b)
    ("FOURTH ROOT" . #x00221c)
    ("PROPORTIONAL TO" . #x00221d)
    ("INFINITY" . #x00221e)
    ("RIGHT ANGLE" . #x00221f)
    ("ANGLE" . #x002220)
    ("MEASURED ANGLE" . #x002221)
    ("SPHERICAL ANGLE" . #x002222)
    ("DIVIDES" . #x002223)
    ("DOES NOT DIVIDE" . #x002224)
    ("PARALLEL TO" . #x002225)
    ("NOT PARALLEL TO" . #x002226)
    ("LOGICAL AND" . #x002227)
    ("LOGICAL OR" . #x002228)
    ("INTERSECTION" . #x002229)
    ("UNION" . #x00222a)
    ("INTEGRAL" . #x00222b)
    ("DOUBLE INTEGRAL" . #x00222c)
    ("TRIPLE INTEGRAL" . #x00222d)
    ("CONTOUR INTEGRAL" . #x00222e)
    ("SURFACE INTEGRAL" . #x00222f)
    ("VOLUME INTEGRAL" . #x002230)
    ("CLOCKWISE INTEGRAL" . #x002231)
    ("CLOCKWISE CONTOUR INTEGRAL" . #x002232)
    ("ANTICLOCKWISE CONTOUR INTEGRAL" . #x002233)
    ("THEREFORE" . #x002234)
    ("BECAUSE" . #x002235)
    ("RATIO" . #x002236)
    ("PROPORTION" . #x002237)
    ("DOT MINUS" . #x002238)
    ("EXCESS" . #x002239)
    ("GEOMETRIC PROPORTION" . #x00223a)
    ("HOMOTHETIC" . #x00223b)
    ("TILDE OPERATOR" . #x00223c)
    ("REVERSED TILDE" . #x00223d)
    ("INVERTED LAZY S" . #x00223e)
    ("SINE WAVE" . #x00223f)
    ("WREATH PRODUCT" . #x002240)
    ("NOT TILDE" . #x002241)
    ("MINUS TILDE" . #x002242)
    ("ASYMPTOTICALLY EQUAL TO" . #x002243)
    ("NOT ASYMPTOTICALLY EQUAL TO" . #x002244)
    ("APPROXIMATELY EQUAL TO" . #x002245)
    ("APPROXIMATELY BUT NOT ACTUALLY EQUAL TO" . #x002246)
    ("NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO" . #x002247)
    ("ALMOST EQUAL TO" . #x002248)
    ("NOT ALMOST EQUAL TO" . #x002249)
    ("ALMOST EQUAL OR EQUAL TO" . #x00224a)
    ("TRIPLE TILDE" . #x00224b)
    ("ALL EQUAL TO" . #x00224c)
    ("EQUIVALENT TO" . #x00224d)
    ("GEOMETRICALLY EQUIVALENT TO" . #x00224e)
    ("DIFFERENCE BETWEEN" . #x00224f)
    ("APPROACHES THE LIMIT" . #x002250)
    ("GEOMETRICALLY EQUAL TO" . #x002251)
    ("APPROXIMATELY EQUAL TO OR THE IMAGE OF" . #x002252)
    ("IMAGE OF OR APPROXIMATELY EQUAL TO" . #x002253)
    ("COLON EQUALS" . #x002254)
    ("EQUALS COLON" . #x002255)
    ("RING IN EQUAL TO" . #x002256)
    ("RING EQUAL TO" . #x002257)
    ("CORRESPONDS TO" . #x002258)
    ("ESTIMATES" . #x002259)
    ("EQUIANGULAR TO" . #x00225a)
    ("STAR EQUALS" . #x00225b)
    ("DELTA EQUAL TO" . #x00225c)
    ("EQUAL TO BY DEFINITION" . #x00225d)
    ("MEASURED BY" . #x00225e)
    ("QUESTIONED EQUAL TO" . #x00225f)
    ("NOT EQUAL TO" . #x002260)
    ("IDENTICAL TO" . #x002261)
    ("NOT IDENTICAL TO" . #x002262)
    ("STRICTLY EQUIVALENT TO" . #x002263)
    ("LESS-THAN OR EQUAL TO" . #x002264)
    ("GREATER-THAN OR EQUAL TO" . #x002265)
    ("LESS-THAN OVER EQUAL TO" . #x002266)
    ("GREATER-THAN OVER EQUAL TO" . #x002267)
    ("LESS-THAN BUT NOT EQUAL TO" . #x002268)
    ("GREATER-THAN BUT NOT EQUAL TO" . #x002269)
    ("MUCH LESS-THAN" . #x00226a)
    ("MUCH GREATER-THAN" . #x00226b)
    ("BETWEEN" . #x00226c)
    ("NOT EQUIVALENT TO" . #x00226d)
    ("NOT LESS-THAN" . #x00226e)
    ("NOT GREATER-THAN" . #x00226f)
    ("NEITHER LESS-THAN NOR EQUAL TO" . #x002270)
    ("NEITHER GREATER-THAN NOR EQUAL TO" . #x002271)
    ("LESS-THAN OR EQUIVALENT TO" . #x002272)
    ("GREATER-THAN OR EQUIVALENT TO" . #x002273)
    ("NEITHER LESS-THAN NOR EQUIVALENT TO" . #x002274)
    ("NEITHER GREATER-THAN NOR EQUIVALENT TO" . #x002275)
    ("LESS-THAN OR GREATER-THAN" . #x002276)
    ("GREATER-THAN OR LESS-THAN" . #x002277)
    ("NEITHER LESS-THAN NOR GREATER-THAN" . #x002278)
    ("NEITHER GREATER-THAN NOR LESS-THAN" . #x002279)
    ("PRECEDES" . #x00227a)
    ("SUCCEEDS" . #x00227b)
    ("PRECEDES OR EQUAL TO" . #x00227c)
    ("SUCCEEDS OR EQUAL TO" . #x00227d)
    ("PRECEDES OR EQUIVALENT TO" . #x00227e)
    ("SUCCEEDS OR EQUIVALENT TO" . #x00227f)
    ("DOES NOT PRECEDE" . #x002280)
    ("DOES NOT SUCCEED" . #x002281)
    ("SUBSET OF" . #x002282)
    ("SUPERSET OF" . #x002283)
    ("NOT A SUBSET OF" . #x002284)
    ("NOT A SUPERSET OF" . #x002285)
    ("SUBSET OF OR EQUAL TO" . #x002286)
    ("SUPERSET OF OR EQUAL TO" . #x002287)
    ("NEITHER A SUBSET OF NOR EQUAL TO" . #x002288)
    ("NEITHER A SUPERSET OF NOR EQUAL TO" . #x002289)
    ("SUBSET OF WITH NOT EQUAL TO" . #x00228a)
    ("SUPERSET OF WITH NOT EQUAL TO" . #x00228b)
    ("MULTISET" . #x00228c)
    ("MULTISET MULTIPLICATION" . #x00228d)
    ("MULTISET UNION" . #x00228e)
    ("SQUARE IMAGE OF" . #x00228f)
    ("SQUARE ORIGINAL OF" . #x002290)
    ("SQUARE IMAGE OF OR EQUAL TO" . #x002291)
    ("SQUARE ORIGINAL OF OR EQUAL TO" . #x002292)
    ("SQUARE CAP" . #x002293)
    ("SQUARE CUP" . #x002294)
    ("CIRCLED PLUS" . #x002295)
    ("CIRCLED MINUS" . #x002296)
    ("CIRCLED TIMES" . #x002297)
    ("CIRCLED DIVISION SLASH" . #x002298)
    ("CIRCLED DOT OPERATOR" . #x002299)
    ("CIRCLED RING OPERATOR" . #x00229a)
    ("CIRCLED ASTERISK OPERATOR" . #x00229b)
    ("CIRCLED EQUALS" . #x00229c)
    ("CIRCLED DASH" . #x00229d)
    ("SQUARED PLUS" . #x00229e)
    ("SQUARED MINUS" . #x00229f)
    ("SQUARED TIMES" . #x0022a0)
    ("SQUARED DOT OPERATOR" . #x0022a1)
    ("RIGHT TACK" . #x0022a2)
    ("LEFT TACK" . #x0022a3)
    ("DOWN TACK" . #x0022a4)
    ("UP TACK" . #x0022a5)
    ("ASSERTION" . #x0022a6)
    ("MODELS" . #x0022a7)
    ("TRUE" . #x0022a8)
    ("FORCES" . #x0022a9)
    ("TRIPLE VERTICAL BAR RIGHT TURNSTILE" . #x0022aa)
    ("DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" . #x0022ab)
    ("DOES NOT PROVE" . #x0022ac)
    ("NOT TRUE" . #x0022ad)
    ("DOES NOT FORCE" . #x0022ae)
    ("NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" . #x0022af)
    ("PRECEDES UNDER RELATION" . #x0022b0)
    ("SUCCEEDS UNDER RELATION" . #x0022b1)
    ("NORMAL SUBGROUP OF" . #x0022b2)
    ("CONTAINS AS NORMAL SUBGROUP" . #x0022b3)
    ("NORMAL SUBGROUP OF OR EQUAL TO" . #x0022b4)
    ("CONTAINS AS NORMAL SUBGROUP OR EQUAL TO" . #x0022b5)
    ("ORIGINAL OF" . #x0022b6)
    ("IMAGE OF" . #x0022b7)
    ("MULTIMAP" . #x0022b8)
    ("HERMITIAN CONJUGATE MATRIX" . #x0022b9)
    ("INTERCALATE" . #x0022ba)
    ("XOR" . #x0022bb)
    ("NAND" . #x0022bc)
    ("NOR" . #x0022bd)
    ("RIGHT ANGLE WITH ARC" . #x0022be)
    ("RIGHT TRIANGLE" . #x0022bf)
    ("N-ARY LOGICAL AND" . #x0022c0)
    ("N-ARY LOGICAL OR" . #x0022c1)
    ("N-ARY INTERSECTION" . #x0022c2)
    ("N-ARY UNION" . #x0022c3)
    ("DIAMOND OPERATOR" . #x0022c4)
    ("DOT OPERATOR" . #x0022c5)
    ("STAR OPERATOR" . #x0022c6)
    ("DIVISION TIMES" . #x0022c7)
    ("BOWTIE" . #x0022c8)
    ("LEFT NORMAL FACTOR SEMIDIRECT PRODUCT" . #x0022c9)
    ("RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT" . #x0022ca)
    ("LEFT SEMIDIRECT PRODUCT" . #x0022cb)
    ("RIGHT SEMIDIRECT PRODUCT" . #x0022cc)
    ("REVERSED TILDE EQUALS" . #x0022cd)
    ("CURLY LOGICAL OR" . #x0022ce)
    ("CURLY LOGICAL AND" . #x0022cf)
    ("DOUBLE SUBSET" . #x0022d0)
    ("DOUBLE SUPERSET" . #x0022d1)
    ("DOUBLE INTERSECTION" . #x0022d2)
    ("DOUBLE UNION" . #x0022d3)
    ("PITCHFORK" . #x0022d4)
    ("EQUAL AND PARALLEL TO" . #x0022d5)
    ("LESS-THAN WITH DOT" . #x0022d6)
    ("GREATER-THAN WITH DOT" . #x0022d7)
    ("VERY MUCH LESS-THAN" . #x0022d8)
    ("VERY MUCH GREATER-THAN" . #x0022d9)
    ("LESS-THAN EQUAL TO OR GREATER-THAN" . #x0022da)
    ("GREATER-THAN EQUAL TO OR LESS-THAN" . #x0022db)
    ("EQUAL TO OR LESS-THAN" . #x0022dc)
    ("EQUAL TO OR GREATER-THAN" . #x0022dd)
    ("EQUAL TO OR PRECEDES" . #x0022de)
    ("EQUAL TO OR SUCCEEDS" . #x0022df)
    ("DOES NOT PRECEDE OR EQUAL" . #x0022e0)
    ("DOES NOT SUCCEED OR EQUAL" . #x0022e1)
    ("NOT SQUARE IMAGE OF OR EQUAL TO" . #x0022e2)
    ("NOT SQUARE ORIGINAL OF OR EQUAL TO" . #x0022e3)
    ("SQUARE IMAGE OF OR NOT EQUAL TO" . #x0022e4)
    ("SQUARE ORIGINAL OF OR NOT EQUAL TO" . #x0022e5)
    ("LESS-THAN BUT NOT EQUIVALENT TO" . #x0022e6)
    ("GREATER-THAN BUT NOT EQUIVALENT TO" . #x0022e7)
    ("PRECEDES BUT NOT EQUIVALENT TO" . #x0022e8)
    ("SUCCEEDS BUT NOT EQUIVALENT TO" . #x0022e9)
    ("NOT NORMAL SUBGROUP OF" . #x0022ea)
    ("DOES NOT CONTAIN AS NORMAL SUBGROUP" . #x0022eb)
    ("NOT NORMAL SUBGROUP OF OR EQUAL TO" . #x0022ec)
    ("DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL" . #x0022ed)
    ("VERTICAL ELLIPSIS" . #x0022ee)
    ("MIDLINE HORIZONTAL ELLIPSIS" . #x0022ef)
    ("UP RIGHT DIAGONAL ELLIPSIS" . #x0022f0)
    ("DOWN RIGHT DIAGONAL ELLIPSIS" . #x0022f1)
    ("ELEMENT OF WITH LONG HORIZONTAL STROKE" . #x0022f2)
    ("ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . #x0022f3)
    ("SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . #x0022f4)
    ("ELEMENT OF WITH DOT ABOVE" . #x0022f5)
    ("ELEMENT OF WITH OVERBAR" . #x0022f6)
    ("SMALL ELEMENT OF WITH OVERBAR" . #x0022f7)
    ("ELEMENT OF WITH UNDERBAR" . #x0022f8)
    ("ELEMENT OF WITH TWO HORIZONTAL STROKES" . #x0022f9)
    ("CONTAINS WITH LONG HORIZONTAL STROKE" . #x0022fa)
    ("CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . #x0022fb)
    ("SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . #x0022fc)
    ("CONTAINS WITH OVERBAR" . #x0022fd)
    ("SMALL CONTAINS WITH OVERBAR" . #x0022fe)
    ("Z NOTATION BAG MEMBERSHIP" . #x0022ff)
    ("DIAMETER SIGN" . #x002300)
    ("ELECTRIC ARROW" . #x002301)
    ("HOUSE" . #x002302)
    ("UP ARROWHEAD" . #x002303)
    ("DOWN ARROWHEAD" . #x002304)
    ("PROJECTIVE" . #x002305)
    ("PERSPECTIVE" . #x002306)
    ("WAVY LINE" . #x002307)
    ("LEFT CEILING" . #x002308)
    ("RIGHT CEILING" . #x002309)
    ("LEFT FLOOR" . #x00230a)
    ("RIGHT FLOOR" . #x00230b)
    ("BOTTOM RIGHT CROP" . #x00230c)
    ("BOTTOM LEFT CROP" . #x00230d)
    ("TOP RIGHT CROP" . #x00230e)
    ("TOP LEFT CROP" . #x00230f)
    ("REVERSED NOT SIGN" . #x002310)
    ("SQUARE LOZENGE" . #x002311)
    ("ARC" . #x002312)
    ("SEGMENT" . #x002313)
    ("SECTOR" . #x002314)
    ("TELEPHONE RECORDER" . #x002315)
    ("POSITION INDICATOR" . #x002316)
    ("VIEWDATA SQUARE" . #x002317)
    ("PLACE OF INTEREST SIGN" . #x002318)
    ("TURNED NOT SIGN" . #x002319)
    ("WATCH" . #x00231a)
    ("HOURGLASS" . #x00231b)
    ("TOP LEFT CORNER" . #x00231c)
    ("TOP RIGHT CORNER" . #x00231d)
    ("BOTTOM LEFT CORNER" . #x00231e)
    ("BOTTOM RIGHT CORNER" . #x00231f)
    ("TOP HALF INTEGRAL" . #x002320)
    ("BOTTOM HALF INTEGRAL" . #x002321)
    ("FROWN" . #x002322)
    ("SMILE" . #x002323)
    ("UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS" . #x002324)
    ("OPTION KEY" . #x002325)
    ("ERASE TO THE RIGHT" . #x002326)
    ("X IN A RECTANGLE BOX" . #x002327)
    ("KEYBOARD" . #x002328)
    ("LEFT-POINTING ANGLE BRACKET" . #x002329)
    ("RIGHT-POINTING ANGLE BRACKET" . #x00232a)
    ("ERASE TO THE LEFT" . #x00232b)
    ("BENZENE RING" . #x00232c)
    ("CYLINDRICITY" . #x00232d)
    ("ALL AROUND-PROFILE" . #x00232e)
    ("SYMMETRY" . #x00232f)
    ("TOTAL RUNOUT" . #x002330)
    ("DIMENSION ORIGIN" . #x002331)
    ("CONICAL TAPER" . #x002332)
    ("SLOPE" . #x002333)
    ("COUNTERBORE" . #x002334)
    ("COUNTERSINK" . #x002335)
    ("APL FUNCTIONAL SYMBOL I-BEAM" . #x002336)
    ("APL FUNCTIONAL SYMBOL SQUISH QUAD" . #x002337)
    ("APL FUNCTIONAL SYMBOL QUAD EQUAL" . #x002338)
    ("APL FUNCTIONAL SYMBOL QUAD DIVIDE" . #x002339)
    ("APL FUNCTIONAL SYMBOL QUAD DIAMOND" . #x00233a)
    ("APL FUNCTIONAL SYMBOL QUAD JOT" . #x00233b)
    ("APL FUNCTIONAL SYMBOL QUAD CIRCLE" . #x00233c)
    ("APL FUNCTIONAL SYMBOL CIRCLE STILE" . #x00233d)
    ("APL FUNCTIONAL SYMBOL CIRCLE JOT" . #x00233e)
    ("APL FUNCTIONAL SYMBOL SLASH BAR" . #x00233f)
    ("APL FUNCTIONAL SYMBOL BACKSLASH BAR" . #x002340)
    ("APL FUNCTIONAL SYMBOL QUAD SLASH" . #x002341)
    ("APL FUNCTIONAL SYMBOL QUAD BACKSLASH" . #x002342)
    ("APL FUNCTIONAL SYMBOL QUAD LESS-THAN" . #x002343)
    ("APL FUNCTIONAL SYMBOL QUAD GREATER-THAN" . #x002344)
    ("APL FUNCTIONAL SYMBOL LEFTWARDS VANE" . #x002345)
    ("APL FUNCTIONAL SYMBOL RIGHTWARDS VANE" . #x002346)
    ("APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW" . #x002347)
    ("APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW" . #x002348)
    ("APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH" . #x002349)
    ("APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR" . #x00234a)
    ("APL FUNCTIONAL SYMBOL DELTA STILE" . #x00234b)
    ("APL FUNCTIONAL SYMBOL QUAD DOWN CARET" . #x00234c)
    ("APL FUNCTIONAL SYMBOL QUAD DELTA" . #x00234d)
    ("APL FUNCTIONAL SYMBOL DOWN TACK JOT" . #x00234e)
    ("APL FUNCTIONAL SYMBOL UPWARDS VANE" . #x00234f)
    ("APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW" . #x002350)
    ("APL FUNCTIONAL SYMBOL UP TACK OVERBAR" . #x002351)
    ("APL FUNCTIONAL SYMBOL DEL STILE" . #x002352)
    ("APL FUNCTIONAL SYMBOL QUAD UP CARET" . #x002353)
    ("APL FUNCTIONAL SYMBOL QUAD DEL" . #x002354)
    ("APL FUNCTIONAL SYMBOL UP TACK JOT" . #x002355)
    ("APL FUNCTIONAL SYMBOL DOWNWARDS VANE" . #x002356)
    ("APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW" . #x002357)
    ("APL FUNCTIONAL SYMBOL QUOTE UNDERBAR" . #x002358)
    ("APL FUNCTIONAL SYMBOL DELTA UNDERBAR" . #x002359)
    ("APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR" . #x00235a)
    ("APL FUNCTIONAL SYMBOL JOT UNDERBAR" . #x00235b)
    ("APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR" . #x00235c)
    ("APL FUNCTIONAL SYMBOL UP SHOE JOT" . #x00235d)
    ("APL FUNCTIONAL SYMBOL QUOTE QUAD" . #x00235e)
    ("APL FUNCTIONAL SYMBOL CIRCLE STAR" . #x00235f)
    ("APL FUNCTIONAL SYMBOL QUAD COLON" . #x002360)
    ("APL FUNCTIONAL SYMBOL UP TACK DIAERESIS" . #x002361)
    ("APL FUNCTIONAL SYMBOL DEL DIAERESIS" . #x002362)
    ("APL FUNCTIONAL SYMBOL STAR DIAERESIS" . #x002363)
    ("APL FUNCTIONAL SYMBOL JOT DIAERESIS" . #x002364)
    ("APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS" . #x002365)
    ("APL FUNCTIONAL SYMBOL DOWN SHOE STILE" . #x002366)
    ("APL FUNCTIONAL SYMBOL LEFT SHOE STILE" . #x002367)
    ("APL FUNCTIONAL SYMBOL TILDE DIAERESIS" . #x002368)
    ("APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS" . #x002369)
    ("APL FUNCTIONAL SYMBOL COMMA BAR" . #x00236a)
    ("APL FUNCTIONAL SYMBOL DEL TILDE" . #x00236b)
    ("APL FUNCTIONAL SYMBOL ZILDE" . #x00236c)
    ("APL FUNCTIONAL SYMBOL STILE TILDE" . #x00236d)
    ("APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR" . #x00236e)
    ("APL FUNCTIONAL SYMBOL QUAD NOT EQUAL" . #x00236f)
    ("APL FUNCTIONAL SYMBOL QUAD QUESTION" . #x002370)
    ("APL FUNCTIONAL SYMBOL DOWN CARET TILDE" . #x002371)
    ("APL FUNCTIONAL SYMBOL UP CARET TILDE" . #x002372)
    ("APL FUNCTIONAL SYMBOL IOTA" . #x002373)
    ("APL FUNCTIONAL SYMBOL RHO" . #x002374)
    ("APL FUNCTIONAL SYMBOL OMEGA" . #x002375)
    ("APL FUNCTIONAL SYMBOL ALPHA UNDERBAR" . #x002376)
    ("APL FUNCTIONAL SYMBOL EPSILON UNDERBAR" . #x002377)
    ("APL FUNCTIONAL SYMBOL IOTA UNDERBAR" . #x002378)
    ("APL FUNCTIONAL SYMBOL OMEGA UNDERBAR" . #x002379)
    ("APL FUNCTIONAL SYMBOL ALPHA" . #x00237a)
    ("NOT CHECK MARK" . #x00237b)
    ("RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW" . #x00237c)
    ("SHOULDERED OPEN BOX" . #x00237d)
    ("BELL SYMBOL" . #x00237e)
    ("VERTICAL LINE WITH MIDDLE DOT" . #x00237f)
    ("INSERTION SYMBOL" . #x002380)
    ("CONTINUOUS UNDERLINE SYMBOL" . #x002381)
    ("DISCONTINUOUS UNDERLINE SYMBOL" . #x002382)
    ("EMPHASIS SYMBOL" . #x002383)
    ("COMPOSITION SYMBOL" . #x002384)
    ("WHITE SQUARE WITH CENTRE VERTICAL LINE" . #x002385)
    ("ENTER SYMBOL" . #x002386)
    ("ALTERNATIVE KEY SYMBOL" . #x002387)
    ("HELM SYMBOL" . #x002388)
    ("CIRCLED HORIZONTAL BAR WITH NOTCH" . #x002389)
    ("CIRCLED TRIANGLE DOWN" . #x00238a)
    ("BROKEN CIRCLE WITH NORTHWEST ARROW" . #x00238b)
    ("UNDO SYMBOL" . #x00238c)
    ("MONOSTABLE SYMBOL" . #x00238d)
    ("HYSTERESIS SYMBOL" . #x00238e)
    ("OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL" . #x00238f)
    ("OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL" . #x002390)
    ("PASSIVE-PULL-DOWN-OUTPUT SYMBOL" . #x002391)
    ("PASSIVE-PULL-UP-OUTPUT SYMBOL" . #x002392)
    ("DIRECT CURRENT SYMBOL FORM TWO" . #x002393)
    ("SOFTWARE-FUNCTION SYMBOL" . #x002394)
    ("APL FUNCTIONAL SYMBOL QUAD" . #x002395)
    ("DECIMAL SEPARATOR KEY SYMBOL" . #x002396)
    ("PREVIOUS PAGE" . #x002397)
    ("NEXT PAGE" . #x002398)
    ("PRINT SCREEN SYMBOL" . #x002399)
    ("CLEAR SCREEN SYMBOL" . #x00239a)
    ("LEFT PARENTHESIS UPPER HOOK" . #x00239b)
    ("LEFT PARENTHESIS EXTENSION" . #x00239c)
    ("LEFT PARENTHESIS LOWER HOOK" . #x00239d)
    ("RIGHT PARENTHESIS UPPER HOOK" . #x00239e)
    ("RIGHT PARENTHESIS EXTENSION" . #x00239f)
    ("RIGHT PARENTHESIS LOWER HOOK" . #x0023a0)
    ("LEFT SQUARE BRACKET UPPER CORNER" . #x0023a1)
    ("LEFT SQUARE BRACKET EXTENSION" . #x0023a2)
    ("LEFT SQUARE BRACKET LOWER CORNER" . #x0023a3)
    ("RIGHT SQUARE BRACKET UPPER CORNER" . #x0023a4)
    ("RIGHT SQUARE BRACKET EXTENSION" . #x0023a5)
    ("RIGHT SQUARE BRACKET LOWER CORNER" . #x0023a6)
    ("LEFT CURLY BRACKET UPPER HOOK" . #x0023a7)
    ("LEFT CURLY BRACKET MIDDLE PIECE" . #x0023a8)
    ("LEFT CURLY BRACKET LOWER HOOK" . #x0023a9)
    ("CURLY BRACKET EXTENSION" . #x0023aa)
    ("RIGHT CURLY BRACKET UPPER HOOK" . #x0023ab)
    ("RIGHT CURLY BRACKET MIDDLE PIECE" . #x0023ac)
    ("RIGHT CURLY BRACKET LOWER HOOK" . #x0023ad)
    ("INTEGRAL EXTENSION" . #x0023ae)
    ("HORIZONTAL LINE EXTENSION" . #x0023af)
    ("UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION" . #x0023b0)
    ("UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION" . #x0023b1)
    ("SUMMATION TOP" . #x0023b2)
    ("SUMMATION BOTTOM" . #x0023b3)
    ("TOP SQUARE BRACKET" . #x0023b4)
    ("BOTTOM SQUARE BRACKET" . #x0023b5)
    ("BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET" . #x0023b6)
    ("RADICAL SYMBOL BOTTOM" . #x0023b7)
    ("LEFT VERTICAL BOX LINE" . #x0023b8)
    ("RIGHT VERTICAL BOX LINE" . #x0023b9)
    ("HORIZONTAL SCAN LINE-1" . #x0023ba)
    ("HORIZONTAL SCAN LINE-3" . #x0023bb)
    ("HORIZONTAL SCAN LINE-7" . #x0023bc)
    ("HORIZONTAL SCAN LINE-9" . #x0023bd)
    ("DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT" . #x0023be)
    ("DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT" . #x0023bf)
    ("DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE" . #x0023c0)
    ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE" . #x0023c1)
    ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE" . #x0023c2)
    ("DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE" . #x0023c3)
    ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE" . #x0023c4)
    ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE" . #x0023c5)
    ("DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE" . #x0023c6)
    ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE" . #x0023c7)
    ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE" . #x0023c8)
    ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL" . #x0023c9)
    ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL" . #x0023ca)
    ("DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT" . #x0023cb)
    ("DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT" . #x0023cc)
    ("SQUARE FOOT" . #x0023cd)
    ("RETURN SYMBOL" . #x0023ce)
    ("SYMBOL FOR NULL" . #x002400)
    ("SYMBOL FOR START OF HEADING" . #x002401)
    ("SYMBOL FOR START OF TEXT" . #x002402)
    ("SYMBOL FOR END OF TEXT" . #x002403)
    ("SYMBOL FOR END OF TRANSMISSION" . #x002404)
    ("SYMBOL FOR ENQUIRY" . #x002405)
    ("SYMBOL FOR ACKNOWLEDGE" . #x002406)
    ("SYMBOL FOR BELL" . #x002407)
    ("SYMBOL FOR BACKSPACE" . #x002408)
    ("SYMBOL FOR HORIZONTAL TABULATION" . #x002409)
    ("SYMBOL FOR LINE FEED" . #x00240a)
    ("SYMBOL FOR VERTICAL TABULATION" . #x00240b)
    ("SYMBOL FOR FORM FEED" . #x00240c)
    ("SYMBOL FOR CARRIAGE RETURN" . #x00240d)
    ("SYMBOL FOR SHIFT OUT" . #x00240e)
    ("SYMBOL FOR SHIFT IN" . #x00240f)
    ("SYMBOL FOR DATA LINK ESCAPE" . #x002410)
    ("SYMBOL FOR DEVICE CONTROL ONE" . #x002411)
    ("SYMBOL FOR DEVICE CONTROL TWO" . #x002412)
    ("SYMBOL FOR DEVICE CONTROL THREE" . #x002413)
    ("SYMBOL FOR DEVICE CONTROL FOUR" . #x002414)
    ("SYMBOL FOR NEGATIVE ACKNOWLEDGE" . #x002415)
    ("SYMBOL FOR SYNCHRONOUS IDLE" . #x002416)
    ("SYMBOL FOR END OF TRANSMISSION BLOCK" . #x002417)
    ("SYMBOL FOR CANCEL" . #x002418)
    ("SYMBOL FOR END OF MEDIUM" . #x002419)
    ("SYMBOL FOR SUBSTITUTE" . #x00241a)
    ("SYMBOL FOR ESCAPE" . #x00241b)
    ("SYMBOL FOR FILE SEPARATOR" . #x00241c)
    ("SYMBOL FOR GROUP SEPARATOR" . #x00241d)
    ("SYMBOL FOR RECORD SEPARATOR" . #x00241e)
    ("SYMBOL FOR UNIT SEPARATOR" . #x00241f)
    ("SYMBOL FOR SPACE" . #x002420)
    ("SYMBOL FOR DELETE" . #x002421)
    ("BLANK SYMBOL" . #x002422)
    ("OPEN BOX" . #x002423)
    ("SYMBOL FOR NEWLINE" . #x002424)
    ("SYMBOL FOR DELETE FORM TWO" . #x002425)
    ("SYMBOL FOR SUBSTITUTE FORM TWO" . #x002426)
    ("OCR HOOK" . #x002440)
    ("OCR CHAIR" . #x002441)
    ("OCR FORK" . #x002442)
    ("OCR INVERTED FORK" . #x002443)
    ("OCR BELT BUCKLE" . #x002444)
    ("OCR BOW TIE" . #x002445)
    ("OCR BRANCH BANK IDENTIFICATION" . #x002446)
    ("OCR AMOUNT OF CHECK" . #x002447)
    ("OCR DASH" . #x002448)
    ("OCR CUSTOMER ACCOUNT NUMBER" . #x002449)
    ("OCR DOUBLE BACKSLASH" . #x00244a)
    ("CIRCLED DIGIT ONE" . #x002460)
    ("CIRCLED DIGIT TWO" . #x002461)
    ("CIRCLED DIGIT THREE" . #x002462)
    ("CIRCLED DIGIT FOUR" . #x002463)
    ("CIRCLED DIGIT FIVE" . #x002464)
    ("CIRCLED DIGIT SIX" . #x002465)
    ("CIRCLED DIGIT SEVEN" . #x002466)
    ("CIRCLED DIGIT EIGHT" . #x002467)
    ("CIRCLED DIGIT NINE" . #x002468)
    ("CIRCLED NUMBER TEN" . #x002469)
    ("CIRCLED NUMBER ELEVEN" . #x00246a)
    ("CIRCLED NUMBER TWELVE" . #x00246b)
    ("CIRCLED NUMBER THIRTEEN" . #x00246c)
    ("CIRCLED NUMBER FOURTEEN" . #x00246d)
    ("CIRCLED NUMBER FIFTEEN" . #x00246e)
    ("CIRCLED NUMBER SIXTEEN" . #x00246f)
    ("CIRCLED NUMBER SEVENTEEN" . #x002470)
    ("CIRCLED NUMBER EIGHTEEN" . #x002471)
    ("CIRCLED NUMBER NINETEEN" . #x002472)
    ("CIRCLED NUMBER TWENTY" . #x002473)
    ("PARENTHESIZED DIGIT ONE" . #x002474)
    ("PARENTHESIZED DIGIT TWO" . #x002475)
    ("PARENTHESIZED DIGIT THREE" . #x002476)
    ("PARENTHESIZED DIGIT FOUR" . #x002477)
    ("PARENTHESIZED DIGIT FIVE" . #x002478)
    ("PARENTHESIZED DIGIT SIX" . #x002479)
    ("PARENTHESIZED DIGIT SEVEN" . #x00247a)
    ("PARENTHESIZED DIGIT EIGHT" . #x00247b)
    ("PARENTHESIZED DIGIT NINE" . #x00247c)
    ("PARENTHESIZED NUMBER TEN" . #x00247d)
    ("PARENTHESIZED NUMBER ELEVEN" . #x00247e)
    ("PARENTHESIZED NUMBER TWELVE" . #x00247f)
    ("PARENTHESIZED NUMBER THIRTEEN" . #x002480)
    ("PARENTHESIZED NUMBER FOURTEEN" . #x002481)
    ("PARENTHESIZED NUMBER FIFTEEN" . #x002482)
    ("PARENTHESIZED NUMBER SIXTEEN" . #x002483)
    ("PARENTHESIZED NUMBER SEVENTEEN" . #x002484)
    ("PARENTHESIZED NUMBER EIGHTEEN" . #x002485)
    ("PARENTHESIZED NUMBER NINETEEN" . #x002486)
    ("PARENTHESIZED NUMBER TWENTY" . #x002487)
    ("DIGIT ONE FULL STOP" . #x002488)
    ("DIGIT TWO FULL STOP" . #x002489)
    ("DIGIT THREE FULL STOP" . #x00248a)
    ("DIGIT FOUR FULL STOP" . #x00248b)
    ("DIGIT FIVE FULL STOP" . #x00248c)
    ("DIGIT SIX FULL STOP" . #x00248d)
    ("DIGIT SEVEN FULL STOP" . #x00248e)
    ("DIGIT EIGHT FULL STOP" . #x00248f)
    ("DIGIT NINE FULL STOP" . #x002490)
    ("NUMBER TEN FULL STOP" . #x002491)
    ("NUMBER ELEVEN FULL STOP" . #x002492)
    ("NUMBER TWELVE FULL STOP" . #x002493)
    ("NUMBER THIRTEEN FULL STOP" . #x002494)
    ("NUMBER FOURTEEN FULL STOP" . #x002495)
    ("NUMBER FIFTEEN FULL STOP" . #x002496)
    ("NUMBER SIXTEEN FULL STOP" . #x002497)
    ("NUMBER SEVENTEEN FULL STOP" . #x002498)
    ("NUMBER EIGHTEEN FULL STOP" . #x002499)
    ("NUMBER NINETEEN FULL STOP" . #x00249a)
    ("NUMBER TWENTY FULL STOP" . #x00249b)
    ("PARENTHESIZED LATIN SMALL LETTER A" . #x00249c)
    ("PARENTHESIZED LATIN SMALL LETTER B" . #x00249d)
    ("PARENTHESIZED LATIN SMALL LETTER C" . #x00249e)
    ("PARENTHESIZED LATIN SMALL LETTER D" . #x00249f)
    ("PARENTHESIZED LATIN SMALL LETTER E" . #x0024a0)
    ("PARENTHESIZED LATIN SMALL LETTER F" . #x0024a1)
    ("PARENTHESIZED LATIN SMALL LETTER G" . #x0024a2)
    ("PARENTHESIZED LATIN SMALL LETTER H" . #x0024a3)
    ("PARENTHESIZED LATIN SMALL LETTER I" . #x0024a4)
    ("PARENTHESIZED LATIN SMALL LETTER J" . #x0024a5)
    ("PARENTHESIZED LATIN SMALL LETTER K" . #x0024a6)
    ("PARENTHESIZED LATIN SMALL LETTER L" . #x0024a7)
    ("PARENTHESIZED LATIN SMALL LETTER M" . #x0024a8)
    ("PARENTHESIZED LATIN SMALL LETTER N" . #x0024a9)
    ("PARENTHESIZED LATIN SMALL LETTER O" . #x0024aa)
    ("PARENTHESIZED LATIN SMALL LETTER P" . #x0024ab)
    ("PARENTHESIZED LATIN SMALL LETTER Q" . #x0024ac)
    ("PARENTHESIZED LATIN SMALL LETTER R" . #x0024ad)
    ("PARENTHESIZED LATIN SMALL LETTER S" . #x0024ae)
    ("PARENTHESIZED LATIN SMALL LETTER T" . #x0024af)
    ("PARENTHESIZED LATIN SMALL LETTER U" . #x0024b0)
    ("PARENTHESIZED LATIN SMALL LETTER V" . #x0024b1)
    ("PARENTHESIZED LATIN SMALL LETTER W" . #x0024b2)
    ("PARENTHESIZED LATIN SMALL LETTER X" . #x0024b3)
    ("PARENTHESIZED LATIN SMALL LETTER Y" . #x0024b4)
    ("PARENTHESIZED LATIN SMALL LETTER Z" . #x0024b5)
    ("CIRCLED LATIN CAPITAL LETTER A" . #x0024b6)
    ("CIRCLED LATIN CAPITAL LETTER B" . #x0024b7)
    ("CIRCLED LATIN CAPITAL LETTER C" . #x0024b8)
    ("CIRCLED LATIN CAPITAL LETTER D" . #x0024b9)
    ("CIRCLED LATIN CAPITAL LETTER E" . #x0024ba)
    ("CIRCLED LATIN CAPITAL LETTER F" . #x0024bb)
    ("CIRCLED LATIN CAPITAL LETTER G" . #x0024bc)
    ("CIRCLED LATIN CAPITAL LETTER H" . #x0024bd)
    ("CIRCLED LATIN CAPITAL LETTER I" . #x0024be)
    ("CIRCLED LATIN CAPITAL LETTER J" . #x0024bf)
    ("CIRCLED LATIN CAPITAL LETTER K" . #x0024c0)
    ("CIRCLED LATIN CAPITAL LETTER L" . #x0024c1)
    ("CIRCLED LATIN CAPITAL LETTER M" . #x0024c2)
    ("CIRCLED LATIN CAPITAL LETTER N" . #x0024c3)
    ("CIRCLED LATIN CAPITAL LETTER O" . #x0024c4)
    ("CIRCLED LATIN CAPITAL LETTER P" . #x0024c5)
    ("CIRCLED LATIN CAPITAL LETTER Q" . #x0024c6)
    ("CIRCLED LATIN CAPITAL LETTER R" . #x0024c7)
    ("CIRCLED LATIN CAPITAL LETTER S" . #x0024c8)
    ("CIRCLED LATIN CAPITAL LETTER T" . #x0024c9)
    ("CIRCLED LATIN CAPITAL LETTER U" . #x0024ca)
    ("CIRCLED LATIN CAPITAL LETTER V" . #x0024cb)
    ("CIRCLED LATIN CAPITAL LETTER W" . #x0024cc)
    ("CIRCLED LATIN CAPITAL LETTER X" . #x0024cd)
    ("CIRCLED LATIN CAPITAL LETTER Y" . #x0024ce)
    ("CIRCLED LATIN CAPITAL LETTER Z" . #x0024cf)
    ("CIRCLED LATIN SMALL LETTER A" . #x0024d0)
    ("CIRCLED LATIN SMALL LETTER B" . #x0024d1)
    ("CIRCLED LATIN SMALL LETTER C" . #x0024d2)
    ("CIRCLED LATIN SMALL LETTER D" . #x0024d3)
    ("CIRCLED LATIN SMALL LETTER E" . #x0024d4)
    ("CIRCLED LATIN SMALL LETTER F" . #x0024d5)
    ("CIRCLED LATIN SMALL LETTER G" . #x0024d6)
    ("CIRCLED LATIN SMALL LETTER H" . #x0024d7)
    ("CIRCLED LATIN SMALL LETTER I" . #x0024d8)
    ("CIRCLED LATIN SMALL LETTER J" . #x0024d9)
    ("CIRCLED LATIN SMALL LETTER K" . #x0024da)
    ("CIRCLED LATIN SMALL LETTER L" . #x0024db)
    ("CIRCLED LATIN SMALL LETTER M" . #x0024dc)
    ("CIRCLED LATIN SMALL LETTER N" . #x0024dd)
    ("CIRCLED LATIN SMALL LETTER O" . #x0024de)
    ("CIRCLED LATIN SMALL LETTER P" . #x0024df)
    ("CIRCLED LATIN SMALL LETTER Q" . #x0024e0)
    ("CIRCLED LATIN SMALL LETTER R" . #x0024e1)
    ("CIRCLED LATIN SMALL LETTER S" . #x0024e2)
    ("CIRCLED LATIN SMALL LETTER T" . #x0024e3)
    ("CIRCLED LATIN SMALL LETTER U" . #x0024e4)
    ("CIRCLED LATIN SMALL LETTER V" . #x0024e5)
    ("CIRCLED LATIN SMALL LETTER W" . #x0024e6)
    ("CIRCLED LATIN SMALL LETTER X" . #x0024e7)
    ("CIRCLED LATIN SMALL LETTER Y" . #x0024e8)
    ("CIRCLED LATIN SMALL LETTER Z" . #x0024e9)
    ("CIRCLED DIGIT ZERO" . #x0024ea)
    ("NEGATIVE CIRCLED NUMBER ELEVEN" . #x0024eb)
    ("NEGATIVE CIRCLED NUMBER TWELVE" . #x0024ec)
    ("NEGATIVE CIRCLED NUMBER THIRTEEN" . #x0024ed)
    ("NEGATIVE CIRCLED NUMBER FOURTEEN" . #x0024ee)
    ("NEGATIVE CIRCLED NUMBER FIFTEEN" . #x0024ef)
    ("NEGATIVE CIRCLED NUMBER SIXTEEN" . #x0024f0)
    ("NEGATIVE CIRCLED NUMBER SEVENTEEN" . #x0024f1)
    ("NEGATIVE CIRCLED NUMBER EIGHTEEN" . #x0024f2)
    ("NEGATIVE CIRCLED NUMBER NINETEEN" . #x0024f3)
    ("NEGATIVE CIRCLED NUMBER TWENTY" . #x0024f4)
    ("DOUBLE CIRCLED DIGIT ONE" . #x0024f5)
    ("DOUBLE CIRCLED DIGIT TWO" . #x0024f6)
    ("DOUBLE CIRCLED DIGIT THREE" . #x0024f7)
    ("DOUBLE CIRCLED DIGIT FOUR" . #x0024f8)
    ("DOUBLE CIRCLED DIGIT FIVE" . #x0024f9)
    ("DOUBLE CIRCLED DIGIT SIX" . #x0024fa)
    ("DOUBLE CIRCLED DIGIT SEVEN" . #x0024fb)
    ("DOUBLE CIRCLED DIGIT EIGHT" . #x0024fc)
    ("DOUBLE CIRCLED DIGIT NINE" . #x0024fd)
    ("DOUBLE CIRCLED NUMBER TEN" . #x0024fe)
    ("BOX DRAWINGS LIGHT HORIZONTAL" . #x002500)
    ("BOX DRAWINGS HEAVY HORIZONTAL" . #x002501)
    ("BOX DRAWINGS LIGHT VERTICAL" . #x002502)
    ("BOX DRAWINGS HEAVY VERTICAL" . #x002503)
    ("BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL" . #x002504)
    ("BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL" . #x002505)
    ("BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL" . #x002506)
    ("BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL" . #x002507)
    ("BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL" . #x002508)
    ("BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL" . #x002509)
    ("BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL" . #x00250a)
    ("BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL" . #x00250b)
    ("BOX DRAWINGS LIGHT DOWN AND RIGHT" . #x00250c)
    ("BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY" . #x00250d)
    ("BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT" . #x00250e)
    ("BOX DRAWINGS HEAVY DOWN AND RIGHT" . #x00250f)
    ("BOX DRAWINGS LIGHT DOWN AND LEFT" . #x002510)
    ("BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY" . #x002511)
    ("BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT" . #x002512)
    ("BOX DRAWINGS HEAVY DOWN AND LEFT" . #x002513)
    ("BOX DRAWINGS LIGHT UP AND RIGHT" . #x002514)
    ("BOX DRAWINGS UP LIGHT AND RIGHT HEAVY" . #x002515)
    ("BOX DRAWINGS UP HEAVY AND RIGHT LIGHT" . #x002516)
    ("BOX DRAWINGS HEAVY UP AND RIGHT" . #x002517)
    ("BOX DRAWINGS LIGHT UP AND LEFT" . #x002518)
    ("BOX DRAWINGS UP LIGHT AND LEFT HEAVY" . #x002519)
    ("BOX DRAWINGS UP HEAVY AND LEFT LIGHT" . #x00251a)
    ("BOX DRAWINGS HEAVY UP AND LEFT" . #x00251b)
    ("BOX DRAWINGS LIGHT VERTICAL AND RIGHT" . #x00251c)
    ("BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY" . #x00251d)
    ("BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT" . #x00251e)
    ("BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT" . #x00251f)
    ("BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT" . #x002520)
    ("BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY" . #x002521)
    ("BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY" . #x002522)
    ("BOX DRAWINGS HEAVY VERTICAL AND RIGHT" . #x002523)
    ("BOX DRAWINGS LIGHT VERTICAL AND LEFT" . #x002524)
    ("BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY" . #x002525)
    ("BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT" . #x002526)
    ("BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT" . #x002527)
    ("BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT" . #x002528)
    ("BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY" . #x002529)
    ("BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY" . #x00252a)
    ("BOX DRAWINGS HEAVY VERTICAL AND LEFT" . #x00252b)
    ("BOX DRAWINGS LIGHT DOWN AND HORIZONTAL" . #x00252c)
    ("BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT" . #x00252d)
    ("BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT" . #x00252e)
    ("BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY" . #x00252f)
    ("BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT" . #x002530)
    ("BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY" . #x002531)
    ("BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY" . #x002532)
    ("BOX DRAWINGS HEAVY DOWN AND HORIZONTAL" . #x002533)
    ("BOX DRAWINGS LIGHT UP AND HORIZONTAL" . #x002534)
    ("BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT" . #x002535)
    ("BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT" . #x002536)
    ("BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY" . #x002537)
    ("BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT" . #x002538)
    ("BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY" . #x002539)
    ("BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY" . #x00253a)
    ("BOX DRAWINGS HEAVY UP AND HORIZONTAL" . #x00253b)
    ("BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL" . #x00253c)
    ("BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT" . #x00253d)
    ("BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT" . #x00253e)
    ("BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY" . #x00253f)
    ("BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT" . #x002540)
    ("BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT" . #x002541)
    ("BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT" . #x002542)
    ("BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT" . #x002543)
    ("BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT" . #x002544)
    ("BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT" . #x002545)
    ("BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT" . #x002546)
    ("BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY" . #x002547)
    ("BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY" . #x002548)
    ("BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY" . #x002549)
    ("BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY" . #x00254a)
    ("BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL" . #x00254b)
    ("BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL" . #x00254c)
    ("BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL" . #x00254d)
    ("BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL" . #x00254e)
    ("BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL" . #x00254f)
    ("BOX DRAWINGS DOUBLE HORIZONTAL" . #x002550)
    ("BOX DRAWINGS DOUBLE VERTICAL" . #x002551)
    ("BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE" . #x002552)
    ("BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE" . #x002553)
    ("BOX DRAWINGS DOUBLE DOWN AND RIGHT" . #x002554)
    ("BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE" . #x002555)
    ("BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE" . #x002556)
    ("BOX DRAWINGS DOUBLE DOWN AND LEFT" . #x002557)
    ("BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE" . #x002558)
    ("BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE" . #x002559)
    ("BOX DRAWINGS DOUBLE UP AND RIGHT" . #x00255a)
    ("BOX DRAWINGS UP SINGLE AND LEFT DOUBLE" . #x00255b)
    ("BOX DRAWINGS UP DOUBLE AND LEFT SINGLE" . #x00255c)
    ("BOX DRAWINGS DOUBLE UP AND LEFT" . #x00255d)
    ("BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE" . #x00255e)
    ("BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE" . #x00255f)
    ("BOX DRAWINGS DOUBLE VERTICAL AND RIGHT" . #x002560)
    ("BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE" . #x002561)
    ("BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE" . #x002562)
    ("BOX DRAWINGS DOUBLE VERTICAL AND LEFT" . #x002563)
    ("BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE" . #x002564)
    ("BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE" . #x002565)
    ("BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL" . #x002566)
    ("BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE" . #x002567)
    ("BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE" . #x002568)
    ("BOX DRAWINGS DOUBLE UP AND HORIZONTAL" . #x002569)
    ("BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE" . #x00256a)
    ("BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE" . #x00256b)
    ("BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL" . #x00256c)
    ("BOX DRAWINGS LIGHT ARC DOWN AND RIGHT" . #x00256d)
    ("BOX DRAWINGS LIGHT ARC DOWN AND LEFT" . #x00256e)
    ("BOX DRAWINGS LIGHT ARC UP AND LEFT" . #x00256f)
    ("BOX DRAWINGS LIGHT ARC UP AND RIGHT" . #x002570)
    ("BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT" . #x002571)
    ("BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT" . #x002572)
    ("BOX DRAWINGS LIGHT DIAGONAL CROSS" . #x002573)
    ("BOX DRAWINGS LIGHT LEFT" . #x002574)
    ("BOX DRAWINGS LIGHT UP" . #x002575)
    ("BOX DRAWINGS LIGHT RIGHT" . #x002576)
    ("BOX DRAWINGS LIGHT DOWN" . #x002577)
    ("BOX DRAWINGS HEAVY LEFT" . #x002578)
    ("BOX DRAWINGS HEAVY UP" . #x002579)
    ("BOX DRAWINGS HEAVY RIGHT" . #x00257a)
    ("BOX DRAWINGS HEAVY DOWN" . #x00257b)
    ("BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT" . #x00257c)
    ("BOX DRAWINGS LIGHT UP AND HEAVY DOWN" . #x00257d)
    ("BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT" . #x00257e)
    ("BOX DRAWINGS HEAVY UP AND LIGHT DOWN" . #x00257f)
    ("UPPER HALF BLOCK" . #x002580)
    ("LOWER ONE EIGHTH BLOCK" . #x002581)
    ("LOWER ONE QUARTER BLOCK" . #x002582)
    ("LOWER THREE EIGHTHS BLOCK" . #x002583)
    ("LOWER HALF BLOCK" . #x002584)
    ("LOWER FIVE EIGHTHS BLOCK" . #x002585)
    ("LOWER THREE QUARTERS BLOCK" . #x002586)
    ("LOWER SEVEN EIGHTHS BLOCK" . #x002587)
    ("FULL BLOCK" . #x002588)
    ("LEFT SEVEN EIGHTHS BLOCK" . #x002589)
    ("LEFT THREE QUARTERS BLOCK" . #x00258a)
    ("LEFT FIVE EIGHTHS BLOCK" . #x00258b)
    ("LEFT HALF BLOCK" . #x00258c)
    ("LEFT THREE EIGHTHS BLOCK" . #x00258d)
    ("LEFT ONE QUARTER BLOCK" . #x00258e)
    ("LEFT ONE EIGHTH BLOCK" . #x00258f)
    ("RIGHT HALF BLOCK" . #x002590)
    ("LIGHT SHADE" . #x002591)
    ("MEDIUM SHADE" . #x002592)
    ("DARK SHADE" . #x002593)
    ("UPPER ONE EIGHTH BLOCK" . #x002594)
    ("RIGHT ONE EIGHTH BLOCK" . #x002595)
    ("QUADRANT LOWER LEFT" . #x002596)
    ("QUADRANT LOWER RIGHT" . #x002597)
    ("QUADRANT UPPER LEFT" . #x002598)
    ("QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT" . #x002599)
    ("QUADRANT UPPER LEFT AND LOWER RIGHT" . #x00259a)
    ("QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT" . #x00259b)
    ("QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT" . #x00259c)
    ("QUADRANT UPPER RIGHT" . #x00259d)
    ("QUADRANT UPPER RIGHT AND LOWER LEFT" . #x00259e)
    ("QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT" . #x00259f)
    ("BLACK SQUARE" . #x0025a0)
    ("WHITE SQUARE" . #x0025a1)
    ("WHITE SQUARE WITH ROUNDED CORNERS" . #x0025a2)
    ("WHITE SQUARE CONTAINING BLACK SMALL SQUARE" . #x0025a3)
    ("SQUARE WITH HORIZONTAL FILL" . #x0025a4)
    ("SQUARE WITH VERTICAL FILL" . #x0025a5)
    ("SQUARE WITH ORTHOGONAL CROSSHATCH FILL" . #x0025a6)
    ("SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL" . #x0025a7)
    ("SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL" . #x0025a8)
    ("SQUARE WITH DIAGONAL CROSSHATCH FILL" . #x0025a9)
    ("BLACK SMALL SQUARE" . #x0025aa)
    ("WHITE SMALL SQUARE" . #x0025ab)
    ("BLACK RECTANGLE" . #x0025ac)
    ("WHITE RECTANGLE" . #x0025ad)
    ("BLACK VERTICAL RECTANGLE" . #x0025ae)
    ("WHITE VERTICAL RECTANGLE" . #x0025af)
    ("BLACK PARALLELOGRAM" . #x0025b0)
    ("WHITE PARALLELOGRAM" . #x0025b1)
    ("BLACK UP-POINTING TRIANGLE" . #x0025b2)
    ("WHITE UP-POINTING TRIANGLE" . #x0025b3)
    ("BLACK UP-POINTING SMALL TRIANGLE" . #x0025b4)
    ("WHITE UP-POINTING SMALL TRIANGLE" . #x0025b5)
    ("BLACK RIGHT-POINTING TRIANGLE" . #x0025b6)
    ("WHITE RIGHT-POINTING TRIANGLE" . #x0025b7)
    ("BLACK RIGHT-POINTING SMALL TRIANGLE" . #x0025b8)
    ("WHITE RIGHT-POINTING SMALL TRIANGLE" . #x0025b9)
    ("BLACK RIGHT-POINTING POINTER" . #x0025ba)
    ("WHITE RIGHT-POINTING POINTER" . #x0025bb)
    ("BLACK DOWN-POINTING TRIANGLE" . #x0025bc)
    ("WHITE DOWN-POINTING TRIANGLE" . #x0025bd)
    ("BLACK DOWN-POINTING SMALL TRIANGLE" . #x0025be)
    ("WHITE DOWN-POINTING SMALL TRIANGLE" . #x0025bf)
    ("BLACK LEFT-POINTING TRIANGLE" . #x0025c0)
    ("WHITE LEFT-POINTING TRIANGLE" . #x0025c1)
    ("BLACK LEFT-POINTING SMALL TRIANGLE" . #x0025c2)
    ("WHITE LEFT-POINTING SMALL TRIANGLE" . #x0025c3)
    ("BLACK LEFT-POINTING POINTER" . #x0025c4)
    ("WHITE LEFT-POINTING POINTER" . #x0025c5)
    ("BLACK DIAMOND" . #x0025c6)
    ("WHITE DIAMOND" . #x0025c7)
    ("WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND" . #x0025c8)
    ("FISHEYE" . #x0025c9)
    ("LOZENGE" . #x0025ca)
    ("WHITE CIRCLE" . #x0025cb)
    ("DOTTED CIRCLE" . #x0025cc)
    ("CIRCLE WITH VERTICAL FILL" . #x0025cd)
    ("BULLSEYE" . #x0025ce)
    ("BLACK CIRCLE" . #x0025cf)
    ("CIRCLE WITH LEFT HALF BLACK" . #x0025d0)
    ("CIRCLE WITH RIGHT HALF BLACK" . #x0025d1)
    ("CIRCLE WITH LOWER HALF BLACK" . #x0025d2)
    ("CIRCLE WITH UPPER HALF BLACK" . #x0025d3)
    ("CIRCLE WITH UPPER RIGHT QUADRANT BLACK" . #x0025d4)
    ("CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK" . #x0025d5)
    ("LEFT HALF BLACK CIRCLE" . #x0025d6)
    ("RIGHT HALF BLACK CIRCLE" . #x0025d7)
    ("INVERSE BULLET" . #x0025d8)
    ("INVERSE WHITE CIRCLE" . #x0025d9)
    ("UPPER HALF INVERSE WHITE CIRCLE" . #x0025da)
    ("LOWER HALF INVERSE WHITE CIRCLE" . #x0025db)
    ("UPPER LEFT QUADRANT CIRCULAR ARC" . #x0025dc)
    ("UPPER RIGHT QUADRANT CIRCULAR ARC" . #x0025dd)
    ("LOWER RIGHT QUADRANT CIRCULAR ARC" . #x0025de)
    ("LOWER LEFT QUADRANT CIRCULAR ARC" . #x0025df)
    ("UPPER HALF CIRCLE" . #x0025e0)
    ("LOWER HALF CIRCLE" . #x0025e1)
    ("BLACK LOWER RIGHT TRIANGLE" . #x0025e2)
    ("BLACK LOWER LEFT TRIANGLE" . #x0025e3)
    ("BLACK UPPER LEFT TRIANGLE" . #x0025e4)
    ("BLACK UPPER RIGHT TRIANGLE" . #x0025e5)
    ("WHITE BULLET" . #x0025e6)
    ("SQUARE WITH LEFT HALF BLACK" . #x0025e7)
    ("SQUARE WITH RIGHT HALF BLACK" . #x0025e8)
    ("SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK" . #x0025e9)
    ("SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK" . #x0025ea)
    ("WHITE SQUARE WITH VERTICAL BISECTING LINE" . #x0025eb)
    ("WHITE UP-POINTING TRIANGLE WITH DOT" . #x0025ec)
    ("UP-POINTING TRIANGLE WITH LEFT HALF BLACK" . #x0025ed)
    ("UP-POINTING TRIANGLE WITH RIGHT HALF BLACK" . #x0025ee)
    ("LARGE CIRCLE" . #x0025ef)
    ("WHITE SQUARE WITH UPPER LEFT QUADRANT" . #x0025f0)
    ("WHITE SQUARE WITH LOWER LEFT QUADRANT" . #x0025f1)
    ("WHITE SQUARE WITH LOWER RIGHT QUADRANT" . #x0025f2)
    ("WHITE SQUARE WITH UPPER RIGHT QUADRANT" . #x0025f3)
    ("WHITE CIRCLE WITH UPPER LEFT QUADRANT" . #x0025f4)
    ("WHITE CIRCLE WITH LOWER LEFT QUADRANT" . #x0025f5)
    ("WHITE CIRCLE WITH LOWER RIGHT QUADRANT" . #x0025f6)
    ("WHITE CIRCLE WITH UPPER RIGHT QUADRANT" . #x0025f7)
    ("UPPER LEFT TRIANGLE" . #x0025f8)
    ("UPPER RIGHT TRIANGLE" . #x0025f9)
    ("LOWER LEFT TRIANGLE" . #x0025fa)
    ("WHITE MEDIUM SQUARE" . #x0025fb)
    ("BLACK MEDIUM SQUARE" . #x0025fc)
    ("WHITE MEDIUM SMALL SQUARE" . #x0025fd)
    ("BLACK MEDIUM SMALL SQUARE" . #x0025fe)
    ("LOWER RIGHT TRIANGLE" . #x0025ff)
    ("BLACK SUN WITH RAYS" . #x002600)
    ("CLOUD" . #x002601)
    ("UMBRELLA" . #x002602)
    ("SNOWMAN" . #x002603)
    ("COMET" . #x002604)
    ("BLACK STAR" . #x002605)
    ("WHITE STAR" . #x002606)
    ("LIGHTNING" . #x002607)
    ("THUNDERSTORM" . #x002608)
    ("SUN" . #x002609)
    ("ASCENDING NODE" . #x00260a)
    ("DESCENDING NODE" . #x00260b)
    ("CONJUNCTION" . #x00260c)
    ("OPPOSITION" . #x00260d)
    ("BLACK TELEPHONE" . #x00260e)
    ("WHITE TELEPHONE" . #x00260f)
    ("BALLOT BOX" . #x002610)
    ("BALLOT BOX WITH CHECK" . #x002611)
    ("BALLOT BOX WITH X" . #x002612)
    ("SALTIRE" . #x002613)
    ("WHITE SHOGI PIECE" . #x002616)
    ("BLACK SHOGI PIECE" . #x002617)
    ("REVERSED ROTATED FLORAL HEART BULLET" . #x002619)
    ("BLACK LEFT POINTING INDEX" . #x00261a)
    ("BLACK RIGHT POINTING INDEX" . #x00261b)
    ("WHITE LEFT POINTING INDEX" . #x00261c)
    ("WHITE UP POINTING INDEX" . #x00261d)
    ("WHITE RIGHT POINTING INDEX" . #x00261e)
    ("WHITE DOWN POINTING INDEX" . #x00261f)
    ("SKULL AND CROSSBONES" . #x002620)
    ("CAUTION SIGN" . #x002621)
    ("RADIOACTIVE SIGN" . #x002622)
    ("BIOHAZARD SIGN" . #x002623)
    ("CADUCEUS" . #x002624)
    ("ANKH" . #x002625)
    ("ORTHODOX CROSS" . #x002626)
    ("CHI RHO" . #x002627)
    ("CROSS OF LORRAINE" . #x002628)
    ("CROSS OF JERUSALEM" . #x002629)
    ("STAR AND CRESCENT" . #x00262a)
    ("FARSI SYMBOL" . #x00262b)
    ("ADI SHAKTI" . #x00262c)
    ("HAMMER AND SICKLE" . #x00262d)
    ("PEACE SYMBOL" . #x00262e)
    ("YIN YANG" . #x00262f)
    ("TRIGRAM FOR HEAVEN" . #x002630)
    ("TRIGRAM FOR LAKE" . #x002631)
    ("TRIGRAM FOR FIRE" . #x002632)
    ("TRIGRAM FOR THUNDER" . #x002633)
    ("TRIGRAM FOR WIND" . #x002634)
    ("TRIGRAM FOR WATER" . #x002635)
    ("TRIGRAM FOR MOUNTAIN" . #x002636)
    ("TRIGRAM FOR EARTH" . #x002637)
    ("WHEEL OF DHARMA" . #x002638)
    ("WHITE FROWNING FACE" . #x002639)
    ("WHITE SMILING FACE" . #x00263a)
    ("BLACK SMILING FACE" . #x00263b)
    ("WHITE SUN WITH RAYS" . #x00263c)
    ("FIRST QUARTER MOON" . #x00263d)
    ("LAST QUARTER MOON" . #x00263e)
    ("MERCURY" . #x00263f)
    ("FEMALE SIGN" . #x002640)
    ("EARTH" . #x002641)
    ("MALE SIGN" . #x002642)
    ("JUPITER" . #x002643)
    ("SATURN" . #x002644)
    ("URANUS" . #x002645)
    ("NEPTUNE" . #x002646)
    ("PLUTO" . #x002647)
    ("ARIES" . #x002648)
    ("TAURUS" . #x002649)
    ("GEMINI" . #x00264a)
    ("CANCER" . #x00264b)
    ("LEO" . #x00264c)
    ("VIRGO" . #x00264d)
    ("LIBRA" . #x00264e)
    ("SCORPIUS" . #x00264f)
    ("SAGITTARIUS" . #x002650)
    ("CAPRICORN" . #x002651)
    ("AQUARIUS" . #x002652)
    ("PISCES" . #x002653)
    ("WHITE CHESS KING" . #x002654)
    ("WHITE CHESS QUEEN" . #x002655)
    ("WHITE CHESS ROOK" . #x002656)
    ("WHITE CHESS BISHOP" . #x002657)
    ("WHITE CHESS KNIGHT" . #x002658)
    ("WHITE CHESS PAWN" . #x002659)
    ("BLACK CHESS KING" . #x00265a)
    ("BLACK CHESS QUEEN" . #x00265b)
    ("BLACK CHESS ROOK" . #x00265c)
    ("BLACK CHESS BISHOP" . #x00265d)
    ("BLACK CHESS KNIGHT" . #x00265e)
    ("BLACK CHESS PAWN" . #x00265f)
    ("BLACK SPADE SUIT" . #x002660)
    ("WHITE HEART SUIT" . #x002661)
    ("WHITE DIAMOND SUIT" . #x002662)
    ("BLACK CLUB SUIT" . #x002663)
    ("WHITE SPADE SUIT" . #x002664)
    ("BLACK HEART SUIT" . #x002665)
    ("BLACK DIAMOND SUIT" . #x002666)
    ("WHITE CLUB SUIT" . #x002667)
    ("HOT SPRINGS" . #x002668)
    ("QUARTER NOTE" . #x002669)
    ("EIGHTH NOTE" . #x00266a)
    ("BEAMED EIGHTH NOTES" . #x00266b)
    ("BEAMED SIXTEENTH NOTES" . #x00266c)
    ("MUSIC FLAT SIGN" . #x00266d)
    ("MUSIC NATURAL SIGN" . #x00266e)
    ("MUSIC SHARP SIGN" . #x00266f)
    ("WEST SYRIAC CROSS" . #x002670)
    ("EAST SYRIAC CROSS" . #x002671)
    ("UNIVERSAL RECYCLING SYMBOL" . #x002672)
    ("RECYCLING SYMBOL FOR TYPE-1 PLASTICS" . #x002673)
    ("RECYCLING SYMBOL FOR TYPE-2 PLASTICS" . #x002674)
    ("RECYCLING SYMBOL FOR TYPE-3 PLASTICS" . #x002675)
    ("RECYCLING SYMBOL FOR TYPE-4 PLASTICS" . #x002676)
    ("RECYCLING SYMBOL FOR TYPE-5 PLASTICS" . #x002677)
    ("RECYCLING SYMBOL FOR TYPE-6 PLASTICS" . #x002678)
    ("RECYCLING SYMBOL FOR TYPE-7 PLASTICS" . #x002679)
    ("RECYCLING SYMBOL FOR GENERIC MATERIALS" . #x00267a)
    ("BLACK UNIVERSAL RECYCLING SYMBOL" . #x00267b)
    ("RECYCLED PAPER SYMBOL" . #x00267c)
    ("PARTIALLY-RECYCLED PAPER SYMBOL" . #x00267d)
    ("DIE FACE-1" . #x002680)
    ("DIE FACE-2" . #x002681)
    ("DIE FACE-3" . #x002682)
    ("DIE FACE-4" . #x002683)
    ("DIE FACE-5" . #x002684)
    ("DIE FACE-6" . #x002685)
    ("WHITE CIRCLE WITH DOT RIGHT" . #x002686)
    ("WHITE CIRCLE WITH TWO DOTS" . #x002687)
    ("BLACK CIRCLE WITH WHITE DOT RIGHT" . #x002688)
    ("BLACK CIRCLE WITH TWO WHITE DOTS" . #x002689)
    ("UPPER BLADE SCISSORS" . #x002701)
    ("BLACK SCISSORS" . #x002702)
    ("LOWER BLADE SCISSORS" . #x002703)
    ("WHITE SCISSORS" . #x002704)
    ("TELEPHONE LOCATION SIGN" . #x002706)
    ("TAPE DRIVE" . #x002707)
    ("AIRPLANE" . #x002708)
    ("ENVELOPE" . #x002709)
    ("VICTORY HAND" . #x00270c)
    ("WRITING HAND" . #x00270d)
    ("LOWER RIGHT PENCIL" . #x00270e)
    ("PENCIL" . #x00270f)
    ("UPPER RIGHT PENCIL" . #x002710)
    ("WHITE NIB" . #x002711)
    ("BLACK NIB" . #x002712)
    ("CHECK MARK" . #x002713)
    ("HEAVY CHECK MARK" . #x002714)
    ("MULTIPLICATION X" . #x002715)
    ("HEAVY MULTIPLICATION X" . #x002716)
    ("BALLOT X" . #x002717)
    ("HEAVY BALLOT X" . #x002718)
    ("OUTLINED GREEK CROSS" . #x002719)
    ("HEAVY GREEK CROSS" . #x00271a)
    ("OPEN CENTRE CROSS" . #x00271b)
    ("HEAVY OPEN CENTRE CROSS" . #x00271c)
    ("LATIN CROSS" . #x00271d)
    ("SHADOWED WHITE LATIN CROSS" . #x00271e)
    ("OUTLINED LATIN CROSS" . #x00271f)
    ("MALTESE CROSS" . #x002720)
    ("STAR OF DAVID" . #x002721)
    ("FOUR TEARDROP-SPOKED ASTERISK" . #x002722)
    ("FOUR BALLOON-SPOKED ASTERISK" . #x002723)
    ("HEAVY FOUR BALLOON-SPOKED ASTERISK" . #x002724)
    ("FOUR CLUB-SPOKED ASTERISK" . #x002725)
    ("BLACK FOUR POINTED STAR" . #x002726)
    ("WHITE FOUR POINTED STAR" . #x002727)
    ("STRESS OUTLINED WHITE STAR" . #x002729)
    ("CIRCLED WHITE STAR" . #x00272a)
    ("OPEN CENTRE BLACK STAR" . #x00272b)
    ("BLACK CENTRE WHITE STAR" . #x00272c)
    ("OUTLINED BLACK STAR" . #x00272d)
    ("HEAVY OUTLINED BLACK STAR" . #x00272e)
    ("PINWHEEL STAR" . #x00272f)
    ("SHADOWED WHITE STAR" . #x002730)
    ("HEAVY ASTERISK" . #x002731)
    ("OPEN CENTRE ASTERISK" . #x002732)
    ("EIGHT SPOKED ASTERISK" . #x002733)
    ("EIGHT POINTED BLACK STAR" . #x002734)
    ("EIGHT POINTED PINWHEEL STAR" . #x002735)
    ("SIX POINTED BLACK STAR" . #x002736)
    ("EIGHT POINTED RECTILINEAR BLACK STAR" . #x002737)
    ("HEAVY EIGHT POINTED RECTILINEAR BLACK STAR" . #x002738)
    ("TWELVE POINTED BLACK STAR" . #x002739)
    ("SIXTEEN POINTED ASTERISK" . #x00273a)
    ("TEARDROP-SPOKED ASTERISK" . #x00273b)
    ("OPEN CENTRE TEARDROP-SPOKED ASTERISK" . #x00273c)
    ("HEAVY TEARDROP-SPOKED ASTERISK" . #x00273d)
    ("SIX PETALLED BLACK AND WHITE FLORETTE" . #x00273e)
    ("BLACK FLORETTE" . #x00273f)
    ("WHITE FLORETTE" . #x002740)
    ("EIGHT PETALLED OUTLINED BLACK FLORETTE" . #x002741)
    ("CIRCLED OPEN CENTRE EIGHT POINTED STAR" . #x002742)
    ("HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK" . #x002743)
    ("SNOWFLAKE" . #x002744)
    ("TIGHT TRIFOLIATE SNOWFLAKE" . #x002745)
    ("HEAVY CHEVRON SNOWFLAKE" . #x002746)
    ("SPARKLE" . #x002747)
    ("HEAVY SPARKLE" . #x002748)
    ("BALLOON-SPOKED ASTERISK" . #x002749)
    ("EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" . #x00274a)
    ("HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" . #x00274b)
    ("SHADOWED WHITE CIRCLE" . #x00274d)
    ("LOWER RIGHT DROP-SHADOWED WHITE SQUARE" . #x00274f)
    ("UPPER RIGHT DROP-SHADOWED WHITE SQUARE" . #x002750)
    ("LOWER RIGHT SHADOWED WHITE SQUARE" . #x002751)
    ("UPPER RIGHT SHADOWED WHITE SQUARE" . #x002752)
    ("BLACK DIAMOND MINUS WHITE X" . #x002756)
    ("LIGHT VERTICAL BAR" . #x002758)
    ("MEDIUM VERTICAL BAR" . #x002759)
    ("HEAVY VERTICAL BAR" . #x00275a)
    ("HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT" . #x00275b)
    ("HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT" . #x00275c)
    ("HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT" . #x00275d)
    ("HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT" . #x00275e)
    ("CURVED STEM PARAGRAPH SIGN ORNAMENT" . #x002761)
    ("HEAVY EXCLAMATION MARK ORNAMENT" . #x002762)
    ("HEAVY HEART EXCLAMATION MARK ORNAMENT" . #x002763)
    ("HEAVY BLACK HEART" . #x002764)
    ("ROTATED HEAVY BLACK HEART BULLET" . #x002765)
    ("FLORAL HEART" . #x002766)
    ("ROTATED FLORAL HEART BULLET" . #x002767)
    ("MEDIUM LEFT PARENTHESIS ORNAMENT" . #x002768)
    ("MEDIUM RIGHT PARENTHESIS ORNAMENT" . #x002769)
    ("MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT" . #x00276a)
    ("MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT" . #x00276b)
    ("MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT" . #x00276c)
    ("MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT" . #x00276d)
    ("HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT" . #x00276e)
    ("HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT" . #x00276f)
    ("HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT" . #x002770)
    ("HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT" . #x002771)
    ("LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT" . #x002772)
    ("LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT" . #x002773)
    ("MEDIUM LEFT CURLY BRACKET ORNAMENT" . #x002774)
    ("MEDIUM RIGHT CURLY BRACKET ORNAMENT" . #x002775)
    ("DINGBAT NEGATIVE CIRCLED DIGIT ONE" . #x002776)
    ("DINGBAT NEGATIVE CIRCLED DIGIT TWO" . #x002777)
    ("DINGBAT NEGATIVE CIRCLED DIGIT THREE" . #x002778)
    ("DINGBAT NEGATIVE CIRCLED DIGIT FOUR" . #x002779)
    ("DINGBAT NEGATIVE CIRCLED DIGIT FIVE" . #x00277a)
    ("DINGBAT NEGATIVE CIRCLED DIGIT SIX" . #x00277b)
    ("DINGBAT NEGATIVE CIRCLED DIGIT SEVEN" . #x00277c)
    ("DINGBAT NEGATIVE CIRCLED DIGIT EIGHT" . #x00277d)
    ("DINGBAT NEGATIVE CIRCLED DIGIT NINE" . #x00277e)
    ("DINGBAT NEGATIVE CIRCLED NUMBER TEN" . #x00277f)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT ONE" . #x002780)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT TWO" . #x002781)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT THREE" . #x002782)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT FOUR" . #x002783)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT FIVE" . #x002784)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT SIX" . #x002785)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN" . #x002786)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT" . #x002787)
    ("DINGBAT CIRCLED SANS-SERIF DIGIT NINE" . #x002788)
    ("DINGBAT CIRCLED SANS-SERIF NUMBER TEN" . #x002789)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE" . #x00278a)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO" . #x00278b)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE" . #x00278c)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR" . #x00278d)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE" . #x00278e)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX" . #x00278f)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN" . #x002790)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT" . #x002791)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE" . #x002792)
    ("DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN" . #x002793)
    ("HEAVY WIDE-HEADED RIGHTWARDS ARROW" . #x002794)
    ("HEAVY SOUTH EAST ARROW" . #x002798)
    ("HEAVY RIGHTWARDS ARROW" . #x002799)
    ("HEAVY NORTH EAST ARROW" . #x00279a)
    ("DRAFTING POINT RIGHTWARDS ARROW" . #x00279b)
    ("HEAVY ROUND-TIPPED RIGHTWARDS ARROW" . #x00279c)
    ("TRIANGLE-HEADED RIGHTWARDS ARROW" . #x00279d)
    ("HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW" . #x00279e)
    ("DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" . #x00279f)
    ("HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" . #x0027a0)
    ("BLACK RIGHTWARDS ARROW" . #x0027a1)
    ("THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD" . #x0027a2)
    ("THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD" . #x0027a3)
    ("BLACK RIGHTWARDS ARROWHEAD" . #x0027a4)
    ("HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW" . #x0027a5)
    ("HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW" . #x0027a6)
    ("SQUAT BLACK RIGHTWARDS ARROW" . #x0027a7)
    ("HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW" . #x0027a8)
    ("RIGHT-SHADED WHITE RIGHTWARDS ARROW" . #x0027a9)
    ("LEFT-SHADED WHITE RIGHTWARDS ARROW" . #x0027aa)
    ("BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW" . #x0027ab)
    ("FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW" . #x0027ac)
    ("HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . #x0027ad)
    ("HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . #x0027ae)
    ("NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . #x0027af)
    ("NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . #x0027b1)
    ("CIRCLED HEAVY WHITE RIGHTWARDS ARROW" . #x0027b2)
    ("WHITE-FEATHERED RIGHTWARDS ARROW" . #x0027b3)
    ("BLACK-FEATHERED SOUTH EAST ARROW" . #x0027b4)
    ("BLACK-FEATHERED RIGHTWARDS ARROW" . #x0027b5)
    ("BLACK-FEATHERED NORTH EAST ARROW" . #x0027b6)
    ("HEAVY BLACK-FEATHERED SOUTH EAST ARROW" . #x0027b7)
    ("HEAVY BLACK-FEATHERED RIGHTWARDS ARROW" . #x0027b8)
    ("HEAVY BLACK-FEATHERED NORTH EAST ARROW" . #x0027b9)
    ("TEARDROP-BARBED RIGHTWARDS ARROW" . #x0027ba)
    ("HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW" . #x0027bb)
    ("WEDGE-TAILED RIGHTWARDS ARROW" . #x0027bc)
    ("HEAVY WEDGE-TAILED RIGHTWARDS ARROW" . #x0027bd)
    ("OPEN-OUTLINED RIGHTWARDS ARROW" . #x0027be)
    ("WHITE DIAMOND WITH CENTRED DOT" . #x0027d0)
    ("AND WITH DOT" . #x0027d1)
    ("ELEMENT OF OPENING UPWARDS" . #x0027d2)
    ("LOWER RIGHT CORNER WITH DOT" . #x0027d3)
    ("UPPER LEFT CORNER WITH DOT" . #x0027d4)
    ("LEFT OUTER JOIN" . #x0027d5)
    ("RIGHT OUTER JOIN" . #x0027d6)
    ("FULL OUTER JOIN" . #x0027d7)
    ("LARGE UP TACK" . #x0027d8)
    ("LARGE DOWN TACK" . #x0027d9)
    ("LEFT AND RIGHT DOUBLE TURNSTILE" . #x0027da)
    ("LEFT AND RIGHT TACK" . #x0027db)
    ("LEFT MULTIMAP" . #x0027dc)
    ("LONG RIGHT TACK" . #x0027dd)
    ("LONG LEFT TACK" . #x0027de)
    ("UP TACK WITH CIRCLE ABOVE" . #x0027df)
    ("LOZENGE DIVIDED BY HORIZONTAL RULE" . #x0027e0)
    ("WHITE CONCAVE-SIDED DIAMOND" . #x0027e1)
    ("WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK" . #x0027e2)
    ("WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK" . #x0027e3)
    ("WHITE SQUARE WITH LEFTWARDS TICK" . #x0027e4)
    ("WHITE SQUARE WITH RIGHTWARDS TICK" . #x0027e5)
    ("MATHEMATICAL LEFT WHITE SQUARE BRACKET" . #x0027e6)
    ("MATHEMATICAL RIGHT WHITE SQUARE BRACKET" . #x0027e7)
    ("MATHEMATICAL LEFT ANGLE BRACKET" . #x0027e8)
    ("MATHEMATICAL RIGHT ANGLE BRACKET" . #x0027e9)
    ("MATHEMATICAL LEFT DOUBLE ANGLE BRACKET" . #x0027ea)
    ("MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET" . #x0027eb)
    ("UPWARDS QUADRUPLE ARROW" . #x0027f0)
    ("DOWNWARDS QUADRUPLE ARROW" . #x0027f1)
    ("ANTICLOCKWISE GAPPED CIRCLE ARROW" . #x0027f2)
    ("CLOCKWISE GAPPED CIRCLE ARROW" . #x0027f3)
    ("RIGHT ARROW WITH CIRCLED PLUS" . #x0027f4)
    ("LONG LEFTWARDS ARROW" . #x0027f5)
    ("LONG RIGHTWARDS ARROW" . #x0027f6)
    ("LONG LEFT RIGHT ARROW" . #x0027f7)
    ("LONG LEFTWARDS DOUBLE ARROW" . #x0027f8)
    ("LONG RIGHTWARDS DOUBLE ARROW" . #x0027f9)
    ("LONG LEFT RIGHT DOUBLE ARROW" . #x0027fa)
    ("LONG LEFTWARDS ARROW FROM BAR" . #x0027fb)
    ("LONG RIGHTWARDS ARROW FROM BAR" . #x0027fc)
    ("LONG LEFTWARDS DOUBLE ARROW FROM BAR" . #x0027fd)
    ("LONG RIGHTWARDS DOUBLE ARROW FROM BAR" . #x0027fe)
    ("LONG RIGHTWARDS SQUIGGLE ARROW" . #x0027ff)
    ("RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE" . #x002900)
    ("RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE" . #x002901)
    ("LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE" . #x002902)
    ("RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE" . #x002903)
    ("LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE" . #x002904)
    ("RIGHTWARDS TWO-HEADED ARROW FROM BAR" . #x002905)
    ("LEFTWARDS DOUBLE ARROW FROM BAR" . #x002906)
    ("RIGHTWARDS DOUBLE ARROW FROM BAR" . #x002907)
    ("DOWNWARDS ARROW WITH HORIZONTAL STROKE" . #x002908)
    ("UPWARDS ARROW WITH HORIZONTAL STROKE" . #x002909)
    ("UPWARDS TRIPLE ARROW" . #x00290a)
    ("DOWNWARDS TRIPLE ARROW" . #x00290b)
    ("LEFTWARDS DOUBLE DASH ARROW" . #x00290c)
    ("RIGHTWARDS DOUBLE DASH ARROW" . #x00290d)
    ("LEFTWARDS TRIPLE DASH ARROW" . #x00290e)
    ("RIGHTWARDS TRIPLE DASH ARROW" . #x00290f)
    ("RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW" . #x002910)
    ("RIGHTWARDS ARROW WITH DOTTED STEM" . #x002911)
    ("UPWARDS ARROW TO BAR" . #x002912)
    ("DOWNWARDS ARROW TO BAR" . #x002913)
    ("RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE" . #x002914)
    ("RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" . #x002915)
    ("RIGHTWARDS TWO-HEADED ARROW WITH TAIL" . #x002916)
    ("RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE" . #x002917)
    ("RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" . #x002918)
    ("LEFTWARDS ARROW-TAIL" . #x002919)
    ("RIGHTWARDS ARROW-TAIL" . #x00291a)
    ("LEFTWARDS DOUBLE ARROW-TAIL" . #x00291b)
    ("RIGHTWARDS DOUBLE ARROW-TAIL" . #x00291c)
    ("LEFTWARDS ARROW TO BLACK DIAMOND" . #x00291d)
    ("RIGHTWARDS ARROW TO BLACK DIAMOND" . #x00291e)
    ("LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND" . #x00291f)
    ("RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND" . #x002920)
    ("NORTH WEST AND SOUTH EAST ARROW" . #x002921)
    ("NORTH EAST AND SOUTH WEST ARROW" . #x002922)
    ("NORTH WEST ARROW WITH HOOK" . #x002923)
    ("NORTH EAST ARROW WITH HOOK" . #x002924)
    ("SOUTH EAST ARROW WITH HOOK" . #x002925)
    ("SOUTH WEST ARROW WITH HOOK" . #x002926)
    ("NORTH WEST ARROW AND NORTH EAST ARROW" . #x002927)
    ("NORTH EAST ARROW AND SOUTH EAST ARROW" . #x002928)
    ("SOUTH EAST ARROW AND SOUTH WEST ARROW" . #x002929)
    ("SOUTH WEST ARROW AND NORTH WEST ARROW" . #x00292a)
    ("RISING DIAGONAL CROSSING FALLING DIAGONAL" . #x00292b)
    ("FALLING DIAGONAL CROSSING RISING DIAGONAL" . #x00292c)
    ("SOUTH EAST ARROW CROSSING NORTH EAST ARROW" . #x00292d)
    ("NORTH EAST ARROW CROSSING SOUTH EAST ARROW" . #x00292e)
    ("FALLING DIAGONAL CROSSING NORTH EAST ARROW" . #x00292f)
    ("RISING DIAGONAL CROSSING SOUTH EAST ARROW" . #x002930)
    ("NORTH EAST ARROW CROSSING NORTH WEST ARROW" . #x002931)
    ("NORTH WEST ARROW CROSSING NORTH EAST ARROW" . #x002932)
    ("WAVE ARROW POINTING DIRECTLY RIGHT" . #x002933)
    ("ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS" . #x002934)
    ("ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS" . #x002935)
    ("ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS" . #x002936)
    ("ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS" . #x002937)
    ("RIGHT-SIDE ARC CLOCKWISE ARROW" . #x002938)
    ("LEFT-SIDE ARC ANTICLOCKWISE ARROW" . #x002939)
    ("TOP ARC ANTICLOCKWISE ARROW" . #x00293a)
    ("BOTTOM ARC ANTICLOCKWISE ARROW" . #x00293b)
    ("TOP ARC CLOCKWISE ARROW WITH MINUS" . #x00293c)
    ("TOP ARC ANTICLOCKWISE ARROW WITH PLUS" . #x00293d)
    ("LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW" . #x00293e)
    ("LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW" . #x00293f)
    ("ANTICLOCKWISE CLOSED CIRCLE ARROW" . #x002940)
    ("CLOCKWISE CLOSED CIRCLE ARROW" . #x002941)
    ("RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW" . #x002942)
    ("LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW" . #x002943)
    ("SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW" . #x002944)
    ("RIGHTWARDS ARROW WITH PLUS BELOW" . #x002945)
    ("LEFTWARDS ARROW WITH PLUS BELOW" . #x002946)
    ("RIGHTWARDS ARROW THROUGH X" . #x002947)
    ("LEFT RIGHT ARROW THROUGH SMALL CIRCLE" . #x002948)
    ("UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE" . #x002949)
    ("LEFT BARB UP RIGHT BARB DOWN HARPOON" . #x00294a)
    ("LEFT BARB DOWN RIGHT BARB UP HARPOON" . #x00294b)
    ("UP BARB RIGHT DOWN BARB LEFT HARPOON" . #x00294c)
    ("UP BARB LEFT DOWN BARB RIGHT HARPOON" . #x00294d)
    ("LEFT BARB UP RIGHT BARB UP HARPOON" . #x00294e)
    ("UP BARB RIGHT DOWN BARB RIGHT HARPOON" . #x00294f)
    ("LEFT BARB DOWN RIGHT BARB DOWN HARPOON" . #x002950)
    ("UP BARB LEFT DOWN BARB LEFT HARPOON" . #x002951)
    ("LEFTWARDS HARPOON WITH BARB UP TO BAR" . #x002952)
    ("RIGHTWARDS HARPOON WITH BARB UP TO BAR" . #x002953)
    ("UPWARDS HARPOON WITH BARB RIGHT TO BAR" . #x002954)
    ("DOWNWARDS HARPOON WITH BARB RIGHT TO BAR" . #x002955)
    ("LEFTWARDS HARPOON WITH BARB DOWN TO BAR" . #x002956)
    ("RIGHTWARDS HARPOON WITH BARB DOWN TO BAR" . #x002957)
    ("UPWARDS HARPOON WITH BARB LEFT TO BAR" . #x002958)
    ("DOWNWARDS HARPOON WITH BARB LEFT TO BAR" . #x002959)
    ("LEFTWARDS HARPOON WITH BARB UP FROM BAR" . #x00295a)
    ("RIGHTWARDS HARPOON WITH BARB UP FROM BAR" . #x00295b)
    ("UPWARDS HARPOON WITH BARB RIGHT FROM BAR" . #x00295c)
    ("DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR" . #x00295d)
    ("LEFTWARDS HARPOON WITH BARB DOWN FROM BAR" . #x00295e)
    ("RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR" . #x00295f)
    ("UPWARDS HARPOON WITH BARB LEFT FROM BAR" . #x002960)
    ("DOWNWARDS HARPOON WITH BARB LEFT FROM BAR" . #x002961)
    ("LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN" . #x002962)
    ("UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" . #x002963)
    ("RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN" . #x002964)
    ("DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT" . #x002965)
    ("LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP" . #x002966)
    ("LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN" . #x002967)
    ("RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP" . #x002968)
    ("RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN" . #x002969)
    ("LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" . #x00296a)
    ("LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" . #x00296b)
    ("RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" . #x00296c)
    ("RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" . #x00296d)
    ("UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT" . #x00296e)
    ("DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" . #x00296f)
    ("RIGHT DOUBLE ARROW WITH ROUNDED HEAD" . #x002970)
    ("EQUALS SIGN ABOVE RIGHTWARDS ARROW" . #x002971)
    ("TILDE OPERATOR ABOVE RIGHTWARDS ARROW" . #x002972)
    ("LEFTWARDS ARROW ABOVE TILDE OPERATOR" . #x002973)
    ("RIGHTWARDS ARROW ABOVE TILDE OPERATOR" . #x002974)
    ("RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO" . #x002975)
    ("LESS-THAN ABOVE LEFTWARDS ARROW" . #x002976)
    ("LEFTWARDS ARROW THROUGH LESS-THAN" . #x002977)
    ("GREATER-THAN ABOVE RIGHTWARDS ARROW" . #x002978)
    ("SUBSET ABOVE RIGHTWARDS ARROW" . #x002979)
    ("LEFTWARDS ARROW THROUGH SUBSET" . #x00297a)
    ("SUPERSET ABOVE LEFTWARDS ARROW" . #x00297b)
    ("LEFT FISH TAIL" . #x00297c)
    ("RIGHT FISH TAIL" . #x00297d)
    ("UP FISH TAIL" . #x00297e)
    ("DOWN FISH TAIL" . #x00297f)
    ("TRIPLE VERTICAL BAR DELIMITER" . #x002980)
    ("Z NOTATION SPOT" . #x002981)
    ("Z NOTATION TYPE COLON" . #x002982)
    ("LEFT WHITE CURLY BRACKET" . #x002983)
    ("RIGHT WHITE CURLY BRACKET" . #x002984)
    ("LEFT WHITE PARENTHESIS" . #x002985)
    ("RIGHT WHITE PARENTHESIS" . #x002986)
    ("Z NOTATION LEFT IMAGE BRACKET" . #x002987)
    ("Z NOTATION RIGHT IMAGE BRACKET" . #x002988)
    ("Z NOTATION LEFT BINDING BRACKET" . #x002989)
    ("Z NOTATION RIGHT BINDING BRACKET" . #x00298a)
    ("LEFT SQUARE BRACKET WITH UNDERBAR" . #x00298b)
    ("RIGHT SQUARE BRACKET WITH UNDERBAR" . #x00298c)
    ("LEFT SQUARE BRACKET WITH TICK IN TOP CORNER" . #x00298d)
    ("RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER" . #x00298e)
    ("LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER" . #x00298f)
    ("RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER" . #x002990)
    ("LEFT ANGLE BRACKET WITH DOT" . #x002991)
    ("RIGHT ANGLE BRACKET WITH DOT" . #x002992)
    ("LEFT ARC LESS-THAN BRACKET" . #x002993)
    ("RIGHT ARC GREATER-THAN BRACKET" . #x002994)
    ("DOUBLE LEFT ARC GREATER-THAN BRACKET" . #x002995)
    ("DOUBLE RIGHT ARC LESS-THAN BRACKET" . #x002996)
    ("LEFT BLACK TORTOISE SHELL BRACKET" . #x002997)
    ("RIGHT BLACK TORTOISE SHELL BRACKET" . #x002998)
    ("DOTTED FENCE" . #x002999)
    ("VERTICAL ZIGZAG LINE" . #x00299a)
    ("MEASURED ANGLE OPENING LEFT" . #x00299b)
    ("RIGHT ANGLE VARIANT WITH SQUARE" . #x00299c)
    ("MEASURED RIGHT ANGLE WITH DOT" . #x00299d)
    ("ANGLE WITH S INSIDE" . #x00299e)
    ("ACUTE ANGLE" . #x00299f)
    ("SPHERICAL ANGLE OPENING LEFT" . #x0029a0)
    ("SPHERICAL ANGLE OPENING UP" . #x0029a1)
    ("TURNED ANGLE" . #x0029a2)
    ("REVERSED ANGLE" . #x0029a3)
    ("ANGLE WITH UNDERBAR" . #x0029a4)
    ("REVERSED ANGLE WITH UNDERBAR" . #x0029a5)
    ("OBLIQUE ANGLE OPENING UP" . #x0029a6)
    ("OBLIQUE ANGLE OPENING DOWN" . #x0029a7)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT" . #x0029a8)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT" . #x0029a9)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT" . #x0029aa)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT" . #x0029ab)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP" . #x0029ac)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP" . #x0029ad)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN" . #x0029ae)
    ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN" . #x0029af)
    ("REVERSED EMPTY SET" . #x0029b0)
    ("EMPTY SET WITH OVERBAR" . #x0029b1)
    ("EMPTY SET WITH SMALL CIRCLE ABOVE" . #x0029b2)
    ("EMPTY SET WITH RIGHT ARROW ABOVE" . #x0029b3)
    ("EMPTY SET WITH LEFT ARROW ABOVE" . #x0029b4)
    ("CIRCLE WITH HORIZONTAL BAR" . #x0029b5)
    ("CIRCLED VERTICAL BAR" . #x0029b6)
    ("CIRCLED PARALLEL" . #x0029b7)
    ("CIRCLED REVERSE SOLIDUS" . #x0029b8)
    ("CIRCLED PERPENDICULAR" . #x0029b9)
    ("CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR" . #x0029ba)
    ("CIRCLE WITH SUPERIMPOSED X" . #x0029bb)
    ("CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN" . #x0029bc)
    ("UP ARROW THROUGH CIRCLE" . #x0029bd)
    ("CIRCLED WHITE BULLET" . #x0029be)
    ("CIRCLED BULLET" . #x0029bf)
    ("CIRCLED LESS-THAN" . #x0029c0)
    ("CIRCLED GREATER-THAN" . #x0029c1)
    ("CIRCLE WITH SMALL CIRCLE TO THE RIGHT" . #x0029c2)
    ("CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT" . #x0029c3)
    ("SQUARED RISING DIAGONAL SLASH" . #x0029c4)
    ("SQUARED FALLING DIAGONAL SLASH" . #x0029c5)
    ("SQUARED ASTERISK" . #x0029c6)
    ("SQUARED SMALL CIRCLE" . #x0029c7)
    ("SQUARED SQUARE" . #x0029c8)
    ("TWO JOINED SQUARES" . #x0029c9)
    ("TRIANGLE WITH DOT ABOVE" . #x0029ca)
    ("TRIANGLE WITH UNDERBAR" . #x0029cb)
    ("S IN TRIANGLE" . #x0029cc)
    ("TRIANGLE WITH SERIFS AT BOTTOM" . #x0029cd)
    ("RIGHT TRIANGLE ABOVE LEFT TRIANGLE" . #x0029ce)
    ("LEFT TRIANGLE BESIDE VERTICAL BAR" . #x0029cf)
    ("VERTICAL BAR BESIDE RIGHT TRIANGLE" . #x0029d0)
    ("BOWTIE WITH LEFT HALF BLACK" . #x0029d1)
    ("BOWTIE WITH RIGHT HALF BLACK" . #x0029d2)
    ("BLACK BOWTIE" . #x0029d3)
    ("TIMES WITH LEFT HALF BLACK" . #x0029d4)
    ("TIMES WITH RIGHT HALF BLACK" . #x0029d5)
    ("WHITE HOURGLASS" . #x0029d6)
    ("BLACK HOURGLASS" . #x0029d7)
    ("LEFT WIGGLY FENCE" . #x0029d8)
    ("RIGHT WIGGLY FENCE" . #x0029d9)
    ("LEFT DOUBLE WIGGLY FENCE" . #x0029da)
    ("RIGHT DOUBLE WIGGLY FENCE" . #x0029db)
    ("INCOMPLETE INFINITY" . #x0029dc)
    ("TIE OVER INFINITY" . #x0029dd)
    ("INFINITY NEGATED WITH VERTICAL BAR" . #x0029de)
    ("DOUBLE-ENDED MULTIMAP" . #x0029df)
    ("SQUARE WITH CONTOURED OUTLINE" . #x0029e0)
    ("INCREASES AS" . #x0029e1)
    ("SHUFFLE PRODUCT" . #x0029e2)
    ("EQUALS SIGN AND SLANTED PARALLEL" . #x0029e3)
    ("EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE" . #x0029e4)
    ("IDENTICAL TO AND SLANTED PARALLEL" . #x0029e5)
    ("GLEICH STARK" . #x0029e6)
    ("THERMODYNAMIC" . #x0029e7)
    ("DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK" . #x0029e8)
    ("DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK" . #x0029e9)
    ("BLACK DIAMOND WITH DOWN ARROW" . #x0029ea)
    ("BLACK LOZENGE" . #x0029eb)
    ("WHITE CIRCLE WITH DOWN ARROW" . #x0029ec)
    ("BLACK CIRCLE WITH DOWN ARROW" . #x0029ed)
    ("ERROR-BARRED WHITE SQUARE" . #x0029ee)
    ("ERROR-BARRED BLACK SQUARE" . #x0029ef)
    ("ERROR-BARRED WHITE DIAMOND" . #x0029f0)
    ("ERROR-BARRED BLACK DIAMOND" . #x0029f1)
    ("ERROR-BARRED WHITE CIRCLE" . #x0029f2)
    ("ERROR-BARRED BLACK CIRCLE" . #x0029f3)
    ("RULE-DELAYED" . #x0029f4)
    ("REVERSE SOLIDUS OPERATOR" . #x0029f5)
    ("SOLIDUS WITH OVERBAR" . #x0029f6)
    ("REVERSE SOLIDUS WITH HORIZONTAL STROKE" . #x0029f7)
    ("BIG SOLIDUS" . #x0029f8)
    ("BIG REVERSE SOLIDUS" . #x0029f9)
    ("DOUBLE PLUS" . #x0029fa)
    ("TRIPLE PLUS" . #x0029fb)
    ("LEFT-POINTING CURVED ANGLE BRACKET" . #x0029fc)
    ("RIGHT-POINTING CURVED ANGLE BRACKET" . #x0029fd)
    ("TINY" . #x0029fe)
    ("MINY" . #x0029ff)
    ("N-ARY CIRCLED DOT OPERATOR" . #x002a00)
    ("N-ARY CIRCLED PLUS OPERATOR" . #x002a01)
    ("N-ARY CIRCLED TIMES OPERATOR" . #x002a02)
    ("N-ARY UNION OPERATOR WITH DOT" . #x002a03)
    ("N-ARY UNION OPERATOR WITH PLUS" . #x002a04)
    ("N-ARY SQUARE INTERSECTION OPERATOR" . #x002a05)
    ("N-ARY SQUARE UNION OPERATOR" . #x002a06)
    ("TWO LOGICAL AND OPERATOR" . #x002a07)
    ("TWO LOGICAL OR OPERATOR" . #x002a08)
    ("N-ARY TIMES OPERATOR" . #x002a09)
    ("MODULO TWO SUM" . #x002a0a)
    ("SUMMATION WITH INTEGRAL" . #x002a0b)
    ("QUADRUPLE INTEGRAL OPERATOR" . #x002a0c)
    ("FINITE PART INTEGRAL" . #x002a0d)
    ("INTEGRAL WITH DOUBLE STROKE" . #x002a0e)
    ("INTEGRAL AVERAGE WITH SLASH" . #x002a0f)
    ("CIRCULATION FUNCTION" . #x002a10)
    ("ANTICLOCKWISE INTEGRATION" . #x002a11)
    ("LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE" . #x002a12)
    ("LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE" . #x002a13)
    ("LINE INTEGRATION NOT INCLUDING THE POLE" . #x002a14)
    ("INTEGRAL AROUND A POINT OPERATOR" . #x002a15)
    ("QUATERNION INTEGRAL OPERATOR" . #x002a16)
    ("INTEGRAL WITH LEFTWARDS ARROW WITH HOOK" . #x002a17)
    ("INTEGRAL WITH TIMES SIGN" . #x002a18)
    ("INTEGRAL WITH INTERSECTION" . #x002a19)
    ("INTEGRAL WITH UNION" . #x002a1a)
    ("INTEGRAL WITH OVERBAR" . #x002a1b)
    ("INTEGRAL WITH UNDERBAR" . #x002a1c)
    ("JOIN" . #x002a1d)
    ("LARGE LEFT TRIANGLE OPERATOR" . #x002a1e)
    ("Z NOTATION SCHEMA COMPOSITION" . #x002a1f)
    ("Z NOTATION SCHEMA PIPING" . #x002a20)
    ("Z NOTATION SCHEMA PROJECTION" . #x002a21)
    ("PLUS SIGN WITH SMALL CIRCLE ABOVE" . #x002a22)
    ("PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE" . #x002a23)
    ("PLUS SIGN WITH TILDE ABOVE" . #x002a24)
    ("PLUS SIGN WITH DOT BELOW" . #x002a25)
    ("PLUS SIGN WITH TILDE BELOW" . #x002a26)
    ("PLUS SIGN WITH SUBSCRIPT TWO" . #x002a27)
    ("PLUS SIGN WITH BLACK TRIANGLE" . #x002a28)
    ("MINUS SIGN WITH COMMA ABOVE" . #x002a29)
    ("MINUS SIGN WITH DOT BELOW" . #x002a2a)
    ("MINUS SIGN WITH FALLING DOTS" . #x002a2b)
    ("MINUS SIGN WITH RISING DOTS" . #x002a2c)
    ("PLUS SIGN IN LEFT HALF CIRCLE" . #x002a2d)
    ("PLUS SIGN IN RIGHT HALF CIRCLE" . #x002a2e)
    ("VECTOR OR CROSS PRODUCT" . #x002a2f)
    ("MULTIPLICATION SIGN WITH DOT ABOVE" . #x002a30)
    ("MULTIPLICATION SIGN WITH UNDERBAR" . #x002a31)
    ("SEMIDIRECT PRODUCT WITH BOTTOM CLOSED" . #x002a32)
    ("SMASH PRODUCT" . #x002a33)
    ("MULTIPLICATION SIGN IN LEFT HALF CIRCLE" . #x002a34)
    ("MULTIPLICATION SIGN IN RIGHT HALF CIRCLE" . #x002a35)
    ("CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT" . #x002a36)
    ("MULTIPLICATION SIGN IN DOUBLE CIRCLE" . #x002a37)
    ("CIRCLED DIVISION SIGN" . #x002a38)
    ("PLUS SIGN IN TRIANGLE" . #x002a39)
    ("MINUS SIGN IN TRIANGLE" . #x002a3a)
    ("MULTIPLICATION SIGN IN TRIANGLE" . #x002a3b)
    ("INTERIOR PRODUCT" . #x002a3c)
    ("RIGHTHAND INTERIOR PRODUCT" . #x002a3d)
    ("Z NOTATION RELATIONAL COMPOSITION" . #x002a3e)
    ("AMALGAMATION OR COPRODUCT" . #x002a3f)
    ("INTERSECTION WITH DOT" . #x002a40)
    ("UNION WITH MINUS SIGN" . #x002a41)
    ("UNION WITH OVERBAR" . #x002a42)
    ("INTERSECTION WITH OVERBAR" . #x002a43)
    ("INTERSECTION WITH LOGICAL AND" . #x002a44)
    ("UNION WITH LOGICAL OR" . #x002a45)
    ("UNION ABOVE INTERSECTION" . #x002a46)
    ("INTERSECTION ABOVE UNION" . #x002a47)
    ("UNION ABOVE BAR ABOVE INTERSECTION" . #x002a48)
    ("INTERSECTION ABOVE BAR ABOVE UNION" . #x002a49)
    ("UNION BESIDE AND JOINED WITH UNION" . #x002a4a)
    ("INTERSECTION BESIDE AND JOINED WITH INTERSECTION" . #x002a4b)
    ("CLOSED UNION WITH SERIFS" . #x002a4c)
    ("CLOSED INTERSECTION WITH SERIFS" . #x002a4d)
    ("DOUBLE SQUARE INTERSECTION" . #x002a4e)
    ("DOUBLE SQUARE UNION" . #x002a4f)
    ("CLOSED UNION WITH SERIFS AND SMASH PRODUCT" . #x002a50)
    ("LOGICAL AND WITH DOT ABOVE" . #x002a51)
    ("LOGICAL OR WITH DOT ABOVE" . #x002a52)
    ("DOUBLE LOGICAL AND" . #x002a53)
    ("DOUBLE LOGICAL OR" . #x002a54)
    ("TWO INTERSECTING LOGICAL AND" . #x002a55)
    ("TWO INTERSECTING LOGICAL OR" . #x002a56)
    ("SLOPING LARGE OR" . #x002a57)
    ("SLOPING LARGE AND" . #x002a58)
    ("LOGICAL OR OVERLAPPING LOGICAL AND" . #x002a59)
    ("LOGICAL AND WITH MIDDLE STEM" . #x002a5a)
    ("LOGICAL OR WITH MIDDLE STEM" . #x002a5b)
    ("LOGICAL AND WITH HORIZONTAL DASH" . #x002a5c)
    ("LOGICAL OR WITH HORIZONTAL DASH" . #x002a5d)
    ("LOGICAL AND WITH DOUBLE OVERBAR" . #x002a5e)
    ("LOGICAL AND WITH UNDERBAR" . #x002a5f)
    ("LOGICAL AND WITH DOUBLE UNDERBAR" . #x002a60)
    ("SMALL VEE WITH UNDERBAR" . #x002a61)
    ("LOGICAL OR WITH DOUBLE OVERBAR" . #x002a62)
    ("LOGICAL OR WITH DOUBLE UNDERBAR" . #x002a63)
    ("Z NOTATION DOMAIN ANTIRESTRICTION" . #x002a64)
    ("Z NOTATION RANGE ANTIRESTRICTION" . #x002a65)
    ("EQUALS SIGN WITH DOT BELOW" . #x002a66)
    ("IDENTICAL WITH DOT ABOVE" . #x002a67)
    ("TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE" . #x002a68)
    ("TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE" . #x002a69)
    ("TILDE OPERATOR WITH DOT ABOVE" . #x002a6a)
    ("TILDE OPERATOR WITH RISING DOTS" . #x002a6b)
    ("SIMILAR MINUS SIMILAR" . #x002a6c)
    ("CONGRUENT WITH DOT ABOVE" . #x002a6d)
    ("EQUALS WITH ASTERISK" . #x002a6e)
    ("ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT" . #x002a6f)
    ("APPROXIMATELY EQUAL OR EQUAL TO" . #x002a70)
    ("EQUALS SIGN ABOVE PLUS SIGN" . #x002a71)
    ("PLUS SIGN ABOVE EQUALS SIGN" . #x002a72)
    ("EQUALS SIGN ABOVE TILDE OPERATOR" . #x002a73)
    ("DOUBLE COLON EQUAL" . #x002a74)
    ("TWO CONSECUTIVE EQUALS SIGNS" . #x002a75)
    ("THREE CONSECUTIVE EQUALS SIGNS" . #x002a76)
    ("EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW" . #x002a77)
    ("EQUIVALENT WITH FOUR DOTS ABOVE" . #x002a78)
    ("LESS-THAN WITH CIRCLE INSIDE" . #x002a79)
    ("GREATER-THAN WITH CIRCLE INSIDE" . #x002a7a)
    ("LESS-THAN WITH QUESTION MARK ABOVE" . #x002a7b)
    ("GREATER-THAN WITH QUESTION MARK ABOVE" . #x002a7c)
    ("LESS-THAN OR SLANTED EQUAL TO" . #x002a7d)
    ("GREATER-THAN OR SLANTED EQUAL TO" . #x002a7e)
    ("LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE" . #x002a7f)
    ("GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE" . #x002a80)
    ("LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE" . #x002a81)
    ("GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE" . #x002a82)
    ("LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT" . #x002a83)
    ("GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT" . #x002a84)
    ("LESS-THAN OR APPROXIMATE" . #x002a85)
    ("GREATER-THAN OR APPROXIMATE" . #x002a86)
    ("LESS-THAN AND SINGLE-LINE NOT EQUAL TO" . #x002a87)
    ("GREATER-THAN AND SINGLE-LINE NOT EQUAL TO" . #x002a88)
    ("LESS-THAN AND NOT APPROXIMATE" . #x002a89)
    ("GREATER-THAN AND NOT APPROXIMATE" . #x002a8a)
    ("LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN" . #x002a8b)
    ("GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN" . #x002a8c)
    ("LESS-THAN ABOVE SIMILAR OR EQUAL" . #x002a8d)
    ("GREATER-THAN ABOVE SIMILAR OR EQUAL" . #x002a8e)
    ("LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN" . #x002a8f)
    ("GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN" . #x002a90)
    ("LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL" . #x002a91)
    ("GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL" . #x002a92)
    ("LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL" . #x002a93)
    ("GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL" . #x002a94)
    ("SLANTED EQUAL TO OR LESS-THAN" . #x002a95)
    ("SLANTED EQUAL TO OR GREATER-THAN" . #x002a96)
    ("SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE" . #x002a97)
    ("SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE" . #x002a98)
    ("DOUBLE-LINE EQUAL TO OR LESS-THAN" . #x002a99)
    ("DOUBLE-LINE EQUAL TO OR GREATER-THAN" . #x002a9a)
    ("DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN" . #x002a9b)
    ("DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN" . #x002a9c)
    ("SIMILAR OR LESS-THAN" . #x002a9d)
    ("SIMILAR OR GREATER-THAN" . #x002a9e)
    ("SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN" . #x002a9f)
    ("SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN" . #x002aa0)
    ("DOUBLE NESTED LESS-THAN" . #x002aa1)
    ("DOUBLE NESTED GREATER-THAN" . #x002aa2)
    ("DOUBLE NESTED LESS-THAN WITH UNDERBAR" . #x002aa3)
    ("GREATER-THAN OVERLAPPING LESS-THAN" . #x002aa4)
    ("GREATER-THAN BESIDE LESS-THAN" . #x002aa5)
    ("LESS-THAN CLOSED BY CURVE" . #x002aa6)
    ("GREATER-THAN CLOSED BY CURVE" . #x002aa7)
    ("LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL" . #x002aa8)
    ("GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL" . #x002aa9)
    ("SMALLER THAN" . #x002aaa)
    ("LARGER THAN" . #x002aab)
    ("SMALLER THAN OR EQUAL TO" . #x002aac)
    ("LARGER THAN OR EQUAL TO" . #x002aad)
    ("EQUALS SIGN WITH BUMPY ABOVE" . #x002aae)
    ("PRECEDES ABOVE SINGLE-LINE EQUALS SIGN" . #x002aaf)
    ("SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN" . #x002ab0)
    ("PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO" . #x002ab1)
    ("SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO" . #x002ab2)
    ("PRECEDES ABOVE EQUALS SIGN" . #x002ab3)
    ("SUCCEEDS ABOVE EQUALS SIGN" . #x002ab4)
    ("PRECEDES ABOVE NOT EQUAL TO" . #x002ab5)
    ("SUCCEEDS ABOVE NOT EQUAL TO" . #x002ab6)
    ("PRECEDES ABOVE ALMOST EQUAL TO" . #x002ab7)
    ("SUCCEEDS ABOVE ALMOST EQUAL TO" . #x002ab8)
    ("PRECEDES ABOVE NOT ALMOST EQUAL TO" . #x002ab9)
    ("SUCCEEDS ABOVE NOT ALMOST EQUAL TO" . #x002aba)
    ("DOUBLE PRECEDES" . #x002abb)
    ("DOUBLE SUCCEEDS" . #x002abc)
    ("SUBSET WITH DOT" . #x002abd)
    ("SUPERSET WITH DOT" . #x002abe)
    ("SUBSET WITH PLUS SIGN BELOW" . #x002abf)
    ("SUPERSET WITH PLUS SIGN BELOW" . #x002ac0)
    ("SUBSET WITH MULTIPLICATION SIGN BELOW" . #x002ac1)
    ("SUPERSET WITH MULTIPLICATION SIGN BELOW" . #x002ac2)
    ("SUBSET OF OR EQUAL TO WITH DOT ABOVE" . #x002ac3)
    ("SUPERSET OF OR EQUAL TO WITH DOT ABOVE" . #x002ac4)
    ("SUBSET OF ABOVE EQUALS SIGN" . #x002ac5)
    ("SUPERSET OF ABOVE EQUALS SIGN" . #x002ac6)
    ("SUBSET OF ABOVE TILDE OPERATOR" . #x002ac7)
    ("SUPERSET OF ABOVE TILDE OPERATOR" . #x002ac8)
    ("SUBSET OF ABOVE ALMOST EQUAL TO" . #x002ac9)
    ("SUPERSET OF ABOVE ALMOST EQUAL TO" . #x002aca)
    ("SUBSET OF ABOVE NOT EQUAL TO" . #x002acb)
    ("SUPERSET OF ABOVE NOT EQUAL TO" . #x002acc)
    ("SQUARE LEFT OPEN BOX OPERATOR" . #x002acd)
    ("SQUARE RIGHT OPEN BOX OPERATOR" . #x002ace)
    ("CLOSED SUBSET" . #x002acf)
    ("CLOSED SUPERSET" . #x002ad0)
    ("CLOSED SUBSET OR EQUAL TO" . #x002ad1)
    ("CLOSED SUPERSET OR EQUAL TO" . #x002ad2)
    ("SUBSET ABOVE SUPERSET" . #x002ad3)
    ("SUPERSET ABOVE SUBSET" . #x002ad4)
    ("SUBSET ABOVE SUBSET" . #x002ad5)
    ("SUPERSET ABOVE SUPERSET" . #x002ad6)
    ("SUPERSET BESIDE SUBSET" . #x002ad7)
    ("SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET" . #x002ad8)
    ("ELEMENT OF OPENING DOWNWARDS" . #x002ad9)
    ("PITCHFORK WITH TEE TOP" . #x002ada)
    ("TRANSVERSAL INTERSECTION" . #x002adb)
    ("FORKING" . #x002adc)
    ("NONFORKING" . #x002add)
    ("SHORT LEFT TACK" . #x002ade)
    ("SHORT DOWN TACK" . #x002adf)
    ("SHORT UP TACK" . #x002ae0)
    ("PERPENDICULAR WITH S" . #x002ae1)
    ("VERTICAL BAR TRIPLE RIGHT TURNSTILE" . #x002ae2)
    ("DOUBLE VERTICAL BAR LEFT TURNSTILE" . #x002ae3)
    ("VERTICAL BAR DOUBLE LEFT TURNSTILE" . #x002ae4)
    ("DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE" . #x002ae5)
    ("LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL" . #x002ae6)
    ("SHORT DOWN TACK WITH OVERBAR" . #x002ae7)
    ("SHORT UP TACK WITH UNDERBAR" . #x002ae8)
    ("SHORT UP TACK ABOVE SHORT DOWN TACK" . #x002ae9)
    ("DOUBLE DOWN TACK" . #x002aea)
    ("DOUBLE UP TACK" . #x002aeb)
    ("DOUBLE STROKE NOT SIGN" . #x002aec)
    ("REVERSED DOUBLE STROKE NOT SIGN" . #x002aed)
    ("DOES NOT DIVIDE WITH REVERSED NEGATION SLASH" . #x002aee)
    ("VERTICAL LINE WITH CIRCLE ABOVE" . #x002aef)
    ("VERTICAL LINE WITH CIRCLE BELOW" . #x002af0)
    ("DOWN TACK WITH CIRCLE BELOW" . #x002af1)
    ("PARALLEL WITH HORIZONTAL STROKE" . #x002af2)
    ("PARALLEL WITH TILDE OPERATOR" . #x002af3)
    ("TRIPLE VERTICAL BAR BINARY RELATION" . #x002af4)
    ("TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE" . #x002af5)
    ("TRIPLE COLON OPERATOR" . #x002af6)
    ("TRIPLE NESTED LESS-THAN" . #x002af7)
    ("TRIPLE NESTED GREATER-THAN" . #x002af8)
    ("DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO" . #x002af9)
    ("DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO" . #x002afa)
    ("TRIPLE SOLIDUS BINARY RELATION" . #x002afb)
    ("LARGE TRIPLE VERTICAL BAR OPERATOR" . #x002afc)
    ("DOUBLE SOLIDUS OPERATOR" . #x002afd)
    ("WHITE VERTICAL BAR" . #x002afe)
    ("N-ARY WHITE VERTICAL BAR" . #x002aff)
    ("IDEOGRAPHIC SPACE" . #x003000)
    ("IDEOGRAPHIC COMMA" . #x003001)
    ("IDEOGRAPHIC FULL STOP" . #x003002)
    ("DITTO MARK" . #x003003)
    ("JAPANESE INDUSTRIAL STANDARD SYMBOL" . #x003004)
    ("IDEOGRAPHIC ITERATION MARK" . #x003005)
    ("IDEOGRAPHIC CLOSING MARK" . #x003006)
    ("IDEOGRAPHIC NUMBER ZERO" . #x003007)
    ("LEFT ANGLE BRACKET" . #x003008)
    ("RIGHT ANGLE BRACKET" . #x003009)
    ("LEFT DOUBLE ANGLE BRACKET" . #x00300a)
    ("RIGHT DOUBLE ANGLE BRACKET" . #x00300b)
    ("LEFT CORNER BRACKET" . #x00300c)
    ("RIGHT CORNER BRACKET" . #x00300d)
    ("LEFT WHITE CORNER BRACKET" . #x00300e)
    ("RIGHT WHITE CORNER BRACKET" . #x00300f)
    ("LEFT BLACK LENTICULAR BRACKET" . #x003010)
    ("RIGHT BLACK LENTICULAR BRACKET" . #x003011)
    ("POSTAL MARK" . #x003012)
    ("GETA MARK" . #x003013)
    ("LEFT TORTOISE SHELL BRACKET" . #x003014)
    ("RIGHT TORTOISE SHELL BRACKET" . #x003015)
    ("LEFT WHITE LENTICULAR BRACKET" . #x003016)
    ("RIGHT WHITE LENTICULAR BRACKET" . #x003017)
    ("LEFT WHITE TORTOISE SHELL BRACKET" . #x003018)
    ("RIGHT WHITE TORTOISE SHELL BRACKET" . #x003019)
    ("LEFT WHITE SQUARE BRACKET" . #x00301a)
    ("RIGHT WHITE SQUARE BRACKET" . #x00301b)
    ("WAVE DASH" . #x00301c)
    ("REVERSED DOUBLE PRIME QUOTATION MARK" . #x00301d)
    ("DOUBLE PRIME QUOTATION MARK" . #x00301e)
    ("LOW DOUBLE PRIME QUOTATION MARK" . #x00301f)
    ("POSTAL MARK FACE" . #x003020)
    ("HANGZHOU NUMERAL ONE" . #x003021)
    ("HANGZHOU NUMERAL TWO" . #x003022)
    ("HANGZHOU NUMERAL THREE" . #x003023)
    ("HANGZHOU NUMERAL FOUR" . #x003024)
    ("HANGZHOU NUMERAL FIVE" . #x003025)
    ("HANGZHOU NUMERAL SIX" . #x003026)
    ("HANGZHOU NUMERAL SEVEN" . #x003027)
    ("HANGZHOU NUMERAL EIGHT" . #x003028)
    ("HANGZHOU NUMERAL NINE" . #x003029)
    ("IDEOGRAPHIC LEVEL TONE MARK" . #x00302a)
    ("IDEOGRAPHIC RISING TONE MARK" . #x00302b)
    ("IDEOGRAPHIC DEPARTING TONE MARK" . #x00302c)
    ("IDEOGRAPHIC ENTERING TONE MARK" . #x00302d)
    ("HANGUL SINGLE DOT TONE MARK" . #x00302e)
    ("HANGUL DOUBLE DOT TONE MARK" . #x00302f)
    ("WAVY DASH" . #x003030)
    ("VERTICAL KANA REPEAT MARK" . #x003031)
    ("VERTICAL KANA REPEAT WITH VOICED SOUND MARK" . #x003032)
    ("VERTICAL KANA REPEAT MARK UPPER HALF" . #x003033)
    ("VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF" . #x003034)
    ("VERTICAL KANA REPEAT MARK LOWER HALF" . #x003035)
    ("CIRCLED POSTAL MARK" . #x003036)
    ("IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL" . #x003037)
    ("HANGZHOU NUMERAL TEN" . #x003038)
    ("HANGZHOU NUMERAL TWENTY" . #x003039)
    ("HANGZHOU NUMERAL THIRTY" . #x00303a)
    ("VERTICAL IDEOGRAPHIC ITERATION MARK" . #x00303b)
    ("MASU MARK" . #x00303c)
    ("PART ALTERNATION MARK" . #x00303d)
    ("IDEOGRAPHIC VARIATION INDICATOR" . #x00303e)
    ("IDEOGRAPHIC HALF FILL SPACE" . #x00303f)
    ("HIRAGANA LETTER SMALL A" . #x003041)
    ("HIRAGANA LETTER A" . #x003042)
    ("HIRAGANA LETTER SMALL I" . #x003043)
    ("HIRAGANA LETTER I" . #x003044)
    ("HIRAGANA LETTER SMALL U" . #x003045)
    ("HIRAGANA LETTER U" . #x003046)
    ("HIRAGANA LETTER SMALL E" . #x003047)
    ("HIRAGANA LETTER E" . #x003048)
    ("HIRAGANA LETTER SMALL O" . #x003049)
    ("HIRAGANA LETTER O" . #x00304a)
    ("HIRAGANA LETTER KA" . #x00304b)
    ("HIRAGANA LETTER GA" . #x00304c)
    ("HIRAGANA LETTER KI" . #x00304d)
    ("HIRAGANA LETTER GI" . #x00304e)
    ("HIRAGANA LETTER KU" . #x00304f)
    ("HIRAGANA LETTER GU" . #x003050)
    ("HIRAGANA LETTER KE" . #x003051)
    ("HIRAGANA LETTER GE" . #x003052)
    ("HIRAGANA LETTER KO" . #x003053)
    ("HIRAGANA LETTER GO" . #x003054)
    ("HIRAGANA LETTER SA" . #x003055)
    ("HIRAGANA LETTER ZA" . #x003056)
    ("HIRAGANA LETTER SI" . #x003057)
    ("HIRAGANA LETTER ZI" . #x003058)
    ("HIRAGANA LETTER SU" . #x003059)
    ("HIRAGANA LETTER ZU" . #x00305a)
    ("HIRAGANA LETTER SE" . #x00305b)
    ("HIRAGANA LETTER ZE" . #x00305c)
    ("HIRAGANA LETTER SO" . #x00305d)
    ("HIRAGANA LETTER ZO" . #x00305e)
    ("HIRAGANA LETTER TA" . #x00305f)
    ("HIRAGANA LETTER DA" . #x003060)
    ("HIRAGANA LETTER TI" . #x003061)
    ("HIRAGANA LETTER DI" . #x003062)
    ("HIRAGANA LETTER SMALL TU" . #x003063)
    ("HIRAGANA LETTER TU" . #x003064)
    ("HIRAGANA LETTER DU" . #x003065)
    ("HIRAGANA LETTER TE" . #x003066)
    ("HIRAGANA LETTER DE" . #x003067)
    ("HIRAGANA LETTER TO" . #x003068)
    ("HIRAGANA LETTER DO" . #x003069)
    ("HIRAGANA LETTER NA" . #x00306a)
    ("HIRAGANA LETTER NI" . #x00306b)
    ("HIRAGANA LETTER NU" . #x00306c)
    ("HIRAGANA LETTER NE" . #x00306d)
    ("HIRAGANA LETTER NO" . #x00306e)
    ("HIRAGANA LETTER HA" . #x00306f)
    ("HIRAGANA LETTER BA" . #x003070)
    ("HIRAGANA LETTER PA" . #x003071)
    ("HIRAGANA LETTER HI" . #x003072)
    ("HIRAGANA LETTER BI" . #x003073)
    ("HIRAGANA LETTER PI" . #x003074)
    ("HIRAGANA LETTER HU" . #x003075)
    ("HIRAGANA LETTER BU" . #x003076)
    ("HIRAGANA LETTER PU" . #x003077)
    ("HIRAGANA LETTER HE" . #x003078)
    ("HIRAGANA LETTER BE" . #x003079)
    ("HIRAGANA LETTER PE" . #x00307a)
    ("HIRAGANA LETTER HO" . #x00307b)
    ("HIRAGANA LETTER BO" . #x00307c)
    ("HIRAGANA LETTER PO" . #x00307d)
    ("HIRAGANA LETTER MA" . #x00307e)
    ("HIRAGANA LETTER MI" . #x00307f)
    ("HIRAGANA LETTER MU" . #x003080)
    ("HIRAGANA LETTER ME" . #x003081)
    ("HIRAGANA LETTER MO" . #x003082)
    ("HIRAGANA LETTER SMALL YA" . #x003083)
    ("HIRAGANA LETTER YA" . #x003084)
    ("HIRAGANA LETTER SMALL YU" . #x003085)
    ("HIRAGANA LETTER YU" . #x003086)
    ("HIRAGANA LETTER SMALL YO" . #x003087)
    ("HIRAGANA LETTER YO" . #x003088)
    ("HIRAGANA LETTER RA" . #x003089)
    ("HIRAGANA LETTER RI" . #x00308a)
    ("HIRAGANA LETTER RU" . #x00308b)
    ("HIRAGANA LETTER RE" . #x00308c)
    ("HIRAGANA LETTER RO" . #x00308d)
    ("HIRAGANA LETTER SMALL WA" . #x00308e)
    ("HIRAGANA LETTER WA" . #x00308f)
    ("HIRAGANA LETTER WI" . #x003090)
    ("HIRAGANA LETTER WE" . #x003091)
    ("HIRAGANA LETTER WO" . #x003092)
    ("HIRAGANA LETTER N" . #x003093)
    ("HIRAGANA LETTER VU" . #x003094)
    ("HIRAGANA LETTER SMALL KA" . #x003095)
    ("HIRAGANA LETTER SMALL KE" . #x003096)
    ("COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK" . #x003099)
    ("COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" . #x00309a)
    ("KATAKANA-HIRAGANA VOICED SOUND MARK" . #x00309b)
    ("KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" . #x00309c)
    ("HIRAGANA ITERATION MARK" . #x00309d)
    ("HIRAGANA VOICED ITERATION MARK" . #x00309e)
    ("HIRAGANA DIGRAPH YORI" . #x00309f)
    ("KATAKANA-HIRAGANA DOUBLE HYPHEN" . #x0030a0)
    ("KATAKANA LETTER SMALL A" . #x0030a1)
    ("KATAKANA LETTER A" . #x0030a2)
    ("KATAKANA LETTER SMALL I" . #x0030a3)
    ("KATAKANA LETTER I" . #x0030a4)
    ("KATAKANA LETTER SMALL U" . #x0030a5)
    ("KATAKANA LETTER U" . #x0030a6)
    ("KATAKANA LETTER SMALL E" . #x0030a7)
    ("KATAKANA LETTER E" . #x0030a8)
    ("KATAKANA LETTER SMALL O" . #x0030a9)
    ("KATAKANA LETTER O" . #x0030aa)
    ("KATAKANA LETTER KA" . #x0030ab)
    ("KATAKANA LETTER GA" . #x0030ac)
    ("KATAKANA LETTER KI" . #x0030ad)
    ("KATAKANA LETTER GI" . #x0030ae)
    ("KATAKANA LETTER KU" . #x0030af)
    ("KATAKANA LETTER GU" . #x0030b0)
    ("KATAKANA LETTER KE" . #x0030b1)
    ("KATAKANA LETTER GE" . #x0030b2)
    ("KATAKANA LETTER KO" . #x0030b3)
    ("KATAKANA LETTER GO" . #x0030b4)
    ("KATAKANA LETTER SA" . #x0030b5)
    ("KATAKANA LETTER ZA" . #x0030b6)
    ("KATAKANA LETTER SI" . #x0030b7)
    ("KATAKANA LETTER ZI" . #x0030b8)
    ("KATAKANA LETTER SU" . #x0030b9)
    ("KATAKANA LETTER ZU" . #x0030ba)
    ("KATAKANA LETTER SE" . #x0030bb)
    ("KATAKANA LETTER ZE" . #x0030bc)
    ("KATAKANA LETTER SO" . #x0030bd)
    ("KATAKANA LETTER ZO" . #x0030be)
    ("KATAKANA LETTER TA" . #x0030bf)
    ("KATAKANA LETTER DA" . #x0030c0)
    ("KATAKANA LETTER TI" . #x0030c1)
    ("KATAKANA LETTER DI" . #x0030c2)
    ("KATAKANA LETTER SMALL TU" . #x0030c3)
    ("KATAKANA LETTER TU" . #x0030c4)
    ("KATAKANA LETTER DU" . #x0030c5)
    ("KATAKANA LETTER TE" . #x0030c6)
    ("KATAKANA LETTER DE" . #x0030c7)
    ("KATAKANA LETTER TO" . #x0030c8)
    ("KATAKANA LETTER DO" . #x0030c9)
    ("KATAKANA LETTER NA" . #x0030ca)
    ("KATAKANA LETTER NI" . #x0030cb)
    ("KATAKANA LETTER NU" . #x0030cc)
    ("KATAKANA LETTER NE" . #x0030cd)
    ("KATAKANA LETTER NO" . #x0030ce)
    ("KATAKANA LETTER HA" . #x0030cf)
    ("KATAKANA LETTER BA" . #x0030d0)
    ("KATAKANA LETTER PA" . #x0030d1)
    ("KATAKANA LETTER HI" . #x0030d2)
    ("KATAKANA LETTER BI" . #x0030d3)
    ("KATAKANA LETTER PI" . #x0030d4)
    ("KATAKANA LETTER HU" . #x0030d5)
    ("KATAKANA LETTER BU" . #x0030d6)
    ("KATAKANA LETTER PU" . #x0030d7)
    ("KATAKANA LETTER HE" . #x0030d8)
    ("KATAKANA LETTER BE" . #x0030d9)
    ("KATAKANA LETTER PE" . #x0030da)
    ("KATAKANA LETTER HO" . #x0030db)
    ("KATAKANA LETTER BO" . #x0030dc)
    ("KATAKANA LETTER PO" . #x0030dd)
    ("KATAKANA LETTER MA" . #x0030de)
    ("KATAKANA LETTER MI" . #x0030df)
    ("KATAKANA LETTER MU" . #x0030e0)
    ("KATAKANA LETTER ME" . #x0030e1)
    ("KATAKANA LETTER MO" . #x0030e2)
    ("KATAKANA LETTER SMALL YA" . #x0030e3)
    ("KATAKANA LETTER YA" . #x0030e4)
    ("KATAKANA LETTER SMALL YU" . #x0030e5)
    ("KATAKANA LETTER YU" . #x0030e6)
    ("KATAKANA LETTER SMALL YO" . #x0030e7)
    ("KATAKANA LETTER YO" . #x0030e8)
    ("KATAKANA LETTER RA" . #x0030e9)
    ("KATAKANA LETTER RI" . #x0030ea)
    ("KATAKANA LETTER RU" . #x0030eb)
    ("KATAKANA LETTER RE" . #x0030ec)
    ("KATAKANA LETTER RO" . #x0030ed)
    ("KATAKANA LETTER SMALL WA" . #x0030ee)
    ("KATAKANA LETTER WA" . #x0030ef)
    ("KATAKANA LETTER WI" . #x0030f0)
    ("KATAKANA LETTER WE" . #x0030f1)
    ("KATAKANA LETTER WO" . #x0030f2)
    ("KATAKANA LETTER N" . #x0030f3)
    ("KATAKANA LETTER VU" . #x0030f4)
    ("KATAKANA LETTER SMALL KA" . #x0030f5)
    ("KATAKANA LETTER SMALL KE" . #x0030f6)
    ("KATAKANA LETTER VA" . #x0030f7)
    ("KATAKANA LETTER VI" . #x0030f8)
    ("KATAKANA LETTER VE" . #x0030f9)
    ("KATAKANA LETTER VO" . #x0030fa)
    ("KATAKANA MIDDLE DOT" . #x0030fb)
    ("KATAKANA-HIRAGANA PROLONGED SOUND MARK" . #x0030fc)
    ("KATAKANA ITERATION MARK" . #x0030fd)
    ("KATAKANA VOICED ITERATION MARK" . #x0030fe)
    ("KATAKANA DIGRAPH KOTO" . #x0030ff)
    ("LATIN SMALL LIGATURE FF" . #x00fb00)
    ("LATIN SMALL LIGATURE FI" . #x00fb01)
    ("LATIN SMALL LIGATURE FL" . #x00fb02)
    ("LATIN SMALL LIGATURE FFI" . #x00fb03)
    ("LATIN SMALL LIGATURE FFL" . #x00fb04)
    ("LATIN SMALL LIGATURE LONG S T" . #x00fb05)
    ("LATIN SMALL LIGATURE ST" . #x00fb06)
    ("ARMENIAN SMALL LIGATURE MEN NOW" . #x00fb13)
    ("ARMENIAN SMALL LIGATURE MEN ECH" . #x00fb14)
    ("ARMENIAN SMALL LIGATURE MEN INI" . #x00fb15)
    ("ARMENIAN SMALL LIGATURE VEW NOW" . #x00fb16)
    ("ARMENIAN SMALL LIGATURE MEN XEH" . #x00fb17)
    ("HEBREW LETTER YOD WITH HIRIQ" . #x00fb1d)
    ("HEBREW POINT JUDEO-SPANISH VARIKA" . #x00fb1e)
    ("HEBREW LIGATURE YIDDISH YOD YOD PATAH" . #x00fb1f)
    ("HEBREW LETTER ALTERNATIVE AYIN" . #x00fb20)
    ("HEBREW LETTER WIDE ALEF" . #x00fb21)
    ("HEBREW LETTER WIDE DALET" . #x00fb22)
    ("HEBREW LETTER WIDE HE" . #x00fb23)
    ("HEBREW LETTER WIDE KAF" . #x00fb24)
    ("HEBREW LETTER WIDE LAMED" . #x00fb25)
    ("HEBREW LETTER WIDE FINAL MEM" . #x00fb26)
    ("HEBREW LETTER WIDE RESH" . #x00fb27)
    ("HEBREW LETTER WIDE TAV" . #x00fb28)
    ("HEBREW LETTER ALTERNATIVE PLUS SIGN" . #x00fb29)
    ("HEBREW LETTER SHIN WITH SHIN DOT" . #x00fb2a)
    ("HEBREW LETTER SHIN WITH SIN DOT" . #x00fb2b)
    ("HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT" . #x00fb2c)
    ("HEBREW LETTER SHIN WITH DAGESH AND SIN DOT" . #x00fb2d)
    ("HEBREW LETTER ALEF WITH PATAH" . #x00fb2e)
    ("HEBREW LETTER ALEF WITH QAMATS" . #x00fb2f)
    ("HEBREW LETTER ALEF WITH MAPIQ" . #x00fb30)
    ("HEBREW LETTER BET WITH DAGESH" . #x00fb31)
    ("HEBREW LETTER GIMEL WITH DAGESH" . #x00fb32)
    ("HEBREW LETTER DALET WITH DAGESH" . #x00fb33)
    ("HEBREW LETTER HE WITH MAPIQ" . #x00fb34)
    ("HEBREW LETTER VAV WITH DAGESH" . #x00fb35)
    ("HEBREW LETTER ZAYIN WITH DAGESH" . #x00fb36)
    ("HEBREW LETTER TET WITH DAGESH" . #x00fb38)
    ("HEBREW LETTER YOD WITH DAGESH" . #x00fb39)
    ("HEBREW LETTER FINAL KAF WITH DAGESH" . #x00fb3a)
    ("HEBREW LETTER KAF WITH DAGESH" . #x00fb3b)
    ("HEBREW LETTER LAMED WITH DAGESH" . #x00fb3c)
    ("HEBREW LETTER MEM WITH DAGESH" . #x00fb3e)
    ("HEBREW LETTER NUN WITH DAGESH" . #x00fb40)
    ("HEBREW LETTER SAMEKH WITH DAGESH" . #x00fb41)
    ("HEBREW LETTER FINAL PE WITH DAGESH" . #x00fb43)
    ("HEBREW LETTER PE WITH DAGESH" . #x00fb44)
    ("HEBREW LETTER TSADI WITH DAGESH" . #x00fb46)
    ("HEBREW LETTER QOF WITH DAGESH" . #x00fb47)
    ("HEBREW LETTER RESH WITH DAGESH" . #x00fb48)
    ("HEBREW LETTER SHIN WITH DAGESH" . #x00fb49)
    ("HEBREW LETTER TAV WITH DAGESH" . #x00fb4a)
    ("HEBREW LETTER VAV WITH HOLAM" . #x00fb4b)
    ("HEBREW LETTER BET WITH RAFE" . #x00fb4c)
    ("HEBREW LETTER KAF WITH RAFE" . #x00fb4d)
    ("HEBREW LETTER PE WITH RAFE" . #x00fb4e)
    ("HEBREW LIGATURE ALEF LAMED" . #x00fb4f)
    ("ARABIC LETTER ALEF WASLA ISOLATED FORM" . #x00fb50)
    ("ARABIC LETTER ALEF WASLA FINAL FORM" . #x00fb51)
    ("ARABIC LETTER BEEH ISOLATED FORM" . #x00fb52)
    ("ARABIC LETTER BEEH FINAL FORM" . #x00fb53)
    ("ARABIC LETTER BEEH INITIAL FORM" . #x00fb54)
    ("ARABIC LETTER BEEH MEDIAL FORM" . #x00fb55)
    ("ARABIC LETTER PEH ISOLATED FORM" . #x00fb56)
    ("ARABIC LETTER PEH FINAL FORM" . #x00fb57)
    ("ARABIC LETTER PEH INITIAL FORM" . #x00fb58)
    ("ARABIC LETTER PEH MEDIAL FORM" . #x00fb59)
    ("ARABIC LETTER BEHEH ISOLATED FORM" . #x00fb5a)
    ("ARABIC LETTER BEHEH FINAL FORM" . #x00fb5b)
    ("ARABIC LETTER BEHEH INITIAL FORM" . #x00fb5c)
    ("ARABIC LETTER BEHEH MEDIAL FORM" . #x00fb5d)
    ("ARABIC LETTER TTEHEH ISOLATED FORM" . #x00fb5e)
    ("ARABIC LETTER TTEHEH FINAL FORM" . #x00fb5f)
    ("ARABIC LETTER TTEHEH INITIAL FORM" . #x00fb60)
    ("ARABIC LETTER TTEHEH MEDIAL FORM" . #x00fb61)
    ("ARABIC LETTER TEHEH ISOLATED FORM" . #x00fb62)
    ("ARABIC LETTER TEHEH FINAL FORM" . #x00fb63)
    ("ARABIC LETTER TEHEH INITIAL FORM" . #x00fb64)
    ("ARABIC LETTER TEHEH MEDIAL FORM" . #x00fb65)
    ("ARABIC LETTER TTEH ISOLATED FORM" . #x00fb66)
    ("ARABIC LETTER TTEH FINAL FORM" . #x00fb67)
    ("ARABIC LETTER TTEH INITIAL FORM" . #x00fb68)
    ("ARABIC LETTER TTEH MEDIAL FORM" . #x00fb69)
    ("ARABIC LETTER VEH ISOLATED FORM" . #x00fb6a)
    ("ARABIC LETTER VEH FINAL FORM" . #x00fb6b)
    ("ARABIC LETTER VEH INITIAL FORM" . #x00fb6c)
    ("ARABIC LETTER VEH MEDIAL FORM" . #x00fb6d)
    ("ARABIC LETTER PEHEH ISOLATED FORM" . #x00fb6e)
    ("ARABIC LETTER PEHEH FINAL FORM" . #x00fb6f)
    ("ARABIC LETTER PEHEH INITIAL FORM" . #x00fb70)
    ("ARABIC LETTER PEHEH MEDIAL FORM" . #x00fb71)
    ("ARABIC LETTER DYEH ISOLATED FORM" . #x00fb72)
    ("ARABIC LETTER DYEH FINAL FORM" . #x00fb73)
    ("ARABIC LETTER DYEH INITIAL FORM" . #x00fb74)
    ("ARABIC LETTER DYEH MEDIAL FORM" . #x00fb75)
    ("ARABIC LETTER NYEH ISOLATED FORM" . #x00fb76)
    ("ARABIC LETTER NYEH FINAL FORM" . #x00fb77)
    ("ARABIC LETTER NYEH INITIAL FORM" . #x00fb78)
    ("ARABIC LETTER NYEH MEDIAL FORM" . #x00fb79)
    ("ARABIC LETTER TCHEH ISOLATED FORM" . #x00fb7a)
    ("ARABIC LETTER TCHEH FINAL FORM" . #x00fb7b)
    ("ARABIC LETTER TCHEH INITIAL FORM" . #x00fb7c)
    ("ARABIC LETTER TCHEH MEDIAL FORM" . #x00fb7d)
    ("ARABIC LETTER TCHEHEH ISOLATED FORM" . #x00fb7e)
    ("ARABIC LETTER TCHEHEH FINAL FORM" . #x00fb7f)
    ("ARABIC LETTER TCHEHEH INITIAL FORM" . #x00fb80)
    ("ARABIC LETTER TCHEHEH MEDIAL FORM" . #x00fb81)
    ("ARABIC LETTER DDAHAL ISOLATED FORM" . #x00fb82)
    ("ARABIC LETTER DDAHAL FINAL FORM" . #x00fb83)
    ("ARABIC LETTER DAHAL ISOLATED FORM" . #x00fb84)
    ("ARABIC LETTER DAHAL FINAL FORM" . #x00fb85)
    ("ARABIC LETTER DUL ISOLATED FORM" . #x00fb86)
    ("ARABIC LETTER DUL FINAL FORM" . #x00fb87)
    ("ARABIC LETTER DDAL ISOLATED FORM" . #x00fb88)
    ("ARABIC LETTER DDAL FINAL FORM" . #x00fb89)
    ("ARABIC LETTER JEH ISOLATED FORM" . #x00fb8a)
    ("ARABIC LETTER JEH FINAL FORM" . #x00fb8b)
    ("ARABIC LETTER RREH ISOLATED FORM" . #x00fb8c)
    ("ARABIC LETTER RREH FINAL FORM" . #x00fb8d)
    ("ARABIC LETTER KEHEH ISOLATED FORM" . #x00fb8e)
    ("ARABIC LETTER KEHEH FINAL FORM" . #x00fb8f)
    ("ARABIC LETTER KEHEH INITIAL FORM" . #x00fb90)
    ("ARABIC LETTER KEHEH MEDIAL FORM" . #x00fb91)
    ("ARABIC LETTER GAF ISOLATED FORM" . #x00fb92)
    ("ARABIC LETTER GAF FINAL FORM" . #x00fb93)
    ("ARABIC LETTER GAF INITIAL FORM" . #x00fb94)
    ("ARABIC LETTER GAF MEDIAL FORM" . #x00fb95)
    ("ARABIC LETTER GUEH ISOLATED FORM" . #x00fb96)
    ("ARABIC LETTER GUEH FINAL FORM" . #x00fb97)
    ("ARABIC LETTER GUEH INITIAL FORM" . #x00fb98)
    ("ARABIC LETTER GUEH MEDIAL FORM" . #x00fb99)
    ("ARABIC LETTER NGOEH ISOLATED FORM" . #x00fb9a)
    ("ARABIC LETTER NGOEH FINAL FORM" . #x00fb9b)
    ("ARABIC LETTER NGOEH INITIAL FORM" . #x00fb9c)
    ("ARABIC LETTER NGOEH MEDIAL FORM" . #x00fb9d)
    ("ARABIC LETTER NOON GHUNNA ISOLATED FORM" . #x00fb9e)
    ("ARABIC LETTER NOON GHUNNA FINAL FORM" . #x00fb9f)
    ("ARABIC LETTER RNOON ISOLATED FORM" . #x00fba0)
    ("ARABIC LETTER RNOON FINAL FORM" . #x00fba1)
    ("ARABIC LETTER RNOON INITIAL FORM" . #x00fba2)
    ("ARABIC LETTER RNOON MEDIAL FORM" . #x00fba3)
    ("ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM" . #x00fba4)
    ("ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM" . #x00fba5)
    ("ARABIC LETTER HEH GOAL ISOLATED FORM" . #x00fba6)
    ("ARABIC LETTER HEH GOAL FINAL FORM" . #x00fba7)
    ("ARABIC LETTER HEH GOAL INITIAL FORM" . #x00fba8)
    ("ARABIC LETTER HEH GOAL MEDIAL FORM" . #x00fba9)
    ("ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM" . #x00fbaa)
    ("ARABIC LETTER HEH DOACHASHMEE FINAL FORM" . #x00fbab)
    ("ARABIC LETTER HEH DOACHASHMEE INITIAL FORM" . #x00fbac)
    ("ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM" . #x00fbad)
    ("ARABIC LETTER YEH BARREE ISOLATED FORM" . #x00fbae)
    ("ARABIC LETTER YEH BARREE FINAL FORM" . #x00fbaf)
    ("ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM" . #x00fbb0)
    ("ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM" . #x00fbb1)
    ("ARABIC LETTER NG ISOLATED FORM" . #x00fbd3)
    ("ARABIC LETTER NG FINAL FORM" . #x00fbd4)
    ("ARABIC LETTER NG INITIAL FORM" . #x00fbd5)
    ("ARABIC LETTER NG MEDIAL FORM" . #x00fbd6)
    ("ARABIC LETTER U ISOLATED FORM" . #x00fbd7)
    ("ARABIC LETTER U FINAL FORM" . #x00fbd8)
    ("ARABIC LETTER OE ISOLATED FORM" . #x00fbd9)
    ("ARABIC LETTER OE FINAL FORM" . #x00fbda)
    ("ARABIC LETTER YU ISOLATED FORM" . #x00fbdb)
    ("ARABIC LETTER YU FINAL FORM" . #x00fbdc)
    ("ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM" . #x00fbdd)
    ("ARABIC LETTER VE ISOLATED FORM" . #x00fbde)
    ("ARABIC LETTER VE FINAL FORM" . #x00fbdf)
    ("ARABIC LETTER KIRGHIZ OE ISOLATED FORM" . #x00fbe0)
    ("ARABIC LETTER KIRGHIZ OE FINAL FORM" . #x00fbe1)
    ("ARABIC LETTER KIRGHIZ YU ISOLATED FORM" . #x00fbe2)
    ("ARABIC LETTER KIRGHIZ YU FINAL FORM" . #x00fbe3)
    ("ARABIC LETTER E ISOLATED FORM" . #x00fbe4)
    ("ARABIC LETTER E FINAL FORM" . #x00fbe5)
    ("ARABIC LETTER E INITIAL FORM" . #x00fbe6)
    ("ARABIC LETTER E MEDIAL FORM" . #x00fbe7)
    ("ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM" . #x00fbe8)
    ("ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM" . #x00fbe9)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM" . #x00fbea)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM" . #x00fbeb)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM" . #x00fbec)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM" . #x00fbed)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM" . #x00fbee)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM" . #x00fbef)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM" . #x00fbf0)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM" . #x00fbf1)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM" . #x00fbf2)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM" . #x00fbf3)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM" . #x00fbf4)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM" . #x00fbf5)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM" . #x00fbf6)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM" . #x00fbf7)
    ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM" . #x00fbf8)
    ("ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM" . #x00fbf9)
    ("ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM" . #x00fbfa)
    ("ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM" . #x00fbfb)
    ("ARABIC LETTER FARSI YEH ISOLATED FORM" . #x00fbfc)
    ("ARABIC LETTER FARSI YEH FINAL FORM" . #x00fbfd)
    ("ARABIC LETTER FARSI YEH INITIAL FORM" . #x00fbfe)
    ("ARABIC LETTER FARSI YEH MEDIAL FORM" . #x00fbff)
    ("VARIATION SELECTOR-1" . #x00fe00)
    ("VARIATION SELECTOR-2" . #x00fe01)
    ("VARIATION SELECTOR-3" . #x00fe02)
    ("VARIATION SELECTOR-4" . #x00fe03)
    ("VARIATION SELECTOR-5" . #x00fe04)
    ("VARIATION SELECTOR-6" . #x00fe05)
    ("VARIATION SELECTOR-7" . #x00fe06)
    ("VARIATION SELECTOR-8" . #x00fe07)
    ("VARIATION SELECTOR-9" . #x00fe08)
    ("VARIATION SELECTOR-10" . #x00fe09)
    ("VARIATION SELECTOR-11" . #x00fe0a)
    ("VARIATION SELECTOR-12" . #x00fe0b)
    ("VARIATION SELECTOR-13" . #x00fe0c)
    ("VARIATION SELECTOR-14" . #x00fe0d)
    ("VARIATION SELECTOR-15" . #x00fe0e)
    ("VARIATION SELECTOR-16" . #x00fe0f)
    ("COMBINING LIGATURE LEFT HALF" . #x00fe20)
    ("COMBINING LIGATURE RIGHT HALF" . #x00fe21)
    ("COMBINING DOUBLE TILDE LEFT HALF" . #x00fe22)
    ("COMBINING DOUBLE TILDE RIGHT HALF" . #x00fe23)
    ("PRESENTATION FORM FOR VERTICAL TWO DOT LEADER" . #x00fe30)
    ("PRESENTATION FORM FOR VERTICAL EM DASH" . #x00fe31)
    ("PRESENTATION FORM FOR VERTICAL EN DASH" . #x00fe32)
    ("PRESENTATION FORM FOR VERTICAL LOW LINE" . #x00fe33)
    ("PRESENTATION FORM FOR VERTICAL WAVY LOW LINE" . #x00fe34)
    ("PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS" . #x00fe35)
    ("PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS" . #x00fe36)
    ("PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET" . #x00fe37)
    ("PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET" . #x00fe38)
    ("PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET" . #x00fe39)
    ("PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET" . #x00fe3a)
    ("PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET" . #x00fe3b)
    ("PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET" . #x00fe3c)
    ("PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET" . #x00fe3d)
    ("PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET" . #x00fe3e)
    ("PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET" . #x00fe3f)
    ("PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET" . #x00fe40)
    ("PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET" . #x00fe41)
    ("PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET" . #x00fe42)
    ("PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET" . #x00fe43)
    ("PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET" . #x00fe44)
    ("SESAME DOT" . #x00fe45)
    ("WHITE SESAME DOT" . #x00fe46)
    ("DASHED OVERLINE" . #x00fe49)
    ("CENTRELINE OVERLINE" . #x00fe4a)
    ("WAVY OVERLINE" . #x00fe4b)
    ("DOUBLE WAVY OVERLINE" . #x00fe4c)
    ("DASHED LOW LINE" . #x00fe4d)
    ("CENTRELINE LOW LINE" . #x00fe4e)
    ("WAVY LOW LINE" . #x00fe4f)
    ("SMALL COMMA" . #x00fe50)
    ("SMALL IDEOGRAPHIC COMMA" . #x00fe51)
    ("SMALL FULL STOP" . #x00fe52)
    ("SMALL SEMICOLON" . #x00fe54)
    ("SMALL COLON" . #x00fe55)
    ("SMALL QUESTION MARK" . #x00fe56)
    ("SMALL EXCLAMATION MARK" . #x00fe57)
    ("SMALL EM DASH" . #x00fe58)
    ("SMALL LEFT PARENTHESIS" . #x00fe59)
    ("SMALL RIGHT PARENTHESIS" . #x00fe5a)
    ("SMALL LEFT CURLY BRACKET" . #x00fe5b)
    ("SMALL RIGHT CURLY BRACKET" . #x00fe5c)
    ("SMALL LEFT TORTOISE SHELL BRACKET" . #x00fe5d)
    ("SMALL RIGHT TORTOISE SHELL BRACKET" . #x00fe5e)
    ("SMALL NUMBER SIGN" . #x00fe5f)
    ("SMALL AMPERSAND" . #x00fe60)
    ("SMALL ASTERISK" . #x00fe61)
    ("SMALL PLUS SIGN" . #x00fe62)
    ("SMALL HYPHEN-MINUS" . #x00fe63)
    ("SMALL LESS-THAN SIGN" . #x00fe64)
    ("SMALL GREATER-THAN SIGN" . #x00fe65)
    ("SMALL EQUALS SIGN" . #x00fe66)
    ("SMALL REVERSE SOLIDUS" . #x00fe68)
    ("SMALL DOLLAR SIGN" . #x00fe69)
    ("SMALL PERCENT SIGN" . #x00fe6a)
    ("SMALL COMMERCIAL AT" . #x00fe6b)
    ("ARABIC FATHATAN ISOLATED FORM" . #x00fe70)
    ("ARABIC TATWEEL WITH FATHATAN ABOVE" . #x00fe71)
    ("ARABIC DAMMATAN ISOLATED FORM" . #x00fe72)
    ("ARABIC TAIL FRAGMENT" . #x00fe73)
    ("ARABIC KASRATAN ISOLATED FORM" . #x00fe74)
    ("ARABIC FATHA ISOLATED FORM" . #x00fe76)
    ("ARABIC FATHA MEDIAL FORM" . #x00fe77)
    ("ARABIC DAMMA ISOLATED FORM" . #x00fe78)
    ("ARABIC DAMMA MEDIAL FORM" . #x00fe79)
    ("ARABIC KASRA ISOLATED FORM" . #x00fe7a)
    ("ARABIC KASRA MEDIAL FORM" . #x00fe7b)
    ("ARABIC SHADDA ISOLATED FORM" . #x00fe7c)
    ("ARABIC SHADDA MEDIAL FORM" . #x00fe7d)
    ("ARABIC SUKUN ISOLATED FORM" . #x00fe7e)
    ("ARABIC SUKUN MEDIAL FORM" . #x00fe7f)
    ("ARABIC LETTER HAMZA ISOLATED FORM" . #x00fe80)
    ("ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM" . #x00fe81)
    ("ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM" . #x00fe82)
    ("ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM" . #x00fe83)
    ("ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM" . #x00fe84)
    ("ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM" . #x00fe85)
    ("ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM" . #x00fe86)
    ("ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM" . #x00fe87)
    ("ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM" . #x00fe88)
    ("ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM" . #x00fe89)
    ("ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM" . #x00fe8a)
    ("ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM" . #x00fe8b)
    ("ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM" . #x00fe8c)
    ("ARABIC LETTER ALEF ISOLATED FORM" . #x00fe8d)
    ("ARABIC LETTER ALEF FINAL FORM" . #x00fe8e)
    ("ARABIC LETTER BEH ISOLATED FORM" . #x00fe8f)
    ("ARABIC LETTER BEH FINAL FORM" . #x00fe90)
    ("ARABIC LETTER BEH INITIAL FORM" . #x00fe91)
    ("ARABIC LETTER BEH MEDIAL FORM" . #x00fe92)
    ("ARABIC LETTER TEH MARBUTA ISOLATED FORM" . #x00fe93)
    ("ARABIC LETTER TEH MARBUTA FINAL FORM" . #x00fe94)
    ("ARABIC LETTER TEH ISOLATED FORM" . #x00fe95)
    ("ARABIC LETTER TEH FINAL FORM" . #x00fe96)
    ("ARABIC LETTER TEH INITIAL FORM" . #x00fe97)
    ("ARABIC LETTER TEH MEDIAL FORM" . #x00fe98)
    ("ARABIC LETTER THEH ISOLATED FORM" . #x00fe99)
    ("ARABIC LETTER THEH FINAL FORM" . #x00fe9a)
    ("ARABIC LETTER THEH INITIAL FORM" . #x00fe9b)
    ("ARABIC LETTER THEH MEDIAL FORM" . #x00fe9c)
    ("ARABIC LETTER JEEM ISOLATED FORM" . #x00fe9d)
    ("ARABIC LETTER JEEM FINAL FORM" . #x00fe9e)
    ("ARABIC LETTER JEEM INITIAL FORM" . #x00fe9f)
    ("ARABIC LETTER JEEM MEDIAL FORM" . #x00fea0)
    ("ARABIC LETTER HAH ISOLATED FORM" . #x00fea1)
    ("ARABIC LETTER HAH FINAL FORM" . #x00fea2)
    ("ARABIC LETTER HAH INITIAL FORM" . #x00fea3)
    ("ARABIC LETTER HAH MEDIAL FORM" . #x00fea4)
    ("ARABIC LETTER KHAH ISOLATED FORM" . #x00fea5)
    ("ARABIC LETTER KHAH FINAL FORM" . #x00fea6)
    ("ARABIC LETTER KHAH INITIAL FORM" . #x00fea7)
    ("ARABIC LETTER KHAH MEDIAL FORM" . #x00fea8)
    ("ARABIC LETTER DAL ISOLATED FORM" . #x00fea9)
    ("ARABIC LETTER DAL FINAL FORM" . #x00feaa)
    ("ARABIC LETTER THAL ISOLATED FORM" . #x00feab)
    ("ARABIC LETTER THAL FINAL FORM" . #x00feac)
    ("ARABIC LETTER REH ISOLATED FORM" . #x00fead)
    ("ARABIC LETTER REH FINAL FORM" . #x00feae)
    ("ARABIC LETTER ZAIN ISOLATED FORM" . #x00feaf)
    ("ARABIC LETTER ZAIN FINAL FORM" . #x00feb0)
    ("ARABIC LETTER SEEN ISOLATED FORM" . #x00feb1)
    ("ARABIC LETTER SEEN FINAL FORM" . #x00feb2)
    ("ARABIC LETTER SEEN INITIAL FORM" . #x00feb3)
    ("ARABIC LETTER SEEN MEDIAL FORM" . #x00feb4)
    ("ARABIC LETTER SHEEN ISOLATED FORM" . #x00feb5)
    ("ARABIC LETTER SHEEN FINAL FORM" . #x00feb6)
    ("ARABIC LETTER SHEEN INITIAL FORM" . #x00feb7)
    ("ARABIC LETTER SHEEN MEDIAL FORM" . #x00feb8)
    ("ARABIC LETTER SAD ISOLATED FORM" . #x00feb9)
    ("ARABIC LETTER SAD FINAL FORM" . #x00feba)
    ("ARABIC LETTER SAD INITIAL FORM" . #x00febb)
    ("ARABIC LETTER SAD MEDIAL FORM" . #x00febc)
    ("ARABIC LETTER DAD ISOLATED FORM" . #x00febd)
    ("ARABIC LETTER DAD FINAL FORM" . #x00febe)
    ("ARABIC LETTER DAD INITIAL FORM" . #x00febf)
    ("ARABIC LETTER DAD MEDIAL FORM" . #x00fec0)
    ("ARABIC LETTER TAH ISOLATED FORM" . #x00fec1)
    ("ARABIC LETTER TAH FINAL FORM" . #x00fec2)
    ("ARABIC LETTER TAH INITIAL FORM" . #x00fec3)
    ("ARABIC LETTER TAH MEDIAL FORM" . #x00fec4)
    ("ARABIC LETTER ZAH ISOLATED FORM" . #x00fec5)
    ("ARABIC LETTER ZAH FINAL FORM" . #x00fec6)
    ("ARABIC LETTER ZAH INITIAL FORM" . #x00fec7)
    ("ARABIC LETTER ZAH MEDIAL FORM" . #x00fec8)
    ("ARABIC LETTER AIN ISOLATED FORM" . #x00fec9)
    ("ARABIC LETTER AIN FINAL FORM" . #x00feca)
    ("ARABIC LETTER AIN INITIAL FORM" . #x00fecb)
    ("ARABIC LETTER AIN MEDIAL FORM" . #x00fecc)
    ("ARABIC LETTER GHAIN ISOLATED FORM" . #x00fecd)
    ("ARABIC LETTER GHAIN FINAL FORM" . #x00fece)
    ("ARABIC LETTER GHAIN INITIAL FORM" . #x00fecf)
    ("ARABIC LETTER GHAIN MEDIAL FORM" . #x00fed0)
    ("ARABIC LETTER FEH ISOLATED FORM" . #x00fed1)
    ("ARABIC LETTER FEH FINAL FORM" . #x00fed2)
    ("ARABIC LETTER FEH INITIAL FORM" . #x00fed3)
    ("ARABIC LETTER FEH MEDIAL FORM" . #x00fed4)
    ("ARABIC LETTER QAF ISOLATED FORM" . #x00fed5)
    ("ARABIC LETTER QAF FINAL FORM" . #x00fed6)
    ("ARABIC LETTER QAF INITIAL FORM" . #x00fed7)
    ("ARABIC LETTER QAF MEDIAL FORM" . #x00fed8)
    ("ARABIC LETTER KAF ISOLATED FORM" . #x00fed9)
    ("ARABIC LETTER KAF FINAL FORM" . #x00feda)
    ("ARABIC LETTER KAF INITIAL FORM" . #x00fedb)
    ("ARABIC LETTER KAF MEDIAL FORM" . #x00fedc)
    ("ARABIC LETTER LAM ISOLATED FORM" . #x00fedd)
    ("ARABIC LETTER LAM FINAL FORM" . #x00fede)
    ("ARABIC LETTER LAM INITIAL FORM" . #x00fedf)
    ("ARABIC LETTER LAM MEDIAL FORM" . #x00fee0)
    ("ARABIC LETTER MEEM ISOLATED FORM" . #x00fee1)
    ("ARABIC LETTER MEEM FINAL FORM" . #x00fee2)
    ("ARABIC LETTER MEEM INITIAL FORM" . #x00fee3)
    ("ARABIC LETTER MEEM MEDIAL FORM" . #x00fee4)
    ("ARABIC LETTER NOON ISOLATED FORM" . #x00fee5)
    ("ARABIC LETTER NOON FINAL FORM" . #x00fee6)
    ("ARABIC LETTER NOON INITIAL FORM" . #x00fee7)
    ("ARABIC LETTER NOON MEDIAL FORM" . #x00fee8)
    ("ARABIC LETTER HEH ISOLATED FORM" . #x00fee9)
    ("ARABIC LETTER HEH FINAL FORM" . #x00feea)
    ("ARABIC LETTER HEH INITIAL FORM" . #x00feeb)
    ("ARABIC LETTER HEH MEDIAL FORM" . #x00feec)
    ("ARABIC LETTER WAW ISOLATED FORM" . #x00feed)
    ("ARABIC LETTER WAW FINAL FORM" . #x00feee)
    ("ARABIC LETTER ALEF MAKSURA ISOLATED FORM" . #x00feef)
    ("ARABIC LETTER ALEF MAKSURA FINAL FORM" . #x00fef0)
    ("ARABIC LETTER YEH ISOLATED FORM" . #x00fef1)
    ("ARABIC LETTER YEH FINAL FORM" . #x00fef2)
    ("ARABIC LETTER YEH INITIAL FORM" . #x00fef3)
    ("ARABIC LETTER YEH MEDIAL FORM" . #x00fef4)
    ("ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM" . #x00fef5)
    ("ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM" . #x00fef6)
    ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM" . #x00fef7)
    ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM" . #x00fef8)
    ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM" . #x00fef9)
    ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM" . #x00fefa)
    ("ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM" . #x00fefb)
    ("ARABIC LIGATURE LAM WITH ALEF FINAL FORM" . #x00fefc)
    ("ZERO WIDTH NO-BREAK SPACE" . #x00feff)
    ("REPLACEMENT CHARACTER" . #x00fffd)
    ("MATHEMATICAL BOLD CAPITAL A" . #x01d400)
    ("MATHEMATICAL BOLD CAPITAL B" . #x01d401)
    ("MATHEMATICAL BOLD CAPITAL C" . #x01d402)
    ("MATHEMATICAL BOLD CAPITAL D" . #x01d403)
    ("MATHEMATICAL BOLD CAPITAL E" . #x01d404)
    ("MATHEMATICAL BOLD CAPITAL F" . #x01d405)
    ("MATHEMATICAL BOLD CAPITAL G" . #x01d406)
    ("MATHEMATICAL BOLD CAPITAL H" . #x01d407)
    ("MATHEMATICAL BOLD CAPITAL I" . #x01d408)
    ("MATHEMATICAL BOLD CAPITAL J" . #x01d409)
    ("MATHEMATICAL BOLD CAPITAL K" . #x01d40a)
    ("MATHEMATICAL BOLD CAPITAL L" . #x01d40b)
    ("MATHEMATICAL BOLD CAPITAL M" . #x01d40c)
    ("MATHEMATICAL BOLD CAPITAL N" . #x01d40d)
    ("MATHEMATICAL BOLD CAPITAL O" . #x01d40e)
    ("MATHEMATICAL BOLD CAPITAL P" . #x01d40f)
    ("MATHEMATICAL BOLD CAPITAL Q" . #x01d410)
    ("MATHEMATICAL BOLD CAPITAL R" . #x01d411)
    ("MATHEMATICAL BOLD CAPITAL S" . #x01d412)
    ("MATHEMATICAL BOLD CAPITAL T" . #x01d413)
    ("MATHEMATICAL BOLD CAPITAL U" . #x01d414)
    ("MATHEMATICAL BOLD CAPITAL V" . #x01d415)
    ("MATHEMATICAL BOLD CAPITAL W" . #x01d416)
    ("MATHEMATICAL BOLD CAPITAL X" . #x01d417)
    ("MATHEMATICAL BOLD CAPITAL Y" . #x01d418)
    ("MATHEMATICAL BOLD CAPITAL Z" . #x01d419)
    ("MATHEMATICAL BOLD SMALL A" . #x01d41a)
    ("MATHEMATICAL BOLD SMALL B" . #x01d41b)
    ("MATHEMATICAL BOLD SMALL C" . #x01d41c)
    ("MATHEMATICAL BOLD SMALL D" . #x01d41d)
    ("MATHEMATICAL BOLD SMALL E" . #x01d41e)
    ("MATHEMATICAL BOLD SMALL F" . #x01d41f)
    ("MATHEMATICAL BOLD SMALL G" . #x01d420)
    ("MATHEMATICAL BOLD SMALL H" . #x01d421)
    ("MATHEMATICAL BOLD SMALL I" . #x01d422)
    ("MATHEMATICAL BOLD SMALL J" . #x01d423)
    ("MATHEMATICAL BOLD SMALL K" . #x01d424)
    ("MATHEMATICAL BOLD SMALL L" . #x01d425)
    ("MATHEMATICAL BOLD SMALL M" . #x01d426)
    ("MATHEMATICAL BOLD SMALL N" . #x01d427)
    ("MATHEMATICAL BOLD SMALL O" . #x01d428)
    ("MATHEMATICAL BOLD SMALL P" . #x01d429)
    ("MATHEMATICAL BOLD SMALL Q" . #x01d42a)
    ("MATHEMATICAL BOLD SMALL R" . #x01d42b)
    ("MATHEMATICAL BOLD SMALL S" . #x01d42c)
    ("MATHEMATICAL BOLD SMALL T" . #x01d42d)
    ("MATHEMATICAL BOLD SMALL U" . #x01d42e)
    ("MATHEMATICAL BOLD SMALL V" . #x01d42f)
    ("MATHEMATICAL BOLD SMALL W" . #x01d430)
    ("MATHEMATICAL BOLD SMALL X" . #x01d431)
    ("MATHEMATICAL BOLD SMALL Y" . #x01d432)
    ("MATHEMATICAL BOLD SMALL Z" . #x01d433)
    ("MATHEMATICAL ITALIC CAPITAL A" . #x01d434)
    ("MATHEMATICAL ITALIC CAPITAL B" . #x01d435)
    ("MATHEMATICAL ITALIC CAPITAL C" . #x01d436)
    ("MATHEMATICAL ITALIC CAPITAL D" . #x01d437)
    ("MATHEMATICAL ITALIC CAPITAL E" . #x01d438)
    ("MATHEMATICAL ITALIC CAPITAL F" . #x01d439)
    ("MATHEMATICAL ITALIC CAPITAL G" . #x01d43a)
    ("MATHEMATICAL ITALIC CAPITAL H" . #x01d43b)
    ("MATHEMATICAL ITALIC CAPITAL I" . #x01d43c)
    ("MATHEMATICAL ITALIC CAPITAL J" . #x01d43d)
    ("MATHEMATICAL ITALIC CAPITAL K" . #x01d43e)
    ("MATHEMATICAL ITALIC CAPITAL L" . #x01d43f)
    ("MATHEMATICAL ITALIC CAPITAL M" . #x01d440)
    ("MATHEMATICAL ITALIC CAPITAL N" . #x01d441)
    ("MATHEMATICAL ITALIC CAPITAL O" . #x01d442)
    ("MATHEMATICAL ITALIC CAPITAL P" . #x01d443)
    ("MATHEMATICAL ITALIC CAPITAL Q" . #x01d444)
    ("MATHEMATICAL ITALIC CAPITAL R" . #x01d445)
    ("MATHEMATICAL ITALIC CAPITAL S" . #x01d446)
    ("MATHEMATICAL ITALIC CAPITAL T" . #x01d447)
    ("MATHEMATICAL ITALIC CAPITAL U" . #x01d448)
    ("MATHEMATICAL ITALIC CAPITAL V" . #x01d449)
    ("MATHEMATICAL ITALIC CAPITAL W" . #x01d44a)
    ("MATHEMATICAL ITALIC CAPITAL X" . #x01d44b)
    ("MATHEMATICAL ITALIC CAPITAL Y" . #x01d44c)
    ("MATHEMATICAL ITALIC CAPITAL Z" . #x01d44d)
    ("MATHEMATICAL ITALIC SMALL A" . #x01d44e)
    ("MATHEMATICAL ITALIC SMALL B" . #x01d44f)
    ("MATHEMATICAL ITALIC SMALL C" . #x01d450)
    ("MATHEMATICAL ITALIC SMALL D" . #x01d451)
    ("MATHEMATICAL ITALIC SMALL E" . #x01d452)
    ("MATHEMATICAL ITALIC SMALL F" . #x01d453)
    ("MATHEMATICAL ITALIC SMALL G" . #x01d454)
    ("MATHEMATICAL ITALIC SMALL I" . #x01d456)
    ("MATHEMATICAL ITALIC SMALL J" . #x01d457)
    ("MATHEMATICAL ITALIC SMALL K" . #x01d458)
    ("MATHEMATICAL ITALIC SMALL L" . #x01d459)
    ("MATHEMATICAL ITALIC SMALL M" . #x01d45a)
    ("MATHEMATICAL ITALIC SMALL N" . #x01d45b)
    ("MATHEMATICAL ITALIC SMALL O" . #x01d45c)
    ("MATHEMATICAL ITALIC SMALL P" . #x01d45d)
    ("MATHEMATICAL ITALIC SMALL Q" . #x01d45e)
    ("MATHEMATICAL ITALIC SMALL R" . #x01d45f)
    ("MATHEMATICAL ITALIC SMALL S" . #x01d460)
    ("MATHEMATICAL ITALIC SMALL T" . #x01d461)
    ("MATHEMATICAL ITALIC SMALL U" . #x01d462)
    ("MATHEMATICAL ITALIC SMALL V" . #x01d463)
    ("MATHEMATICAL ITALIC SMALL W" . #x01d464)
    ("MATHEMATICAL ITALIC SMALL X" . #x01d465)
    ("MATHEMATICAL ITALIC SMALL Y" . #x01d466)
    ("MATHEMATICAL ITALIC SMALL Z" . #x01d467)
    ("MATHEMATICAL BOLD ITALIC CAPITAL A" . #x01d468)
    ("MATHEMATICAL BOLD ITALIC CAPITAL B" . #x01d469)
    ("MATHEMATICAL BOLD ITALIC CAPITAL C" . #x01d46a)
    ("MATHEMATICAL BOLD ITALIC CAPITAL D" . #x01d46b)
    ("MATHEMATICAL BOLD ITALIC CAPITAL E" . #x01d46c)
    ("MATHEMATICAL BOLD ITALIC CAPITAL F" . #x01d46d)
    ("MATHEMATICAL BOLD ITALIC CAPITAL G" . #x01d46e)
    ("MATHEMATICAL BOLD ITALIC CAPITAL H" . #x01d46f)
    ("MATHEMATICAL BOLD ITALIC CAPITAL I" . #x01d470)
    ("MATHEMATICAL BOLD ITALIC CAPITAL J" . #x01d471)
    ("MATHEMATICAL BOLD ITALIC CAPITAL K" . #x01d472)
    ("MATHEMATICAL BOLD ITALIC CAPITAL L" . #x01d473)
    ("MATHEMATICAL BOLD ITALIC CAPITAL M" . #x01d474)
    ("MATHEMATICAL BOLD ITALIC CAPITAL N" . #x01d475)
    ("MATHEMATICAL BOLD ITALIC CAPITAL O" . #x01d476)
    ("MATHEMATICAL BOLD ITALIC CAPITAL P" . #x01d477)
    ("MATHEMATICAL BOLD ITALIC CAPITAL Q" . #x01d478)
    ("MATHEMATICAL BOLD ITALIC CAPITAL R" . #x01d479)
    ("MATHEMATICAL BOLD ITALIC CAPITAL S" . #x01d47a)
    ("MATHEMATICAL BOLD ITALIC CAPITAL T" . #x01d47b)
    ("MATHEMATICAL BOLD ITALIC CAPITAL U" . #x01d47c)
    ("MATHEMATICAL BOLD ITALIC CAPITAL V" . #x01d47d)
    ("MATHEMATICAL BOLD ITALIC CAPITAL W" . #x01d47e)
    ("MATHEMATICAL BOLD ITALIC CAPITAL X" . #x01d47f)
    ("MATHEMATICAL BOLD ITALIC CAPITAL Y" . #x01d480)
    ("MATHEMATICAL BOLD ITALIC CAPITAL Z" . #x01d481)
    ("MATHEMATICAL BOLD ITALIC SMALL A" . #x01d482)
    ("MATHEMATICAL BOLD ITALIC SMALL B" . #x01d483)
    ("MATHEMATICAL BOLD ITALIC SMALL C" . #x01d484)
    ("MATHEMATICAL BOLD ITALIC SMALL D" . #x01d485)
    ("MATHEMATICAL BOLD ITALIC SMALL E" . #x01d486)
    ("MATHEMATICAL BOLD ITALIC SMALL F" . #x01d487)
    ("MATHEMATICAL BOLD ITALIC SMALL G" . #x01d488)
    ("MATHEMATICAL BOLD ITALIC SMALL H" . #x01d489)
    ("MATHEMATICAL BOLD ITALIC SMALL I" . #x01d48a)
    ("MATHEMATICAL BOLD ITALIC SMALL J" . #x01d48b)
    ("MATHEMATICAL BOLD ITALIC SMALL K" . #x01d48c)
    ("MATHEMATICAL BOLD ITALIC SMALL L" . #x01d48d)
    ("MATHEMATICAL BOLD ITALIC SMALL M" . #x01d48e)
    ("MATHEMATICAL BOLD ITALIC SMALL N" . #x01d48f)
    ("MATHEMATICAL BOLD ITALIC SMALL O" . #x01d490)
    ("MATHEMATICAL BOLD ITALIC SMALL P" . #x01d491)
    ("MATHEMATICAL BOLD ITALIC SMALL Q" . #x01d492)
    ("MATHEMATICAL BOLD ITALIC SMALL R" . #x01d493)
    ("MATHEMATICAL BOLD ITALIC SMALL S" . #x01d494)
    ("MATHEMATICAL BOLD ITALIC SMALL T" . #x01d495)
    ("MATHEMATICAL BOLD ITALIC SMALL U" . #x01d496)
    ("MATHEMATICAL BOLD ITALIC SMALL V" . #x01d497)
    ("MATHEMATICAL BOLD ITALIC SMALL W" . #x01d498)
    ("MATHEMATICAL BOLD ITALIC SMALL X" . #x01d499)
    ("MATHEMATICAL BOLD ITALIC SMALL Y" . #x01d49a)
    ("MATHEMATICAL BOLD ITALIC SMALL Z" . #x01d49b)
    ("MATHEMATICAL SCRIPT CAPITAL A" . #x01d49c)
    ("MATHEMATICAL SCRIPT CAPITAL C" . #x01d49e)
    ("MATHEMATICAL SCRIPT CAPITAL D" . #x01d49f)
    ("MATHEMATICAL SCRIPT CAPITAL G" . #x01d4a2)
    ("MATHEMATICAL SCRIPT CAPITAL J" . #x01d4a5)
    ("MATHEMATICAL SCRIPT CAPITAL K" . #x01d4a6)
    ("MATHEMATICAL SCRIPT CAPITAL N" . #x01d4a9)
    ("MATHEMATICAL SCRIPT CAPITAL O" . #x01d4aa)
    ("MATHEMATICAL SCRIPT CAPITAL P" . #x01d4ab)
    ("MATHEMATICAL SCRIPT CAPITAL Q" . #x01d4ac)
    ("MATHEMATICAL SCRIPT CAPITAL S" . #x01d4ae)
    ("MATHEMATICAL SCRIPT CAPITAL T" . #x01d4af)
    ("MATHEMATICAL SCRIPT CAPITAL U" . #x01d4b0)
    ("MATHEMATICAL SCRIPT CAPITAL V" . #x01d4b1)
    ("MATHEMATICAL SCRIPT CAPITAL W" . #x01d4b2)
    ("MATHEMATICAL SCRIPT CAPITAL X" . #x01d4b3)
    ("MATHEMATICAL SCRIPT CAPITAL Y" . #x01d4b4)
    ("MATHEMATICAL SCRIPT CAPITAL Z" . #x01d4b5)
    ("MATHEMATICAL SCRIPT SMALL A" . #x01d4b6)
    ("MATHEMATICAL SCRIPT SMALL B" . #x01d4b7)
    ("MATHEMATICAL SCRIPT SMALL C" . #x01d4b8)
    ("MATHEMATICAL SCRIPT SMALL D" . #x01d4b9)
    ("MATHEMATICAL SCRIPT SMALL F" . #x01d4bb)
    ("MATHEMATICAL SCRIPT SMALL H" . #x01d4bd)
    ("MATHEMATICAL SCRIPT SMALL I" . #x01d4be)
    ("MATHEMATICAL SCRIPT SMALL J" . #x01d4bf)
    ("MATHEMATICAL SCRIPT SMALL K" . #x01d4c0)
    ("MATHEMATICAL SCRIPT SMALL L" . #x01d4c1)
    ("MATHEMATICAL SCRIPT SMALL M" . #x01d4c2)
    ("MATHEMATICAL SCRIPT SMALL N" . #x01d4c3)
    ("MATHEMATICAL SCRIPT SMALL P" . #x01d4c5)
    ("MATHEMATICAL SCRIPT SMALL Q" . #x01d4c6)
    ("MATHEMATICAL SCRIPT SMALL R" . #x01d4c7)
    ("MATHEMATICAL SCRIPT SMALL S" . #x01d4c8)
    ("MATHEMATICAL SCRIPT SMALL T" . #x01d4c9)
    ("MATHEMATICAL SCRIPT SMALL U" . #x01d4ca)
    ("MATHEMATICAL SCRIPT SMALL V" . #x01d4cb)
    ("MATHEMATICAL SCRIPT SMALL W" . #x01d4cc)
    ("MATHEMATICAL SCRIPT SMALL X" . #x01d4cd)
    ("MATHEMATICAL SCRIPT SMALL Y" . #x01d4ce)
    ("MATHEMATICAL SCRIPT SMALL Z" . #x01d4cf)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL A" . #x01d4d0)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL B" . #x01d4d1)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL C" . #x01d4d2)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL D" . #x01d4d3)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL E" . #x01d4d4)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL F" . #x01d4d5)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL G" . #x01d4d6)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL H" . #x01d4d7)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL I" . #x01d4d8)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL J" . #x01d4d9)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL K" . #x01d4da)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL L" . #x01d4db)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL M" . #x01d4dc)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL N" . #x01d4dd)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL O" . #x01d4de)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL P" . #x01d4df)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL Q" . #x01d4e0)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL R" . #x01d4e1)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL S" . #x01d4e2)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL T" . #x01d4e3)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL U" . #x01d4e4)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL V" . #x01d4e5)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL W" . #x01d4e6)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL X" . #x01d4e7)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL Y" . #x01d4e8)
    ("MATHEMATICAL BOLD SCRIPT CAPITAL Z" . #x01d4e9)
    ("MATHEMATICAL BOLD SCRIPT SMALL A" . #x01d4ea)
    ("MATHEMATICAL BOLD SCRIPT SMALL B" . #x01d4eb)
    ("MATHEMATICAL BOLD SCRIPT SMALL C" . #x01d4ec)
    ("MATHEMATICAL BOLD SCRIPT SMALL D" . #x01d4ed)
    ("MATHEMATICAL BOLD SCRIPT SMALL E" . #x01d4ee)
    ("MATHEMATICAL BOLD SCRIPT SMALL F" . #x01d4ef)
    ("MATHEMATICAL BOLD SCRIPT SMALL G" . #x01d4f0)
    ("MATHEMATICAL BOLD SCRIPT SMALL H" . #x01d4f1)
    ("MATHEMATICAL BOLD SCRIPT SMALL I" . #x01d4f2)
    ("MATHEMATICAL BOLD SCRIPT SMALL J" . #x01d4f3)
    ("MATHEMATICAL BOLD SCRIPT SMALL K" . #x01d4f4)
    ("MATHEMATICAL BOLD SCRIPT SMALL L" . #x01d4f5)
    ("MATHEMATICAL BOLD SCRIPT SMALL M" . #x01d4f6)
    ("MATHEMATICAL BOLD SCRIPT SMALL N" . #x01d4f7)
    ("MATHEMATICAL BOLD SCRIPT SMALL O" . #x01d4f8)
    ("MATHEMATICAL BOLD SCRIPT SMALL P" . #x01d4f9)
    ("MATHEMATICAL BOLD SCRIPT SMALL Q" . #x01d4fa)
    ("MATHEMATICAL BOLD SCRIPT SMALL R" . #x01d4fb)
    ("MATHEMATICAL BOLD SCRIPT SMALL S" . #x01d4fc)
    ("MATHEMATICAL BOLD SCRIPT SMALL T" . #x01d4fd)
    ("MATHEMATICAL BOLD SCRIPT SMALL U" . #x01d4fe)
    ("MATHEMATICAL BOLD SCRIPT SMALL V" . #x01d4ff)
    ("MATHEMATICAL BOLD SCRIPT SMALL W" . #x01d500)
    ("MATHEMATICAL BOLD SCRIPT SMALL X" . #x01d501)
    ("MATHEMATICAL BOLD SCRIPT SMALL Y" . #x01d502)
    ("MATHEMATICAL BOLD SCRIPT SMALL Z" . #x01d503)
    ("MATHEMATICAL FRAKTUR CAPITAL A" . #x01d504)
    ("MATHEMATICAL FRAKTUR CAPITAL B" . #x01d505)
    ("MATHEMATICAL FRAKTUR CAPITAL D" . #x01d507)
    ("MATHEMATICAL FRAKTUR CAPITAL E" . #x01d508)
    ("MATHEMATICAL FRAKTUR CAPITAL F" . #x01d509)
    ("MATHEMATICAL FRAKTUR CAPITAL G" . #x01d50a)
    ("MATHEMATICAL FRAKTUR CAPITAL J" . #x01d50d)
    ("MATHEMATICAL FRAKTUR CAPITAL K" . #x01d50e)
    ("MATHEMATICAL FRAKTUR CAPITAL L" . #x01d50f)
    ("MATHEMATICAL FRAKTUR CAPITAL M" . #x01d510)
    ("MATHEMATICAL FRAKTUR CAPITAL N" . #x01d511)
    ("MATHEMATICAL FRAKTUR CAPITAL O" . #x01d512)
    ("MATHEMATICAL FRAKTUR CAPITAL P" . #x01d513)
    ("MATHEMATICAL FRAKTUR CAPITAL Q" . #x01d514)
    ("MATHEMATICAL FRAKTUR CAPITAL S" . #x01d516)
    ("MATHEMATICAL FRAKTUR CAPITAL T" . #x01d517)
    ("MATHEMATICAL FRAKTUR CAPITAL U" . #x01d518)
    ("MATHEMATICAL FRAKTUR CAPITAL V" . #x01d519)
    ("MATHEMATICAL FRAKTUR CAPITAL W" . #x01d51a)
    ("MATHEMATICAL FRAKTUR CAPITAL X" . #x01d51b)
    ("MATHEMATICAL FRAKTUR CAPITAL Y" . #x01d51c)
    ("MATHEMATICAL FRAKTUR SMALL A" . #x01d51e)
    ("MATHEMATICAL FRAKTUR SMALL B" . #x01d51f)
    ("MATHEMATICAL FRAKTUR SMALL C" . #x01d520)
    ("MATHEMATICAL FRAKTUR SMALL D" . #x01d521)
    ("MATHEMATICAL FRAKTUR SMALL E" . #x01d522)
    ("MATHEMATICAL FRAKTUR SMALL F" . #x01d523)
    ("MATHEMATICAL FRAKTUR SMALL G" . #x01d524)
    ("MATHEMATICAL FRAKTUR SMALL H" . #x01d525)
    ("MATHEMATICAL FRAKTUR SMALL I" . #x01d526)
    ("MATHEMATICAL FRAKTUR SMALL J" . #x01d527)
    ("MATHEMATICAL FRAKTUR SMALL K" . #x01d528)
    ("MATHEMATICAL FRAKTUR SMALL L" . #x01d529)
    ("MATHEMATICAL FRAKTUR SMALL M" . #x01d52a)
    ("MATHEMATICAL FRAKTUR SMALL N" . #x01d52b)
    ("MATHEMATICAL FRAKTUR SMALL O" . #x01d52c)
    ("MATHEMATICAL FRAKTUR SMALL P" . #x01d52d)
    ("MATHEMATICAL FRAKTUR SMALL Q" . #x01d52e)
    ("MATHEMATICAL FRAKTUR SMALL R" . #x01d52f)
    ("MATHEMATICAL FRAKTUR SMALL S" . #x01d530)
    ("MATHEMATICAL FRAKTUR SMALL T" . #x01d531)
    ("MATHEMATICAL FRAKTUR SMALL U" . #x01d532)
    ("MATHEMATICAL FRAKTUR SMALL V" . #x01d533)
    ("MATHEMATICAL FRAKTUR SMALL W" . #x01d534)
    ("MATHEMATICAL FRAKTUR SMALL X" . #x01d535)
    ("MATHEMATICAL FRAKTUR SMALL Y" . #x01d536)
    ("MATHEMATICAL FRAKTUR SMALL Z" . #x01d537)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL A" . #x01d538)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL B" . #x01d539)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL D" . #x01d53b)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL E" . #x01d53c)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL F" . #x01d53d)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL G" . #x01d53e)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL I" . #x01d540)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL J" . #x01d541)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL K" . #x01d542)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL L" . #x01d543)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL M" . #x01d544)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL O" . #x01d546)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL S" . #x01d54a)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL T" . #x01d54b)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL U" . #x01d54c)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL V" . #x01d54d)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL W" . #x01d54e)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL X" . #x01d54f)
    ("MATHEMATICAL DOUBLE-STRUCK CAPITAL Y" . #x01d550)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL A" . #x01d552)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL B" . #x01d553)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL C" . #x01d554)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL D" . #x01d555)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL E" . #x01d556)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL F" . #x01d557)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL G" . #x01d558)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL H" . #x01d559)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL I" . #x01d55a)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL J" . #x01d55b)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL K" . #x01d55c)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL L" . #x01d55d)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL M" . #x01d55e)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL N" . #x01d55f)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL O" . #x01d560)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL P" . #x01d561)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL Q" . #x01d562)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL R" . #x01d563)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL S" . #x01d564)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL T" . #x01d565)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL U" . #x01d566)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL V" . #x01d567)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL W" . #x01d568)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL X" . #x01d569)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL Y" . #x01d56a)
    ("MATHEMATICAL DOUBLE-STRUCK SMALL Z" . #x01d56b)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL A" . #x01d56c)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL B" . #x01d56d)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL C" . #x01d56e)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL D" . #x01d56f)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL E" . #x01d570)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL F" . #x01d571)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL G" . #x01d572)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL H" . #x01d573)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL I" . #x01d574)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL J" . #x01d575)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL K" . #x01d576)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL L" . #x01d577)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL M" . #x01d578)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL N" . #x01d579)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL O" . #x01d57a)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL P" . #x01d57b)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL Q" . #x01d57c)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL R" . #x01d57d)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL S" . #x01d57e)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL T" . #x01d57f)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL U" . #x01d580)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL V" . #x01d581)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL W" . #x01d582)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL X" . #x01d583)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL Y" . #x01d584)
    ("MATHEMATICAL BOLD FRAKTUR CAPITAL Z" . #x01d585)
    ("MATHEMATICAL BOLD FRAKTUR SMALL A" . #x01d586)
    ("MATHEMATICAL BOLD FRAKTUR SMALL B" . #x01d587)
    ("MATHEMATICAL BOLD FRAKTUR SMALL C" . #x01d588)
    ("MATHEMATICAL BOLD FRAKTUR SMALL D" . #x01d589)
    ("MATHEMATICAL BOLD FRAKTUR SMALL E" . #x01d58a)
    ("MATHEMATICAL BOLD FRAKTUR SMALL F" . #x01d58b)
    ("MATHEMATICAL BOLD FRAKTUR SMALL G" . #x01d58c)
    ("MATHEMATICAL BOLD FRAKTUR SMALL H" . #x01d58d)
    ("MATHEMATICAL BOLD FRAKTUR SMALL I" . #x01d58e)
    ("MATHEMATICAL BOLD FRAKTUR SMALL J" . #x01d58f)
    ("MATHEMATICAL BOLD FRAKTUR SMALL K" . #x01d590)
    ("MATHEMATICAL BOLD FRAKTUR SMALL L" . #x01d591)
    ("MATHEMATICAL BOLD FRAKTUR SMALL M" . #x01d592)
    ("MATHEMATICAL BOLD FRAKTUR SMALL N" . #x01d593)
    ("MATHEMATICAL BOLD FRAKTUR SMALL O" . #x01d594)
    ("MATHEMATICAL BOLD FRAKTUR SMALL P" . #x01d595)
    ("MATHEMATICAL BOLD FRAKTUR SMALL Q" . #x01d596)
    ("MATHEMATICAL BOLD FRAKTUR SMALL R" . #x01d597)
    ("MATHEMATICAL BOLD FRAKTUR SMALL S" . #x01d598)
    ("MATHEMATICAL BOLD FRAKTUR SMALL T" . #x01d599)
    ("MATHEMATICAL BOLD FRAKTUR SMALL U" . #x01d59a)
    ("MATHEMATICAL BOLD FRAKTUR SMALL V" . #x01d59b)
    ("MATHEMATICAL BOLD FRAKTUR SMALL W" . #x01d59c)
    ("MATHEMATICAL BOLD FRAKTUR SMALL X" . #x01d59d)
    ("MATHEMATICAL BOLD FRAKTUR SMALL Y" . #x01d59e)
    ("MATHEMATICAL BOLD FRAKTUR SMALL Z" . #x01d59f)
    ("MATHEMATICAL SANS-SERIF CAPITAL A" . #x01d5a0)
    ("MATHEMATICAL SANS-SERIF CAPITAL B" . #x01d5a1)
    ("MATHEMATICAL SANS-SERIF CAPITAL C" . #x01d5a2)
    ("MATHEMATICAL SANS-SERIF CAPITAL D" . #x01d5a3)
    ("MATHEMATICAL SANS-SERIF CAPITAL E" . #x01d5a4)
    ("MATHEMATICAL SANS-SERIF CAPITAL F" . #x01d5a5)
    ("MATHEMATICAL SANS-SERIF CAPITAL G" . #x01d5a6)
    ("MATHEMATICAL SANS-SERIF CAPITAL H" . #x01d5a7)
    ("MATHEMATICAL SANS-SERIF CAPITAL I" . #x01d5a8)
    ("MATHEMATICAL SANS-SERIF CAPITAL J" . #x01d5a9)
    ("MATHEMATICAL SANS-SERIF CAPITAL K" . #x01d5aa)
    ("MATHEMATICAL SANS-SERIF CAPITAL L" . #x01d5ab)
    ("MATHEMATICAL SANS-SERIF CAPITAL M" . #x01d5ac)
    ("MATHEMATICAL SANS-SERIF CAPITAL N" . #x01d5ad)
    ("MATHEMATICAL SANS-SERIF CAPITAL O" . #x01d5ae)
    ("MATHEMATICAL SANS-SERIF CAPITAL P" . #x01d5af)
    ("MATHEMATICAL SANS-SERIF CAPITAL Q" . #x01d5b0)
    ("MATHEMATICAL SANS-SERIF CAPITAL R" . #x01d5b1)
    ("MATHEMATICAL SANS-SERIF CAPITAL S" . #x01d5b2)
    ("MATHEMATICAL SANS-SERIF CAPITAL T" . #x01d5b3)
    ("MATHEMATICAL SANS-SERIF CAPITAL U" . #x01d5b4)
    ("MATHEMATICAL SANS-SERIF CAPITAL V" . #x01d5b5)
    ("MATHEMATICAL SANS-SERIF CAPITAL W" . #x01d5b6)
    ("MATHEMATICAL SANS-SERIF CAPITAL X" . #x01d5b7)
    ("MATHEMATICAL SANS-SERIF CAPITAL Y" . #x01d5b8)
    ("MATHEMATICAL SANS-SERIF CAPITAL Z" . #x01d5b9)
    ("MATHEMATICAL SANS-SERIF SMALL A" . #x01d5ba)
    ("MATHEMATICAL SANS-SERIF SMALL B" . #x01d5bb)
    ("MATHEMATICAL SANS-SERIF SMALL C" . #x01d5bc)
    ("MATHEMATICAL SANS-SERIF SMALL D" . #x01d5bd)
    ("MATHEMATICAL SANS-SERIF SMALL E" . #x01d5be)
    ("MATHEMATICAL SANS-SERIF SMALL F" . #x01d5bf)
    ("MATHEMATICAL SANS-SERIF SMALL G" . #x01d5c0)
    ("MATHEMATICAL SANS-SERIF SMALL H" . #x01d5c1)
    ("MATHEMATICAL SANS-SERIF SMALL I" . #x01d5c2)
    ("MATHEMATICAL SANS-SERIF SMALL J" . #x01d5c3)
    ("MATHEMATICAL SANS-SERIF SMALL K" . #x01d5c4)
    ("MATHEMATICAL SANS-SERIF SMALL L" . #x01d5c5)
    ("MATHEMATICAL SANS-SERIF SMALL M" . #x01d5c6)
    ("MATHEMATICAL SANS-SERIF SMALL N" . #x01d5c7)
    ("MATHEMATICAL SANS-SERIF SMALL O" . #x01d5c8)
    ("MATHEMATICAL SANS-SERIF SMALL P" . #x01d5c9)
    ("MATHEMATICAL SANS-SERIF SMALL Q" . #x01d5ca)
    ("MATHEMATICAL SANS-SERIF SMALL R" . #x01d5cb)
    ("MATHEMATICAL SANS-SERIF SMALL S" . #x01d5cc)
    ("MATHEMATICAL SANS-SERIF SMALL T" . #x01d5cd)
    ("MATHEMATICAL SANS-SERIF SMALL U" . #x01d5ce)
    ("MATHEMATICAL SANS-SERIF SMALL V" . #x01d5cf)
    ("MATHEMATICAL SANS-SERIF SMALL W" . #x01d5d0)
    ("MATHEMATICAL SANS-SERIF SMALL X" . #x01d5d1)
    ("MATHEMATICAL SANS-SERIF SMALL Y" . #x01d5d2)
    ("MATHEMATICAL SANS-SERIF SMALL Z" . #x01d5d3)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL A" . #x01d5d4)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL B" . #x01d5d5)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL C" . #x01d5d6)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL D" . #x01d5d7)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL E" . #x01d5d8)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL F" . #x01d5d9)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL G" . #x01d5da)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL H" . #x01d5db)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL I" . #x01d5dc)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL J" . #x01d5dd)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL K" . #x01d5de)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL L" . #x01d5df)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL M" . #x01d5e0)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL N" . #x01d5e1)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL O" . #x01d5e2)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL P" . #x01d5e3)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL Q" . #x01d5e4)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL R" . #x01d5e5)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL S" . #x01d5e6)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL T" . #x01d5e7)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL U" . #x01d5e8)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL V" . #x01d5e9)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL W" . #x01d5ea)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL X" . #x01d5eb)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL Y" . #x01d5ec)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL Z" . #x01d5ed)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL A" . #x01d5ee)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL B" . #x01d5ef)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL C" . #x01d5f0)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL D" . #x01d5f1)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL E" . #x01d5f2)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL F" . #x01d5f3)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL G" . #x01d5f4)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL H" . #x01d5f5)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL I" . #x01d5f6)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL J" . #x01d5f7)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL K" . #x01d5f8)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL L" . #x01d5f9)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL M" . #x01d5fa)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL N" . #x01d5fb)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL O" . #x01d5fc)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL P" . #x01d5fd)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL Q" . #x01d5fe)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL R" . #x01d5ff)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL S" . #x01d600)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL T" . #x01d601)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL U" . #x01d602)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL V" . #x01d603)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL W" . #x01d604)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL X" . #x01d605)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL Y" . #x01d606)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL Z" . #x01d607)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL A" . #x01d608)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL B" . #x01d609)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL C" . #x01d60a)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL D" . #x01d60b)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL E" . #x01d60c)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL F" . #x01d60d)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL G" . #x01d60e)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL H" . #x01d60f)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL I" . #x01d610)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL J" . #x01d611)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL K" . #x01d612)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL L" . #x01d613)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL M" . #x01d614)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL N" . #x01d615)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL O" . #x01d616)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL P" . #x01d617)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q" . #x01d618)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL R" . #x01d619)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL S" . #x01d61a)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL T" . #x01d61b)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL U" . #x01d61c)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL V" . #x01d61d)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL W" . #x01d61e)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL X" . #x01d61f)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y" . #x01d620)
    ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z" . #x01d621)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL A" . #x01d622)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL B" . #x01d623)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL C" . #x01d624)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL D" . #x01d625)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL E" . #x01d626)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL F" . #x01d627)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL G" . #x01d628)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL H" . #x01d629)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL I" . #x01d62a)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL J" . #x01d62b)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL K" . #x01d62c)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL L" . #x01d62d)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL M" . #x01d62e)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL N" . #x01d62f)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL O" . #x01d630)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL P" . #x01d631)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL Q" . #x01d632)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL R" . #x01d633)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL S" . #x01d634)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL T" . #x01d635)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL U" . #x01d636)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL V" . #x01d637)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL W" . #x01d638)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL X" . #x01d639)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL Y" . #x01d63a)
    ("MATHEMATICAL SANS-SERIF ITALIC SMALL Z" . #x01d63b)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A" . #x01d63c)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B" . #x01d63d)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C" . #x01d63e)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D" . #x01d63f)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E" . #x01d640)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F" . #x01d641)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G" . #x01d642)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H" . #x01d643)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I" . #x01d644)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J" . #x01d645)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K" . #x01d646)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L" . #x01d647)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M" . #x01d648)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N" . #x01d649)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O" . #x01d64a)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P" . #x01d64b)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q" . #x01d64c)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R" . #x01d64d)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S" . #x01d64e)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T" . #x01d64f)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U" . #x01d650)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V" . #x01d651)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W" . #x01d652)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X" . #x01d653)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y" . #x01d654)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z" . #x01d655)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A" . #x01d656)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B" . #x01d657)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C" . #x01d658)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D" . #x01d659)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E" . #x01d65a)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F" . #x01d65b)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G" . #x01d65c)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H" . #x01d65d)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I" . #x01d65e)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J" . #x01d65f)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K" . #x01d660)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L" . #x01d661)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M" . #x01d662)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N" . #x01d663)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O" . #x01d664)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P" . #x01d665)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q" . #x01d666)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R" . #x01d667)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S" . #x01d668)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T" . #x01d669)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U" . #x01d66a)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V" . #x01d66b)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W" . #x01d66c)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X" . #x01d66d)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y" . #x01d66e)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z" . #x01d66f)
    ("MATHEMATICAL MONOSPACE CAPITAL A" . #x01d670)
    ("MATHEMATICAL MONOSPACE CAPITAL B" . #x01d671)
    ("MATHEMATICAL MONOSPACE CAPITAL C" . #x01d672)
    ("MATHEMATICAL MONOSPACE CAPITAL D" . #x01d673)
    ("MATHEMATICAL MONOSPACE CAPITAL E" . #x01d674)
    ("MATHEMATICAL MONOSPACE CAPITAL F" . #x01d675)
    ("MATHEMATICAL MONOSPACE CAPITAL G" . #x01d676)
    ("MATHEMATICAL MONOSPACE CAPITAL H" . #x01d677)
    ("MATHEMATICAL MONOSPACE CAPITAL I" . #x01d678)
    ("MATHEMATICAL MONOSPACE CAPITAL J" . #x01d679)
    ("MATHEMATICAL MONOSPACE CAPITAL K" . #x01d67a)
    ("MATHEMATICAL MONOSPACE CAPITAL L" . #x01d67b)
    ("MATHEMATICAL MONOSPACE CAPITAL M" . #x01d67c)
    ("MATHEMATICAL MONOSPACE CAPITAL N" . #x01d67d)
    ("MATHEMATICAL MONOSPACE CAPITAL O" . #x01d67e)
    ("MATHEMATICAL MONOSPACE CAPITAL P" . #x01d67f)
    ("MATHEMATICAL MONOSPACE CAPITAL Q" . #x01d680)
    ("MATHEMATICAL MONOSPACE CAPITAL R" . #x01d681)
    ("MATHEMATICAL MONOSPACE CAPITAL S" . #x01d682)
    ("MATHEMATICAL MONOSPACE CAPITAL T" . #x01d683)
    ("MATHEMATICAL MONOSPACE CAPITAL U" . #x01d684)
    ("MATHEMATICAL MONOSPACE CAPITAL V" . #x01d685)
    ("MATHEMATICAL MONOSPACE CAPITAL W" . #x01d686)
    ("MATHEMATICAL MONOSPACE CAPITAL X" . #x01d687)
    ("MATHEMATICAL MONOSPACE CAPITAL Y" . #x01d688)
    ("MATHEMATICAL MONOSPACE CAPITAL Z" . #x01d689)
    ("MATHEMATICAL MONOSPACE SMALL A" . #x01d68a)
    ("MATHEMATICAL MONOSPACE SMALL B" . #x01d68b)
    ("MATHEMATICAL MONOSPACE SMALL C" . #x01d68c)
    ("MATHEMATICAL MONOSPACE SMALL D" . #x01d68d)
    ("MATHEMATICAL MONOSPACE SMALL E" . #x01d68e)
    ("MATHEMATICAL MONOSPACE SMALL F" . #x01d68f)
    ("MATHEMATICAL MONOSPACE SMALL G" . #x01d690)
    ("MATHEMATICAL MONOSPACE SMALL H" . #x01d691)
    ("MATHEMATICAL MONOSPACE SMALL I" . #x01d692)
    ("MATHEMATICAL MONOSPACE SMALL J" . #x01d693)
    ("MATHEMATICAL MONOSPACE SMALL K" . #x01d694)
    ("MATHEMATICAL MONOSPACE SMALL L" . #x01d695)
    ("MATHEMATICAL MONOSPACE SMALL M" . #x01d696)
    ("MATHEMATICAL MONOSPACE SMALL N" . #x01d697)
    ("MATHEMATICAL MONOSPACE SMALL O" . #x01d698)
    ("MATHEMATICAL MONOSPACE SMALL P" . #x01d699)
    ("MATHEMATICAL MONOSPACE SMALL Q" . #x01d69a)
    ("MATHEMATICAL MONOSPACE SMALL R" . #x01d69b)
    ("MATHEMATICAL MONOSPACE SMALL S" . #x01d69c)
    ("MATHEMATICAL MONOSPACE SMALL T" . #x01d69d)
    ("MATHEMATICAL MONOSPACE SMALL U" . #x01d69e)
    ("MATHEMATICAL MONOSPACE SMALL V" . #x01d69f)
    ("MATHEMATICAL MONOSPACE SMALL W" . #x01d6a0)
    ("MATHEMATICAL MONOSPACE SMALL X" . #x01d6a1)
    ("MATHEMATICAL MONOSPACE SMALL Y" . #x01d6a2)
    ("MATHEMATICAL MONOSPACE SMALL Z" . #x01d6a3)
    ("MATHEMATICAL BOLD CAPITAL ALPHA" . #x01d6a8)
    ("MATHEMATICAL BOLD CAPITAL BETA" . #x01d6a9)
    ("MATHEMATICAL BOLD CAPITAL GAMMA" . #x01d6aa)
    ("MATHEMATICAL BOLD CAPITAL DELTA" . #x01d6ab)
    ("MATHEMATICAL BOLD CAPITAL EPSILON" . #x01d6ac)
    ("MATHEMATICAL BOLD CAPITAL ZETA" . #x01d6ad)
    ("MATHEMATICAL BOLD CAPITAL ETA" . #x01d6ae)
    ("MATHEMATICAL BOLD CAPITAL THETA" . #x01d6af)
    ("MATHEMATICAL BOLD CAPITAL IOTA" . #x01d6b0)
    ("MATHEMATICAL BOLD CAPITAL KAPPA" . #x01d6b1)
    ("MATHEMATICAL BOLD CAPITAL LAMDA" . #x01d6b2)
    ("MATHEMATICAL BOLD CAPITAL MU" . #x01d6b3)
    ("MATHEMATICAL BOLD CAPITAL NU" . #x01d6b4)
    ("MATHEMATICAL BOLD CAPITAL XI" . #x01d6b5)
    ("MATHEMATICAL BOLD CAPITAL OMICRON" . #x01d6b6)
    ("MATHEMATICAL BOLD CAPITAL PI" . #x01d6b7)
    ("MATHEMATICAL BOLD CAPITAL RHO" . #x01d6b8)
    ("MATHEMATICAL BOLD CAPITAL THETA SYMBOL" . #x01d6b9)
    ("MATHEMATICAL BOLD CAPITAL SIGMA" . #x01d6ba)
    ("MATHEMATICAL BOLD CAPITAL TAU" . #x01d6bb)
    ("MATHEMATICAL BOLD CAPITAL UPSILON" . #x01d6bc)
    ("MATHEMATICAL BOLD CAPITAL PHI" . #x01d6bd)
    ("MATHEMATICAL BOLD CAPITAL CHI" . #x01d6be)
    ("MATHEMATICAL BOLD CAPITAL PSI" . #x01d6bf)
    ("MATHEMATICAL BOLD CAPITAL OMEGA" . #x01d6c0)
    ("MATHEMATICAL BOLD NABLA" . #x01d6c1)
    ("MATHEMATICAL BOLD SMALL ALPHA" . #x01d6c2)
    ("MATHEMATICAL BOLD SMALL BETA" . #x01d6c3)
    ("MATHEMATICAL BOLD SMALL GAMMA" . #x01d6c4)
    ("MATHEMATICAL BOLD SMALL DELTA" . #x01d6c5)
    ("MATHEMATICAL BOLD SMALL EPSILON" . #x01d6c6)
    ("MATHEMATICAL BOLD SMALL ZETA" . #x01d6c7)
    ("MATHEMATICAL BOLD SMALL ETA" . #x01d6c8)
    ("MATHEMATICAL BOLD SMALL THETA" . #x01d6c9)
    ("MATHEMATICAL BOLD SMALL IOTA" . #x01d6ca)
    ("MATHEMATICAL BOLD SMALL KAPPA" . #x01d6cb)
    ("MATHEMATICAL BOLD SMALL LAMDA" . #x01d6cc)
    ("MATHEMATICAL BOLD SMALL MU" . #x01d6cd)
    ("MATHEMATICAL BOLD SMALL NU" . #x01d6ce)
    ("MATHEMATICAL BOLD SMALL XI" . #x01d6cf)
    ("MATHEMATICAL BOLD SMALL OMICRON" . #x01d6d0)
    ("MATHEMATICAL BOLD SMALL PI" . #x01d6d1)
    ("MATHEMATICAL BOLD SMALL RHO" . #x01d6d2)
    ("MATHEMATICAL BOLD SMALL FINAL SIGMA" . #x01d6d3)
    ("MATHEMATICAL BOLD SMALL SIGMA" . #x01d6d4)
    ("MATHEMATICAL BOLD SMALL TAU" . #x01d6d5)
    ("MATHEMATICAL BOLD SMALL UPSILON" . #x01d6d6)
    ("MATHEMATICAL BOLD SMALL PHI" . #x01d6d7)
    ("MATHEMATICAL BOLD SMALL CHI" . #x01d6d8)
    ("MATHEMATICAL BOLD SMALL PSI" . #x01d6d9)
    ("MATHEMATICAL BOLD SMALL OMEGA" . #x01d6da)
    ("MATHEMATICAL BOLD PARTIAL DIFFERENTIAL" . #x01d6db)
    ("MATHEMATICAL BOLD EPSILON SYMBOL" . #x01d6dc)
    ("MATHEMATICAL BOLD THETA SYMBOL" . #x01d6dd)
    ("MATHEMATICAL BOLD KAPPA SYMBOL" . #x01d6de)
    ("MATHEMATICAL BOLD PHI SYMBOL" . #x01d6df)
    ("MATHEMATICAL BOLD RHO SYMBOL" . #x01d6e0)
    ("MATHEMATICAL BOLD PI SYMBOL" . #x01d6e1)
    ("MATHEMATICAL ITALIC CAPITAL ALPHA" . #x01d6e2)
    ("MATHEMATICAL ITALIC CAPITAL BETA" . #x01d6e3)
    ("MATHEMATICAL ITALIC CAPITAL GAMMA" . #x01d6e4)
    ("MATHEMATICAL ITALIC CAPITAL DELTA" . #x01d6e5)
    ("MATHEMATICAL ITALIC CAPITAL EPSILON" . #x01d6e6)
    ("MATHEMATICAL ITALIC CAPITAL ZETA" . #x01d6e7)
    ("MATHEMATICAL ITALIC CAPITAL ETA" . #x01d6e8)
    ("MATHEMATICAL ITALIC CAPITAL THETA" . #x01d6e9)
    ("MATHEMATICAL ITALIC CAPITAL IOTA" . #x01d6ea)
    ("MATHEMATICAL ITALIC CAPITAL KAPPA" . #x01d6eb)
    ("MATHEMATICAL ITALIC CAPITAL LAMDA" . #x01d6ec)
    ("MATHEMATICAL ITALIC CAPITAL MU" . #x01d6ed)
    ("MATHEMATICAL ITALIC CAPITAL NU" . #x01d6ee)
    ("MATHEMATICAL ITALIC CAPITAL XI" . #x01d6ef)
    ("MATHEMATICAL ITALIC CAPITAL OMICRON" . #x01d6f0)
    ("MATHEMATICAL ITALIC CAPITAL PI" . #x01d6f1)
    ("MATHEMATICAL ITALIC CAPITAL RHO" . #x01d6f2)
    ("MATHEMATICAL ITALIC CAPITAL THETA SYMBOL" . #x01d6f3)
    ("MATHEMATICAL ITALIC CAPITAL SIGMA" . #x01d6f4)
    ("MATHEMATICAL ITALIC CAPITAL TAU" . #x01d6f5)
    ("MATHEMATICAL ITALIC CAPITAL UPSILON" . #x01d6f6)
    ("MATHEMATICAL ITALIC CAPITAL PHI" . #x01d6f7)
    ("MATHEMATICAL ITALIC CAPITAL CHI" . #x01d6f8)
    ("MATHEMATICAL ITALIC CAPITAL PSI" . #x01d6f9)
    ("MATHEMATICAL ITALIC CAPITAL OMEGA" . #x01d6fa)
    ("MATHEMATICAL ITALIC NABLA" . #x01d6fb)
    ("MATHEMATICAL ITALIC SMALL ALPHA" . #x01d6fc)
    ("MATHEMATICAL ITALIC SMALL BETA" . #x01d6fd)
    ("MATHEMATICAL ITALIC SMALL GAMMA" . #x01d6fe)
    ("MATHEMATICAL ITALIC SMALL DELTA" . #x01d6ff)
    ("MATHEMATICAL ITALIC SMALL EPSILON" . #x01d700)
    ("MATHEMATICAL ITALIC SMALL ZETA" . #x01d701)
    ("MATHEMATICAL ITALIC SMALL ETA" . #x01d702)
    ("MATHEMATICAL ITALIC SMALL THETA" . #x01d703)
    ("MATHEMATICAL ITALIC SMALL IOTA" . #x01d704)
    ("MATHEMATICAL ITALIC SMALL KAPPA" . #x01d705)
    ("MATHEMATICAL ITALIC SMALL LAMDA" . #x01d706)
    ("MATHEMATICAL ITALIC SMALL MU" . #x01d707)
    ("MATHEMATICAL ITALIC SMALL NU" . #x01d708)
    ("MATHEMATICAL ITALIC SMALL XI" . #x01d709)
    ("MATHEMATICAL ITALIC SMALL OMICRON" . #x01d70a)
    ("MATHEMATICAL ITALIC SMALL PI" . #x01d70b)
    ("MATHEMATICAL ITALIC SMALL RHO" . #x01d70c)
    ("MATHEMATICAL ITALIC SMALL FINAL SIGMA" . #x01d70d)
    ("MATHEMATICAL ITALIC SMALL SIGMA" . #x01d70e)
    ("MATHEMATICAL ITALIC SMALL TAU" . #x01d70f)
    ("MATHEMATICAL ITALIC SMALL UPSILON" . #x01d710)
    ("MATHEMATICAL ITALIC SMALL PHI" . #x01d711)
    ("MATHEMATICAL ITALIC SMALL CHI" . #x01d712)
    ("MATHEMATICAL ITALIC SMALL PSI" . #x01d713)
    ("MATHEMATICAL ITALIC SMALL OMEGA" . #x01d714)
    ("MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL" . #x01d715)
    ("MATHEMATICAL ITALIC EPSILON SYMBOL" . #x01d716)
    ("MATHEMATICAL ITALIC THETA SYMBOL" . #x01d717)
    ("MATHEMATICAL ITALIC KAPPA SYMBOL" . #x01d718)
    ("MATHEMATICAL ITALIC PHI SYMBOL" . #x01d719)
    ("MATHEMATICAL ITALIC RHO SYMBOL" . #x01d71a)
    ("MATHEMATICAL ITALIC PI SYMBOL" . #x01d71b)
    ("MATHEMATICAL BOLD ITALIC CAPITAL ALPHA" . #x01d71c)
    ("MATHEMATICAL BOLD ITALIC CAPITAL BETA" . #x01d71d)
    ("MATHEMATICAL BOLD ITALIC CAPITAL GAMMA" . #x01d71e)
    ("MATHEMATICAL BOLD ITALIC CAPITAL DELTA" . #x01d71f)
    ("MATHEMATICAL BOLD ITALIC CAPITAL EPSILON" . #x01d720)
    ("MATHEMATICAL BOLD ITALIC CAPITAL ZETA" . #x01d721)
    ("MATHEMATICAL BOLD ITALIC CAPITAL ETA" . #x01d722)
    ("MATHEMATICAL BOLD ITALIC CAPITAL THETA" . #x01d723)
    ("MATHEMATICAL BOLD ITALIC CAPITAL IOTA" . #x01d724)
    ("MATHEMATICAL BOLD ITALIC CAPITAL KAPPA" . #x01d725)
    ("MATHEMATICAL BOLD ITALIC CAPITAL LAMDA" . #x01d726)
    ("MATHEMATICAL BOLD ITALIC CAPITAL MU" . #x01d727)
    ("MATHEMATICAL BOLD ITALIC CAPITAL NU" . #x01d728)
    ("MATHEMATICAL BOLD ITALIC CAPITAL XI" . #x01d729)
    ("MATHEMATICAL BOLD ITALIC CAPITAL OMICRON" . #x01d72a)
    ("MATHEMATICAL BOLD ITALIC CAPITAL PI" . #x01d72b)
    ("MATHEMATICAL BOLD ITALIC CAPITAL RHO" . #x01d72c)
    ("MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL" . #x01d72d)
    ("MATHEMATICAL BOLD ITALIC CAPITAL SIGMA" . #x01d72e)
    ("MATHEMATICAL BOLD ITALIC CAPITAL TAU" . #x01d72f)
    ("MATHEMATICAL BOLD ITALIC CAPITAL UPSILON" . #x01d730)
    ("MATHEMATICAL BOLD ITALIC CAPITAL PHI" . #x01d731)
    ("MATHEMATICAL BOLD ITALIC CAPITAL CHI" . #x01d732)
    ("MATHEMATICAL BOLD ITALIC CAPITAL PSI" . #x01d733)
    ("MATHEMATICAL BOLD ITALIC CAPITAL OMEGA" . #x01d734)
    ("MATHEMATICAL BOLD ITALIC NABLA" . #x01d735)
    ("MATHEMATICAL BOLD ITALIC SMALL ALPHA" . #x01d736)
    ("MATHEMATICAL BOLD ITALIC SMALL BETA" . #x01d737)
    ("MATHEMATICAL BOLD ITALIC SMALL GAMMA" . #x01d738)
    ("MATHEMATICAL BOLD ITALIC SMALL DELTA" . #x01d739)
    ("MATHEMATICAL BOLD ITALIC SMALL EPSILON" . #x01d73a)
    ("MATHEMATICAL BOLD ITALIC SMALL ZETA" . #x01d73b)
    ("MATHEMATICAL BOLD ITALIC SMALL ETA" . #x01d73c)
    ("MATHEMATICAL BOLD ITALIC SMALL THETA" . #x01d73d)
    ("MATHEMATICAL BOLD ITALIC SMALL IOTA" . #x01d73e)
    ("MATHEMATICAL BOLD ITALIC SMALL KAPPA" . #x01d73f)
    ("MATHEMATICAL BOLD ITALIC SMALL LAMDA" . #x01d740)
    ("MATHEMATICAL BOLD ITALIC SMALL MU" . #x01d741)
    ("MATHEMATICAL BOLD ITALIC SMALL NU" . #x01d742)
    ("MATHEMATICAL BOLD ITALIC SMALL XI" . #x01d743)
    ("MATHEMATICAL BOLD ITALIC SMALL OMICRON" . #x01d744)
    ("MATHEMATICAL BOLD ITALIC SMALL PI" . #x01d745)
    ("MATHEMATICAL BOLD ITALIC SMALL RHO" . #x01d746)
    ("MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA" . #x01d747)
    ("MATHEMATICAL BOLD ITALIC SMALL SIGMA" . #x01d748)
    ("MATHEMATICAL BOLD ITALIC SMALL TAU" . #x01d749)
    ("MATHEMATICAL BOLD ITALIC SMALL UPSILON" . #x01d74a)
    ("MATHEMATICAL BOLD ITALIC SMALL PHI" . #x01d74b)
    ("MATHEMATICAL BOLD ITALIC SMALL CHI" . #x01d74c)
    ("MATHEMATICAL BOLD ITALIC SMALL PSI" . #x01d74d)
    ("MATHEMATICAL BOLD ITALIC SMALL OMEGA" . #x01d74e)
    ("MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL" . #x01d74f)
    ("MATHEMATICAL BOLD ITALIC EPSILON SYMBOL" . #x01d750)
    ("MATHEMATICAL BOLD ITALIC THETA SYMBOL" . #x01d751)
    ("MATHEMATICAL BOLD ITALIC KAPPA SYMBOL" . #x01d752)
    ("MATHEMATICAL BOLD ITALIC PHI SYMBOL" . #x01d753)
    ("MATHEMATICAL BOLD ITALIC RHO SYMBOL" . #x01d754)
    ("MATHEMATICAL BOLD ITALIC PI SYMBOL" . #x01d755)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA" . #x01d756)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA" . #x01d757)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA" . #x01d758)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA" . #x01d759)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON" . #x01d75a)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA" . #x01d75b)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA" . #x01d75c)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA" . #x01d75d)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA" . #x01d75e)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA" . #x01d75f)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA" . #x01d760)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL MU" . #x01d761)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL NU" . #x01d762)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL XI" . #x01d763)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON" . #x01d764)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL PI" . #x01d765)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO" . #x01d766)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL" . #x01d767)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA" . #x01d768)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU" . #x01d769)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON" . #x01d76a)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI" . #x01d76b)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI" . #x01d76c)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI" . #x01d76d)
    ("MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA" . #x01d76e)
    ("MATHEMATICAL SANS-SERIF BOLD NABLA" . #x01d76f)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA" . #x01d770)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL BETA" . #x01d771)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA" . #x01d772)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL DELTA" . #x01d773)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON" . #x01d774)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL ZETA" . #x01d775)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL ETA" . #x01d776)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL THETA" . #x01d777)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL IOTA" . #x01d778)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA" . #x01d779)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA" . #x01d77a)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL MU" . #x01d77b)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL NU" . #x01d77c)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL XI" . #x01d77d)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON" . #x01d77e)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL PI" . #x01d77f)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL RHO" . #x01d780)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA" . #x01d781)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA" . #x01d782)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL TAU" . #x01d783)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON" . #x01d784)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL PHI" . #x01d785)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL CHI" . #x01d786)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL PSI" . #x01d787)
    ("MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA" . #x01d788)
    ("MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL" . #x01d789)
    ("MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL" . #x01d78a)
    ("MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL" . #x01d78b)
    ("MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL" . #x01d78c)
    ("MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL" . #x01d78d)
    ("MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL" . #x01d78e)
    ("MATHEMATICAL SANS-SERIF BOLD PI SYMBOL" . #x01d78f)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA" . #x01d790)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA" . #x01d791)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA" . #x01d792)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA" . #x01d793)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON" . #x01d794)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA" . #x01d795)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA" . #x01d796)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA" . #x01d797)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA" . #x01d798)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA" . #x01d799)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA" . #x01d79a)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU" . #x01d79b)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU" . #x01d79c)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI" . #x01d79d)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON" . #x01d79e)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI" . #x01d79f)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO" . #x01d7a0)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL" . #x01d7a1)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA" . #x01d7a2)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU" . #x01d7a3)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON" . #x01d7a4)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI" . #x01d7a5)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI" . #x01d7a6)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI" . #x01d7a7)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA" . #x01d7a8)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA" . #x01d7a9)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA" . #x01d7aa)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA" . #x01d7ab)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA" . #x01d7ac)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA" . #x01d7ad)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON" . #x01d7ae)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA" . #x01d7af)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA" . #x01d7b0)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA" . #x01d7b1)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA" . #x01d7b2)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA" . #x01d7b3)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA" . #x01d7b4)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU" . #x01d7b5)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU" . #x01d7b6)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI" . #x01d7b7)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON" . #x01d7b8)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI" . #x01d7b9)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO" . #x01d7ba)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA" . #x01d7bb)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA" . #x01d7bc)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU" . #x01d7bd)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON" . #x01d7be)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI" . #x01d7bf)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI" . #x01d7c0)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI" . #x01d7c1)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA" . #x01d7c2)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL" . #x01d7c3)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL" . #x01d7c4)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL" . #x01d7c5)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL" . #x01d7c6)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL" . #x01d7c7)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL" . #x01d7c8)
    ("MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL" . #x01d7c9)
    ("MATHEMATICAL BOLD DIGIT ZERO" . #x01d7ce)
    ("MATHEMATICAL BOLD DIGIT ONE" . #x01d7cf)
    ("MATHEMATICAL BOLD DIGIT TWO" . #x01d7d0)
    ("MATHEMATICAL BOLD DIGIT THREE" . #x01d7d1)
    ("MATHEMATICAL BOLD DIGIT FOUR" . #x01d7d2)
    ("MATHEMATICAL BOLD DIGIT FIVE" . #x01d7d3)
    ("MATHEMATICAL BOLD DIGIT SIX" . #x01d7d4)
    ("MATHEMATICAL BOLD DIGIT SEVEN" . #x01d7d5)
    ("MATHEMATICAL BOLD DIGIT EIGHT" . #x01d7d6)
    ("MATHEMATICAL BOLD DIGIT NINE" . #x01d7d7)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO" . #x01d7d8)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT ONE" . #x01d7d9)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT TWO" . #x01d7da)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT THREE" . #x01d7db)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR" . #x01d7dc)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE" . #x01d7dd)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT SIX" . #x01d7de)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN" . #x01d7df)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT" . #x01d7e0)
    ("MATHEMATICAL DOUBLE-STRUCK DIGIT NINE" . #x01d7e1)
    ("MATHEMATICAL SANS-SERIF DIGIT ZERO" . #x01d7e2)
    ("MATHEMATICAL SANS-SERIF DIGIT ONE" . #x01d7e3)
    ("MATHEMATICAL SANS-SERIF DIGIT TWO" . #x01d7e4)
    ("MATHEMATICAL SANS-SERIF DIGIT THREE" . #x01d7e5)
    ("MATHEMATICAL SANS-SERIF DIGIT FOUR" . #x01d7e6)
    ("MATHEMATICAL SANS-SERIF DIGIT FIVE" . #x01d7e7)
    ("MATHEMATICAL SANS-SERIF DIGIT SIX" . #x01d7e8)
    ("MATHEMATICAL SANS-SERIF DIGIT SEVEN" . #x01d7e9)
    ("MATHEMATICAL SANS-SERIF DIGIT EIGHT" . #x01d7ea)
    ("MATHEMATICAL SANS-SERIF DIGIT NINE" . #x01d7eb)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO" . #x01d7ec)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT ONE" . #x01d7ed)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT TWO" . #x01d7ee)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT THREE" . #x01d7ef)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR" . #x01d7f0)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE" . #x01d7f1)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT SIX" . #x01d7f2)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN" . #x01d7f3)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT" . #x01d7f4)
    ("MATHEMATICAL SANS-SERIF BOLD DIGIT NINE" . #x01d7f5)
    ("MATHEMATICAL MONOSPACE DIGIT ZERO" . #x01d7f6)
    ("MATHEMATICAL MONOSPACE DIGIT ONE" . #x01d7f7)
    ("MATHEMATICAL MONOSPACE DIGIT TWO" . #x01d7f8)
    ("MATHEMATICAL MONOSPACE DIGIT THREE" . #x01d7f9)
    ("MATHEMATICAL MONOSPACE DIGIT FOUR" . #x01d7fa)
    ("MATHEMATICAL MONOSPACE DIGIT FIVE" . #x01d7fb)
    ("MATHEMATICAL MONOSPACE DIGIT SIX" . #x01d7fc)
    ("MATHEMATICAL MONOSPACE DIGIT SEVEN" . #x01d7fd)
    ("MATHEMATICAL MONOSPACE DIGIT EIGHT" . #x01d7fe)
    ("MATHEMATICAL MONOSPACE DIGIT NINE" . #x01d7ff)))

;; taken from xmlunicode.el, also by Norman Walsh.
;; Modified a bit by me to use its own help-style buffer

;;;###autoload
(defun unicode-chars-list-chars ()
  "Insert each Unicode character into a buffer.
Lets you see which characters are available for literal display
in your emacs font."
  (interactive)
  (pop-to-buffer "*unicode-chars*")
  (let ((chars unicode-chars-alist)
	char codept name)
    (while chars
      (setq char (car chars))
      (setq chars (cdr chars))
      (setq name (car char))
      (setq codept (cdr char))

      (if (< codept #xffff)
	  (progn
	    (insert (format "#x%06x " codept))
	    (insert-char codept 1)
	    (insert (format " %s\n" name)))))))

(provide 'unicode-chars)
