#!/usr/bin/python

"""A log that retains events for a certain amount of time."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import datetime
import cPickle as pickle

class lazy_log:
	"""A log of pickled objects that retains log data for a given amount of time."""
	def __init__(self, writer, max_age, max_size):
		"""Create a log object."""
		self.writer = writer
		self.messages = []
		self.max_age = max_age
		self.max_size = max_size

	def log(self, object):
		"""Pickle an object, save it to the log, and write it out."""
		time = datetime.datetime.utcnow()
		tuple = (time, object)
		pickled = pickle.dumps(tuple, protocol = pickle.HIGHEST_PROTOCOL)
		self.messages.append((time, pickled))
		self.writer.write(pickled)
		print tuple
		self.scrape_log()

	def scrape_log(self):
		"""Remove expired messages from the log."""
		now = datetime.datetime.utcnow()

		for i in range(0, len(self.messages)):
			if (now - self.messages[i][0]).seconds <= self.max_age:
				del self.messages[0:i]
				break

		if len(self.messages) > self.max_size:
			self.messages = self.messages[len(self.messages) - self.max_size:]

	def dump_log(self):
		"""Retrieve log contents."""
		pickles = []

		self.scrape_log()
		for (time, pickle) in self.messages:
			pickles.append(pickle)

		return pickles

logger = None
