
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2458849.5,
          {-2.090566637,-0.01784081723,420.8341385,1.69269874,0.004489175797,0.8644283913}, /*cmx*/
          {-5.590121079,-0.9122939185,-3.092826781,-0.7260234083}, /*cfx*/
          {-0.1952861963,-0.00446933203,32.01840862,0.7385712933,0.002791157419,0.08719632322}, /*cmy*/
          {-6.088495949,-5.693627036,-1.37137001,-1.067930239}, /*cfy*/
          {1.654542217,-0.03990036231,421.5054266,1.719935396,0.003948157491,0.8685441829}, /*cmz*/
          {-4.021747846,-5.595301544,-1.574658065,-5.440165077} /*cfz*/
     },
     {
          2458879.5,
          {-2.623570954,0.003403276784,418.7089883,1.546390838,0.005487493655,0.8617311177}, /*cmx*/
          {0.311390865,4.959430818,2.308749358,5.30502206}, /*cfx*/
          {-0.3357542471,-0.002267898574,52.77616289,0.6905874031,0.002796243169,0.1291047893}, /*cmy*/
          {6.326220509,0.09222184401,3.940655763,5.095050773}, /*cfy*/
          {0.432059743,-0.04259658928,421.5624736,1.573746446,0.005344223599,0.8706302701}, /*cmz*/
          {1.878192402,0.3018917842,3.857502478,0.589530533} /*cfz*/
     },
     {
          2458909.5,
          {-2.509073432,0.02136484584,415.8633623,1.25650349,0.007413797585,0.8580140248}, /*cmx*/
          {-0.05525451775,4.567738643,1.601414824,5.073527909}, /*cfx*/
          {-0.4058471983,0.002242751794,71.60601222,0.5711534594,0.003259322274,0.1638713074}, /*cmy*/
          {6.050834217,5.916232042,3.01836573,4.923430301}, /*cfy*/
          {-0.8672145107,-0.03453964807,421.6101984,1.282017739,0.007579589382,0.8715839924}, /*cmz*/
          {1.510568043,-0.06815768117,3.213680278,0.3576836836} /*cfz*/
     },
     {
          2458939.5,
          {-1.850515056,0.03118726096,413.1517652,0.8116089359,0.009644782232,0.8540029823}, /*cmx*/
          {5.8870862,4.205524358,1.095819894,4.876688994}, /*cfx*/
          {-0.3347285565,0.006177904504,85.68810333,0.3816052718,0.004160209964,0.1866667135}, /*cmy*/
          {5.754651721,5.535117009,2.342610044,4.757399865}, /*cfy*/
          {-1.915927698,-0.01998604163,421.6400871,0.8277436915,0.00991936794,0.8717253542}, /*cmz*/
          {1.169307078,5.872656544,2.749668961,6.442696475} /*cfz*/
     },
     {
          2458969.5,
          {-0.9035553102,0.03234382173,411.4610715,0.2165291227,0.01072742472,0.8514147042}, /*cmx*/
          {5.583249424,3.862484512,0.7689842674,4.72003048}, /*cfx*/
          {-0.1436533512,0.007321820691,93.25358256,0.1290690271,0.004738260587,0.1942476346}, /*cmy*/
          {5.472712557,5.427525559,1.975639344,4.614262093}, /*cfy*/
          {-2.513766409,-0.005210509039,421.6443425,0.2170802621,0.01101042158,0.870490393}, /*cmz*/
          {0.8655073654,5.579957228,2.437238105,6.284578209} /*cfz*/
     },
     {
          2458999.5,
          {0.07481902264,0.02829685082,411.4529896,-0.4573587812,0.007515237095,0.8506663246}, /*cmx*/
          {5.324586158,3.672000028,0.603182021,4.607965802}, /*cfx*/
          {0.08088645981,0.00563162893,93.15755967,-0.1794822676,0.003673388842,0.1851038973}, /*cmy*/
          {5.220253282,4.606161593,1.939161399,4.501786768}, /*cfy*/
          {-2.660982421,0.00607779406,421.6525196,-0.4746501732,0.007613333997,0.8692757805}, /*cmz*/
          {0.6071273825,5.310354392,2.269313829,6.17245956} /*cfz*/
     },
     {
          2459029.5,
          {0.9261444335,0.02363318668,413.1012098,-0.9274487212,-0.001338353934,0.8514518076}, /*cmx*/
          {5.107360863,3.457875343,-0.3947924177,4.521894945}, /*cfx*/
          {0.2503938025,0.002995477951,85.6517582,-0.3985578452,0.001097920375,0.1634273499}, /*cmy*/
          {4.995247899,4.624542106,9.205455272,4.401948059}, /*cfy*/
          {-2.475582147,0.01424961544,421.6791766,-0.9529721697,-0.00146417766,0.8669167391}, /*cmz*/
          {0.3903514081,5.107477721,1.326779576,6.086161395} /*cfz*/
     },
     {
          2459059.5,
          {1.640741947,0.01905727634,415.3065127,-0.8501377722,-0.009516800371,0.8516141566}, /*cmx*/
          {4.905375393,3.267556838,12.68035685,4.426565415}, /*cfx*/
          {0.3382580958,0.001312344718,74.35702934,-0.3946082952,0.003754211983,0.1416530239}, /*cmy*/
          {4.773779536,4.555897619,42.12236098,4.284676005}, /*cfy*/
          {-2.051481111,0.02260206762,421.6931029,-0.869080046,0.009767121194,0.8635928946}, /*cmz*/
          {0.1889148849,4.914680202,4.895480601,5.991300535} /*cfz*/
     },
     {
          2459089.5,
          {2.220748879,0.01133562201,416.6925765,-0.2514752794,-0.01209705788,0.8493954009}, /*cmx*/
          {4.679627337,3.01997766,6.192404882,4.288493095}, /*cfx*/
          {0.3761211109,0.0009614085488,66.03457719,-0.1614215782,0.005104022018,0.1325769425}, /*cmy*/
          {4.528994392,4.441949599,4.35062336,4.136671661}, /*cfy*/
          {-1.377292624,0.03158929576,421.6601842,-0.2588358829,0.01236329311,0.8599225125}, /*cmz*/
          {6.246757624,4.682506114,4.680169813,5.853194805} /*cfz*/
     },
     {
          2459119.5,
          {2.570265432,-0.002561070215,416.7134971,0.4874891084,-0.01019630354,0.8451764435}, /*cmx*/
          {4.405515052,2.801938089,5.808124276,4.10119602}, /*cfx*/
          {0.406833884,0.0004898033033,65.7121695,0.1512591265,0.004451231379,0.1409803826}, /*cmy*/
          {4.256560721,4.027639404,3.927232598,3.965134153}, /*cfy*/
          {-0.4193910393,0.03746531561,421.6403973,0.4913589737,0.01046055631,0.8571143467}, /*cmz*/
          {5.972722837,4.418446566,4.309575859,5.666334322} /*cfz*/
     },
     {
          2459149.5,
          {2.497678959,-0.02021927915,415.3177165,1.10000822,-0.007044494359,0.8388131597}, /*cmx*/
          {4.082623174,2.454837214,5.207982697,3.872051895}, /*cfx*/
          {0.4265437856,-0.001877979625,73.90605654,0.4193027598,0.003344030081,0.1641838695}, /*cmy*/
          {3.958563318,3.698678736,3.174647382,3.766871536}, /*cfy*/
          {0.7237940972,0.03535485176,421.6531656,1.114670746,0.007235919154,0.8557068447}, /*cmz*/
          {5.64961865,4.087209848,3.756508546,5.437887428} /*cfz*/
     },
     {
          2459179.5,
          {1.883287026,-0.03568467138,412.4861136,1.499751491,-0.004806271559,0.8315788731}, /*cmx*/
          {3.722825877,2.075418537,4.371131483,3.616923513}, /*cfx*/
          {0.3739134857,-0.006522007363,88.29503684,0.6015508996,0.002840928761,0.1966810626}, /*cmy*/
          {3.631501967,3.258046791,2.177803348,3.54360337}, /*cfy*/
          {1.807207545,0.02295552057,421.6869764,1.526390488,0.004805908634,0.855375381}, /*cmz*/
          {5.289611254,3.722264605,2.97154552,5.183736162} /*cfz*/
     },
     {
          2459209.5,
          {0.7963569176,-0.04238348905,408.3477879,1.702598266,-0.00382839317,0.822973558}, /*cmx*/
          {3.340418455,1.676512832,3.326068205,3.34820307}, /*cfx*/
          {0.1768124902,-0.01134583663,105.7330407,0.6973916193,0.002822197527,0.232373994}, /*cmy*/
          {3.279059845,2.766182841,1.204096454,3.301889283}, /*cfy*/
          {2.505565741,0.002908109539,421.7323876,1.744605202,0.003623877866,0.8558682899}, /*cmz*/
          {4.907360856,3.335824651,1.910890923,4.91619926} /*cfz*/
     },
     {
          2459239.5,
          {-0.4975757797,-0.03746481226,403.3714003,1.731929758,-0.003916790218,0.8141344776}, /*cmx*/
          {2.948166589,1.272719561,2.304415081,3.080011093}, /*cfx*/
          {-0.1717908027,-0.01321967144,123.3316365,0.7167433446,0.002811021081,0.2664965681}, /*cmy*/
          {2.911724231,2.255012918,0.3241485001,3.055880178}, /*cfy*/
          {2.58537505,-0.01903928896,421.76932,1.787973528,0.003868841658,0.8573791342}, /*cmz*/
          {4.515858592,2.941419502,0.8500740737,4.649224601} /*cfz*/
     },
     {
          2459269.5,
          {-1.635393351,-0.02287824099,398.2596812,1.620620882,-0.004850114482,0.806944616}, /*cmx*/
          {2.557444686,0.8771028518,1.405403475,2.820432514}, /*cfx*/
          {-0.5773353549,-0.01035462413,138.9497108,0.6721549519,0.002697621977,0.2959999978}, /*cmy*/
          {2.541705588,1.746654451,-0.5848199225,2.815091873}, /*cfy*/
          {1.996497543,-0.03543437431,421.7943933,1.685927516,0.005015502479,0.859954142}, /*cmz*/
          {4.126560768,2.549432988,-0.04853685169,4.391747897} /*cfz*/
     },
     {
          2459299.5,
          {-2.324635253,-0.003973758975,393.7251239,1.376024172,-0.006440248417,0.8020007163}, /*cmx*/
          {2.178565765,0.4988344022,0.7113686379,2.580074532}, /*cfx*/
          {-0.893198952,-0.003689499969,151.3368362,0.5684146514,0.002907016252,0.3188749603}, /*cmy*/
          {2.180372425,1.267877479,4.767227433,2.590854464}, /*cfy*/
          {0.9126928677,-0.04161103448,421.8012581,1.439751624,0.0067953789,0.86332608}, /*cmz*/
          {3.749627783,2.169938279,5.537924894,4.153936614} /*cfz*/
     },
     {
          2459329.5,
          {-2.433236805,0.01259916523,390.2865899,1.003104511,-0.008715581408,0.7997240706}, /*cmx*/
          {1.822119048,0.1452947662,0.19529672,2.366968775}, /*cfx*/
          {-1.001745759,0.003677604946,160.0187266,0.4063876001,0.003721816171,0.334381898}, /*cmy*/
          {1.838817141,0.8462589114,3.992866793,2.390935936}, /*cfy*/
          {-0.3472613988,-0.0369405756,421.7873043,1.049176333,0.009235209817,0.866065823}, /*cmz*/
          {3.395326493,1.813243632,5.006679095,3.94314924} /*cfz*/
     },
     {
          2459359.5,
          {-2.037275023,0.02280837521,388.2007001,0.4802162273,-0.01049284947,0.7995170944}, /*cmx*/
          {1.499122698,6.102734846,6.114451324,2.192502521}, /*cfx*/
          {-0.8840509895,0.008965989953,165.0113084,0.1798127971,0.004494131711,0.3421839229}, /*cmy*/
          {1.527880069,0.5811222194,3.532423914,2.22594983}, /*cfy*/
          {-1.460964005,-0.02532793037,421.7523042,0.4938216555,0.01116338241,0.8679494996}, /*cmz*/
          {3.074322869,1.492932688,4.634241508,3.770530239} /*cfz*/
     },
     {
          2459389.5,
          {-1.340692138,0.02596131368,387.5734415,-0.1645989614,-0.009602005711,0.8018638882}, /*cmx*/
          {1.220203268,5.890157367,5.877209006,2.060522351}, /*cfx*/
          {-0.6087419618,0.01098210733,166.461204,-0.1082509325,0.004035469363,0.3425962078}, /*cmy*/
          {1.257371912,-0.2192056064,3.373251544,2.099283352}, /*cfy*/
          {-2.218053137,-0.01259041323,421.7169195,-0.1933281539,0.01012066922,0.8702059998}, /*cmz*/
          {2.796785025,1.208756164,4.404148924,3.639093607} /*cfz*/
     },
     {
          2459419.5,
          {-0.5587557626,0.02569376821,388.4624622,-0.7632996263,-0.003041372165,0.8064997055}, /*cmx*/
          {0.9884335888,5.626695691,5.852764071,1.964955359}, /*cfx*/
          {-0.2765994608,0.01083751075,164.4112184,-0.3538415718,0.001547576279,0.3359011106}, /*cmy*/
          {1.029200811,6.130726689,3.945840928,2.005225658}, /*cfy*/
          {-2.592887232,-0.002213110244,421.7175839,-0.8229331992,0.003088541887,0.872110743}, /*cmz*/
          {2.565433819,0.9928911219,4.467158708,3.543850474} /*cfz*/
     },
     {
          2459449.5,
          {0.2086055767,0.02554363384,390.5621005,-0.9343537274,0.006598393792,0.8111736307}, /*cmx*/
          {0.7870375508,5.420489399,5.378049727,1.876880819}, /*cfx*/
          {0.04729012439,0.01020464259,159.4127943,-0.4111786834,0.003141315904,0.3246132311}, /*cmy*/
          {0.8260791281,6.079672696,5.803129231,1.914610897}, /*cfy*/
          {-2.657573409,0.006712547879,421.7501248,-0.9882212984,-0.007145824254,0.8724292906}, /*cmz*/
          {2.36341462,0.8017200645,3.873247765,3.453799708} /*cfz*/
     },
     {
          2459479.5,
          {0.9827213062,0.02463183337,392.66875,-0.5029836128,0.01185530019,0.8126387903}, /*cmx*/
          {0.5766580971,5.18893213,5.213692747,1.75924537}, /*cfx*/
          {0.3546812923,0.009661740243,154.0630772,-0.2190441221,0.005122872753,0.3157117305}, /*cmy*/
          {0.6104230582,6.05198247,5.883393735,1.791010296}, /*cfy*/
          {-2.454989722,0.01763294026,421.7480511,-0.5241807343,-0.01258413899,0.8699131203}, /*cmz*/
          {2.151915527,0.5898295155,3.732503297,3.333009713} /*cfz*/
     },
     {
          2459509.5,
          {1.736316744,0.01844685946,393.3712628,0.2353094197,0.01105374454,0.8092211922}, /*cmx*/
          {0.3216939164,5.02455546,4.890557358,1.585901955}, /*cfx*/
          {0.6486237861,0.008104627695,152.1275492,0.105577849,0.004678341534,0.3155274014}, /*cmy*/
          {0.3508731464,5.314100027,5.582479195,1.614141581}, /*cfy*/
          {-1.921733439,0.03017526292,421.7329204,0.2534834664,-0.01170037937,0.8676822569}, /*cmz*/
          {1.896239247,0.3490302659,3.417238081,3.157999543} /*cfz*/
     },
     {
          2459539.5,
          {2.304592099,0.004780947875,392.1930827,0.9068240578,0.007881657431,0.802060892}, /*cmx*/
          {0.01266719279,4.661014791,4.396694784,1.363349921}, /*cfx*/
          {0.8987746154,0.003885664064,155.08788,0.3879423414,0.003415982791,0.3242120731}, /*cmy*/
          {0.04146257001,5.244659016,4.914144379,1.394203152}, /*cfy*/
          {-1.003680005,0.039731459,421.7250085,0.9618844083,-0.008432228404,0.8653766994}, /*cmz*/
          {1.587327575,0.02674135373,2.918647277,2.935614411} /*cfz*/
     },
     {
          2459569.5,
          {2.449543411,-0.01342410865,389.5971164,1.37131265,0.004908253881,0.7928489375}, /*cmx*/
          {5.94298732,4.302073128,3.67844543,1.104479399}, /*cfx*/
          {1.019098705,-0.003319163985,161.5483761,0.5886992215,0.002679655104,0.3374457326}, /*cmy*/
          {5.976290022,4.857904866,3.930403345,1.142706583}, /*cfy*/
          {0.2063036995,0.04029491098,421.7227975,1.459853403,-0.005426075134,0.8626163458}, /*cmz*/
          {1.235493805,5.952373625,2.175695675,2.680279801} /*cfz*/
     },
     {
          2459599.5,
          {2.033163772,-0.03022395697,386.4287941,1.619844335,0.003367252389,0.7838152774}, /*cmx*/
          {5.561816998,3.926458509,2.694902708,0.8318309836}, /*cfx*/
          {0.9161905319,-0.0115765622,169.0789432,0.6990044652,0.002666318885,0.3508187083}, /*cmy*/
          {5.603503384,4.398032909,2.932583207,0.8800970246}, /*cfy*/
          {1.438860847,0.02954716502,421.7068167,1.736085468,-0.004002140802,0.8596908879}, /*cmz*/
          {0.8561702005,5.569486548,1.177264081,2.410866679} /*cfz*/
     },
     {
          2459629.5,
          {1.103642994,-0.03941379641,383.5550383,1.698328038,0.003211163378,0.7771048309}, /*cmx*/
          {5.166971035,3.544615329,1.583670669,0.5556406642}, /*cfx*/
          {0.5588839149,-0.01734815391,175.6375298,0.7339417576,0.002736047589,0.361452205}, /*cmy*/
          {5.219656918,3.905831431,2.033862789,0.6153770501}, /*cfy*/
          {2.339409281,0.009930736163,421.6786063,1.829956347,-0.003965867876,0.8566491306}, /*cmz*/
          {0.4637349189,5.17404032,0.1287810489,2.137436354} /*cfz*/
     },
     {
          2459659.5,
          {-0.1028538746,-0.03809403074,381.5786228,1.636976007,0.003935003971,0.7731790386}, /*cmx*/
          {4.770502493,3.166893683,0.6828405921,0.2894115758}, /*cfx*/
          {0.02603045527,-0.01808607231,180.0332763,0.7032658929,0.002780912656,0.3675690875}, /*cmy*/
          {4.835785834,3.408237518,1.187261826,0.3617995136}, /*cfy*/
          {2.637809251,-0.01235337412,421.6334759,1.77105595,-0.004671894853,0.8556317457}, /*cmz*/
          {0.06999388469,4.778012402,5.522034639,1.874013613} /*cfz*/
     },
     {
          2459689.5,
          {-1.258865112,-0.02693596291,380.7437538,1.461250833,0.00536220062,0.771673456}, /*cmx*/
          {4.382889396,2.799950263,-0.04037584654,6.322568857}, /*cfx*/
          {-0.5239191393,-0.01354627688,181.9506108,0.6171710783,0.002967882624,0.3689973084}, /*cmy*/
          {4.461588193,2.920071709,0.3247511353,6.408114671}, /*cfy*/
          {2.250287608,-0.03004831672,421.5830988,1.581758425,-0.006051656143,0.8550756241}, /*cmz*/
          {5.968271881,4.389954812,4.752293038,1.625334592} /*cfz*/
     },
     {
          2459719.5,
          {-2.071891863,-0.01040886714,380.887951,1.163756816,0.007402373702,0.7736597042}, /*cmx*/
          {4.013813719,2.451073343,5.690931426,6.099749017}, /*cfx*/
          {-0.9329321709,-0.006104303742,181.8037158,0.475053312,0.003495407648,0.3678388038}, /*cmy*/
          {4.106026606,2.456195517,-0.4600639204,6.198115881}, /*cfy*/
          {1.323312516,-0.03843763634,421.5091189,1.254735359,-0.008144952417,0.8561512685}, /*cmz*/
          {5.601644499,4.02131702,4.149035503,1.405925422} /*cfz*/
     },
     {
          2459749.5,
          {-2.378503332,0.005536987797,381.5342696,0.7265231206,0.009735986435,0.7760115496}, /*cmx*/
          {3.67365351,2.129038279,5.277336023,5.910054478}, /*cfx*/
          {-1.113528583,0.001094436337,180.5935912,0.2746407596,0.004287519419,0.3657582313}, /*cmy*/
          {3.778544288,2.028707072,5.231987963,6.019973307}, /*cfy*/
          {0.1498861017,-0.03657224374,421.4236215,0.7752086557,-0.01064373359,0.8575679831}, /*cmz*/
          {5.263568385,3.682541646,3.701857102,1.219117703} /*cfz*/
     },
     {
          2459779.5,
          {-2.204630541,0.01621824385,382.0331258,0.1345219331,0.0105733499,0.7793284544}, /*cmx*/
          {3.373430113,1.889386878,4.993690762,5.764387855}, /*cfx*/
          {-1.078207243,0.006023472914,179.6329694,0.01414993001,0.004428902701,0.3662225149}, /*cmy*/
          {3.488590911,1.089999244,4.90234791,5.882983502}, /*cfy*/
          {-0.9567884484,-0.02803718585,421.3253217,0.1259806927,-0.01140937512,0.8593814252}, /*cmz*/
          {4.96495866,3.417748282,3.410658957,1.076261886} /*cfz*/
     },
     {
          2459809.5,
          {-1.71211611,0.02097059698,381.9405713,-0.5235047413,0.00666788672,0.7791867432}, /*cmx*/
          {3.121322915,1.570235462,4.838543375,5.656493165}, /*cfx*/
          {-0.8959626282,0.008775117565,179.9261736,-0.2624114955,0.002514347161,0.3682834753}, /*cmy*/
          {3.241967488,-11.04655373,4.891491198,5.777914714}, /*cfy*/
          {-1.793491804,-0.01789845378,421.2665769,-0.5894653669,-0.007020879695,0.8601480833}, /*cmz*/
          {4.713886047,3.126496761,3.291912296,0.9714710283} /*cfz*/
     },
     {
          2459839.5,
          {-1.083649901,0.02362889903,381.3597498,-0.9295628253,-0.002825888393,0.7820332583}, /*cmx*/
          {2.911237417,1.366793351,4.241632641,5.574644527}, /*cfx*/
          {-0.6330427405,0.01091507292,181.1887026,-0.4132250241,-0.001846831514,0.3728501335}, /*cmy*/
          {3.030579203,1.355552942,4.147453208,5.691248794}, /*cfy*/
          {-2.330722239,-0.009268717702,421.2962721,-1.022189602,0.003511064256,0.8636785005}, /*cmz*/
          {4.503855198,2.932042579,2.640738756,0.8884651522} /*cfz*/
     },
     {
          2459869.5,
          {-0.3757827244,0.0271130731,380.8842546,-0.7351556336,-0.01051663191,0.7860350617}, /*cmx*/
          {2.711260055,1.159011808,4.287893347,5.474893523}, /*cfx*/
          {-0.3053808686,0.01322546585,182.0838064,-0.2960794502,-0.004898699704,0.3761641609}, /*cmy*/
          {2.823465447,1.218294558,4.336276718,5.582630524}, /*cfy*/
          {-2.618020746,-0.0002509269998,421.3579619,-0.794279494,0.01172692965,0.8681751404}, /*cmz*/
          {4.30279753,2.735292223,2.722052092,0.7855050291} /*cfz*/
     },
     {
          2459899.5,
          {0.4453028443,0.02909993582,380.729218,-0.07208127585,-0.01184476202,0.7908466672}, /*cmx*/
          {2.478022645,0.8283661562,4.028969087,5.325911169}, /*cfx*/
          {0.09488350001,0.01458203757,182.1859741,0.01105478523,-0.005174485293,0.3784289558}, /*cmy*/
          {2.581804452,1.165191653,4.099938071,5.426738543}, /*cfy*/
          {-2.640122834,0.01233212925,421.390007,-0.06039197586,0.01291719024,0.8737416808}, /*cmz*/
          {4.068085221,2.366564059,2.472635842,0.6316065702} /*cfz*/
     },
     {
          2459929.5,
          {1.330946919,0.02448327883,380.7521701,0.6503759534,-0.009050351058,0.7911510672}, /*cmx*/
          {2.189784538,0.6422810518,3.62400603,5.116247407}, /*cfx*/
          {0.5386847294,0.01270647982,182.0328917,0.3267935917,-0.003849635789,0.3777176048}, /*cmy*/
          {2.288521053,-5.564606754,3.546388284,5.214907409}, /*cfy*/
          {-2.270665158,0.02746747191,421.4099346,-0.7268634197,0.009835861363,0.8742029514}, /*cmz*/
          {3.77888082,11.65169367,2.043880098,0.4206471058} /*cfz*/
     },
     {
          2459959.5,
          {2.081230991,0.0114160892,381.0523243,1.191063329,-0.005828513007,0.7913983831}, /*cmx*/
          {1.851518009,0.3054880959,3.029812649,4.865691622}, /*cfx*/
          {0.9281783521,0.006559934112,181.4131278,0.5529034561,-0.002827492567,0.3746498728}, /*cmy*/
          {1.950453297,0.3232383048,2.624685015,4.966929004}, /*cfy*/
          {-1.433429805,0.03976298123,421.4092793,-1.314213554,0.006417021027,0.8749559968}, /*cmz*/
          {3.440531689,5.02085857,1.383201778,6.453638605} /*cfz*/
     },
     {
          2459989.5,
          {2.431381768,-0.007322496391,382.0536096,1.51626255,-0.003727297265,0.7913312423}, /*cmx*/
          {1.479280937,-0.05434122807,2.17589827,4.59175437}, /*cfx*/
          {1.128474319,-0.002456964915,179.3848068,0.6785936071,-0.002753178485,0.3667254892}, /*cmy*/
          {1.58333432,-0.1343898029,1.583193538,4.699215086}, /*cfy*/
          {-0.2177793103,0.04295909472,421.40436,-1.663633773,0.004390454514,0.8710720589}, /*cmz*/
          {3.068797243,4.642789799,0.4696739703,6.181127798} /*cfz*/
     },
     {
          2460019.5,
          {2.210090547,-0.02580268245,384.1067464,1.661993647,-0.00308763899,0.794480479}, /*cmx*/
          {1.089106232,5.85585844,1.119352635,4.311401755}, /*cfx*/
          {1.052144919,-0.01092758596,175.0867707,0.7211107813,-0.003020980805,0.3541499963}, /*cmy*/
          {1.202229943,5.650173076,0.7174117481,4.428685734}, /*cfy*/
          {1.093459994,0.03450924128,421.3674644,-1.812826753,0.003954445486,0.868319742}, /*cmz*/
          {2.679267872,4.250063836,-0.5476738517,5.902355193} /*cfz*/
     },
     {
          2460049.5,
          {1.418410398,-0.03787803378,387.2559392,1.666872541,-0.003453686652,0.7968462103}, /*cmx*/
          {0.6939991742,5.477926036,0.1455730097,4.038127825}, /*cfx*/
          {0.7140294332,-0.01555914184,168.1977418,0.7020445156,-0.003098906699,0.3353495141}, /*cmy*/
          {0.8193927455,5.126013987,-0.04482594969,4.16851052}, /*cfy*/
          {2.138846969,0.01633756803,421.3223652,-1.807642113,0.004298879729,0.8623037819}, /*cmz*/
          {2.284609661,3.852368394,4.806888557,5.627992871} /*cfz*/
     },
     {
          2460079.5,
          {0.2584420536,-0.03991841149,391.1799792,1.555031012,-0.004545648732,0.8022368925}, /*cmx*/
          {0.304347464,5.103276941,5.609638821,3.78005742}, /*cfx*/
          {0.2367694006,-0.01522027175,159.0497589,0.638536312,-0.003006358356,0.3137005034}, /*cmy*/
          {0.4448060926,4.592114297,5.453742349,3.92657308}, /*cfy*/
          {2.627888449,-0.005573807969,421.2619925,-1.672040963,0.005245809181,0.8585758505}, /*cmz*/
          {1.894933886,3.460569998,3.993358703,5.368996805} /*cfz*/
     },
     {
          2460109.5,
          {-0.9581770316,-0.03167225253,395.3209282,1.3230396,-0.006364336008,0.8052070458}, /*cmx*/
          {-0.07081845869,4.737537101,4.938328043,3.546342861}, /*cfx*/
          {-0.225078149,-0.01117486493,148.6816817,0.5355397888,-0.003053714869,0.290583829}, /*cmy*/
          {0.08711922247,4.063096697,4.580943496,3.711458266}, /*cfy*/
          {2.445918191,-0.02416530185,421.1983079,-1.409525886,0.006978126294,0.854715901}, /*cmz*/
          {1.51934011,3.083071347,3.309360321,5.134090944} /*cfz*/
     },
     {
          2460139.5,
          {-1.914212293,-0.01700953268,398.9357143,0.9496612192,-0.008868761305,0.8098334545}, /*cmx*/
          {5.861010307,4.394836606,4.434213773,3.343572013}, /*cfx*/
          {-0.5585682281,-0.006172685094,138.8478742,0.3838989055,-0.003665860953,0.2725114465}, /*cmy*/
          {6.037643309,3.556434096,3.78069378,3.527248198}, /*cfy*/
          {1.704191614,-0.03424947677,421.131198,-1.003018326,0.009492151456,0.8532439178}, /*cmz*/
          {1.167426172,2.730246513,2.786372236,4.931310829} /*cfz*/
     },
     {
          2460169.5,
          {-2.413103834,-0.001614931164,401.3061991,0.4075985061,-0.01090739987,0.8097543642}, /*cmx*/
          {5.544075028,4.101626029,4.079377828,3.182521113}, /*cfx*/
          {-0.7379506382,-0.0022536878,131.9554161,0.1697949348,-0.004394343773,0.2630274941}, /*cmy*/
          {5.737253238,3.019327479,3.254712999,3.380827478}, /*cfy*/
          {0.660051086,-0.03462270029,421.0639201,-0.421516447,0.01146197508,0.8508408263}, /*cmz*/
          {0.8501471594,2.417117557,2.422072279,4.772858921} /*cfz*/
     },
     {
          2460199.5,
          {-2.447334719,0.009749832186,401.8240728,-0.2766631261,-0.009359893979,0.8087969768}, /*cmx*/
          {5.271926217,3.738636602,3.88166995,3.067019222}, /*cfx*/
          {-0.8027424,0.0003642237627,130.4150813,-0.1168361311,-0.003656424033,0.2672976638}, /*cmy*/
          {5.473542494,3.286537451,3.028668872,3.269981383}, /*cfy*/
          {-0.3857341668,-0.02887660989,421.001133,0.3024075746,0.009759090615,0.8505957482}, /*cmz*/
          {0.5783228286,2.124736822,2.215299948,4.66028954} /*cfz*/
     },
     {
          2460229.5,
          {-2.146006213,0.01669320894,400.3400148,-0.8665599666,-0.001752574447,0.8054594969}, /*cmx*/
          {5.046627224,3.56839188,4.386504588,2.98589847}, /*cfx*/
          {-0.7928932953,0.003007099347,134.9752362,-0.3478798079,-0.0004612792783,0.2814124602}, /*cmy*/
          {5.243832501,2.860147742,3.640658171,3.180668535}, /*cfy*/
          {-1.250552674,-0.02214222009,421.0159108,0.9267349093,0.001535949033,0.8508517379}, /*cmz*/
          {0.3539440109,1.923519125,2.711947084,4.583255771} /*cfz*/
     },
     {
          2460259.5,
          {-1.649034566,0.02280352002,397.6409431,-0.9286956838,-0.008661769812,0.8063306817}, /*cmx*/
          {4.847392984,3.386633525,6.458583717,2.900765151}, /*cfx*/
          {-0.7059732756,0.006762785459,142.7055258,-0.3642673802,0.003586812255,0.2975195255}, /*cmy*/
          {5.030298471,2.66235857,9.026465395,3.078637488}, /*cfy*/
          {-1.912723194,-0.01639199094,421.0713927,0.9877010316,-0.009421004452,0.8569321269}, /*cmz*/
          {0.155520079,1.733098332,7.973376955,4.496664189} /*cfz*/
     },
     {
          2460289.5,
          {-0.9624071193,0.02971648669,395.4330325,-0.379030725,-0.0125014488,0.810753909}, /*cmx*/
          {4.631296665,3.183631229,6.292085321,2.774227496}, /*cfx*/
          {-0.5007288313,0.01084576426,148.4777887,-0.1406040316,0.005054787228,0.3065330242}, /*cmy*/
          {4.798900414,2.221807042,2.5880747,2.936457715}, /*cfy*/
          {-2.409047897,-0.008080117899,421.124577,0.3925284215,-0.0134186603,0.8635018329}, /*cmz*/
          {6.222546006,1.507072892,1.511935662,4.367376534} /*cfz*/
     },
     {
          2460319.5,
          {-0.05757735019,0.03426950826,395.0209734,0.3849776457,-0.01053478865,0.818015955}, /*cmx*/
          {4.3655037,2.87985896,5.949312931,2.588706511}, /*cfx*/
          {-0.1674989182,0.0129388895,149.327862,-0.1865269917,0.004226528387,0.3048292253}, /*cmy*/
          {4.523689707,5.767343969,2.115985746,2.743676257}, /*cfy*/
          {-2.66074639,0.005884251829,421.1591925,-0.425955983,-0.01122589631,0.8704748069}, /*cmz*/
          {5.955851462,1.271560989,1.15475247,4.178784482} /*cfz*/
     },
     {
          2460349.5,
          {0.992168212,0.03138116013,396.6237373,1.016195445,-0.007179405681,0.8265491616}, /*cmx*/
          {4.046656287,2.571311737,5.418952419,2.356605743}, /*cfx*/
          {0.2310241472,0.01099117139,144.9136242,-0.4280361573,0.003220698316,0.2916801277}, /*cmy*/
          {4.203793316,5.204621658,1.283576617,2.51319177}, /*cfy*/
          {-2.484885531,0.02340677498,421.1974186,-1.09625184,-0.00750705301,0.8738956039}, /*cmz*/
          {5.635758568,0.9341566978,0.6036326169,3.944221776} /*cfz*/
     },
     {
          2460379.5,
          {1.950962318,0.01906858789,399.8838764,1.429591515,-0.004673953405,0.8360925219}, /*cmx*/
          {3.688907114,2.216734583,4.634495921,2.091484361}, /*cfx*/
          {0.5664967147,0.005265330177,135.6471765,-0.5817831534,0.00309001613,0.2682430444}, /*cmy*/
          {3.853609562,4.695169093,0.3021195974,2.2591339}, /*cfy*/
          {-1.773988955,0.03818029368,421.2199823,-1.524281746,-0.004790867455,0.8760848885}, /*cmz*/
          {5.276485992,0.5686256993,-0.2068046577,3.678379458} /*cfz*/
     },
     {
          2460409.5,
          {2.529855348,-0.0005301577255,404.256715,1.644965683,-0.003711706626,0.8449252827}, /*cmx*/
          {3.308674127,1.835713492,3.662001404,1.81614016}, /*cfx*/
          {0.7232157985,-0.001710445841,122.0779095,-0.6632778906,0.003259512181,0.2360006681}, /*cmy*/
          {3.490077052,4.151512582,-0.5328208182,2.005533027}, /*cfy*/
          {-0.6051154406,0.04388468705,421.2319113,-1.735785804,-0.003769525006,0.875280378}, /*cmz*/
          {4.894378329,0.1827397075,5.08245492,3.400795149} /*cfz*/
     },
     {
          2460439.5,
          {2.509731079,-0.02135532624,409.0387964,1.708556165,-0.003788890802,0.8531482838}, /*cmx*/
          {2.919512572,1.440594566,2.681589677,1.539525939}, /*cfx*/
          {0.6655487377,-0.006565960241,105.0265059,-0.6961316088,0.003220009498,0.1976384116}, /*cmy*/
          {3.129130501,3.59096738,4.988808291,1.765144439}, /*cfy*/
          {0.7380397959,0.03795925059,421.2378046,-1.786856631,-0.003843636671,0.8727160925}, /*cmz*/
          {4.502974605,6.071920314,4.089174591,3.122120173} /*cfz*/
     },
     {
          2460469.5,
          {1.851565898,-0.03665759395,413.5174531,1.64268737,-0.004416037612,0.8580876629}, /*cmx*/
          {2.531748397,1.039886281,1.795830514,1.275567615}, /*cfx*/
          {0.4608727151,-0.007543176602,85.804688,-0.6895370241,0.002928546547,0.1564220805}, /*cmy*/
          {2.786741182,3.035587729,4.176154494,1.559724383}, /*cfy*/
          {1.89828105,0.02199786967,421.2475725,-1.703188838,-0.004484579445,0.8691576524}, /*cmz*/
          {4.112660071,5.679209999,3.229324361,2.854822085} /*cfz*/
     },
     {
          2460499.5,
          {0.7314755616,-0.04164559798,417.0917419,1.456074,-0.005856563475,0.8596093405}, /*cmx*/
          {2.154190741,0.6438551701,0.9961928306,1.029602157}, /*cfx*/
          {0.2309513385,-0.005463908814,66.32550249,-0.6367739263,0.002803876585,0.117434052}, /*cmy*/
          {2.48242039,2.508050689,3.222967261,1.407220823}, /*cfy*/
          {2.563154308,0.001630009083,421.2558051,-1.501134572,-0.006000800849,0.8644825851}, /*cmz*/
          {3.732539933,5.296920024,2.472748664,2.604382773} /*cfz*/
     },
     {
          2460529.5,
          {-0.5389836732,-0.03569647784,419.4597588,1.127955149,-0.008143748475,0.8572962923}, /*cmx*/
          {1.79564231,0.2649683697,0.3645306048,0.8131813804}, /*cfx*/
          {0.06814572476,-0.002862631029,49.14456004,-0.5211239176,0.003450197029,0.08647651322}, /*cmy*/
          {2.239955561,2.024840191,2.280346448,1.330438982}, /*cfy*/
          {2.599219465,-0.01673479077,421.2683495,-1.158493643,-0.00831869845,0.859639842}, /*cmz*/
          {3.371698363,4.9332112,1.882831932,2.38549127} /*cfz*/
     },
     {
          2460559.5,
          {-1.620709161,-0.02294169189,420.6697186,0.6351139445,-0.01078428912,0.8531756439}, /*cmx*/
          {1.466525838,6.205222175,-0.07927173493,0.6341719666}, /*cfx*/
          {-0.01371590431,-0.001951447513,37.16104247,-0.322580965,0.004668181646,0.06910138002}, /*cmy*/
          {2.065894011,1.604077075,1.653020684,1.296773438}, /*cfy*/
          {2.0789828,-0.02781744052,421.2663633,-0.6506526258,-0.01096415513,0.8554822959}, /*cmz*/
          {3.040911653,4.600862296,1.462521232,2.205335313} /*cfz*/
     },
     {
          2460589.5,
          {-2.310499952,-0.009132646822,421.0318953,-0.03658609094,-0.01090267228,0.8502019562}, /*cmx*/
          {1.17813757,5.771513378,5.94093834,0.5023959346}, /*cfx*/
          {-0.06998034393,-0.002849371928,32.45839921,-0.03509151916,0.005017488236,0.06758679132}, /*cmy*/
          {1.880449694,1.130651127,1.346388114,1.183521379}, /*cfy*/
          {1.229723081,-0.03054453814,421.2498977,0.03526412428,-0.01115767436,0.8525731398}, /*cmz*/
          {2.751852825,4.291857501,1.196614339,2.075432356} /*cfz*/
     },
     {
          2460619.5,
          {-2.580643292,0.001582265382,420.7818146,0.7287639035,-0.005005120996,0.8478343722}, /*cmx*/
          {0.9374610671,8.815060635,5.931050926,6.695126548}, /*cfx*/
          {-0.1573405932,-0.003720968261,35.55766665,-0.2813573498,0.002675237698,0.08180807475}, /*cmy*/
          {1.571236526,-2.032779033,1.352651804,0.9598754597}, /*cfy*/
          {0.313224207,-0.02839817728,421.248794,0.7442438008,-0.005128031076,0.8513374568}, /*cmz*/
          {2.511666149,4.08034817,1.130277022,1.988283021} /*cfz*/
     },
     {
          2460649.5,
          {-2.531872687,0.01044511229,419.8527586,1.027866313,0.005993665048,0.8457603396}, /*cmx*/
          {0.7329639544,2.359399829,5.355445037,6.619800828}, /*cfx*/
          {-0.2738741578,-0.002473655037,45.54139629,-0.4382425646,-0.00195308977,0.1048902614}, /*cmy*/
          {1.211668461,4.09701217,0.8090858418,0.7517193121}, /*cfy*/
          {-0.5368038512,-0.0260309043,421.2857046,1.052118045,0.006039406536,0.8513020975}, /*cmz*/
          {2.30856556,3.889342275,0.6445214877,1.914940463} /*cfz*/
     },
     {
          2460679.5,
          {-2.223230788,0.02039287684,418.4726959,0.6405476508,0.01228329382,0.8449725327}, /*cmx*/
          {0.527163551,2.177768041,5.304349564,6.513693868}, /*cfx*/
          {-0.3508239929,0.0008647446175,56.61621433,-0.3059534038,-0.004810426782,0.1212162665}, /*cmy*/
          {0.8986512911,3.881753316,0.8854621089,0.5769783432}, /*cfy*/
          {-1.323611681,-0.02358697133,421.3041452,0.6568748108,0.01261603689,0.8531664031}, /*cmz*/
          {2.104079589,3.687847338,0.5496809931,1.809378781} /*cfz*/
     },
     {
          2460709.5,
          {-1.611693481,0.03145278599,417.7337544,-0.119609961,0.01175353573,0.8490735691}, /*cmx*/
          {0.2804494906,1.875525076,5.019061446,6.354321203}, /*cfx*/
          {-0.3224047885,0.004039915808,61.36009298,0.05050611616,-0.004878834216,0.1214023383}, /*cmy*/
          {0.6099961042,-0.8943123277,0.5660421674,0.4014751607}, /*cfy*/
          {-2.048732905,-0.01629559096,421.3099222,-0.1236412595,0.0120728489,0.8571495363}, /*cmz*/
          {1.857737018,3.456459859,0.2608590968,1.649451525} /*cfz*/
     },
     {
          2460739.5,
          {-0.6607832841,0.03905299586,418.281526,-0.8288516469,0.008317387766,0.8563327257}, /*cmx*/
          {-0.01931862788,1.611462556,4.527579184,6.142572961}, /*cfx*/
          {-0.1957180532,0.004636592616,57.12685171,-0.2957229571,-0.003871794939,0.1048048104}, /*cmy*/
          {0.3211918866,-12.0868437,-0.07306618542,6.509596474}, /*cfy*/
          {-2.550034489,-0.001875487608,421.3329424,-0.8523862974,0.008381812708,0.8616369318}, /*cmz*/
          {1.557278396,3.13765353,6.076373519,1.436824936} /*cfz*/
     },
     {
          2460769.5,
          {0.5299631264,0.03797106855,419.7120927,-1.316142231,0.005517129473,0.8641248917}, /*cmx*/
          {5.921135236,1.255883285,3.787391161,5.896509035}, /*cfx*/
          {-0.05207247313,0.002190897565,45.19934778,-0.5100162823,-0.003214599066,0.07540632567}, /*cmy*/
          {0.05446221549,-0.03476802586,5.338668211,6.394759334}, /*cfy*/
          {-2.606085738,0.01725225928,421.3680829,-1.347752466,0.005296713516,0.8661985717}, /*cmz*/
          {1.213017433,2.788548312,5.37965498,1.188722481} /*cfz*/
     },
     {
          2460799.5,
          {1.688172289,0.02623232408,421.1465306,-1.593211634,0.00416545241,0.8707924641}, /*cmx*/
          {5.551415575,0.8642932606,2.818780758,5.630616596}, /*cfx*/
          {0.01282801139,-0.001390377805,28.7021267,-0.6477240591,-0.003036946634,0.04200119286}, /*cmy*/
          {6.204553832,5.737540844,4.437796832,6.577917286}, /*cfy*/
          {-2.078342129,0.03444352451,421.4086552,-1.625695044,0.003671887148,0.8702650308}, /*cmz*/
          {0.8412875312,2.413600318,4.411912843,0.9204395654} /*cfz*/
     },
     {
          2460829.5,
          {2.488145028,0.006317020653,421.7817379,-1.69790201,0.003996724877,0.8742193779}, /*cmx*/
          {5.168342046,0.4540702104,1.850898554,5.359143231}, /*cfx*/
          {-0.03478260975,-0.003246748313,16.50115104,-0.7180842955,-0.002926546601,0.03977986782}, /*cmy*/
          {6.701549039,5.218879921,3.587085831,13.8302469}, /*cfy*/
          {-1.026669115,0.04353983762,421.4541772,-1.727521601,0.003450191842,0.8737565314}, /*cmz*/
          {0.4560276795,2.025933188,3.394927171,0.6466164839} /*cfz*/
     },
     {
          2460859.5,
          {2.675000087,-0.01522559556,421.1794042,-1.671641695,0.004417374018,0.8734516832}, /*cmx*/
          {4.782664081,0.03878762558,0.9158651365,5.091101209}, /*cfx*/
          {-0.1390309921,-0.001755076763,27.5342268,-0.7266197272,-0.002729190838,0.07705525346}, /*cmy*/
          {1.047349852,4.704880509,2.724140112,1.546979268}, /*cfy*/
          {0.2962678851,0.04105880021,421.5031473,-1.697121232,0.00399871175,0.8751368804}, /*cmz*/
          {0.06828760498,1.63579912,2.447322877,0.3763282978} /*cfz*/
     },
     {
          2460889.5,
          {2.199882384,-0.03183581307,419.3692431,-1.518139398,0.005466573343,0.8685105308}, /*cmx*/
          {4.403173478,5.914046925,0.08389709672,4.837954583}, /*cfx*/
          {-0.1941491877,0.002238611342,47.43973694,-0.6748661132,-0.002672442483,0.11767423}, /*cmy*/
          {0.9575965627,4.210091649,1.775116407,1.461414199}, /*cfy*/
          {1.543220711,0.02806887853,421.5527747,-1.54110099,0.00527069411,0.8740647615}, /*cmz*/
          {5.970327627,1.252256606,1.649797805,6.404302842} /*cfz*/
     },
     {
          2460919.5,
          {1.222821742,-0.03875009437,416.8279796,-1.236129622,0.007606622982,0.8608278081}, /*cmx*/
          {4.038909285,5.525367059,5.682889269,4.607878898}, /*cfx*/
          {-0.1237064589,0.006023555321,65.87619059,-0.5596549433,-0.003199538414,0.1511839114}, /*cmy*/
          {0.6994920408,3.752487265,0.8364058699,1.301376512}, /*cfy*/
          {2.389198698,0.009681098056,421.6044516,-1.255405826,0.007594054513,0.8719080196}, /*cmz*/
          {5.604956772,0.8833630848,1.008806503,6.172098488} /*cfz*/
     },
     {
          2460949.5,
          {0.0431443783,-0.03586343334,414.3510354,-0.7917593773,0.01019662531,0.8526222799}, /*cmx*/
          {3.700158994,5.166624985,5.194458106,4.412428843}, /*cfx*/
          {0.06361667475,0.007114282403,79.73530514,-0.3727217114,-0.004319633253,0.172653915}, /*cmy*/
          {0.4103234262,3.372364511,0.1703635484,1.138237121}, /*cfy*/
          {2.672210042,-0.007725316867,421.6366708,-0.8034424788,0.01033378709,0.868121692}, /*cmz*/
          {5.265685794,0.5415160487,0.5513298801,5.975379894} /*cfz*/
     },
     {
          2460979.5,
          {-1.034130072,-0.02674104586,412.8451914,-0.1726136483,0.01148972721,0.8458974449}, /*cmx*/
          {3.399052368,4.826729165,4.880375348,4.260509414}, /*cfx*/
          {0.2811758399,0.004908843288,86.9479808,-0.1100679832,-0.005039482515,0.1786505742}, /*cmy*/
          {0.1320192367,3.302268373,6.113414468,0.9949062351}, /*cfy*/
          {2.424985677,-0.01891661002,421.6413817,-0.1710714685,0.01170023152,0.8635952523}, /*cmz*/
          {4.964541738,0.245953831,0.2501639607,5.823360129} /*cfz*/
     },
     {
          2461009.5,
          {-1.831820778,-0.01651705483,413.0177799,0.5408890225,0.007490085412,0.8432239329}, /*cmx*/
          {3.145105987,4.632226316,4.742100499,4.153614321}, /*cfx*/
          {0.4282145974,0.001068419089,85.99379833,-0.2144236981,-0.003699989629,0.1680027865}, /*cmy*/
          {6.165288389,-0.6127771491,6.122457972,0.8821767782}, /*cfy*/
          {1.843610172,-0.02390045856,421.638202,0.5594444278,0.007525488571,0.8587095011}, /*cmz*/
          {4.710867815,6.273760407,6.393198058,5.717104129} /*cfz*/
     },
     {
          2461039.5,
          {-2.324498244,-0.007799222753,414.7892849,0.9945093814,-0.002680658173,0.8440061446}, /*cmx*/
          {2.93353317,4.432070977,4.081911447,4.073378138}, /*cfx*/
          {0.4560939872,-0.001820086271,77.17194496,-0.4343228875,-0.001285847805,0.1451413409}, /*cmy*/
          {5.940152073,5.661913891,1101.079925,0.7814811314}, /*cfy*/
          {1.12472368,-0.02660761815,421.6630523,1.019193678,-0.002842838905,0.8553081149}, /*cmz*/
          {4.499829746,6.076531906,5.75896942,5.638361184} /*cfz*/
     },
     {
          2461069.5,
          {-2.56538516,0.001445766326,416.8625119,0.8073001831,-0.01086344846,0.8441469217}, /*cmx*/
          {2.732894991,4.241662322,4.236428983,3.982254275}, /*cfx*/
          {0.3985455785,-0.00257586958,65.10955122,-0.3874197045,-0.004375727503,0.1229844972}, /*cmy*/
          {5.711214718,5.587310459,2.352732065,0.6630298402}, /*cfy*/
          {0.3248731447,-0.0300343835,421.6681546,0.8236549448,-0.01109342623,0.853440653}, /*cmz*/
          {4.299854676,5.883807947,5.873431098,5.547648133} /*cfz*/
     },
     {
          2461099.5,
          {-2.527299236,0.01378816923,417.9575429,0.1208714973,-0.01197516582,0.8436544747}, /*cmx*/
          {2.501130411,3.925274645,4.003627821,3.842691243}, /*cfx*/
          {0.3220999036,-0.002391546522,57.45499056,-0.1137197283,-0.005127745476,0.1154488242}, /*cmy*/
          {5.455553883,5.478709501,2.214501791,0.5158901482}, /*cfy*/
          {-0.5841430992,-0.03114383901,421.6361719,0.1230053107,-0.01213748932,0.8527150578}, /*cmz*/
          {4.068555959,5.637834216,5.635396175,5.409896863} /*cfz*/
     },
     {
          2461129.5,
          {-2.106760168,0.02805201253,417.7745692,-0.6097024381,-0.009102068323,0.8427660994}, /*cmx*/
          {2.217986654,3.760339539,3.580702974,3.65086537}, /*cfx*/
          {0.2533799121,-0.003371795103,58.58548407,0.1990421704,-0.004035552112,0.1262079724}, /*cmy*/
          {5.179900349,5.040787604,1.734000445,6.629937113}, /*cfy*/
          {-1.537695721,-0.02524870852,421.6145422,-0.6201849698,-0.009156639519,0.8536999192}, /*cmz*/
          {3.785445593,5.370798377,5.228502476,5.219176838} /*cfz*/
     },
     {
          2461159.5,
          {-1.247472311,0.03869735046,416.3498554,-1.152199179,-0.005865604429,0.8417947467}, /*cmx*/
          {1.888914354,3.406001988,2.931449278,3.419353181}, /*cfx*/
          {0.1540312355,-0.006167653153,67.9378154,0.4402269616,-0.002902751466,0.1514577062}, /*cmy*/
          {4.885114364,4.680670323,0.9275424239,6.437804554}, /*cfy*/
          {-2.311091374,-0.0108202494,421.6232819,-1.171608319,-0.005863559874,0.8556061145}, /*cmz*/
          {3.456027199,5.035136907,4.615134316,4.987654621} /*cfz*/
     },
     {
          2461189.5,
          {-0.0633063348,0.04053215614,413.6532892,-1.473815951,-0.004016008613,0.8392855673}, /*cmx*/
          {1.528389499,3.025598376,2.040250086,3.165652855}, /*cfx*/
          {-0.03373703636,-0.009306334327,82.73211583,0.5904153156,-0.002491316999,0.1853170493}, /*cmy*/
          {4.563341749,4.23672957,-0.06608676988,6.22061824}, /*cfy*/
          {-2.642464045,0.009092167347,421.6496268,-1.501855844,-0.003927173395,0.8592796481}, /*cmz*/
          {3.0951199,4.670653546,3.752819002,4.733914684} /*cfz*/
     },
     {
          2461219.5,
          {1.169275989,0.0313181407,409.8135555,-1.620274498,-0.003433462182,0.8343204395}, /*cmx*/
          {1.150342722,2.630622378,0.9990271827,2.900384666}, /*cfx*/
          {-0.319211818,-0.01009566464,99.95944328,0.6628708222,-0.002449147532,0.2219277792}, /*cmy*/
          {4.218041775,3.7531503,5.283505489,5.984831572}, /*cfy*/
          {-2.359831273,0.0282644012,421.6944867,-1.657703368,-0.003273254527,0.8633364011}, /*cmz*/
          {2.716981454,4.288812596,2.705886256,4.4673422} /*cfz*/
     },
     {
          2461249.5,
          {2.120403672,0.01367503997,405.2140566,-1.623706592,-0.003744190799,0.8288953056}, /*cmx*/
          {0.7658093554,2.234212492,0.02589914366,2.636486659}, /*cfx*/
          {-0.6302949805,-0.006883414757,117.1334827,0.6724652486,-0.002423032916,0.2570291776}, /*cmy*/
          {3.859485511,3.257430263,4.401916062,5.744527674}, /*cfy*/
          {-1.489037343,0.04063397633,421.7323931,-1.669632797,-0.00365071537,0.8676906037}, /*cmz*/
          {2.332872304,3.902261236,1.721823885,4.204615767} /*cfz*/
     },
     {
          2461279.5,
          {2.530530478,-0.006562118576,400.4471826,-1.505614711,-0.004828562139,0.8226054651}, /*cmx*/
          {0.3842679477,1.846059592,5.458911683,2.380229165}, /*cfx*/
          {-0.8414289169,-0.0003337169828,132.4666197,0.6269303681,-0.002457328912,0.2868973984}, /*cmy*/
          {3.498826883,2.769443693,3.471781612,5.507220005}, /*cfy*/
          {-0.2445708099,0.04214728954,421.7675514,-1.558888499,-0.004886617334,0.8715215367}, /*cmz*/
          {1.952383295,3.518683833,0.8536520904,3.950238268} /*cfz*/
     },
     {
          2461309.5,
          {2.32457395,-0.02303273042,396.138404,-1.260053263,-0.006754369298,0.8182900481}, /*cmx*/
          {0.0150202376,1.47544417,4.800440162,2.144965584}, /*cfx*/
          {-0.8504493706,0.006837683746,144.8086768,0.5244758856,-0.002956367698,0.3101094759}, /*cmy*/
          {3.146790302,2.313897363,2.559613228,5.287055783}, /*cfy*/
          {1.040939993,0.03327956692,421.7814755,-1.310633207,-0.00699617049,0.8743687037}, /*cmz*/
          {1.584653355,3.148423899,0.1851929302,3.716340325} /*cfz*/
     },
     {
          2461339.5,
          {1.616070354,-0.03134106611,392.8431506,-0.8693869795,-0.009314476523,0.813432847}, /*cmx*/
          {5.951963441,1.129016628,4.314232567,1.937403482}, /*cfx*/
          {-0.6381402365,0.01156317874,153.519601,0.3565665505,-0.00398160586,0.3242987517}, /*cmy*/
          {2.814706463,1.926595142,1.869226715,5.090846217}, /*cfy*/
          {2.043973508,0.0180496045,421.7750788,-0.9036803244,-0.009795923828,0.8740335949}, /*cmz*/
          {1.240149082,2.802481632,5.976384742,3.511030139} /*cfz*/
     },
     {
          2461369.5,
          {0.6581901197,-0.03134314724,390.9337993,-0.3074650981,-0.01092845396,0.8103245332}, /*cmx*/
          {5.640978754,0.8163260396,3.986444961,1.774165932}, /*cfx*/
          {-0.2823082743,0.01248114796,158.2581753,0.1190426715,-0.004703098485,0.3294392517}, /*cmy*/
          {2.51459677,1.823832946,1.496500321,4.93480682}, /*cfy*/
          {2.581357118,0.002618325,421.7445419,-0.3099225204,-0.01153620229,0.8723896289}, /*cmz*/
          {0.9307304797,2.503663291,5.645174963,3.347259842} /*cfz*/
     },
     {
          2461399.5,
          {-0.2881587528,-0.02644446417,390.6972154,0.3693238284,-0.008519692102,0.8076523315}, /*cmx*/
          {5.37627133,0.5708754796,3.796462439,1.654457488}, /*cfx*/
          {0.09649043363,0.01042093718,158.7940256,-0.1830976017,-0.003670556398,0.3246423433}, /*cmy*/
          {2.256551172,0.9884721728,1.454671777,4.816563829}, /*cfy*/
          {2.652188844,-0.008667911262,421.7250716,0.4080801554,-0.008785524675,0.8665786972}, /*cmz*/
          {0.6669478797,2.21957239,5.463227885,3.227083171} /*cfz*/
     },
     {
          2461429.5,
          {-1.079187161,-0.02127671078,392.195231,0.8963188106,0.0009745631032,0.808363101}, /*cmx*/
          {5.157144877,0.3507758808,-4.29148478,1.568120889}, /*cfx*/
          {0.4084727387,0.007578053453,155.0881913,-0.3975291579,-0.001377005802,0.3126432586}, /*cmy*/
          {2.038848747,0.9939014264,40.43463807,4.726385381}, /*cfy*/
          {2.39489326,-0.01628316803,421.7440974,0.9534348217,-0.001112619032,0.8632228608}, /*cmz*/
          {0.4478917787,2.018285333,7.027513914,3.138869904} /*cfz*/
     },
     {
          2461459.5,
          {-1.716095872,-0.01633880039,394.742034,0.8725854968,-0.008889134095,0.8098695204}, /*cmx*/
          {4.958256502,0.1469642268,-6.163597101,1.476667059}, /*cfx*/
          {0.6328278839,0.005238232189,148.5395947,-0.3797310837,0.003866152749,0.2983480771}, /*cmy*/
          {1.836334478,0.9561202933,-5.539058306,4.630856402}, /*cfy*/
          {1.913129563,-0.02372635106,421.7698548,0.912738727,-0.009431055077,0.8604774886}, /*cmz*/
          {0.2482977818,1.827608743,1.793206815,3.046107545} /*cfz*/
     },
     {
          2461489.5,
          {-2.218544486,-0.008208396897,396.7463665,0.3091489713,-0.01156544535,0.8106948256}, /*cmx*/
          {4.737554211,6.162251561,6.205399776,1.34649566}, /*cfx*/
          {0.7916706378,0.002925489544,143.0416916,-0.1442247513,0.004850452521,0.2904216001}, /*cmy*/
          {1.609905649,0.9865047224,0.7144454793,4.499772629}, /*cfy*/
          {1.20147779,-0.0318520023,421.7419891,0.3143407866,-0.01204190794,0.8614481049}, /*cmz*/
          {6.309960004,1.590775657,1.592391705,2.916742032} /*cfz*/
     },
     {
          2461519.5,
          {-2.477476646,0.005154252088,397.0151903,-0.3974522279,-0.00941176449,0.8065358593}, /*cmx*/
          {4.468616861,6.001399189,5.849953808,1.164828817}, /*cfx*/
          {0.8845195329,-0.0007510619305,142.2365966,0.1610484578,0.00393420726,0.2926686135}, /*cmy*/
          {1.337668326,0.2504949256,0.3406687243,4.319803582}, /*cfy*/
          {0.2337178128,-0.03664671865,421.7265079,-0.4229333205,-0.009781767618,0.8589760986}, /*cmz*/
          {6.040635948,1.352331094,1.23664876,2.736159362} /*cfz*/
     },
     {
          2461549.5,
          {-2.32828457,0.02113688633,395.4495225,-0.9599013281,-0.006231504198,0.8013059091}, /*cmx*/
          {4.151582304,5.650277085,5.317126565,0.942078497}, /*cfx*/
          {0.8674650913,-0.006315137979,146.5321267,0.3985191891,0.00273926927,0.304723589}, /*cmy*/
          {1.022156335,6.324189451,-0.3754823269,4.101381246}, /*cfy*/
          {-0.8847790573,-0.03357564028,421.7184564,-1.010445387,-0.006631490778,0.8581733531}, /*cmz*/
          {5.723840423,1.023610053,0.6937141051,2.516021847} /*cfz*/
     },
     {
          2461579.5,
          {-1.682110575,0.03426147217,392.6027347,-1.316357308,-0.00389978543,0.7926166417}, /*cmx*/
          {3.799300297,5.290966821,4.566501967,0.6945684308}, /*cfx*/
          {0.6767701807,-0.01244668358,154.0503322,0.5541282124,0.00220076801,0.3206479807}, /*cmy*/
          {0.6758332289,5.933073636,4.929150549,3.860877344}, /*cfy*/
          {-1.90599548,-0.02080119706,421.7262967,-1.391808511,-0.004300588865,0.8554231602}, /*cmz*/
          {5.372539069,0.6659906954,-0.07441992221,2.269282695} /*cfz*/
     },
     {
          2461609.5,
          {-0.633339402,0.039632715,389.1904128,-1.497284567,-0.002801347421,0.7868903437}, /*cmx*/
          {3.425763815,4.920407137,3.545248341,0.4354557695}, /*cfx*/
          {0.2959180414,-0.01656426722,162.5354809,0.6363594558,0.002180373566,0.3380879466}, /*cmy*/
          {0.3113522782,5.485394898,3.954563306,3.611144272}, /*cfy*/
          {-2.537852801,-0.001012785856,421.722633,-1.591460467,-0.003290575652,0.8557819377}, /*cmz*/
          {5.000610406,0.2904662785,5.213006727,2.011547751} /*cfz*/
     },
     {
          2461639.5,
          {0.5762647489,0.03478921396,385.9175848,-1.53803556,-0.002880353131,0.7805845457}, /*cmx*/
          {3.042717823,4.545835609,2.435367249,6.458536378}, /*cfx*/
          {-0.211359903,-0.01628119088,170.2635831,0.6560192168,0.002238766879,0.3521119636}, /*cmy*/
          {-0.06068395259,5.014144696,3.06138078,3.36218037}, /*cfy*/
          {-2.563144567,0.01996730133,421.7095774,-1.643796161,-0.003399795278,0.8566556702}, /*cmz*/
          {4.619733376,-0.09337018515,4.162170607,1.753052181} /*cfz*/
     },
     {
          2461669.5,
          {1.632330427,0.02128835546,383.2909561,-1.457284062,-0.003963391704,0.7793363205}, /*cmx*/
          {2.660232771,4.177619948,1.536820221,6.205727278}, /*cfx*/
          {-0.707594833,-0.01123630297,176.1918019,0.6189599202,0.002397271322,0.3633684364}, /*cmy*/
          {5.852179173,4.542011378,2.160728554,3.121374085}, /*cfy*/
          {-1.952280421,0.03549457182,421.6828325,-1.565037885,-0.00447071845,0.8603896265}, /*cmz*/
          {4.239803032,5.807263063,3.240074064,1.502509405} /*cfz*/
     },
     {
          2461699.5,
          {2.268661852,0.003542986108,381.5988289,-1.254654202,-0.005900076681,0.7783401967}, /*cmx*/
          {2.288114031,3.821528451,0.8694750542,5.970184553}, /*cfx*/
          {-1.045172785,-0.00326321967,179.9497707,0.523628752,0.002896781628,0.3694554865}, /*cmy*/
          {5.492702515,4.08442133,1.280946315,2.897941672}, /*cfy*/
          {-0.8667136226,0.04093010306,421.650413,-1.346809653,-0.006416103597,0.8624307089}, /*cmz*/
          {3.870312418,5.434167673,2.518993814,1.271461321} /*cfz*/
     },
     {
          2461729.5,
          {2.364591321,-0.01251980853,380.7982811,-0.9085095455,-0.008387645006,0.7811148882}, /*cmx*/
          {1.937084977,3.48692719,0.3891663011,5.762625028}, /*cfx*/
          {-1.138747902,0.004466788203,181.7499298,0.3626174879,0.003801319625,0.3733600078}, /*cmy*/
          {5.154000463,3.66442582,0.5910089267,2.701831735}, /*cfy*/
          {0.380300878,0.03613633112,421.590915,-0.9709886792,-0.009118571999,0.8661351012}, /*cmz*/
          {3.52180105,5.083873015,1.996011826,1.067012744} /*cfz*/
     },
     {
          2461759.5,
          {1.972299534,-0.02237123192,380.5780472,-0.3960550172,-0.01021986545,0.7834715224}, /*cmx*/
          {1.619268547,3.189497976,0.04981286021,5.594745479}, /*cfx*/
          {-0.9972252897,0.009518117301,182.2906927,0.130640849,0.004454362777,0.3751911158}, /*cmy*/
          {4.847018334,3.331790714,0.1602230002,2.543378025}, /*cfy*/
          {1.473280269,0.02482055648,421.526404,-0.4118216275,-0.01109148458,0.8666996428}, /*cmz*/
          {3.206092291,4.768931158,1.631831718,0.9021821042} /*cfz*/
     },
     {
          2461789.5,
          {1.291090107,-0.02537795086,380.5512852,0.244926075,-0.008704813457,0.7859108097}, /*cmx*/
          {1.345919802,2.881817082,6.119328144,5.470772524}, /*cfx*/
          {-0.7072465361,0.0115413675,182.3926564,-0.1498079359,0.003569822918,0.3766241305}, /*cmy*/
          {4.581212041,2.955912944,6.296761147,2.424590987}, /*cfy*/
          {2.21311118,0.01266858415,421.4597194,0.2847814687,-0.009357465446,0.8680957636}, /*cmz*/
          {2.934182768,4.484478393,1.422801719,0.7784361959} /*cfz*/
     },
     {
          2461819.5,
          {0.5257225699,-0.02494806431,380.6194722,0.7979199523,-0.001729801805,0.786807123}, /*cmx*/
          {1.119012759,2.678010855,6.359877735,5.382078318}, /*cfx*/
          {-0.3583806318,0.01194795363,182.3232684,-0.3758018842,-0.0009229113863,0.3761206292}, /*cmy*/
          {4.356531786,2.809711229,10.62919721,2.334041486}, /*cfy*/
          {2.580380486,0.00267753698,421.4624074,0.8754740543,-0.001820190117,0.8665166671}, /*cmz*/
          {2.707725532,4.276285957,1.743032662,0.6879159087} /*cfz*/
     },
     {
          2461849.5,
          {-0.2223672131,-0.02485573646,380.9661146,0.8874153817,-0.007147662111,0.788885971}, /*cmx*/
          {0.9186339722,2.473576684,8.703542907,5.290557903}, /*cfx*/
          {0.000859404491,0.01221814438,181.6005708,-0.3854620504,-0.003534041559,0.3743932564}, /*cmy*/
          {4.152505081,2.697090766,30.81725555,2.236119542}, /*cfy*/
          {2.657354696,-0.00658147811,421.5062166,0.9581832615,-0.007862332981,0.8687536652}, /*cmz*/
          {2.506515728,4.08352931,4.024281483,0.5943377112} /*cfz*/
     },
     {
          2461879.5,
          {-0.9749749036,-0.0238127948,381.5020408,0.4392729938,-0.01087598301,0.7898760147}, /*cmx*/
          {0.7051686329,2.241789567,2.25000254,5.164714244}, /*cfx*/
          {0.3705605146,0.01195140529,180.3642122,-0.1671091631,-0.004872765577,0.3725826408}, /*cmy*/
          {3.932107989,2.593656836,5.642281874,2.104450284}, /*cfy*/
          {2.462700296,-0.01778056752,421.5352075,0.4607506098,-0.011756208,0.8702741678}, /*cmz*/
          {2.291556152,3.864539526,3.86621927,0.4660793908} /*cfz*/
     },
     {
          2461909.5,
          {-1.701637083,-0.01780700279,381.7019268,-0.2224281937,-0.009579093381,0.7888519684}, /*cmx*/
          {0.448009,2.036572202,1.934174019,4.98644758}, /*cfx*/
          {0.7342511754,0.009575384924,179.810301,0.1298218648,-0.004112806226,0.372394572}, /*cmy*/
          {3.669078058,2.169429997,5.311904012,1.923310963}, /*cfy*/
          {1.931394331,-0.03002011473,421.5443942,-0.2570572066,-0.01031835739,0.8708431817}, /*cmz*/
          {2.033225164,3.633526279,3.547782438,6.5715613} /*cfz*/
     },
     {
          2461939.5,
          {-2.246227754,-0.004967658318,381.377867,-0.7943061059,-0.006751373766,0.7844056679}, /*cmx*/
          {0.1420547336,1.699836942,1.485265176,4.768964401}, /*cfx*/
          {1.027000489,0.003935500623,180.483489,0.3763629197,-0.00291141422,0.3728544746}, /*cmy*/
          {3.361141908,1.909608786,4.681773874,1.706148879}, /*cfy*/
          {1.016565403,-0.03874788078,421.5481798,-0.8750031954,-0.007318851451,0.8678317108}, /*cmz*/
          {1.727009628,3.308641098,3.066185168,6.353972334} /*cfz*/
     },
     {
          2461969.5,
          {-2.399190678,0.01206640365,380.838971,-1.187729388,-0.004247531826,0.7803267886}, /*cmx*/
          {6.081160094,1.359654276,0.8539338902,4.522143144}, /*cfx*/
          {1.148199533,-0.00415630586,181.6700507,0.5418158324,-0.002211557547,0.3732447567}, /*cmy*/
          {3.019490493,1.524031456,3.747489718,1.463210112}, /*cfy*/
          {-0.1695583366,-0.03941919821,421.5395686,-1.302152085,-0.004736886656,0.8636936081}, /*cmz*/
          {1.383570239,2.959486091,2.369056322,6.108552883} /*cfz*/
     },
     {
          2461999.5,
          {-2.029000762,0.02818073417,380.6230098,-1.411105323,-0.002703555729,0.7767193706}, /*cmx*/
          {5.712688317,1.003304484,-0.03646965903,4.263991427}, /*cfx*/
          {1.020307872,-0.01221718219,182.2373573,0.6298845029,-0.002144382084,0.3710358563}, /*cmy*/
          {2.657220253,1.084098346,2.755486693,1.212421139}, /*cfy*/
          {-1.377774567,-0.02973807015,421.5190212,-1.543119608,-0.003376525827,0.8594656088}, /*cmz*/
          {1.016313103,2.588102135,1.440727926,5.851614482} /*cfz*/
     },
     {
          2462029.5,
          {-1.168915732,0.03794654273,381.1482099,-1.496480706,-0.002352411235,0.7758541126}, /*cmx*/
          {5.332186628,0.6399310863,5.032399234,4.002963713}, /*cfx*/
          {0.6462871899,-0.01717468565,181.2822639,0.6538849307,-0.002309222243,0.3656910997}, /*cmy*/
          {2.285845981,0.613710381,1.843927171,0.961521576}, /*cfy*/
          {-2.283100535,-0.01174044756,421.4775312,-1.633465407,-0.003189809549,0.8556488522}, /*cmz*/
          {0.6373081875,2.206117812,0.328437122,5.590421823} /*cfz*/
     },
     {
          2462059.5,
          {-0.008674883569,0.03789944397,382.5814746,-1.455033219,-0.003355208361,0.7767147462}, /*cmx*/
          {4.950279367,0.2768092388,3.992722385,3.75191451}, /*cfx*/
          {0.1200210235,-0.01716440256,178.4139529,0.6197525034,-0.002495135375,0.3565561627}, /*cmy*/
          {1.9152683,0.1269721193,0.9865388628,0.722775306}, /*cfy*/
          {-2.631761503,0.009549141759,421.4313515,-1.5817872,-0.00403888886,0.8530930513}, /*cmz*/
          {0.2568354541,1.821980252,-0.6619961815,5.340469967} /*cfz*/
     },
     {
          2462089.5,
          {1.146833665,0.02839407587,384.7568991,-1.288583558,-0.005392455638,0.7797073266}, /*cmx*/
          {4.577187839,-0.07851259189,3.272743685,3.517895029}, /*cfx*/
          {-0.4029211926,-0.01278327931,173.8629516,0.532477831,-0.002866285776,0.3455136639}, /*cmy*/
          {1.555052421,5.920848263,0.1265447514,0.5024004299}, /*cfy*/
          {-2.331825302,0.02721759099,421.3701106,-1.391602927,-0.00597884887,0.8525688159}, /*cmz*/
          {6.168104696,1.446360631,4.845008201,5.107292012} /*cfz*/
     },
     {
          2462119.5,
          {2.009535199,0.01309404348,387.1841188,-0.9707824943,-0.007882244475,0.7845044331}, /*cmx*/
          {4.223486717,5.866794711,2.767047767,3.312332809}, /*cfx*/
          {-0.7897098877,-0.006421482808,168.5776423,0.3867456913,-0.003509339253,0.3355772489}, /*cmy*/
          {1.214890612,5.438801529,5.649422188,6.593585354}, /*cfy*/
          {-1.495812503,0.03619305854,421.3006276,-1.040009417,-0.008562486631,0.8534082926}, /*cmz*/
          {5.815318045,1.089230225,4.289376952,4.903980105} /*cfz*/
     },
     {
          2462149.5,
          {2.400087654,-0.001996302695,389.1247535,-0.4876422317,-0.01002670067,0.788969372}, /*cmx*/
          {3.900927012,5.565552791,2.406177597,3.142043143}, /*cfx*/
          {-0.980344612,-0.0008168571348,164.1906624,0.1810750439,-0.004182524089,0.330082575}, /*cmy*/
          {0.9048646182,4.936982567,5.120281528,6.434463771}, /*cfy*/
          {-0.396663055,0.03546870087,421.2165259,-0.5132541357,-0.0108033335,0.8554095949}, /*cmz*/
          {5.493521991,0.7634233942,3.905814436,4.736505933} /*cfz*/
     },
     {
          2462179.5,
          {2.328907495,-0.01270985552,389.8548824,0.140665495,-0.009152252881,0.7928964814}, /*cmx*/
          {3.620374309,5.195535474,2.169412024,3.016820651}, /*cfx*/
          {-1.001366979,0.003108406111,162.5672953,-0.08786514545,-0.003649490315,0.3324042395}, /*cmy*/
          {0.6329558291,5.197737072,4.846588057,6.314260323}, /*cfy*/
          {0.676617791,0.02837844243,421.1364279,0.1634404282,-0.009838666658,0.8582688495}, /*cmz*/
          {5.213799173,0.5006817689,3.668228276,4.612563283} /*cfz*/
     },
     {
          2462209.5,
          {1.941204617,-0.01873106936,389.0532724,0.720185387,-0.003179622736,0.7950854946}, /*cmx*/
          {3.385653795,5.031373379,2.159773539,2.925718036}, /*cfx*/
          {-0.9077425834,0.006079622917,164.5738993,-0.3144039105,-0.001042643053,0.3414273449}, /*cmy*/
          {0.3998073543,4.69196589,4.994659538,6.220570272}, /*cfy*/
          {1.530600314,0.02021680799,421.1130667,0.7852159643,-0.003372612196,0.8622276297}, /*cmz*/
          {4.979885927,0.2669309381,3.676812524,4.522280879} /*cfz*/
     },
     {
          2462239.5,
          {1.379896516,-0.02344914085,387.2596388,0.9067179472,0.005628659031,0.7959306223}, /*cmx*/
          {3.181498334,4.836959347,1.610884834,2.840966609}, /*cfx*/
          {-0.7268364683,0.009344983013,168.7690994,-0.3726592908,0.002632817299,0.3517561578}, /*cmy*/
          {0.1896408209,4.50223777,4.465188198,6.12760136}, /*cfy*/
          {2.140739636,0.0129411355,421.1612584,0.9798752496,0.006201467675,0.8665123165}, /*cmz*/
          {4.776007364,0.07176315954,3.132954505,4.436998167} /*cfz*/
     },
     {
          2462269.5,
          {0.680301642,-0.02844787247,385.6186846,0.5475585437,0.01029575742,0.7964378464}, /*cmx*/
          {2.972208415,4.629427477,1.475445555,2.723278631}, /*cfx*/
          {-0.4474741711,0.01269325044,172.3039585,-0.2028661353,0.004466105259,0.3580082901}, /*cmy*/
          {6.253674343,4.268560257,4.386517981,6.000238073}, /*cfy*/
          {2.534096606,0.004312557467,421.2184703,0.5804916626,0.01118196958,0.869840535}, /*cmz*/
          {4.566142727,6.146472161,3.009828868,4.318615533} /*cfz*/
     },
     {
          2462299.5,
          {-0.1804014562,-0.03104496513,384.9464663,-0.084952092,0.009986509546,0.7982099802}, /*cmx*/
          {2.724557292,4.28908938,1.191384417,2.55726803}, /*cfx*/
          {-0.06207620596,0.01443724535,173.58506,0.07804567208,0.00416952262,0.3589250573}, /*cmy*/
          {5.99749549,4.461757757,4.068215837,5.827320314}, /*cfy*/
          {2.669195451,-0.008692888054,421.2571623,-0.1110001503,0.01074506223,0.8724615775}, /*cmz*/
          {4.317434284,5.918384771,2.722003823,4.151275342} /*cfz*/
     },
     {
          2462329.5,
          {-1.126421032,-0.02737956463,385.4065725,-0.68569748,0.007406462098,0.8014724748}, /*cmx*/
          {2.428692547,4.058008373,0.7775895676,2.345010308}, /*cfx*/
          {0.3785041481,0.01277254274,172.4507867,0.3252763245,0.003054529558,0.3544979247}, /*cmy*/
          {5.697662654,3.894339727,3.452703831,5.613171935}, /*cfy*/
          {2.410725657,-0.02432666922,421.2789197,-0.7628906723,0.007878527158,0.873472769}, /*cmz*/
          {4.02063788,5.60131841,2.274633687,3.937543951} /*cfz*/
     },
     {
          2462359.5,
          {-1.965630544,-0.01566496971,386.9863839,-1.124612536,0.004943129482,0.8054372836}, /*cmx*/
          {2.092425132,3.731224136,0.2002940012,2.101232245}, /*cfx*/
          {0.7694054612,0.007173518434,168.8710811,0.4977226771,0.002412048025,0.3441230837}, /*cmy*/
          {5.362786604,3.461313928,2.530672082,5.3731057}, /*cfy*/
          {1.673444101,-0.03761846885,421.2871398,-1.232763594,0.005267345972,0.8733005952}, /*cmz*/
          {3.683714221,5.259197058,1.63704802,3.69253792} /*cfz*/
     },
     {
          2462389.5,
          {-2.443409299,0.001958944447,389.6865076,-1.401607982,0.003123952609,0.8098517816}, /*cmx*/
          {1.729125937,3.377909776,5.644474573,1.839302069}, /*cfx*/
          {0.986114943,-0.0007131150643,162.6226285,0.5970457683,0.002467813282,0.3273585021}, /*cmy*/
          {5.005930395,2.988359466,1.53654894,5.120003225}, /*cfy*/
          {0.5305448964,-0.04280519574,421.2747534,-1.520283744,0.003566835001,0.8708192084}, /*cmz*/
          {3.319833852,4.891802093,0.7373361064,3.429583106} /*cfz*/
     },
     {
          2462419.5,
          {-2.378013125,0.02102132857,393.3865054,-1.528958231,0.00254879919,0.8146144071}, /*cmx*/
          {1.351323651,3.010554385,4.498418179,1.574609564}, /*cfx*/
          {0.9590825266,-0.008053905475,153.5726099,0.6341742887,0.002699705828,0.3046159835}, /*cmy*/
          {4.639294912,2.47776675,0.7015604148,4.868810936}, /*cfy*/
          {-0.775222807,-0.03699150901,421.2535841,-1.64232763,0.003112462984,0.866499972}, /*cmz*/
          {2.941288127,4.510070362,-0.3534835734,3.163680469} /*cfz*/
     },
     {
          2462449.5,
          {-1.731308903,0.03526945864,397.7575675,-1.525268912,0.003422948164,0.8194427046}, /*cmx*/
          {0.97023656,2.636752305,3.357100948,1.317227264}, /*cfx*/
          {0.7087795697,-0.01201275501,142.0078983,0.6234361088,0.002770136436,0.277611125}, /*cmy*/
          {4.274104962,1.945419632,-0.1089606307,4.629419307}, /*cfy*/
          {-1.89968579,-0.02146689811,421.2311978,-1.622228081,0.003882493529,0.8620334138}, /*cmz*/
          {2.559123969,4.124288703,4.851357831,2.904219696} /*cfz*/
     },
     {
          2462479.5,
          {-0.6532083453,0.04021161401,402.2479778,-1.379496317,0.005272756777,0.8237161433}, /*cmx*/
          {0.5960708079,2.265675023,2.563505639,1.078354304}, /*cfx*/
          {0.3414432138,-0.01186636639,128.8841264,0.5662265314,0.002755968754,0.2494738509}, /*cmy*/
          {3.920729586,1.40934317,5.278100621,4.412758796}, /*cfy*/
          {-2.547384376,-0.001129065918,421.2057047,-1.454045676,0.005644647754,0.8576325949}, /*cmz*/
          {2.183589329,3.745145634,4.045361698,2.66304447} /*cfz*/
     },
     {
          2462509.5,
          {0.5649389308,0.0346934823,406.1903181,-1.081921492,0.007835779009,0.8260125958}, /*cmx*/
          {0.2394168136,1.908437552,1.982939326,0.8659163489}, /*cfx*/
          {-0.01549766257,-0.009109712642,115.9891354,0.4556178872,0.00325440705,0.224518574}, /*cmy*/
          {3.589011189,0.896011896,4.367902865,4.225673205}, /*cfy*/
          {-2.569998366,0.01695761822,421.1756191,-1.133656247,0.008281761056,0.8540543218}, /*cmz*/
          {1.825526404,3.383163919,3.459829525,2.449044933} /*cfz*/
     },
     {
          2462539.5,
          {1.610967186,0.02214720096,408.9641832,-0.6104008552,0.01009988447,0.8261961332}, /*cmx*/
          {6.194569308,1.585661591,1.572103172,0.6913678209}, /*cfx*/
          {-0.2868494398,-0.006202860329,105.8720797,0.2755791783,0.004134310651,0.2081868662}, /*cmy*/
          {3.286097535,0.4081126298,3.71227289,4.074055521}, /*cfy*/
          {-2.040879163,0.0279869605,421.1288475,-0.6361147042,0.01057826847,0.8510159419}, /*cmz*/
          {1.496385013,3.051226152,3.052359973,2.273810013} /*cfz*/
     },
     {
          2462569.5,
          {2.271883235,0.008421920967,410.1353605,0.01555332639,0.01012186949,0.8256223194}, /*cmx*/
          {5.906093049,0.3967811237,1.308666444,0.5580421498}, /*cfx*/
          {-0.4710947991,-0.004398892593,101.2837559,0.04084140552,0.004190702755,0.2052384696}, /*cmy*/
          {3.013804482,-0.8547930668,3.371296963,3.950985553}, /*cfy*/
          {-1.186420635,0.03072971887,421.0742188,0.01266703066,0.01057462391,0.8497694479}, /*cmz*/
          {1.207547056,2.862740816,2.78705864,2.141296677} /*cfz*/
     },
     {
          2462599.5,
          {2.520111501,-0.002530931712,409.5183989,0.6383438974,0.005054067951,0.824248118}, /*cmx*/
          {5.66248016,32.44433372,1.244871496,0.46386079}, /*cfx*/
          {-0.6046865637,-0.002923793908,103.8186999,-0.2434797744,0.002121637225,0.2163558003}, /*cmy*/
          {2.768008974,0.10837849,3.296995756,3.847381847}, /*cfy*/
          {-0.258975624,0.02874411746,421.0499511,-0.6693186108,0.005227614243,0.8509315226}, /*cmz*/
          {0.9645122108,-0.6082886736,2.691263913,2.047877011} /*cfz*/
     },
     {
          2462629.5,
          {2.440356157,-0.01089043695,407.3943036,0.9326747739,-0.003894791924,0.8229297053}, /*cmx*/
          {5.453319808,0.8461396966,0.6343376136,6.666273286}, /*cfx*/
          {-0.6948583993,-0.0002875870213,111.9346124,-0.3705560828,-0.001447135034,0.2353873385}, /*cmy*/
          {2.540309868,6.157137427,2.932911159,3.744288102}, /*cfy*/
          {0.6004321673,0.02605593596,421.0814836,-0.9781927296,-0.004112384539,0.8540176021}, /*cmz*/
          {0.7565246135,5.476096749,2.17792366,1.969054932} /*cfz*/
     },
     {
          2462659.5,
          {2.109871158,-0.01975450062,404.8548694,0.673166021,-0.01000763336,0.8222584366}, /*cmx*/
          {5.246836303,0.6570589528,0.6294351227,6.565561752}, /*cfx*/
          {-0.7035950777,0.003965842049,120.6480668,-0.2721873947,-0.003918537187,0.2509002501}, /*cmy*/
          {2.311691646,5.912598589,2.962300554,3.623015741}, /*cfy*/
          {1.388421036,0.02291647524,421.1182095,-0.7007918449,-0.01052692923,0.8585030663}, /*cmz*/
          {0.5509555574,5.272207688,2.128330167,1.870405515} /*cfz*/
     },
     {
          2462689.5,
          {1.512123745,-0.02941286683,403.4037055,0.04859082621,-0.01064512252,0.8261954884}, /*cmx*/
          {5.008075188,0.6408730113,0.3836174787,6.415688643}, /*cfx*/
          {-0.5812595596,0.008402454331,125.1587623,-0.06034358656,-0.004230704874,0.2557955702}, /*cmy*/
          {2.057342983,4.604868458,2.677534234,3.461524752}, /*cfy*/
          {2.088593147,0.01568828879,421.1423757,-0.03840121558,-0.01114788163,0.8632755476}, /*cmz*/
          {0.3121815577,4.91029982,1.867879404,1.721087459} /*cfz*/
     },
     {
          2462719.5,
          {0.6184718496,-0.03660144779,403.7981441,0.6018381545,-0.00845120604,0.8341140194}, /*cmx*/
          {4.721789887,3.240100677,-0.01963389467,6.216433118}, /*cfx*/
          {-0.3225383637,0.01080122902,123.6712544,0.2424532662,-0.003508350766,0.2482950795}, /*cmy*/
          {1.765628339,-6.76165089,2.100559049,3.261466459}, /*cfy*/
          {2.573184482,0.00201267354,421.1655918,-0.6451875227,-0.00875663996,0.8682544225}, /*cmz*/
          {0.02505639373,1.613395337,1.452120093,1.521292652} /*cfz*/
     },
     {
          2462749.5,
          {-0.4943338356,-0.03640225945,405.9360853,1.110411079,-0.005795591709,0.8439903842}, /*cmx*/
          {4.392801283,2.916144654,5.670160133,5.978140301}, /*cfx*/
          {0.008322326756,0.009471385975,116.3551571,0.4377303266,-0.003016941874,0.2290364323}, /*cmy*/
          {1.442167225,5.275972225,1.247403216,3.033796802}, /*cfy*/
          {2.635458304,-0.01600734487,421.1969371,-1.172447652,-0.005929184851,0.8720509124}, /*cmz*/
          {5.97781256,1.274255509,0.8515233884,1.279756548} /*cfz*/
     },
     {
          2462779.5,
          {-1.607680965,-0.02643217215,409.2846732,1.442058482,-0.00403290845,0.8543659937}, /*cmx*/
          {4.033508569,2.553976656,4.820027292,5.718733071}, /*cfx*/
          {0.2975334924,0.004847991339,103.8984496,0.5712442403,-0.003035595608,0.199362215}, /*cmy*/
          {1.100801782,4.75673316,0.3663253978,2.798741441}, /*cfy*/
          {2.14258614,-0.03306997413,421.2235841,-1.506242154,-0.004062276403,0.8745689009}, /*cmz*/
          {5.616598454,0.9086679856,0.01542203135,1.017784625} /*cfz*/
     },
     {
          2462809.5,
          {-2.415164698,-0.008160088082,413.1494608,1.612306475,-0.003476961898,0.8625825157}, /*cmx*/
          {3.656877966,2.167715076,3.739315584,5.449039158}, /*cfx*/
          {0.4419347517,-0.0006073311791,87.23655515,0.6524240516,-0.003057783932,0.1614804149}, /*cmy*/
          {0.7592563176,4.216695239,-0.4488668949,2.573925726}, /*cfy*/
          {1.127501027,-0.04276391218,421.2575365,-1.671156042,-0.003298470282,0.8757269151}, /*cmz*/
          {5.23769065,0.525602664,5.208900966,0.7453656761} /*cfz*/
     },
     {
          2462839.5,
          {-2.662200326,0.0131592751,416.7738544,1.629888307,-0.004074216371,0.8690060165}, /*cmx*/
          {3.274387214,1.769196676,2.704690195,5.184338172}, /*cfx*/
          {0.4181689063,-0.003968682816,67.79637908,0.6849256876,-0.002820921212,0.1196678427}, /*cmy*/
          {0.4413016805,3.673025723,4.987093838,2.391418452}, /*cfy*/
          {-0.1814710176,-0.04144824907,421.2841258,-1.678112807,-0.003849417746,0.8749385356}, /*cmz*/
          {4.852652408,0.1376814052,4.144617113,0.4778303978} /*cfz*/
     },
     {
          2462869.5,
          {-2.25154461,0.03045546199,419.5363434,1.501500157,-0.005490819179,0.8704558213}, /*cmx*/
          {2.896642694,1.368779202,1.822370912,4.93148657}, /*cfx*/
          {0.2932616495,-0.003962684007,47.80780589,0.6608042966,-0.002659391783,0.07948766107}, /*cmy*/
          {0.1881739689,3.150165125,3.993748576,2.305840208}, /*cfy*/
          {-1.43997597,-0.02929358465,421.3099322,-1.540210526,-0.005449798195,0.8715056539}, /*cmz*/
          {4.472350494,6.037775211,3.284784247,6.506783574} /*cfz*/
     },
     {
          2462899.5,
          {-1.312417406,0.0386408884,421.1215041,1.217115855,-0.007617190419,0.8687724473}, /*cmx*/
          {2.533986646,0.9829747317,1.146030655,4.707182803}, /*cfx*/
          {0.1733689662,-0.001914153129,30.62845362,0.5652070396,-0.003174608002,0.04961943065}, /*cmy*/
          {6.367944765,2.668009868,2.993329355,2.434868827}, /*cfy*/
          {-2.324573732,-0.01109713502,421.3257467,-1.246899298,-0.007757116776,0.8674640648}, /*cmz*/
          {4.107400801,5.671144014,2.660828722,6.279216521} /*cfz*/
     },
     {
          2462929.5,
          {-0.133001584,0.03657923849,421.6961132,0.7709241289,-0.01000836018,0.863582904}, /*cmx*/
          {2.197396879,0.6282774149,0.653334117,4.516425954}, /*cfx*/
          {0.1198442605,-0.0003812959862,20.75428898,0.3866194563,-0.004267417133,0.03794027071}, /*cmy*/
          {6.511341466,2.248490389,2.293863985,2.761542611}, /*cfy*/
          {-2.651073648,0.006487420017,421.3341652,-0.7892721588,-0.01020142268,0.8611769942}, /*cmz*/
          {3.769061579,5.332805137,2.208623483,6.086238901} /*cfz*/
     },
     {
          2462959.5,
          {0.9734097213,0.02784505374,421.7398592,0.162787782,-0.01072416875,0.8574358986}, /*cmx*/
          {1.897779967,0.3535693042,0.3424682734,4.370530758}, /*cfx*/
          {0.112983556,-0.0009028823018,18.89611245,0.1254732829,-0.004872957583,0.03846601104}, /*cmy*/
          {6.627272542,1.934506764,1.916425887,2.83479656}, /*cfy*/
          {-2.448380742,0.01839021189,421.321429,-0.1701588954,-0.01100703761,0.8560716899}, /*cmz*/
          {3.468558936,5.058644807,1.908623982,5.938458138} /*cfz*/
     },
     {
          2462989.5,
          {1.804677857,0.01732448044,421.718695,-0.5035458303,-0.007088684333,0.850387658}, /*cmx*/
          {1.642680729,0.04943484084,0.2235318296,4.265725075}, /*cfx*/
          {0.08648492736,-0.002797309659,18.85102339,-0.1784168971,-0.00354997943,0.04062350741}, /*cmy*/
          {0.04710101785,1.624819947,1.816360935,2.476251715}, /*cfy*/
          {-1.890414708,0.02391942348,421.3227205,0.5096868509,-0.007300000724,0.8486794733}, /*cmz*/
          {3.213548938,4.771553872,1.753138819,5.832060101} /*cfz*/
     },
     {
          2463019.5,
          {2.324689451,0.008033234735,421.6260413,-0.936756292,0.002128772031,0.8469562578}, /*cmx*/
          {1.426716061,6.147563932,5.521021951,4.1859895}, /*cfx*/
          {-0.001600201886,-0.003983258436,21.23444265,-0.3959179397,0.0003835159745,0.0510505655}, /*cmy*/
          {5.658583966,1.483607803,-12.34986707,1.945912905}, /*cfy*/
          {-1.17262441,0.02676354601,421.3375909,0.9521498433,0.001863812046,0.8467862994}, /*cmz*/
          {2.998595221,4.569865879,0.891873409,5.754082211} /*cfz*/
     },
     {
          2463049.5,
          {2.573001252,-0.001236778556,421.1529686,-0.8145692926,-0.009522081916,0.8462194222}, /*cmx*/
          {1.223087296,5.969109578,9.067902325,4.094990144}, /*cfx*/
          {-0.1264423916,-0.00297706921,29.29481089,-0.3781548888,0.003634469224,0.06689514062}, /*cmy*/
          {5.054584421,1.32833947,20.20911833,1.566124984}, /*cfy*/
          {-0.3701863722,0.02976564127,421.357113,0.8290423437,-0.009584679678,0.8479658068}, /*cmz*/
          {2.796301485,4.373305103,4.347668755,5.665420155} /*cfz*/
     },
     {
          2463079.5,
          {2.548581421,-0.01301552529,420.5748326,-0.2182595534,-0.01164962701,0.8504949999}, /*cmx*/
          {0.9944845307,5.746294756,2.58867417,3.961949026}, /*cfx*/
          {-0.2180048436,-0.00030029125,36.21708607,-0.150838094,0.004823969963,0.07452656669}, /*cmy*/
          {4.663041172,0.9785587085,1.193482213,1.329422856}, /*cfy*/
          {0.5296146285,0.03110863793,421.346542,0.2232228289,-0.01186726125,0.8536324867}, /*cmz*/
          {2.568503741,4.115875229,4.126311641,5.535805574} /*cfz*/
     },
     {
          2463109.5,
          {2.158676105,-0.02685745504,420.5495386,0.4913712633,-0.009742780352,0.8545946657}, /*cmx*/
          {0.7190988759,5.479818747,2.20617757,3.777214946}, /*cfx*/
          {-0.2235429536,0.002022516464,36.01332381,0.1508248851,0.00432418371,0.06644538344}, /*cmy*/
          {4.371328873,1.174876709,0.7346119096,1.178906071}, /*cfy*/
          {1.474486172,0.02606550072,421.3576329,-0.5017317327,-0.009885147039,0.8571636038}, /*cmz*/
          {2.293030957,3.889543985,3.752390813,5.351222506} /*cfz*/
     },
     {
          2463139.5,
          {1.341706283,-0.03845581132,421.1094018,1.075811194,-0.00692208909,0.8625804883}, /*cmx*/
          {0.3974658971,5.145229722,1.60098069,3.549906766}, /*cfx*/
          {-0.1565138917,0.001998856239,28.20164578,0.402447822,0.003521712826,0.04539488282}, /*cmy*/
          {4.180398961,0.6278610488,0.003259251237,1.210631705}, /*cfy*/
          {2.272242081,0.01248040029,421.3840264,-1.094262174,-0.006945924126,0.86228514}, /*cmz*/
          {1.970409759,3.553996049,3.1957635,5.123101976} /*cfz*/
     },
     {
          2463169.5,
          {0.167152914,-0.04191882744,421.6833047,1.467658781,-0.004941608375,0.8669940636}, /*cmx*/
          {0.04118199753,4.766929748,0.7563781008,3.294617865}, /*cfx*/
          {-0.09232596923,-0.0006629639181,17.30874099,0.5882201888,0.003070921865,0.007609729607}, /*cmy*/
          {4.364909741,0.1409515927,5.383743029,2.094424783}, /*cfy*/
          {2.654900243,-0.007330325253,421.4248074,-1.490315431,-0.00466478843,0.866405564}, /*cmz*/
          {1.612568272,3.190308224,2.407143563,4.865149919} /*cfz*/
     },
     {
          2463199.5,
          {-1.111911715,-0.03414696159,421.5023228,1.673915674,-0.004250206276,0.8709122165}, /*cmx*/
          {5.946862547,4.363028641,-0.2502942948,3.025072419}, /*cfx*/
          {-0.114256285,-0.003940188574,20.75183961,0.70132171,0.002913620985,0.05507447669}, /*cmy*/
          {5.13808072,5.918634329,4.445357655,8.722519057}, /*cfy*/
          {2.433675697,-0.02727198543,421.4745123,-1.698708083,-0.003634719661,0.8720037904}, /*cmz*/
          {1.233260732,2.807136626,1.376656194,4.592915964} /*cfz*/
     },
     {
          2463229.5,
          {-2.146765143,-0.01651030403,420.1016073,1.716338645,-0.004392194346,0.8679226118}, /*cmx*/
          {5.560364519,3.946728545,5.027598326,2.753435428}, /*cfx*/
          {-0.2396669941,-0.00489080807,39.88331052,0.7401514752,0.002826555783,0.1050553632}, /*cmy*/
          {5.206602869,5.405847347,3.518341042,2.506333877}, /*cfy*/
          {1.596300899,-0.0405093458,421.5350994,-1.740103555,-0.003841008599,0.8743609962}, /*cmz*/
          {0.8450251408,2.415478026,0.3150811401,4.321090639} /*cfz*/
     },
     {
          2463259.5,
          {-2.641181203,0.004974103171,417.4733096,1.607762497,-0.005283637128,0.863724596}, /*cmx*/
          {5.175750942,3.534722477,4.121925566,2.491745854}, /*cfx*/
          {-0.3938903585,-0.002155866378,61.33024636,0.7057834279,0.002786434618,0.1483797141}, /*cmy*/
          {4.97135346,4.902456436,2.570305906,2.336826673}, /*cfy*/
          {0.3553288145,-0.04289965005,421.5896928,-1.633087897,-0.005036919581,0.8770542355}, /*cmz*/
          {0.4591218358,2.027146829,-0.5850499675,4.059266463} /*cfz*/
     },
     {
          2463289.5,
          {-2.477002107,0.02306958911,414.1366626,1.353579326,-0.006963071855,0.8565347089}, /*cmx*/
          {4.80340538,3.140158882,3.385026595,2.251122412}, /*cfx*/
          {-0.4604945368,0.002884799125,80.62994043,0.6019643158,0.003096065638,0.1841165668}, /*cmy*/
          {4.666774176,4.429950888,1.628586829,2.14125504}, /*cfy*/
          {-0.9523382335,-0.03432565038,421.6473594,-1.378397742,-0.006965307911,0.8752600304}, /*cmz*/
          {0.08606050346,1.65070325,4.997495947,3.819626969} /*cfz*/
     },
     {
          2463319.5,
          {-1.768245151,0.03279830466,410.918631,0.950472723,-0.009183853718,0.8501556821}, /*cmx*/
          {4.454011897,2.774733798,2.841925793,2.041421973}, /*cfx*/
          {-0.370411569,0.007203798862,95.49876695,0.4310519621,0.003924522582,0.2087689702}, /*cmy*/
          {4.353799195,4.022080356,0.8780780731,1.955808627}, /*cfy*/
          {-1.987750959,-0.0191963214,421.6723447,-0.969181063,-0.009375264831,0.8740605727}, /*cmz*/
          {6.01969471,1.300728005,4.488882669,3.609436227} /*cfz*/
     },
     {
          2463349.5,
          {-0.7680597789,0.03343368396,408.701443,0.3899561675,-0.01065254087,0.843138151}, /*cmx*/
          {4.138739891,2.443571049,2.470307111,1.875328321}, /*cfx*/
          {-0.1472800572,0.008502840313,104.4224447,0.1945273297,0.004672428525,0.2188678525}, /*cmy*/
          {4.058623249,3.793031044,0.4410379023,1.80151712}, /*cfy*/
          {-2.55173821,-0.003411124504,421.6803348,-0.3970834235,-0.01102572703,0.8682069548}, /*cmz*/
          {5.704685542,0.9922221216,4.133779078,3.441410744} /*cfz*/
     },
     {
          2463379.5,
          {0.2417979204,0.02855622086,408.1754169,-0.2790691934,-0.008895464236,0.8392132935}, /*cmx*/
          {3.86736846,2.203717851,2.259094659,1.754371862}, /*cfx*/
          {0.1129578672,0.006745530208,106.3294689,-0.1105305519,0.004143594889,0.213626254}, /*cmy*/
          {3.795934678,2.858877422,0.3210840288,1.680688617}, /*cfy*/
          {-2.640040806,0.008498119244,421.6689735,0.2904532752,-0.009198618685,0.8630638933}, /*cmz*/
          {5.433687797,0.6927404975,3.929809453,3.318699789} /*cfz*/
     },
     {
          2463409.5,
          {1.098290845,0.02256552368,409.5516839,-0.8465524148,-0.001723452229,0.8369338042}, /*cmx*/
          {3.640552378,1.978055046,2.57545819,1.669816798}, /*cfx*/
          {0.316279713,0.003716250008,100.9902532,-0.3577627556,0.001689558216,0.1951052213}, /*cmy*/
          {3.567744572,3.02142557,0.8851148584,1.584532033}, /*cfy*/
          {-2.376779486,0.01633180058,421.680275,0.8685825191,-0.001876436551,0.8568889173}, /*cmz*/
          {5.207252136,0.4899223843,4.279308611,3.231429862} /*cfz*/
     },
     {
          2463439.5,
          {1.774346171,0.01701188401,411.9791532,-0.9349333286,-0.007852961824,0.8384472205}, /*cmx*/
          {3.43848527,1.78477653,4.876563004,1.581592333}, /*cfx*/
          {0.4248869209,0.001494769563,90.70111617,-0.4190405111,0.003068917394,0.1735497362}, /*cmy*/
          {3.35540777,2.975883212,8.998055735,1.482306005}, /*cfy*/
          {-1.890258718,0.0233440581,421.6999071,0.9534137603,-0.00796805128,0.8546227043}, /*cmz*/
          {5.005502711,0.2987817675,6.517467501,3.144894233} /*cfz*/
     },
     {
          2463469.5,
          {2.289470877,0.008894673335,413.9195749,-0.4439527077,-0.01220727719,0.8387429586}, /*cmx*/
          {3.222641328,1.5588389,4.723339079,1.460302634}, /*cfx*/
          {0.466871906,0.0005958680715,81.36505756,-0.2329998178,0.005018222791,0.1606765844}, /*cmy*/
          {3.126308314,2.890658757,2.789753909,1.358425383}, /*cfy*/
          {-1.186150711,0.03094582782,421.6856298,0.4513738967,-0.01240149582,0.853817069}, /*cmz*/
          {4.789887577,0.07948800413,6.362255226,3.025200822} /*cfz*/
     },
     {
          2463499.5,
          {2.565634276,-0.004453854748,414.3795697,0.2991481763,-0.0110503496,0.8384030025}, /*cmx*/
          {2.962151871,1.379517437,4.385308128,1.286735727}, /*cfx*/
          {0.4859527802,-0.0002802842315,78.81948617,0.07811504938,0.004689063433,0.1643443191}, /*cmy*/
          {2.861926228,2.328339619,2.462809854,1.195791735}, /*cfy*/
          {-0.2433739946,0.03613442681,421.6641619,-0.3051015506,-0.01121241154,0.854016507}, /*cmz*/
          {4.529485115,6.130315314,6.035113674,2.853689402} /*cfz*/
     },
     {
          2463529.5,
          {2.433674635,-0.0213636954,413.2032231,0.959072587,-0.007939948128,0.8346053239}, /*cmx*/
          {2.650739887,1.020829781,3.856723233,1.069611324}, /*cfx*/
          {0.4817315392,-0.002916569207,84.71594894,0.3624983281,0.003522412215,0.1836449597}, /*cmy*/
          {2.562111589,2.17404077,1.785513561,0.9967356827}, /*cfy*/
          {0.8640977464,0.03373834136,421.6679847,-0.9771458492,-0.008105238357,0.8545032399}, /*cmz*/
          {4.217975388,5.80136804,5.530237756,2.637339303} /*cfz*/
     },
     {
          2463559.5,
          {1.784629008,-0.03596264083,410.445004,1.416504594,-0.005222642002,0.8295584971}, /*cmx*/
          {2.298578775,0.6489627239,3.085558409,0.8188895609}, /*cfx*/
          {0.3978397279,-0.007568183012,97.18272076,0.5664668497,0.002840539363,0.2136946046}, /*cmy*/
          {2.230637652,1.761082453,0.8098694994,0.7663781661}, /*cfy*/
          {1.894897515,0.02141932209,421.6885607,-1.448270337,-0.005342125954,0.8557641581}, /*cmz*/
          {3.865774618,5.443462509,4.789057676,2.385685501} /*cfz*/
     },
     {
          2463589.5,
          {0.6829604794,-0.0419169495,406.3385184,1.663176238,-0.003861253598,0.8220049728}, /*cmx*/
          {1.919997831,0.2552282657,2.0914463,0.5520943348}, /*cfx*/
          {0.1675522371,-0.01215536907,113.1218535,0.6809566055,0.002813969628,0.2476423029}, /*cmy*/
          {1.874114425,1.282961813,-0.180876376,0.5193501974}, /*cfy*/
          {2.545337654,0.001153081269,421.7285891,-1.709471317,-0.003937408995,0.8580895872}, /*cmz*/
          {3.487486128,5.060342656,3.822020165,2.119327335} /*cfz*/
     },
     {
          2463619.5,
          {-0.5998075216,-0.03650679629,401.3892078,1.734672837,-0.003760932134,0.8141507878}, /*cmx*/
          {1.52853544,6.138093136,1.012844682,0.2793957563}, /*cfx*/
          {-0.2064840798,-0.01362088777,129.5828264,0.7180530549,0.002808305019,0.280360632}, /*cmy*/
          {1.502921022,0.774889479,5.206508966,6.548048864}, /*cfy*/
          {2.576406112,-0.02060542828,421.7622193,-1.794785115,-0.003812719836,0.8620378883}, /*cmz*/
          {3.096887845,4.666187009,2.753497528,1.847202264} /*cfz*/
     },
     {
          2463649.5,
          {-1.715028993,-0.02145252359,396.3137179,1.654123763,-0.004451816169,0.8075451981}, /*cmx*/
          {1.13577373,5.74340386,0.105114632,6.296638688}, /*cfx*/
          {-0.6265599907,-0.01024934851,144.36297,0.6885884499,0.002727414045,0.3085639832}, /*cmy*/
          {1.128238035,0.2667234716,4.327308817,6.298535243}, /*cfy*/
          {1.941579363,-0.03669663908,421.7917458,-1.725668219,-0.004552808675,0.8660933226}, /*cmz*/
          {2.705678251,4.271263266,1.814775195,1.584159805} /*cfz*/
     },
     {
          2463679.5,
          {-2.36275123,-0.002410603633,391.8140525,1.447034019,-0.005904392021,0.8022591851}, /*cmx*/
          {0.7523173609,5.364241366,5.653165135,6.044177849}, /*cfx*/
          {-0.9397936177,-0.00319920406,156.1761119,0.6010502093,0.002847666059,0.330259747}, /*cmy*/
          {0.7609689108,-0.2201331129,3.398248658,6.06094255}, /*cfy*/
          {0.8209578958,-0.04223247232,421.800206,-1.519477925,-0.006160869927,0.8696733797}, /*cmz*/
          {2.324293722,3.886574016,1.045848454,1.336033902} /*cfz*/
     },
     {
          2463709.5,
          {-2.423595891,0.01460417275,388.3851513,1.108451139,-0.007845076887,0.7992789572}, /*cmx*/
          {0.3883387732,5.006544399,5.095051961,5.819688376}, /*cfx*/
          {-1.033215534,0.004583797,164.5587609,0.4530219277,0.003451509274,0.3451904109}, /*cmy*/
          {0.4114110129,5.625097345,2.586731221,5.849600524}, /*cfy*/
          {-0.4670539862,-0.03675996731,421.7896176,-1.167482354,-0.008366122033,0.8715794393}, /*cmz*/
          {1.962655411,3.521608707,0.4651038347,1.114711887} /*cfz*/
     },
     {
          2463739.5,
          {-1.969365408,0.02494272895,386.2219838,0.6317814787,-0.009923325877,0.7981618604}, /*cmx*/
          {0.05483427011,4.677007584,4.690705361,5.63049085}, /*cfx*/
          {-0.8889831981,0.01005927313,169.6038807,0.2430270896,0.004307491796,0.3534289274}, /*cmy*/
          {0.0902328739,5.288760639,2.035300064,5.671155511}, /*cfy*/
          {-1.581103137,-0.02440313332,421.7552224,-0.6610481715,-0.01070404381,0.8721741889}, /*cmz*/
          {1.631379417,3.188227278,0.04936458635,0.9279865252} /*cfz*/
     },
     {
          2463769.5,
          {-1.208150038,0.0278295237,385.3386876,0.01557066577,-0.01005123799,0.7988128762}, /*cmx*/
          {6.045958989,3.974083088,4.414832676,5.48795424}, /*cfx*/
          {-0.5806737542,0.01206907803,171.6220057,-0.04292969321,0.004265843901,0.355292311}, /*cmy*/
          {6.090690022,4.050038118,1.782728979,5.535583797}, /*cfy*/
          {-2.315170586,-0.01073127489,421.7096327,0.00289084291,-0.01072978719,0.8725130554}, /*cmz*/
          {1.340981102,2.91239272,6.064119867,0.7850122632} /*cfz*/
     },
     {
          2463799.5,
          {-0.3732782231,0.02623294309,385.7302576,-0.6233108762,-0.005260720558,0.8006552572}, /*cmx*/
          {5.801809651,-14.67965297,4.282696886,5.386590831}, /*cfx*/
          {-0.2174926168,0.01151541333,170.7742186,-0.301341237,0.002188465422,0.3504980288}, /*cmy*/
          {5.851506496,10.83591593,1.982794384,5.436432259}, /*cfy*/
          {-2.632810292,0.0001105432398,421.6914107,-0.6824705882,-0.005431287947,0.8717642583}, /*cmz*/
          {1.097561898,5.806030609,5.975821441,0.6817609142} /*cfz*/
     },
     {
          2463829.5,
          {0.4119112415,0.02424210464,387.3139788,-0.9494317961,0.004300511389,0.8022795864}, /*cmx*/
          {5.595382449,3.958987033,3.856371073,5.303039955}, /*cfx*/
          {0.1274796739,0.01027610898,167.2196373,-0.4230382948,-0.002415929499,0.3402672959}, /*cmy*/
          {5.644634961,4.488309978,-5.342202674,5.350275424}, /*cfy*/
          {-2.628070384,0.009096772401,421.725555,-1.017144129,0.004881533048,0.8697958494}, /*cmz*/
          {0.8907078222,5.611105941,5.470437877,0.5965420962} /*cfz*/
     },
     {
          2463859.5,
          {1.143692163,0.02223110441,389.3159935,-0.6678321252,0.01116999721,0.8021451641}, /*cmx*/
          {5.391991243,3.74305759,3.759470123,5.194835622}, /*cfx*/
          {0.43640681,0.00925240336,162.4616903,-0.2851131369,-0.004957184465,0.3306388318}, /*cmy*/
          {5.43630662,4.437858931,1.164109708,5.236279248}, /*cfy*/
          {-2.360633614,0.01914930761,421.7410446,-0.7013592927,0.01192535784,0.8659494889}, /*cmz*/
          {0.6861640907,5.410601032,5.408815426,0.4875348402} /*cfz*/
     },
     {
          2463889.5,
          {1.826250919,0.01596692664,390.3806339,0.02863283532,0.01178986073,0.7991621137}, /*cmx*/
          {5.151231661,3.913540622,3.482124104,5.037094197}, /*cfx*/
          {0.7189525232,0.00734353379,159.7666466,0.03823693313,-0.005040529381,0.3281407056}, /*cmy*/
          {5.189869235,3.089866097,0.942820649,5.073887768}, /*cfy*/
          {-1.788064238,0.03065064921,421.7247986,0.03997943899,0.01244738325,0.8625590205}, /*cmz*/
          {0.4443970851,5.237891848,5.134648423,6.612855606} /*cfz*/
     },
     {
          2463919.5,
          {2.317043822,0.002976922204,389.752325,0.7420785619,0.008707616418,0.7930122983}, /*cmx*/
          {4.856180069,-3.05721787,3.047216469,4.827731869}, /*cfx*/
          {0.944677672,0.002980514789,161.2444136,0.3273200032,-0.003751552431,0.333747648}, /*cmy*/
          {4.892478546,10.00582256,0.3859892715,4.864357081}, /*cfy*/
          {-0.8619529205,0.03912593801,421.7067216,0.7961040136,0.009333167586,0.8592163641}, /*cmz*/
          {0.1490931529,450.9807661,4.683666633,6.403410885} /*cfz*/
     },
     {
          2463949.5,
          {2.406412966,-0.01477960406,387.689723,1.262211512,0.00552036551,0.7851998333}, /*cmx*/
          {4.513251364,2.878030087,2.40944091,4.581859003}, /*cfx*/
          {1.036740765,-0.004328340968,166.1673376,0.5506939273,-0.002788910978,0.3441603662}, /*cmy*/
          {4.552130117,3.368422032,-0.5256004449,4.623530542}, /*cfy*/
          {0.3317354656,0.03911554599,421.7021543,1.350841254,0.006184093675,0.8561503184}, /*cmz*/
          {6.090068764,4.525663482,4.018257532,6.1586087} /*cfz*/
     },
     {
          2463979.5,
          {1.953019331,-0.03103534095,385.007393,1.566242533,0.003472003667,0.7780474121}, /*cmx*/
          {4.137889592,2.509378287,1.474394909,4.314501776}, /*cfx*/
          {0.9048227202,-0.01242136449,172.3657737,0.6835186961,-0.00257892646,0.3552292918}, /*cmy*/
          {4.183695595,2.922680332,4.71341184,4.365290782}, /*cfy*/
          {1.525045672,0.02809591475,421.6983202,1.682373172,0.00422882015,0.8545004551}, /*cmz*/
          {5.716298513,4.146705453,3.088036223,5.892900914} /*cfz*/
     },
     {
          2464009.5,
          {1.004472141,-0.03983155182,382.5759657,1.683094795,0.003012283373,0.7735807451}, /*cmx*/
          {3.745203881,2.131228808,0.3737913287,4.040889814}, /*cfx*/
          {0.5246793941,-0.01789458569,177.8015364,0.7337383871,-0.002707700247,0.363976467}, /*cmy*/
          {3.801069006,2.439247845,3.80066109,4.103155932}, /*cfy*/
          {2.381420775,0.008216211679,421.6825516,1.81699973,0.003779066949,0.8541862796}, /*cmz*/
          {5.325877673,3.752275732,2.047075696,5.621596499} /*cfz*/
     },
     {
          2464039.5,
          {-0.2062284837,-0.03779993571,381.0322341,1.659283813,0.003588716405,0.7718667098}, /*cmx*/
          {3.348097653,1.753645754,-0.6112350315,3.770745518}, /*cfx*/
          {-0.02053037307,-0.01806899837,181.2201375,0.7174631454,-0.002784963208,0.3685531021}, /*cmy*/
          {3.416070605,1.942100532,2.947779395,3.845781926}, /*cfy*/
          {2.625303001,-0.01399374627,421.6490466,1.799325657,0.004303633757,0.8552636816}, /*cmz*/
          {4.931403221,3.354333456,1.065997886,5.354215778} /*cfz*/
     },
     {
          2464069.5,
          {-1.354445644,-0.02593645626,380.6309821,1.513510542,0.004749482262,0.772867358}, /*cmx*/
          {2.95718741,1.38436944,4.911433492,3.515474695}, /*cfx*/
          {-0.570289633,-0.01299858567,182.2208923,0.6423725902,-0.002872380301,0.3688790171}, /*cmy*/
          {3.038493796,1.448203998,2.108479541,3.604029342}, /*cfy*/
          {2.187235744,-0.0317191731,421.5937235,1.642716099,0.005444376532,0.857146191}, /*cmz*/
          {4.543115686,2.963116792,0.2646852201,5.101919856} /*cfz*/
     },
     {
          2464099.5,
          {-2.136907391,-0.008869984846,381.2309706,1.254111379,0.006664563974,0.7769986282}, /*cmx*/
          {2.582283089,1.029145143,4.305014466,3.281321806}, /*cfx*/
          {-0.9622980483,-0.005227697031,181.1556658,0.5157255747,-0.00327743614,0.3666556976}, /*cmy*/
          {2.677434443,0.9697679985,1.281569559,3.383531201}, /*cfy*/
          {1.213107372,-0.03970528547,421.5189394,1.358349624,0.00747021856,0.8598701231}, /*cmz*/
          {4.170588863,2.587683909,5.893954146,4.871535936} /*cfz*/
     },
     {
          2464129.5,
          {-2.397003614,0.007564437364,382.3328368,0.8577076196,0.008984446749,0.7821283912}, /*cmx*/
          {2.233294218,0.6971182186,3.853475954,3.079242465}, /*cfx*/
          {-1.116171632,0.002096323096,179.0019911,0.3325757885,-0.004004773279,0.3637771717}, /*cmy*/
          {2.341904358,0.5185294875,0.6177824189,3.194127808}, /*cfy*/
          {0.00275323358,-0.03734308768,421.42814,0.9219031096,0.009929084619,0.8629159293}, /*cmz*/
          {3.823581361,2.238162131,5.408210382,4.672447658} /*cfz*/
     },
     {
          2464159.5,
          {-2.155230348,0.01835386612,383.2427349,0.3093859553,0.01065272416,0.7866914786}, /*cmx*/
          {1.921244581,0.4063174335,3.533443014,2.916141462}, /*cfx*/
          {-1.047007078,0.006882479064,177.1836448,0.09218223972,-0.004503380929,0.3629702187}, /*cmy*/
          {2.041400206,0.02302286764,0.2061501537,3.040513525}, /*cfy*/
          {-1.121250826,-0.02782371612,421.3306708,0.3208094188,0.01163533828,0.8654649067}, /*cmz*/
          {3.513125411,1.92659385,5.073787809,4.511130509} /*cfz*/
     },
     {
          2464189.5,
          {-1.589598874,0.02281760717,383.3506151,-0.354407744,0.008317416696,0.7886119553}, /*cmx*/
          {1.65570311,0.1149289,3.340985387,2.797885784}, /*cfx*/
          {-0.8349056512,0.009376252791,177.0307047,-0.1902777273,-0.003239661266,0.3655983878}, /*cmy*/
          {1.78304195,6.299258148,6.356291623,2.926100657}, /*cfy*/
          {-1.95225649,-0.01650121843,421.2562557,-0.4001714469,0.009008644272,0.8681243259}, /*cmz*/
          {3.248790847,1.668063261,4.889028599,4.393468435} /*cfz*/
     },
     {
          2464219.5,
          {-0.9018461854,0.024186887,382.597954,-0.8722971791,0.0008097411099,0.7892341206}, /*cmx*/
          {1.436195544,6.193024342,-14.26079013,2.70954881}, /*cfx*/
          {-0.5524436064,0.01101544198,178.7157515,-0.3922903213,0.0007978875585,0.3710911355}, /*cmy*/
          {1.563847209,6.080144419,5.199885356,2.834746208}, /*cfy*/
          {-2.442902231,-0.006947591382,421.2683837,-0.956247133,-0.00096915774,0.8711365989}, /*cmz*/
          {3.029761756,1.460946904,-40.83539184,4.303890703} /*cfz*/
     },
     {
          2464249.5,
          {-0.176260474,0.0262003028,381.6308404,-0.8533919848,0.009089494941,0.7894098422}, /*cmx*/
          {1.237907525,5.993518787,24.81774276,2.617349936}, /*cfx*/
          {-0.2213514451,0.01285301991,180.7243456,-0.3521822276,-0.00431329071,0.3754077609}, /*cmy*/
          {1.359090208,5.93591817,9.054325405,2.734512636}, /*cfy*/
          {-2.65654654,0.002114639759,421.3215032,-0.9217124989,-0.01001680866,0.8724299548}, /*cmz*/
          {2.830817555,1.268089281,4.383738726,4.211180155} /*cfz*/
     },
     {
          2464279.5,
          {0.6152446595,0.0271092063,381.0850162,-0.2706208042,0.01200338461,0.7891027148}, /*cmx*/
          {1.017227243,5.766224493,5.754527738,2.480913296}, /*cfx*/
          {0.1674750884,0.01375350706,181.6698276,-0.07699379237,-0.005280951868,0.3763599872}, /*cmy*/
          {1.12932432,5.68204538,2.609808341,2.589524081}, /*cfy*/
          {-2.599163706,0.01385040296,421.3573378,-0.2779229454,-0.01311280065,0.8718006583}, /*cmz*/
          {2.608682157,1.029219858,4.177184637,4.072453347} /*cfz*/
     },
     {
          2464309.5,
          {1.446505514,0.02231249157,381.0311983,0.4711806635,0.00987610734,0.7885113365}, /*cmx*/
          {0.7441779841,5.487032119,5.389865048,2.289199284}, /*cfx*/
          {0.5893645604,0.01168157579,181.6021585,0.2496549128,-0.004167012718,0.3746914564}, /*cmy*/
          {0.8498628366,5.52171772,2.140432374,2.393552633}, /*cfy*/
          {-2.179045912,0.02809973185,421.3758425,0.5301398692,-0.0108058665,0.8699032585}, /*cmz*/
          {2.334409106,0.7862536963,3.79559371,3.879098939} /*cfz*/
     },
     {
          2464339.5,
          {2.132217517,0.009585997347,381.5026122,1.070965276,0.006502319291,0.7875026777}, /*cmx*/
          {0.4180035537,5.164825894,4.848321957,2.050029622}, /*cfx*/
          {0.948240888,0.005589493685,180.5618424,0.5011793717,-0.002935217579,0.3697125645}, /*cmy*/
          {0.5226293192,5.133243861,1.284363237,2.156221653}, /*cfy*/
          {-1.319092375,0.03954261201,421.3925991,1.181466636,-0.00715412287,0.8678226105}, /*cmz*/
          {2.007829906,0.4461226644,3.208966912,3.639343313} /*cfz*/
     },
     {
          2464369.5,
          {2.427603689,-0.008687699907,382.7850387,1.450026371,0.004118673417,0.7884960182}, /*cmx*/
          {0.05335616454,4.812308019,4.062044754,1.785499445}, /*cfx*/
          {1.119147165,-0.003168630851,177.8817082,0.6483127035,-0.002730972402,0.3606209637}, /*cmy*/
          {0.1623291747,4.683697455,0.2276081501,1.898248981}, /*cfy*/
          {-0.1082079065,0.04230585414,421.3855815,1.588918623,-0.004723446944,0.8650303929}, /*cmz*/
          {1.643400962,0.07579027488,2.365551896,3.374674603} /*cfz*/
     },
     {
          2464399.5,
          {2.158363686,-0.02672602919,385.171308,1.641139416,0.003103704915,0.7910063955}, /*cmx*/
          {5.950160242,4.441085813,3.028801396,1.508199762}, /*cfx*/
          {1.018097077,-0.0112465156,172.8055995,0.7091175778,-0.003012575039,0.3458588585}, /*cmy*/
          {6.068012541,4.186565761,5.608602446,1.631077292}, /*cfy*/
          {1.180247522,0.03325896704,421.35458,1.788182033,-0.003852435975,0.8610750215}, /*cmz*/
          {1.257426656,5.969103192,1.325885043,3.098880353} /*cfz*/
     },
     {
          2464429.5,
          {1.335114106,-0.03858333226,388.6554805,1.681774744,0.003326484873,0.795976167}, /*cmx*/
          {5.555807341,4.063163639,2.021757923,1.23713136}, /*cfx*/
          {0.6693631298,-0.01549560042,164.9941003,0.7052239957,-0.003166501174,0.3262025417}, /*cmy*/
          {5.686324947,3.659888884,4.847992841,1.373215791}, /*cfy*/
          {2.19193095,0.01460517411,421.3021298,1.819775383,-0.004086149772,0.8579114733}, /*cmz*/
          {0.8632450971,5.572493692,0.3638455363,2.826835576} /*cfz*/
     },
     {
          2464459.5,
          {0.1532999544,-0.04005844614,392.932231,1.603196454,0.0042472304,0.8023106519}, /*cmx*/
          {5.164418664,3.684371572,1.148954493,0.976742557}, /*cfx*/
          {0.1946910306,-0.01466521418,154.7420173,0.6572681489,-0.003092006641,0.3027148256}, /*cmy*/
          {5.311019469,3.119232492,4.080725801,1.129342195}, /*cfy*/
          {2.630927232,-0.007591566259,421.2457394,1.718928627,-0.004908272487,0.8547102297}, /*cmz*/
          {0.4715421598,5.178493446,-0.484551787,2.565186456} /*cfz*/
     },
     {
          2464489.5,
          {-1.06924174,-0.03118542649,397.4178819,1.404126615,0.005854137107,0.8096293224}, /*cmx*/
          {4.785055033,3.313389762,0.4437542709,0.7378751806}, /*cfx*/
          {-0.2499517167,-0.01025705812,143.0216978,0.569934914,-0.002994718843,0.2783180972}, /*cmy*/
          {4.950935493,2.581476098,3.232856987,0.9105564507}, /*cfy*/
          {2.394181709,-0.02616111843,421.1845268,1.492583215,-0.006457749144,0.8543792508}, /*cmz*/
          {0.09145028246,4.796789952,5.085178746,2.325685164} /*cfz*/
     },
     {
          2464519.5,
          {-2.010385276,-0.01558093718,401.4180863,1.072320236,0.008298372182,0.815086576}, /*cmx*/
          {4.426833868,2.959774575,-0.1129697338,0.526142362}, /*cfx*/
          {-0.5554185658,-0.00503241175,131.5519755,0.4379892387,-0.003442895926,0.2566941482}, /*cmy*/
          {4.614253328,2.06604504,2.368064362,0.7206665882}, /*cfy*/
          {1.590144849,-0.03578709294,421.1318458,1.130622263,-0.00888699381,0.8533753891}, /*cmz*/
          {6.015495339,4.435058624,4.516456292,2.112610206} /*cfz*/
     },
     {
          2464549.5,
          {-2.473951737,0.000649984167,404.2347732,0.5747561305,0.01072547596,0.8198895511}, /*cmx*/
          {4.099910754,2.645218661,5.773813719,6.63571112}, /*cfx*/
          {-0.7031166362,-0.001185615584,122.7420955,0.2435318352,-0.0043069495,0.243873278}, /*cmy*/
          {4.307844537,1.5630717,1.744679948,0.5663004782}, /*cfy*/
          {0.4956025455,-0.03564557591,421.0566885,0.6002649693,-0.01131775949,0.8544422633}, /*cmz*/
          {5.687872981,4.110914924,4.119876272,1.940567218} /*cfz*/
     },
     {
          2464579.5,
          {-2.444348792,0.01240235445,405.3014247,-0.08822238917,0.01053043394,0.8193660168}, /*cmx*/
          {3.815190776,2.162314486,5.528930276,6.504784683}, /*cfx*/
          {-0.7375841347,0.001076615532,119.2541525,0.04493341986,-0.004221136816,0.2435418132}, /*cmy*/
          {4.035755721,-0.7429082736,1.434998701,0.4450374865}, /*cfy*/
          {-0.5833635931,-0.02887766891,420.982687,-0.09477570608,-0.01114207962,0.8547759802}, /*cmz*/
          {5.403151058,3.755046864,3.873410044,1.810674197} /*cfz*/
     },
     {
          2464609.5,
          {-2.070239221,0.01892179106,404.336607,-0.747075094,0.00421977677,0.8178630188}, /*cmx*/
          {3.578304,-10.47181768,5.545256569,6.412175176}, /*cfx*/
          {-0.7088002101,0.003172354338,122.579791,0.2946822089,-0.001617643555,0.2565056041}, /*cmy*/
          {3.796592208,-1.841034295,1.450908745,6.629451851}, /*cfy*/
          {-1.447653707,-0.02088059127,420.9501037,-0.7900594168,-0.004453860772,0.8572805351}, /*cmz*/
          {5.167046958,3.58355208,3.88914428,1.720376722} /*cfz*/
     },
     {
          2464639.5,
          {-1.507777027,0.02373666343,401.7960012,-0.9862058955,-0.006419477167,0.8157327011}, /*cmx*/
          {3.375770802,1.917145429,4.941344761,6.328513255}, /*cfx*/
          {-0.6169562104,0.006356803556,130.7243882,0.3883253259,0.00256159579,0.2744157456}, /*cmy*/
          {3.578502874,4.233757516,1.11604053,6.526805522}, /*cfy*/
          {-2.068072199,-0.01395843814,421.001083,-1.04071861,0.006846847525,0.861075344}, /*cmz*/
          {4.965599409,3.395385307,3.280371633,1.638097655} /*cfz*/
     },
     {
          2464669.5,
          {-0.7989187912,0.02944480273,399.1837545,-0.5667448487,-0.01215983695,0.8209636831}, /*cmx*/
          {3.168409854,1.720705485,4.836347136,6.215049513}, /*cfx*/
          {-0.4257882287,0.01005119846,138.2358292,0.2204181227,0.00487785841,0.2884484365}, /*cmy*/
          {3.352814544,3.930143354,1.034583515,6.393885296}, /*cfy*/
          {-2.496243689,-0.005416643516,421.0621625,-0.5928937379,0.01300480553,0.8680298753}, /*cmz*/
          {4.758634586,3.184570742,3.183552035,1.523657539} /*cfz*/
     },
     {
          2464699.5,
          {0.09313593496,0.03316217233,398.1890049,0.1881620949,-0.01132573567,0.8260525973}, /*cmx*/
          {2.917319947,1.417440856,4.536111598,6.044543562}, /*cfx*/
          {-0.1181564559,0.01191554798,140.7846226,-0.1071806214,0.004549739726,0.28942995}, /*cmy*/
          {3.089537672,4.522502946,0.651496503,6.213775541}, /*cfy*/
          {-2.672396626,0.007952707209,421.1072722,0.212286503,0.01206190545,0.8724403221}, /*cmz*/
          {4.506977456,2.994452644,2.878112435,1.351277612} /*cfz*/
     },
     {
          2464729.5,
          {1.105665907,0.03003004726,399.3259425,0.8736437916,-0.008046023435,0.8342155842}, /*cmx*/
          {2.61178218,1.141165765,4.04687182,5.822420253}, /*cfx*/
          {0.2475297762,0.009992351679,137.3406924,-0.3621178803,0.00350093035,0.2777388685}, /*cmy*/
          {2.781321858,3.732348707,-0.08332571542,5.992462781}, /*cfy*/
          {-2.441222506,0.0244983672,421.1456265,0.939351866,0.008395003883,0.8762590866}, /*cmz*/
          {4.200274083,2.645562254,2.380252349,1.125793055} /*cfz*/
     },
     {
          2464759.5,
          {2.020765929,0.01753062177,402.2881655,1.346184134,-0.00523740483,0.8402305967}, /*cmx*/
          {2.263158097,0.7927361842,3.326105892,5.564975684}, /*cfx*/
          {0.5512596888,0.004440991316,128.380898,-0.5416005312,0.003129508672,0.2532320256}, /*cmy*/
          {2.440036313,3.216825504,5.239550473,5.745847468}, /*cfy*/
          {-1.693714087,0.03835920165,421.1804122,1.428174885,0.005379091549,0.8752708682}, /*cmz*/
          {3.850022155,2.286613982,1.647108814,0.8670650623} /*cfz*/
     },
     {
          2464789.5,
          {2.554744942,-0.002043260861,406.421107,1.611504884,-0.003955244893,0.8479475532}, /*cmx*/
          {1.888047467,0.4148987303,2.368327385,5.291879421}, /*cfx*/
          {0.682398777,-0.002128311388,114.6426081,-0.6452947061,0.003277497096,0.219892865}, /*cmy*/
          {2.083112245,2.678437145,4.369334749,5.495046751}, /*cfy*/
          {-0.5189027976,0.04365865948,421.1995191,1.693184601,0.003958049291,0.8745841687}, /*cmz*/
          {3.472909874,1.905321171,0.6749629217,0.592234421} /*cfz*/
     },
     {
          2464819.5,
          {2.487490768,-0.02281968913,410.9727315,1.711494595,-0.003902425745,0.8535808768}, /*cmx*/
          {1.500756776,0.01937283449,1.388767933,5.017044495}, /*cfx*/
          {0.6105312893,-0.006460602923,97.10387177,-0.6954669498,0.003278843358,0.1797499917}, /*cmy*/
          {1.728232646,2.120931492,3.601844538,5.259455036}, /*cfy*/
          {0.815155728,0.03728712058,421.2242144,1.782631609,0.003769685236,0.869591331}, /*cmz*/
          {3.083221447,1.511912088,-0.3221414683,0.3157140993} /*cfz*/
     },
     {
          2464849.5,
          {1.789372208,-0.0378548122,415.1810487,1.678328723,-0.004454195579,0.8585096986}, /*cmx*/
          {1.112294787,5.899383657,0.4963727389,4.750179882}, /*cfx*/
          {0.4088854197,-0.006905244212,77.16996991,-0.7034938503,0.002988200847,0.1371076857}, /*cmy*/
          {1.39498506,1.566136876,2.811127926,5.063314387}, /*cfy*/
          {1.947973157,0.02098438182,421.2367514,1.734701155,0.004312481155,0.8663487347}, /*cmz*/
          {2.692075365,1.118793613,5.067005008,6.329522272} /*cfz*/
     },
     {
          2464879.5,
          {0.6316058062,-0.04217669042,418.4540954,1.519532641,-0.005511737915,0.858437704}, /*cmx*/
          {0.7316084748,5.497578056,-0.3153464288,4.502691868}, /*cfx*/
          {0.1977618542,-0.004391663055,56.84504596,-0.6657808026,0.002724990517,0.09630141322}, /*cmy*/
          {1.111694177,1.034921211,1.869093319,4.946750019}, /*cfy*/
          {2.574195903,-3.072449861e-05,421.2563243,1.565367803,0.005573035629,0.8602236802}, /*cmz*/
          {2.308714605,0.7331691816,4.276967867,6.077444533} /*cfz*/
     },
     {
          2464909.5,
          {-0.6539952139,-0.03557081405,420.4903324,1.230452376,-0.007580994155,0.8573813709}, /*cmx*/
          {0.3674746948,5.110934938,5.280545705,4.279854247}, /*cfx*/
          {0.06795187711,-0.001618284517,38.88314117,-0.5674373703,0.003199987913,0.06432705484}, /*cmy*/
          {0.9269807621,0.5465688476,0.8750767593,4.965435254}, /*cfy*/
          {2.560435057,-0.01882045402,421.2718803,1.264336823,0.007783192933,0.8565985221}, /*cmz*/
          {1.942130013,0.3649036279,3.646128615,5.85168855} /*cfz*/
     },
     {
          2464939.5,
          {-1.731000606,-0.02193617126,421.4236204,0.7796432539,-0.01019301449,0.8528623121}, /*cmx*/
          {0.02977290339,4.753790239,4.774658052,4.094183348}, /*cfx*/
          {0.02423897471,-0.0007634797612,26.68845102,-0.3894144493,0.004425746015,0.04732712768}, /*cmy*/
          {0.8919971619,0.1199816539,0.168340842,5.113039786}, /*cfy*/
          {1.975503417,-0.02996534731,421.2761986,0.8012029505,0.01047152384,0.8529291575}, /*cmz*/
          {1.602565828,0.02621577654,3.188157716,5.66348127} /*cfz*/
     },
     {
          2464969.5,
          {-2.384809642,-0.007528947189,421.6540838,0.1498284872,-0.0113920116,0.8504609442}, /*cmx*/
          {6.013168625,4.47791047,4.4638507,3.950766846}, /*cfx*/
          {0.004334270548,-0.001952096982,22.00496171,-0.119080984,0.005195112239,0.04435302625}, /*cmy*/
          {0.8780152896,6.074236612,6.081580095,5.103176004}, /*cfy*/
          {1.062284096,-0.03216373941,421.2593042,0.1561166954,0.01167647784,0.851117959}, /*cmz*/
          {1.301796795,6.048029752,2.889951813,5.520476579} /*cfz*/
     },
     {
          2464999.5,
          {-2.59518623,0.003597633104,421.6111782,-0.5701968225,-0.007217188158,0.8463562072}, /*cmx*/
          {5.760374589,4.184724011,4.357861559,3.853893106}, /*cfx*/
          {-0.05603176625,-0.003326429798,22.55673932,0.2077206194,0.003639668975,0.05174787873}, /*cmy*/
          {0.5717526332,5.806883134,6.007606927,4.772851874}, /*cfy*/
          {0.08978784597,-0.02868454157,421.2563294,-0.5846151024,0.007278827842,0.8497326699}, /*cmz*/
          {1.049091808,5.745803486,2.76150936,5.426185052} /*cfz*/
     },
     {
          2465029.5,
          {-2.479448774,0.01209176553,421.2587049,-1.016510954,0.003377982549,0.8464752567}, /*cmx*/
          {5.549372056,4.005923706,3.651485917,3.777029395}, /*cfx*/
          {-0.1608790538,-0.002801604515,28.82411511,0.4324232461,-0.0009946673265,0.07059276294}, /*cmy*/
          {0.03347904825,5.665253982,5.026292218,4.404895439}, /*cfy*/
          {-0.7700566648,-0.0248062404,421.2874998,-1.043267055,-0.003485097963,0.8512815423}, /*cmz*/
          {0.8392570882,5.553542034,2.118962415,5.351710477} /*cfz*/
     },
     {
          2465059.5,
          {-2.117189229,0.0212413288,420.397779,-0.8010941299,0.0114666545,0.8502364021}, /*cmx*/
          {5.34835427,3.830785555,3.806909243,3.680014563}, /*cfx*/
          {-0.2483036583,-8.314674683e-05,39.40792407,0.3740806148,-0.004439030569,0.08880681895}, /*cmy*/
          {5.872743146,5.501062401,24.42661499,4.151190956}, /*cfy*/
          {-1.517686497,-0.02128626454,421.3181421,-0.8240108533,-0.01184474555,0.8555992491}, /*cmz*/
          {0.6397020216,5.360345578,2.206651196,5.256625086} /*cfz*/
     },
     {
          2465089.5,
          {-1.482203326,0.03134651646,419.6561094,-0.08790679345,0.01238858606,0.8578335319}, /*cmx*/
          {5.114747124,3.621828423,3.573281873,3.531343894}, /*cfx*/
          {-0.2490168796,0.002757244066,46.10881487,0.0994078974,-0.005126790464,0.09360385972}, /*cmy*/
          {5.543461521,4.947467345,5.353604111,3.951061189}, /*cfy*/
          {-2.167276848,-0.01402209687,421.3141851,-0.09197894226,-0.01272483835,0.8618666524}, /*cmz*/
          {0.4068640221,5.058479168,1.959645411,5.106288321} /*cfz*/
     },
     {
          2465119.5,
          {-0.5282675608,0.0381060537,419.8165152,0.6588636121,0.009340719989,0.8649532518}, /*cmx*/
          {4.828516945,3.30916206,3.140111164,3.329719816}, /*cfx*/
          {-0.1600237214,0.003307256549,44.15914924,0.2231702102,-0.004156605002,0.08079312613}, /*cmy*/
          {5.259243025,2.138950128,4.809900489,3.794388325}, /*cfy*/
          {-2.598638748,0.0001039969592,421.3371181,0.6731623675,-0.009519440251,0.8669987281}, /*cmz*/
          {0.120286335,4.850308344,1.544481703,4.903583177} /*cfz*/
     },
     {
          2465149.5,
          {0.638853342,0.0366718333,420.7148841,1.210050576,0.006099300551,0.8709199505}, /*cmx*/
          {4.495865516,2.962923954,2.457516604,3.087864254}, /*cfx*/
          {-0.05569021252,0.0010786438,34.18874708,0.462178024,-0.003293515286,0.05472553372}, /*cmy*/
          {5.037308168,1.619930549,3.982237633,3.765654411}, /*cfy*/
          {-2.599118106,0.01850620896,421.3763169,1.232286779,-0.006082388164,0.871972958}, /*cmz*/
          {6.069546035,4.507194251,0.9184056305,4.659733315} /*cfz*/
     },
     {
          2465179.5,
          {1.764831104,0.0247690625,421.584813,1.535054781,0.004454116077,0.8746888932}, /*cmx*/
          {4.132114351,2.577440185,1.542373259,2.824469888}, /*cfx*/
          {-0.02350182901,-0.00209210872,20.45754571,0.6202713732,-0.00298095308,0.02608072519}, /*cmy*/
          {5.086942121,1.121072997,3.061379538,4.265130588}, /*cfy*/
          {-2.033018435,0.03508451566,421.4289152,1.560786816,-0.004033172118,0.8749760357}, /*cmz*/
          {5.704017426,4.13644043,0.05017688732,4.395124543} /*cfz*/
     },
     {
          2465209.5,
          {2.520087037,0.005091407851,421.6505243,1.682421687,0.004083543408,0.874543884}, /*cmx*/
          {3.751757787,2.170631842,0.5503879103,2.54983482}, /*cfx*/
          {-0.09176278397,-0.00341222278,18.40191929,0.7056438698,-0.002875446947,-0.05165060122}, /*cmy*/
          {5.878306573,0.6096413308,2.181026504,4.181949129}, /*cfy*/
          {-0.9624054742,0.04357531671,421.4826522,1.70787611,-0.003404165031,0.8764471729}, /*cmz*/
          {5.321694423,3.750830637,5.286617869,4.120626302} /*cfz*/
     },
     {
          2465239.5,
          {2.66637821,-0.01656139111,420.5039069,1.683400453,0.004234520218,0.8705565588}, /*cmx*/
          {3.365965018,1.755628291,-0.3533269757,2.280501238}, /*cfx*/
          {-0.2002426744,-0.00135823764,35.808605,0.7265575634,-0.002756271067,-0.0140909408}, /*cmy*/
          {6.093572201,0.09805297653,1.315112334,-1.053667767}, /*cfy*/
          {0.3694162184,0.04051522404,421.5387111,1.709478061,-0.003723486079,0.8751976109}, /*cmz*/
          {4.93411094,3.36067958,4.318632994,3.85011374} /*cfz*/
     },
     {
          2465269.5,
          {2.15286917,-0.03304298134,418.1781865,1.56329322,0.005033697501,0.8633944839}, /*cmx*/
          {2.984042056,1.345815324,5.048926037,2.022576216}, /*cfx*/
          {-0.2431653797,0.003089362977,56.62402656,0.6864490912,-0.002678740378,-0.1329541665}, /*cmy*/
          {5.893358895,5.882937196,0.4011615499,1.840207074}, /*cfy*/
          {1.603948248,0.02711837153,421.5919728,1.590576483,-0.004896408467,0.8719764144}, /*cmz*/
          {4.550819547,2.975051947,3.46175937,3.590990994} /*cfz*/
     },
     {
          2465299.5,
          {1.140172348,-0.03968648303,415.1509299,1.313208654,0.006787865318,0.8538506077}, /*cmx*/
          {2.614766466,0.9520874165,4.307891731,1.788508536}, /*cfx*/
          {-0.1466891265,0.007157280355,75.51428494,0.5847941859,-0.003012919361,-0.171821174}, /*cmy*/
          {5.602258576,5.416555104,-0.536098038,1.658865456}, /*cfy*/
          {2.426886027,0.00804478509,421.6413647,1.33813589,-0.006884429263,0.8680341549}, /*cmz*/
          {4.180709098,2.602221295,2.785808306,3.354607989} /*cfz*/
     },
     {
          2465329.5,
          {-0.0638178793,-0.03609405669,412.1885478,0.9149694181,0.009452487184,0.8438137931}, /*cmx*/
          {2.268270789,0.5854316094,3.768934219,1.585447513}, /*cfx*/
          {0.07442638984,0.008276171786,90.12400895,0.4156998915,-0.003979123454,-0.1949165527}, /*cmy*/
          {5.296414292,5.013570123,4.995927005,1.484722215}, /*cfy*/
          {2.663710977,-0.009782488062,421.6696287,0.9330400433,-0.009694248023,0.8630264624}, /*cmz*/
          {3.833938722,2.254042092,2.286475466,3.149188638} /*cfz*/
     },
     {
          2465359.5,
          {-1.154563028,-0.02592137599,410.1720773,0.3363966897,0.01126411252,0.8359337552}, /*cmx*/
          {1.956364935,0.2463410378,3.415630002,1.426010712}, /*cfx*/
          {0.3288533609,0.005879186811,98.69172698,0.1725810023,-0.004891878767,-0.2037298478}, /*cmy*/
          {5.005972726,4.810631134,4.580144305,1.339102569}, /*cfy*/
          {2.354662509,-0.02143284634,421.6817486,0.3387009896,-0.01153368615,0.8587363457}, /*cmz*/
          {3.522143611,1.945354243,1.94441332,2.989541126} /*cfz*/
     },
     {
          2465389.5,
          {-1.93335079,-0.01487746302,409.8688678,-0.3715016811,0.00895866419,0.8330728165}, /*cmx*/
          {1.69022537,6.320299178,3.226680297,1.313469052}, /*cfx*/
          {0.5073449834,0.001714118662,99.78029638,-0.1465404954,-0.004190624007,-0.1965386468}, /*cmy*/
          {4.747691145,4.002752095,4.497257557,1.228906047}, /*cfy*/
          {1.70012812,-0.0259376703,421.6843871,-0.3880413502,-0.009094824131,0.8560394279}, /*cmz*/
          {3.256320551,1.674839931,1.752847955,2.877970082} /*cfz*/
     },
     {
          2465419.5,
          {-2.381280197,-0.005678999124,411.4623898,-0.937380268,-0.000952809003,0.8350367514}, /*cmx*/
          {1.469995296,6.09871114,-29.97948272,1.234577101}, /*cfx*/
          {0.5566576609,-0.001754932732,93.06809939,-0.3998170515,-0.001409706882,-0.1760502395}, /*cmy*/
          {4.522969952,4.073752918,5.384052014,1.141392828}, /*cfy*/
          {0.9198171932,-0.02723869917,421.7152223,-0.9627602119,0.0009452453828,0.8547757127}, /*cmz*/
          {3.036500762,1.470865603,-12.52807456,2.801038902} /*cfz*/
     },
     {
          2465449.5,
          {-2.55493423,0.003247082072,413.9056295,-0.9187733963,0.009445929443,0.8375581801}, /*cmx*/
          {1.271042209,5.910612956,125.2711186,1.149345864}, /*cfx*/
          {0.5004343449,-0.003119349083,81.66925312,-0.4225711278,0.003738674573,-0.1538081165}, /*cmy*/
          {4.308686615,4.024211852,10.13920762,1.037738475}, /*cfy*/
          {0.1083851061,-0.02897923561,421.7266372,-0.9393404702,-0.009709323686,0.8529120551}, /*cmz*/
          {2.837953943,1.281205142,67.22911984,2.715936323} /*cfz*/
     },
     {
          2465479.5,
          {-2.460470469,0.01511481473,415.5745071,-0.319210664,0.01229868475,0.8396397863}, /*cmx*/
          {1.050452656,5.672567894,5.702569252,1.022080624}, /*cfx*/
          {0.40632319,-0.003393572202,72.60854653,-0.1906318388,0.005161886619,-0.1438926181}, /*cmy*/
          {4.071394431,3.9306722,3.825523559,0.8985499851}, /*cfy*/
          {-0.7665832174,-0.02919823019,421.69245,-0.3277411312,-0.01259272337,0.8521852396}, /*cmz*/
          {2.617683778,1.058001676,4.198256391,2.588124848} /*cfz*/
     },
     {
          2465509.5,
          {-2.006891847,0.02856721365,415.7494281,0.4342584555,0.009844497865,0.8408143362}, /*cmx*/
          {0.7808585667,5.462267584,5.330382868,0.8407011514}, /*cfx*/
          {0.3077315692,-0.004535359864,71.4251947,0.1262728935,0.004316956299,-0.151193315}, /*cmy*/
          {3.80053776,3.444596476,3.437903101,0.726817162}, /*cfy*/
          {-1.657239382,-0.0232341034,421.671283,0.437212988,-0.01011887743,0.8546187408}, /*cmz*/
          {2.348158102,0.7902489618,3.842610603,2.406643537} /*cfz*/
     },
     {
          2465539.5,
          {-1.139978732,0.03856421403,414.4376612,1.026542922,0.006543465342,0.8409355545}, /*cmx*/
          {0.4624216551,5.11554849,4.751109192,0.6166601323}, /*cfx*/
          {0.1742676197,-0.007253409722,78.59705909,0.3860616298,0.00305965009,-0.1729696289}, /*cmy*/
          {3.499763784,3.172965306,2.706717201,0.5267917319}, /*cfy*/
          {-2.371656906,-0.009054421607,421.6802263,1.041310329,-0.00671579649,0.8588329643}, /*cmz*/
          {2.029589493,0.4652859408,3.304879493,2.182762657} /*cfz*/
     },
     {
          2465569.5,
          {0.03156503285,0.03971086992,411.7432905,1.40073744,0.004232346145,0.8384321269}, /*cmx*/
          {0.1087368083,4.743754264,3.916287822,0.3639818902}, /*cfx*/
          {-0.0444582633,-0.01004512902,91.61486921,0.5562965547,0.00246203778,-0.2034961178}, /*cmy*/
          {3.171494369,2.750799986,1.7220737,6.583142171}, /*cfy*/
          {-2.64885267,0.01024413555,421.7090655,1.429148183,-0.004172711948,0.8635354162}, /*cmz*/
          {1.675818342,0.1071886769,2.512037816,1.93060732} /*cfz*/
     },
     {
          2465599.5,
          {1.241705105,0.03016168468,407.8877645,1.583028846,0.003341652908,0.8333601971}, /*cmx*/
          {6.017253176,4.354054835,2.915591669,6.381868535}, /*cfx*/
          {-0.3525185386,-0.01039967011,107.4447173,0.6447303309,0.002440691693,-0.2372226623}, /*cmy*/
          {2.821371698,2.279789009,0.7669196673,6.340513722}, /*cfy*/
          {-2.33046635,0.02914329478,421.7403852,1.624788891,-0.003194508666,0.8679415978}, /*cmz*/
          {1.301355591,6.013127092,1.491615459,1.666369243} /*cfz*/
     },
     {
          2465629.5,
          {2.157189415,0.01253964775,403.3014325,1.621117062,0.003408079244,0.8274593898}, /*cmx*/
          {5.633465345,3.95961892,1.875271662,6.113362828}, /*cfx*/
          {-0.6722493685,-0.00678237639,123.5411019,0.6678611603,0.002405255248,-0.2700140706}, /*cmy*/
          {2.458866412,1.786818155,-0.1030225433,6.091422965}, /*cfy*/
          {-1.43597429,0.04115260462,421.7670898,1.6753985,-0.003400361975,0.8716664347}, /*cmz*/
          {0.9182760917,5.62776422,0.4215004744,1.400008413} /*cfz*/
     },
     {
          2465659.5,
          {2.532856269,-0.007757919572,398.5616349,1.531767026,0.004251916445,0.8209618605}, /*cmx*/
          {5.2502259,3.571393405,0.9817919113,5.853025713}, /*cfx*/
          {-0.8801817634,0.0001376025215,138.0726739,0.6349119223,0.002363699909,-0.2984230689}, /*cmy*/
          {2.093884236,1.296709393,5.278372966,5.848017652}, /*cfy*/
          {-0.1787151628,0.04249979135,421.7851717,1.593746691,-0.004402059673,0.8742882325}, /*cmz*/
          {0.5362929034,5.243506678,-0.4668698337,1.142184019} /*cfz*/
     },
     {
          2465689.5,
          {2.286929747,-0.02417720904,394.27831,1.324322788,0.00611862635,0.814855371}, /*cmx*/
          {4.87694722,3.197905599,0.2683834608,5.609504349}, /*cfx*/
          {-0.8736300763,0.007540805636,149.8882962,0.5480106055,0.002709588349,-0.3203352711}, /*cmy*/
          {1.736449025,0.8284459578,4.311020916,5.619198271}, /*cfy*/
          {1.108015758,0.03307945612,421.7916314,1.383794903,-0.006387188316,0.8746682363}, /*cmz*/
          {0.1647058678,4.869097176,5.094886926,0.9005610413} /*cfz*/
     },
     {
          2465719.5,
          {1.540286657,-0.03267656974,390.9460509,0.9724125858,0.00855838621,0.8088525488}, /*cmx*/
          {4.523815977,2.846510387,-0.2450331781,5.395837472}, /*cfx*/
          {-0.6388951185,0.01249392984,158.3872936,0.3967571463,0.003652546446,-0.3342438535}, /*cmy*/
          {1.396970488,0.4169886847,3.557381184,5.417543992}, /*cfy*/
          {2.103467826,0.01702911782,421.7799705,1.016270881,-0.009034010382,0.8728576759}, /*cmz*/
          {6.096680369,4.515708603,4.566560816,0.6881892292} /*cfz*/
     },
     {
          2465749.5,
          {0.5439765866,-0.03237590337,388.8911842,0.4578801749,0.01070166954,0.8038309091}, /*cmx*/
          {4.202986088,2.522582798,5.678726587,5.220817761}, /*cfx*/
          {-0.2558802674,0.01339230332,163.3505066,0.1744264748,0.004579972114,-0.3399149007}, /*cmy*/
          {1.087234932,0.1595149451,3.106049984,5.250933758}, /*cfy*/
          {2.60737315,0.0008435952222,421.7539013,0.4697596988,-0.01133420148,0.8701993294}, /*cmz*/
          {5.777627626,4.197169862,4.196909815,0.5134069293} /*cfz*/
     },
     {
          2465779.5,
          {-0.4342955123,-0.02664298084,388.3100225,-0.2029798335,0.009524762983,0.800724268}, /*cmx*/
          {3.926242518,2.301121972,5.446667452,5.091964622}, /*cfx*/
          {0.1506352959,0.01108609844,164.6983696,-0.1195179889,0.004008775232,-0.3375471189}, /*cmy*/
          {0.8180427358,5.671765684,2.971453474,5.126260705}, /*cfy*/
          {2.623990877,-0.01080102469,421.7186366,-0.233480686,-0.009986989375,0.8665050091}, /*cmz*/
          {5.502102677,3.910275964,3.977988976,6.668581887} /*cfz*/
     },
     {
          2465809.5,
          {-1.229477567,-0.02001405129,389.3106815,-0.7966642613,0.002548062256,0.7998264952}, /*cmx*/
          {3.697214602,2.04975538,5.475251222,4.99973318}, /*cfx*/
          {0.4819696531,0.007696841475,162.3602451,-0.3634484199,0.001439579538,-0.327852678}, /*cmy*/
          {0.5917703322,5.723498447,3.665475585,5.03440191}, /*cfy*/
          {2.294476523,-0.01776996685,421.7238334,-0.856242554,-0.002577522177,0.863301173}, /*cmz*/
          {5.273356832,3.700048724,4.129703296,6.576663667} /*cfz*/
     },
     {
          2465839.5,
          {-1.831445423,-0.01412816179,391.5125666,-0.9286442004,-0.006986300875,0.8007589699}, /*cmx*/
          {3.497036579,1.843514949,4.94587943,4.918186353}, /*cfx*/
          {0.7117909026,0.004843192182,157.0074455,-0.4059217347,0.003285904859,-0.3146666877}, /*cmy*/
          {0.3891459109,5.674738329,5.407668614,4.949479574}, /*cfy*/
          {1.756871371,-0.02416489865,421.7551209,-0.9819308049,-0.00761067609,0.8592888017}, /*cmz*/
          {5.072467894,3.509614508,12.86793383,6.493357868} /*cfz*/
     },
     {
          2465869.5,
          {-2.263919828,-0.006112444069,393.6315299,-0.4702341288,-0.0111986384,0.8004765031}, /*cmx*/
          {3.285295133,1.606266223,4.774487125,4.803600983}, /*cfx*/
          {0.85844948,0.002224453916,151.5227342,-0.2060711123,0.004808016014,-0.305096425}, /*cmy*/
          {0.171792183,5.657633228,5.471047247,4.829319269}, /*cfy*/
          {1.025680497,-0.03121175896,421.7584886,-0.4882329614,-0.01185386439,0.8561715926}, /*cmz*/
          {4.859683644,3.297187392,0.156301669,6.376770804} /*cfz*/
     },
     {
          2465899.5,
          {-2.457583486,0.006536537962,394.3278228,0.2271705519,-0.009946546612,0.798232586}, /*cmx*/
          {3.029296851,1.454210031,4.452410818,4.638770277}, /*cfx*/
          {0.9295087254,-0.001567492427,149.5849267,0.1007742655,0.00417801851,-0.3050866613}, /*cmy*/
          {6.1943719,4.871848415,5.171219662,4.661771237}, /*cfy*/
          {0.07573149986,-0.03548694997,421.7424025,0.2454053909,-0.01048071398,0.8545193107}, /*cmz*/
          {4.603030241,3.053253854,6.125706414,6.210562973} /*cfz*/
     },
     {
          2465929.5,
          {-2.260271097,0.02167834731,393.2594348,0.8310975461,-0.006799420318,0.7939326749}, /*cmx*/
          {2.723549206,1.087016008,3.972638021,4.42509564}, /*cfx*/
          {0.8847032325,-0.007050777146,152.3594571,0.3524961779,0.002921277013,-0.3139813569}, /*cmy*/
          {5.888046035,4.822425456,4.541695276,4.450522397}, /*cfy*/
          {-1.003965071,-0.03199754032,421.7341717,0.8818779822,-0.0072170103,0.8537856292}, /*cmz*/
          {4.297346411,2.735527141,5.639894474,5.998748441} /*cfz*/
     },
     {
          2465959.5,
          {-1.595193663,0.03430348374,390.8586635,1.232869008,-0.004277810232,0.7890649583}, /*cmx*/
          {2.37901971,0.7355437383,3.287459838,4.183961319}, /*cfx*/
          {0.6699332447,-0.01301929078,158.4517057,0.5259724055,0.0022377217,-0.3280845665}, /*cmy*/
          {5.547358003,4.45854297,3.59980197,4.215589751}, /*cfy*/
          {-1.982433023,-0.0191343398,421.7248965,1.311703236,-0.004633447449,0.854889626}, /*cmz*/
          {3.953634689,2.387729732,4.928708209,5.758824742} /*cfz*/
     },
     {
          2465989.5,
          {-0.5442634031,0.0391762169,387.8550809,1.454734514,-0.002821482957,0.7849586066}, /*cmx*/
          {2.009966225,0.3691083406,2.322112925,3.925176544}, /*cfx*/
          {0.2708093004,-0.01680107545,165.7497845,0.6240998698,0.002115805747,-0.3434471578}, /*cmy*/
          {5.18559387,4.021890667,2.607552302,3.965311678}, /*cfy*/
          {-2.566913067,0.0004447931772,421.7153456,1.553937461,-0.00330462135,0.8564708836}, /*cmz*/
          {3.586039325,2.016879149,3.958050066,5.501699373} /*cfz*/
     },
     {
          2466019.5,
          {0.6538521776,0.03416530094,384.9375742,1.527531396,-0.00265299389,0.7824413635}, /*cmx*/
          {1.628596425,-0.002290855293,1.207006438,3.663162236}, /*cfx*/
          {-0.2446980402,-0.01623748843,172.5017119,0.6572972485,0.00219260885,-0.3570863779}, /*cmy*/
          {4.813871889,3.557197626,1.706178107,3.713418659}, /*cfy*/
          {-2.552595074,0.02104673098,421.6961902,1.64070127,-0.003244234864,0.8604331175}, /*cmz*/
          {3.206704197,1.635233891,2.892701288,5.242223927} /*cfz*/
     },
     {
          2466049.5,
          {1.690295545,0.02037020902,382.6490791,1.480450212,-0.003560304513,0.7810083663}, /*cmx*/
          {1.245392192,5.91225659,0.2202102078,3.405044148}, /*cfx*/
          {-0.7391428003,-0.01085811976,177.6262842,0.6343418453,0.002332859218,-0.3667374976}, /*cmy*/
          {4.44182601,3.084512533,0.7951609654,3.466544749}, /*cfy*/
          {-1.904176048,0.03613137245,421.6763513,1.595967574,-0.004115059704,0.8636272166}, /*cmz*/
          {2.825890735,1.251115171,1.919977837,4.985923958} /*cfz*/
     },
     {
          2466079.5,
          {2.304098327,0.002285827296,381.2627295,1.311540698,-0.0053449537,0.7828904081}, /*cmx*/
          {0.8700446131,5.554277033,5.793204139,3.163082367}, /*cfx*/
          {-1.067552895,-0.00262273874,180.6952759,0.5528904326,0.002758988298,-0.3728580075}, /*cmy*/
          {4.078459818,2.622244091,-0.08971608006,3.23626369}, /*cfy*/
          {-0.7941783433,0.04145704036,421.6340686,1.414498745,-0.005911875344,0.8675544484}, /*cmz*/
          {2.453056803,0.8757692968,1.164346816,4.748047746} /*cfz*/
     },
     {
          2466109.5,
          {2.364155184,-0.0141698388,380.7528091,1.005511766,-0.007800754326,0.7847175057}, /*cmx*/
          {0.5130502348,5.213862544,5.275223722,2.945450907}, /*cfx*/
          {-1.142677327,0.005286167469,181.9014012,0.4080753042,0.003590951138,-0.3749754709}, /*cmy*/
          {3.73353886,2.186596042,5.451340326,3.029964838}, /*cfy*/
          {0.4703844838,0.03628669793,421.5773884,1.081633359,-0.008565931248,0.8699711824}, /*cmz*/
          {2.098480045,0.518679701,0.5984186482,4.53342218} /*cfz*/
     },
     {
          2466139.5,
          {1.927981911,-0.0243000497,380.7688646,0.536546665,-0.01002233753,0.7878093126}, /*cmx*/
          {0.1862388349,4.905873459,4.909076448,2.765330139}, /*cfx*/
          {-0.9793831201,0.01038314999,181.9636935,0.1937294663,0.004400876304,-0.3760545761}, /*cmy*/
          {3.417822735,1.806681923,4.956466747,2.859539601}, /*cfy*/
          {1.568412517,0.02436127352,421.4977781,0.566248181,-0.0108846068,0.8715175726}, /*cmz*/
          {1.773707798,0.1966074558,0.20545942,4.35573365} /*cfz*/
     },
     {
          2458849.5,
          {7.160283517,0.06020358953,669.3469305,2.644453285,0.006136100873,2.962486999}, /*cmx*/
          {-1.66797399,-3.284104703,-5.419095508,-2.319492943}, /*cfx*/
          {0.7531402655,0.01510387966,56.09360256,1.178880452,0.004568723482,0.3249783393}, /*cmy*/
          {-2.161985788,-1.763682191,-3.749975765,-2.664615753}, /*cfy*/
          {-6.037522739,0.1428947151,670.6023373,2.679467421,0.005355675709,2.987112427}, /*cmz*/
          {-0.1001061157,-1.676113907,-3.794233077,-0.7586429638} /*cfz*/
     },
     {
          2458879.5,
          {9.067166579,-0.01483547119,665.4956686,2.475573116,0.008848690471,2.932117501}, /*cmx*/
          {1.031252277,5.680295325,3.060092199,3.598889945}, /*cfx*/
          {1.245205861,0.006739834082,89.07237221,1.098141002,0.004397778622,0.4643731143}, /*cmy*/
          {0.7605231944,0.8086057117,4.629689104,3.393468709}, /*cfy*/
          {-1.684140326,0.1513294996,670.5055971,2.51811286,0.008748883493,2.981375926}, /*cmz*/
          {2.597465194,1.029938722,4.655977591,5.166369799} /*cfz*/
     },
     {
          2458909.5,
          {8.650553875,-0.07744012817,660.8788131,2.038152111,0.01174342123,2.898806066}, /*cmx*/
          {3.743352193,2.075013993,5.373189408,3.254245682}, /*cfx*/
          {1.467834488,-0.009440806477,118.9897373,0.9061570945,0.005198436852,0.5785993365}, /*cmy*/
          {3.565508154,3.427661711,0.5399210797,3.105962141}, /*cfy*/
          {2.922845426,0.1217641012,670.8681031,2.072296663,0.01174287652,2.968877371}, /*cmz*/
          {5.308615782,3.720367866,0.6811735354,4.824368641} /*cfz*/
     },
     {
          2458939.5,
          {6.29668814,-0.1112393558,656.2287755,1.362069014,0.01600494811,2.901871704}, /*cmx*/
          {0.197208651,4.805865048,1.704557189,2.94360618}, /*cfx*/
          {1.184775804,-0.02318080459,141.2878153,0.6113030498,0.00676271584,0.659497312}, /*cmy*/
          {0.06622257219,6.104730682,2.907760069,2.831009939}, /*cfy*/
          {6.659566507,0.06954584383,670.6895983,1.391341895,0.01650784528,2.978284716}, /*cmz*/
          {1.762262798,0.19893005,3.388567294,4.515037809} /*cfz*/
     },
     {
          2458969.5,
          {2.923150659,-0.1155039165,653.5732759,0.3753940382,0.0168401085,2.928613241}, /*cmx*/
          {2.970253347,1.22431795,4.411793712,2.674265611}, /*cfx*/
          {0.4702678171,-0.02702272856,153.3042527,0.2004445381,0.007389845822,0.6916590491}, /*cmy*/
          {2.862206516,2.797438625,5.649902219,2.571376513}, /*cfy*/
          {8.799215942,0.01668088118,670.9936725,0.3860826493,0.01766188366,2.997070872}, /*cmz*/
          {4.535525423,2.909281423,6.067047341,4.244741983} /*cfz*/
     },
     {
          2458999.5,
          {-0.5362477019,-0.1021210572,653.2614047,-0.6950888825,0.01299787185,2.967386346}, /*cmx*/
          {5.789851679,4.078327185,1.153941996,2.444719916}, /*cfx*/
          {-0.3524586595,-0.02102951123,153.0697425,-0.2802600201,0.005971782736,0.6683204472}, /*cmy*/
          {5.688140458,5.072229799,2.382997983,2.332256565}, /*cfy*/
          {9.331635494,-0.02288911551,670.7168885,-0.7306565794,0.01286642389,3.022130964}, /*cmz*/
          {1.07210271,5.739565275,2.794890652,4.011789713} /*cfz*/
     },
     {
          2459029.5,
          {-3.589418947,-0.08568190542,656.3381768,-1.507620333,-0.001459789639,3.026984605}, /*cmx*/
          {2.368801741,0.7308577359,3.173066146,2.239151186}, /*cfx*/
          {-0.9811249039,-0.01124661591,141.2334499,-0.6463909541,0.001688239958,0.604745555}, /*cmy*/
          {2.258729017,1.880024878,-12.00570689,2.120508174}, /*cfy*/
          {8.697353951,-0.05127282509,671.0141661,-1.546272788,-0.001570542021,3.073742122}, /*cmz*/
          {3.934805947,2.379801642,4.844292778,3.802650746} /*cfz*/
     },
     {
          2459059.5,
          {-6.168262562,-0.06847505271,659.6600595,-1.417378694,-0.01410366426,3.060902264}, /*cmx*/
          {5.249061749,3.587714792,12.93195416,2.01965928}, /*cfx*/
          {-1.315300127,-0.005131142704,123.216256,-0.6280526782,-0.005858853013,0.5363218303}, /*cmy*/
          {5.118391759,4.878865349,1.651546845,1.867387313}, /*cfy*/
          {7.206446444,-0.0817217252,670.8169068,-1.465533448,-0.01498691777,3.088936001}, /*cmz*/
          {0.5321800036,5.249109524,8.346831639,3.585252489} /*cfz*/
     },
     {
          2459089.5,
          {-8.31423401,-0.03866583164,662.3364209,-0.5361923223,-0.01922122068,3.102303159}, /*cmx*/
          {1.824088012,0.2281407528,3.373762269,1.76357712}, /*cfx*/
          {-1.466083769,-0.003484866883,110.0360523,-0.2635028499,-0.008222968852,0.5083644052}, /*cmy*/
          {1.673974907,1.501703904,4.641701646,1.612829726}, /*cfy*/
          {4.808579421,-0.1146704417,670.9300869,-0.5497167044,-0.01964619055,3.140071674}, /*cmz*/
          {3.390947233,1.850075458,4.986321379,3.327280824} /*cfz*/
     },
     {
          2459119.5,
          {-9.583042978,0.01119327149,662.0819386,0.6362373499,-0.01622085963,3.117379182}, /*cmx*/
          {4.635990077,3.059944299,6.002667054,1.45092976}, /*cfx*/
          {-1.58506143,-0.001547358206,109.4608076,0.2407158099,-0.00688726476,0.5420118519}, /*cmy*/
          {4.488030589,4.360879098,1.019408774,1.322672888}, /*cfy*/
          {1.379922305,-0.1360949516,670.6172322,0.6488985008,-0.01635168057,3.174933329}, /*cmz*/
          {6.202927838,4.695063431,1.358939442,3.017274898} /*cfz*/
     },
     {
          2459149.5,
          {-9.302987271,0.07446800523,660.0247753,1.622161543,-0.01084872842,3.098080505}, /*cmx*/
          {1.116025517,5.753633183,2.308705227,1.092982581}, /*cfx*/
          {-1.658885364,0.007260494646,122.4958697,0.6577045794,-0.005319831376,0.6329896563}, /*cmy*/
          {0.9942635679,0.7718967727,3.361587769,0.9920486108}, /*cfy*/
          {-2.746562743,-0.1284401254,670.8929097,1.634516627,-0.01150441841,3.164841706}, /*cmz*/
          {2.682685658,1.116004606,3.991506177,2.659674455} /*cfz*/
     },
     {
          2459179.5,
          {-7.076539891,0.1299621862,655.1355389,2.269808456,-0.008060079038,3.062274301}, /*cmx*/
          {3.841582248,2.192911488,4.554386054,0.7105271688}, /*cfx*/
          {-1.47058322,0.0244765394,145.2586265,0.9497298901,-0.004455111491,0.7477885463}, /*cmy*/
          {3.754741892,3.401137903,5.426841813,0.6479627203}, /*cfy*/
          {-6.699192034,-0.08233288777,670.7889396,2.328843648,-0.007933862467,3.154615137}, /*cmz*/
          {5.408432129,3.851511038,-0.08776200741,2.278569114} /*cfz*/
     },
     {
          2459209.5,
          {-3.126745079,0.153915528,648.4832709,2.626165283,-0.005701821089,3.003891552}, /*cmx*/
          {0.2598540656,4.871670101,0.392718393,0.3143064859}, /*cfx*/
          {-0.741677505,0.04210638574,172.8894353,1.094068223,-0.004643291888,0.8751599662}, /*cmy*/
          {0.2047587405,5.98803163,1.295459692,6.559689021}, /*cfy*/
          {-9.272982512,-0.007945815453,671.1156126,2.681991594,-0.005308921243,3.12786155}, /*cmz*/
          {1.826908875,0.2501574008,2.156410872,1.882371554} /*cfz*/
     },
     {
          2459239.5,
          {1.557071034,0.1351792729,640.2543902,2.722309848,-0.006407850704,2.946340832}, /*cmx*/
          {2.94981579,1.278943977,2.421080764,6.200671068}, /*cfx*/
          {0.5345036619,0.04851364411,200.605898,1.140908862,-0.004712002674,0.9923468638}, /*cmy*/
          {2.921678556,2.26640391,3.437416347,6.188872112}, /*cfy*/
          {-9.592452194,0.07082521968,670.9268523,2.8113307,-0.006531517589,3.103321567}, /*cmz*/
          {4.51818424,2.951968233,4.101419122,1.483919749} /*cfz*/
     },
     {
          2459269.5,
          {5.673145454,0.0816078425,632.221111,2.586139196,-0.007270008811,2.860340621}, /*cmx*/
          {5.639238926,3.954056986,4.457071522,5.813532816}, /*cfx*/
          {2.021406588,0.0376328719,225.2814711,1.064563456,-0.004161681787,1.073205691}, /*cmy*/
          {5.633353034,4.824925806,5.668797002,5.819667336}, /*cfy*/
          {-7.469307598,0.1283601102,671.1991572,2.694858233,-0.007713954358,3.059270409}, /*cmz*/
          {0.9263780714,5.62624999,-0.1497946406,1.101886024} /*cfz*/
     },
     {
          2459299.5,
          {8.1783335,0.01285202663,624.8012894,2.231598992,-0.01034459965,2.797066305}, /*cmx*/
          {2.055864634,0.3883169901,0.6685979953,5.448247488}, /*cfx*/
          {3.187990144,0.01301984703,244.6254193,0.9223751945,-0.004959008429,1.135381249}, /*cmy*/
          {2.069017816,1.1418124,1.53578581,5.472543831}, /*cfy*/
          {-3.55832932,0.1484744559,671.025176,2.317485644,-0.01038258738,3.022283746}, /*cmz*/
          {3.628270368,2.051494151,2.318383997,0.7416981865} /*cfz*/
     },
     {
          2459329.5,
          {8.57970889,-0.04715705773,619.6225106,1.646806719,-0.01381747446,2.754079872}, /*cmx*/
          {4.776599309,3.091860001,3.112004169,5.118839481}, /*cfx*/
          {3.594453909,-0.01394661077,258.2835924,0.6555170912,-0.005761815629,1.171005246}, /*cmy*/
          {4.805744177,3.773199733,3.775619752,5.156317468}, /*cfy*/
          {0.9695944644,0.130749531,671.0849017,1.716388215,-0.01445033374,2.98957671}, /*cmz*/
          {0.06849125113,4.763249534,4.802435671,0.4148949416} /*cfz*/
     },
     {
          2459359.5,
          {7.161612302,-0.08269129598,616.0411969,0.8158138305,-0.01688906836,2.736631843}, /*cmx*/
          {1.247415644,5.894671057,5.920371739,4.825926257}, /*cfx*/
          {3.179355018,-0.03273274524,265.878811,0.3089341426,-0.007426516289,1.189130214}, /*cmy*/
          {1.289417698,0.3189276045,0.1853731072,4.873414283}, /*cfy*/
          {4.929656801,0.08971389038,670.8482268,0.8404450045,-0.01792225722,2.976951259}, /*cmz*/
          {2.824742985,1.267494038,1.281223044,6.408364374} /*cfz*/
     },
     {
          2459389.5,
          {4.656802852,-0.09329741506,615.3496924,-0.2135656106,-0.01627252324,2.734781606}, /*cmx*/
          {4.04602838,2.496584007,2.392616901,4.585000073}, /*cfx*/
          {2.185018115,-0.03980860538,268.2202699,-0.1559349665,-0.006629458866,1.185528443}, /*cmy*/
          {4.096734805,2.684474918,2.99549298,4.637162494}, /*cfy*/
          {7.611823015,0.04534425347,670.9989516,-0.2706914954,-0.0167279857,2.964220736}, /*cmz*/
          {5.624705824,4.084580241,4.062275739,6.164514326} /*cfz*/
     },
     {
          2459419.5,
          {1.84970588,-0.09292745348,616.5683824,-1.256305489,-0.004646408819,2.736313383}, /*cmx*/
          {0.6095441827,5.238889631,5.610804911,4.390287269}, /*cfx*/
          {0.9775855348,-0.03964471708,264.9276877,-0.5813647122,-0.002552283186,1.155586192}, /*cmy*/
          {0.6636560359,5.736502139,6.817542434,4.440313024}, /*cfy*/
          {8.9335788,0.008413230167,670.7142606,-1.327627446,-0.00573289074,2.957781806}, /*cmz*/
          {2.189028995,0.5918482827,1.105609337,5.961523069} /*cfz*/
     },
     {
          2459449.5,
          {-0.9095455237,-0.09209664825,620.07148,-1.55626373,0.009926577068,2.796470254}, /*cmx*/
          {3.489806454,1.853932551,1.823715215,4.189918426}, /*cfx*/
          {-0.1987214258,-0.03744178709,257.1994339,-0.6843815258,-0.004929220451,1.135626238}, /*cmy*/
          {3.541748531,2.491530679,5.42892954,4.239445408}, /*cfy*/
          {9.224105066,-0.0251277213,671.1140387,-1.655138301,0.01098990774,3.005215311}, /*cmz*/
          {5.068172961,3.51887091,3.478800036,5.763876726} /*cfz*/
     },
     {
          2459479.5,
          {-3.66577868,-0.08860824543,623.2048627,-0.9355040126,0.01902308971,2.828229828}, /*cmx*/
          {0.08020029573,4.687295929,4.684274133,3.961932821}, /*cfx*/
          {-1.317176322,-0.03556532316,248.7259161,-0.3863511784,-0.008084894103,1.118275809}, /*cmy*/
          {0.1264209959,5.453858512,2.221021594,4.004326176}, /*cfy*/
          {8.516883687,-0.0642228804,670.8061405,-0.9627895021,0.01967748268,3.038907314}, /*cmz*/
          {1.657488809,0.06821175239,0.05339301419,5.532046732} /*cfz*/
     },
     {
          2459509.5,
          {-6.366689655,-0.06538722323,624.4924424,0.2372695231,0.01715695374,2.849529532}, /*cmx*/
          {2.911451963,1.300233201,1.218471584,3.676896193}, /*cfx*/
          {-2.392712353,-0.02981025141,245.7197881,0.1163231514,-0.007320454659,1.131565728}, /*cmy*/
          {2.953114295,1.724326774,5.056902308,3.718579814}, /*cfy*/
          {6.618517118,-0.1089648425,671.1016527,0.2656840922,0.01786676745,3.082001167}, /*cmz*/
          {4.487937735,2.859839083,2.916559375,5.248784175} /*cfz*/
     },
     {
          2459539.5,
          {-8.404065813,-0.01515312105,622.5803551,1.292675551,0.01295790489,2.869417502}, /*cmx*/
          {5.68903367,4.055111564,3.8030942,3.337675627}, /*cfx*/
          {-3.314373282,-0.01400378559,250.2719693,0.5680029562,-0.005499461838,1.181271072}, /*cmy*/
          {5.730835655,4.700214414,1.140566656,3.384582082}, /*cfy*/
          {3.319750202,-0.1426035407,670.8106104,1.354539917,0.01420581476,3.119936933}, /*cmz*/
          {0.9823061719,5.71772684,5.462495884,4.916326155} /*cfz*/
     },
     {
          2459569.5,
          {-8.91582623,0.05132664814,618.620924,2.048936602,0.007948804219,2.870680022}, /*cmx*/
          {2.139027603,0.4895808208,0.007647010885,2.960071023}, /*cfx*/
          {-3.772377838,0.01272443505,260.3603747,0.8816255443,-0.00439815521,1.240906164}, /*cmy*/
          {2.186205953,1.080240577,3.348511685,3.012592707}, /*cfy*/
          {-1.043205996,-0.144745806,670.9374879,2.187275259,0.008617053052,3.140560588}, /*cmz*/
          {3.717064682,2.14793579,1.606484821,4.544067397} /*cfz*/
     },
     {
          2459599.5,
          {-7.398269144,0.1112233938,613.5378548,2.49010423,0.005585375305,2.875926727}, /*cmx*/
          {4.842828425,3.212013176,2.070856262,2.557897858}, /*cfx*/
          {-3.412946732,0.0426880073,271.8952434,1.077160126,-0.004429316201,1.305935785}, /*cmy*/
          {4.899529485,3.699016437,5.384096402,2.622549165}, /*cfy*/
          {-5.46679384,-0.1061346832,670.7892115,2.648692476,0.006995017316,3.159167888}, /*cmz*/
          {0.1395491472,4.859201086,3.727963864,4.14462077} /*cfz*/
     },
     {
          2459629.5,
          {-4.007454967,0.1434191418,609.3062367,2.67102561,0.004536813321,2.864512282}, /*cmx*/
          {1.247848209,5.905221115,3.907630163,2.154556304}, /*cfx*/
          {-2.113953872,0.06345023314,281.9490188,1.149802296,-0.00405514999,1.346019428}, /*cmy*/
          {1.316606417,-0.01563993462,1.255897957,2.23076303}, /*cfy*/
          {-8.723670908,-0.03507154861,670.8192163,2.860065943,0.005886286308,3.142805943}, /*cmz*/
          {2.830582715,1.256430143,-0.5967210534,3.74089584} /*cfz*/
     },
     {
          2459659.5,
          {0.3928079188,0.1370634382,606.2862188,2.57722104,0.005571410685,2.842941287}, /*cmx*/
          {3.931957486,2.333625103,-0.01586273423,1.75609023}, /*cfx*/
          {-0.1653501587,0.06567294687,288.3512041,1.105452028,-0.004300077282,1.361535444}, /*cmy*/
          {4.014255176,2.575454065,3.605078588,1.845290597}, /*cfy*/
          {-9.816386113,0.04621286792,670.6962524,2.797128478,0.006986155115,3.132574819}, /*cmz*/
          {5.518094006,3.945000382,1.66575716,3.339618284} /*cfz*/
     },
     {
          2459689.5,
          {4.597560175,0.09580007129,605.2792407,2.354774693,0.008304716039,2.817522769}, /*cmx*/
          {0.3406053996,5.042355031,2.191134983,1.372826726}, /*cfx*/
          {1.850163434,0.04905975144,290.9276301,0.9959425901,-0.004591931421,1.3536407}, /*cmy*/
          {0.4370399681,5.157538187,-0.5870785916,1.476989028}, /*cfy*/
          {-8.423655,0.11063058,670.6874792,2.538039967,0.009008079928,3.11702865}, /*cmz*/
          {1.929363462,0.3450605971,3.843822235,2.956900915} /*cfz*/
     },
     {
          2459719.5,
          {7.529581488,0.03623509678,605.7571632,1.887006097,0.01122101827,2.793249932}, /*cmx*/
          {3.049166906,1.492114702,4.760786188,1.00945002}, /*cfx*/
          {3.349781661,0.02232638619,290.2342564,0.7709209704,-0.005260053146,1.331113895}, /*cmy*/
          {3.159581303,1.494743302,1.746019932,1.126980736}, /*cfy*/
          {-5.069453889,0.1389629872,670.352761,2.052503887,0.01286156584,3.092696702}, /*cmz*/
          {4.640677058,3.065110974,0.08219846274,2.596998487} /*cfz*/
     },
     {
          2459749.5,
          {8.61308707,-0.02026226153,607.0182675,1.228753457,0.01606960891,2.759040795}, /*cmx*/
          {5.786229485,4.238274913,1.096723443,0.6893086218}, /*cfx*/
          {4.017090643,-0.003207967489,287.9839255,0.4722557052,-0.007140462808,1.303493145}, /*cmy*/
          {5.9097247,4.145848876,4.195844881,0.8192037652}, /*cfy*/
          {-0.8130860112,0.1305277189,670.37086,1.329374518,0.01790875353,3.062443453}, /*cmz*/
          {1.096580169,5.783995913,2.643385952,2.283930354} /*cfz*/
     },
     {
          2459779.5,
          {7.954319716,-0.0581882083,607.8492798,0.2465119751,0.01654841596,2.730650175}, /*cmx*/
          {2.279403173,0.8111257669,3.912279443,0.4178855005}, /*cfx*/
          {3.902067706,-0.02090552606,286.2423684,0.03804437501,-0.006898528697,1.285392413}, /*cmy*/
          {2.413348639,0.3314081559,0.6774648336,0.5562987386}, /*cfy*/
          {3.189841139,0.09877645685,670.1004504,0.2258918513,0.01762947546,3.024333325}, /*cmz*/
          {3.874148957,2.321916405,5.462241816,2.018159398} /*cfz*/
     },
     {
          2459809.5,
          {6.174585941,-0.07576782468,607.7537707,-0.8167090704,0.01113927113,2.708300905}, /*cmx*/
          {5.105168677,3.558254733,0.5358697636,6.476933254}, /*cfx*/
          {3.266027604,-0.03124358358,286.7233966,0.410450533,-0.004281755357,1.282153036}, /*cmy*/
          {5.244657636,0.3655072559,3.750229247,6.617067432}, /*cfy*/
          {6.18643454,0.0628893723,670.0895372,-0.9026331058,0.01225192935,2.997547042}, /*cmz*/
          {0.4180853364,5.131599118,2.075516015,1.792441962} /*cfz*/
     },
     {
          2459839.5,
          {3.883975845,-0.08514371151,606.6298556,-1.530805839,-0.004496023461,2.689990485}, /*cmx*/
          {1.691501536,0.1411585624,2.913494233,6.285444632}, /*cfx*/
          {2.322847199,-0.03907688083,288.8619206,0.6821837234,0.002926476868,1.286050439}, /*cmy*/
          {1.829643124,3.281548794,-0.2862401523,6.420430067}, /*cfy*/
          {8.073874926,0.03319051669,670.0998142,-1.699544233,-0.005834075154,2.975573809}, /*cmz*/
          {3.287418068,1.719048578,4.584570125,1.604473356} /*cfz*/
     },
     {
          2459869.5,
          {1.340551395,-0.09698200275,605.9359498,-1.247101674,-0.01563437553,2.698030481}, /*cmx*/
          {4.574438146,3.035439019,6.174062778,6.077080844}, /*cfx*/
          {1.153989183,-0.04739151379,290.563348,0.5084031299,0.007237526167,1.295616401}, /*cmy*/
          {4.705294012,6.247019934,3.078871378,6.203602767}, /*cfy*/
          {9.090912591,0.0004800912191,670.2106274,-1.339584794,-0.01705274882,2.979379098}, /*cmz*/
          {6.169583534,4.608596645,1.459600345,1.389738682} /*cfz*/
     },
     {
          2459899.5,
          {-1.633876246,-0.1021033895,605.5401612,-0.2732641978,-0.01922046457,2.710145597}, /*cmx*/
          {1.14283023,5.82940494,2.706662848,5.827487679}, /*cfx*/
          {-0.2978701795,-0.05164656337,290.7457176,0.058400061,0.008404192815,1.301055845}, /*cmy*/
          {1.265269834,2.822645572,5.922317403,5.9465502}, /*cfy*/
          {9.156984852,-0.04518060502,670.2810532,-0.2686143602,-0.02093055003,2.989267651}, /*cmz*/
          {2.736536715,1.138445446,4.292751532,1.136572222} /*cfz*/
     },
     {
          2459929.5,
          {-4.794884562,-0.08501108937,605.7026331,0.8953485756,-0.01393991735,2.728037619}, /*cmx*/
          {3.941820466,2.390075208,5.427318054,5.519870878}, /*cfx*/
          {-1.895452671,-0.04494485136,290.3932311,-0.4525702075,0.005881115369,1.304346485}, /*cmy*/
          {4.059325977,5.601149612,2.205734905,5.636726236}, /*cfy*/
          {7.839054558,-0.09957815878,670.2402249,0.9915237319,-0.01546530087,3.008606661}, /*cmz*/
          {5.534385032,3.98848919,0.672484521,0.8281998222} /*cfz*/
     },
     {
          2459959.5,
          {-7.435898076,-0.03811809576,606.3054733,1.738436935,-0.009755887332,2.756428013}, /*cmx*/
          {0.4072175527,5.152322825,1.64359452,5.160862762}, /*cfx*/
          {-3.288192291,-0.02303071162,289.0488143,-0.8058790441,0.004602690927,1.30448201}, /*cmy*/
          {0.525166514,2.019762105,4.389623503,5.280644434}, /*cfy*/
          {4.850779839,-0.1422808735,670.2688684,1.930584691,-0.01035976808,3.045505703}, /*cmz*/
          {1.999951527,0.4377011622,3.153423543,0.4700343911} /*cfz*/
     },
     {
          2459989.5,
          {-8.650596153,0.02815001717,608.1027621,2.309122929,-0.005525905445,2.788681096}, /*cmx*/
          {3.121669341,1.593544565,3.871224339,4.781003837}, /*cfx*/
          {-4.015373455,0.008779993695,285.3418435,-1.032491479,0.004191918905,1.288057414}, /*cmy*/
          {3.244989991,4.645930685,0.08332180119,4.909031174}, /*cfy*/
          {0.483620997,-0.1522360148,670.2780556,2.535853014,-0.006455683735,3.072595428}, /*cmz*/
          {4.714627162,3.144239307,5.312426861,6.374548805} /*cfz*/
     },
     {
          2460019.5,
          {-7.818592738,0.09441783363,611.6959078,2.542705628,-0.004817379862,2.838822858}, /*cmx*/
          {5.816076071,4.303895984,-0.1763665799,4.384436056}, /*cfx*/
          {-3.75591932,0.03908631629,278.008663,-1.103671214,0.004385202486,1.256607062}, /*cmy*/
          {5.948642568,0.9395841075,2.406253055,4.522032822}, /*cfy*/
          {-4.225378309,-0.1206609065,670.1931049,2.776887119,-0.005928488446,3.097023805}, /*cmz*/
          {1.126131896,5.837716333,1.239790933,5.980485714} /*cfz*/
     },
     {
          2460049.5,
          {-4.94945767,0.1379100973,616.8603982,2.612838044,-0.005295991432,2.887418144}, /*cmx*/
          {2.220951779,0.7271825316,1.760575128,3.989568759}, /*cfx*/
          {-2.558790436,0.05574788035,266.4135497,-1.103171669,0.004821338468,1.204720212}, /*cmy*/
          {2.366066883,3.508131999,4.655544254,4.140702182}, /*cfy*/
          {-7.968087966,-0.05560746759,670.1050188,2.844396604,-0.006408168215,3.118031755}, /*cmz*/
          {3.814446443,2.239634053,3.214416179,5.583066059} /*cfz*/
     },
     {
          2460079.5,
          {-0.7550591257,0.1441180101,623.3352344,2.475252777,-0.006810908003,2.928294515}, /*cmx*/
          {4.912286489,3.428343419,3.95814712,3.597382385}, /*cfx*/
          {-0.8585689144,0.05424609136,251.3342481,-1.022476657,0.004571645897,1.130249966}, /*cmy*/
          {5.072607257,-0.2300780362,0.6056187021,3.765829915}, /*cfy*/
          {-9.707563596,0.02290287319,670.0943212,2.649793507,-0.007494952189,3.127491755}, /*cmz*/
          {0.2219282084,4.926656366,5.514728644,5.187098447} /*cfz*/
     },
     {
          2460109.5,
          {3.677355751,0.1126989693,630.0436234,2.164669378,-0.01051327169,2.960859214}, /*cmx*/
          {1.333326151,6.139587768,0.05469419885,3.228521615}, /*cfx*/
          {0.8034929821,0.03944784233,234.2824335,-0.8714971286,0.005000055797,1.056078813}, /*cmy*/
          {1.511298648,2.342622595,2.860663829,3.413859306}, /*cfy*/
          {-9.023529514,0.08854571391,669.9225302,2.306693371,-0.01149322541,3.133095133}, /*cmz*/
          {2.925397365,1.345900864,1.560550113,4.81621077} /*cfz*/
     },
     {
          2460139.5,
          {7.16801584,0.05799725067,635.9258815,1.552579531,-0.01356900304,2.96642927}, /*cmx*/
          {4.059132057,2.5861928,2.629838917,2.886593325}, /*cfx*/
          {2.017069752,0.02130042956,218.2664272,-0.6274691688,0.005784449342,0.9831832569}, /*cmy*/
          {4.255951157,4.90956835,5.081809114,3.092893306}, /*cfy*/
          {-6.314551091,0.123526128,669.9246159,1.640067372,-0.01424841977,3.126265325}, /*cmz*/
          {5.650357218,4.06064346,4.097879565,4.476061112} /*cfz*/
     },
     {
          2460169.5,
          {8.970147375,0.00305991223,639.6597236,0.7355410337,-0.01826216232,2.964751062}, /*cmx*/
          {0.5362722866,5.362603862,5.34739658,2.586525891}, /*cfx*/
          {2.665964701,0.007905193783,207.016545,-0.2867197693,0.007176251151,0.9478534422}, /*cmy*/
          {0.7496784777,1.241431505,1.413054154,2.805013921}, /*cfy*/
          {-2.529040508,0.1237800504,669.6303456,0.7581518009,-0.01899741353,3.107373441}, /*cmz*/
          {2.126751681,0.5666425066,0.5761828628,4.180299555} /*cfz*/
     },
     {
          2460199.5,
          {9.071411799,-0.03685520409,640.6218726,-0.4153607561,-0.01473386225,2.940580769}, /*cmx*/
          {3.340607776,1.842372699,1.921673103,2.333749647}, /*cfx*/
          {2.908527156,-0.0009665567009,204.4871364,0.1737926014,0.00586329301,0.9551872419}, /*cmy*/
          {3.562420201,4.472935408,4.243462114,2.55446668}, /*cfy*/
          {1.235023052,0.1023422256,669.6606455,-0.4331250247,-0.01607076272,3.078819499}, /*cmz*/
          {4.931537737,3.358797237,3.399239313,3.929864464} /*cfz*/
     },
     {
          2460229.5,
          {7.971484761,-0.06174000988,638.1857335,-1.352792169,-0.003899352544,2.892219667}, /*cmx*/
          {6.194049071,4.719559268,5.190388185,2.11650449}, /*cfx*/
          {2.90097872,-0.01041776263,211.7897185,0.5450118303,0.00135619602,0.9901184885}, /*cmy*/
          {0.1279387904,0.8504091348,1.73137429,2.331412078}, /*cfy*/
          {4.333621327,0.07698700637,669.5155857,-1.453568959,-0.004028910969,3.04046978}, /*cmz*/
          {1.502564381,6.200192332,6.863151692,3.718744974} /*cfz*/
     },
     {
          2460259.5,
          {6.135109805,-0.08364804137,634.0501247,-1.574661404,-0.01409693288,2.86579387}, /*cmx*/
          {2.791780534,1.340759462,4.447778611,1.924675013}, /*cfx*/
          {2.602234618,-0.02413178232,224.2972233,0.5981384854,0.005669583017,1.042769388}, /*cmy*/
          {2.994153889,3.798420739,6.990410721,2.119104712}, /*cfy*/
          {6.728599912,0.05585597764,669.7792295,-1.66329896,-0.01482865874,3.024716438}, /*cmz*/
          {4.384638052,2.82770933,5.936828602,3.520701193} /*cfz*/
     },
     {
          2460289.5,
          {3.652826879,-0.108589858,630.2479863,-0.701919313,-0.01874415183,2.845573564}, /*cmx*/
          {5.659861287,4.170801741,1.015804399,1.687307865}, /*cfx*/
          {1.891220611,-0.03901015249,233.4928358,0.2491315132,0.007816796791,1.061393449}, /*cmy*/
          {5.84674489,0.2297736961,3.566510777,1.867882961}, /*cfy*/
          {8.484914265,0.0262570113,669.7756812,-0.7352886244,-0.0202841379,3.007613312}, /*cmz*/
          {0.9696479518,5.674320795,2.537423426,3.279234488} /*cfz*/
     },
     {
          2460319.5,
          {0.3919412571,-0.1232591453,629.8428744,0.4602535924,-0.01664122605,2.838817488}, /*cmx*/
          {2.196767863,0.7030915831,3.828683175,1.396665571}, /*cfx*/
          {0.7138655589,-0.04608431765,234.8567541,-0.2472466763,0.006510744728,1.04206163}, /*cmy*/
          {2.374049409,3.486941833,-0.01623224513,1.569994396}, /*cfy*/
          {9.367987661,-0.02358052214,669.9362232,0.5162654492,-0.01762059849,2.996710315}, /*cmz*/
          {3.788854276,2.240148573,5.296987392,2.98398503} /*cfz*/
     },
     {
          2460349.5,
          {-3.401940453,-0.1099219211,632.2671182,1.484820511,-0.01087942398,2.847550413}, /*cmx*/
          {4.965312553,3.50701106,0.0481339796,1.066538654}, /*cfx*/
          {-0.7124176245,-0.03835080627,227.4910209,-0.6407187258,0.005123745891,0.9890839882}, /*cmy*/
          {5.141364053,-0.1968832072,2.187873621,1.242956374}, /*cfy*/
          {8.73609805,-0.08513547071,669.880809,1.602222833,-0.01138927518,2.999292292}, /*cmz*/
          {0.2728367137,5.001249695,1.537491737,2.649716834} /*cfz*/
     },
     {
          2460379.5,
          {-6.836982255,-0.06413254782,637.6462123,2.120055721,-0.007556895446,2.873549162}, /*cmx*/
          {1.411002607,-0.05978053091,2.500369418,0.7023939622}, /*cfx*/
          {-1.908451077,-0.01775420611,212.4296925,-0.8981777575,0.004435905962,0.9012019462}, /*cmy*/
          {1.594316497,2.372987687,4.340368324,0.8914972416}, /*cfy*/
          {6.183118667,-0.1367848032,670.0539344,2.258764963,-0.0080948603,3.012187049}, /*cmz*/
          {2.999828112,1.431563093,3.952084787,2.283870724} /*cfz*/
     },
     {
          2460409.5,
          {-8.886790334,0.005461745514,644.4231386,2.519296917,-0.005873626405,2.919296737}, /*cmx*/
          {4.117089287,2.650776911,4.499564497,0.32126972}, /*cfx*/
          {-2.4674921,0.006333978488,190.3256318,-1.037091716,0.005045413163,0.7938812512}, /*cmy*/
          {4.316705571,4.939414146,0.3120976497,0.531321355}, /*cfy*/
          {2.026728552,-0.1561439998,669.8938639,2.658399338,-0.00635742831,3.033186732}, /*cmz*/
          {5.703516564,4.141940431,-0.3527353488,1.907883137} /*cfz*/
     },
     {
          2460439.5,
          {-8.77802615,0.07866841958,652.0525276,2.642846058,-0.005562208092,2.965414317}, /*cmx*/
          {0.5289069198,5.331134972,0.3707449304,6.214636046}, /*cfx*/
          {-2.271218086,0.02275977468,162.8615729,-1.108781307,0.004939890903,0.6599906921}, /*cmy*/
          {0.7568630219,1.18687719,2.572607519,6.462037884}, /*cfy*/
          {-2.735918488,-0.1344383802,670.1664259,2.769280302,-0.005183491756,3.042256632}, /*cmz*/
          {2.112677651,0.5351456641,1.760085244,1.518832312} /*cfz*/
     },
     {
          2460469.5,
          {-6.405095658,0.1324080559,658.8553873,2.601288208,-0.007098572511,3.02147379}, /*cmx*/
          {3.223761076,1.731484604,2.493211239,5.833574172}, /*cfx*/
          {-1.563895811,0.02573684349,131.9350435,-1.09795745,0.004486035268,0.5228752214}, /*cmy*/
          {3.497656119,3.723563435,4.867961583,6.133925856}, /*cfy*/
          {-6.880600354,-0.07622780987,670.0430216,2.701136997,-0.007416939656,3.058493952}, /*cmz*/
          {4.80464121,3.236289934,3.973457351,1.13548307} /*cfz*/
     },
     {
          2460499.5,
          {-2.369957694,0.1495323736,664.4299539,2.304757655,-0.008130102788,3.068661616}, /*cmx*/
          {5.926189572,4.407582628,4.789091658,5.467223662}, /*cfx*/
          {-0.7786048976,0.01810679069,100.7859224,-1.019991935,0.004462774438,0.393373419}, /*cmy*/
          {-0.006517439451,-0.002034668245,0.6626260592,5.870465764}, /*cfy*/
          {-9.265227936,-0.00196839364,670.3212799,2.392758063,-0.008820890735,3.069334196}, /*cmz*/
          {1.221155853,5.920691052,-0.06559536877,0.7640956104} /*cfz*/
     },
     {
          2460529.5,
          {2.192477535,0.1279183699,667.746766,1.852144754,-0.01315673373,3.104824116}, /*cmx*/
          {2.363347426,0.8403137182,0.9926092981,5.123694471}, /*cfx*/
          {-0.2381967382,0.00922468103,73.39280526,-0.8292060058,0.005465439463,0.2861586989}, /*cmy*/
          {2.838333122,2.600719986,2.837180606,5.661770859}, /*cfy*/
          {-9.384037623,0.06322649413,670.1513449,1.907042388,-0.01358512469,3.100240085}, /*cmz*/
          {3.939102793,2.367410399,2.488316271,0.4114390642} /*cfz*/
     },
     {
          2460559.5,
          {6.074065152,0.08184030493,669.7981138,1.075897088,-0.01727998594,3.107745771}, /*cmx*/
          {5.111374866,3.539909395,3.520753284,4.809264244}, /*cfx*/
          {0.02127425721,0.006369015567,54.50754627,-0.5152134646,0.00753177722,0.2305389107}, /*cmy*/
          {5.758399494,5.266395723,5.298681789,5.525935146}, /*cfy*/
          {-7.491881988,0.1014439453,670.3523861,1.106185206,-0.01773503215,3.101055281}, /*cmz*/
          {0.4022351684,5.092889306,5.088134715,6.377499868} /*cfz*/
     },
     {
          2460589.5,
          {8.57197921,0.03142960315,669.9683519,0.04463452917,-0.01824121026,3.102099824}, /*cmx*/
          {1.616812181,1.25238625,0.1504487639,4.541015932}, /*cfx*/
          {0.2018176694,0.01006659528,47.13785129,-0.05006244275,0.007855383347,0.2274058945}, /*cmy*/
          {2.380139952,1.733835207,1.793051151,5.28148985}, /*cfy*/
          {-4.421870203,0.1097627765,670.1707845,0.02835447675,-0.01881529667,3.100096778}, /*cmz*/
          {3.190167316,2.088203519,1.651079436,6.108415308} /*cfz*/
     },
     {
          2460619.5,
          {9.566552252,-0.00742900132,669.9727011,-1.151935402,-0.008075615802,3.103334728}, /*cmx*/
          {4.453438147,28.05307281,3.07551559,4.31598292}, /*cfx*/
          {0.5099790775,0.01347623424,51.83569442,0.4508783232,0.004111788965,0.2768184669}, /*cmy*/
          {5.136582256,4.613118348,4.887012799,4.894380441}, /*cfy*/
          {-1.105078782,0.1012973027,670.3456713,-1.184919976,-0.007998296392,3.119852707}, /*cmz*/
          {6.027094084,23.31775287,4.587740181,5.888486686} /*cfz*/
     },
     {
          2460649.5,
          {9.381785101,-0.03942779781,668.3396592,-1.674322067,0.009032794449,3.074254707}, /*cmx*/
          {1.045577511,5.791867994,5.546979863,4.106231994}, /*cfx*/
          {0.9424848849,0.008847724021,67.39210899,0.7027968411,-0.003407213723,0.3554523424}, /*cmy*/
          {1.553813502,1.268444415,1.098926955,4.570802858}, /*cfy*/
          {1.895950699,0.09444069435,670.0640915,-1.701512821,0.008768610808,3.09812825}, /*cmz*/
          {2.620779888,1.03993152,0.8126242133,5.680782649} /*cfz*/
     },
     {
          2460679.5,
          {8.278096796,-0.07494686949,666.5967838,-1.111404864,0.01867108562,3.067470301}, /*cmx*/
          {3.922325363,2.438900494,2.443542801,3.875699941}, /*cfx*/
          {1.22766284,-0.002814070358,84.92895477,0.4831244267,-0.007621594579,0.4159035535}, /*cmy*/
          {4.313118524,4.156253391,4.261416502,4.23803593}, /*cfy*/
          {4.722901752,0.08544981811,670.4424055,-1.145262059,0.01944532417,3.096510712}, /*cmz*/
          {5.498661471,3.958101503,3.973989656,5.454067154} /*cfz*/
     },
     {
          2460709.5,
          {6.071403059,-0.1146586206,665.2675563,0.05657147176,0.01830075372,3.050644342}, /*cmx*/
          {0.4774029383,5.456620144,5.204093721,3.598613387}, /*cfx*/
          {1.141657218,-0.01400718189,92.38984068,-0.06237517054,-0.007809734126,0.4126828412}, /*cmy*/
          {0.8228112245,-3.840675339,0.7661249196,3.940764014}, /*cfy*/
          {7.345112428,0.05786424932,670.1423948,0.08115703187,0.01843791343,3.077975416}, /*cmz*/
          {2.054319219,0.9438829372,0.4110996035,5.176703951} /*cfz*/
     },
     {
          2460739.5,
          {2.623723667,-0.140992106,666.2134764,-1.156018059,0.01346764249,3.045579914}, /*cmx*/
          {3.263848415,-1.390497214,1.569207726,3.274677669}, /*cfx*/
          {0.7041208217,-0.01589154463,85.62816755,-0.4721129133,-0.006031258454,0.345445781}, /*cmy*/
          {3.619858301,-8.841910225,3.218758968,3.660409301}, /*cfy*/
          {9.182323393,0.003769460313,670.5104111,1.191755147,0.01346139983,3.059946595}, /*cmz*/
          {4.839944381,-3.018284455,3.148527716,4.85110701} /*cfz*/
     },
     {
          2460769.5,
          {-1.65282615,-0.135775109,668.1047803,-1.957889932,0.009116981358,3.053366476}, /*cmx*/
          {6.007790993,1.355384312,3.843558704,2.920598099}, /*cfx*/
          {0.204335993,-0.006968823277,66.60055918,-0.8141685606,-0.00490071529,0.2398315208}, /*cmy*/
          {0.1600490092,0.03227916278,5.468372339,3.438336175}, /*cfy*/
          {9.396828836,-0.06426624068,670.3087181,2.004205199,0.008759065508,3.050495949}, /*cmz*/
          {1.29923602,6.028963312,5.448359432,4.491467851} /*cfz*/
     },
     {
          2460799.5,
          {-5.807365297,-0.09254875046,670.3725461,-2.416499887,0.006196547078,3.028888249}, /*cmx*/
          {2.440497793,4.030242926,-0.181895818,2.543320195}, /*cfx*/
          {-0.005610946401,0.005621615326,40.5677433,-1.036971628,-0.004695282681,0.1208922494}, /*cmy*/
          {3.141945311,2.624858968,1.317076372,3.614059089}, /*cfy*/
          {7.492139566,-0.1239311128,670.6304259,2.47560016,0.005208016519,3.030038777}, /*cmz*/
          {4.013281667,2.438709096,1.389748797,4.114703907} /*cfz*/
     },
     {
          2460829.5,
          {-8.67565196,-0.02079421386,670.9108886,-2.629825586,0.006903002848,3.017136903}, /*cmx*/
          {5.141876169,0.4341296122,1.889710756,2.163781964}, /*cfx*/
          {0.1802107555,0.01165802305,24.29960845,-1.149202906,-0.004468916667,-0.1406499179}, /*cmy*/
          {6.880287208,5.193436228,3.520484338,-3.60969155}, /*cfy*/
          {3.728275371,-0.154684078,670.5587129,2.658824593,0.005358183329,3.018880398}, /*cmz*/
          {0.4291524129,5.143847472,3.495823584,3.734312725} /*cfz*/
     },
     {
          2460859.5,
          {-9.354586493,0.05690878365,669.9588081,-2.612359168,0.006079261378,3.004957882}, /*cmx*/
          {1.555292148,3.084739148,3.992068983,1.787059081}, /*cfx*/
          {0.5622501152,0.00568853651,46.36027102,-1.155339305,-0.004388837702,-0.2832882985}, /*cmy*/
          {4.213168233,1.485136304,-0.5110553705,1.471793296}, /*cfy*/
          {-0.9958888924,-0.1447369276,670.7445904,2.642445718,0.005481853611,3.015576928}, /*cmz*/
          {3.124080203,1.547364399,-0.7116529655,3.356657988} /*cfz*/
     },
     {
          2460889.5,
          {-7.662588586,0.1149037397,666.5899294,-2.416106361,0.008642810124,3.002654193}, /*cmx*/
          {4.256605973,5.775384296,0.03813045217,1.416229601}, /*cfx*/
          {0.7631397865,-0.008927230481,78.58770048,-1.075617469,-0.004389647052,-0.4266577341}, /*cmy*/
          {0.8714641971,4.063741228,1.589853216,1.242136267}, /*cfy*/
          {-5.412603412,-0.09886992473,670.698202,2.445888963,0.008233998053,3.026504979}, /*cmz*/
          {5.824094258,4.255330434,1.59522323,2.987491153} /*cfz*/
     },
     {
          2460919.5,
          {-4.179793916,0.1387206035,662.6473409,-2.016211305,0.01228147196,2.984295702}, /*cmx*/
          {0.6882075657,2.168347175,2.298363965,1.072668046}, /*cfx*/
          {0.4973470604,-0.02252237578,107.8263794,-0.8851751199,-0.005087087168,-0.5402994671}, /*cmy*/
          {3.676687215,0.3957369293,3.764780157,0.9507570588}, /*cfy*/
          {-8.408837468,-0.03337089227,671.0110878,2.026207315,0.01186397971,3.02408988}, /*cmz*/
          {2.254878957,0.666068321,3.900151147,2.637344641} /*cfz*/
     },
     {
          2460949.5,
          {0.0442337166,0.1274447831,658.5506641,-1.303166133,0.0159041915,2.977937373}, /*cmx*/
          {3.426914113,4.900807293,4.935495018,0.756627832}, /*cfx*/
          {-0.1933473601,-0.02619838963,129.5664926,-0.593275697,-0.006987758897,-0.6191871969}, /*cmy*/
          {0.1758087096,3.085195324,-0.09711184136,0.66303839}, /*cfy*/
          {-9.422295919,0.02879408622,670.7720691,1.329634674,0.01644657292,3.039353732}, /*cmz*/
          {4.993753851,3.432911443,0.3378324508,2.319054983} /*cfz*/
     },
     {
          2460979.5,
          {3.90401297,0.09480243448,656.2514595,-0.3225460159,0.01850491437,2.985936833}, /*cmx*/
          {6.202994367,1.338595503,1.382316238,0.482079259}, /*cfx*/
          {-1.003935406,-0.01812775368,140.8598183,-0.1699376598,-0.007929481204,-0.6420469077}, /*cmy*/
          {2.972335845,6.061828623,2.627535798,0.3959143105}, /*cfy*/
          {-8.54769822,0.06937463948,671.0916967,0.3218797731,0.01885778332,3.058814572}, /*cmz*/
          {1.486764401,6.124978787,3.019747179,2.044309381} /*cfz*/
     },
     {
          2461009.5,
          {6.734427482,0.05962030089,656.3625662,0.8531822058,0.01210014217,2.999290933}, /*cmx*/
          {2.743621739,4.200325214,4.404704405,6.534394821}, /*cfx*/
          {-1.555348377,-0.004755951755,139.2881114,0.3466543315,-0.005808057457,-0.6019002675}, /*cmy*/
          {5.800735502,2.133050397,5.724429831,6.438068556}, /*cfy*/
          {-6.465264303,0.0865795445,670.7042957,-0.8825643594,0.01218563367,3.074607775}, /*cmz*/
          {4.310772824,2.690852855,6.08855101,1.815284483} /*cfz*/
     },
     {
          2461039.5,
          {8.519618555,0.02894373574,659.4561392,1.612488801,-0.003477070089,3.039964067}, /*cmx*/
          {5.611756189,0.8353674199,0.4660413427,6.325596039}, /*cfx*/
          {-1.682849933,0.005692149754,125.4130463,0.7031534169,-0.001917838205,-0.5323557562}, /*cmy*/
          {2.375869568,5.198041312,4.342805349,6.220930876}, /*cfy*/
          {-3.896136036,0.09543878638,671.0978984,-1.636166859,-0.003311232457,3.102186924}, /*cmz*/
          {0.8962307758,5.627847702,2.222281818,1.608804931} /*cfz*/
     },
     {
          2461069.5,
          {9.386740925,-0.004538513025,662.5793203,1.383297015,0.01711775352,3.050145635}, /*cmx*/
          {2.210125625,3.705568819,0.5222222269,6.107823739}, /*cfx*/
          {-1.500138605,0.008366661959,106.3128707,0.6214277317,0.0069860614,-0.4541087497}, /*cmy*/
          {5.23568318,1.899619014,-1.302366452,5.970643575}, /*cfy*/
          {-1.017295544,0.1079370795,670.8854035,-1.427768311,-0.0180539846,3.099266736}, /*cmz*/
          {3.777782235,2.211660977,5.32546378,1.398953978} /*cfz*/
     },
     {
          2461099.5,
          {9.299167048,-0.05168429895,664.653895,0.3253685747,0.01890623077,3.077940329}, /*cmx*/
          {5.06287843,0.3273374859,3.458903497,5.843537146}, /*cfx*/
          {-1.245707872,0.00825375314,94.17416939,0.1873459371,0.00821009807,-0.4352454944}, /*cmy*/
          {1.78758883,4.791108413,1.640134122,5.711335598}, /*cfy*/
          {2.239899113,0.1127039245,670.976605,-0.3203392262,-0.01884218881,3.116045405}, /*cmz*/
          {0.3479865571,5.095102407,1.937685328,1.134951507} /*cfz*/
     },
     {
          2461129.5,
          {7.800387492,-0.1032999793,664.09815,-0.8317716802,0.01457888315,3.089832841}, /*cmx*/
          {1.582484491,3.141760581,6.064247521,5.527128518}, /*cfx*/
          {-1.016437594,0.01236197996,95.82239192,-0.3173955118,0.006219043781,-0.4795376334}, /*cmy*/
          {4.597542227,1.338906285,4.233449693,5.426326841}, /*cfy*/
          {5.665254319,0.09122730825,670.7879408,0.8287364754,-0.01505814245,3.1258324}, /*cmz*/
          {3.150551248,1.619438945,4.574990301,0.8177416834} /*cfz*/
     },
     {
          2461159.5,
          {4.677230234,-0.1408767418,662.0404207,-1.723969439,0.008607784677,3.069954891}, /*cmx*/
          {4.339426531,5.841790217,2.314147638,5.177446296}, /*cfx*/
          {-0.6663937241,0.0228031293,110.5344848,-0.6898182653,0.004589022127,-0.5689751804}, /*cmy*/
          {1.099654551,4.018890052,0.2741983789,5.099179364}, /*cfy*/
          {8.467213662,0.03859913097,670.935664,1.731216469,-0.009132798597,3.100839504}, /*cmz*/
          {5.90741274,4.343017846,0.8408724697,0.4644813835} /*cfz*/
     },
     {
          2461189.5,
          {0.3665675856,-0.1451391433,657.5753692,-2.21889455,0.006885372387,3.033776285}, /*cmx*/
          {0.7804322961,2.277585202,4.574535928,4.805925916}, /*cfx*/
          {0.01390655644,0.03412649172,133.6263209,-0.9320828514,0.004041191994,-0.6846024915}, /*cmy*/
          {3.855958648,0.3757339714,2.301295318,4.764554042}, /*cfy*/
          {9.683998954,-0.03413503482,670.9066443,2.264683764,-0.006790831166,3.095369761}, /*cmz*/
          {2.34878662,0.7880012074,3.091230722,6.370674815} /*cfz*/
     },
     {
          2461219.5,
          {-4.100113343,-0.1109343286,651.5833244,-2.506167189,0.004964537329,2.978921087}, /*cmx*/
          {3.486432245,4.963903389,0.2615821013,4.422979492}, /*cfx*/
          {1.06154009,0.03682457848,160.5402303,-1.042196025,0.00389716875,-0.8024018619}, /*cmy*/
          {0.3059203403,2.964255434,4.497388504,4.400231868}, /*cfy*/
          {8.679923517,-0.1035294686,671.0931164,2.543027554,-0.004626210491,3.081385169}, /*cmz*/
          {5.054913678,3.479961309,5.199362285,5.98567275} /*cfz*/
     },
     {
          2461249.5,
          {-7.512876279,-0.04765971139,644.3976749,-2.529536808,0.005463304529,2.925972082}, /*cmx*/
          {-0.09907462435,1.371768709,2.444783454,4.033777337}, /*cfx*/
          {2.197536121,0.02517209102,187.2280043,-1.063344649,0.004097925867,-0.9148652845}, /*cmy*/
          {3.025658104,5.54871576,0.4133234869,4.02987726}, /*cfy*/
          {5.557405169,-0.1460762776,670.928139,2.608657031,-0.005806407444,3.072400583}, /*cmz*/
          {1.470567669,-0.09646719927,0.9622899077,5.599562967} /*cfz*/
     },
     {
          2461279.5,
          {-8.967515629,0.02378920845,637.0584087,-2.396481484,0.007428997969,2.865859083}, /*cmx*/
          {2.600333722,4.062085428,4.504543045,3.658705315}, /*cfx*/
          {2.977042271,0.001915735945,211.04433,-0.9915933855,0.003807468208,-1.00028474}, /*cmy*/
          {5.742942164,1.842905825,2.567199821,3.670723629}, /*cfy*/
          {1.088294358,-0.1502067986,671.1289139,2.490493999,-0.007731686549,3.054461373}, /*cmz*/
          {4.171423039,2.589573251,3.002660713,5.23229469} /*cfz*/
     },
     {
          2461309.5,
          {-8.226939124,0.08226912515,630.372787,-2.014840191,0.009996866,2.825773396}, /*cmx*/
          {5.310266163,0.4937085753,0.6973795903,3.302286717}, /*cfx*/
          {3.038281564,-0.02380977829,230.0640529,-0.8372709353,0.004668321605,-1.070555724}, /*cmy*/
          {2.184884275,4.465667791,4.781213626,3.326873715}, /*cfy*/
          {-3.523678515,-0.1170264161,671.0474311,2.084527506,-0.01020361849,3.030828157}, /*cmz*/
          {0.5996002309,5.305408545,5.514246762,4.881409708} /*cfz*/
     },
     {
          2461339.5,
          {-5.697852554,0.1123800501,625.4516574,-1.428720674,0.01482037503,2.802665189}, /*cmx*/
          {1.759040707,3.217062748,3.239490577,2.980218879}, /*cfx*/
          {2.303826087,-0.04099747268,243.49204,-0.5746730147,0.006219391991,-1.112396209}, /*cmy*/
          {4.929500821,0.8435155104,0.8002151413,3.01577331}, /*cfy*/
          {-7.098796957,-0.06295954507,671.0432003,1.494328415,-0.01593127966,3.01370854}, /*cmz*/
          {3.333673137,1.749393932,1.77047711,4.561986819} /*cfz*/
     },
     {
          2461369.5,
          {-2.287001657,0.1120114175,622.3972772,-0.526015066,0.01739090499,2.793250921}, /*cmx*/
          {4.525435182,6.020725151,6.035633011,2.695998766}, /*cfx*/
          {1.055282142,-0.04432796351,250.6232956,-0.1999871688,0.007549459148,-1.129111556}, /*cmy*/
          {1.422736244,3.788677985,3.541474561,2.738940454}, /*cfy*/
          {-9.001235686,-0.008657402464,670.983275,0.52279115,-0.01799629829,3.004753046}, /*cmz*/
          {6.101544912,4.530418038,4.533711811,4.277029487} /*cfz*/
     },
     {
          2461399.5,
          {1.116218564,0.09386493713,622.2649989,0.5440627888,0.01467983407,2.797738173}, /*cmx*/
          {1.055689653,2.555247045,2.586527768,2.462430822}, /*cfx*/
          {-0.2979203756,-0.03685304567,251.4315278,0.2774917656,0.00598261931,-1.117306465}, /*cmy*/
          {4.24263192,-0.1292335755,0.2053196929,2.50800392}, /*cfy*/
          {-9.24577055,0.03011329779,670.9313584,-0.6019420023,-0.01527825448,3.001684689}, /*cmz*/
          {2.632785593,1.045019352,1.134200238,4.040224817} /*cfz*/
     },
     {
          2461429.5,
          {3.982072854,0.0753155679,624.5277603,1.496944295,-0.001721295923,2.82077931}, /*cmx*/
          {3.915285631,5.401387654,4.32887377,2.272435797}, /*cfx*/
          {-1.432360974,-0.02687690369,245.6171845,0.6599140468,0.002309663101,-1.079387763}, /*cmy*/
          {0.8210381262,2.888528923,-1.503236165,2.31471834}, /*cfy*/
          {-8.302897472,0.05686121644,670.925168,-1.568895727,-0.002003787133,3.000433945}, /*cmz*/
          {5.492699579,3.919891193,18.42480639,3.844858} /*cfz*/
     },
     {
          2461459.5,
          {6.271395213,0.05770419078,628.563997,1.457996451,-0.01311923678,2.853764151}, /*cmx*/
          {0.5158068905,2.00807273,8.274729701,2.061044047}, /*cfx*/
          {-2.240810015,-0.01912407344,235.4362679,0.6309784833,-0.005982530443,-1.045042858}, /*cmy*/
          {3.70215662,5.93014007,-0.4916157041,2.103630388}, /*cfy*/
          {-6.6177493,0.08481702686,670.9851038,-1.534416785,-0.01421552086,3.032405711}, /*cmz*/
          {2.0920413,0.5295951784,9.907753188,3.635855651} /*cfz*/
     },
     {
          2461489.5,
          {8.060856862,0.02876090199,631.6033603,0.6385487519,-0.01872510752,2.881228604}, /*cmx*/
          {3.379301802,4.843270771,4.854292978,1.817167843}, /*cfx*/
          {-2.827986108,-0.0112405861,226.7867114,0.265143177,-0.007810920689,-1.027828615}, /*cmy*/
          {0.2775978065,2.623077906,2.494634153,1.854657803}, /*cfy*/
          {-4.076776054,0.1142055107,670.9286523,-0.6369477336,-0.01896823169,3.056538065}, /*cmz*/
          {4.954892978,3.379335008,0.2385034148,3.390343735} /*cfz*/
     },
     {
          2461519.5,
          {8.984119562,-0.01929292725,632.022602,-0.5134480844,-0.01417584084,2.893943542}, /*cmx*/
          {6.196929308,1.438582058,1.312524014,1.522763045}, /*cfx*/
          {-3.187293627,0.001789705516,225.4186064,-0.2203272489,-0.006009753461,-1.046778357}, /*cmy*/
          {3.091912986,5.2021811,5.254440926,1.560030744}, /*cfy*/
          {-0.5893764916,0.1312043461,671.0043286,0.5445172276,-0.01480702766,3.084882708}, /*cmz*/
          {1.488685494,6.206481358,3.004129639,3.097061897} /*cfz*/
     },
     {
          2461549.5,
          {8.437926291,-0.07810872946,629.7112834,-1.373321586,-0.01069502716,2.902345944}, /*cmx*/
          {2.682699396,4.173999525,3.92550997,1.181866393}, /*cfx*/
          {-3.152345208,0.0224866489,231.9714025,-0.5877420147,-0.004645709911,-1.100775998}, /*cmy*/
          {5.861370066,1.769768688,1.294811702,1.223192631}, /*cfy*/
          {3.455652599,0.1192170716,670.9265787,1.440753617,-0.01129370051,3.107473855}, /*cmz*/
          {4.257824118,2.698813597,5.574930553,2.760311105} /*cfz*/
     },
     {
          2461579.5,
          {6.088981983,-0.125774237,625.2938645,-1.986081454,-0.006349024062,2.894181117}, /*cmx*/
          {5.416283021,0.6270425436,-0.03291503943,0.8159356495}, /*cfx*/
          {-2.492121682,0.04506419071,243.4726408,-0.8457578254,-0.003590547168,-1.162103425}, /*cmy*/
          {2.316043525,4.438456932,3.42493945,0.8625569702}, /*cfy*/
          {7.156919117,0.07263965357,670.9488502,2.104760976,-0.006554950954,3.120247933}, /*cmz*/
          {0.7094306406,5.425095032,1.629524549,2.393994688} /*cfz*/
     },
     {
          2461609.5,
          {2.277268045,-0.1438910033,620.1800205,-2.307207081,-0.004174520323,2.880268063}, /*cmx*/
          {1.843954226,3.338626336,2.098958443,0.4275376223}, /*cfx*/
          {-1.132812904,0.05976910318,256.4606704,-0.984055178,-0.003506614298,-1.226732128}, /*cmy*/
          {5.034011264,0.7770363312,5.579490577,0.4815392411}, /*cfy*/
          {9.426046871,0.001148033865,670.9644041,2.432382696,-0.005290784347,3.126526077}, /*cmz*/
          {3.421648278,1.852319984,3.820541952,2.005166173} /*cfz*/
     },
     {
          2461639.5,
          {-2.149918382,-0.1240950666,615.2650285,-2.42787928,-0.004503572125,2.859662646}, /*cmx*/
          {4.5439117,6.049963536,3.903720252,6.323446338}, /*cfx*/
          {0.7079765628,0.05801308108,268.2291938,-1.03674259,-0.003460053308,-1.273722767}, /*cmy*/
          {1.459658007,3.374348955,1.40746009,6.386947209}, /*cfy*/
          {9.50203834,-0.073381509,670.8698969,2.588890912,-0.00523242232,3.125140587}, /*cmz*/
          {6.123802067,4.551425481,-0.6492060991,1.618655661} /*cfz*/
     },
     {
          2461669.5,
          {-6.002476689,-0.07377953803,611.4281622,-2.296613778,-0.005455651513,2.828898709}, /*cmx*/
          {0.9588750463,2.477584521,-0.1093314039,5.940428103}, /*cfx*/
          {2.511089215,0.03936077091,277.1605009,-0.9775720249,-0.003557629331,-1.29970957}, /*cmy*/
          {4.167765635,5.982139931,3.694593351,6.013775133}, /*cfy*/
          {7.268147065,-0.1281932002,670.8982041,2.463550041,-0.005913723477,3.118740032}, /*cmz*/
          {2.541219597,0.9622733308,1.611722489,1.238722923} /*cfz*/
     },
     {
          2461699.5,
          {-8.301134872,-0.01022849777,608.9187228,-2.037803027,-0.009594216129,2.810527337}, /*cmx*/
          {3.666668308,5.204007218,2.248704796,5.574603393}, /*cfx*/
          {3.736383808,0.01108190532,282.6981325,-0.8568128642,-0.004675357488,-1.313234766}, /*cmy*/
          {0.6028803564,2.315733788,-0.4950546019,5.658665769}, /*cfy*/
          {3.342208908,-0.1468587143,670.7117349,2.182641506,-0.01020998982,3.103218973}, /*cmz*/
          {5.251128223,3.67527833,3.924156635,0.8784419339} /*cfz*/
     },
     {
          2461729.5,
          {-8.631156027,0.04645656384,607.917871,-1.479538202,-0.01290849455,2.785226665}, /*cmx*/
          {0.1103288006,1.655954915,4.832291877,5.232047129}, /*cfx*/
          {4.082889371,-0.0159865913,285.2993166,-0.5969947355,-0.005814951324,-1.308183324}, /*cmy*/
          {3.340162216,4.966841823,1.893927521,5.325700843}, /*cfy*/
          {-1.133516556,-0.128634723,670.70035,1.603790814,-0.01458456815,3.070900826}, /*cmz*/
          {1.697130588,0.1103887766,0.147441221,0.5413231941} /*cfz*/
     },
     {
          2461759.5,
          {-7.206299324,0.08062939244,607.553278,-0.7105586806,-0.01746171598,2.76503348}, /*cmx*/
          {2.870367674,4.441767956,1.300346949,4.937640297}, /*cfx*/
          {3.59183456,-0.03345102665,285.9340219,-0.250597737,-0.007651612479,-1.300520062}, /*cmy*/
          {6.109729855,1.425054152,4.548574062,5.039011484}, /*cfy*/
          {-5.074630311,-0.08653628763,670.5136526,0.7441450285,-0.0188023505,3.042728572}, /*cmz*/
          {4.45877972,2.888263137,2.893891743,6.531697432} /*cfz*/
     },
     {
          2461789.5,
          {-4.736082497,0.09105392243,607.6503264,0.3840258792,-0.01353911504,2.747219641}, /*cmx*/
          {5.674004757,0.9758145333,4.122361016,4.698123561}, /*cfx*/
          {2.568876331,-0.04055848928,286.094426,0.2299925345,-0.005512774406,-1.293300258}, /*cmy*/
          {2.637176921,4.184939083,1.159151804,4.804159867}, /*cfy*/
          {-7.741525705,-0.04202670645,670.5136394,-0.4422983498,-0.01474368537,3.017514177}, /*cmz*/
          {0.9804989541,5.690348868,5.735267605,6.289312451} /*cfz*/
     },
     {
          2461819.5,
          {-2.007820768,0.09009473505,607.4838648,1.267504829,-0.004189883617,2.727092059}, /*cmx*/
          {2.243207725,3.787502367,1.199969782,4.489204689}, /*cfx*/
          {1.35645737,-0.04240667799,285.933834,0.5923125107,-0.001910522441,-1.281696407}, /*cmy*/
          {5.492113767,0.7823799883,5.118521575,4.594384121}, /*cfy*/
          {-9.04895237,-0.005898770318,670.4382415,-1.396865903,-0.003944807312,2.986706963}, /*cmz*/
          {3.833376616,2.257322589,2.750672715,6.075407664} /*cfz*/
     },
     {
          2461849.5,
          {0.7050276389,0.08922380031,608.2024547,1.486242833,-0.01076183123,2.720838068}, /*cmx*/
          {5.123963187,0.4105662469,12.94816155,4.294519275}, /*cfx*/
          {0.08188024413,-0.04323003728,285.0290521,0.6463269906,-0.005364824349,-1.269588703}, /*cmy*/
          {2.086820333,3.777622905,9.947382797,4.395463422}, /*cfy*/
          {-9.2977931,0.02582046489,670.6236826,-1.626560723,-0.01242106721,2.99201499}, /*cmz*/
          {0.4301473377,5.156921129,8.248254572,5.877690054} /*cfz*/
     },
     {
          2461879.5,
          {3.424784506,0.08436781437,608.8280049,0.7942896706,-0.01608773427,2.721149576}, /*cmx*/
          {1.711720687,3.240196086,3.231102697,4.063981505}, /*cfx*/
          {-1.233754589,-0.04204231076,283.0617407,0.3056470589,-0.007141608975,-1.263301305}, /*cmy*/
          {4.951443985,0.4211851704,0.3576118445,4.15846244}, /*cfy*/
          {-8.58148073,0.0650448863,670.5300951,-0.8392364457,-0.01740677685,2.989754499}, /*cmz*/
          {3.299965384,1.728418557,4.871564432,5.643980755} /*cfz*/
     },
     {
          2461909.5,
          {6.06246334,0.06137414168,609.3207763,-0.1985179039,-0.01537011502,2.725925127}, /*cmx*/
          {4.540372267,6.06374772,6.076753875,3.788760793}, /*cfx*/
          {-2.541132201,-0.03320885665,282.2347434,-0.1356559996,-0.006673084095,-1.266202744}, /*cmy*/
          {1.490891288,3.093070914,3.172440463,3.879186618}, /*cfy*/
          {-6.662087815,0.1083625969,670.6713797,0.2244499532,-0.01708464471,3.01117941}, /*cmz*/
          {6.127363702,4.558113304,1.389591186,5.369009796} /*cfz*/
     },
     {
          2461939.5,
          {8.016496946,0.01517532448,608.7284453,-1.131626174,-0.01054070624,2.740256399}, /*cmx*/
          {1.038590439,2.603183771,2.394981329,3.466693666}, /*cfx*/
          {-3.591294696,-0.01323920214,283.1051126,-0.5397549438,-0.004555178039,-1.278414371}, /*cmy*/
          {4.269320266,5.967671691,5.588760014,3.556999791}, /*cfy*/
          {-3.402818539,0.1398122142,670.4401287,1.246455879,-0.01155294834,3.038041654}, /*cmz*/
          {2.625193313,1.084311286,3.933419007,5.054369628} /*cfz*/
     },
     {
          2461969.5,
          {8.544043128,-0.04593712211,608.0797362,-1.762761213,-0.006884767499,2.755261591}, /*cmx*/
          {3.781076338,5.340224799,4.93319801,3.107423266}, /*cfx*/
          {-4.024783389,0.01547869394,284.8471362,-0.8054977685,-0.003469308007,-1.292975238}, /*cmy*/
          {0.7293984181,2.36852408,1.527772842,3.199685517}, /*cfy*/
          {0.8358150896,0.1416740475,670.6771509,1.931260926,-0.00761597196,3.056467988}, /*cmz*/
          {5.368013728,3.795412494,0.2085412293,4.698607431} /*cfz*/
     },
     {
          2461999.5,
          {7.197974302,-0.1038803057,607.6936843,-2.167270852,-0.004225247435,2.785317596}, /*cmx*/
          {0.2152169401,1.793066093,0.7823772739,2.733843623}, /*cfx*/
          {-3.579080854,0.04425567153,285.4831392,-0.9683366108,-0.003386852826,-1.303622618}, /*cmy*/
          {3.450815684,5.016158305,3.554920902,2.831485232}, /*cfy*/
          {5.196449153,0.1049950355,670.4914139,2.374933958,-0.005547330882,3.075750603}, /*cmz*/
          {1.802956734,0.2400505462,2.220869942,4.328423427} /*cfz*/
     },
     {
          2462029.5,
          {4.05541072,-0.1382852723,608.6811843,-2.307672179,-0.003323771972,2.824582405}, /*cmx*/
          {2.918172461,4.507126855,2.957434735,2.352428022}, /*cfx*/
          {-2.239770919,0.0616312239,283.8429505,-1.010378405,-0.003345700636,-1.302741302}, /*cmy*/
          {6.160570805,1.335661478,-0.4309897467,2.456767064}, /*cfy*/
          {8.478571858,0.03799854414,670.6528463,2.531603588,-0.004265114246,3.092828351}, /*cmz*/
          {4.506923396,2.928689515,4.362133993,3.946429874} /*cfz*/
     },
     {
          2462059.5,
          {-0.1604511059,-0.1373393556,610.7567952,-2.31395503,-0.005545005979,2.864006993}, /*cmx*/
          {5.618316501,0.953224356,4.799014118,1.97544154}, /*cfx*/
          {-0.3592455526,0.06121294009,279.0641164,-0.9867952187,-0.004043691217,-1.287500164}, /*cmy*/
          {2.586451728,3.945734868,1.736267567,2.088530323}, /*cfy*/
          {9.719499703,-0.0383463412,670.4129366,2.522137911,-0.006528571441,3.120338236}, /*cmz*/
          {0.9248593183,5.637042215,0.07041521004,3.562542584} /*cfz*/
     },
     {
          2462089.5,
          {-4.352035267,-0.1019856626,614.392361,-2.078381113,-0.008088733497,2.881692281}, /*cmx*/
          {2.041598005,3.658649179,0.6942840109,1.604288892}, /*cfx*/
          {1.504583298,0.04505110972,271.863215,-0.8662532006,-0.004352028122,-1.250033834}, /*cmy*/
          {5.303437748,0.2388362911,3.81659789,1.730146388}, /*cfy*/
          {8.598130844,-0.1005008951,670.508346,2.252949541,-0.009229845407,3.124338444}, /*cmz*/
          {3.632041246,2.047386185,2.295811791,3.189618777} /*cfz*/
     },
     {
          2462119.5,
          {-7.494331178,-0.04591872566,617.9408746,-1.622693881,-0.0130010856,2.895448343}, /*cmx*/
          {4.766044761,0.1328842009,3.363020952,1.259282061}, /*cfx*/
          {2.882844538,0.02210351253,263.3279847,-0.6453436086,-0.00567488393,-1.21281346}, /*cmy*/
          {1.756127626,2.876685811,-0.03701904979,1.394508683}, /*cfy*/
          {5.540283873,-0.1311274138,670.2746983,1.742044677,-0.01417131453,3.13259227}, /*cmz*/
          {0.0737676485,4.777052681,4.85137371,2.844772615} /*cfz*/
     },
     {
          2462149.5,
          {-8.920530399,0.00953899758,621.1919089,-0.83811104,-0.01604199304,2.890261412}, /*cmx*/
          {1.23677442,2.867560561,5.986355419,0.9508619102}, /*cfx*/
          {3.561474309,0.00182569292,256.474071,-0.3179724677,-0.006828332783,-1.183701346}, /*cmy*/
          {4.520951414,5.452561478,2.417426228,1.098663425}, /*cfy*/
          {1.547847414,-0.1272201746,670.296736,0.8744940145,-0.01683759789,3.12877715}, /*cmz*/
          {2.828054555,1.224847543,1.215488601,2.539160048} /*cfz*/
     },
     {
          2462179.5,
          {-8.658935771,0.04787177115,622.0408022,0.1646864688,-0.01542579966,2.872601336}, /*cmx*/
          {4.033106714,5.480463176,2.617160036,0.6855047175}, /*cfx*/
          {3.628514442,-0.01180983722,253.8060518,0.1131953886,-0.005963010775,-1.178319256}, /*cmy*/
          {1.041953427,2.328762997,5.329572462,0.8395087836}, /*cfy*/
          {-2.291349234,-0.1016130674,669.8727782,-0.1909563804,-0.01672744086,3.111363849}, /*cmz*/
          {5.625193892,3.860646835,4.145406156,2.279464046} /*cfz*/
     },
     {
          2462209.5,
          {-7.251667292,0.06898318218,621.003239,-1.139748724,-0.005683000533,2.850119738}, /*cmx*/
          {0.5930052687,-0.8906875623,5.530134372,0.4619191334}, /*cfx*/
          {3.291118094,-0.02203951818,257.118616,0.4920277408,-0.002043895046,-1.198832027}, /*cmy*/
          {3.886813953,5.037980084,2.168095765,0.6120997716}, /*cfy*/
          {-5.339749406,-0.07178624852,670.2021742,-1.244512487,-0.005917258716,3.089066875}, /*cmz*/
          {2.185792756,0.6304587469,0.7578096763,2.058577295} /*cfz*/
     },
     {
          2462239.5,
          {-5.212836227,0.08597122061,618.0327201,-1.493944401,0.008229267914,2.789300843}, /*cmx*/
          {3.469226002,1.972516084,1.845751999,6.5375214}, /*cfx*/
          {2.651252284,-0.03366975397,263.7477032,0.6141697372,0.003994859749,-1.207538732}, /*cmy*/
          {0.4746710372,1.648549006,4.661541148,6.682147152}, /*cfy*/
          {-7.493874955,-0.04487453836,669.8983333,-1.603619731,0.008891272089,3.045706122}, /*cmz*/
          {5.06254897,3.47539375,3.252942712,1.849904238} /*cfz*/
     },
     {
          2462269.5,
          {-2.672642124,0.1029639201,615.6209777,-0.9927300426,0.01622496052,2.78141691}, /*cmx*/
          {6.343024721,4.86146499,4.865650569,6.312738653}, /*cfx*/
          {1.659706497,-0.04514719946,269.4804088,0.3686047578,0.006948055696,-1.225030126}, /*cmy*/
          {3.339412032,4.563847314,1.486808048,6.44622036}, /*cfy*/
          {-8.924146498,-0.01232493655,670.3837817,-1.053129424,0.01749082509,3.029351177}, /*cmz*/
          {1.652680707,0.1147261504,6.42017355,1.624636174} /*cfz*/
     },
     {
          2462299.5,
          {0.4135499397,0.1115368169,614.2952977,-0.02419748116,0.01539303559,2.770418785}, /*cmx*/
          {2.898142542,18.68495124,1.321235296,6.044717275}, /*cfx*/
          {0.3051388188,-0.0509372655,271.4362683,-0.06759259286,0.006557934484,-1.221254917}, /*cmy*/
          {6.169303048,1.714846808,4.188763486,6.170828458}, /*cfy*/
          {-9.389198685,0.0331520839,670.1204605,0.03897045395,0.01679994014,3.011565254}, /*cmz*/
          {4.48997721,3.820131051,2.854555669,1.351998094} /*cfz*/
     },
     {
          2462329.5,
          {3.79512941,0.09769253473,615.2418365,-0.9386614713,0.01179495348,2.752571734}, /*cmx*/
          {5.689203466,-24.10143513,4.092603556,5.731085067}, /*cfx*/
          {-1.241948574,-0.04473193821,269.7603938,0.4551908563,0.004743601767,-1.191920549}, /*cmy*/
          {2.672483015,0.8300266481,0.4772884155,5.854350835}, /*cfy*/
          {-8.447335397,0.08777510265,670.4344924,-1.056947401,0.01218763938,2.991762899}, /*cmz*/
          {0.9969900355,-16.28683892,5.600835252,1.038074221} /*cfz*/
     },
     {
          2462359.5,
          {6.808144928,0.05460442116,617.4740931,-1.664243489,0.008019294216,2.761969474}, /*cmx*/
          {2.157067497,3.813776337,0.2115304365,5.390838933}, /*cfx*/
          {-2.621558013,-0.02446287818,264.0347568,0.7387080862,0.004013056006,-1.155349102}, /*cmy*/
          {5.4233833,3.513264536,2.600028568,5.515884643}, /*cfy*/
          {-5.818672194,0.1342273486,670.2484476,-1.804809849,0.008877256679,2.986621431}, /*cmz*/
          {3.746915078,5.329701271,1.739267735,0.6966153838} /*cfz*/
     },
     {
          2462389.5,
          {8.533443608,-0.01010074838,621.8787773,-2.10591611,0.005142380179,2.788154292}, /*cmx*/
          {4.879665284,0.2405681104,2.7288416,5.028357328}, /*cfx*/
          {-3.384807745,0.003911326639,254.2731634,0.9098890339,0.003508358339,-1.101529923}, /*cmy*/
          {1.867081674,-0.174529945,4.764687341,5.159880512}, /*cfy*/
          {-1.744750759,0.1525930431,670.3711908,-2.287727521,0.005790612775,2.99309354}, /*cmz*/
          {0.1856853841,1.755408592,4.075856945,0.3342058705} /*cfz*/
     },
     {
          2462419.5,
          {8.301648659,-0.07805184256,627.3078599,-2.367740643,0.004708438859,2.839480892}, /*cmx*/
          {1.303422778,2.97195865,4.568636712,4.654574346}, /*cfx*/
          {-3.280634422,0.02943036124,239.9229367,0.984138595,0.004222041432,-1.037107809}, /*cmy*/
          {4.582478948,2.421547823,0.7336906955,4.794587652}, /*cfy*/
          {2.894871679,0.1314021194,670.1978019,-2.537647548,0.005436051566,3.020797197}, /*cmz*/
          {2.891522133,4.469702345,-0.2648386111,6.2450679} /*cfz*/
     },
     {
          2462449.5,
          {5.963364885,-0.1283553155,634.2374156,-2.411778436,0.004953116853,2.888601359}, /*cmx*/
          {4.004691188,5.66266766,0.0957829911,4.284018751}, /*cfx*/
          {-2.381955377,0.0428087772,221.820363,0.9945717571,0.004250055812,-0.9549370099}, /*cmy*/
          {1.013487128,4.972932087,2.882380972,4.440909774}, /*cfy*/
          {6.900606499,0.07517227595,670.408599,-2.553313563,0.005407702266,3.029867294}, /*cmz*/
          {5.591496644,0.8693458154,1.614479545,5.869719905} /*cfz*/
     },
     {
          2462479.5,
          {2.055640779,-0.1444856311,640.9778766,-2.211434925,0.007853383827,2.945423423}, /*cmx*/
          {0.4272077676,2.095508711,2.468112413,3.922494538}, /*cfx*/
          {-1.067845404,0.04151830187,201.1458495,0.9004204225,0.004034542909,-0.8682713491}, /*cmy*/
          {3.736483187,1.242469667,5.099633846,4.096930587}, /*cfy*/
          {9.220842358,0.00156081425,670.1907963,-2.341783909,0.00896677519,3.060133201}, /*cmz*/
          {2.012955018,3.585812432,3.985404787,5.504244961} /*cfz*/
     },
     {
          2462509.5,
          {-2.356557169,-0.1239612818,647.1186936,-1.771648855,0.0119469208,2.99276174}, /*cmx*/
          {3.148459517,4.805422051,4.877607416,3.580956543}, /*cfx*/
          {0.1909842453,0.03145207255,180.9060692,0.7344884756,0.005213674353,-0.7941029333}, /*cmy*/
          {0.1963208563,3.821447321,0.9560322874,3.780205123}, /*cfy*/
          {9.289568796,-0.06410814446,670.4505561,-1.857404343,0.01277888607,3.092563431}, /*cmz*/
          {4.732775417,-0.003398001638,0.04606307468,5.161318763} /*cfz*/
     },
     {
          2462539.5,
          {-6.122600802,-0.07923959829,651.2318381,-1.048348238,0.0161233327,3.036456206}, /*cmx*/
          {5.897094386,1.29374594,1.311627238,3.266119417}, /*cfx*/
          {1.133176581,0.02138175299,164.9616713,0.4385775866,0.006457368101,-0.7446217454}, /*cmy*/
          {2.967119894,0.1519526655,3.408933391,3.485044291}, /*cfy*/
          {7.364392316,-0.1021389676,670.0543344,-1.090475313,0.01692091057,3.126399979}, /*cmz*/
          {1.19722329,2.780682041,2.813532162,4.844930927} /*cfz*/
     },
     {
          2462569.5,
          {-8.492512874,-0.03078144418,653.2342675,-0.05344908697,0.01667546052,3.04313654}, /*cmx*/
          {2.401684149,4.001794294,4.048597064,2.991725992}, /*cfx*/
          {1.762218766,0.01534120203,157.7973496,0.05475572765,0.006777789376,-0.7405457616}, /*cmy*/
          {5.769778611,2.26228114,6.166071666,3.220294364}, /*cfy*/
          {4.263722614,-0.1107697772,670.2603745,-0.07190270503,0.01786345483,3.140248981}, /*cmz*/
          {3.984836796,5.28944806,5.531359698,4.575700992} /*cfz*/
     },
     {
          2462599.5,
          {-9.377671724,0.008949625928,651.9831508,0.9940831979,0.008713023996,3.02762121}, /*cmx*/
          {5.235229006,0.5695032261,0.9058807388,2.759048959}, /*cfx*/
          {2.21910271,0.009928460837,161.7610922,-0.3958797095,0.003145771876,-0.7863180354}, /*cmy*/
          {2.318594957,-0.3576834483,2.98218381,2.983020135}, /*cfy*/
          {0.917778468,-0.1032985212,670.0420752,-1.063948493,0.008115113916,3.12792273}, /*cmz*/
          {0.5352944714,-1.049498667,2.321760604,4.350873528} /*cfz*/
     },
     {
          2462629.5,
          {-9.129737237,0.04072803402,649.0268318,1.527412468,-0.005711547272,3.026613056}, /*cmx*/
          {1.822261732,3.506696748,3.371895693,2.543365151}, /*cfx*/
          {2.539639921,0.0002252729356,174.7049156,-0.59514093,-0.002247428664,-0.8507377759}, /*cmy*/
          {5.17211242,2.541461058,5.539786672,2.74106458}, /*cfy*/
          {-2.165119996,-0.09326024269,670.2506814,-1.588011526,-0.005765653623,3.145515711}, /*cmz*/
          {3.406839158,1.852995542,4.876423322,4.133236629} /*cfz*/
     },
     {
          2462659.5,
          {-7.939826152,0.07266379079,644.7760771,1.164180211,-0.0154675895,3.000019348}, /*cmx*/
          {4.698075637,0.07408275866,6.305963271,2.310496671}, /*cfx*/
          {2.563678807,-0.01497490771,188.430493,-0.454764927,-0.006371500872,-0.8997682626}, /*cmy*/
          {1.744587021,5.40419399,2.362143369,2.493037556}, /*cfy*/
          {-4.953282569,-0.08217551593,670.0953192,-1.226446452,-0.01673886496,3.120597339}, /*cmz*/
          {6.283251696,4.706723422,1.537960771,3.90306996} /*cfz*/
     },
     {
          2462689.5,
          {-5.784603468,0.1065437526,642.8284732,0.1922461696,-0.01610346679,2.983955564}, /*cmx*/
          {1.261106907,3.095261154,2.970118553,2.041224574}, /*cfx*/
          {2.119501725,-0.03037001517,195.7139892,-0.07849145538,-0.006378493329,-0.9055058533}, /*cmy*/
          {4.575864796,1.258287949,5.202874524,2.209210479}, /*cfy*/
          {-7.449806527,-0.05579839727,670.2855816,-0.1889707161,-0.01703987176,3.092856589}, /*cmz*/
          {2.846244458,1.283190228,4.422892215,3.629760485} /*cfz*/
     },
     {
          2462719.5,
          {-2.559046542,0.1307754079,643.1584265,-0.7914221639,-0.01406233828,2.966080505}, /*cmx*/
          {4.060712773,5.752589205,5.591614436,1.731875086}, /*cfx*/
          {1.187409668,-0.03814979559,193.3810367,0.344688406,-0.005696568454,-0.8650230171}, /*cmy*/
          {1.086201395,-1.22014683,1.474861547,1.894458699}, /*cfy*/
          {-9.18798848,-0.00608225547,670.2324392,0.8626759172,-0.01421798451,3.064817573}, /*cmz*/
          {5.645326355,4.108419467,0.7850973483,3.313092765} /*cfz*/
     },
     {
          2462749.5,
          {1.439556321,0.1294743545,646.5648444,-1.62691079,-0.009178672513,2.948776133}, /*cmx*/
          {0.5353854823,2.200807432,1.881672494,1.387307588}, /*cfx*/
          {0.005647083942,-0.03305068078,181.9859988,0.6741587801,-0.004601802798,-0.782171605}, /*cmy*/
          {3.847545182,1.37243899,3.688540245,1.561419158}, /*cfy*/
          {-9.425172096,0.05871303042,670.4212787,1.702660557,-0.009632096948,3.032052214}, /*cmz*/
          {2.118369147,0.5501523517,3.373249268,2.963826322} /*cfz*/
     },
     {
          2462779.5,
          {5.396919928,0.09375888598,651.6138436,-2.162123634,-0.007187328843,2.945883914}, /*cmx*/
          {3.261896914,4.934200206,4.118071319,1.019068678}, /*cfx*/
          {-1.013234477,-0.01652012907,162.435875,0.8900243769,-0.004559548986,-0.6709153944}, /*cmy*/
          {0.3049681652,3.950305517,-0.3395316676,1.209512937}, /*cfy*/
          {-7.68732217,0.1184620447,670.2921432,2.268217004,-0.006813268552,3.01550738}, /*cmz*/
          {4.843472975,3.283327275,5.582469151,2.593756948} /*cfz*/
     },
     {
          2462809.5,
          {8.28125198,0.02865601984,657.6635838,-2.486017998,-0.005214417757,2.930999465}, /*cmx*/
          {5.97000196,1.338832037,-0.1548420631,0.6463276823}, /*cfx*/
          {-1.514164657,0.002687644475,136.234342,1.034566484,-0.004726332978,-0.5340846727}, /*cmy*/
          {3.042496386,0.2328275384,1.850061386,0.8813617782}, /*cfy*/
          {-4.076722529,0.151852831,670.5321162,2.584449358,-0.004456458806,2.994565239}, /*cmz*/
          {1.266335924,5.972261061,1.248515911,2.222396934} /*cfz*/
     },
     {
          2462839.5,
          {9.178901834,-0.04801560899,663.2473657,-2.5431338,-0.006138972114,2.943665784}, /*cmx*/
          {2.386921871,4.025751305,1.979516361,6.557164063}, /*cfx*/
          {-1.420622414,0.01429052074,105.5795197,1.092784077,-0.004219746681,-0.3877183963}, /*cmy*/
          {5.797105285,2.774957736,4.044759956,0.5842870789}, /*cfy*/
          {0.5801672938,0.1459085194,670.4290364,2.601535917,-0.005471517569,2.980284036}, /*cmz*/
          {3.963868435,2.393146326,3.445657442,1.853602457} /*cfz*/
     },
     {
          2462869.5,
          {7.730905302,-0.1103500871,667.6324265,-2.388949408,-0.007965542638,2.966088416}, /*cmx*/
          {5.089744699,0.4134410968,4.01480742,6.198725345}, /*cfx*/
          {-0.9677426177,0.01398470635,73.76382176,1.049793588,-0.004260172033,-0.2585511345}, /*cmy*/
          {2.325092586,5.345500438,-0.1078838892,6.663044053}, /*cfy*/
          {5.056551452,0.1022555726,670.5385393,2.455436166,-0.008266916153,2.977770801}, /*cmz*/
          {0.3815742295,5.085739268,5.463054782,1.495566852} /*cfz*/
     },
     {
          2462899.5,
          {4.386634658,-0.1383990301,669.9254755,-1.981517942,-0.0118582323,2.99432612}, /*cmx*/
          {1.522595999,3.117011948,0.1710150408,5.855445369}, /*cfx*/
          {-0.5329855313,0.006392108282,45.89143339,0.8980162227,-0.00516784772,-0.1524528818}, /*cmy*/
          {5.274225165,1.656323432,1.9609877,6.675621233}, /*cfy*/
          {8.185875054,0.03794866607,670.5549099,2.004485458,-0.01150052971,2.991153896}, /*cmz*/
          {3.095404869,1.5192094,1.680913775,1.149207475} /*cfz*/
     },
     {
          2462929.5,
          {0.145763756,-0.1300376234,671.0073164,-1.322166997,-0.01674008736,3.028270741}, /*cmx*/
          {4.263457477,5.821347572,2.684285311,5.550527716}, /*cfx*/
          {-0.3492350949,0.0009949085428,28.91697769,0.6080826332,-0.006776158044,-0.1134554037}, /*cmy*/
          {2.213397249,4.31388941,4.358610207,6.892847072}, /*cfy*/
          {9.324564045,-0.02330249676,670.5984692,1.333450675,-0.01673323127,3.0082113}, /*cmz*/
          {5.834851786,4.251767592,4.262436457,0.8385017729} /*cfz*/
     },
     {
          2462959.5,
          {-3.845160786,-0.09867366019,671.0013253,-0.2933848227,-0.01644376174,3.056317524}, /*cmx*/
          {0.7566601736,2.348921896,5.484446919,5.282010956}, /*cfx*/
          {-0.3324075881,0.002977065346,25.34020923,0.1936772075,-0.007738471626,-0.1147183044}, /*cmy*/
          {5.458396895,0.788640418,0.7748621848,6.852670994}, /*cfy*/
          {8.577505814,-0.0649831156,670.5183259,0.3134439543,-0.01705057989,3.039456315}, /*cmz*/
          {2.32768186,0.7818245243,0.7724951583,0.5658995813} /*cfz*/
     },
     {
          2462989.5,
          {-6.845959675,-0.0620003528,671.0553464,0.7489257021,-0.01230259254,3.088095562}, /*cmx*/
          {3.579225704,5.147949159,2.097640211,5.04476705}, /*cfx*/
          {-0.2487609965,0.01002598154,25.35130866,-0.2909133595,-0.00550943202,-0.1248353476}, /*cmy*/
          {1.946010403,3.554255298,3.77500171,6.306915164}, /*cfy*/
          {6.592703186,-0.08483933945,670.5374706,-0.7737020102,-0.01215321784,3.076979073}, /*cmz*/
          {5.150022272,3.565415857,3.687055782,6.614201049} /*cfz*/
     },
     {
          2463019.5,
          {-8.711312839,-0.02999143417,670.8662304,1.541151433,0.003609833131,3.11291423}, /*cmx*/
          {0.1585694777,1.74222802,4.334828375,4.83794141}, /*cfx*/
          {0.05084480427,0.01411362691,30.04620155,-0.6379797173,0.001190901042,-0.1777094144}, /*cmy*/
          {4.299090381,0.2145989173,6.01499882,5.592984147}, /*cfy*/
          {4.023889367,-0.09524146021,670.4604517,-1.544314663,0.003078454156,3.110091604}, /*cmz*/
          {1.730527117,0.153069797,-0.511183246,6.405190215} /*cfz*/
     },
     {
          2463049.5,
          {-9.628333467,0.004159074962,670.1056598,1.342372641,0.01357568719,3.138124135}, /*cmx*/
          {3.037030569,4.647688162,-11.09046256,4.60841603}, /*cfx*/
          {0.4996245567,0.009975590824,44.10440882,-0.602995349,-0.005909596429,-0.2378978103}, /*cmy*/
          {0.49640127,3.145831887,6.287750263,5.121018499}, /*cfy*/
          {1.168753112,-0.1061515266,670.6526952,-1.370835314,0.0140120588,3.147907976}, /*cmz*/
          {4.609812791,3.054506851,3.036316019,6.180974094} /*cfz*/
     },
     {
          2463079.5,
          {-9.545542568,0.04786262802,669.2027072,0.4908545123,0.01897330029,3.149359836}, /*cmx*/
          {5.891888515,1.223882585,4.355205219,4.347789483}, /*cfx*/
          {0.8103382299,3.139615377e-06,55.64588716,-0.2342324997,-0.007649014054,-0.2662453889}, /*cmy*/
          {3.200931406,5.921079835,2.954521831,4.779951264}, /*cfy*/
          {-2.091955228,-0.1102669804,670.5433468,-0.5008222978,0.01932057013,3.16631501}, /*cmz*/
          {1.182105449,5.883345182,5.888850657,5.921887601} /*cfz*/
     },
     {
          2463109.5,
          {-8.149579515,0.09869415887,669.0483597,-0.6486847074,0.01516927736,3.154596113}, /*cmx*/
          {2.419054334,4.055049199,0.7669252282,4.035860033}, /*cfx*/
          {0.8054014278,-0.008382656424,55.4257417,0.2409388094,-0.006834889387,-0.2335431226}, /*cmy*/
          {5.993662679,2.832143479,5.579249985,4.505443673}, /*cfy*/
          {-5.499931083,-0.09217641928,670.6281922,0.6699735289,0.01514157097,3.166647188}, /*cmz*/
          {3.992522448,2.43360821,2.350851856,5.609225112} /*cfz*/
     },
     {
          2463139.5,
          {-5.193016977,0.1391796371,669.9835277,-1.572656295,0.01111821091,3.155383988}, /*cmx*/
          {5.183369689,0.5063264469,3.29832604,3.678896636}, /*cfx*/
          {0.5376441658,-0.007832239023,42.74513679,0.6495722681,-0.005328220589,-0.1478770518}, /*cmy*/
          {2.585597844,5.401465396,1.644184386,4.394040971}, /*cfy*/
          {-8.362429591,-0.04339332626,670.6200678,1.585072452,0.01146143091,3.152307025}, /*cmz*/
          {0.4725729524,5.200187454,4.878497911,5.250599758} /*cfz*/
     },
     {
          2463169.5,
          {-0.9251780791,0.1496641586,670.9128599,-2.23680062,0.007343920099,3.126002245}, /*cmx*/
          {1.629576351,3.212431836,5.518034147,3.303216819}, /*cfx*/
          {0.2779369401,0.002121881116,23.77927741,0.9363934346,-0.004867508623,0.09003609232}, /*cmy*/
          {5.839653712,1.731001739,3.841726994,7.584245576}, /*cfy*/
          {-9.74689521,0.02680135405,670.6404816,2.26590109,0.006890521631,3.118681036}, /*cmz*/
          {3.200888066,1.637312409,0.8780574903,4.872803532} /*cfz*/
     },
     {
          2463199.5,
          {3.709157989,0.1200322715,670.6942177,-2.559401632,0.006476511148,3.07959882}, /*cmx*/
          {4.336008882,5.892913445,1.449621026,2.915699229}, /*cfx*/
          {0.3376003336,0.01412925884,28.72452755,1.121778514,-0.004671499193,0.1936815252}, /*cmy*/
          {3.595258817,4.313990329,-0.3438879881,1.397713824}, /*cfy*/
          {-8.961104922,0.09776194477,670.7929027,2.587073139,0.005731703668,3.085801519}, /*cmz*/
          {5.90596102,4.336036458,3.138305623,4.48181663} /*cfz*/
     },
     {
          2463229.5,
          {7.437978145,0.05708280488,668.5703048,-2.695524171,0.006625346658,3.022620363}, /*cmx*/
          {0.749431022,2.278400686,3.364512021,2.529639005}, /*cfx*/
          {0.7838163466,0.01752673957,60.0677432,1.174886664,-0.004366558576,0.3526607706}, /*cmy*/
          {0.4505221317,0.5949560977,1.855077291,21.17956838}, /*cfy*/
          {-5.989155669,0.144825248,670.7472104,2.718980647,0.00596190856,3.0445778}, /*cmz*/
          {2.317891145,0.7486946704,4.990487052,4.097566538} /*cfz*/
     },
     {
          2463259.5,
          {9.220778805,-0.01916832223,664.6697552,-2.536832059,0.007586106358,2.958618007}, /*cmx*/
          {3.44559666,4.945737901,5.573010232,2.149445146}, /*cfx*/
          {1.336246836,0.007783263399,94.22344596,1.124161871,-0.004575084974,0.4957906938}, /*cmy*/
          {3.276837108,3.174155888,3.987095756,2.021236393}, /*cfy*/
          {-1.584868041,0.1521456545,670.8914606,2.587537593,0.007472667306,3.001803966}, /*cmz*/
          {5.013276097,3.435600168,0.8152556166,3.720270596} /*cfz*/
     },
     {
          2463289.5,
          {8.648848802,-0.0827478291,659.4914747,-2.201181945,0.01148755548,2.910445641}, /*cmx*/
          {6.153014289,1.35175785,1.580862661,1.799251773}, /*cfx*/
          {1.588326608,-0.009895631614,124.7661162,0.9608058558,-0.004939208719,0.6094715256}, /*cmy*/
          {6.041955596,5.767440039,-0.1876752469,1.715716035}, /*cfy*/
          {3.08852012,0.1201331061,670.9119936,2.242511955,0.01153288637,2.972484204}, /*cmz*/
          {1.436838013,6.142724679,3.203444505,3.370786372} /*cfz*/
     },
     {
          2463319.5,
          {6.12355017,-0.1167111754,654.6721718,-1.537795536,0.01377750185,2.878144083}, /*cmx*/
          {2.598130025,4.053626728,4.091354799,1.482492129}, /*cfx*/
          {1.285018869,-0.02506052159,148.2714824,0.685303068,-0.006137504267,0.6903220462}, /*cmy*/
          {2.517970397,2.154418695,2.194532068,1.413782901}, /*cfy*/
          {6.802618359,0.06482395671,671.0125271,1.573047367,0.01440374154,2.945662005}, /*cmz*/
          {4.164990322,2.581764307,5.761831871,3.051578391} /*cfz*/
     },
     {
          2463349.5,
          {2.557260049,-0.1189660883,651.064917,-0.6867611391,0.01763314151,2.869823825}, /*cmx*/
          {5.360616372,0.558124654,0.5804017235,1.208231542}, /*cfx*/
          {0.5088880567,-0.02951175895,162.303031,0.3165228419,-0.007615562864,0.7262003259}, /*cmy*/
          {5.297756657,4.95884879,4.792527671,1.151704733}, /*cfy*/
          {8.813118086,0.009623377646,670.9434714,0.7056633873,0.01839524922,2.94899226}, /*cmz*/
          {0.6446274169,5.358173268,2.21479248,2.772508201} /*cfz*/
     },
     {
          2463379.5,
          {-1.055628842,-0.1018837022,650.4223723,0.4118359731,0.01460055606,2.886060314}, /*cmx*/
          {1.883430566,3.385943918,3.390627721,0.973814105}, /*cfx*/
          {-0.4010190143,-0.02328117108,165.3282297,-0.1727501614,-0.006446420187,0.7143429153}, /*cmy*/
          {1.828669074,0.951075679,1.449292299,0.9199027665}, /*cfy*/
          {9.12232279,-0.03116748941,671.0361543,-0.4478323168,0.01446335797,2.969016456}, /*cmz*/
          {3.450792042,1.878200927,5.064095515,2.53632802} /*cfz*/
     },
     {
          2463409.5,
          {-4.143624883,-0.08030839206,652.374085,1.3339568,0.004304874927,2.916906634}, /*cmx*/
          {4.735695231,6.200549414,6.815836454,0.7709351512}, /*cfx*/
          {-1.109406347,-0.01280962388,156.8047399,-0.566611181,-0.002577558267,0.6660647126}, /*cmy*/
          {4.681037427,4.128961455,4.994556972,0.7046250538}, /*cfy*/
          {8.203715121,-0.05877021419,670.9516287,-1.362844303,0.00422438766,2.988403141}, /*cmz*/
          {6.303630871,4.728334526,2.023351501,2.328733474} /*cfz*/
     },
     {
          2463439.5,
          {-6.640222043,-0.05998731578,656.3164293,1.570174713,0.01241856286,2.981502811}, /*cmx*/
          {1.330970356,2.834748103,5.938683671,0.5736538622}, /*cfx*/
          {-1.504341163,-0.005046538825,140.5625928,-0.6800848085,0.005023154689,0.5936725865}, /*cmy*/
          {1.269291003,0.8593392196,0.6587706504,0.503570249}, /*cfy*/
          {6.464700929,-0.0842474652,671.1440067,-1.613878742,0.01312871563,3.051698802}, /*cmz*/
          {2.899064963,1.348873561,-4.967216457,2.137604852} /*cfz*/
     },
     {
          2463469.5,
          {-8.515753611,-0.0305930367,659.1923229,0.8028329685,0.01860190128,3.032502462}, /*cmx*/
          {4.198948388,5.683572203,2.547222735,6.614291963}, /*cfx*/
          {-1.65615835,-0.002496643854,125.7231571,-0.375543136,0.007906654189,0.564230767}, /*cmy*/
          {4.127091293,3.827183471,3.789422998,6.538561182}, /*cfy*/
          {3.971280345,-0.1132078952,670.813188,-0.8094525427,0.01866682682,3.104110563}, /*cmz*/
          {5.76730784,4.174592658,4.165012753,1.898439572} /*cfz*/
     },
     {
          2463499.5,
          {-9.525973457,0.01856895096,660.0148197,-0.3413555682,0.01733675534,3.072010133}, /*cmx*/
          {0.7403478224,2.271853233,5.331234876,6.315562929}, /*cfx*/
          {-1.742217461,0.000498049485,121.665502,0.1121881926,0.007472659737,0.5874979273}, /*cmy*/
          {0.665134459,0.3042047156,0.2467778132,6.246753511}, /*cfy*/
          {0.5784078848,-0.1316070715,671.0366267,0.3454775522,0.01775863762,3.147090301}, /*cmz*/
          {2.308711655,0.7231663139,0.7163951651,1.603292739} /*cfz*/
     },
     {
          2463529.5,
          {-9.048571501,0.0799931513,658.0840133,-1.410436922,0.01216370893,3.096010047}, /*cmx*/
          {3.515150305,5.030241215,1.584285575,5.971619467}, /*cfx*/
          {-1.757391,0.01009400719,130.9312623,0.5695887775,0.005464603255,0.6618935255}, /*cmy*/
          {3.448854158,3.075411683,2.685617832,5.916669704}, /*cfy*/
          {-3.464655369,-0.1207855029,670.8432513,1.43913236,0.0123693408,3.176104929}, /*cmz*/
          {5.083416145,3.535161294,3.235348971,1.262350688} /*cfz*/
     },
     {
          2463559.5,
          {-6.660815085,0.1325289822,653.981927,-2.119022158,0.008730452046,3.095634717}, /*cmx*/
          {-0.03491861685,1.452843149,4.015956421,5.590186753}, /*cfx*/
          {-1.475228672,0.02703503617,150.6141433,0.8868281956,0.00469814232,0.7805801734}, /*cmy*/
          {6.197926362,5.745710412,4.762002827,5.553778666}, /*cfy*/
          {-7.231393722,-0.07425769833,671.059835,2.168220101,0.008601651144,3.186946531}, /*cmz*/
          {1.533312674,-0.0374700724,5.733739335,0.8817976922} /*cfz*/
     },
     {
          2463589.5,
          {-2.637471705,0.1529367664,647.4709307,-2.566725307,0.006592632373,3.073101623}, /*cmx*/
          {2.671407397,4.157236134,-0.271537777,5.195292573}, /*cfx*/
          {-0.6707443007,0.04354942434,175.7124712,1.079003393,0.004495009497,0.9042682916}, /*cmy*/
          {2.638516274,2.054307991,0.5318032423,5.177044212}, /*cfy*/
          {-9.594602166,-0.001381750964,670.9415882,2.639677789,0.006329488895,3.187070556}, /*cmz*/
          {4.239975149,2.67519546,1.46306288,0.4803555076} /*cfz*/
     },
     {
          2463619.5,
          {2.024487117,0.1323735651,640.0862888,-2.709723488,0.005139208693,3.00773465}, /*cmx*/
          {5.363008039,0.5437350856,1.741430378,4.787338486}, /*cfx*/
          {0.6592151912,0.04867856918,201.7790931,1.130276516,0.004444980065,1.013935641}, /*cmy*/
          {5.346210866,4.618750704,2.804429107,4.780216826}, /*cfy*/
          {-9.693265455,0.07586474546,671.1315476,2.804802682,0.005566446515,3.1601433}, /*cmz*/
          {0.6491342288,5.356632929,3.48731962,6.353276143} /*cfz*/
     },
     {
          2463649.5,
          {6.101867685,0.07653884857,632.075268,-2.634052181,0.007418648958,2.934598049}, /*cmx*/
          {1.768893159,3.244251453,3.938108592,4.389424187}, /*cfx*/
          {2.169942799,0.03610052221,225.1107576,1.103426817,0.004497899171,1.0984748}, /*cmy*/
          {1.766665659,0.9003767621,4.943833137,4.39759593}, /*cfy*/
          {-7.402774852,0.132443861,671.0234645,2.746919424,0.007325680035,3.131293617}, /*cmz*/
          {3.339408925,1.765241079,-0.681755912,5.95581222} /*cfz*/
     },
     {
          2463679.5,
          {8.484005633,0.006534919217,625.3347484,-2.312838285,0.0088816805,2.852226711}, /*cmx*/
          {4.46512377,5.930475337,-0.1000425925,4.011159341}, /*cfx*/
          {3.299368496,0.0103834965,243.909777,0.9591637827,0.004273572438,1.150678996}, /*cmy*/
          {4.476057644,3.48291838,0.8449197486,4.0299425}, /*cfy*/
          {-3.370077604,0.1513834578,671.1418977,2.41779817,0.008816594004,3.090326188}, /*cmz*/
          {6.037306931,4.453508269,1.620397083,5.58063363} /*cfz*/
     },
     {
          2463709.5,
          {8.73040415,-0.05418365097,619.7752895,-1.81394819,0.01280705874,2.796425342}, /*cmx*/
          {0.8969720657,2.385447698,2.503927788,3.659280193}, /*cfx*/
          {3.642684164,-0.01709311968,257.155185,0.7486976112,0.005746444388,1.184949097}, /*cmy*/
          {0.9199778608,-0.1607336535,3.10494821,3.689185135}, /*cfy*/
          {1.239711396,0.131070887,670.8989515,1.913702273,0.01364417737,3.048036031}, /*cmz*/
          {2.47108384,0.9018072092,4.178853206,5.237772223} /*cfz*/
     },
     {
          2463739.5,
          {7.110772074,-0.09042861896,616.5601954,-1.058589607,0.01621385043,2.734600786}, /*cmx*/
          {3.641230397,5.114481264,5.116061067,3.350984706}, /*cfx*/
          {3.135090456,-0.03604670789,265.2855223,0.4090929886,0.006972691556,1.186567495}, /*cmy*/
          {3.674808992,2.548899878,5.591310644,3.389729789}, /*cfy*/
          {5.209393336,0.08628396183,671.1494179,1.105025691,0.01725410852,2.989419149}, /*cmz*/
          {5.217177118,3.61381111,0.454964625,4.932287692} /*cfz*/
     },
     {
          2463769.5,
          {4.378832308,-0.1001146715,615.0077146,-0.07244619469,0.01683933178,2.694887736}, /*cmx*/
          {0.1438259573,1.684523704,1.675673203,3.095649944}, /*cfx*/
          {2.044789497,-0.0426875956,268.4489598,0.04977113219,0.007171696316,1.173189926}, /*cmy*/
          {0.1858662732,7.243125188,2.162098014,3.14042601}, /*cfy*/
          {7.837188377,0.0365247336,670.7476045,0.06229282736,0.0179834484,2.944380519}, /*cmz*/
          {1.721301776,0.7848141366,3.36729893,4.678856462} /*cfz*/
     },
     {
          2463799.5,
          {1.359000552,-0.09462146637,615.769443,1.009273355,0.008323171725,2.704144592}, /*cmx*/
          {2.977791348,4.501716138,4.560354222,2.892006186}, /*cfx*/
          {0.7543903846,-0.04055837797,267.1520636,-0.4858940124,0.003330709797,1.158786712}, /*cmy*/
          {3.024911943,14.30658569,5.406426958,2.93935418}, /*cfy*/
          {8.983303063,-0.002396142275,671.0856366,1.097334036,0.008802083812,2.932131821}, /*cmz*/
          {4.556103642,12.42501326,6.221406971,4.472417556} /*cfz*/
     },
     {
          2463829.5,
          {-1.443818843,-0.08913743048,617.9785792,1.554343318,-0.006333245954,2.706467272}, /*cmx*/
          {5.852016024,1.05625243,0.774386092,2.705425176}, /*cfx*/
          {-0.4531520781,-0.03680827852,261.3320451,-0.6845487394,0.003543371728,1.123389453}, /*cmy*/
          {5.899536168,4.724361426,4.246909045,2.74769743}, /*cfy*/
          {8.948773827,-0.03392112177,670.8061179,1.676483828,-0.007521601513,2.921735326}, /*cmz*/
          {1.14671785,2.70692446,2.425056204,4.284578372} /*cfz*/
     },
     {
          2463859.5,
          {-4.111110617,-0.08148609884,621.4519664,1.16305444,-0.01727514788,2.750063763}, /*cmx*/
          {2.44819415,3.964261803,3.983337994,2.500922986}, /*cfx*/
          {-1.544416475,-0.03309507459,253.8220402,-0.4920910695,0.007809710826,1.108567164}, /*cmy*/
          {2.491801936,1.468811242,1.402422716,2.541562098}, /*cfy*/
          {8.007165347,-0.06942572323,671.1422652,1.218027036,-0.01819837269,2.958021398}, /*cmz*/
          {4.025334444,5.624685497,5.635986207,4.076279514} /*cfz*/
     },
     {
          2463889.5,
          {-6.6053161,-0.05717871538,622.8580199,0.08590708439,-0.01817103754,2.785684933}, /*cmx*/
          {5.292830214,0.06759766022,0.4378559553,2.242507133}, /*cfx*/
          {-2.550113494,-0.02579156985,249.3679967,-0.01397442207,0.007604820671,1.119004878}, /*cmy*/
          {5.331009044,15.21738182,4.206301261,2.279840135}, /*cfy*/
          {5.967150283,-0.1110489935,670.8743418,0.08305142625,-0.01966421922,2.996235219}, /*cmz*/
          {0.5856163684,1.948298341,2.122167976,3.817952106} /*cfz*/
     },
     {
          2463919.5,
          {-8.411923599,-0.00755800941,622.182154,-1.030596066,-0.01405024886,2.823372729}, /*cmx*/
          {1.800791235,-2.995141877,3.20029302,1.926553434}, /*cfx*/
          {-3.362659024,-0.009281076474,251.8138388,-0.4627195913,0.006176333984,1.163656093}, /*cmy*/
          {1.835750126,-27.56634314,0.5129546307,1.961288445}, /*cfy*/
          {2.634490751,-0.1416987054,670.9941024,1.106099635,-0.01514024036,3.052905254}, /*cmz*/
          {3.376569345,1.813173108,4.811943159,3.502126252} /*cfz*/
     },
     {
          2463949.5,
          {-8.734830822,0.05703824398,618.6950496,-1.884102775,-0.00920548483,2.863364212}, /*cmx*/
          {4.544655598,6.0594268,5.569071627,1.562547232}, /*cfx*/
          {-3.691000138,0.01715931496,259.5817331,-0.8353100971,0.004558900373,1.229371764}, /*cmy*/
          {4.580447895,0.2927966815,2.613711293,1.603497513}, /*cfy*/
          {-1.655137812,-0.1408973624,670.7776807,2.01758124,-0.01028534275,3.12441215}, /*cmz*/
          {6.120742043,4.569538342,0.8884644475,3.141870897} /*cfz*/
     },
     {
          2463979.5,
          {-7.045666562,0.1148033163,614.6716666,-2.403945624,-0.005058217018,2.882363726}, /*cmx*/
          {0.971788073,2.477251574,1.548487917,1.169807141}, /*cfx*/
          {-3.197008533,0.04572543494,269.6648335,-1.05102392,0.003905602791,1.29155496}, /*cmy*/
          {1.01218914,2.904365515,4.737638169,1.214347594}, /*cfy*/
          {-5.963598204,-0.1000298857,670.9989095,2.57236909,-0.006474939343,3.153739275}, /*cmz*/
          {2.548918397,0.9766589328,3.178881178,2.748344482} /*cfz*/
     },
     {
          2464009.5,
          {-3.558425377,0.1453575581,610.6049091,-2.611309364,-0.004755906571,2.897302928}, /*cmx*/
          {3.663070811,5.191551256,3.592275659,0.7638597437}, /*cfx*/
          {-1.812584178,0.06468071033,278.4488073,-1.142627491,0.004383124612,1.340377088}, /*cmy*/
          {3.711125523,5.507341719,0.6468793827,0.8173578858}, /*cfy*/
          {-9.063314064,-0.02711810206,670.8311481,2.837867554,-0.006587216422,3.187959071}, /*cmz*/
          {5.242258769,3.677381202,5.171304256,2.34288814} /*cfz*/
     },
     {
          2464039.5,
          {0.8858630452,0.1368833154,608.1115858,-2.609139891,-0.004997052617,2.90255051}, /*cmx*/
          {0.06493645586,1.607726714,-0.6804728421,0.3559264907}, /*cfx*/
          {0.1672632853,0.06455065208,284.2233273,-1.130112772,0.00417135349,1.363136512}, /*cmy*/
          {0.1227101857,1.798038652,2.868396411,0.4197521371}, /*cfy*/
          {-9.939887492,0.05415894433,671.046229,2.832428679,-0.005979572456,3.205210713}, /*cmz*/
          {1.646078368,0.06386216969,0.960145861,1.936197509} /*cfz*/
     },
     {
          2464069.5,
          {5.066351928,0.09396365055,607.191486,-2.421453388,-0.007448026662,2.902882542}, /*cmx*/
          {2.754493049,4.326833728,1.659682225,6.238710525}, /*cfx*/
          {2.140290762,0.04605820164,286.0978716,-1.031144845,0.004566702879,1.364319436}, /*cmy*/
          {2.823405497,4.392299463,5.115983705,6.313412274}, /*cfy*/
          {-8.333317411,0.1168381572,670.7097503,2.63352452,-0.008781893518,3.209682813}, /*cmz*/
          {4.337887674,2.767592076,3.306343754,1.535884214} /*cfz*/
     },
     {
          2464099.5,
          {7.918240077,0.0320069842,608.1229782,-2.037025843,-0.01050961174,2.874230945}, /*cmx*/
          {5.458304173,0.7523728901,4.001699682,5.860191641}, /*cfx*/
          {3.534478695,0.01788565763,284.8255599,-0.8445789903,0.005153123905,1.336667728}, /*cmy*/
          {5.539166741,0.6974679463,0.9706108428,5.947808504}, /*cfy*/
          {-4.786367904,0.1441727666,670.8468879,2.223179318,-0.01214961458,3.176263982}, /*cmz*/
          {0.7606694741,5.455048493,5.594248563,1.165349544} /*cfz*/
     },
     {
          2464129.5,
          {8.886883924,-0.02781769898,609.4464772,-1.420667488,-0.01441569572,2.844110679}, /*cmx*/
          {1.903806162,3.520176653,0.4364202525,5.517657166}, /*cfx*/
          {4.071695009,-0.008558184474,281.5920801,-0.5554240867,0.006361245809,1.303141249}, /*cmy*/
          {1.996572683,3.360605731,3.476277927,5.615066087}, /*cfy*/
          {-0.3925402331,0.1338260388,670.6150523,1.515221016,-0.01548743136,3.127035721}, /*cmz*/
          {3.490749246,1.910397411,1.954423014,0.827062028} /*cfz*/
     },
     {
          2464159.5,
          {8.037734319,-0.06770806861,611.026511,-0.5404738676,-0.01727340461,2.803363798}, /*cmx*/
          {4.668891687,-0.03643708579,3.099924768,5.224543536}, /*cfx*/
          {3.809357302,-0.0260272283,279.0232197,-0.1727142761,0.007365379154,1.277257969}, /*cmy*/
          {4.772142287,5.937394453,-0.2252125207,5.331485386}, /*cfy*/
          {3.666281257,0.09818596683,670.5759488,0.5631323317,-0.01880604016,3.069467648}, /*cmz*/
          {-0.02579455798,4.656160157,4.658620308,0.5357104899} /*cfz*/
     },
     {
          2464189.5,
          {5.999068471,-0.08346908364,610.8150083,0.5535593625,-0.01354739675,2.751732893}, /*cmx*/
          {1.197805506,2.742047336,6.093441892,4.984904948}, /*cfx*/
          {3.030528499,-0.03451944733,278.6832622,0.2975301554,0.005233231964,1.262015446}, /*cmy*/
          {1.307909434,2.629159667,2.852298285,5.096681038}, /*cfy*/
          {6.604943782,0.05789184279,670.313678,-0.6244426852,-0.01453404167,3.005386767}, /*cmz*/
          {2.787481696,1.172130355,1.333074142,6.578713216} /*cfz*/
     },
     {
          2464219.5,
          {3.508581533,-0.08754723723,609.984395,1.403303555,-0.001275472517,2.709678322}, /*cmx*/
          {4.05795463,5.684372858,3.120627029,4.784775227}, /*cfx*/
          {2.003341691,-0.03957734338,281.4228666,0.6265204008,-0.0008930399367,1.258840064}, /*cmy*/
          {4.168658948,5.567545496,-8.269638167,4.892107841}, /*cfy*/
          {8.334423099,0.02402042719,670.5461394,-1.547687245,-0.001434122338,2.964799642}, /*cmz*/
          {5.647959138,4.086801159,5.175475004,6.376066516} /*cfz*/
     },
     {
          2464249.5,
          {0.866170625,-0.09453721716,608.3600405,1.473256794,0.01488033521,2.655971021}, /*cmx*/
          {0.6579888357,2.26029188,11.63842698,4.599806745}, /*cfx*/
          {0.8068812658,-0.04564312176,284.3597268,0.6123021809,-0.007051953088,1.247672627}, /*cmy*/
          {0.7628747299,2.209832921,8.4414757,4.699109061}, /*cfy*/
          {9.044098793,-0.007796077346,670.4026968,-1.569613075,-0.01571248717,2.910822426}, /*cmz*/
          {2.247795081,0.6719565643,16.3160423,6.181538482} /*cfz*/
     },
     {
          2464279.5,
          {-1.979865626,-0.09759161515,607.6932251,0.5548972446,0.01857232959,2.649881051}, /*cmx*/
          {3.522365746,5.14206437,1.99634405,4.367850646}, /*cfx*/
          {-0.5687176072,-0.0485896583,285.8490232,0.1781794925,-0.008116743685,1.247634935}, /*cmy*/
          {3.618529356,5.11545033,5.134183392,4.459754331}, /*cfy*/
          {8.856404578,-0.05122089405,670.7080862,-0.5910335504,-0.02061023755,2.914231109}, /*cmz*/
          {5.11042558,3.569722818,0.4274057254,5.948881129} /*cfz*/
     },
     {
          2464309.5,
          {-4.945979921,-0.07987498516,607.4357359,-0.586739412,0.01615653845,2.661672196}, /*cmx*/
          {0.05253114434,1.684639042,4.680911763,4.081467562}, /*cfx*/
          {-2.044933915,-0.04078470003,285.7401154,-0.3214088576,-0.006870545407,1.250028997}, /*cmy*/
          {0.1419796138,1.707757654,1.429772109,4.169017273}, /*cfy*/
          {7.368760638,-0.101782353,670.4744266,0.6800958902,-0.01721438269,2.936062113}, /*cmz*/
          {1.639671991,0.1212488256,3.087354426,5.662260315} /*cfz*/
     },
     {
          2464339.5,
          {-7.403280711,-0.03339106952,608.1691444,-1.564614919,0.01026546223,2.675133312}, /*cmx*/
          {2.81371844,4.416233925,1.010160867,3.750137625}, /*cfx*/
          {-3.300384214,-0.0186081321,284.3862233,-0.7348288341,-0.004553108091,1.240816276}, /*cmy*/
          {2.90116647,4.377010032,3.713216249,3.838869899}, /*cfy*/
          {4.293379871,-0.1418799041,670.7335581,1.739932371,-0.010762548,2.966294111}, /*cmz*/
          {4.400307283,2.828031346,5.682562645,5.333495067} /*cfz*/
     },
     {
          2464369.5,
          {-8.463688563,0.0335261884,609.9388546,-2.179246303,0.007214420051,2.735341329}, /*cmx*/
          {5.535520007,0.8731248671,3.334927059,3.382643091}, /*cfx*/
          {-3.885469494,0.01317915297,280.5235942,-0.9742292815,-0.004359504578,1.237599417}, /*cmy*/
          {5.625849978,0.7311271802,-0.4731935956,3.475804822}, /*cfy*/
          {-0.0466461584,-0.1499014268,670.5525857,2.376339326,-0.008224875606,3.014532917}, /*cmz*/
          {0.8386774939,5.558779493,1.678572328,4.972754743} /*cfz*/
     },
     {
          2464399.5,
          {-7.485432937,0.09933419062,613.547762,-2.518418798,0.004674696809,2.808856524}, /*cmx*/
          {1.950813631,3.577288518,5.513881295,2.995411476}, /*cfx*/
          {-3.493423342,0.04209381392,273.0062698,-1.093211192,-0.004412546246,1.216109552}, /*cmy*/
          {2.04836589,3.31306904,1.660161705,3.097817634}, /*cfy*/
          {-4.661489476,-0.116600646,670.5978777,2.755534993,-0.005674471014,3.063382239}, /*cmz*/
          {3.53777038,1.965195935,3.712830743,4.588545849} /*cfz*/
     },
     {
          2464429.5,
          {-4.493398125,0.1407119141,618.5863298,-2.639121685,0.005392383247,2.899022407}, /*cmx*/
          {4.639466283,0.007101832485,1.225233027,2.596693052}, /*cfx*/
          {-2.213096502,0.05618556951,261.1383764,-1.107326157,-0.004847939805,1.176931524}, /*cmy*/
          {4.747825053,5.880093693,3.964538783,2.709498995}, /*cfy*/
          {-8.254324644,-0.04963094236,670.5336939,2.835444265,-0.006243918432,3.119049241}, /*cmz*/
          {-0.05678422233,4.655409099,-0.3910218309,4.187757331} /*cfz*/
     },
     {
          2464459.5,
          {-0.1866787216,0.1450723669,625.2312168,-2.573439067,0.006592600484,2.97792626}, /*cmx*/
          {1.045719344,2.697265869,3.253501801,2.206496024}, /*cfx*/
          {-0.4847918569,0.05225868787,245.5168285,-1.054937582,-0.004894943676,1.117892222}, /*cmy*/
          {1.16830827,2.142972585,-0.08060944642,2.335358664}, /*cfy*/
          {-9.779855435,0.02929065604,670.5147749,2.739440289,-0.007484093095,3.157284211}, /*cmz*/
          {2.632604439,1.053968462,1.668784543,3.791886502} /*cfz*/
     },
     {
          2464489.5,
          {4.277776004,0.1115839035,632.0507775,-2.253982219,0.008544387549,3.033868584}, /*cmx*/
          {3.744587309,5.410767843,5.742453859,1.825189388}, /*cfx*/
          {1.126192517,0.03557134397,227.4836617,-0.9085204575,-0.004400715183,1.039126772}, /*cmy*/
          {3.884488366,4.684581902,2.163787558,1.972362005}, /*cfy*/
          {-8.875172781,0.09558298431,670.3764778,2.395933723,-0.009500087159,3.192331939}, /*cmz*/
          {5.331465229,3.755063633,4.092848429,3.406552928} /*cfz*/
     },
     {
          2464519.5,
          {7.699498443,0.0552568901,638.2478476,-1.780110871,0.01349478193,3.066140461}, /*cmx*/
          {0.1807010268,1.845015087,1.907272545,1.467641149}, /*cfx*/
          {2.204725629,0.01675005089,209.7632458,-0.7098877827,-0.005648202071,0.9687260726}, /*cmy*/
          {0.340399704,0.9849142994,4.388175575,1.634021318}, /*cfy*/
          {-5.93931811,0.1305510721,670.3917103,1.860420491,-0.01400957405,3.20993183}, /*cmz*/
          {1.766833079,0.1786403256,0.244753474,3.048041394} /*cfz*/
     },
     {
          2464549.5,
          {9.379338554,-0.003000618766,642.6581764,-0.9680385828,0.01680679582,3.069981428}, /*cmx*/
          {2.930022,4.60449547,4.603024607,1.139102389}, /*cfx*/
          {2.705384885,0.003116818767,196.1146795,-0.3907623302,-0.006825226666,0.9170975455}, /*cmy*/
          {3.108700761,3.565751236,0.5498815687,1.325211432}, /*cfy*/
          {-1.972850843,0.1284924146,670.1049034,1.020052928,-0.01809516757,3.201476031}, /*cmz*/
          {4.515908129,2.948056713,2.964113503,2.721732681} /*cfz*/
     },
     {
          2464579.5,
          {9.263010854,-0.044232073,644.2831008,0.06718723726,0.01805211709,3.035333803}, /*cmx*/
          {5.722364386,0.8949682721,1.134421893,0.8626786922}, /*cfx*/
          {2.791737878,-0.004603937332,190.7203337,0.04772699866,-0.006917959771,0.9077056131}, /*cmy*/
          {5.913200718,1.065318039,3.394626885,1.056135316}, /*cfy*/
          {1.943122574,0.1021696465,670.1586191,-0.07192313391,-0.01899210472,3.169098672}, /*cmz*/
          {1.025143251,5.794442818,5.746018217,2.449288968} /*cfz*/
     },
     {
          2464609.5,
          {7.881208086,-0.06725226288,642.7027177,-1.211249276,0.00658331246,2.969332184}, /*cmx*/
          {2.28002313,7.076980536,4.261085956,0.6389825133}, /*cfx*/
          {2.650597353,-0.01214117615,195.9614778,0.4813634688,-0.002379927556,0.9430153417}, /*cmy*/
          {2.469210488,-3.144808388,6.517931077,0.8233096264}, /*cfy*/
          {5.063957662,0.07191871172,670.0702989,-1.296989077,-0.00636455412,3.120921747}, /*cmz*/
          {3.866364502,2.287788538,2.601739302,2.230506476} /*cfz*/
     },
     {
          2464639.5,
          {5.872375262,-0.08529571481,638.6721728,-1.624339376,-0.009349075575,2.910853322}, /*cmx*/
          {5.158461993,3.693864604,0.4142702993,6.710469974}, /*cfx*/
          {2.305514044,-0.02351401617,208.7763263,0.6356673424,0.004053960134,0.9826846317}, /*cmy*/
          {5.333420118,6.030168844,2.803672087,0.5951927799}, /*cfy*/
          {7.246490658,0.04681886439,670.2356673,-1.702292368,0.00968323194,3.067307147}, /*cmz*/
          {0.4627736527,5.187727211,5.102220819,2.015053294} /*cfz*/
     },
     {
          2464669.5,
          {3.310560622,-0.1051048801,634.5415183,-1.022731688,-0.01900824277,2.843385259}, /*cmx*/
          {1.751508323,0.2888553261,3.416837226,6.483174986}, /*cfx*/
          {1.598284818,-0.03630568623,220.606863,0.3783689334,0.007673008412,1.00435131}, /*cmy*/
          {1.909307478,2.598879324,5.884339567,6.63481112}, /*cfy*/
          {8.709189869,0.0175123348,670.2716756,-1.088935278,0.02083313255,3.010667614}, /*cmz*/
          {3.338882993,1.773307606,1.770809297,1.789242731} /*cfz*/
     },
     {
          2464699.5,
          {0.1064230978,-0.1174595158,633.0339282,0.17152886,-0.01717582996,2.802920022}, /*cmx*/
          {4.586646387,3.064873459,6.234379938,6.212788334}, /*cfx*/
          {0.4814597137,-0.04230436643,224.7449158,-0.1255975317,0.006919299905,0.9856421307}, /*cmy*/
          {4.732629736,6.138002618,2.303366547,6.355690034}, /*cfy*/
          {9.295311395,-0.02875492354,670.2640276,0.2051895036,0.01803957192,2.959345327}, /*cmz*/
          {6.173618487,4.682988373,4.559928101,1.515758742} /*cfz*/
     },
     {
          2464729.5,
          {-3.518098223,-0.1048293033,634.7220793,1.215271598,-0.01341323412,2.785450617}, /*cmx*/
          {1.084404285,5.905966369,2.562907383,5.899510736}, /*cfx*/
          {-0.8334059702,-0.03464103302,219.5537926,0.5291660347,0.005425655651,0.9295380367}, /*cmy*/
          {1.227412853,-13.56934838,4.728503957,6.041400521}, /*cfy*/
          {8.465728859,-0.08768872101,670.3689371,1.304354634,0.01409201844,2.930713076}, /*cmz*/
          {2.6704168,1.113707342,0.9011411947,1.198284473} /*cfz*/
     },
     {
          2464759.5,
          {-6.783486442,-0.05990625558,639.3362278,2.014035007,-0.008010692852,2.792717328}, /*cmx*/
          {3.822815899,2.354685389,4.959447261,5.555770147}, /*cfx*/
          {-1.916535686,-0.01469678507,205.7440115,0.830420429,0.004799112882,0.8477925019}, /*cmy*/
          {3.972153307,1.600125366,0.5287719551,5.710684968}, /*cfy*/
          {5.825495289,-0.136763136,670.3002784,2.122300468,0.008635930945,2.913071597}, /*cmz*/
          {5.407369199,3.847290198,3.250197753,0.8559220806} /*cfz*/
     },
     {
          2464789.5,
          {-8.668488255,0.009959660822,645.87041,2.441415253,-0.0064317727,2.831679483}, /*cmx*/
          {0.2497591157,5.063283394,0.8812378737,5.186924255}, /*cfx*/
          {-2.374557156,0.008613323073,184.4658825,1.005890833,0.004848327532,0.7400700103}, /*cmy*/
          {0.4155020104,4.151446913,2.756954458,5.360350737}, /*cfy*/
          {1.67716126,-0.154307566,670.3681045,2.573417175,0.006017769504,2.925222701}, /*cmz*/
          {1.833016377,0.2638112977,5.439895191,0.4878534725} /*cfz*/
     },
     {
          2464819.5,
          {-8.412669447,0.08300374045,653.032716,2.671006935,-0.005858292276,2.894197498}, /*cmx*/
          {2.946595092,1.467169586,2.825504837,4.816840088}, /*cfx*/
          {-2.105859363,0.02360591559,157.0726067,1.097849257,0.005096501498,0.6198220917}, /*cmy*/
          {3.141656281,0.4129532177,5.040300588,5.027396959}, /*cfy*/
          {-3.077761513,-0.1295969966,670.373462,2.779107716,0.005708445108,2.956615529}, /*cmz*/
          {4.527870709,2.955983347,1.110188035,6.399952816} /*cfz*/
     },
     {
          2464849.5,
          {-5.888943346,0.1358915393,659.8848413,2.621569741,-0.006077699401,2.975228155}, /*cmx*/
          {5.639677766,4.142565876,5.165343937,4.444330546}, /*cfx*/
          {-1.375409708,0.0246962451,125.8383829,1.120285362,0.004493201979,0.4855212832}, /*cmy*/
          {5.8840949,2.939900286,0.9890558478,4.722888315}, /*cfy*/
          {-7.109974364,-0.07002020919,670.4288581,2.706608452,0.005990862554,2.999338893}, /*cmz*/
          {0.9354576491,5.643423822,3.419733282,6.024043708} /*cfz*/
     },
     {
          2464879.5,
          {-1.725616929,0.1509343409,665.123934,2.439647512,-0.008643190403,3.055308541}, /*cmx*/
          {2.055988303,0.542524017,1.047169835,4.079353138}, /*cfx*/
          {-0.6150688438,0.01557801122,93.67417567,1.053742938,0.004352492594,0.3572141724}, /*cmy*/
          {2.38649839,5.502610598,3.199778098,4.461418292}, /*cfy*/
          {-9.307691855,0.004283621264,670.3598463,2.514642242,0.008866006793,3.065674826}, /*cmz*/
          {3.632886611,2.057513546,5.604137023,5.653031143} /*cfz*/
     },
     {
          2464909.5,
          {2.882336094,0.1269222262,668.6389281,2.010734224,-0.01189911497,3.113039371}, /*cmx*/
          {4.770036929,3.227165259,3.380583858,3.722166642}, /*cfx*/
          {-0.1468346491,0.005648728874,64.9532848,0.9023949604,0.005276867137,0.2457958526}, /*cmy*/
          {5.255001591,1.808030006,5.272305523,4.325894822}, /*cfy*/
          {-9.205380316,0.07010160375,670.4828291,2.043244334,0.01166926446,3.120606832}, /*cmz*/
          {0.06142660297,4.760920767,1.755382387,5.290658953} /*cfz*/
     },
     {
          2464939.5,
          {6.783352242,0.07713870452,670.2173614,1.340652821,-0.01713014734,3.166307872}, /*cmx*/
          {1.226460392,5.956768681,5.983848457,3.393916478}, /*cfx*/
          {0.005947462789,0.002802216518,44.63491768,0.6110802819,0.006966207997,0.1839367694}, /*cmy*/
          {1.969201382,4.454981327,1.369512229,4.260001295}, /*cfy*/
          {-7.054268934,0.1081575897,670.3485395,1.372598699,0.01763786304,3.174999483}, /*cmz*/
          {2.799495034,1.221524989,4.384098189,4.962017026} /*cfz*/
     },
     {
          2464969.5,
          {9.164513421,0.02457114638,670.8060551,0.2859672437,-0.01794808838,3.192985497}, /*cmx*/
          {4.002670103,2.434303079,2.441390948,3.102914156}, /*cfx*/
          {0.08058217561,0.007172259417,36.11668175,0.1849925813,0.008257242684,0.1724473417}, /*cmy*/
          {4.994949226,0.9053806968,4.072735967,4.099055212}, /*cfy*/
          {-3.738061107,0.1149856391,670.4280509,0.2900699484,0.01809970657,3.209054399}, /*cmz*/
          {5.574814299,3.955198061,0.8394500311,4.674837348} /*cfz*/
     },
     {
          2464999.5,
          {9.946758953,-0.01589388633,670.6134461,-0.855489152,-0.01268492901,3.195123647}, /*cmx*/
          {0.5442680279,5.246682161,5.427207827,2.851169391}, /*cfx*/
          {0.3040323374,0.01213827359,37.37162823,-0.3356674817,0.005663056487,0.2046699334}, /*cmy*/
          {1.49009582,3.733533423,0.8176699075,3.670631659}, /*cfy*/
          {-0.2643540264,0.1017036826,670.1325792,-0.8783754714,0.0128649867,3.212320266}, /*cmz*/
          {2.116457187,0.5004311882,3.874882752,4.429407057} /*cfz*/
     },
     {
          2465029.5,
          {9.522810873,-0.04548111536,670.0881204,-1.668885022,0.005214897573,3.197663594}, /*cmx*/
          {3.411981305,1.882206233,1.59049433,2.632836802}, /*cfx*/
          {0.6790585823,0.009781582083,48.73534297,-0.6915184707,-0.001800573759,0.2819724046}, /*cmy*/
          {4.077321539,0.3947615238,2.927195294,3.173651538}, /*cfy*/
          {2.807337152,0.08735908444,670.4405297,-1.685492451,-0.004713040591,3.20259792}, /*cmz*/
          {4.985477407,3.426211926,0.0316797232,4.212601213} /*cfz*/
     },
     {
          2465059.5,
          {8.204328562,-0.07802225729,668.3909775,-1.339830128,0.01671872066,3.154014244}, /*cmx*/
          {6.293528004,4.776278271,4.752320273,2.394037097}, /*cfx*/
          {0.9990819535,-0.0008166632009,66.36000546,-0.5949624448,-0.00714265214,0.3437966814}, /*cmy*/
          {0.4691756555,3.320042317,6.497244888,2.809483815}, /*cfy*/
          {5.457269084,0.07411188305,670.3036807,-1.374325431,-0.01731596682,3.167200393}, /*cmz*/
          {1.58492109,6.292251343,3.111535538,3.977831458} /*cfz*/
     },
     {
          2465089.5,
          {5.886681294,-0.1134042633,667.2428825,-0.3050748556,0.02013747878,3.120640764}, /*cmx*/
          {2.861027416,1.381476447,1.346718638,2.125690992}, /*cfx*/
          {0.9742977781,-0.01123364429,77.30452679,-0.1509225056,-0.008078228423,0.3578997388}, /*cmy*/
          {3.237132381,5.956838544,3.107949823,2.494035089}, /*cfy*/
          {7.798769792,0.0473385283,670.5274311,-0.2953554098,-0.02005805012,3.120729267}, /*cmz*/
          {4.436404943,2.899548986,6.022962881,3.706028533} /*cfz*/
     },
     {
          2465119.5,
          {2.466949864,-0.1372433233,667.2410145,0.9048852165,0.01446420457,3.075161939}, /*cmx*/
          {5.661540606,4.179408199,3.943144647,1.814313646}, /*cfx*/
          {0.6175492711,-0.01326092663,74.26768374,-0.3512868237,-0.006625260375,0.3072068772}, /*cmy*/
          {6.038998287,6.063370911,5.658163474,2.216301203}, /*cfy*/
          {9.345198614,-0.002441719489,670.3847521,0.928679913,-0.01455909804,3.069100897}, /*cmz*/
          {0.9534041042,5.694655633,2.378310386,3.386082934} /*cfz*/
     },
     {
          2465149.5,
          {-1.702897632,-0.1313830435,669.048749,1.769643435,0.009593384312,3.016301813}, /*cmx*/
          {2.132294066,0.5975562667,0.1998052866,1.462249367}, /*cfx*/
          {0.2055428911,-0.005145254414,58.34515368,-0.741607317,-0.00499766771,0.2049010632}, /*cmy*/
          {2.603384145,2.378384834,1.621936532,2.04859542}, /*cfy*/
          {9.345648667,-0.06705406883,670.5655731,1.805860132,-0.009554468767,3.00552677}, /*cmz*/
          {3.706164343,2.13929444,4.908917813,3.03029576} /*cfz*/
     },
     {
          2465179.5,
          {-5.75710312,-0.08703931944,670.4662656,2.330368831,0.007174548187,2.958688993}, /*cmx*/
          {4.854905647,3.31243582,2.249185707,1.101376538}, /*cfx*/
          {0.04547361428,0.006218895951,35.29513367,-0.9883381849,-0.004604709173,0.1100546232}, /*cmy*/
          {5.666549828,4.978382112,3.806651228,2.371410655}, /*cfy*/
          {7.356512649,-0.1251388223,670.4706458,2.368325285,-0.006158816755,2.958031753}, /*cmz*/
          {0.143909956,4.86228119,0.7851717394,2.665830229} /*cfz*/
     },
     {
          2465209.5,
          {-8.490890875,-0.01513783498,671.0771044,2.569397663,0.005720584767,2.910984925}, /*cmx*/
          {1.275958656,5.975983082,4.486733837,0.733332471}, /*cfx*/
          {0.2516734878,0.01095572209,26.54150554,-1.130271891,-0.00457101447,0.1636249738}, /*cmy*/
          {3.226792836,1.277133477,-0.3220933454,3.198956454}, /*cfy*/
          {3.556732457,-0.1539670208,670.643725,2.598029539,-0.004981845889,2.92806501}, /*cmz*/
          {2.846165579,1.271950541,3.06520841,2.298672504} /*cfz*/
     },
     {
          2465239.5,
          {-9.036412541,0.06145756079,669.3464224,2.63276112,0.006876124007,2.895803292}, /*cmx*/
          {3.973820804,2.372194354,0.2987749278,0.3669067042}, /*cfx*/
          {0.6154742126,0.003694045958,52.16348048,-1.160147965,-0.004205706268,0.2996431131}, /*cmy*/
          {6.649778873,3.842892732,1.903699848,3.189095691}, /*cfy*/
          {-1.145227281,-0.1422812199,670.4999198,2.670703507,-0.006202609702,2.919651368}, /*cmz*/
          {5.542097475,3.976933342,5.030665235,1.938397535} /*cfz*/
     },
     {
          2465269.5,
          {-7.213837121,0.1185466721,666.0960571,2.472163793,0.007526764914,2.882601441}, /*cmx*/
          {0.3901990646,5.033670815,2.446937196,6.292351575}, /*cfx*/
          {0.7474509639,-0.01167025371,85.20576023,-1.096139162,-0.004336137956,0.440702091}, /*cmy*/
          {3.269986244,0.146986947,4.097689078,2.945135236}, /*cfy*/
          {-5.497226631,-0.09410218645,670.8234047,2.514595825,-0.00705140672,2.919453446}, /*cmz*/
          {1.956884674,0.3738209834,0.8253677749,1.581111902} /*cfz*/
     },
     {
          2465299.5,
          {-3.603848791,0.1411122724,661.3457156,2.126582123,0.0110732241,2.902370693}, /*cmx*/
          {3.100985017,1.445436263,4.81797949,5.952586645}, /*cfx*/
          {0.39655606,-0.02544460516,115.4058223,-0.9410909974,-0.004903222027,0.5673225465}, /*cmy*/
          {6.064773503,2.746864688,-0.08638233152,2.667735083}, /*cfy*/
          {-8.40826115,-0.02609454402,670.6560238,2.167206655,-0.01112069515,2.950917956}, /*cmz*/
          {4.666596398,3.098106294,3.33881087,1.239765648} /*cfz*/
     },
     {
          2465329.5,
          {0.7001574643,0.1279963001,656.9008432,1.484635883,0.0143553739,2.939480799}, /*cmx*/
          {5.832475874,4.143394394,1.018819558,5.638491642}, /*cfx*/
          {-0.3912755228,-0.02884508472,138.9361361,-0.6656056802,-0.006236244521,0.6592438569}, /*cmy*/
          {2.555277975,5.422262116,2.300971167,2.375668029}, /*cfy*/
          {-9.238708753,0.03761410701,670.9589647,1.531237725,-0.01521435904,2.995605686}, /*cmz*/
          {1.114485631,5.805475599,5.816859818,0.9225004404} /*cfz*/
     },
     {
          2465359.5,
          {4.584754569,0.09315945127,653.4666034,0.5988996262,0.01831935054,2.992912697}, /*cmx*/
          {2.315079253,0.6747967385,3.83433182,5.356203343}, /*cfx*/
          {-1.282675388,-0.02006524689,152.6955272,-0.2899927142,-0.008078242596,0.7082430738}, /*cmy*/
          {5.343008633,1.967577589,4.938865337,2.107308439}, /*cfy*/
          {-8.125517409,0.07813992651,670.7081154,0.6119577179,-0.01893200269,3.064780193}, /*cmz*/
          {3.880090448,2.339087679,2.339501698,0.6350161766} /*cfz*/
     },
     {
          2465389.5,
          {7.384605116,0.05455442294,653.316266,-0.5518534681,0.01472756897,3.051169917}, /*cmx*/
          {5.126110407,3.502590015,0.3415882724,5.109161987}, /*cfx*/
          {-1.897548062,-0.005101370908,154.5880572,0.2285502393,-0.006463251053,0.6979945964}, /*cmy*/
          {1.878483808,4.351430654,1.620606954,1.86046218}, /*cfy*/
          {-5.78579894,0.09317454271,670.928934,-0.5724871647,-0.01510419402,3.126148713}, /*cmz*/
          {0.4082321007,5.13342983,5.154683115,6.671727524} /*cfz*/
     },
     {
          2465419.5,
          {9.018387556,0.02083113701,655.400515,-1.498429945,0.003142609452,3.097705483}, /*cmx*/
          {1.70129397,0.01874051415,10.87053055,4.892670227}, /*cfx*/
          {-2.040886228,0.007088223136,143.7613659,0.6301970678,-0.00218399496,0.633963287}, /*cmy*/
          {4.731374315,1.162713283,5.542095787,1.614817091}, /*cfy*/
          {-3.016942657,0.09818633406,670.8147287,-1.534682312,-0.001965799488,3.146405202}, /*cmz*/
          {3.26706329,1.694500154,2.973898071,6.454996648} /*cfz*/
     },
     {
          2465449.5,
          {9.731534862,-0.01343326874,659.6104055,-1.536715657,-0.01456925581,3.164925122}, /*cmx*/
          {4.583091233,2.961025803,6.101212931,4.669119861}, /*cfx*/
          {-1.824548275,0.01204856284,125.5797074,0.6804225379,0.006118772387,0.5584097282}, /*cmy*/
          {1.312803403,4.184823048,7.207683776,1.389157542}, /*cfy*/
          {-0.1054041282,0.103785527,671.0183878,-1.580271192,0.01526388139,3.218338238}, /*cmz*/
          {6.149365188,4.603527151,10.87721896,6.23454583} /*cfz*/
     },
     {
          2465479.5,
          {9.412975661,-0.05629665777,661.8413893,-0.6243431939,-0.0191099981,3.189095634}, /*cmx*/
          {1.16314214,5.762460204,2.629611628,4.401120952}, /*cfx*/
          {-1.468730596,0.01234481806,111.0508459,0.2997815059,0.008052590548,0.5250524961}, /*cmy*/
          {4.156581327,0.8428500886,3.946768314,1.107851789}, /*cfy*/
          {3.007024503,0.1053472121,670.6534764,-0.6335109795,0.01936162922,3.235631002}, /*cmz*/
          {2.729903415,1.122326555,1.122982841,5.969552186} /*cfz*/
     },
     {
          2465509.5,
          {7.771681088,-0.1044941353,662.3714475,0.5611861918,-0.01497017814,3.172047107}, /*cmx*/
          {3.979244306,2.341104969,5.429992816,4.084525811}, /*cfx*/
          {-1.114334157,0.01592106757,109.271928,-0.1961015742,0.006860312846,0.550464953}, /*cmy*/
          {0.6871068861,3.608738046,0.3719109368,0.8017927784}, /*cfy*/
          {6.209233998,0.08374259747,670.9164581,0.5531141552,0.01581893092,3.216956665}, /*cmz*/
          {5.545906834,3.965502835,3.940486935,5.651051675} /*cfz*/
     },
     {
          2465539.5,
          {4.623508578,-0.1397198819,660.1431547,1.482802624,-0.01066383889,3.126946936}, /*cmx*/
          {0.4639152203,5.118900102,1.632853171,3.730978516}, /*cfx*/
          {-0.6567387917,0.02536946965,120.8260493,-0.6130283047,0.00473216577,0.6214783567}, /*cmy*/
          {3.473978447,0.07379690654,2.721356659,0.478951165}, /*cfy*/
          {8.8111582,0.03202391518,670.6841099,1.522275158,0.01076291735,3.186434807}, /*cmz*/
          {2.030576409,0.4855377835,0.1128448882,5.297369021} /*cfz*/
     },
     {
          2465569.5,
          {0.3664912299,-0.1433480854,656.0332764,2.089826999,-0.006726735217,3.049202409}, /*cmx*/
          {3.196357185,1.541255652,3.996645501,3.353998563}, /*cfx*/
          {0.1050973664,0.03505899276,141.8581498,-0.8751880669,0.004013252391,0.7250297864}, /*cmy*/
          {-0.04967497782,2.731167931,4.823694316,6.408252192}, /*cfy*/
          {9.850524952,-0.03870400722,671.0122568,2.13567742,0.006583903901,3.133878188}, /*cmz*/
          {4.762500716,3.186828694,2.615250411,4.91867813} /*cfz*/
     },
     {
          2465599.5,
          {-4.005950214,-0.1087809577,649.8178192,2.414275567,-0.005697418927,2.965852905}, /*cmx*/
          {5.907093571,4.248518082,-0.2410195875,2.969401326}, /*cfx*/
          {1.171004061,0.03608372304,167.3792016,-1.024686501,0.003934727595,0.8322756832}, /*cmy*/
          {2.687374423,5.335545188,0.6031362373,6.050212318}, /*cfy*/
          {8.744992026,-0.105650583,670.7815055,2.488244677,0.005650096495,3.081290639}, /*cmz*/
          {1.189959069,5.912060075,4.58594123,4.532062853} /*cfz*/
     },
     {
          2465629.5,
          {-7.325377663,-0.04510588402,642.7192772,2.513886414,-0.004675880512,2.856525823}, /*cmx*/
          {2.324018333,0.6421528204,1.71349921,2.586186148}, /*cfx*/
          {2.284122809,0.02288241921,193.5452459,-1.050091342,0.003748240355,0.9218949392}, /*cmy*/
          {5.40969101,1.632162467,2.920709453,5.684095274}, /*cfy*/
          {5.560860828,-0.1472384924,671.0578201,2.614022864,0.004859783839,3.00915635}, /*cmz*/
          {3.890384009,2.312098198,0.2269245633,4.154236132} /*cfz*/
     },
     {
          2465659.5,
          {-8.724761012,0.02789224621,634.8920143,2.407011976,-0.006676770252,2.772439451}, /*cmx*/
          {5.023159019,3.351622806,4.02990911,2.218705259}, /*cfx*/
          {3.005320285,-0.001937144996,217.1025765,-1.015984392,0.004090176731,1.000927004}, /*cmy*/
          {1.844598958,4.223145096,5.072646547,5.335720887}, /*cfy*/
          {1.069311277,-0.1498941554,670.9871611,2.502856969,0.006444809413,2.948321558}, /*cmz*/
          {0.3067976293,5.016426592,2.531208134,3.790562732} /*cfz*/
     },
     {
          2465689.5,
          {-7.897842287,0.08721324315,628.1989559,2.111947027,-0.009240602839,2.714123592}, /*cmx*/
          {1.447104621,6.040520449,-0.06775991369,1.876211738}, /*cfx*/
          {2.96383219,-0.02832000597,236.5340479,-0.8724648978,0.004054895503,1.059983054}, /*cmy*/
          {4.567877617,0.5328137881,0.887038906,5.006535593}, /*cfy*/
          {-3.513590786,-0.1152433869,671.0987342,2.204376505,0.009457564888,2.906113883}, /*cmz*/
          {3.01522306,1.432597939,4.788011438,3.448763542} /*cfz*/
     },
     {
          2465719.5,
          {-5.268882168,0.1164594045,622.4358978,1.577807902,-0.01335385427,2.692314289}, /*cmx*/
          {4.172921886,2.510326741,2.608971167,1.557978336}, /*cfx*/
          {2.116274179,-0.04505799451,250.4030946,-0.6536978268,0.005989321998,1.107583111}, /*cmy*/
          {1.02444703,3.210975193,3.262797981,4.700046667}, /*cfy*/
          {-7.029811647,-0.05900988982,670.9921102,1.655870132,0.01412972287,2.898228113}, /*cmz*/
          {5.742703292,4.171168011,1.111597323,3.132253671} /*cfz*/
     },
     {
          2465749.5,
          {-1.73236765,0.115684603,619.2427311,0.7960411236,-0.01777022939,2.68701041}, /*cmx*/
          {0.6468626207,5.238140605,5.243128739,1.286681334}, /*cfx*/
          {0.743306016,-0.04779359358,258.7480205,-0.3003683425,0.007494649283,1.131041667}, /*cmy*/
          {3.792818106,5.9665468,5.793418512,4.437104989}, /*cfy*/
          {-8.788691774,-0.003023368899,671.18694,0.8048446975,0.01840036064,2.90115346}, /*cmz*/
          {2.218084618,0.6142653927,3.746091137,2.854948587} /*cfz*/
     },
     {
          2465779.5,
          {1.769725311,0.09612658253,618.1388543,-0.3076245402,-0.01489288344,2.708968213}, /*cmx*/
          {3.447265734,1.794258818,1.842172377,1.05847645}, /*cfx*/
          {-0.7108240634,-0.03940011206,261.0086529,0.1838109254,0.006333266033,1.135046584}, /*cmy*/
          {0.3176689472,2.014207294,2.515828805,4.213188601}, /*cfy*/
          {-8.836091041,0.03788721895,670.8169689,-0.347444241,0.016018083,2.936487601}, /*cmz*/
          {5.019988559,3.333811639,0.4156460621,2.623225513} /*cfz*/
     },
     {
          2465809.5,
          {4.65600101,0.07347788538,619.8574115,-1.272027208,-0.004570570098,2.785782973}, /*cmx*/
          {6.29696216,4.655425711,4.849810932,0.8537843188}, /*cfx*/
          {-1.896254862,-0.02719451685,257.2699112,0.5823475103,0.002116215823,1.134406329}, /*cmy*/
          {3.170100859,5.181998108,6.14529802,4.008081881}, /*cfy*/
          {-7.703126969,0.063818462,671.1650347,-1.377952286,0.004239486327,3.00437384}, /*cmz*/
          {1.586731944,6.312006758,3.427017469,2.420004811} /*cfz*/
     },
     {
          2465839.5,
          {6.842869855,0.05304589936,623.2974934,-1.555754552,0.01120909967,2.846459589}, /*cmx*/
          {2.894229028,1.233769847,1.145339688,0.6546001435}, /*cfx*/
          {-2.706950565,-0.01709359344,248.4942572,0.6706986452,0.005241054503,1.10800234}, /*cmy*/
          {6.047873919,1.897703066,4.786636383,3.801855117}, /*cfy*/
          {-5.81068394,0.08720252126,670.8552978,-1.643832358,-0.01208130729,3.070031264}, /*cmz*/
          {4.466738008,2.885644381,5.888709853,2.219742038} /*cfz*/
     },
     {
          2465869.5,
          {8.456913556,0.02297701463,626.8896387,-0.8474638993,0.017073409,2.923861136}, /*cmx*/
          {5.766133678,4.111829492,4.126460231,6.694427881}, /*cfx*/
          {-3.21505167,-0.007430538802,239.6295889,0.3579412258,0.007499141854,1.105789401}, /*cmy*/
          {2.630730366,4.92624734,1.703141004,3.55616655}, /*cfy*/
          {-3.225437026,0.1128834354,671.1891,-0.8713105729,-0.01771296502,3.147320928}, /*cmz*/
          {1.054702013,5.802677882,2.673903888,1.980862293} /*cfz*/
     },
     {
          2465899.5,
          {9.194314999,-0.02436884518,627.8732687,0.2175211903,0.01608814841,2.97674129}, /*cmx*/
          {2.312325542,0.7797443852,0.5800346534,6.397415694}, /*cfx*/
          {-3.452938432,0.006683619155,236.4851583,-0.1116089956,0.006616363184,1.132337217}, /*cmy*/
          {5.455299419,1.204267044,4.425845516,3.25791601}, /*cfy*/
          {0.2016406631,0.1275157284,670.9283828,0.225128109,-0.01727088976,3.202114708}, /*cmz*/
          {3.883111648,2.394776541,5.398641928,1.689188313} /*cfz*/
     },
     {
          2465929.5,
          {8.495216138,-0.08052731078,626.2580336,1.178635187,0.01096902815,2.999197263}, /*cmx*/
          {5.09287542,3.432949216,3.272472605,6.051860433}, /*cfx*/
          {-3.275463555,0.0268256587,241.1797108,-0.5096403872,0.004840076549,1.182117984}, /*cmy*/
          {1.952157587,4.097753685,0.6692501793,2.91303771}, /*cfy*/
          {4.114275057,0.1149558046,671.0232955,1.26293526,-0.01138671254,3.232184637}, /*cmz*/
          {0.3807061031,5.098476401,1.772191686,1.346288849} /*cfz*/
     },
     {
          2465959.5,
          {6.087186886,-0.1258669922,622.1041429,1.841525613,0.007161592688,3.001017394}, /*cmx*/
          {1.551359147,6.189884567,5.6267922,5.670403724}, /*cfx*/
          {-2.486306668,0.04811869006,251.170422,-0.7990630313,0.003691681955,1.248807296}, /*cmy*/
          {4.698072272,0.5256155416,2.751898086,2.540267802}, /*cfy*/
          {7.643768892,0.06860286898,670.9547406,1.94586448,-0.008132421404,3.246553392}, /*cmz*/
          {3.122698765,1.563850671,4.14926914,0.9643409405} /*cfz*/
     },
     {
          2465989.5,
          {2.244375001,-0.1427406865,617.2713608,2.242941357,0.003813038795,2.964129314}, /*cmx*/
          {4.267460518,2.614479216,1.484172659,5.2779575}, /*cfx*/
          {-1.023308414,0.06115937895,263.36759,-0.9622363926,0.003061868827,1.299150672}, /*cmy*/
          {1.138836876,3.143686785,4.897201096,2.155269735}, /*cfy*/
          {9.763201017,-0.001640979598,671.0267153,2.380781584,-0.004957227692,3.21634234}, /*cmz*/
          {5.840072841,4.269951845,0.01605405643,0.568611278} /*cfz*/
     },
     {
          2466019.5,
          {-2.138346953,-0.1233303465,612.2794128,2.355282535,0.003870870046,2.901897993}, /*cmx*/
          {0.6858659732,5.333641819,3.659907523,4.880939058}, /*cfx*/
          {0.8536221022,0.05820835247,274.6110687,-1.015008397,0.00356770293,1.329469621}, /*cmy*/
          {3.850833359,5.768513575,0.8865943693,1.769681688}, /*cfy*/
          {9.729759636,-0.07644454329,670.9756054,2.537663985,-0.005051723828,3.181615037}, /*cmz*/
          {2.260759354,0.6925254358,2.156337978,6.452157483} /*cfz*/
     },
     {
          2466049.5,
          {-5.930488357,-0.07293891845,608.3756599,2.342010213,0.005314971436,2.829192709}, /*cmx*/
          {3.384508212,1.762335364,-0.7921056654,4.491351036}, /*cfx*/
          {2.645721447,0.03818642444,283.3409593,-1.001656951,0.003549812992,1.334776158}, /*cmy*/
          {0.2782956815,2.080405799,2.943887556,1.392766095}, /*cfy*/
          {7.410385828,-0.1311199088,671.0596024,2.51402873,-0.005805624796,3.128987104}, /*cmz*/
          {4.961550457,3.382291788,4.07470396,6.064218407} /*cfz*/
     },
     {
          2466079.5,
          {-8.175797203,-0.00800968577,605.9348091,2.088898992,0.00778055177,2.759097935}, /*cmx*/
          {6.08877122,4.485616633,1.61749627,4.115323473}, /*cfx*/
          {3.821233597,0.008351919317,288.7361425,-0.8782994752,0.004087156029,1.32219921}, /*cmy*/
          {2.995425228,4.698459605,5.182631222,1.028993186}, /*cfy*/
          {3.43196955,-0.1486338479,670.8442356,2.265995291,-0.009119948071,3.065591769}, /*cmz*/
          {1.385430664,6.096172145,0.1492073398,5.69311739} /*cfz*/
     },
     {
          2466109.5,
          {-8.412872381,0.04994913234,604.9163307,1.652955037,0.01271504783,2.69022603}, /*cmx*/
          {2.527073508,0.9363257973,4.128782499,3.777890166}, /*cfx*/
          {4.071269724,-0.01963540011,291.0726723,-0.6728195169,0.005844850575,1.295930132}, /*cmy*/
          {5.729848163,1.051316911,1.152010678,0.7040926509}, /*cfy*/
          {-1.121790199,-0.1284585681,670.9200445,1.793886835,-0.01428845516,2.998833413}, /*cmz*/
          {4.10952905,2.521908478,2.575410221,5.363961194} /*cfz*/
     },
     {
          2466139.5,
          {-6.861456874,0.08567917798,604.7311781,0.8870828737,0.01547615362,2.640062412}, /*cmx*/
          {5.277297967,3.709248269,0.5738834359,3.485172307}, /*cfx*/
          {3.459735243,-0.03760335263,291.4250551,-0.3220019751,0.006764961042,1.270695888}, /*cmy*/
          {2.20861557,3.761088329,3.758874905,0.4215475666}, /*cfy*/
          {-5.065905826,-0.08476052742,670.7775951,0.9301140454,-0.01669238068,2.933006057}, /*cmz*/
          {0.5784483558,5.282109967,5.292051192,5.075103033} /*cfz*/
     },
     {
          2458849.5,
          {-3.476811487,0.01860985243,1068.30238,4.331034634,0.0110653701,1.197100708}, /*cmx*/
          {-1.274825147,-2.886260788,-5.148931752,-3.724673436}, /*cfx*/
          {-0.2005245469,-0.00242363408,81.05166369,1.89905156,0.007181626941,0.140452597}, /*cmy*/
          {-1.796875368,-1.384638692,-3.473275861,-3.965424619}, /*cfy*/
          {-1.39620985,-0.02658928454,1069.775711,4.382075002,0.009997365517,1.218727021}, /*cmz*/
          {-5.98987894,-1.28212972,-3.563797851,-2.159134052} /*cfz*/
     },
     {
          2458889.5,
          {-3.082234962,0.01633294047,1060.69326,3.858714521,0.01549650323,1.289026553}, /*cmx*/
          {2.284721495,0.6327803996,4.07997263,3.659180494}, /*cfx*/
          {-0.3614383479,-0.0003261679862,150.4518374,1.687160929,0.007645375308,0.2096069064}, /*cmy*/
          {2.04259098,2.010561596,-0.6546889032,3.486003736}, /*cfy*/
          {-2.052681478,-0.03604343049,1070.089475,3.933611253,0.01539626116,1.309002879}, /*cmz*/
          {3.85100562,2.264558283,-0.6171054935,5.226875444} /*cfz*/
     },
     {
          2458929.5,
          {-2.221077904,0.003026028612,1050.881551,2.698546217,0.02351902817,1.28517}, /*cmx*/
          {5.873286784,4.19984031,1.106997385,4.791166968}, /*cfx*/
          {-0.3568671774,-0.0004068709611,206.8260865,1.174109893,0.01033086105,0.2814505601}, /*cmy*/
          {5.719873637,5.477245653,2.364407598,4.626693989}, /*cfy*/
          {-2.969369312,-0.019698755,1070.031717,2.779355039,0.02467193961,1.297162692}, /*cmz*/
          {1.155420433,5.854677704,2.750346602,0.0816411638} /*cfz*/
     },
     {
          2458969.5,
          {-1.517194101,-0.002431873595,1044.418109,0.7391566516,0.0277727347,1.261721856}, /*cmx*/
          {3.235504856,1.557174657,4.714259696,6.045992377}, /*cfx*/
          {-0.2505392031,-0.0004239470848,236.4256078,0.3268880609,0.01190019159,0.2839847011}, /*cmy*/
          {3.116198819,2.953274486,5.9069728,5.923213474}, /*cfy*/
          {-3.799299289,0.008633456124,1070.018902,0.7425137924,0.02846673983,1.295587885}, /*cmz*/
          {4.800457853,3.245425851,0.098525054,1.328921729} /*cfz*/
     },
     {
          2459009.5,
          {-1.460329767,0.008195638132,1045.310426,-1.694642706,0.01064486622,1.258472459}, /*cmx*/
          {0.6776517781,5.29675778,2.394658289,1.039210086}, /*cfx*/
          {-0.2467320123,0.002513661661,231.821108,-0.7274465576,0.005508129279,0.2588351699}, /*cmy*/
          {0.5630753169,0.09231379175,3.870031345,0.9859746696}, /*cfy*/
          {-4.032410115,0.02175208921,1069.948857,-1.735673604,0.01124535994,1.2705663}, /*cmz*/
          {2.243176498,0.6534289114,4.077560346,2.621836934} /*cfz*/
     },
     {
          2459049.5,
          {-1.538650911,0.01805966198,1052.260537,-2.571259851,-0.01953517144,1.081521463}, /*cmx*/
          {4.468982714,2.828822048,5.90322915,2.366424458}, /*cfx*/
          {-0.1804591927,0.003106269708,198.0230011,-1.124329323,-0.008195553239,0.1778263349}, /*cmy*/
          {4.334832127,4.089561527,0.8408409735,2.06732926}, /*cfy*/
          {-3.335745024,0.006979173036,1070.419942,-2.621520761,-0.01986845885,1.079410992}, /*cmz*/
          {6.035324788,4.485680485,1.301639415,3.942229912} /*cfz*/
     },
     {
          2459089.5,
          {-1.226570845,0.006051378855,1057.623908,-0.8798263417,-0.02941558903,0.9502375185}, /*cmx*/
          {1.965233742,0.3165379297,3.464113673,3.514857917}, /*cfx*/
          {-0.1191715251,0.0006902169959,166.9802835,-0.4099679321,-0.01275665309,0.1471622669}, /*cmy*/
          {1.801748139,1.628711511,4.78246594,3.346995672}, /*cfy*/
          {-2.588585733,-0.004141427569,1070.205464,-0.8924612471,-0.02994481238,0.9654076655}, /*cmz*/
          {3.532249057,1.978862593,5.114922951,5.07523048} /*cfz*/
     },
     {
          2459129.5,
          {-0.6958120657,-0.01182029269,1056.767409,1.532432463,-0.02228257006,0.8050833616}, /*cmx*/
          {5.666309143,4.072602993,0.6725140092,4.480363702}, /*cfx*/
          {-0.03868914786,-0.003183433366,170.7110267,0.6571635925,-0.009436069444,0.153908801}, /*cmy*/
          {5.5104007,5.41269188,1.853265694,4.371629446}, /*cfy*/
          {-2.209371135,0.002989061713,1069.831799,1.584051097,-0.02200319097,0.7955594794}, /*cmz*/
          {0.9502665349,5.697709546,2.342516665,6.06983094} /*cfz*/
     },
     {
          2459169.5,
          {-0.6139634899,-0.01565093817,1049.814464,3.292943258,-0.01329608036,0.7145604851}, /*cmx*/
          {3.004660142,1.362549966,3.830943216,5.416278519}, /*cfx*/
          {-0.07572583635,-0.005641503348,209.9834129,1.41373434,-0.007137123164,0.1560533215}, /*cmy*/
          {2.891437687,2.615599019,4.679944608,5.317275691}, /*cfy*/
          {-2.184173216,0.01292425006,1070.103295,3.358299312,-0.01316648804,0.7340437466}, /*cmz*/
          {4.571088446,3.010394594,5.543578854,0.6711663446} /*cfz*/
     },
     {
          2459209.5,
          {-1.109095696,-0.0006922615925,1036.351359,4.194318117,-0.0093930831,0.7140036747}, /*cmx*/
          {0.2917681072,4.910111218,0.2806575983,-0.1397540052}, /*cfx*/
          {-0.2340071533,-0.002670798131,267.8852174,1.781770643,-0.007333307172,0.2120104726}, /*cmy*/
          {0.2214720986,-0.262215471,1.183701138,-0.224879072}, /*cfy*/
          {-2.100545705,0.008518332593,1070.259642,4.287351237,-0.009289306445,0.7614094666}, /*cmz*/
          {1.858026481,0.2900431978,2.034641933,1.426585933} /*cfz*/
     },
     {
          2459249.5,
          {-1.546054073,0.01407971711,1019.322618,4.358909769,-0.0106131457,0.8926889534}, /*cmx*/
          {3.839910604,2.161462434,2.975851099,0.718716064}, /*cfx*/
          {-0.4863957065,0.002934630128,326.9153505,1.825615864,-0.007191211193,0.3164405827}, /*cmy*/
          {3.803253921,3.099546469,4.08558204,0.7061904497}, /*cfy*/
          {-2.164824563,-0.01071450502,1070.610849,4.504635386,-0.01021500638,0.9223355308}, /*cmz*/
          {5.407265724,3.827775424,4.669741592,2.301249601} /*cfz*/
     },
     {
          2459289.5,
          {-1.504969551,0.01718525914,1002.927818,3.849221548,-0.01479080706,0.998797879}, /*cmx*/
          {1.10818923,5.705325848,-0.308327421,1.711892575}, /*cfx*/
          {-0.5579809796,0.005353721955,375.0516449,1.589149904,-0.007156768124,0.3911000432}, /*cmy*/
          {1.097632523,0.1987692814,0.6626423627,1.718916877}, /*cfy*/
          {-2.353569211,-0.02906966327,1070.705718,4.032192591,-0.01548659657,1.079077169}, /*cmz*/
          {2.677811345,1.089665637,1.362587566,3.273729986} /*cfz*/
     },
     {
          2459329.5,
          {-0.8603913215,0.004340739909,990.3452672,2.740828455,-0.02269124907,1.099590786}, /*cmx*/
          {4.689407888,3.012626567,3.052805024,2.777085234}, /*cfx*/
          {-0.3715292067,0.0008467069108,406.7932943,1.106142953,-0.009802937563,0.4659014785}, /*cmy*/
          {4.699649008,3.664101429,3.685128795,2.792712425}, /*cfy*/
          {-2.97962888,-0.02637889637,1070.387341,2.869704751,-0.02404241232,1.210737337}, /*cmz*/
          {-0.02164160841,4.679695455,4.733112613,4.342591321} /*cfz*/
     },
     {
          2459369.5,
          {-0.181100419,-0.006038971079,983.8555054,0.8744698669,-0.02755466225,1.188755658}, /*cmx*/
          {2.04453053,0.3886841238,0.395656979,4.003959343}, /*cfx*/
          {-0.1184700733,-0.002978911644,421.7962442,0.2986243524,-0.01172771073,0.5099673632}, /*cmy*/
          {2.070148667,1.140310785,0.9535704807,4.032245855}, /*cfy*/
          {-3.810892635,-0.004412528235,1070.415134,0.8819096991,-0.02912199371,1.291402154}, /*cmz*/
          {3.619165187,2.04675301,2.050341157,5.584700404} /*cfz*/
     },
     {
          2459409.5,
          {-0.06203353848,0.001995301781,984.1918618,-1.52210874,-0.01250890988,1.280265029}, /*cmx*/
          {5.764949302,4.10691272,4.281548914,5.334029837}, /*cfx*/
          {-0.08798412968,0.0008785220514,420.890311,-0.7378595339,-0.005060743782,0.5348360198}, /*cmy*/
          {5.798546667,4.586482356,5.189591687,5.386102476}, /*cfy*/
          {-4.414217654,0.01326699277,1070.349858,-1.690548399,-0.01200864855,1.39473957}, /*cmz*/
          {1.0575067,5.759689504,5.985583806,0.6116126872} /*cfz*/
     },
     {
          2459449.5,
          {-0.3727251575,0.01972684225,990.8875963,-2.553722499,0.01879018625,1.198517086}, /*cmx*/
          {3.273932199,1.628589725,1.579199613,0.3574640367}, /*cfx*/
          {-0.179340929,0.00793954525,405.4364269,-1.114970969,0.008861714721,0.4845652107}, /*cmy*/
          {3.305994588,2.281465362,2.125340344,0.3633525698}, /*cfy*/
          {-4.205637052,0.007013587688,1070.323229,-2.694000211,0.02007965089,1.31215859}, /*cmz*/
          {4.849447112,3.285268888,3.214053968,1.919321237} /*cfz*/
     },
     {
          2459489.5,
          {-0.1258673842,0.0172245673,997.5840485,-0.9071490241,0.02951744067,1.181625413}, /*cmx*/
          {0.7747641933,5.401345742,5.400991864,1.605486123}, /*cfx*/
          {-0.08149538588,0.006847768036,388.6521395,-0.3667826196,0.01271572766,0.4582266534}, /*cmy*/
          {0.7991208137,6.222228633,6.11212891,1.623749607}, /*cfy*/
          {-3.731928215,-0.005028176359,1070.431255,-0.9243486558,0.0307592504,1.274185552}, /*cmz*/
          {2.348939233,0.7853479492,0.7836915366,3.181718611} /*cfz*/
     },
     {
          2459529.5,
          {0.591298262,0.0008177741344,996.6231359,1.530614627,0.02163921184,1.052413503}, /*cmx*/
          {4.476268696,2.838397768,2.659032466,2.754281717}, /*cfx*/
          {0.2004594276,0.0008546960666,390.4134752,0.6802060392,0.009390495761,0.4350781057}, /*cmy*/
          {4.496761463,3.521777052,3.182936655,2.796627392}, /*cfy*/
          {-3.366405218,0.002226441406,1070.026134,1.61803237,0.0232359773,1.150634811}, /*cmz*/
          {6.049708948,4.5225872,4.282251898,4.315703922} /*cfz*/
     },
     {
          2459569.5,
          {1.177246737,-0.009209870452,988.3577671,3.264195384,0.01189581448,0.9005156667}, /*cmx*/
          {1.809948116,0.1653417278,-0.4398319108,3.831758025}, /*cfx*/
          {0.4632626971,-0.003594648535,410.8547225,1.42143636,0.006950422564,0.3789156568}, /*cmy*/
          {1.835941687,0.7686501052,-0.2788477472,3.86754463}, /*cfy*/
          {-3.120598661,0.01841066505,1070.181012,3.46478602,0.01374598238,0.9763925083}, /*cmz*/
          {3.384491745,1.828411224,1.157811054,5.426424925} /*cfz*/
     },
     {
          2459609.5,
          {1.08326732,-0.004339210755,977.5385035,4.090277399,0.007465146952,0.7558878746}, /*cmx*/
          {5.373462161,3.737181138,2.30356417,4.71931791}, /*cfx*/
          {0.4421004554,-0.001403794976,436.4325426,1.776125353,0.006842764413,0.348425641}, /*cmy*/
          {5.412127593,4.191382222,2.548417199,4.751372295}, /*cfy*/
          {-2.746060444,0.02532500622,1070.321787,4.39987569,0.009369035832,0.8246511582}, /*cmz*/
          {0.6676214555,5.379938186,3.92327883,0.01547566741} /*cfz*/
     },
     {
          2459649.5,
          {0.7377941588,0.006382547015,968.9851788,4.226639881,0.008594332997,0.7037030851}, /*cmx*/
          {2.632379995,1.018474764,4.994692695,5.536454243}, /*cfx*/
          {0.296153967,0.003092310968,455.6518466,1.826155342,0.006812262858,0.3385330644}, /*cmy*/
          {2.687745197,1.300423127,5.476324459,5.605170879}, /*cfy*/
          {-2.253330691,0.009897083849,1070.233396,4.595006344,0.0108204163,0.7955252144}, /*cmz*/
          {4.21343499,2.636658653,0.3665400306,0.8136667038} /*cfz*/
     },
     {
          2459689.5,
          {0.4328673879,0.01234737949,965.5065382,3.814522714,0.01347873164,0.714171662}, /*cmx*/
          {-0.1039919546,4.586580476,1.711052025,0.003230177833}, /*cfx*/
          {0.1442304211,0.004946564403,464.0253963,1.614666299,0.007192702904,0.3426222193}, /*cmy*/
          {-0.03010421871,4.699006314,2.040619612,0.09371443854}, /*cfy*/
          {-1.89423232,-0.01395467344,1070.141488,4.137943127,0.01546367412,0.7774301319}, /*cmz*/
          {1.480680344,-0.1039390959,3.368331807,1.608733718} /*cfz*/
     },
     {
          2459729.5,
          {0.6781453622,0.00370216057,966.0074469,2.811513068,0.02154372807,0.8260364007}, /*cmx*/
          {3.471820539,1.907751445,5.094638932,0.8922199386}, /*cfx*/
          {0.2500978923,7.3288682e-05,462.9410569,1.134913796,0.009687017773,0.3901972781}, /*cmy*/
          {3.564334232,1.876249756,5.111514273,0.9898349899}, /*cfy*/
          {-1.997609061,-0.02660254274,1069.975137,3.01607322,0.02326848478,0.905572626}, /*cmz*/
          {5.059743412,3.466355025,0.3769540112,2.486544813} /*cfz*/
     },
     {
          2459769.5,
          {1.169076974,-0.007709267358,968.0446353,1.050102348,0.02754296063,0.9475041973}, /*cmx*/
          {0.8201817043,5.572800979,2.428718958,2.020647762}, /*cfx*/
          {0.4281489406,-0.004673522416,458.9413888,0.3430795688,0.01164966889,0.4489110917}, /*cmy*/
          {0.9288176368,5.447699637,2.342189362,2.13137206}, /*cfy*/
          {-2.61828158,-0.01628756688,1069.516582,1.098740236,0.02984304161,1.050921969}, /*cmz*/
          {2.410865235,0.8278883905,3.974831044,3.602897046} /*cfz*/
     },
     {
          2459809.5,
          {1.344502074,-0.003561422904,968.0242247,-1.377137394,0.01395343288,1.103516194}, /*cmx*/
          {4.533288128,2.973029136,6.305796884,3.283537541}, /*cfx*/
          {0.4550504249,-0.001165931055,459.1069077,-0.6908913506,0.005151084821,0.5309287864}, /*cmy*/
          {4.650576167,2.904610297,6.454184964,3.396743679}, /*cfy*/
          {-3.454331245,0.00301444227,1069.344787,-1.516021844,0.01519651812,1.209558431}, /*cmz*/
          {6.12574427,4.548769928,1.556482426,4.905866864} /*cfz*/
     },
     {
          2459849.5,
          {0.9901711828,0.01529535361,966.0924172,-2.55431284,-0.01720040346,1.175466984}, /*cmx*/
          {2.040764063,0.4960869993,3.56288489,4.53668951}, /*cfx*/
          {0.2841141818,0.008238694429,463.3773404,-1.105088966,-0.008562074147,0.5674151004}, /*cmy*/
          {2.154551793,0.5193263937,3.547836538,4.643297117}, /*cfy*/
          {-3.899224613,0.007754631147,1069.480678,-2.795555251,-0.01951692456,1.274340865}, /*cmz*/
          {3.632646414,2.074446005,5.153953175,6.129497363} /*cfz*/
     },
     {
          2459889.5,
          {1.107893763,0.02301224554,965.2983577,-1.01502063,-0.02924908697,1.235398063}, /*cmx*/
          {5.829999045,4.282057476,1.135512466,5.835978589}, /*cfx*/
          {0.3661161,0.01129902417,464.9628837,-0.3511168522,-0.01283077984,0.5934969866}, /*cmy*/
          {5.932352362,4.377814955,1.211444553,5.930502861}, /*cfy*/
          {-3.709763685,-0.003491904442,1069.616201,-1.073332509,-0.03190020775,1.357433526}, /*cmz*/
          {1.136695274,5.848857119,2.708309977,1.138243505} /*cfz*/
     },
     {
          2459929.5,
          {1.850041173,0.010599225,964.9225717,1.408222946,-0.02156486739,1.219758651}, /*cmx*/
          {3.252819142,1.720916397,4.685616744,0.7378460639}, /*cfx*/
          {0.7487600633,0.004781924217,464.3994199,0.7165744409,-0.009111338646,0.5871311964}, /*cmy*/
          {3.347734585,1.806315144,4.560410327,0.8354463679}, /*cfy*/
          {-3.372149759,-0.0002890086121,1069.60942,1.556465136,-0.02388804557,1.35213389}, /*cmz*/
          {4.841293187,3.298966765,-0.03602065568,2.335780729} /*cfz*/
     },
     {
          2459969.5,
          {2.703371249,-0.004162678921,966.2037347,3.144702657,-0.0121932235,1.130074802}, /*cmx*/
          {0.5884865776,5.339559007,1.614858794,1.889768151}, /*cfx*/
          {1.16985176,-0.00230152275,461.8265097,1.442176042,-0.006806093772,0.533307664}, /*cmy*/
          {0.6855842461,5.323845096,1.0562531,1.996521107}, /*cfy*/
          {-2.965882924,0.01884838223,1069.50623,3.450527128,-0.01376824729,1.243516226}, /*cmz*/
          {2.177264683,0.618398931,3.116991548,3.469541975} /*cfz*/
     },
     {
          2460009.5,
          {2.991202398,-0.008782326197,971.6040264,4.010731649,-0.007354419532,1.053698782}, /*cmx*/
          {4.153851809,2.629933745,4.447611019,2.915424899}, /*cfx*/
          {1.275345638,-0.004430453224,451.7183907,1.76523938,-0.006959731836,0.4719898845}, /*cmy*/
          {4.261634521,2.456511839,3.874659328,3.027185739}, /*cfy*/
          {-2.440209899,0.03538150918,1069.52782,4.380147856,-0.00930227193,1.155349453}, /*cmz*/
          {5.743665196,4.171678295,-0.3925058415,4.504878598} /*cfz*/
     },
     {
          2460049.5,
          {2.725937678,-0.001509750897,981.596846,4.226912478,-0.008385819129,0.9506559653}, /*cmx*/
          {1.415584794,-0.08571904396,0.8570875102,3.926462289}, /*cfx*/
          {1.104413969,-0.001606489207,429.9899329,1.786057204,-0.007400417977,0.4033969623}, /*cmy*/
          {1.540342825,5.837192798,0.6110179325,4.049412821}, /*cfy*/
          {-1.526077891,0.02857554345,1069.249423,4.565396485,-0.01045032536,1.027795943}, /*cmz*/
          {3.006152489,1.432131571,2.407285909,5.52545175} /*cfz*/
     },
     {
          2460089.5,
          {2.185398161,0.005521882892,995.2618653,3.919792194,-0.0134541908,0.7850958325}, /*cmx*/
          {4.965279977,3.47589038,3.808246403,4.850155967}, /*cfx*/
          {0.8376755761,-0.0002849718465,398.2611218,1.596978546,-0.007584670948,0.2999536311}, /*cmy*/
          {5.112077482,2.918784414,3.547887748,5.050616624}, /*cfy*/
          {-0.6793755702,0.0036981867,1069.281522,4.176930189,-0.01467045473,0.8386274002}, /*cmz*/
          {0.27277289,4.971708945,5.346204767,0.1442424439} /*cfz*/
     },
     {
          2460129.5,
          {1.981622057,0.001229015339,1008.851824,2.953763467,-0.02112669393,0.7181986128}, /*cmx*/
          {2.258482812,0.772853125,0.8276603759,5.698061594}, /*cfx*/
          {0.6868019602,-0.002172908722,363.4063644,1.174929279,-0.009086448707,0.2358142247}, /*cmy*/
          {2.430912128,0.01791571762,0.1994584968,5.84952941}, /*cfy*/
          {-0.1811461309,-0.02192096791,1069.108834,3.139325707,-0.02277955422,0.7539973737}, /*cmz*/
          {3.848990531,2.253578443,2.308607297,1.00136555} /*cfz*/
     },
     {
          2460169.5,
          {2.138310002,-0.00996658378,1017.615522,1.216042838,-0.02845352898,0.7251271299}, /*cmx*/
          {5.88782139,4.430107533,4.425056299,0.3393381182}, /*cfx*/
          {0.6636000487,-0.004856091814,337.897609,0.4568481636,-0.01127033946,0.2403330825}, /*cmy*/
          {6.0841318,3.469171962,3.604709087,0.5445011156}, /*cfy*/
          {-0.4783582004,-0.02440219324,1068.455196,1.28097916,-0.03037571154,0.7608412233}, /*cmz*/
          {1.194697045,5.905405531,5.9065131,1.93350173} /*cfz*/
     },
     {
          2460209.5,
          {2.245041307,-0.008637890324,1018.499977,-1.28989431,-0.01640175064,0.8209284032}, /*cmx*/
          {3.313031654,1.834998609,1.969632806,1.463215459}, /*cfx*/
          {0.6239302577,-0.002235824142,336.1235663,-0.5362022646,-0.006185502739,0.2964390728}, /*cmy*/
          {3.518377161,1.118936893,1.26995721,1.663411178}, /*cfy*/
          {-1.389352279,-0.006721781098,1068.170566,-1.380899793,-0.01755124778,0.8836352208}, /*cmz*/
          {4.903493121,3.299254045,3.503804599,3.013521065} /*cfz*/
     },
     {
          2460249.5,
          {2.002183043,0.009498503704,1010.85834,-2.702349599,0.01729369192,0.9945838914}, /*cmx*/
          {0.8167532143,5.645855598,5.568527294,2.535406709}, /*cfx*/
          {0.5736336029,0.004771749299,358.4878288,-1.054364566,0.007360998432,0.353332785}, /*cmy*/
          {1.007885538,4.958286477,4.931653693,2.707268904}, /*cfy*/
          {-2.319854338,0.003792850288,1068.550566,-2.84938438,0.0180420138,1.081971768}, /*cmz*/
          {2.408640262,0.848471462,0.7667252965,4.13289697} /*cfz*/
     },
     {
          2460289.5,
          {1.985310194,0.0257550164,1002.515575,-1.164980305,0.0298588657,1.123094402}, /*cmx*/
          {4.608339268,3.14116076,3.136906886,3.791958559}, /*cfx*/
          {0.6012347057,0.009644213798,379.7875558,-0.4008567615,0.01213972542,0.4273213869}, /*cmy*/
          {4.77848265,2.363534293,2.530314977,3.954414967}, /*cfy*/
          {-2.466615884,-0.003195057173,1068.831787,-1.225246375,0.03225848289,1.203937949}, /*cmz*/
          {6.200090347,4.630264641,4.630546478,5.385675671} /*cfz*/
     },
     {
          2460329.5,
          {2.651743412,0.019074337,1002.264077,1.303410643,0.02255644133,1.224192494}, /*cmx*/
          {2.036136128,0.590429026,0.4229926905,4.984388627}, /*cfx*/
          {0.8859751581,0.004709086531,379.6199833,0.6211220448,0.009058858959,0.4533192324}, /*cmy*/
          {2.195955302,6.395647002,5.881768642,5.141168432}, /*cfy*/
          {-2.227063133,-0.003957378822,1068.865998,1.448557974,0.02342907033,1.296515313}, /*cmz*/
          {3.626969964,2.083314863,1.910841246,0.2793610627} /*cfz*/
     },
     {
          2460369.5,
          {3.612981896,0.0009657952117,1010.677989,3.098744287,0.01355370355,1.247028243}, /*cmx*/
          {5.661595164,4.209122586,3.616780768,6.100100041}, /*cfx*/
          {1.162062715,-0.003449427936,356.2188325,1.315395306,0.007408613655,0.4065233193}, /*cmy*/
          {5.826797038,3.539966531,2.428674562,6.291481527}, /*cfy*/
          {-1.790537282,0.01360195207,1068.757187,3.344102936,0.01333339907,1.322651073}, /*cmz*/
          {0.9674784666,5.694638083,5.057534898,1.416014365} /*cfz*/
     },
     {
          2460409.5,
          {4.216449264,-0.01212330088,1025.347518,4.040561233,0.009151439861,1.318171835}, /*cmx*/
          {2.951751143,1.485085665,0.1601175451,0.9106505421}, /*cfx*/
          {1.205920953,-0.007567148859,312.5893701,1.675295276,0.007716031257,0.3567785922}, /*cmy*/
          {3.138672342,0.6260959972,5.323695913,1.106029538}, /*cfy*/
          {-1.216368975,0.03428241705,1069.01221,4.267994713,0.008971063478,1.356164742}, /*cmz*/
          {4.538135159,2.967027091,1.578402827,2.496699658} /*cfz*/
     },
     {
          2460449.5,
          {4.012405643,-0.009640678136,1041.524405,4.301858033,0.0100289955,1.276359136}, /*cmx*/
          {0.2212042719,5.025315671,2.944206736,2.0103985}, /*cfx*/
          {0.9205931189,-0.006222897741,253.184482,1.785884342,0.007476006259,0.270660192}, /*cmy*/
          {0.451528985,3.964270615,2.068816772,2.258093384}, /*cfy*/
          {-0.228004798,0.03856171193,1069.051025,4.477218476,0.009586072845,1.295679821}, /*cmz*/
          {1.80437734,0.2279135427,4.363992143,3.585585922} /*cfz*/
     },
     {
          2460489.5,
          {3.321073271,-0.002491033129,1055.578658,4.019282402,0.01423728169,1.132922539}, /*cmx*/
          {3.777024725,2.27102562,-0.4243054008,3.047862722}, /*cfx*/
          {0.6101082251,-0.00422424699,186.800668,1.696746282,0.006987004038,0.1659898855}, /*cmy*/
          {4.088177575,1.031345065,4.91453715,3.487758325}, /*cfy*/
          {0.8501242523,0.0192127094,1069.228344,4.147266423,0.01406531654,1.155584084}, /*cmz*/
          {5.356717007,3.771570157,0.9961340576,4.632080843} /*cfz*/
     },
     {
          2460529.5,
          {2.622318101,-0.001064378157,1064.69836,3.063783934,0.02174381019,1.011074063}, /*cmx*/
          {1.073656038,5.812057124,2.744615704,4.123006884}, /*cfx*/
          {0.3522024981,-0.003235711422,126.9429852,1.339297055,0.009281836544,0.09329186356}, /*cmy*/
          {1.53430613,4.437455465,1.459012824,4.626233803}, /*cfy*/
          {1.768267354,-0.01130699704,1069.248738,3.155095469,0.02245986888,1.01234969}, /*cmz*/
          {2.650143486,1.057075275,4.255121298,5.696407755} /*cfz*/
     },
     {
          2460569.5,
          {2.396063479,-0.01058301868,1068.048163,1.290241812,0.02951925445,0.8541423119}, /*cmx*/
          {4.703584834,3.161528835,0.01729400655,5.194231333}, /*cfx*/
          {0.2561299597,-0.002390390908,90.51419027,0.5967784539,0.01277817596,0.07035142684}, /*cmy*/
          {5.372639737,1.68977661,4.848285421,5.92830464}, /*cfy*/
          {1.883579598,-0.02641759049,1068.790116,1.322955852,0.03033728655,0.8511190092}, /*cmz*/
          {-0.005362364216,4.712933148,1.570762806,0.496739703} /*cfz*/
     },
     {
          2460609.5,
          {2.396126157,-0.01424314628,1068.132304,-1.294532176,0.01796630083,0.744797267}, /*cmx*/
          {2.12784458,0.5502508777,3.909392922,-0.03245077407}, /*cfx*/
          {0.2171548812,-0.0008633810103,87.47205647,-0.53019692,0.007540224655,0.09987106118}, /*cmy*/
          {2.82804865,5.402799342,2.513894143,0.5183953675}, /*cfy*/
          {1.083121397,-0.01476105014,1069.001922,-1.35017579,0.01771587145,0.7451968945}, /*cmz*/
          {3.701740672,2.119795276,5.405061468,1.583522236} /*cfz*/
     },
     {
          2460649.5,
          {2.278589299,0.002457780293,1065.675177,-2.787574784,-0.01698027672,0.8346676809}, /*cmx*/
          {5.913615886,4.408273816,1.176036704,0.8985855825}, /*cfx*/
          {0.2512793419,0.002227487018,117.2508858,-1.171956819,-0.007133929475,0.08902289901}, /*cmy*/
          {0.1294194377,3.010056506,6.049464669,1.264456474}, /*cfy*/
          {-0.002490680577,-0.001365406031,1069.0672,-2.889288113,-0.01814886447,0.8055244486}, /*cmz*/
          {1.206027664,5.931129321,2.701938663,2.468286875} /*cfz*/
     },
     {
          2460689.5,
          {2.070349381,0.02518050352,1060.866389,-1.254736599,-0.03055570632,0.8892018025}, /*cmx*/
          {3.421511263,1.909546308,5.047336492,1.960335281}, /*cfx*/
          {0.2586376767,0.003512818803,151.8704879,-0.5430617836,-0.01296345531,0.1288556505}, /*cmy*/
          {3.788328669,0.4870322444,3.761721515,2.309032414}, /*cfy*/
          {-0.4840251693,-0.002790503501,1069.030336,-1.278088794,-0.03142931133,0.9021447689}, /*cmz*/
          {4.999142129,3.427387463,0.2885366105,3.542900087} /*cfz*/
     },
     {
          2460729.5,
          {2.53920796,0.02502179917,1060.720446,1.27947891,-0.0224586222,1.026938391}, /*cmx*/
          {0.8518851376,5.646244385,2.336876062,3.035962663}, /*cfx*/
          {0.333938848,-6.757776899e-05,152.7987449,0.5441977863,-0.01003591734,0.1447811332}, /*cmy*/
          {1.199166291,4.533631501,0.8775110151,3.42616834}, /*cfy*/
          {-0.4244137598,-0.007510319541,1069.103153,1.326040795,-0.02282439982,1.035135547}, /*cmz*/
          {2.42920234,0.8867544606,3.868050176,4.623345387} /*cfz*/
     },
     {
          2460769.5,
          {3.44998763,0.005096742587,1065.04028,3.086705939,-0.01363246442,1.180369081}, /*cmx*/
          {4.48277199,2.971593264,5.473743913,4.105229564}, /*cfx*/
          {0.3497374837,-0.005454490679,116.5080696,1.329117764,-0.007636289169,0.09060348053}, /*cmy*/
          {4.920172831,1.656765902,3.795807091,4.849686065}, /*cfy*/
          {-0.1474990945,0.004557654944,1068.981863,3.156532579,-0.01357828298,1.159358664}, /*cmz*/
          {6.05801055,4.50776245,0.7606798445,5.670823096} /*cfz*/
     },
     {
          2460809.5,
          {4.195144274,-0.01374489225,1069.67506,4.027660674,-0.009989348686,1.323516787}, /*cmx*/
          {1.779624779,0.2284896301,1.974619712,5.195306425}, /*cfx*/
          {0.1610140805,-0.005829969825,61.25516233,1.757847105,-0.007286223177,0.04182893047}, /*cmy*/
          {2.637728873,5.0585707,0.3780512371,6.805464645}, /*cfy*/
          {0.3155873489,0.02612361479,1069.413829,4.098422727,-0.008821713624,1.335991794}, /*cmz*/
          {3.351985217,1.784831185,3.594513967,0.478267661} /*cfz*/
     },
     {
          2460849.5,
          {4.054022798,-0.01704352402,1069.884193,4.257583814,-0.01012357297,1.364134832}, /*cmx*/
          {5.337818903,3.742776501,4.809537559,-0.002922592847}, /*cfx*/
          {-0.115053317,-0.004016500677,57.46263223,1.88120084,-0.007156513357,0.1073546118}, /*cmy*/
          {1.356426851,2.158543981,3.314451987,2.584591504}, /*cfy*/
          {1.081632836,0.03979226303,1069.630476,4.339857602,-0.008970585888,1.374262732}, /*cmz*/
          {0.6241128276,5.33215983,0.04718037363,1.571315144} /*cfz*/
     },
     {
          2460889.5,
          {3.307814849,-0.009200297367,1064.383712,3.955627241,-0.01376916135,1.355999641}, /*cmx*/
          {2.614165266,0.9790958377,1.414440729,1.072318623}, /*cfx*/
          {-0.2968094348,-0.002344744531,121.8253476,1.739187091,-0.007288432346,0.2118827599}, /*cmy*/
          {5.433770677,5.547629672,-0.1382027475,3.948927773}, /*cfy*/
          {2.139219985,0.02905384771,1069.781151,4.050866616,-0.01415338661,1.34959147}, /*cmz*/
          {4.181238803,2.602680314,2.972716707,2.636764522} /*cfz*/
     },
     {
          2460929.5,
          {2.321404584,-0.003252498147,1055.772341,3.014408691,-0.02222531319,1.281084544}, /*cmx*/
          {-0.08699507084,4.523349386,4.585213394,2.230752116}, /*cfx*/
          {-0.2969143367,-0.002012507811,181.9751908,1.306967403,-0.009593341703,0.247405877}, /*cmy*/
          {2.865787948,2.707149058,2.787779366,5.261153488}, /*cfy*/
          {3.167240563,0.001084570968,1070.113431,3.076340115,-0.02289290961,1.308851541}, /*cmz*/
          {1.478434811,-0.1096625233,-0.05095017639,3.795854277} /*cfz*/
     },
     {
          2460969.5,
          {1.82607399,-0.009170489663,1048.264242,1.1999796,-0.02948624602,1.160920188}, /*cmx*/
          {3.544653436,1.877229585,1.878742286,3.430529168}, /*cfx*/
          {-0.2753979495,0.0009971364406,218.2996342,0.5317938092,-0.01271219925,0.2470442931}, /*cmy*/
          {0.2626824451,0.06463678876,-0.04536786659,0.1514049696}, /*cfy*/
          {3.646680464,-0.02148179789,1070.058205,1.20320443,-0.02983905696,1.190468551}, /*cmz*/
          {5.109550089,3.533726323,3.534219568,4.984293532} /*cfz*/
     },
     {
          2461009.5,
          {1.78409218,-0.01692407178,1047.768195,-1.406857192,-0.01603539707,0.9983866735}, /*cmx*/
          {0.9718151281,5.574133539,5.790241872,4.679703158}, /*cfx*/
          {-0.2662200929,0.003819234309,220.0312476,-0.5898341835,-0.007826464889,0.1918139597}, /*cmy*/
          {3.98252761,3.514111276,4.033670184,1.287617032}, /*cfy*/
          {3.161481924,-0.01787384019,1069.967153,-1.415623333,-0.01688571667,1.005411181}, /*cmz*/
          {2.537504085,0.9450958849,1.128925962,6.219314697} /*cfz*/
     },
     {
          2461049.5,
          {1.715198661,-0.004977586608,1054.35958,-2.775659413,0.01781527241,0.9170562831}, /*cmx*/
          {4.759868447,3.125754936,3.024709958,5.789093672}, /*cfx*/
          {-0.2440194562,0.002719043437,187.3715708,-1.204954334,0.007394219358,0.1602185331}, /*cmy*/
          {1.465151122,1.263410012,1.094915796,2.644032709}, /*cfy*/
          {2.26302546,-0.003831134258,1070.343143,-2.820361101,0.01794246074,0.9549242102}, /*cmz*/
          {6.326210856,4.778183776,4.722016441,1.059565501} /*cfz*/
     },
     {
          2461089.5,
          {1.375170576,0.01603278499,1060.075491,-1.20053766,0.02995445829,0.7983192528}, /*cmx*/
          {2.26651663,0.6331299498,0.6348938597,0.547113454}, /*cfx*/
          {-0.1480261346,-0.002011358623,151.4547368,-0.5535911313,0.01299188958,0.1123687089}, /*cmy*/
          {5.212842096,5.12399472,5.138027608,3.494069221}, /*cfy*/
          {1.5705914,-0.001251469403,1069.885416,-1.206838996,0.03007699059,0.7913830457}, /*cmz*/
          {3.833621974,2.258984261,2.262215176,2.105725693} /*cfz*/
     },
     {
          2461129.5,
          {1.433302427,0.02246734577,1060.23338,1.271172451,0.02146543529,0.7608246786}, /*cmx*/
          {5.979147788,4.375843385,4.195219688,1.466468709}, /*cfx*/
          {-0.1607826912,-0.005658036409,149.9427849,0.5272618458,0.009433283263,0.1146908144}, /*cmy*/
          {2.643963265,2.634232658,2.303301603,4.371801579}, /*cfy*/
          {1.428849597,-0.01001826622,1069.949443,1.288361364,0.0217015588,0.7793388193}, /*cmz*/
          {1.262954003,6.003861341,5.840693592,3.025541684} /*cfz*/
     },
     {
          2461169.5,
          {2.057285286,0.00738054535,1054.328461,3.000441004,0.01251866822,0.8591832265}, /*cmx*/
          {3.328418442,1.699856703,1.063612396,2.329695339}, /*cfx*/
          {-0.2966275519,-0.005327400267,185.0157676,1.287619295,0.006432791674,0.1850197829}, /*cmy*/
          {0.04393618238,-0.1386642788,5.163825985,5.372221624}, /*cfy*/
          {1.466176522,-0.007476518673,1070.024536,3.027441705,0.01295448615,0.8969092353}, /*cmz*/
          {4.894804962,3.336832268,2.799863424,3.900159603} /*cfz*/
     },
     {
          2461209.5,
          {2.726612339,-0.01100593093,1043.208668,3.872968594,0.008723260581,1.051676164}, /*cmx*/
          {0.6277362546,5.253961564,3.873887232,3.313745689}, /*cfx*/
          {-0.605451436,-0.0009726816585,240.2312151,1.647950547,0.006339918401,0.2704274174}, /*cmy*/
          {3.677897709,3.291791956,1.673879894,0.1143400749}, /*cfy*/
          {1.627573325,0.01159722032,1070.265696,3.948914893,0.008144769213,1.062661979}, /*cmz*/
          {2.193951919,0.6245436237,-0.6419957527,4.884918102} /*cfz*/
     },
     {
          2461249.5,
          {2.803819257,-0.01860973449,1028.150547,4.081880375,0.008585475466,1.144224838}, /*cmx*/
          {4.187906478,2.507679868,0.304020067,4.327684132}, /*cfx*/
          {-0.7909865757,0.002764648013,298.8897613,1.709983412,0.006337301227,0.3652511871}, /*cmy*/
          {0.9931071164,0.3997716466,4.635112381,1.137857903}, /*cfy*/
          {1.958399209,0.03176313657,1070.403407,4.199001905,0.008417187863,1.204091309}, /*cmz*/
          {5.754570336,4.17826115,2.013218783,5.885284883} /*cfz*/
     },
     {
          2461289.5,
          {2.211241419,-0.01132731254,1012.068135,3.759690512,0.01350912569,1.242413322}, /*cmx*/
          {1.465477439,6.062230718,3.235770775,5.37244051}, /*cfx*/
          {-0.7563643784,0.001941013318,349.3465415,1.553546965,0.006592086561,0.4629170073}, /*cmy*/
          {4.582345001,3.792408844,1.162113862,2.219751164}, /*cfy*/
          {2.748309979,0.03229672751,1070.368788,3.892682066,0.01386192275,1.348336185}, /*cmz*/
          {3.033459527,1.456074669,4.954360331,0.661325689} /*cfz*/
     },
     {
          2461329.5,
          {1.304102676,-0.00244877515,999.0030541,2.803539198,0.02262756329,1.286366674}, /*cmx*/
          {5.049463247,3.360902275,0.2596531158,0.2572102042}, /*cfx*/
          {-0.4944315884,-0.0004434908693,385.2219742,1.13159531,0.009519297705,0.5092271172}, /*cmy*/
          {1.904862379,0.9658993518,4.122977664,3.407433509}, /*cfy*/
          {3.668731567,0.01130566564,1070.6749,2.906840572,0.0234175007,1.367865963}, /*cmz*/
          {0.3364516292,5.03030197,1.937331743,1.838527465} /*cfz*/
     },
     {
          2461369.5,
          {0.7446538996,-0.004390062884,991.4395962,0.9500796122,0.02789892992,1.280827246}, /*cmx*/
          {2.402182542,0.7320437005,3.880110242,1.483188389}, /*cfx*/
          {-0.325935501,0.001595699989,403.4442045,0.3463352222,0.01185012854,0.5238257109}, /*cmy*/
          {5.556347683,4.715941399,1.396034456,4.644214307}, /*cfy*/
          {4.419045301,-0.01413786128,1070.532806,0.9683425175,0.02929396277,1.386742896}, /*cmz*/
          {3.974806409,2.388460009,5.533124669,3.05874651} /*cfz*/
     },
     {
          2461409.5,
          {0.7767532539,-0.01523278863,991.6329718,-1.495751723,0.01339559386,1.190940405}, /*cmx*/
          {6.120093317,4.446720834,1.498752155,2.752018065}, /*cfx*/
          {-0.3459415815,0.0069308561,402.9250499,-0.7120015955,0.005607633544,0.4714755004}, /*cmy*/
          {2.998663878,1.863378209,5.623121514,5.890791803}, /*cfy*/
          {4.37020771,-0.01784278027,1070.088591,-1.631351094,0.01347585167,1.297187168}, /*cmz*/
          {1.410471462,6.090676882,3.231965631,4.337155565} /*cfz*/
     },
     {
          2461449.5,
          {0.704631376,-0.01182097989,999.3355048,-2.605157164,-0.01814054314,1.19802244}, /*cmx*/
          {3.628719077,1.985422871,5.089681926,4.049456591}, /*cfx*/
          {-0.3126604238,0.005313166057,384.7386011,-1.132049573,-0.008418730433,0.4382494237}, /*cmy*/
          {0.5053662741,5.863597995,2.553479459,0.9548287218}, /*cfy*/
          {3.766813844,-0.001749867057,1070.512069,-2.721513903,-0.01891425446,1.267741357}, /*cmz*/
          {5.202035028,3.645617348,0.4417427185,5.644501642} /*cfz*/
     },
     {
          2461489.5,
          {0.3189982684,0.003381680685,1006.435178,-1.008419315,-0.02777592167,1.011745335}, /*cmx*/
          {1.132134367,5.741228458,2.607255412,5.261270635}, /*cfx*/
          {-0.1261937316,-0.001111169402,364.5825708,-0.4176156759,-0.0118500078,0.3666121752}, /*cmy*/
          {4.283906161,3.508652833,6.563432109,2.131455357}, /*cfy*/
          {3.149600864,0.001723043932,1070.303727,-1.051154902,-0.02917361976,1.087889393}, /*cmz*/
          {2.704003255,1.126276848,4.269664868,0.5551518278} /*cfz*/
     },
     {
          2461529.5,
          {-0.03837886653,0.01381234991,1006.201425,1.292843796,-0.019324518,0.8471192853}, /*cmx*/
          {4.840734164,3.204076303,-0.1176179391,0.06658815775}, /*cfx*/
          {0.01173596506,-0.005693727248,364.764873,0.5626096034,-0.008247977997,0.3067890648}, /*cmy*/
          {1.70572335,0.832309119,3.70401014,3.19694189}, /*cfy*/
          {2.924062958,-0.01236591375,1070.279984,1.347201587,-0.02066491093,0.8884098462}, /*cmz*/
          {0.1289813781,4.874308494,1.541535646,1.645362479} /*cfz*/
     },
     {
          2461569.5,
          {0.1276122645,0.007459465432,998.4686031,2.845229033,-0.01106176086,0.7500362461}, /*cmx*/
          {2.188007307,0.5322025912,3.157384235,0.952236168}, /*cfx*/
          {-0.05368044102,-0.003427261814,385.5314669,1.225074978,-0.005955140299,0.309671275}, /*cmy*/
          {5.341873335,4.399947108,0.3121094558,4.104468184}, /*cfy*/
          {2.757146402,-0.02103838103,1070.402778,3.009832103,-0.01181865768,0.8048855323}, /*cmz*/
          {3.76055461,2.195971394,4.815706217,2.531319776} /*cfz*/
     },
     {
          2461609.5,
          {0.5724339722,-0.005850386739,987.0757411,3.637346185,-0.006761694355,0.7413154544}, /*cmx*/
          {5.770251223,4.118990223,-0.2645956384,1.777614927}, /*cfx*/
          {-0.2652652009,0.001789050704,414.1057085,1.561540738,-0.005785084856,0.3213947611}, /*cmy*/
          {2.653171181,1.571102001,3.16797321,4.964450869}, /*cfy*/
          {2.484165695,-0.007683955878,1070.285915,3.885241134,-0.007988791711,0.8276436891}, /*cmz*/
          {1.061702922,5.777929857,1.316887259,3.343982524} /*cfz*/
     },
     {
          2461649.5,
          {0.8713392796,-0.01336474067,976.3104194,3.846416043,-0.007272543162,0.8159034753}, /*cmx*/
          {3.047784697,1.408546634,2.228909283,2.563878136}, /*cfx*/
          {-0.4328536997,0.005126107664,439.4862878,1.644183681,-0.005595864345,0.3750323841}, /*cmy*/
          {-0.05360850941,4.986255765,-0.2509416585,5.747298267}, /*cfy*/
          {2.25632995,0.01588191532,1070.397743,4.121610395,-0.008629391094,0.8884429436}, /*cmz*/
          {4.6253535,3.04858067,3.947906067,4.153059484} /*cfz*/
     },
     {
          2461689.5,
          {0.6192754034,-0.008067916434,968.8016475,3.508842465,-0.01332244658,0.9790476061}, /*cmx*/
          {0.3269190427,4.99335857,5.236980029,3.516065856}, /*cfx*/
          {-0.3511004105,0.002337252151,455.9469049,1.483257033,-0.006774497255,0.4683353337}, /*cmy*/
          {3.525929281,2.134802975,2.554649921,0.4373804374}, /*cfy*/
          {2.521109551,0.0288585028,1070.413347,3.769173516,-0.01436383609,1.066039521}, /*cmz*/
          {1.908058836,0.321065693,0.5922154755,5.096401254} /*cfz*/
     },
     {
          2461729.5,
          {0.04599989289,0.001444147126,965.6171786,2.523867712,-0.02260176371,1.056246623}, /*cmx*/
          {3.915606967,2.319761131,2.355384889,4.622702398}, /*cfx*/
          {-0.1260028833,-0.001906955265,463.1582483,1.022772127,-0.01016602623,0.5097586628}, /*cmy*/
          {0.8483768713,5.622683248,5.668025522,1.567569891}, /*cfy*/
          {3.177071978,0.01842081034,1070.261676,2.7075143,-0.0244710426,1.188648642}, /*cmz*/
          {5.500305777,3.905173871,3.931943655,6.194891192} /*cfz*/
     },
     {
          2461769.5,
          {-0.4258059001,0.002329398127,965.0641605,0.6432627892,-0.02615595037,1.186749044}, /*cmx*/
          {1.277051722,5.987041172,5.991883302,5.822884827}, /*cfx*/
          {0.04873025589,-0.001221554065,464.6766609,0.174791873,-0.01112882923,0.5727072375}, /*cmy*/
          {4.506999471,3.032712218,2.972938667,2.775240937}, /*cfy*/
          {4.038561473,-0.004256879173,1069.803979,0.6766366543,-0.02884776689,1.300084442}, /*cmz*/
          {2.864607535,1.281985386,1.288884018,1.136335868} /*cfz*/
     },
     {
          2461809.5,
          {-0.3242323704,-0.009173968576,964.8282041,-1.663938936,-0.009434668364,1.242954573}, /*cmx*/
          {5.004892672,3.409094221,3.704480441,0.7960316577}, /*cfx*/
          {-0.03162388862,0.005210550934,464.7162004,-0.8120206362,-0.003691862301,0.5988243251}, /*cmy*/
          {1.958276185,0.376149197,1.1048699,4.029916741}, /*cfy*/
          {4.501783669,-0.01360551405,1069.623749,-1.851151778,-0.009648481635,1.360120362}, /*cmz*/
          {0.3102730136,5.013138412,5.296033309,2.367521166} /*cfz*/
     },
     {
          2461849.5,
          {-0.2995284092,-0.01624570614,966.1629268,-2.398330731,0.01854597968,1.288004349}, /*cmx*/
          {2.516920339,0.9443593472,0.9167991968,2.167192515}, /*cfx*/
          {-0.02876522895,0.00806816207,462.9402963,-1.043317455,-0.009003431232,0.610805399}, /*cmy*/
          {5.749464214,4.318109928,7.380698967,5.397393753}, /*cfy*/
          {4.227640992,0.001595159674,1069.985508,-2.626995789,0.02107535867,1.420263853}, /*cmz*/
          {4.104363384,2.549790344,2.508549698,3.736340301} /*cfz*/
     },
     {
          2461889.5,
          {-0.6825560647,-0.007923837778,967.5807224,-0.7788344935,0.0257948476,1.220102081}, /*cmx*/
          {6.297305399,4.680693352,4.68938005,3.403519577}, /*cfx*/
          {0.1905474311,0.003670682432,458.7455286,-0.2685875746,-0.01125727186,0.5790603181}, /*cmy*/
          {3.237023899,1.882545713,4.957431211,0.3412203661}, /*cfy*/
          {3.834550748,0.006639514177,1069.90582,-0.8179462126,0.02810470643,1.346781936}, /*cmz*/
          {1.59978899,6.307306089,6.30828821,4.988434579} /*cfz*/
     },
     {
          2461929.5,
          {-1.344173361,0.004814044361,967.2403419,1.352778493,0.01789272423,1.081153489}, /*cmx*/
          {3.71624751,2.151945353,1.951991575,4.590118528}, /*cfx*/
          {0.5239614659,-0.002011326196,458.9648451,0.6665093295,-0.007596808098,0.5153724651}, /*cmy*/
          {0.6504944032,5.539336979,2.044474931,1.51767531}, /*cfy*/
          {3.650906881,-0.01008042547,1069.847449,1.488490609,0.01962745877,1.202526577}, /*cmz*/
          {5.300963371,3.756395901,3.560854755,6.16312579} /*cfz*/
     },
     {
          2461969.5,
          {-1.658695289,0.006252516672,965.7608576,2.792819489,0.01019419429,0.986395605}, /*cmx*/
          {1.060095941,5.759431071,5.30934514,5.66183494}, /*cfx*/
          {0.6753655123,-0.002185819027,463.0748398,1.272844567,-0.005379223274,0.4767381269}, /*cmy*/
          {4.280144832,2.794436339,4.994163649,2.604098563}, /*cfy*/
          {3.439030355,-0.02949420339,1069.866345,3.06712316,0.01134564914,1.09020811}, /*cmz*/
          {2.645617864,1.080792105,0.5191006555,0.9645305914} /*cfz*/
     },
     {
          2462009.5,
          {-1.503397243,-0.002642842077,965.1859113,3.556527688,0.00609394742,0.8571286192}, /*cmx*/
          {4.641238323,3.080626578,1.859990825,0.3536309791}, /*cfx*/
          {0.615179928,0.001734247212,464.2624036,1.577397484,-0.005394285581,0.4103568355}, /*cmy*/
          {1.587692569,-0.01548530513,1.50661168,3.592652556}, /*cfy*/
          {2.825305293,-0.02679205111,1069.578471,3.880783614,0.008282026041,0.9469111567}, /*cmz*/
          {-0.0548014222,4.664007703,3.329952824,1.953232292} /*cfz*/
     },
     {
          2462049.5,
          {-1.152808935,-0.008192684803,968.541705,3.774794924,0.007354351945,0.7361974442}, /*cmx*/
          {1.919739901,0.3796094682,4.253293399,1.179432192}, /*cfx*/
          {0.4551788359,0.003007695975,457.9726009,1.626493729,-0.005910747484,0.3386701552}, /*cmy*/
          {5.163820625,3.408892197,4.332906599,4.443838737}, /*cfy*/
          {2.038300188,-0.003872377375,1069.69557,4.105691106,0.009152952449,0.807748381}, /*cmz*/
          {3.509114939,1.931917308,-0.3939012458,2.757594143} /*cfz*/
     },
     {
          2462089.5,
          {-1.100624639,-0.003380055995,975.6561333,3.387295474,0.01374078433,0.743938888}, /*cmx*/
          {5.485523193,3.963118837,1.01165166,1.997084915}, /*cfx*/
          {0.4199632092,-0.000395550539,443.5757393,1.402688215,-0.007046200907,0.328323117}, /*cmy*/
          {2.463966031,0.5394492981,0.9266532515,5.243770484}, /*cfy*/
          {1.577215793,0.02044631486,1069.556653,3.679731039,0.01563292532,0.822050138}, /*cmz*/
          {0.7937774412,5.488878191,2.567195248,3.580634464} /*cfz*/
     },
     {
          2462129.5,
          {-1.282651295,0.00802060192,983.6493025,2.322470557,0.02333768463,0.7933982729}, /*cmx*/
          {2.798717676,1.297619627,4.46189167,2.890411116}, /*cfx*/
          {0.449208438,-0.005465130187,425.9320612,0.9028062042,-0.009909793453,0.3423519363}, /*cmy*/
          {6.078894875,3.998661073,4.089342321,-0.08732439398}, /*cfy*/
          {1.833784708,0.02272257748,1069.063652,2.50866907,0.02585096198,0.8552287463}, /*cmz*/
          {4.391486598,2.805271911,5.972654113,4.502273558} /*cfz*/
     },
     {
          2462169.5,
          {-1.505940561,0.01041976302,988.5657708,0.3631474254,0.02557216269,0.9243605528}, /*cmx*/
          {0.1714378671,4.957811146,1.825954705,4.010159839}, /*cfx*/
          {0.4663417878,-0.004815612378,415.2276476,0.08949204599,-0.01029311876,0.3933528905}, /*cmy*/
          {3.466661409,0.8557838809,1.40110785,1.032483827}, /*cfy*/
          {2.640467245,0.005853189582,1068.687125,0.3613041439,0.02766072738,1.021606875}, /*cmz*/
          {1.764987014,0.2331397099,3.357299013,5.58868765} /*cfz*/
     },
     {
          2462209.5,
          {-1.324651573,-0.002724269111,986.5188566,-1.89080279,0.005439547683,1.11651884}, /*cmx*/
          {3.908977982,2.416088906,5.946564326,5.161125563}, /*cfx*/
          {0.3566206167,0.002058051641,419.8843559,-0.8282808662,-0.001727007965,0.4753220097}, /*cmy*/
          {0.9247762235,-1.083781674,5.958733416,2.164756392}, /*cfy*/
          {3.497143753,-0.005122576662,1068.571846,-2.046617448,0.006347490025,1.230218894}, /*cmz*/
          {5.50373771,3.92231721,1.251346399,0.493885266} /*cfz*/
     },
     {
          2462249.5,
          {-1.129489392,-0.01871509488,980.1751087,-2.302621541,-0.02037939715,1.200753546}, /*cmx*/
          {1.421986364,6.21356752,21.88340627,0.2209973459}, /*cfx*/
          {0.2778687102,0.008889156552,434.1003672,-0.9295604505,-0.009181255054,0.5423995923}, /*cmy*/
          {4.711369239,2.769471666,5.894876891,3.502571751}, /*cfy*/
          {3.598497351,0.006117668496,1069.114261,-2.483827935,-0.02241920463,1.314890439}, /*cmz*/
          {3.016841682,1.46406203,10.86488961,1.83308583} /*cfz*/
     },
     {
          2462289.5,
          {-1.4767684,-0.01657482263,976.1211497,-0.5648271225,-0.02516830433,1.265145103}, /*cmx*/
          {5.19459914,3.685915374,0.5386373265,1.466721925}, /*cfx*/
          {0.4752600474,0.006908036358,442.551401,-0.1519554876,-0.01055775006,0.5740332932}, /*cmy*/
          {2.187723237,0.07690629009,3.41793243,4.740106718}, /*cfy*/
          {3.510258437,0.01173430296,1069.060769,-0.565992335,-0.02717363356,1.383474408}, /*cmz*/
          {0.505157843,5.202730057,2.06897113,3.054428679} /*cfz*/
     },
     {
          2462329.5,
          {-2.295207323,-0.003892841136,976.892265,1.493561371,-0.01795682863,1.243967453}, /*cmx*/
          {2.605705728,1.127069824,4.063304983,2.635057168}, /*cfx*/
          {0.8496259493,0.0009287575723,440.0315178,-0.7185790142,-0.007502082713,0.546977999}, /*cmy*/
          {5.875889392,26.05348801,0.4138084197,5.905656394}, /*cfy*/
          {3.434453208,-0.004303417548,1068.984321,1.68339228,-0.0187397263,1.363021524}, /*cmz*/
          {4.198313286,2.656304041,5.565851108,4.23616184} /*cfz*/
     },
     {
          2462369.5,
          {-3.012677954,0.002941977527,983.1896479,2.93174487,-0.01035951165,1.245758425}, /*cmx*/
          {-0.05459229099,4.737384088,1.07506457,3.78691494}, /*cfx*/
          {1.135265548,-0.002137967243,426.6097583,-1.290958452,-0.005775840604,0.5252061926}, /*cmy*/
          {3.219278893,4.399380196,3.25874875,0.778030194}, /*cfy*/
          {3.249502471,-0.02926080214,1069.118271,3.200894,-0.01112391199,1.35275006}, /*cmz*/
          {1.537003075,-0.02697927891,2.485583264,5.377001991} /*cfz*/
     },
     {
          2462409.5,
          {-3.184589171,-0.001858059824,993.9436048,3.700036506,-0.0069625002,1.176805019}, /*cmx*/
          {3.524743027,2.049264323,3.845093248,4.866701779}, /*cfx*/
          {1.130992091,-0.000669832474,400.612827,-1.556770728,-0.006357583131,0.4515267333}, /*cmy*/
          {0.5282645245,1.541454391,-0.140609981,1.887982391}, /*cfy*/
          {2.540708283,-0.03889515072,1069.047625,3.970593017,-0.007933074808,1.245730653}, /*cmz*/
          {5.11545412,3.545487605,5.298768059,0.1737467462} /*cfz*/
     },
     {
          2462449.5,
          {-2.937678772,-0.005612139941,1008.696139,3.903087037,-0.009000377792,1.038598254}, /*cmx*/
          {0.8040389237,5.614474873,0.06922714943,5.866384878}, /*cfx*/
          {0.9731198692,-0.0006827012126,362.8243118,-1.59365649,-0.006597035867,0.3394994933}, /*cmy*/
          {4.112095493,4.913420401,2.788826294,2.915543153}, /*cfy*/
          {1.424696167,-0.02264702161,1069.106353,4.144152868,-0.009553795614,1.101879483}, /*cmz*/
          {2.39359064,0.8133514262,1.531113928,1.175459153} /*cfz*/
     },
     {
          2462489.5,
          {-2.658683987,-0.001290341818,1024.049971,3.444333398,-0.01581141417,0.9244680853}, /*cmx*/
          {4.373628799,2.891144489,3.077202965,0.6019068305}, /*cfx*/
          {0.7779467294,-0.002844329347,318.1759171,-1.394653054,-0.007209087755,0.268993408}, /*cmy*/
          {1.428675377,1.995103997,-0.7025569878,3.926380889}, /*cfy*/
          {0.3264518729,0.005820503985,1069.017457,3.617232144,-0.0166798635,0.9570954195}, /*cmz*/
          {5.961345844,4.372898307,4.555882167,2.189996712} /*cfz*/
     },
     {
          2462529.5,
          {-2.541838323,0.01292603744,1035.636457,2.227688973,-0.02514784839,0.7766664671}, /*cmx*/
          {1.693771247,0.2084208814,0.2187339296,1.547912467}, /*cfx*/
          {0.6682848578,-0.005977457223,278.1924962,-0.9023389502,-0.01015667741,0.2016376182}, /*cmy*/
          {5.067940673,5.427134551,2.382889405,4.98368879}, /*cfy*/
          {0.03106391442,0.02147495745,1068.528782,2.319103682,-0.02634559155,0.7900451064}, /*cmz*/
          {3.279722135,1.70017744,1.722291987,3.134397505} /*cfz*/
     },
     {
          2462569.5,
          {-2.48744341,0.01911506879,1040.58231,0.1321637913,-0.02570931517,0.7540360431}, /*cmx*/
          {5.359063738,4.037538144,3.907791581,2.503996016}, /*cfx*/
          {0.5631378937,-0.00515511993,259.0113554,-0.06366640315,-0.01007723838,0.1981125572}, /*cmy*/
          {2.475644284,2.158402335,6.017514234,5.937294128}, /*cfy*/
          {0.5884160291,0.01341760258,1068.560834,0.1024911319,-0.02631241675,0.7678613143}, /*cmz*/
          {0.6609615328,5.4016499,5.395098783,4.11608676} /*cfz*/
     },
     {
          2462609.5,
          {-2.199079206,0.004764590113,1037.611645,2.089444856,-0.003564092569,0.933179963}, /*cmx*/
          {2.821157439,4.488524161,2.058291669,3.528810898}, /*cfx*/
          {0.473310048,0.0005400158488,271.0906792,-0.832116882,-0.001510962052,0.2450543256}, /*cmy*/
          {6.213760019,-2.773553075,4.541552614,0.5751118325}, /*cfy*/
          {1.596403015,0.002228985799,1068.407119,-2.227374728,-0.003202432364,0.9299799339}, /*cmz*/
          {4.407170727,2.833839469,3.773171873,5.084313002} /*cfz*/
     },
     {
          2462649.5,
          {-1.715895163,-0.01950637844,1029.140712,2.274363736,-0.02259657672,0.9793282944}, /*cmx*/
          {0.3338350516,2.020377938,8.272909709,4.697875887}, /*cfx*/
          {0.3526633054,0.006848598777,301.6250023,-0.8765796129,0.009124402936,0.3044513726}, /*cmy*/
          {3.696424424,1.084297739,7.421698894,1.785928583}, /*cfy*/
          {2.07296267,0.007633121651,1068.514709,-2.366730462,0.02364232434,1.025153351}, /*cmz*/
          {1.921811235,0.3586861116,6.616208193,6.274307622} /*cfz*/
     },
     {
          2462689.5,
          {-1.954635056,-0.02313917213,1023.374576,0.3647625909,-0.02582192083,1.133164468}, /*cmx*/
          {4.09901313,5.794694078,5.764845895,5.849625372}, /*cfx*/
          {0.4779419059,0.005776860818,319.8722936,-0.127030874,0.01026236935,0.3535563902}, /*cmy*/
          {1.155581412,4.21177537,4.876302988,2.909468576}, /*cfy*/
          {2.232639845,0.01526768874,1068.717186,-0.3601658613,0.02719677783,1.182350494}, /*cmz*/
          {5.687060562,4.082722288,4.10311216,1.161984617} /*cfz*/
     },
     {
          2462729.5,
          {-2.811854063,-0.01047644656,1025.57287,-1.753138158,-0.01830184283,1.257330481}, /*cmx*/
          {1.502273353,3.195969945,2.956300164,0.697486438}, /*cfx*/
          {0.7196799072,-0.000189160458,311.4082104,0.758594991,0.007822746981,0.3525261747}, /*cmy*/
          {4.837950467,-3.845955388,1.806939682,4.041705633}, /*cfy*/
          {2.318309373,0.002960768602,1068.528514,1.870980145,0.01892567209,1.284833387}, /*cmz*/
          {3.089085977,1.555972075,1.268081443,2.274146533} /*cfz*/
     },
     {
          2462769.5,
          {-3.773374747,0.0004273014748,1035.274376,-3.232044205,-0.01104746503,1.351898358}, /*cmx*/
          {5.119523759,0.5121162924,-0.1989786404,1.847216006}, /*cfx*/
          {0.8799092669,-0.00390885957,277.5759079,1.346529137,0.00710148667,0.3289113622}, /*cmy*/
          {2.189006507,5.860767526,4.679803982,5.198905099}, /*cfy*/
          {2.21325047,-0.02357970293,1068.900488,3.38532733,0.0112154185,1.394527754}, /*cmz*/
          {0.4208404009,5.142528442,4.426212767,3.426475253} /*cfz*/
     },
     {
          2462809.5,
          {-4.185171586,6.630038228e-05,1048.324776,-3.968949524,-0.008888212489,1.38239124}, /*cmx*/
          {2.411633785,4.070427532,2.569032722,2.930366215}, /*cfx*/
          {0.7713735931,-0.004738494671,223.18749,1.674963436,0.007153654065,0.2538774042}, /*cmy*/
          {5.810061741,2.950827039,1.336065388,0.1177746633}, /*cfy*/
          {1.622347812,-0.04320571558,1069.078912,4.131216965,0.007766682359,1.41607434}, /*cmz*/
          {3.99328157,2.419724822,0.8951646937,4.51144105} /*cfz*/
     },
     {
          2462849.5,
          {-4.056172782,-0.003522923588,1060.445786,-4.095029847,-0.01089527272,1.378730278}, /*cmx*/
          {5.972224737,1.316477373,5.240983829,3.994055483}, /*cfx*/
          {0.5393908544,-0.004435615084,156.5692869,1.766447942,0.006644016379,0.1454497943}, /*cmy*/
          {3.189718746,0.02431932331,4.173973968,1.363380816}, /*cfy*/
          {0.4355434618,-0.0356677729,1069.072885,4.241659249,0.01077472054,1.362732286}, /*cmz*/
          {1.267062235,5.973067507,3.481343659,5.572029337} /*cfz*/
     },
     {
          2462889.5,
          {-3.604072528,-0.0003077045259,1068.020174,-3.534029073,-0.01742436136,1.269994287}, /*cmx*/
          {3.258893063,4.844569441,1.907961137,5.133996912}, /*cfx*/
          {0.2935475347,-0.004617640966,92.55492295,1.560269079,0.007855393503,0.07653993161}, /*cmy*/
          {0.7298456996,3.41673447,0.622931635,2.705096602}, /*cfy*/
          {-0.9526972118,-0.009719356788,1069.340967,3.629575659,0.01797676943,1.272756069}, /*cmz*/
          {4.833209691,3.24617652,0.2677529773,0.4170238144} /*cfz*/
     },
     {
          2462929.5,
          {-3.308899889,0.01402942282,1070.2563,-2.189677636,-0.02634176505,1.093917675}, /*cmx*/
          {0.5814179878,2.145054413,5.298236946,6.24304193}, /*cfx*/
          {0.1435771829,-0.002538434438,55.41503407,0.9896368326,0.01133288556,0.05985613087}, /*cmy*/
          {4.926821976,0.6176367794,3.774108296,4.572814408}, /*cfy*/
          {-1.755998027,0.01470212793,1069.322395,2.222750167,0.02660387394,1.10793915}, /*cmz*/
          {2.152934758,0.5656653632,3.716722677,1.524249472} /*cfz*/
     },
     {
          2462969.5,
          {-3.072824186,0.02369627747,1070.224306,0.04025420947,-0.0253294792,0.9505203721}, /*cmx*/
          {4.250807933,4.812854767,2.7329352,1.111022977}, /*cfx*/
          {0.06583707654,0.0003832223293,51.30039083,0.04260277333,0.01117589409,0.05481394387}, /*cmy*/
          {2.754713613,4.817096315,1.18412536,5.784011289}, /*cfy*/
          {-1.59970816,0.01577915877,1069.247323,-0.01766859042,0.02603753363,0.9458574239}, /*cmz*/
          {5.821601793,3.436947457,1.142398601,2.670603671} /*cfz*/
     },
     {
          2463009.5,
          {-2.74053734,0.01131716949,1070.215988,-2.243841975,-0.003493937153,0.8989844036}, /*cmx*/
          {1.717125092,50.41012759,1.483729045,2.176092127}, /*cfx*/
          {0.0604967816,0.00259536799,52.88505989,0.9395355754,-0.001769358341,0.02414289527}, /*cmy*/
          {-0.1207529949,11.18501906,9.23402472,-0.4495675465}, /*cfy*/
          {-0.7668330457,0.005508396103,1069.438914,2.276677038,0.002024874793,0.9415259781}, /*cmz*/
          {3.288766259,99.12127293,5.860778759,3.743404221} /*cfz*/
     },
     {
          2463049.5,
          {-2.073869933,-0.01362907752,1069.059084,-2.273783109,0.02458806555,0.7976855044}, /*cmx*/
          {5.513582631,3.984847785,-40.02124456,3.201699497}, /*cfx*/
          {0.1035951229,0.002046565813,75.82379356,0.9855321174,0.01040163282,0.07604213126}, /*cmy*/
          {3.102172369,2.500620106,5.672178718,0.726020693}, /*cfy*/
          {-0.006407818336,0.004753967953,1069.230242,2.327257342,-0.02521776725,0.7963295096}, /*cmz*/
          {0.8036629791,2.386605341,14.9367803,4.78396488} /*cfz*/
     },
     {
          2463089.5,
          {-2.039325238,-0.02225004882,1067.312715,-0.2022077603,0.02715391367,0.8666708271}, /*cmx*/
          {2.990859348,1.392355254,-4.8564918,4.186376453}, /*cfx*/
          {0.1502207896,-0.000100589736,95.28136456,0.1283421998,0.0117328209,0.07615791899}, /*cmy*/
          {0.3910453938,5.727483483,3.130743619,1.670956242}, /*cfy*/
          {0.2749795399,0.01504979104,1069.264215,0.202778953,-0.02762771255,0.877606264}, /*cmz*/
          {4.565090792,6.060061049,6.113193453,5.754897814} /*cfz*/
     },
     {
          2463129.5,
          {-2.694670612,-0.01130608516,1068.019254,2.032983751,0.01865671252,1.021070292}, /*cmx*/
          {0.3871711299,5.160864866,4.820548303,5.151149406}, /*cfx*/
          {0.1751216774,-0.004056280849,81.28767018,0.8583840028,0.00896538939,0.04513679548}, /*cmy*/
          {4.143333114,6.944152164,0.07798496255,2.795740128}, /*cfy*/
          {0.4672117228,0.01118867935,1069.228991,-2.054414776,-0.01922224474,1.039782064}, /*cmz*/
          {1.960457628,3.557975331,3.277849832,0.4502094262} /*cfz*/
     },
     {
          2463169.5,
          {-3.584680007,0.001639033723,1070.089575,3.539323144,0.01204273699,1.1948818}, /*cmx*/
          {3.996995749,2.446057674,1.526129287,-0.05145249715}, /*cfx*/
          {0.02453779109,-0.005353679556,46.58031701,1.527829804,0.007470626491,0.05092182064}, /*cmy*/
          {2.086457151,4.102192044,2.943733882,4.864984782}, /*cfy*/
          {0.5004486768,-0.0122011927,1069.542187,-3.582183095,-0.01128252999,1.172442968}, /*cmz*/
          {5.568269094,0.8634043088,0.1004876517,1.521336076} /*cfz*/
     },
     {
          2463209.5,
          {-4.072779721,0.006436116823,1069.026851,4.228183771,0.009853174003,1.316768181}, /*cmx*/
          {1.281902442,5.965541246,4.320741742,0.9802233786}, /*cfx*/
          {-0.2260801117,-0.005401055719,69.88977425,1.862901787,0.007406002545,0.1412444631}, /*cmy*/
          {6.953757547,1.217067563,-0.5213419828,6.850943953}, /*cfy*/
          {0.2184233562,-0.03784237394,1069.739385,-4.304447747,-0.008320037483,1.319814413}, /*cmz*/
          {2.850837542,4.419932869,2.773502958,2.545983086} /*cfz*/
     },
     {
          2463249.5,
          {-3.93278511,0.001513320918,1061.974685,4.263066905,0.01168018155,1.391152153}, /*cmx*/
          {4.836047503,3.195269624,0.7538538486,2.036781879}, /*cfx*/
          {-0.5012774522,-0.004728807239,140.4477728,1.859409818,0.00724283366,0.239195233}, /*cmy*/
          {4.581921371,4.591661103,2.324747216,1.901550329}, /*cfy*/
          {-0.7520369393,-0.04079440495,1069.770674,-4.3281154,-0.01134416728,1.434601311}, /*cmz*/
          {0.1193622583,1.68771467,-0.7741141469,3.602504139} /*cfz*/
     },
     {
          2463289.5,
          {-3.373109706,0.0007377764089,1050.868871,3.617514477,0.01814794744,1.38220967}, /*cmx*/
          {2.11742272,0.442359072,3.765663728,3.174802797}, /*cfx*/
          {-0.5969135032,-0.003846212259,207.5137641,1.544240698,0.008062210167,0.3002784278}, /*cmy*/
          {1.972405716,1.71199884,5.148877177,3.053547712}, /*cfy*/
          {-2.081661644,-0.02067618538,1070.212892,-3.681926914,-0.01828696593,1.401920794}, /*cmz*/
          {3.682731012,5.240069063,2.276765131,4.751912643} /*cfz*/
     },
     {
          2463329.5,
          {-2.948736266,0.009494783417,1040.083032,2.201789384,0.02599453715,1.328466488}, /*cmx*/
          {5.718888231,4.029958064,0.9005836246,4.33119349}, /*cfx*/
          {-0.6564831439,0.0007993238697,254.7136167,0.9366509335,0.01107507061,0.3472452377}, /*cmy*/
          {5.620981437,5.226536622,2.035002765,4.231521237}, /*cfy*/
          {-3.219195647,0.007853280078,1070.323685,-2.258991756,-0.02688996991,1.357738751}, /*cmz*/
          {1.001074526,2.554173369,5.702493957,5.897153552} /*cfz*/
     },
     {
          2463369.5,
          {-2.707994427,0.02089418666,1034.971851,0.02755055547,0.02570831414,1.229216838}, /*cmx*/
          {3.103112004,2.364386389,4.621730009,5.57277787}, /*cfx*/
          {-0.6536394238,0.006284461881,273.4291778,-0.08828351202,0.01100092916,0.3185683445}, /*cmy*/
          {3.024806034,0.9687928067,5.75720452,5.471738404}, /*cfy*/
          {-3.459534549,0.0161100112,1070.0123,0.0405787903,-0.02641751149,1.274472598}, /*cmz*/
          {4.668898488,17.14836784,3.151295702,0.8557908247} /*cfz*/
     },
     {
          2463409.5,
          {-2.437797016,0.01486283538,1038.989147,-2.243771234,0.002130611879,1.213641468}, /*cmx*/
          {0.5694922273,68.03510887,3.159622911,0.5487220681}, /*cfx*/
          {-0.5759424106,0.005611345064,259.643343,0.972874368,0.002853910268,0.2701496617}, /*cmy*/
          {0.4914804086,47.09158304,-1.70893364,0.5271523079}, /*cfy*/
          {-2.916591692,0.003640289834,1070.183479,2.281498854,-0.003086883298,1.214505417}, /*cmz*/
          {2.135999651,53.9701937,1.58776741,2.13998634} /*cfz*/
     },
     {
          2463449.5,
          {-1.90243042,-0.003316477953,1046.974569,-2.305433083,-0.02598376803,0.9573245333}, /*cmx*/
          {4.367896444,2.726187662,12.13859491,1.750187529}, /*cfx*/
          {-0.3465647814,-7.01283478e-05,224.2139807,1.002003604,-0.01084448826,0.1973629817}, /*cmy*/
          {4.274093585,0.796529423,7.039056788,1.555629656}, /*cfy*/
          {-2.12395298,-0.001615347208,1070.285662,2.34797012,-0.02630306418,0.9720703241}, /*cmz*/
          {5.93464464,1.237227546,13.788425,3.310548925} /*cfz*/
     },
     {
          2463489.5,
          {-1.559910111,-0.01369904078,1051.16984,-0.1240238857,-0.02804855534,0.8304540114}, /*cmx*/
          {1.845116648,-0.07621851346,3.295631741,2.795636762}, /*cfx*/
          {-0.2528781427,-0.004032957835,202.6104767,0.07691321502,-0.01208325489,0.1619381228}, /*cmy*/
          {1.736614981,4.391099649,4.524853679,2.649122924}, /*cfy*/
          {-1.901556386,0.012309817,1070.105707,0.1294935721,-0.02866394597,0.8366838968}, /*cmz*/
          {3.412023536,4.766773853,4.942365487,4.372957254} /*cfz*/
     },
     {
          2463529.5,
          {-1.776838861,-0.006475245464,1048.023394,-2.170183457,-0.01890783189,0.8125200244}, /*cmx*/
          {5.519474352,7.031661405,0.4221958788,3.659208882}, /*cfx*/
          {-0.3132795545,-0.004268333738,217.7687116,0.9290816554,-0.008310000772,0.1937709212}, /*cmy*/
          {5.424091291,-1.148946742,1.406151236,3.614160085}, /*cfy*/
          {-1.724956674,0.01999757631,1070.104204,2.228179548,-0.01899204543,0.8148466251}, /*cmz*/
          {0.8033455888,-0.7480152181,2.110210511,5.221648621} /*cfz*/
     },
     {
          2463569.5,
          {-2.219541626,0.004808770368,1037.701142,-3.655308618,-0.01159135777,0.829613205}, /*cmx*/
          {2.838026585,4.324086271,3.434256305,4.548235872}, /*cfx*/
          {-0.5460760155,-0.002161133621,262.4020625,1.559565512,-0.007148164986,0.2271173355}, /*cmy*/
          {2.773469026,2.313019277,4.137483888,4.489366138}, /*cfy*/
          {-1.473109613,0.004320560636,1070.164095,3.766534451,-0.0113063121,0.8844461994}, /*cmz*/
          {4.405144097,2.843895585,5.128707009,-0.1790983055} /*cfz*/
     },
     {
          2463609.5,
          {-2.617442789,0.01070889499,1022.270538,-4.311808846,-0.008490716417,0.9784025635}, /*cmx*/
          {0.1141186323,1.576504279,-0.1929026289,5.396460539}, /*cfx*/
          {-0.8015909256,0.0002032684176,318.1975153,1.808923566,-0.007257356104,0.3382401348}, /*cmy*/
          {0.08038030457,5.69411693,0.7395985692,5.361646608}, /*cfy*/
          {-1.323776562,-0.02196867367,1070.408054,4.453234783,-0.009106971843,1.027865907}, /*cmz*/
          {1.681910584,0.1103438563,1.530785548,0.6830407762} /*cfz*/
     },
     {
          2463649.5,
          {-2.488691071,0.0050914998,1004.730133,-4.248697176,-0.01091538148,1.129960818}, /*cmx*/
          {3.659177168,5.122636779,2.601620792,0.08864566091}, /*cfx*/
          {-0.9207220903,-0.001065377999,369.3429128,1.773298189,-0.006980183328,0.4481782296}, /*cmy*/
          {3.651874502,2.77777342,3.645850618,0.1021165984}, /*cfy*/
          {-1.761720098,-0.03606567863,1070.628253,4.41829927,-0.0110035531,1.198028219}, /*cmz*/
          {5.228957357,3.648469135,4.335144582,1.662753963} /*cfz*/
     },
     {
          2463689.5,
          {-2.014565806,2.971690743e-05,990.0601172,-3.594404981,-0.01714458636,1.174674833}, /*cmx*/
          {0.932533154,2.404576502,-0.5486778965,1.174611197}, /*cfx*/
          {-0.8450862839,-0.002102970096,407.341633,1.483124114,-0.007912182837,0.4983262554}, /*cmy*/
          {0.9476647443,-0.1033394138,0.1935275477,1.203025752}, /*cfy*/
          {-2.722750393,-0.0252566695,1070.679249,3.779642494,-0.01777818442,1.292974439}, /*cmz*/
          {2.505511423,0.9172553263,1.106672792,2.735513797} /*cfz*/
     },
     {
          2463729.5,
          {-1.528243844,0.001781486559,980.6603429,-2.274188358,-0.02502930594,1.269485538}, /*cmx*/
          {4.526501623,6.004908881,2.876010752,2.302959293}, /*cfx*/
          {-0.7261440053,-0.0001427338003,429.8697266,0.8986756095,-0.01084268947,0.5658138235}, /*cmy*/
          {4.560301287,3.399927781,3.363909524,2.343302234}, /*cfy*/
          {-3.895300509,0.0002174099808,1070.473768,2.391842546,-0.02672544068,1.396095281}, /*cmz*/
          {6.102702265,4.512587371,4.523659799,3.885493511} /*cfz*/
     },
     {
          2463769.5,
          {-1.328388532,0.01208532369,976.6792823,-0.1855621998,-0.02582145673,1.294223694}, /*cmx*/
          {1.903428477,3.515384934,0.3025183229,3.552348139}, /*cfx*/
          {-0.6876826089,0.005671918665,438.1376549,-0.06950055139,-0.01092870088,0.5796143003}, /*cmy*/
          {1.950670392,18.20132354,0.8097630269,3.599681103}, /*cfy*/
          {-4.456149912,0.01307521461,1070.052652,0.1569027039,-0.0275689117,1.414501786}, /*cmz*/
          {3.482094913,2.1076544,1.949268524,5.129295859} /*cfz*/
     },
     {
          2463809.5,
          {-1.230844987,0.01564825756,978.9004016,2.05915503,-0.004149929562,1.315311189}, /*cmx*/
          {5.649231791,0.8736957773,4.479551605,4.914314606}, /*cfx*/
          {-0.6379280483,0.007172210598,433.8996405,-0.9662575698,-0.002316037342,0.5646746236}, /*cmy*/
          {5.701852467,17.0418133,12.18872816,4.980075571}, /*cfy*/
          {-4.230438008,0.0007000257721,1070.333055,2.286488324,-0.003394102425,1.453027814}, /*cmz*/
          {0.9449771506,8.800332258,6.537136597,6.468838793} /*cfz*/
     },
     {
          2463849.5,
          {-1.005108944,0.006410624609,985.3507383,2.305270994,-0.02509186074,1.167864347}, /*cmx*/
          {3.166612484,4.674397845,4.669443323,6.140142927}, /*cfx*/
          {-0.4763070731,0.002798465682,418.9386542,-0.9888357211,0.01142186092,0.4949571811}, /*cmy*/
          {3.214929331,2.142343854,8.358367466,6.177796651}, /*cfy*/
          {-3.642239881,-0.00820965424,1070.332462,2.456472265,0.02729125617,1.28802329}, /*cmz*/
          {4.744696435,6.327925528,9.449499484,1.442211409} /*cfz*/
     },
     {
          2463889.5,
          {-0.4436785708,-0.005106276096,989.5430035,0.1630355319,-0.02797208833,1.047993359}, /*cmx*/
          {0.6481292269,1.892953159,2.091008206,1.085916149}, /*cfx*/
          {-0.230669565,-0.002209206119,407.9758592,-0.03000443879,0.01185713275,0.4371397758}, /*cmy*/
          {0.6884560931,6.551008606,5.842755864,1.111443667}, /*cfy*/
          {-3.534850023,0.005443350282,1070.216383,0.1556361234,0.02988133492,1.141986874}, /*cmz*/
          {2.224808274,3.624367661,0.6170286195,2.651431527} /*cfz*/
     },
     {
          2463929.5,
          {-0.1843480873,-0.003649782125,986.7667807,2.139325911,-0.01799734245,0.9340226595}, /*cmx*/
          {4.321881025,2.684137493,5.574795945,2.133472453}, /*cfx*/
          {-0.1339006807,-0.001443907544,415.1266487,-0.9528902464,0.008138657446,0.4078840288}, /*cmy*/
          {4.360419561,25.25546623,2.761574349,2.201445774}, /*cfy*/
          {-3.515872649,0.02464250394,1070.127042,2.278480783,0.01973148679,1.029273938}, /*cmz*/
          {5.8984409,-1.933912577,4.051778844,3.715939612} /*cfz*/
     },
     {
          2463969.5,
          {-0.2061162602,0.006093424916,978.3646077,3.581916678,-0.009891778556,0.7932582423}, /*cmx*/
          {1.63580743,0.005184686828,2.347827971,3.079065279}, /*cfx*/
          {-0.146035174,0.002647886641,434.4687509,-1.573181479,0.006767316771,0.3551588521}, /*cmy*/
          {1.681592951,3.618641207,-0.7728014648,3.123955501}, /*cfy*/
          {-3.067802906,0.02221621379,1069.911424,3.841368917,0.01204220956,0.859690198}, /*cmz*/
          {3.214054121,1.657745086,0.7543256276,4.670392863} /*cfz*/
     },
     {
          2464009.5,
          {-0.4311707661,0.01143088977,970.0800561,4.203063625,-0.007166079966,0.7471433384}, /*cmx*/
          {5.189785177,3.573543323,4.924422785,3.829226942}, /*cfx*/
          {-0.26854771,0.004970024506,453.3809012,-1.836328307,0.006710702959,0.3566846345}, /*cmy*/
          {5.24921401,0.7436079327,2.057583423,3.891626158}, /*cfy*/
          {-2.463557829,0.0009416843143,1070.238062,4.529696493,0.009474399344,0.8361983398}, /*cmz*/
          {0.4878762065,5.197905283,3.470295194,5.401451283} /*cfz*/
     },
     {
          2464049.5,
          {-0.4044648822,0.006159110855,965.6347283,4.131437282,-0.009201952728,0.805781698}, /*cmx*/
          {2.447007631,0.8574861691,1.501464478,4.617320354}, /*cfx*/
          {-0.2607279777,0.001616295002,463.3333238,-1.781902027,0.006664973978,0.3891596097}, /*cmy*/
          {2.523603041,4.1400059,5.025039658,4.703235378}, /*cfy*/
          {-2.11888381,-0.02305346072,1070.19337,4.49434078,0.01094376651,0.897232319}, /*cmz*/
          {4.032271659,2.449108795,0.01439830939,-0.07736886627} /*cfz*/
     },
     {
          2464089.5,
          {-0.1348967887,-0.00296332512,966.2318508,3.574424852,-0.01530445371,0.8956151726}, /*cmx*/
          {6.000105612,4.439586543,4.651307718,5.518111126}, /*cfx*/
          {-0.1668820675,-0.003142736391,462.7388048,-1.49381366,0.007684374225,0.4242057474}, /*cmy*/
          {6.095381957,1.272905266,1.649978213,5.634253585}, /*cfy*/
          {-2.46752682,-0.02504666911,1069.74792,3.896376902,0.01754651626,0.9764986006}, /*cmz*/
          {1.305652588,6.004666352,3.09703407,0.8385535709} /*cfz*/
     },
     {
          2464129.5,
          {0.2678522583,-0.006096371313,969.9843113,2.394591196,-0.02416470162,1.073727574}, /*cmx*/
          {3.306433566,1.761061062,1.774687966,0.3113167466}, /*cfx*/
          {-0.03343948662,-0.003746698476,455.6978471,-0.9390876811,0.01058302494,0.4966552651}, /*cmy*/
          {3.420102893,4.737373013,4.789687651,0.4282814228}, /*cfy*/
          {-3.357841363,-0.008160972254,1069.627936,2.575436164,0.02654206301,1.178937229}, /*cmz*/
          {4.897678256,3.301749269,0.1760462486,1.895052384} /*cfz*/
     },
     {
          2464169.5,
          {0.3711003683,0.004196969614,972.5067655,0.3823115362,-0.02663042495,1.190209217}, /*cmx*/
          {0.6765587247,5.488718102,5.458220616,1.495798756}, /*cfx*/
          {-0.05046867721,0.00215521592,450.0538993,-0.05751936869,0.01090024733,0.5504344472}, /*cmy*/
          {0.805011583,1.893211761,2.153000721,1.622802897}, /*cfy*/
          {-4.094461484,0.006223402143,1069.020038,0.3644620364,0.02876043593,1.309039265}, /*cmz*/
          {2.26974036,0.7467828518,3.86577089,3.093999374} /*cfz*/
     },
     {
          2464209.5,
          {0.2976477104,0.01599270448,971.2268345,-1.97584689,-0.005793377195,1.274390927}, /*cmx*/
          {4.41553095,2.876812232,3.382477394,2.827772266}, /*cfx*/
          {-0.1103313025,0.007968707954,452.8173402,-0.9153349297,0.002227239786,0.6058292497}, /*cmy*/
          {4.549072729,-41.23572521,7.055490196,2.957875056}, /*cfy*/
          {-4.213325742,-0.002160149904,1069.22451,-2.159019131,0.005982217544,1.37681306}, /*cmz*/
          {6.010241693,4.443798158,1.710195257,4.44798394} /*cfz*/
     },
     {
          2464249.5,
          {0.323709148,0.01285563359,968.0316206,-2.371523355,-0.02416462619,1.296963959}, /*cmx*/
          {1.933130126,0.4057912491,3.525224648,4.083111029}, /*cfx*/
          {-0.06398660552,0.006055167027,459.9496262,-0.9811025923,-0.01118056157,0.6214436499}, /*cmy*/
          {2.059033376,-5.914916865,9.767912578,4.202239313}, /*cfy*/
          {-4.060014457,-0.01248067795,1069.504504,-2.571949291,0.02689891169,1.408656927}, /*cmz*/
          {3.527039694,1.981167712,14.54391282,5.659317202} /*cfz*/
     },
     {
          2464289.5,
          {0.9333623647,0.002364221031,966.3626849,-0.3045053849,-0.02854763398,1.241600871}, /*cmx*/
          {5.703105919,4.076636028,0.980900559,5.343715458}, /*cfx*/
          {0.2486737092,0.001227037303,462.4977235,-0.03679990511,-0.01224815847,0.5921152787}, /*cmy*/
          {5.816954775,3.446290402,0.9409159611,5.449937024}, /*cfy*/
          {-4.02065656,-0.002949021048,1069.220519,-0.268714006,0.03057335671,1.372845977}, /*cmz*/
          {1.012023239,5.603524455,5.690146764,0.6597320305} /*cfz*/
     },
     {
          2464329.5,
          {1.556939519,-0.001002795311,967.1160906,2.0146079,-0.01835249301,1.206815016}, /*cmx*/
          {3.097962393,1.573259933,4.472261783,0.236998393}, /*cfx*/
          {0.5487570379,-2.685647659e-05,460.6907647,-0.9722123174,-0.007910801421,0.5726404449}, /*cmy*/
          {3.206762546,-26.71536206,4.119049796,0.3491205913}, /*cfy*/
          {-4.107289607,0.02164492102,1069.376689,2.238697332,0.01981634373,1.326198107}, /*cmz*/
          {4.688800035,3.136572484,2.854794159,1.827608971} /*cfz*/
     },
     {
          2464369.5,
          {1.836457491,0.006213045043,970.933051,3.481713503,-0.01020711677,1.064876911}, /*cmx*/
          {0.4146295659,5.184188671,1.279399502,1.307749616}, /*cfx*/
          {0.6791419281,0.003193526152,452.4490388,-1.563182786,-0.00679034941,0.4831179034}, /*cmy*/
          {0.5283766292,1.899268969,0.5462639032,1.435770238}, /*cfy*/
          {-3.620308126,0.0342782603,1069.268721,3.802946592,0.01182461324,1.162540802}, /*cmz*/
          {2.005443192,0.4431556534,-0.4041976891,2.891702013} /*cfz*/
     },
     {
          2464409.5,
          {1.81247375,0.01097670245,979.9365057,4.152112951,-0.007700634503,0.9591127878}, /*cmx*/
          {3.972063964,2.472480909,3.951914926,2.244620317}, /*cfx*/
          {0.6652101515,0.003662380048,433.5838828,-1.785611276,-0.007542289532,0.4017587732}, /*cmy*/
          {4.0988555,5.297761732,3.447664343,2.370068266}, /*cfy*/
          {-2.725303092,0.02355869042,1069.401287,4.505564072,0.009106475789,1.042095517}, /*cmz*/
          {5.563418583,3.987928869,2.291354316,3.845046411} /*cfz*/
     },
     {
          2464449.5,
          {1.716279869,0.007293386652,993.5351505,4.166072135,-0.00905386309,0.8315603692}, /*cmx*/
          {1.233674922,6.029081258,0.5197043252,3.147360656}, /*cfx*/
          {0.5952895844,0.0002990260571,402.6360786,-1.729296644,-0.007249372121,0.3252657242}, /*cmy*/
          {1.380003843,2.368896251,0.2101946451,3.305133556}, /*cfy*/
          {-1.675939001,-0.002984812327,1069.226917,4.489477413,0.01066027691,0.8956512342}, /*cmz*/
          {2.82499194,1.2433061,5.133319559,4.730981647} /*cfz*/
     },
     {
          2464489.5,
          {1.75819742,-0.005492169247,1008.736672,3.702619536,-0.01514026278,0.7563184486}, /*cmx*/
          {4.790422869,3.309867477,3.559419448,3.964217246}, /*cfx*/
          {0.5631581232,-0.005179840025,363.4257676,-1.491739497,-0.007473251052,0.24930686}, /*cmy*/
          {4.962159169,5.730937952,3.102251918,4.200270491}, /*cfy*/
          {-1.256923091,-0.01913456426,1068.806116,3.925049774,0.0165124639,0.7875740521}, /*cmz*/
          {0.09739541353,4.800408061,1.938449551,5.544823989} /*cfz*/
     },
     {
          2464529.5,
          {1.947119116,-0.01335532647,1021.905351,2.562742359,-0.02449086931,0.8482262193}, /*cmx*/
          {2.097538901,0.6096489304,0.6235991799,4.861367157}, /*cfx*/
          {0.4965622047,-0.005745797059,325.6399105,-1.020564913,-0.01012611925,0.2563378009}, /*cmy*/
          {2.298614182,2.852599062,-0.1716835477,5.029180522}, /*cfy*/
          {-1.609060651,-0.01485444133,1068.851033,2.693866645,0.02595643272,0.8923933308}, /*cmz*/
          {3.686484652,2.093830107,5.262848862,0.1697896095} /*cfz*/
     },
     {
          2464569.5,
          {1.866983912,-0.004183491711,1028.360071,0.5227284291,-0.02829324463,0.9780271792}, /*cmx*/
          {5.748080924,4.329958739,4.298314316,5.895538128}, /*cfx*/
          {0.3799165978,-0.0007446478811,303.7537197,-0.194383716,-0.01109299996,0.2870915864}, /*cmy*/
          {5.972987498,-0.05536695814,3.384012645,6.111504442}, /*cfy*/
          {-2.409343444,-0.0005350911471,1068.380847,0.5314263954,0.029555474,1.021171693}, /*cmz*/
          {1.053283649,5.778742337,2.636345799,1.190281292} /*cfz*/
     },
     {
          2464609.5,
          {1.555225113,0.01542972461,1026.475176,-1.970068841,-0.007565712278,1.059010521}, /*cmx*/
          {3.199546958,1.725833198,2.100739857,0.841336145}, /*cfx*/
          {0.2468540316,0.006154682736,311.0035513,-0.7937279114,-0.002750544407,0.3537241297}, /*cmy*/
          {3.424995764,0.8840207619,1.47581785,1.088281031}, /*cfy*/
          {-2.913691285,-0.001470537316,1068.053144,-2.081132663,0.008292064363,1.144433475}, /*cmz*/
          {4.788830421,3.196876773,0.5229920184,2.41913439} /*cfz*/
     },
     {
          2464649.5,
          {1.532064808,0.0189430762,1017.743185,-2.543153634,0.02484457721,1.259306098}, /*cmx*/
          {0.7149327544,5.557675095,5.540202366,2.032696501}, /*cfx*/
          {0.3150819936,0.006519616807,339.3356724,-0.9646936967,0.01001278979,0.4283392229}, /*cmy*/
          {0.9174273685,4.770896579,17.39355471,2.208332344}, /*cfy*/
          {-3.148693795,-0.01487592652,1068.635269,-2.647052274,0.02563401241,1.348006412}, /*cmz*/
          {2.305820199,0.7533090822,-5.545303254,3.641272072} /*cfz*/
     },
     {
          2464689.5,
          {2.121922756,0.00973214095,1010.76709,-0.4244046545,0.02931114622,1.315716849}, /*cmx*/
          {4.487767572,2.995991699,2.998652281,3.30430365}, /*cfx*/
          {0.5558866182,0.002234670582,357.2545401,-0.13056899,0.01164926311,0.4585390507}, /*cmy*/
          {4.66904056,1.59244317,2.268106131,3.476898365}, /*cfy*/
          {-3.201846743,-0.0109825603,1068.473341,-0.4259736735,0.03113484563,1.380803391}, /*cmz*/
          {6.07827558,4.404683888,4.468780615,4.882808552} /*cfz*/
     },
     {
          2464729.5,
          {2.985837526,0.001901168122,1013.416016,1.961058845,0.01906799043,1.360648655}, /*cmx*/
          {1.887825095,0.438188166,0.1837437626,4.504120997}, /*cfx*/
          {0.8387133155,-0.001149039758,348.9850241,0.8657649396,0.008169293021,0.4519822112}, /*cmy*/
          {2.063612051,-0.1913870596,5.407476649,4.682488018}, /*cfy*/
          {-3.337172308,0.01463731702,1068.701755,2.117806883,0.01981033114,1.445435204}, /*cmz*/
          {3.47702006,1.933509763,1.640505687,6.090293619} /*cfz*/
     },
     {
          2464769.5,
          {3.484763344,0.004608801174,1024.198347,3.467397554,0.01149165569,1.3426265}, /*cmx*/
          {5.494487827,4.036551997,3.24420531,5.587446355}, /*cfx*/
          {0.8880805865,-0.001465366527,315.7435884,1.453932223,0.007495024055,0.3729072143}, /*cmy*/
          {5.682999147,3.216217106,1.935225,5.807951429}, /*cfy*/
          {-2.98457904,0.03885269862,1068.8469,3.691341472,0.01114701773,1.399958447}, /*cmz*/
          {0.7983809828,5.517774592,4.703827242,0.9020201873} /*cfz*/
     },
     {
          2464809.5,
          {3.643521239,0.008442044218,1039.315724,4.182244031,0.00959029523,1.338162545}, /*cmx*/
          {2.776879399,1.303597844,-0.2739651631,0.3758936092}, /*cfx*/
          {0.8023358372,-0.002393604523,262.3286798,1.741196924,0.007746044641,0.2849850039}, /*cmy*/
          {2.999468314,0.2882609918,4.916944418,0.6133164724}, /*cfy*/
          {-1.988790384,0.03871837594,1068.887642,4.396776597,0.008978939541,1.347016224}, /*cmz*/
          {4.360832487,2.790466582,1.107136389,1.951947029} /*cfz*/
     },
     {
          2464849.5,
          {3.429141573,0.005780504272,1054.095441,4.26315207,0.01045519207,1.189813257}, /*cmx*/
          {0.04620311472,4.824899075,2.531300374,1.423246499}, /*cfx*/
          {0.576911775,-0.004719194406,195.8817856,1.811464993,0.007154718587,0.1856546089}, /*cmy*/
          {0.3390712732,3.628519543,1.594394217,1.753383286}, /*cfy*/
          {-0.5985927046,0.016644799,1069.086312,4.412754894,0.01047663721,1.199232711}, /*cmz*/
          {1.626192516,0.04849671146,3.959701697,3.005068561} /*cfz*/
     },
     {
          2464889.5,
          {3.229829944,-0.00885970434,1064.204131,3.790673783,0.01578138906,1.001412579}, /*cmx*/
          {3.60785147,2.075182444,5.528340808,2.431325368}, /*cfx*/
          {0.3793718271,-0.005578437794,127.9554842,1.647304442,0.007317179295,0.09610343736}, /*cmy*/
          {4.051028004,0.7153445926,4.365181079,3.144551549}, /*cfy*/
          {0.45352736,-0.008455255307,1069.286122,3.874703194,0.01550744906,1.022318808}, /*cmz*/
          {5.184030677,3.598772014,0.7175864945,4.009748987} /*cfz*/
     },
     {
          2464929.5,
          {3.042451463,-0.01990146373,1069.167041,2.639467415,0.02520494915,0.9276651503}, /*cmx*/
          {0.9173364543,5.636373697,2.532555074,3.440184305}, /*cfx*/
          {0.1621942095,-0.003343895003,76.23144086,1.173042194,0.0106881494,0.04906757289}, /*cmy*/
          {1.692274329,4.162838553,1.080966985,4.319273902}, /*cfy*/
          {0.6849704355,-0.0154444875,1069.362036,2.697206537,0.02548493043,0.911697293}, /*cmz*/
          {2.490725862,0.8988734996,4.064476092,5.020151084} /*cfz*/
     },
     {
          2464969.5,
          {2.746795441,-0.01396757926,1070.183349,0.5435407049,0.02913566066,0.8514764855}, /*cmx*/
          {4.568219505,3.034126674,6.166763607,4.380366012}, /*cfx*/
          {0.0461811661,-1.072960341e-05,56.8943558,0.2839762138,0.01280072835,0.03966988716}, /*cmy*/
          {5.750820519,1.518797364,4.652450675,5.499121785}, /*cfy*/
          {0.04097285261,-0.005491335752,1069.040161,0.5711038739,0.03008280815,0.8464193124}, /*cmz*/
          {6.140133248,4.585470262,1.437308642,5.969189186} /*cfz*/
     },
     {
          2465009.5,
          {2.25237615,0.008024828039,1069.784724,-2.023391368,0.008566232105,0.8415584469}, /*cmx*/
          {2.01941007,0.4436374247,4.087558467,5.404639031}, /*cfx*/
          {0.03770139124,0.001815698609,61.17631944,-0.8561196037,0.003729244484,0.09330652254}, /*cmy*/
          {3.054237475,5.234142521,2.656734597,0.1068162161}, /*cfy*/
          {-0.7635401268,-0.0009477642744,1069.058524,-2.080936721,0.008053393414,0.8153019619}, /*cmz*/
          {3.591528705,2.013962662,5.532933842,0.7116987736} /*cfz*/
     },
     {
          2465049.5,
          {2.152067311,0.02121936084,1068.239082,-2.594991657,0.02447380701,1.060465823}, /*cmx*/
          {5.817711068,4.311173996,4.29214016,0.2241966354}, /*cfx*/
          {0.1127052948,0.002892944682,91.03446047,-1.117286659,-0.01038294559,0.09899322819}, /*cmy*/
          {0.1461155402,2.849613678,-19.13639388,0.6095990769}, /*cfy*/
          {-1.214707826,-0.01499532092,1069.334149,-2.689935971,-0.0257231349,1.039396299}, /*cmz*/
          {1.108325849,5.838525526,2.670461838,1.783223429} /*cfz*/
     },
     {
          2465089.5,
          {2.60156038,0.015456822,1064.980975,-0.4704936446,0.02941111438,1.146684416}, /*cmx*/
          {3.307003943,1.731078881,1.756021697,1.359375285}, /*cfx*/
          {0.2084939429,-0.0001864219032,116.9843914,-0.2333392127,-0.01261775154,0.1183943941}, /*cmy*/
          {3.755551562,0.07077355874,3.519286089,1.769769879}, /*cfy*/
          {-1.405327223,-0.01733928423,1069.19408,-0.4950568631,-0.03057748864,1.16279478}, /*cmz*/
          {4.882332856,3.275300206,0.1511628174,2.947247859} /*cfz*/
     },
     {
          2465129.5,
          {3.53671725,0.003076895633,1066.020071,1.94920109,0.01900125797,1.291219246}, /*cmx*/
          {0.7099148888,5.494578609,5.171817847,2.52658228}, /*cfx*/
          {0.2429530329,-0.003579298472,105.5676887,-0.8168580468,-0.009122053049,0.1172365401}, /*cmy*/
          {1.184995586,1.063323028,0.4764743422,3.143654192}, /*cfy*/
          {-1.597059523,0.004367406095,1069.244069,1.981746636,-0.01951513608,1.271194818}, /*cmz*/
          {2.284606592,0.7377516941,3.62299434,4.098574695} /*cfz*/
     },
     {
          2465169.5,
          {4.177143096,-0.001698923925,1069.467397,3.452659583,0.01162733958,1.396334926}, /*cmx*/
          {4.321908598,2.778292151,1.926146328,3.598795508}, /*cfx*/
          {0.1181678659,-0.005585617799,63.8298136,-1.49880412,-0.0073267817,0.05952387413}, /*cmy*/
          {5.110184964,4.495877021,3.318876142,5.224775995}, /*cfy*/
          {-1.517555165,0.03399566212,1069.349232,3.516896557,-0.01101322942,1.389291262}, /*cmz*/
          {5.894493981,4.333337899,0.427153288,5.160606318} /*cfz*/
     },
     {
          2465209.5,
          {4.35826787,0.001485912485,1070.165876,4.158021646,0.009786631718,1.45744239}, /*cmx*/
          {1.610026383,0.02666501443,4.691856079,4.686638383}, /*cfx*/
          {-0.144838796,-0.006017847209,49.05515757,-1.820600127,-0.007137366713,0.09813354389}, /*cmy*/
          {3.744022044,1.609929418,-0.08010087184,1.122724255}, /*cfy*/
          {-0.6611743497,0.04385525857,1069.417306,4.216887393,-0.008792261088,1.479974662}, /*cmz*/
          {3.17975929,1.614796447,3.163480699,-0.0234244496} /*cfz*/
     },
     {
          2465249.5,
          {4.006507611,0.001573527988,1065.518775,4.234550658,0.01091258561,1.408092867}, /*cmx*/
          {5.166788011,3.539602108,1.192639336,5.775793881}, /*cfx*/
          {-0.3643102729,-0.006492632823,110.8098987,-1.845459502,-0.006935537414,0.1903271987}, /*cmy*/
          {1.685027673,4.994187905,2.843664687,2.348266318}, /*cfy*/
          {0.7007429301,0.02939969473,1069.96931,4.282532374,-0.009891855718,1.408755457}, /*cmz*/
          {0.4508327934,5.156402069,-0.3568302671,1.057425748} /*cfz*/
     },
     {
          2465289.5,
          {3.560712564,-0.009164247386,1056.048929,3.703524613,0.01546425036,1.302242159}, /*cmx*/
          {2.447247863,0.7854181078,4.198590011,0.5853648123}, /*cfx*/
          {-0.5445122564,-0.002747124578,178.9393749,-1.611871567,-0.00761610733,0.2714483239}, /*cmy*/
          {5.409947783,2.115241091,-0.6098265659,3.571369781}, /*cfy*/
          {2.094777236,0.001207371732,1070.204793,3.783616657,-0.01568517317,1.316381411}, /*cmz*/
          {4.013276665,2.427666155,2.656794464,2.148130075} /*cfz*/
     },
     {
          2465329.5,
          {3.113997149,-0.02240671877,1045.643965,2.530167874,0.0249195147,1.190260257}, /*cmx*/
          {6.041585188,4.361812983,1.255367094,1.746461754}, /*cfx*/
          {-0.6246551659,0.002767804924,231.1346926,-1.088501192,-0.01078647133,0.2766531494}, /*cmy*/
          {2.783645533,5.595833114,2.446766614,4.818170859}, /*cfy*/
          {2.747113612,-0.01354955202,1070.151621,2.602203478,-0.02604632562,1.236119425}, /*cmz*/
          {1.323987014,6.024025313,-0.2331053595,3.303383427} /*cfz*/
     },
     {
          2465369.5,
          {2.703480025,-0.02154408374,1039.597094,0.4370052545,0.02869903153,1.053648691}, /*cmx*/
          {3.412009084,1.729589231,4.894641192,2.871272213}, /*cfx*/
          {-0.61841646,0.00536074852,256.2489912,-0.1991435839,-0.01219392478,0.2589754361}, /*cmy*/
          {0.17984727,3.282466205,6.066807888,5.942752093}, /*cfy*/
          {2.399022204,-0.007763694857,1070.156766,0.4287016997,-0.02936613152,1.081074768}, /*cmz*/
          {4.97759446,3.435745262,3.424022096,4.434210333} /*cfz*/
     },
     {
          2465409.5,
          {2.19359541,-0.001843163347,1041.765234,-2.107580618,0.006239888406,0.8428840643}, /*cmx*/
          {0.8668946915,5.482089837,2.857112699,4.00910645}, /*cfx*/
          {-0.4565377524,0.001893053698,246.6678039,0.8975069753,-0.004222647483,0.198190363}, /*cmy*/
          {3.919963087,0.2772708626,4.350668745,0.6518088947}, /*cfy*/
          {1.564042934,-0.0008514679349,1070.042978,-2.142346148,-0.006893788433,0.874716336}, /*cmz*/
          {2.43322123,0.8508838996,1.348725575,5.540192962} /*cfz*/
     },
     {
          2465449.5,
          {1.904030756,0.01855716118,1049.888862,-2.52927465,0.0245063552,0.8524538396}, /*cmx*/
          {4.666849059,3.025664834,2.992212243,5.052987714}, /*cfx*/
          {-0.3584515001,-0.001784804951,210.051407,1.109000675,-0.01041720317,0.1511685052}, /*cmy*/
          {1.418038949,4.278133684,-2.057946392,1.927707837}, /*cfy*/
          {1.11069151,-0.01316662536,1070.550328,-2.582604367,0.02512735322,0.8849290291}, /*cmz*/
          {6.233551611,4.6880855,10.95381235,0.3297769472} /*cfz*/
     },
     {
          2465489.5,
          {2.109399099,0.01575628868,1054.817359,-0.4275199479,0.02847975919,0.8538804279}, /*cmx*/
          {2.154154369,0.4683809463,0.4905851312,6.025336274}, /*cfx*/
          {-0.3358694864,-0.003784070759,183.3232597,0.2077350192,-0.01219019353,0.1527642879}, /*cmy*/
          {5.16697783,1.73999749,1.764942882,2.798128986}, /*cfy*/
          {0.8101011084,-0.02214985717,1070.179648,-0.4212915615,0.02874985209,0.8575057164}, /*cmz*/
          {3.72137945,2.147837913,2.145823178,1.301214502} /*cfz*/
     },
     {
          2465529.5,
          {2.799643503,0.001951821941,1052.69906,1.880148812,0.01868499876,0.9298199778}, /*cmx*/
          {5.839604516,4.224586635,3.92198784,0.7264145593}, /*cfx*/
          {-0.5052688804,-0.003758802977,193.9380426,-0.8021462995,-0.007962422355,0.1873748904}, /*cmy*/
          {2.581545881,5.513692698,5.012032247,3.717143997}, /*cfy*/
          {0.5143119458,-0.008756371349,1069.971062,1.932195363,0.01842679648,0.9739582628}, /*cmz*/
          {1.123563301,5.863238964,5.597005941,2.2969651} /*cfz*/
     },
     {
          2465569.5,
          {3.425335409,-0.006541257649,1044.346228,3.337917622,0.01034835622,1.121412236}, /*cmx*/
          {3.170132558,1.518248399,0.7065143238,1.685824237}, /*cfx*/
          {-0.7526776004,-0.002812350395,235.1998516,-1.417538676,-0.006114097573,0.2909561977}, /*cmy*/
          {-0.05314672245,2.714104308,1.508377396,4.778988606}, /*cfy*/
          {0.2696060663,0.01976567642,1070.230938,3.398027395,0.01044028416,1.153875671}, /*cmz*/
          {4.736926458,3.173531032,2.435308857,3.26132827} /*cfz*/
     },
     {
          2465609.5,
          {3.546158608,-0.003288630481,1030.544626,3.97688234,0.00797258883,1.261174053}, /*cmx*/
          {0.459782413,5.074178443,3.442913121,2.74667285}, /*cfx*/
          {-0.9992695059,-0.003529593324,289.2807038,-1.675717732,-0.006297312923,0.389407915}, /*cmy*/
          {3.553717451,-0.1536259172,4.375093654,5.864223063}, /*cfy*/
          {0.709504469,0.03860304346,1070.399886,4.069019705,0.007791143609,1.301356256}, /*cmz*/
          {2.026972684,0.4557127346,5.21390476,4.308067313} /*cfz*/
     },
     {
          2465649.5,
          {3.227126796,0.0002514991904,1014.526643,4.023396635,0.009893794398,1.283856726}, /*cmx*/
          {4.017591819,2.339241453,-0.1079412198,3.796279804}, /*cfx*/
          {-1.073643948,-0.004118494044,341.6256045,-1.676129144,-0.006263671372,0.464201121}, /*cmy*/
          {0.8561594359,3.23552255,1.001407346,0.6396715166}, /*cfy*/
          {1.736977038,0.03365130319,1070.610312,4.171958827,0.00968088573,1.387884579}, /*cmz*/
          {5.586422004,4.006330187,1.570156231,5.363337103} /*cfz*/
     },
     {
          2465689.5,
          {2.68908042,-0.004029146369,999.8016347,3.484446211,0.01541748334,1.323511426}, /*cmx*/
          {1.299158382,5.897479935,2.938298664,4.900035757}, /*cfx*/
          {-1.043485597,-0.001021055904,383.3072419,-1.432893726,-0.007022490228,0.5348503749}, /*cmy*/
          {4.443777803,0.362701391,3.825749953,1.771178674}, /*cfy*/
          {3.119315161,0.008956896612,1070.622632,3.649232541,0.01626545529,1.428366391}, /*cmz*/
          {2.870348992,1.283426703,4.618749376,0.1945023843} /*cfz*/
     },
     {
          2465729.5,
          {2.241799153,-0.016715137,989.0158157,2.293014527,0.0248121944,1.313150872}, /*cmx*/
          {4.896322779,3.221755385,0.09534257744,6.092836237}, /*cfx*/
          {-0.9633812833,0.005970070578,409.9496826,-0.9138236684,-0.01062705822,0.5525147302}, /*cmy*/
          {1.776163721,3.870355761,0.6906572315,2.979710795}, /*cfy*/
          {4.007620831,-0.01020979362,1070.344397,2.393070345,0.02631147956,1.408605929}, /*cmz*/
          {0.1869184929,4.890733002,1.7735486,1.394310503} /*cfz*/
     },
     {
          2465769.5,
          {1.913372758,-0.02174119955,984.3464905,0.2021501001,0.02649492588,1.256129838}, /*cmx*/
          {2.272683902,0.6542746366,3.785335964,1.03676509}, /*cfx*/
          {-0.8727785888,0.009420396297,420.5795796,0.06865698515,-0.0111167592,0.5326083338}, /*cmy*/
          {5.448675254,5.78841707,4.394405715,4.222296401}, /*cfy*/
          {4.005373826,-0.008058893261,1070.418095,0.1581382746,0.02762308927,1.374450153}, /*cmz*/
          {3.848647863,2.322462953,5.442185585,2.609435267} /*cfz*/
     },
     {
          2465809.5,
          {1.563044258,-0.008493923514,986.7775631,-2.10776209,0.004046365274,1.103058951}, /*cmx*/
          {6.018336701,4.364526268,1.814156925,2.250734905}, /*cfx*/
          {-0.6993538914,0.004649084168,414.9698582,-0.9698292293,-0.002686690982,0.4576506035}, /*cmy*/
          {2.915933835,14.34330393,-3.044821798,5.409431582}, /*cfy*/
          {3.377893253,0.001221448763,1070.196657,-2.297181193,0.003802329437,1.19658533}, /*cmz*/
          {1.311619804,6.015169427,3.860340143,3.852579003} /*cfz*/
     },
     {
          2465849.5,
          {1.085215369,0.01208386104,994.6198053,-2.312751315,0.02391074161,1.027701141}, /*cmx*/
          {3.536466921,1.889546572,8.156278159,3.528577665}, /*cfx*/
          {-0.4841446268,-0.00360248697,396.3530829,-0.9872313378,0.01059494753,0.3894223329}, /*cmy*/
          {0.4297187243,5.74707565,5.665241228,0.4326972334}, /*cfy*/
          {3.008918819,-0.005122234795,1070.445851,-2.409592595,-0.02500999423,1.094615099}, /*cmz*/
          {5.112275413,3.556233338,6.677542979,5.119456294} /*cfz*/
     },
     {
          2465889.5,
          {0.9924080409,0.01255039884,999.8046623,-0.2767763882,0.02607275439,0.8596493017}, /*cmx*/
          {1.019407259,5.629940918,5.62962014,4.628174691}, /*cfx*/
          {-0.4068411999,-0.004804082076,382.8772782,-0.101341186,0.01113716944,0.3301483078}, /*cmy*/
          {4.188168712,3.533759198,3.204918148,1.532081415}, /*cfy*/
          {2.816970773,-0.02186134782,1070.344269,-0.2685234929,-0.02720449093,0.9185587195}, /*cmz*/
          {2.593753089,0.9996826375,4.15178108,6.203937172} /*cfz*/
     },
     {
          2465929.5,
          {1.289602268,-0.000176952753,996.9309754,1.842440938,0.01674622808,0.7657544568}, /*cmx*/
          {4.701354319,3.061200366,2.816256436,5.563806279}, /*cfx*/
          {-0.522519063,-0.000956036551,389.4585248,-0.8073949963,0.00735730938,0.3043405669}, /*cmy*/
          {1.585498591,3.75628755,0.1531592864,2.415386487}, /*cfy*/
          {2.498005138,-0.02168756227,1069.992631,1.946032369,-0.01798489705,0.8103466649}, /*cmz*/
          {-0.00772705768,4.740060999,1.292885572,0.8596070856} /*cfz*/
     },
     {
          2465969.5,
          {1.715494032,-0.008539248339,988.4506668,3.167462269,0.008721632482,0.8075163137}, /*cmx*/
          {2.030538219,0.3813786892,-0.3156139174,0.07971349723}, /*cfx*/
          {-0.7390571789,0.002395614999,410.9072062,-1.36801785,0.005554265144,0.3545721793}, /*cmy*/
          {5.204761802,0.9864457873,2.986780049,3.267416032}, /*cfy*/
          {1.955016321,9.200226429e-05,1070.318773,3.363361896,-0.01007427236,0.8869375235}, /*cmz*/
          {3.606116992,2.042565648,4.421594058,1.645391656} /*cfz*/
     },
     {
          2466009.5,
          {1.796583207,-0.004805152667,978.2412695,3.737639617,0.005946800628,0.8982053592}, /*cmx*/
          {5.603008283,3.9655578,2.39153346,0.9573496084}, /*cfx*/
          {-0.8320601242,0.0003198588237,434.9132293,-1.612536625,0.005542490038,0.4079161425}, /*cmy*/
          {2.506472916,4.432240206,-0.410306831,4.157815503}, /*cfy*/
          {1.740032094,0.02555241759,1070.335359,4.013433634,-0.007422695307,0.9961966836}, /*cmz*/
          {0.8982180512,5.608492688,0.8878420522,2.543900596} /*cfz*/
     },
     {
          2466049.5,
          {1.6323631,0.00263089097,970.2445163,3.78459935,0.008754084738,1.025830894}, /*cmx*/
          {2.87861546,1.26236041,5.007910553,1.886869152}, /*cfx*/
          {-0.8192370176,-0.003158058276,453.0091352,-1.623391673,0.005858712461,0.4852655535}, /*cmy*/
          {6.080737571,1.572544689,2.42308647,5.093217835}, /*cfy*/
          {2.196314697,0.03117841308,1070.142155,4.10216465,-0.0104274051,1.116502975}, /*cmz*/
          {4.460468146,2.883480175,3.52827749,3.474250816} /*cfz*/
     },
     {
          2466089.5,
          {1.225302596,0.003699693815,966.5029288,3.260167651,0.01583660849,1.15149017}, /*cmx*/
          {0.1632154439,4.842785442,1.821208123,2.968140339}, /*cfx*/
          {-0.6896540337,-0.002990075135,462.0874725,-1.364700616,0.007532160388,0.553763172}, /*cmy*/
          {3.382082985,5.004931701,5.245969352,6.193279997}, /*cfy*/
          {3.242365138,0.01458845111,1070.20392,3.523802394,-0.01759512309,1.283946742}, /*cmz*/
          {1.748348907,0.1576050758,0.3086226155,4.54724569} /*cfz*/
     },
     {
          2466129.5,
          {0.9577527505,-0.007766396331,965.6606219,2.01370587,0.02477752507,1.235554354}, /*cmx*/
          {3.766619747,2.192972088,5.341507195,4.135677378}, /*cfx*/
          {-0.6324323514,0.003471874452,463.4759973,-0.7864225715,0.01091737026,0.5941181447}, /*cmy*/
          {0.7184284188,2.247194325,2.255327019,1.096582629}, /*cfy*/
          {4.203165201,-0.005312810073,1069.836687,2.137758069,-0.02664853484,1.375478687}, /*cmz*/
          {5.354657157,3.764867956,3.774521474,5.719605166} /*cfz*/
     },
     {
          2458849.5,
          {-20.24722507,0.005545057123,1878.789681,7.758308711,0.02080267116,6.636865237}, /*cmx*/
          {-5.443561931,-0.7675543915,-3.056316543,0.008437857045}, /*cfx*/
          {-1.265623506,-0.03353589951,135.3882408,3.378686992,0.01274116381,0.7839143364}, /*cmy*/
          {-5.894131176,-5.562865542,-1.449792857,-0.300446427}, /*cfy*/
          {0.06734168458,-0.08349427474,1882.106048,7.8263303,0.01797844901,6.727319725}, /*cmz*/
          {-3.874986593,-5.454106611,-1.512767692,-4.707829685} /*cfz*/
     },
     {
          2458889.5,
          {-19.65125707,0.009881139305,1866.468861,6.9145152,0.02740127123,6.746475036}, /*cmx*/
          {3.178528863,1.52332391,4.951565668,4.875110344}, /*cfx*/
          {-2.534487527,-0.02867393581,258.8688455,2.985870547,0.01356262912,1.132597863}, /*cmy*/
          {2.97800286,2.887741315,0.1696090022,4.76255758}, /*cfy*/
          {-3.370781188,-0.06387771369,1882.531745,7.062610915,0.02807664846,6.872814123}, /*cmz*/
          {4.745875794,3.156129565,0.2572056766,0.1572082173} /*cfz*/
     },
     {
          2458929.5,
          {-19.39615331,0.01799717591,1850.006436,4.950619685,0.04346848112,6.646331681}, /*cmx*/
          {5.546322078,3.859288002,0.7353910962,3.465030203}, /*cfx*/
          {-3.735717726,-0.006138986453,357.6942913,2.083749746,0.01851042371,1.46276506}, /*cmy*/
          {5.422577581,5.121509201,1.990860206,3.358170231}, /*cfy*/
          {-6.246328952,-0.01772058117,1882.939381,5.057466168,0.04477227816,6.803280472}, /*cmz*/
          {0.8295547694,5.513540205,2.390979203,5.028440157} /*cfz*/
     },
     {
          2458969.5,
          {-18.74657917,-0.0008283341141,1837.809798,1.374418191,0.04818352609,6.652077324}, /*cmx*/
          {1.687017022,0.04928916184,3.186409738,2.149655859}, /*cfx*/
          {-4.115265896,0.003822182031,409.3633949,0.5735330503,0.02076893491,1.499414411}, /*cmy*/
          {1.592597196,1.379095223,4.365179629,2.067624883}, /*cfy*/
          {-7.401235327,0.01200607513,1882.05817,1.386258753,0.04923758388,6.840604087}, /*cmz*/
          {3.253385409,1.692478409,4.827713667,3.715762416} /*cfz*/
     },
     {
          2459009.5,
          {-19.02325776,0.002704458025,1839.113618,-3.098941281,0.01526506251,6.40674374}, /*cmx*/
          {4.191158555,2.50389907,6.094017847,0.9194310934}, /*cfx*/
          {-3.808766074,0.01015454736,401.557356,-1.334235274,0.008622888931,1.325303076}, /*cmy*/
          {4.101852817,3.601236964,1.229287065,0.7391609057}, /*cfy*/
          {-6.231069621,0.01690108656,1881.450021,-3.097687118,0.0168441403,6.543391147}, /*cmz*/
          {5.758363524,4.155216992,1.390194717,2.468924707} /*cfz*/
     },
     {
          2459049.5,
          {-19.13385091,-0.0255507337,1852.284849,-4.673085513,-0.03784659643,6.805231502}, /*cmx*/
          {0.4797778977,5.141406626,1.963923092,6.007680997}, /*cfx*/
          {-3.578575793,0.01439729743,342.9984997,-2.053197491,0.01618987574,1.031931763}, /*cmy*/
          {0.3763482672,6.382418408,31.42660229,5.879604253}, /*cfy*/
          {-5.570742298,0.03918189181,1882.208091,-4.712529477,-0.03771641806,6.819061398}, /*cmz*/
          {2.047485243,0.4872112218,3.580921406,1.289225916} /*cfz*/
     },
     {
          2459089.5,
          {-19.75240805,-0.003044345971,1860.885549,-1.544230357,-0.0510142787,6.732934266}, /*cmx*/
          {3.041748673,1.395726319,4.539442121,4.709230271}, /*cfx*/
          {-2.854654795,-0.005393144396,288.2948682,-0.7166343054,0.02224567674,1.033621355}, /*cmy*/
          {2.915919137,2.708847635,2.721674961,4.575688277}, /*cfy*/
          {-3.893040096,-0.004590254578,1882.421253,-1.574006244,-0.0516794523,6.820569562}, /*cmz*/
          {4.60956642,3.043647481,6.181107729,6.273986573} /*cfz*/
     },
     {
          2459129.5,
          {-20.27877337,0.03046099352,1859.740911,2.768623614,-0.03655846969,6.809818113}, /*cmx*/
          {5.525275729,3.920988103,0.5315348836,3.339692253}, /*cfx*/
          {-3.01803845,-0.01304400459,294.4364157,1.200504905,0.01573851921,1.240277806}, /*cmy*/
          {5.405446221,5.286140122,4.812549976,3.286316073}, /*cfy*/
          {-4.096326836,-0.03775905231,1882.081063,2.822239419,-0.03681912513,6.897313485}, /*cmz*/
          {0.8101581908,5.551845881,2.198631334,4.907599569} /*cfz*/
     },
     {
          2459169.5,
          {-19.38322482,0.03765045454,1847.150657,5.842090651,-0.02288269255,6.561303972}, /*cmx*/
          {1.645539384,0.01179800929,2.412390293,1.917363375}, /*cfx*/
          {-3.669158366,-0.02051120903,363.1014143,2.516544813,0.01319178101,1.538758728}, /*cmy*/
          {1.560390763,1.276515283,0.08918015201,1.809414128}, /*cfy*/
          {-5.786606704,-0.07102712602,1881.459836,5.950960686,-0.02346150684,6.695831927}, /*cmz*/
          {3.213334534,1.667387235,4.088833463,3.486890589} /*cfz*/
     },
     {
          2459209.5,
          {-17.92867484,0.03761952622,1824.867245,7.438221404,-0.01541566492,6.631523548}, /*cmx*/
          {3.997238477,2.328614258,3.959296908,0.4717144157}, /*cfx*/
          {-4.596249739,-0.01344864727,464.3223869,3.155359511,0.01247925701,1.918319919}, /*cmy*/
          {3.949285961,3.432780457,1.714724488,0.4526165685}, /*cfy*/
          {-8.644504582,-0.07391581671,1883.093057,7.569907594,-0.01550824104,6.8724207}, /*cmz*/
          {5.564853916,3.989723364,-0.5344404693,2.044742356} /*cfz*/
     },
     {
          2459249.5,
          {-16.22879377,0.05350923987,1795.538489,7.769610248,-0.01880526688,6.375140758}, /*cmx*/
          {0.04294039875,4.648144949,-0.8553001463,5.279191832}, /*cfx*/
          {-5.097286734,-0.001989837379,566.7931685,3.260812631,0.01314953428,2.228067168}, /*cmy*/
          {0.02253666166,5.58162415,3.387733417,5.254725685}, /*cfy*/
          {-11.29158556,-0.06883270643,1883.035366,8.080894741,-0.0192743093,6.75390481}, /*cmz*/
          {1.612124497,0.0314349666,0.8045080676,0.5696186585} /*cfz*/
     },
     {
          2459289.5,
          {-13.83478824,0.0473416812,1767.570592,6.909184805,-0.02648475897,6.407257318}, /*cmx*/
          {2.374422419,0.6875638931,0.931740935,3.855492271}, /*cfx*/
          {-5.061184755,0.002463545723,650.9265308,2.82852526,0.01239714464,2.489900628}, /*cmy*/
          {2.376072359,1.446784073,5.028209963,3.875509367}, /*cfy*/
          {-13.96516674,-0.04922892866,1882.984097,7.213933551,-0.02792274373,6.881335671}, /*cmz*/
          {3.945272102,2.359442808,2.647014482,5.435028893} /*cfz*/
     },
     {
          2459329.5,
          {-11.91116056,0.02530833814,1746.461988,5.015709648,-0.04198440641,6.317793593}, /*cmx*/
          {4.734973806,3.048535517,3.066252816,2.437064396}, /*cfx*/
          {-5.00179166,0.004413562247,706.1098551,2.012946699,0.01791684279,2.642380314}, /*cmy*/
          {4.7549769,3.675472448,0.5322420827,2.463560903}, /*cfy*/
          {-16.39190062,-0.006033091243,1883.559835,5.245237761,-0.044079652,6.875917502}, /*cmz*/
          {0.0252323854,4.706736618,4.731947958,4.013748408} /*cfz*/
     },
     {
          2459369.5,
          {-10.74013247,-0.004174569628,1734.631193,1.600622335,-0.04753833263,6.333254276}, /*cmx*/
          {0.8686885954,5.508278847,5.507391166,1.118575569}, /*cfx*/
          {-4.781264607,-0.002445161731,731.9295432,0.5449772491,0.02018779251,2.684901645}, /*cmy*/
          {0.902494888,6.227596155,2.934969838,1.156839807}, /*cfy*/
          {-17.01161362,0.007237480886,1882.339006,1.649233993,-0.05095845829,6.881480587}, /*cmz*/
          {2.444555508,0.8769115601,0.8752643362,2.697876216} /*cfz*/
     },
     {
          2459409.5,
          {-11.50063935,-0.009411182211,1735.133489,-2.757086523,-0.01816787519,6.058114417}, /*cmx*/
          {3.368134035,1.703153375,1.947661105,6.150411019}, /*cfx*/
          {-5.095175403,0.003620537689,730.4654212,-1.352265433,0.007567048543,2.504378493}, /*cmy*/
          {3.409864302,2.187387212,6.132342731,6.175269074}, /*cfy*/
          {-16.38174215,0.02273021343,1881.26149,-3.015572626,-0.01920947105,6.647535361}, /*cmz*/
          {4.944988007,3.324822436,3.741363766,1.445873366} /*cfz*/
     },
     {
          2459449.5,
          {-11.80578508,-0.04585099784,1746.842593,-4.586777196,0.03559992458,6.406570512}, /*cmx*/
          {5.940506937,4.300698331,4.26277236,4.982409432}, /*cfx*/
          {-5.082011108,-0.00990738662,704.0917662,-2.017302144,0.01679153063,2.440758607}, /*cmy*/
          {5.982588398,4.972859653,4.868143287,5.02080707}, /*cfy*/
          {-15.70041934,0.01888242913,1882.400303,-4.922289451,0.03945925778,6.900574614}, /*cmz*/
          {1.233532805,5.957079056,5.90693106,0.2651226842} /*cfz*/
     },
     {
          2459489.5,
          {-13.43043896,0.0007041272857,1758.006,-1.614062306,0.05141696522,6.406761803}, /*cmx*/
          {2.223293209,0.556728716,0.5598519687,3.676712478}, /*cfx*/
          {-5.263217558,-0.00253553483,674.1896709,-0.635334637,0.02190588114,2.440842091}, /*cmy*/
          {2.259047926,1.360747273,1.266163037,3.710304879}, /*cfy*/
          {-14.58447429,-0.005351375359,1882.603233,-1.656023388,0.05374122283,6.879152051}, /*cmz*/
          {3.798697897,2.225194346,2.22205874,5.253258662} /*cfz*/
     },
     {
          2459529.5,
          {-13.68161931,0.04189855874,1756.856645,2.75597454,0.03556803971,6.467256133}, /*cmx*/
          {4.707621422,3.06775456,2.880007937,2.306253453}, /*cfx*/
          {-5.512136008,0.01196327318,677.2252615,1.227924027,0.01551911251,2.596718792}, /*cmy*/
          {4.739114335,3.767516303,3.372888272,2.360702081}, /*cfy*/
          {-15.10339185,-0.01516789388,1882.233448,2.908196762,0.03805677385,6.985678089}, /*cmz*/
          {-0.0008284517243,4.744886773,4.514831147,3.882407689} /*cfz*/
     },
     {
          2459569.5,
          {-12.08831749,0.06682884275,1742.209127,5.79502618,0.02022930305,6.235326427}, /*cmx*/
          {0.8238106732,5.471466337,4.775462316,0.8791815858}, /*cfx*/
          {-5.115439518,0.01664601829,712.6212988,2.536672,0.01208816137,2.684050717}, /*cmy*/
          {0.8590177906,6.073387433,4.932957196,0.9076423663}, /*cfy*/
          {-15.96533984,-0.04393207736,1881.711776,6.118886037,0.02370846496,6.778179227}, /*cmz*/
          {2.399387243,0.8498052053,0.1206647222,2.447888475} /*cfz*/
     },
     {
          2459609.5,
          {-9.440057925,0.06888736179,1724.16981,7.208094923,0.01302033991,6.319355046}, /*cmx*/
          {3.169095388,1.53311254,0.1143386606,5.713754898}, /*cfx*/
          {-4.476140608,0.02169289632,757.1950702,3.149307759,0.01205097153,2.874733403}, /*cmy*/
          {3.214508226,1.986410193,0.3127510902,5.772307828}, /*cfy*/
          {-17.63357238,-0.04766133191,1882.918254,7.751457905,0.01569610654,6.917269469}, /*cmz*/
          {4.747401818,3.170291499,1.750988355,1.006427083} /*cfz*/
     },
     {
          2459649.5,
          {-6.756914362,0.07655321723,1709.771792,7.562320912,0.01590343502,6.199907308}, /*cmx*/
          {5.492989803,3.876109918,1.486539101,4.226797827}, /*cfx*/
          {-3.621096478,0.03015060065,790.7393023,3.272691053,0.01195791949,2.90622154}, /*cmy*/
          {5.552109378,4.151433275,1.979410917,4.291784162}, /*cfy*/
          {-19.15716569,-0.02687074664,1882.220253,8.218507578,0.01995868411,6.815899887}, /*cmz*/
          {0.7912253036,5.496742242,3.175571805,5.807193285} /*cfz*/
     },
     {
          2459689.5,
          {-3.578584704,0.06304054248,1703.192234,6.829632047,0.02440635928,6.261143404}, /*cmx*/
          {1.536831552,-0.05371001572,3.358703455,2.799690188}, /*cfx*/
          {-2.358956404,0.02685176106,804.9661338,2.90692862,0.01295511321,2.976818057}, /*cmy*/
          {1.6118912,0.05310541853,3.648121655,2.888043057}, /*cfy*/
          {-20.10643342,-0.01106486277,1882.442098,7.358378094,0.02646133209,6.885538261}, /*cmz*/
          {3.121020438,1.532760017,5.004140004,4.386951172} /*cfz*/
     },
     {
          2459729.5,
          {-0.7754539232,0.0255588491,1704.96546,5.140797437,0.03982288241,6.303099436}, /*cmx*/
          {3.892420791,2.313964764,5.484927254,1.369225333}, /*cfx*/
          {-1.149436934,0.008942840304,803.3989305,2.082848017,0.01775348551,2.935449295}, /*cmy*/
          {3.983706192,2.281607008,5.490480025,1.465947763}, /*cfy*/
          {-20.98702665,0.009056190697,1882.731625,5.532504916,0.04321668895,6.917542949}, /*cmz*/
          {5.479732009,3.871811468,0.7580794254,2.96175011} /*cfz*/
     },
     {
          2459769.5,
          {0.5028731094,-0.001445477494,1707.792432,1.943341748,0.04814503199,6.285288154}, /*cmx*/
          {0.01942261245,4.758458126,1.613668389,0.04721117636}, /*cfx*/
          {-0.7045327996,-0.002062433218,796.0530746,0.6498188484,0.02034059549,2.931961223}, /*cmy*/
          {0.1257032604,4.649927888,1.529924408,0.1580197564}, /*cfy*/
          {-20.77239289,0.002662493008,1881.093249,2.048380612,0.05256468053,6.907631941}, /*cmz*/
          {1.609099818,0.03119421785,3.176709905,1.638201093} /*cfz*/
     },
     {
          2459809.5,
          {-0.1544475583,-0.02211904974,1707.086513,-2.407192923,0.02285537403,6.077478308}, /*cmx*/
          {2.511555263,0.9313695773,4.31949894,5.056454213}, /*cfx*/
          {-1.082518256,-0.01030228451,795.9147808,-1.208240012,0.008509559753,2.838626895}, /*cmy*/
          {2.626576312,0.8514651531,4.520480489,5.178172256}, /*cfy*/
          {-20.88702513,0.01795099015,1880.348243,-2.792975547,0.02214704354,6.634420758}, /*cmz*/
          {4.102328742,2.497114335,5.939769867,0.3769727413} /*cfz*/
     },
     {
          2459849.5,
          {-0.7426382506,-0.04692524493,1704.136214,-4.630566792,-0.03379101328,6.204457068}, /*cmx*/
          {5.081449786,3.53228919,0.3265336271,3.897484917}, /*cfx*/
          {-1.336239395,-0.020810985,803.660155,-1.99521339,-0.01639836961,2.921677447}, /*cmy*/
          {5.194280686,3.562047352,0.3320871533,4.002606824}, /*cfy*/
          {-20.22664682,-0.01447334476,1881.502279,-5.075986981,-0.03821617518,6.902346824}, /*cmz*/
          {0.3893248587,5.123827889,1.941630534,5.497948836} /*cfz*/
     },
     {
          2459889.5,
          {-2.713675498,0.001437510252,1702.97672,-1.814268248,-0.05093206678,6.245651711}, /*cmx*/
          {1.369364683,6.092228082,2.948548424,2.60201822}, /*cfx*/
          {-2.153727127,0.001873863994,806.3904874,-0.6271647754,-0.02223903367,2.945258046}, /*cmy*/
          {1.471807521,6.17889593,3.019442575,2.700093968}, /*cfy*/
          {-20.37480764,-0.001627028368,1881.170098,-1.908999148,-0.05570004816,6.88175661}, /*cmz*/
          {2.958902361,1.378503045,4.52162908,4.194426221} /*cfz*/
     },
     {
          2459929.5,
          {-2.680640496,0.03709292555,1702.735222,2.527353366,-0.03560931694,6.342808083}, /*cmx*/
          {3.858432538,2.319199919,5.287474001,1.235917738}, /*cfx*/
          {-2.128795695,0.01816299052,805.5667725,1.289701956,-0.0149378532,2.996495938}, /*cmy*/
          {3.953243132,2.409401794,5.130712116,1.334247415}, /*cfy*/
          {-20.93664268,0.0125396595,1881.490355,2.799566434,-0.03917660119,7.002867622}, /*cmz*/
          {5.446335138,3.901452671,0.5551289221,2.829540489} /*cfz*/
     },
     {
          2459969.5,
          {-1.17581469,0.07480740514,1704.376116,5.565057784,-0.02059838421,6.175924757}, /*cmx*/
          {-0.02313645181,4.731686081,0.9482497254,6.085466106}, /*cfx*/
          {-1.398188772,0.03419129269,800.8083768,2.561326968,-0.01191861204,2.843332311}, /*cmy*/
          {0.07229679681,4.71685501,0.3672350511,-0.09928884551}, /*cfy*/
          {-20.60184955,0.00163301209,1881.045089,6.120841975,-0.0228319398,6.82750733}, /*cmz*/
          {1.564791772,0.009079602364,2.433579015,1.391108897} /*cfz*/
     },
     {
          2460009.5,
          {1.672191076,0.08179399391,1713.967993,7.030045009,-0.01324823921,6.308017624}, /*cmx*/
          {2.324252616,0.7981742066,2.679950689,4.646415639}, /*cfx*/
          {-0.0947403993,0.03278782602,783.4003583,3.099068275,-0.01195618962,2.802742441}, /*cmy*/
          {2.427871838,0.6217966075,2.065013364,4.759649641}, /*cfy*/
          {-20.40980685,0.001608898761,1881.328174,7.719638335,-0.01625315276,6.929249082}, /*cmz*/
          {3.913057845,2.340256966,4.059938743,-0.04926202288} /*cfz*/
     },
     {
          2460049.5,
          {4.685886826,0.07650053704,1731.176188,7.56292415,-0.01538840358,6.35833027}, /*cmx*/
          {4.651321049,3.142496697,3.995297394,3.160658914}, /*cfx*/
          {1.171953715,0.02162523405,745.8585111,3.206544277,-0.01292010989,2.562508026}, /*cmy*/
          {4.768961732,2.780416896,3.758810446,3.292368606}, /*cfy*/
          {-20.15623267,0.02761279207,1881.078963,8.161227372,-0.01892669026,6.858259269}, /*cmz*/
          {-0.04301066132,4.66229852,-0.7295454104,4.746973127} /*cfz*/
     },
     {
          2460089.5,
          {7.85081715,0.05947860286,1753.888111,6.962147066,-0.02350293698,6.442587542}, /*cmx*/
          {0.6975746324,5.491448114,-0.4235683594,1.738906981}, /*cfx*/
          {2.116296325,0.01157682094,690.1641777,2.814061551,-0.01262795424,2.414358611}, /*cmy*/
          {0.834100305,4.932589275,5.556438627,1.892742179}, /*cfy*/
          {-18.97914165,0.03429423277,1881.170064,7.448596922,-0.02548901269,6.868875098}, /*cmz*/
          {2.286633612,0.6979016001,1.048650168,3.323279738} /*cfz*/
     },
     {
          2460129.5,
          {10.77920318,0.01939621604,1777.943313,5.40844336,-0.03915807287,6.615227298}, /*cmx*/
          {3.054011021,1.551999323,1.595565374,0.3101753018}, /*cfx*/
          {2.775060961,0.00209854344,629.9599222,2.121489326,-0.01629108785,2.172066674}, /*cmy*/
          {3.212954041,0.8072000088,0.9359935301,0.4742791228}, /*cfy*/
          {-17.76209138,0.02290061698,1881.343617,5.75508406,-0.04253957378,6.920107098}, /*cmz*/
          {4.642542311,3.037690683,3.076152535,1.89185324} /*cfz*/
     },
     {
          2460169.5,
          {11.78510591,0.0009928745663,1792.439667,2.284402537,-0.05085624348,6.568318005}, /*cmx*/
          {5.46174046,3.978308078,3.975896696,5.264116786}, /*cfx*/
          {2.80540587,0.0003353554836,585.0902604,0.8370223085,-0.02014790869,2.117854922}, /*cmy*/
          {5.643200401,3.089971137,3.181237392,5.453002651}, /*cfy*/
          {-16.78122992,0.003550760323,1880.003976,2.381294561,-0.05353523095,6.872429336}, /*cmz*/
          {0.7665953479,5.468008184,5.469821028,0.5672217976} /*cfz*/
     },
     {
          2460209.5,
          {11.5378305,-0.03347633496,1792.60595,-2.332708762,-0.02604941025,6.380963706}, /*cmx*/
          {1.665111872,0.1288626178,0.4436110182,3.987801769}, /*cfx*/
          {2.856536007,-0.01128156512,581.2855876,-1.019638471,-0.0088159719,2.092528874}, /*cmy*/
          {1.855485254,5.700384326,6.035060356,4.211119529}, /*cfy*/
          {-17.20786871,-0.001782978392,1879.424505,-2.469208103,-0.02694543854,6.640898537}, /*cmz*/
          {3.254040605,1.658907855,1.85389448,5.567421871} /*cfz*/
     },
     {
          2460249.5,
          {10.50314504,-0.03215700627,1780.599478,-4.916807934,0.03443486244,6.416317741}, /*cmx*/
          {4.231625958,2.769924892,2.695436822,2.828389426}, /*cfx*/
          {2.496881372,-0.001842567033,620.5364097,-1.925967048,0.01470750358,2.399005301}, /*cmy*/
          {4.409534807,2.089524068,2.072375786,3.001327702}, /*cfy*/
          {-16.87572067,-0.04483828449,1879.847544,-5.126689979,0.03527492505,6.740517107}, /*cmz*/
          {5.821986581,4.264260126,4.201473479,4.424187819} /*cfz*/
     },
     {
          2460289.5,
          {8.874140093,-0.0004605114759,1766.734174,-2.074857962,0.05211713134,6.428721905}, /*cmx*/
          {0.5221208286,5.336336837,5.329968121,1.537226811}, /*cfx*/
          {2.287261446,0.001338773689,658.0135173,-0.7092509991,0.02117634661,2.403261263}, /*cmy*/
          {0.680569852,4.561301094,4.712771463,1.691590777}, /*cfy*/
          {-18.41112665,0.0004009758457,1880.172242,-2.172503598,0.05617098568,6.825160835}, /*cmz*/
          {2.112001412,0.540302112,0.543144376,3.124697469} /*cfz*/
     },
     {
          2460329.5,
          {9.104263844,0.02475959835,1766.075973,2.342998586,0.0374773372,6.569364748}, /*cmx*/
          {3.015938536,1.572131747,1.382944177,0.1835469862}, /*cfx*/
          {2.503524599,0.002653633573,657.831984,1.11684998,0.01538495892,2.380322024}, /*cmy*/
          {3.163830776,1.09615972,0.5190928629,0.3237703412}, /*cfy*/
          {-18.7822947,0.03027576475,1880.521462,2.598777713,0.03888299613,6.930639034}, /*cmz*/
          {4.604839236,3.059800402,2.874741687,1.76765147} /*cfz*/
     },
     {
          2460369.5,
          {10.06048814,0.067339898,1780.232713,5.51568161,0.02218584245,6.478784141}, /*cmx*/
          {5.42399447,3.971249685,3.311416179,5.028664077}, /*cfx*/
          {2.572138608,0.01068104981,617.3341829,2.367281684,0.01264753473,2.037107122}, /*cmy*/
          {5.57541232,3.299690735,2.083225419,5.197699149}, /*cfy*/
          {-17.65422662,0.04809839724,1880.131092,5.93825646,0.02212682724,6.760223576}, /*cmz*/
          {0.7279200106,5.458224942,4.74520813,0.3357125041} /*cfz*/
     },
     {
          2460409.5,
          {12.44146655,0.07322372131,1805.646216,7.102125895,0.01582845036,6.59887791}, /*cmx*/
          {1.495800927,0.02336435745,5.018250003,3.599280428}, /*cfx*/
          {2.905001967,0.002384750044,541.1115995,2.963669594,0.01349352578,1.779871991}, /*cmy*/
          {1.665069735,5.452338504,3.834786259,3.787742497}, /*cfy*/
          {-15.75484693,0.05289610588,1880.646667,7.475456088,0.01615293678,6.831372737}, /*cmz*/
          {3.08025877,1.510667695,0.1629344587,5.187103733} /*cfz*/
     },
     {
          2460449.5,
          {15.10484096,0.0488521573,1833.340032,7.720852695,0.01813441766,6.692730044}, /*cmx*/
          {3.830186842,2.342677668,0.1594870044,2.119921976}, /*cfx*/
          {3.052689334,-0.0180395485,438.0050333,3.188816849,0.01297243269,1.2882033}, /*cmy*/
          {4.035738143,1.283475926,-0.6956968589,2.373922451}, /*cfy*/
          {-13.68639754,0.06623972736,1881.261748,7.97898159,0.0171146338,6.817394545}, /*cmz*/
          {5.411564909,3.829895863,1.606568993,3.703934197} /*cfz*/
     },
     {
          2460489.5,
          {17.21832233,0.02951523802,1857.352358,7.128934056,0.02407446779,6.705552187}, /*cmx*/
          {-0.1178757443,4.653760635,1.965220762,0.7040839508}, /*cfx*/
          {2.432953274,-0.02455864465,321.8375378,3.010996161,0.01230438656,0.978881003}, /*cmy*/
          {0.15894175,3.414302389,0.9372815433,1.04391277}, /*cfy*/
          {-10.91408515,0.06283117571,1880.77265,7.389617857,0.02512777076,6.789534079}, /*cmz*/
          {1.460889347,-0.1219333697,3.390619709,2.282344068} /*cfz*/
     },
     {
          2460529.5,
          {18.97703495,0.006112115595,1873.616297,5.61383147,0.04018714975,6.854506068}, /*cmx*/
          {2.241826853,0.6800349543,3.869227288,5.563612503}, /*cfx*/
          {1.408051026,-0.009669268617,216.4477909,2.387325846,0.01718293013,0.5612972867}, /*cmy*/
          {2.651355159,5.599284462,2.578648556,6.043195611}, /*cfy*/
          {-8.165129592,0.03078450241,1881.499195,5.7503497,0.04149632176,6.914058485}, /*cmz*/
          {3.817356462,2.219605336,5.413387816,0.85223934} /*cfz*/
     },
     {
          2460569.5,
          {19.28112328,0.0004224942161,1878.818456,2.431447068,0.05301080851,6.793513629}, /*cmx*/
          {4.650032796,3.0953431,-0.04513459204,4.236470544}, /*cfx*/
          {0.8842265167,0.0001890034652,150.9588735,1.038900119,0.02237521536,0.5093592207}, /*cmy*/
          {5.254625351,1.646582029,4.79557991,4.884981758}, /*cfy*/
          {-6.83324834,0.006354225714,1880.805695,2.466988435,0.05375560134,6.819051532}, /*cmz*/
          {-0.05940956352,4.638838719,1.495565691,5.808780505} /*cfz*/
     },
     {
          2460609.5,
          {19.49158281,-0.03049695956,1878.716428,-2.40712737,0.02650348913,6.590183301}, /*cmx*/
          {0.8523445999,5.551528645,2.691722883,2.952382677}, /*cfx*/
          {1.052477695,0.009704711614,145.47538,-0.9736701713,0.01231203991,0.5534497665}, /*cmy*/
          {1.489586376,4.090190039,1.304191429,3.652978009}, /*cfy*/
          {-7.111579435,-0.02670254375,1879.656349,-2.362948215,0.02921687386,6.69336795}, /*cmz*/
          {2.426417984,0.8023994389,4.196435527,4.523714051} /*cfz*/
     },
     {
          2460649.5,
          {18.21095003,0.0003871400024,1874.802044,-5.07813977,-0.03448869716,6.621701101}, /*cmx*/
          {3.418141694,1.917190645,4.991199716,1.807798754}, /*cfx*/
          {1.202983664,0.01936466895,198.7601966,-2.120544954,-0.01406649847,0.9431825233}, /*cmy*/
          {3.865047053,0.5143019634,3.585867602,2.205990783}, /*cfy*/
          {-7.558059614,-0.0522321585,1880.136099,-5.190591802,-0.03514342558,6.676327844}, /*cmz*/
          {4.993221176,3.424579709,0.1921125879,3.371651628} /*cfz*/
     },
     {
          2460689.5,
          {17.81592356,-0.001909419068,1866.429581,-2.226013125,-0.05342075294,6.69969612}, /*cmx*/
          {5.991337882,4.48210693,1.335689661,0.512051666}, /*cfx*/
          {2.035911871,-0.001549166536,260.5274389,-0.9499698289,-0.02263495336,0.9601356022}, /*cmy*/
          {0.03178337638,3.063104038,6.331714934,0.8245124972}, /*cfy*/
          {-9.729282324,0.0003247585263,1880.939724,-2.263892168,-0.05461037541,6.771651691}, /*cmz*/
          {1.28477092,6.003886242,2.863687942,2.086339371} /*cfz*/
     },
     {
          2460729.5,
          {18.18271345,0.005428113652,1865.981348,2.284248005,-0.03807926229,6.825355553}, /*cmx*/
          {2.204206377,0.7230887292,3.664525751,5.45173297}, /*cfx*/
          {2.106084483,-0.01259599987,262.7380128,1.001360368,-0.01668504139,0.8471062527}, /*cmy*/
          {2.508186892,5.874719155,2.205404981,5.739023248}, /*cfy*/
          {-9.821389353,0.03513980299,1880.690913,2.386506909,-0.0380739302,6.893269205}, /*cmz*/
          {3.780712214,2.249481388,5.191503578,0.7364114862} /*cfz*/
     },
     {
          2460769.5,
          {18.32119017,0.03032583601,1873.391538,5.525997605,-0.02233353022,6.730669177}, /*cmx*/
          {4.617463698,3.107768719,5.517695735,4.018296291}, /*cfx*/
          {1.568654083,-0.02737412839,198.9050017,2.394298219,-0.01321668017,0.4541492735}, /*cmy*/
          {4.998853347,1.799849019,3.823373471,4.688252108}, /*cfy*/
          {-8.570133844,0.07665852502,1880.618098,5.640912756,-0.02176376646,6.718752607}, /*cmz*/
          {6.192088981,4.642114566,0.8247310636,5.589116524} /*cfz*/
     },
     {
          2460809.5,
          {19.26783251,0.02863225232,1881.408214,7.088502399,-0.0176790143,6.777587376}, /*cmx*/
          {0.6953871655,5.427192518,0.9108593245,2.59484327}, /*cfx*/
          {0.4858228091,-0.03298904362,98.27627289,3.091731676,-0.01252026802,0.2506522786}, /*cmy*/
          {1.463768734,3.969433365,-0.718685926,4.165991376}, /*cfy*/
          {-5.761399426,0.08299982218,1881.508391,7.173810283,-0.01513203204,6.743258293}, /*cmz*/
          {2.267419641,0.6973234397,2.56733533,4.164913396} /*cfz*/
     },
     {
          2460849.5,
          {20.32871964,-0.003152472306,1881.94604,7.627963921,-0.01845732248,6.775768997}, /*cmx*/
          {3.034925443,1.43864027,2.427776948,1.119544207}, /*cfx*/
          {-0.7669332276,-0.03296957906,89.6229401,3.364572634,-0.01236287051,0.624915987}, /*cmy*/
          {11.69563546,-0.1586602088,0.8819404722,3.890440127}, /*cfy*/
          {-2.561264309,0.07415386522,1882.301335,7.750754813,-0.01590505434,6.767812542}, /*cmz*/
          {4.604764879,3.02203505,3.917415694,2.690659562} /*cfz*/
     },
     {
          2460889.5,
          {20.30683258,-0.01753715878,1872.682327,7.074336487,-0.02442392269,6.66620662}, /*cmx*/
          {5.374173803,3.737125106,4.137913701,5.988012331}, /*cfx*/
          {-2.101748082,-0.02755000648,206.7129251,3.058084517,-0.01280427784,0.9323126783}, /*cmy*/
          {1.961131453,2.018790758,2.603625904,2.616250377}, /*cfy*/
          {0.6876417662,0.06334154709,1881.669365,7.18818906,-0.02477162268,6.701255775}, /*cmz*/
          {0.6586723912,5.36454139,-0.5379316573,1.273717447} /*cfz*/
     },
     {
          2460929.5,
          {19.85201486,-0.01101638894,1858.175849,5.505410022,-0.04112581987,6.744652879}, /*cmx*/
          {1.452667725,6.06128263,-0.1759758738,4.56516684}, /*cfx*/
          {-3.41162453,-0.01064604468,312.3998497,2.317629607,-0.01722801516,1.314018088}, /*cmy*/
          {4.440448674,4.216377547,4.267321176,1.32792413}, /*cfy*/
          {3.758751905,0.02844667602,1883.142318,5.556290383,-0.04097713433,6.879445699}, /*cmz*/
          {3.01901348,1.418970304,1.463258241,6.139702658} /*cfz*/
     },
     {
          2460969.5,
          {19.32824086,-0.0003638176317,1845.360428,2.243000424,-0.05227088848,6.647346321}, /*cmx*/
          {3.863018558,2.200004292,2.202078279,3.242839614}, /*cfx*/
          {-3.882336193,0.0003691662304,375.9891714,0.9360766123,-0.02236684525,1.384405155}, /*cmy*/
          {0.608520078,0.351776399,0.2697981811,0.001602356862}, /*cfy*/
          {4.945375574,0.005170661736,1882.373771,2.279684531,-0.05366918483,6.794886433}, /*cmz*/
          {5.42930092,3.844220741,3.844092919,4.813516099} /*cfz*/
     },
     {
          2461009.5,
          {19.72095911,-0.003108327506,1844.301785,-2.479256141,-0.02559487677,6.551633043}, /*cmx*/
          {0.06916619519,4.676651746,4.88857932,1.95083719}, /*cfx*/
          {-3.971807079,0.02100041147,379.4932553,-1.124789692,-0.01170041433,1.321415938}, /*cmy*/
          {3.106483977,2.626092491,3.229331362,4.956326769}, /*cfy*/
          {4.889642775,-0.04334083614,1881.242305,-2.600074347,-0.02570339462,6.681220909}, /*cmz*/
          {1.635371322,0.009235757401,0.3251330107,3.531858285} /*cfz*/
     },
     {
          2461049.5,
          {19.02680259,0.03195757289,1855.178409,-4.969264065,0.03403671249,6.525690087}, /*cmx*/
          {2.637106712,1.005860513,0.9295260926,0.8073190502}, /*cfx*/
          {-3.245772696,0.009265028502,322.76831,-2.222077984,0.01537763606,0.9222530818}, /*cmy*/
          {5.658559362,5.430984348,5.304132051,3.722049679}, /*cfy*/
          {3.570879313,-0.037462537,1882.348441,-5.158075133,0.03656867069,6.670830107}, /*cmz*/
          {4.203839352,2.646296332,2.577555797,2.377138434} /*cfz*/
     },
     {
          2461089.5,
          {20.13331952,-0.003267848534,1865.268455,-2.125798388,0.05219281872,6.680936772}, /*cmx*/
          {5.208613456,3.579931159,3.581026002,5.801917058}, /*cfx*/
          {-2.595216368,-0.002871198529,259.08335,-0.9601683798,0.02250667321,0.8957479047}, /*cmy*/
          {1.913963159,1.780330644,1.795405291,2.492199969}, /*cfy*/
          {1.76456001,5.955788753e-05,1882.231506,-2.132129675,0.0521888535,6.751356069}, /*cmz*/
          {0.4934518773,5.207454573,5.206397479,1.089250052} /*cfz*/
     },
     {
          2461129.5,
          {20.39559431,-0.01410390776,1865.503396,2.294644783,0.03581645301,6.771315829}, /*cmx*/
          {1.420612091,6.105508291,5.906484904,4.457917021}, /*cfx*/
          {-2.786072779,-0.0105233779,256.4407601,0.953180018,0.01605566807,1.004644701}, /*cmy*/
          {4.410309336,4.384011831,3.982224966,1.234847884}, /*cfy*/
          {1.903551027,0.03253167613,1882.028828,2.2752271,0.03717003421,6.881861094}, /*cmz*/
          {2.988355,1.454905443,1.262348372,6.030246801} /*cfz*/
     },
     {
          2461169.5,
          {19.83692686,-0.02303599076,1855.638279,5.383355286,0.02042612861,6.584654515}, /*cmx*/
          {3.835365833,2.210486693,1.485869574,3.030506026}, /*cfx*/
          {-3.178231245,-0.02557272097,317.6730931,2.303083827,0.01115774943,1.400608359}, /*cmy*/
          {0.5842950655,0.3743445299,-0.7053579896,6.088939588}, /*cfy*/
          {2.887713323,0.07962260293,1882.054822,5.42448709,0.02076653262,6.755832671}, /*cmz*/
          {5.402880327,3.847843333,3.219425464,4.59804215} /*cfz*/
     },
     {
          2461209.5,
          {18.86297064,-0.02746094084,1836.771097,6.803383659,0.01489114825,6.54586725}, /*cmx*/
          {-0.08438785745,4.541208682,3.213924052,1.610631394}, /*cfx*/
          {-4.152467828,-0.02274600491,414.1785782,2.912237703,0.011414318,1.685410477}, /*cmy*/
          {2.990421904,2.582790193,0.9365159989,4.703237538}, /*cfy*/
          {5.666657684,0.08342794894,1882.538155,6.941504169,0.01422320236,6.76071235}, /*cmz*/
          {1.483180048,-0.08715608592,4.939740298,3.1741658} /*cfz*/
     },
     {
          2461249.5,
          {17.78397574,-0.04202787206,1811.436754,7.284427307,0.01496213311,6.486167414}, /*cmx*/
          {2.257236337,0.5736126322,4.571753364,0.1409347835}, /*cfx*/
          {-5.08017947,-0.007559906776,516.3126039,3.052576188,0.01133331461,2.10566942}, /*cmy*/
          {5.363795167,4.743934025,2.634119243,3.260676512}, /*cfy*/
          {8.962489748,0.05688709287,1882.973966,7.524111236,0.01550100839,6.809430997}, /*cmz*/
          {3.825582317,2.244741745,-0.02994992023,1.705139757} /*cfz*/
     },
     {
          2461289.5,
          {16.02652628,-0.04664135573,1783.372559,6.724492083,0.02441244071,6.323646242}, /*cmx*/
          {4.598176791,2.915375152,0.07434386213,5.006869589}, /*cfx*/
          {-5.423121322,0.001691341059,604.3092325,2.765622097,0.01165188971,2.283332441}, /*cmy*/
          {1.445123078,0.6298063739,4.25484977,1.86092905}, /*cfy*/
          {11.59624177,0.04303727238,1882.6237,6.942357073,0.02463967617,6.700870997}, /*cmz*/
          {-0.1156891617,4.588063158,1.790745204,0.289329608} /*cfz*/
     },
     {
          2461329.5,
          {14.07131114,-0.02179118385,1761.361413,5.049855383,0.0403911394,6.43925279}, /*cmx*/
          {0.6785393503,5.274950325,2.170058855,3.594402448}, /*cfx*/
          {-5.421008311,0.00010922841,666.7302366,2.051142261,0.01740648992,2.543855525}, /*cmy*/
          {3.827548925,2.861371308,-0.2637572768,0.4741277775}, /*cfy*/
          {13.88613713,0.01942642222,1883.794549,5.284402728,0.0423423047,6.884399975}, /*cmz*/
          {2.250373883,0.6464163753,3.813769406,5.169164309} /*cfz*/
     },
     {
          2461369.5,
          {13.10932816,0.001631908719,1748.43128,1.792111185,0.04934478285,6.354781565}, /*cmx*/
          {3.093949271,1.427832709,4.571840805,2.274776103}, /*cfx*/
          {-5.384541671,-0.00101452581,698.6087383,0.6416604317,0.02081063838,2.551658198}, /*cmy*/
          {-0.02661549932,5.353204011,2.086209091,5.446334636}, /*cfy*/
          {14.62065613,0.002534447723,1882.651754,1.846874613,0.05241878484,6.822847141}, /*cmz*/
          {4.667609136,3.094487229,-0.04394703988,3.849859672} /*cfz*/
     },
     {
          2461409.5,
          {13.52493914,0.02578823025,1747.983523,-2.66555278,0.02117790437,6.353400166}, /*cmx*/
          {5.590712844,3.900607746,1.023768611,0.98874879}, /*cfx*/
          {-5.672710578,0.004040554331,697.62936,-1.274366442,0.008644342654,2.523648856}, /*cmy*/
          {2.477871841,1.348454214,5.152326082,4.150824113}, /*cfy*/
          {14.76409911,-0.04447202826,1882.417792,-2.974598011,0.01931096393,6.733134797}, /*cmz*/
          {0.8817491104,5.57423648,2.726776861,2.560636424} /*cfz*/
     },
     {
          2461449.5,
          {13.89389952,0.03945143374,1760.552122,-4.718874803,-0.03521163213,6.28273322}, /*cmx*/
          {1.879113797,0.2172727282,3.293442964,6.112624794}, /*cfx*/
          {-5.290259841,-0.0103890081,665.9765312,-2.02250782,0.01563475472,2.236988726}, /*cmy*/
          {5.049661456,4.122212012,3.98789783,2.963831252}, /*cfy*/
          {13.01174167,-0.01503006725,1883.05953,-4.942328013,-0.03734028503,6.637288363}, /*cmz*/
          {3.453641797,1.904884144,5.007408206,1.409200028} /*cfz*/
     },
     {
          2461489.5,
          {15.5683228,-0.004522615884,1774.019841,-1.782476991,-0.04804291878,6.394457368}, /*cmx*/
          {4.447798238,2.78185129,5.926348938,4.827914287}, /*cfx*/
          {-5.542833876,-0.0004966505129,630.7785722,-0.7321087337,0.02052597056,2.255913435}, /*cmy*/
          {1.328476499,0.5281240714,0.4514304274,1.697887325}, /*cfy*/
          {12.12129368,-0.0004229781853,1882.443736,-1.84231337,-0.05016926769,6.760849689}, /*cmz*/
          {6.021059159,4.43771414,1.296777719,0.117738685} /*cfz*/
     },
     {
          2461529.5,
          {15.57031022,-0.02626297654,1773.412431,2.278735332,-0.03299402718,6.484678323}, /*cmx*/
          {0.655616904,5.309968902,1.969580991,3.482659211}, /*cfx*/
          {-5.689865822,0.00240777588,631.0044476,1.008897648,0.0139045229,2.349528519}, /*cmy*/
          {3.815915727,2.941823457,2.640370168,0.3700549291}, /*cfy*/
          {12.37702523,0.02485595839,1882.751234,2.364109883,-0.03539842016,6.869531418}, /*cmz*/
          {2.22839011,0.6782751661,3.653821228,5.06059438} /*cfz*/
     },
     {
          2461569.5,
          {14.73059704,-0.05806661907,1760.248914,5.101461769,-0.01800334309,6.306625451}, /*cmx*/
          {3.069000339,1.421473734,3.942242621,2.05051038}, /*cfx*/
          {-5.626968674,0.00872757165,666.9385437,2.214022542,0.009972988793,2.542724733}, /*cmy*/
          {-0.05023490873,5.285479922,4.216745591,5.217094914}, /*cfy*/
          {13.01502696,0.05823132973,1882.454892,5.382190494,-0.01953903906,6.795084674}, /*cmz*/
          {4.642675661,3.084126834,5.592890583,3.629031089} /*cfz*/
     },
     {
          2461609.5,
          {12.5632934,-0.06064607422,1740.949267,6.421403676,-0.0114725143,6.243449894}, /*cmx*/
          {5.432630227,3.781809168,-0.6150319383,0.628755876}, /*cfx*/
          {-5.33406626,0.01289082704,717.0247581,2.755762249,0.01003908644,2.668528643}, /*cmy*/
          {2.322715006,1.231776808,-0.3204780123,3.809397234}, /*cfy*/
          {14.98453587,0.05823491634,1882.517554,6.833015001,-0.01401415658,6.803796818}, /*cmz*/
          {0.7248684261,5.439285758,1.007593133,2.206408098} /*cfz*/
     },
     {
          2461649.5,
          {10.08841577,-0.05418297528,1723.058088,6.873177138,-0.01277682163,6.236426064}, /*cmx*/
          {1.491833467,6.128544325,0.5505281919,5.446622591}, /*cfx*/
          {-4.813743016,0.01728976836,761.4645432,2.942027596,0.009490843107,2.846840129}, /*cmy*/
          {4.678054488,3.415309932,1.2490843,2.356476224}, /*cfy*/
          {17.39013281,0.02714827515,1882.898794,7.355201306,-0.01518997631,6.890573248}, /*cmz*/
          {3.069788747,1.487407209,2.318112372,0.7410074573} /*cfz*/
     },
     {
          2461689.5,
          {7.62815813,-0.05273268303,1709.378661,6.302835438,-0.02446444752,6.093847115}, /*cmx*/
          {3.834632483,2.220039525,2.46294019,4.027099604}, /*cfx*/
          {-4.030152924,0.02090409573,789.9309822,2.67124647,0.01226192657,2.847152879}, /*cmy*/
          {0.7520085142,5.635889397,2.888305407,0.957518674}, /*cfy*/
          {18.75377917,0.01286480333,1882.530198,6.756959235,-0.0260118418,6.756594017}, /*cmz*/
          {5.415582204,3.829103836,4.096669244,5.607179798} /*cfz*/
     },
     {
          2461729.5,
          {5.213540707,-0.02381096032,1704.640876,4.55828351,-0.04011748961,6.277051664}, /*cmx*/
          {-0.08035697361,4.594546321,4.617231067,2.634228093}, /*cfx*/
          {-3.076875356,0.008592647071,802.9358115,1.850266054,0.01787781667,2.967084326}, /*cmy*/
          {3.134967209,1.606159095,4.77620261,5.854617343}, /*cfy*/
          {19.64728959,0.007783376776,1882.528028,4.942078087,-0.04449186861,6.936102154}, /*cmz*/
          {1.504096535,-0.095464653,-0.07741719498,4.21532877} /*cfz*/
     },
     {
          2461769.5,
          {4.223919468,0.004769245622,1702.901174,1.253584865,-0.04642983028,6.224549866}, /*cmx*/
          {2.343658478,0.7744480687,0.774193818,1.322542165}, /*cfx*/
          {-2.733089285,-0.003335397429,805.2167535,0.3671812326,0.01972927305,2.951931232}, /*cmy*/
          {5.571884684,4.106494725,0.904086455,4.555337951}, /*cfy*/
          {19.78625095,0.00495521556,1881.585167,1.267080533,-0.04982303791,6.889696484}, /*cmz*/
          {3.930146618,2.370196359,2.373381166,2.906485895} /*cfz*/
     },
     {
          2461809.5,
          {4.664469726,0.04371769795,1702.289597,-3.001372069,-0.01383556575,6.236006796}, /*cmx*/
          {4.849976008,3.244863383,3.638530141,0.04165528552}, /*cfx*/
          {-3.029362474,-0.01757853937,805.2177143,-1.456642709,0.005628718517,2.95198077}, /*cmy*/
          {1.801942415,0.2150815969,4.254408032,3.27564867}, /*cfy*/
          {20.17801282,-0.02705874173,1881.691952,-3.314543032,-0.01349759406,6.910410191}, /*cmz*/
          {0.1548659279,4.86910001,5.15299538,1.614135197} /*cfz*/
     },
     {
          2461849.5,
          {5.945281738,0.03272141971,1704.670005,-4.389779588,0.03636616785,6.09370516}, /*cmx*/
          {1.141894101,5.845299838,5.808645248,5.153691554}, /*cfx*/
          {-3.461053553,-0.01507900248,802.0269105,-1.897569375,0.01716576891,2.84647701}, /*cmy*/
          {4.374485381,2.934462915,2.85495533,2.08510259}, /*cfy*/
          {18.74782547,0.004452235957,1881.466037,-4.672507509,0.0385488549,6.670514851}, /*cmz*/
          {2.729617368,1.172335937,1.139817835,0.4488351131} /*cfz*/
     },
     {
          2461889.5,
          {7.471054731,-0.006680710121,1707.610461,-1.363857973,0.04415537125,6.171377834}, /*cmx*/
          {3.704876923,2.092203278,2.095512662,3.862986723}, /*cfx*/
          {-4.100184577,0.003843607214,794.8194484,-0.4689311278,0.01921890902,2.869578488}, /*cmy*/
          {0.6456212499,5.571059109,5.504004347,0.7961922707}, /*cfy*/
          {18.79005881,-0.002138863357,1881.582388,-1.456634828,0.04860060059,6.795714812}, /*cmz*/
          {5.290145822,3.698075482,3.703937574,5.443358095} /*cfz*/
     },
     {
          2461929.5,
          {7.261031444,-0.03461841441,1707.088648,2.330788148,0.03130106821,6.259812207}, /*cmx*/
          {6.189259391,4.618343319,4.436418479,2.519329885}, /*cfx*/
          {-4.002903829,0.01428745632,795.0961928,1.157044122,0.01327121861,2.924681211}, /*cmy*/
          {3.124305167,1.740923919,1.353471149,5.741311073}, /*cfy*/
          {18.98701582,0.01252244993,1881.838475,2.613295635,0.03334781814,6.880357162}, /*cmz*/
          {1.490775313,6.223429111,6.040589294,4.100391187} /*cfz*/
     },
     {
          2461969.5,
          {6.285281571,-0.07300834467,1704.067077,4.987054957,0.01680238647,6.19976883}, /*cmx*/
          {2.316569788,0.7399059425,0.1825020622,1.081858929}, /*cfx*/
          {-3.606483725,0.03260392308,802.1759356,2.279417669,0.009463027293,2.93921797}, /*cmy*/
          {5.535806933,4.061170114,2.984617084,4.301792635}, /*cfy*/
          {19.28910117,0.01975453066,1881.506023,5.482149446,0.01892063835,6.825601195}, /*cmz*/
          {3.901536225,2.344238889,1.663707267,2.666203116} /*cfz*/
     },
     {
          2462009.5,
          {3.62767768,-0.07395814616,1703.191173,6.27684729,0.01070180637,6.183281605}, /*cmx*/
          {4.679350286,3.117648935,1.870941659,5.939458439}, /*cfx*/
          {-2.414270808,0.03184730532,804.6136214,2.795324991,0.009463242713,2.897387667}, /*cmy*/
          {1.622798468,0.02051628945,4.647388424,2.892673388}, /*cfy*/
          {19.92336445,0.01719333494,1881.525845,6.861396171,0.01408781054,6.803552089}, /*cmz*/
          {-0.01756715809,4.697971921,3.355863571,1.245567639} /*cfz*/
     },
     {
          2462049.5,
          {0.4961335335,-0.05441616555,1709.199209,6.735794539,0.0129225176,6.289220508}, /*cmx*/
          {0.7394820356,5.47289689,2.988495831,4.475545075}, /*cfx*/
          {-1.012757696,0.02063372478,794.1240535,2.902623741,0.01008436104,2.849303729}, /*cmy*/
          {3.977722098,2.218090577,-0.04799245819,1.434265283}, /*cfy*/
          {20.71161697,-0.004065656741,1882.277284,7.31331233,0.01523512438,6.90641529}, /*cmz*/
          {2.327243361,0.7389419674,4.615682984,6.068430952} /*cfz*/
     },
     {
          2462089.5,
          {-2.075239537,-0.04919039471,1720.218107,6.119960416,0.02570116951,6.185373291}, /*cmx*/
          {3.08560905,1.565803367,4.91899922,3.053933678}, /*cfx*/
          {-0.009922124946,0.01674088835,768.9921375,2.523616399,0.01259856585,2.698957965}, /*cmy*/
          {0.055674167,4.425237666,1.65115234,0.04580450959}, /*cfy*/
          {20.62237325,-0.0173558038,1881.443338,6.644011394,0.02881256495,6.757232603}, /*cmz*/
          {4.675090575,3.085803151,0.1521028293,4.651734199} /*cfz*/
     },
     {
          2462129.5,
          {-4.444767256,-0.02154502832,1734.831845,4.252311399,0.04209341427,6.394779776}, /*cmx*/
          {5.461232863,3.939500139,0.8083315852,1.68086445}, /*cfx*/
          {0.7929543293,0.008498381258,738.7782878,1.659693159,0.01791109995,2.673412831}, /*cmy*/
          {2.447785324,0.3743326041,3.570903074,4.947025659}, /*cfy*/
          {20.06696905,-0.004811984886,1880.915466,4.55298429,0.04599646764,6.935333677}, /*cmz*/
          {0.7683203774,5.458458726,2.33359522,3.271652237} /*cfz*/
     },
     {
          2462169.5,
          {-5.273088527,0.006982781471,1741.984253,0.7089052146,0.04419852319,6.361918316}, /*cmx*/
          {1.612297388,0.1887232583,3.294217114,0.3804052828}, /*cfx*/
          {1.031401287,-0.001631487515,719.5403155,0.1435557452,0.01734930054,2.668828951}, /*cmy*/
          {4.896172511,2.639017082,6.025305238,3.661324673}, /*cfy*/
          {19.66493144,0.01028725411,1880.272861,0.6992722184,0.04708479065,6.895930184}, /*cmz*/
          {3.203717372,1.656219605,4.794341312,1.974953248} /*cfz*/
     },
     {
          2462209.5,
          {-4.877211154,0.053295798,1739.109308,-3.409479089,0.007020393612,6.394753419}, /*cmx*/
          {4.128592935,2.628556318,6.418034001,5.382278633}, /*cfx*/
          {0.9778477286,-0.02270737596,727.7873654,1.494687588,0.002602244467,2.69489747}, /*cmy*/
          {1.133552564,2.260503017,3.555097516,2.375359303}, /*cfy*/
          {20.33212251,0.001902006276,1879.85691,-3.616617777,0.0087361874,7.02296002}, /*cmz*/
          {5.72162328,4.144722182,1.522945633,0.6928660503} /*cfz*/
     },
     {
          2462249.5,
          {-2.985812414,0.02407917491,1728.818119,-4.147776829,0.03798821543,6.124885847}, /*cmx*/
          {0.4221881667,5.223218196,5.206019896,4.199750324}, /*cfx*/
          {0.1693270147,-0.008251940527,752.7372169,1.663463872,-0.01677736126,2.715932523}, /*cmy*/
          {3.702121583,4.925890846,11.21428224,1.192446767}, /*cfy*/
          {19.84508774,0.01666194349,1879.883188,-4.453450672,0.04108056348,6.724968217}, /*cmz*/
          {2.014886858,0.4496790781,6.703437576,5.786734111} /*cfz*/
     },
     {
          2462289.5,
          {-1.821361955,-0.008571698135,1721.214884,-0.9862720948,0.04308206244,6.205407872}, /*cmx*/
          {2.977115927,1.428292048,1.44087429,2.904789611}, /*cfx*/
          {-0.2530229257,0.005951973461,767.0951374,0.2678804433,-0.01804840355,2.751501526}, /*cmy*/
          {6.24494058,0.9258046326,1.164033104,6.167591024}, /*cfy*/
          {20.53388152,-0.006161649726,1880.548011,-1.021165698,0.04714399756,6.803072755}, /*cmz*/
          {4.568665721,2.970661826,2.982051686,4.495375741} /*cfz*/
     },
     {
          2462329.5,
          {-2.166304267,-0.04122563136,1723.100743,2.590466636,0.03108695294,6.283151828}, /*cmx*/
          {5.453794991,3.963866999,3.781972016,1.561130728}, /*cfx*/
          {-0.008105087271,0.01696138294,763.037887,1.256239186,-0.01283249835,2.734076972}, /*cmy*/
          {2.431832636,0.6141871687,3.254268852,4.828485682}, /*cfy*/
          {20.50905648,-0.005903729174,1880.3901,2.927872487,0.03233359708,6.867343115}, /*cmz*/
          {0.7611580116,5.505145378,5.265306669,3.148703058} /*cfz*/
     },
     {
          2462369.5,
          {-3.307422991,-0.07530695337,1733.173049,5.230506993,0.01708786426,6.346285465}, /*cmx*/
          {1.576781434,0.08766647602,5.756211551,0.1221822888}, /*cfx*/
          {0.4749453986,0.0259200996,739.8276904,2.316734253,-0.009918766356,2.583101333}, /*cmy*/
          {4.840115616,2.888152326,4.781492453,3.387856667}, /*cfy*/
          {20.36557229,-0.02498057634,1880.583265,5.689871779,0.01884305895,6.844302847}, /*cmz*/
          {3.166066216,1.608322195,0.8817260721,1.706209767} /*cfz*/
     },
     {
          2462409.5,
          {-6.073994221,-0.07416861899,1751.714659,6.543849648,0.01254032674,6.368524871}, /*cmx*/
          {3.937658844,2.458887278,1.085365638,4.979688874}, /*cfx*/
          {1.482109144,0.01909239958,694.76843,2.765596304,-0.01132270936,2.377084372}, /*cmy*/
          {0.9280325236,5.09615656,0.2353571759,1.992876526}, /*cfy*/
          {19.38972866,-0.02661504972,1880.632316,7.032524273,0.01396085022,6.780272118}, /*cmz*/
          {5.526208229,3.957214505,2.518489407,0.2820906135} /*cfz*/
     },
     {
          2462449.5,
          {-9.350980111,-0.04737672834,1777.335622,6.948331955,0.01513023717,6.584883963}, /*cmx*/
          {-0.00204503209,4.794086814,2.330825941,3.519686145}, /*cfx*/
          {2.416171761,0.004494750778,629.7606298,2.841474052,-0.01071663935,2.109036467}, /*cmy*/
          {3.288851797,0.9475876088,1.882131625,0.5332659131}, /*cfy*/
          {18.24767247,-0.02985015854,1881.569148,7.398629338,0.01657224117,6.869915091}, /*cmz*/
          {1.585358977,-0.005560618997,3.75718746,5.105574595} /*cfz*/
     },
     {
          2462489.5,
          {-11.61654307,-0.03670520469,1802.779557,6.211655513,0.02867822849,6.503776948}, /*cmx*/
          {2.34736491,0.8597496206,4.186824983,2.098709695}, /*cfx*/
          {2.704596274,-0.004200302403,552.0757152,2.508456553,-0.01317280118,1.843953714}, /*cmy*/
          {5.66489378,3.109315524,3.475265447,5.471022154}, /*cfy*/
          {16.88790523,-0.04049451674,1880.535372,6.562946019,0.03127081005,6.697900214}, /*cmz*/
          {3.933259218,2.346950287,5.669766268,3.688745711} /*cfz*/
     },
     {
          2462529.5,
          {-13.4316758,-0.01779048219,1822.878779,4.092693641,0.04513903477,6.684769551}, /*cmx*/
          {4.729567318,3.230492078,0.09495076589,0.7374223926}, /*cfx*/
          {2.524573636,0.001470636146,482.2861121,1.607679051,-0.01813785062,1.691440896}, /*cmy*/
          {1.795490259,5.329056148,5.39221342,4.081358004}, /*cfy*/
          {15.2044245,-0.01512478595,1880.617171,4.227266937,0.04688253001,6.864944237}, /*cmz*/
          {0.03016416678,4.720443581,1.591540006,2.321913088} /*cfz*/
     },
     {
          2462569.5,
          {-13.92885143,0.002548137064,1830.968523,0.2418010042,0.04268789668,6.656510604}, /*cmx*/
          {0.8895101589,5.964635227,2.603352155,5.732862759}, /*cfx*/
          {2.408445591,0.005006559997,448.5740327,0.07204667288,-0.01681869781,1.715446991}, /*cmy*/
          {4.262927416,0.8975091035,1.559338625,2.806800035}, /*cfy*/
          {14.44855792,0.01519982544,1879.672812,0.2638922142,0.04505980613,6.82331968}, /*cmz*/
          {2.473243468,1.089007272,4.082783234,1.034649513} /*cfz*/
     },
     {
          2462609.5,
          {-13.84681242,0.05041491778,1826.59802,3.765475655,0.003611221582,6.782604961}, /*cmx*/
          {3.414023114,5.089838353,6.408825733,4.453092725}, /*cfx*/
          {2.754575906,-0.005269139932,469.653198,-1.501697515,-0.002190789999,1.798381332}, /*cmy*/
          {0.4984301286,123.4721042,-38.32921401,1.493780794}, /*cfy*/
          {15.29506424,0.03270347613,1879.304577,3.917984593,-0.005533104122,6.97826544}, /*cmz*/
          {4.998402291,6.554765877,-1.600731484,6.048345661} /*cfz*/
     },
     {
          2462649.5,
          {-11.79116335,0.01421533339,1811.618136,4.043791304,-0.04067992963,6.392017526}, /*cmx*/
          {5.990743656,1.398515643,13.95271543,3.251704329}, /*cfx*/
          {2.455133793,0.00119457568,522.8365834,-1.559584715,-0.01643333805,1.927387602}, /*cmy*/
          {3.048043707,0.4529786367,-2.634396135,0.3110835801}, /*cfy*/
          {16.07112079,0.0199162384,1880.060517,4.274902082,0.04375066503,6.694636147}, /*cmz*/
          {1.292992447,2.875521181,5.998886463,4.844730128} /*cfz*/
     },
     {
          2462689.5,
          {-11.07752686,-0.009614878361,1801.185918,0.6509030998,-0.04467479788,6.477417793}, /*cmx*/
          {2.254746621,3.846971052,3.886610595,1.955309127}, /*cfx*/
          {2.50197667,0.001568255373,554.7467886,-0.2313851626,-0.01793685974,1.955884265}, /*cmy*/
          {5.573847155,2.340187839,6.147929537,5.271872052}, /*cfy*/
          {17.07580058,-0.01458197707,1880.174818,0.6153188286,0.04639367012,6.751814787}, /*cmz*/
          {3.84084349,5.342480684,2.242975093,3.545664524} /*cfz*/
     },
     {
          2462729.5,
          {-11.51508466,-0.04102882284,1805.614984,-3.061945627,-0.03163858804,6.523283844}, /*cmx*/
          {4.723595487,0.1298599023,-0.1087621756,0.6084614956}, /*cfx*/
          {2.606377128,0.003955141936,540.2959615,1.347237533,-0.01347305517,1.855735281}, /*cmy*/
          {1.754624905,-0.6270216759,1.849957794,3.936505687}, /*cfy*/
          {16.70255211,-0.03043966794,1879.980777,-3.257153117,0.03266344003,6.78770859}, /*cmz*/
          {0.02504291554,1.633074538,4.486229464,2.197142339} /*cfz*/
     },
     {
          2462769.5,
          {-12.77331291,-0.05719035252,1821.742147,-5.760844873,-0.01866740134,6.643939533}, /*cmx*/
          {0.8403983575,2.517999558,1.714410895,5.449340375}, /*cfx*/
          {2.763221229,-0.00868413035,481.7085434,2.405597601,-0.01239398196,1.502675852}, /*cmy*/
          {4.167751276,1.582511267,3.463141439,2.496351664}, /*cfy*/
          {15.88775071,-0.06385147226,1880.796885,-6.003741617,0.01864582213,6.826640178}, /*cmz*/
          {2.422931516,4.001796165,0.0966050169,0.7469538733} /*cfz*/
     },
     {
          2462809.5,
          {-14.96378111,-0.05385905986,1844.179142,-7.063007642,-0.01637874499,6.611438957}, /*cmx*/
          {3.197089223,4.856636811,3.305155809,4.021798152}, /*cfx*/
          {2.493510501,-0.01688491503,386.9569024,2.961826125,-0.01248908102,1.152597886}, /*cmy*/
          {0.2796730279,3.73638505,5.230984896,1.177080463}, /*cfy*/
          {13.4125684,-0.06239810485,1880.640804,-7.320197049,0.01450672951,6.739549545}, /*cmz*/
          {4.777082806,0.06654720409,1.615875103,5.60081239} /*cfz*/
     },
     {
          2462849.5,
          {-17.42584466,-0.02817592057,1866.203912,-7.332481206,-0.018387029,6.816510157}, /*cmx*/
          {5.538101293,0.8648831841,4.677726516,2.564591393}, /*cfx*/
          {1.817515183,-0.01855946408,270.6503256,3.140863188,-0.01158289471,0.6696369587}, /*cmy*/
          {2.707605461,5.86583295,0.4977655831,6.081646927}, /*cfy*/
          {10.55254339,-0.0481695959,1881.703476,-7.541736235,0.01836598933,6.845092701}, /*cmz*/
          {0.8317678573,2.384622247,2.959042059,4.136308673} /*cfz*/
     },
     {
          2462889.5,
          {-18.79044515,-0.008617593959,1878.578275,-6.414364878,-0.03220437549,6.680167649}, /*cmx*/
          {1.60430674,3.183507917,0.218874998,1.148767099}, /*cfx*/
          {1.032654976,-0.02220723186,156.6892367,2.75563349,-0.01423248053,0.4276583113}, /*cmy*/
          {5.281313945,1.760697392,2.079105067,5.228604221}, /*cfy*/
          {8.302743363,-0.05220365054,1881.091523,-6.529292197,0.03244472639,6.665650285}, /*cmz*/
          {3.178062801,4.733683845,4.89700477,2.71441992} /*cfz*/
     },
     {
          2462929.5,
          {-19.34557792,-0.007988268412,1882.494775,-4.005280994,-0.0469389686,6.815466065}, /*cmx*/
          {3.9884711,5.547473545,2.412912534,6.072197978}, /*cfx*/
          {-0.006097578838,-0.006991994541,86.26953309,1.742785702,-0.02016616817,0.2549549309}, /*cmy*/
          {1.961149571,4.013396927,4.01935482,4.313095105}, /*cfy*/
          {6.031630388,-0.02218119695,1881.6011,-4.076477326,0.0476400885,6.799490955}, /*cmz*/
          {5.560081324,0.8251100952,0.8330068278,1.358084275} /*cfz*/
     },
     {
          2462969.5,
          {-19.31353628,-0.007701406076,1882.490832,-0.0631467558,-0.0425807328,6.779057815}, /*cmx*/
          {0.1530829386,-9.146204194,4.922843283,4.792455333}, /*cfx*/
          {-0.3558123483,0.007819418358,77.05534284,-0.0592056403,-0.01851838983,0.2760736389}, /*cmy*/
          {4.91126996,11.0316782,0.2593981653,2.854608403}, /*cfy*/
          {5.164080842,0.0148545057,1880.520045,0.08595881314,0.04363554433,6.771784316}, /*cmz*/
          {1.723754081,8.054779359,3.356965758,0.07580012363} /*cfz*/
     },
     {
          2463009.5,
          {-19.79089133,0.02533572156,1882.624483,-3.960352983,-0.004490007615,7.032157123}, /*cmx*/
          {2.682139103,76.52211126,-15.96232996,3.524403686}, /*cfx*/
          {0.04045371429,0.02109704295,81.20640946,1.746392802,-0.003364497495,0.2696293548}, /*cmy*/
          {0.7711113763,18.42426335,4.626870346,1.173783788}, /*cfy*/
          {5.843120833,0.05756297321,1881.07835,4.129696689,-0.005364118492,6.947368952}, /*cmz*/
          {4.252938692,12.10448668,4.757749362,5.091608182} /*cfz*/
     },
     {
          2463049.5,
          {-18.43776311,0.003252300768,1879.914731,-4.04602531,-0.04403216125,6.653672266}, /*cmx*/
          {5.258987038,3.730171275,-5.709466354,2.303210537}, /*cfx*/
          {0.7945099547,0.005650927531,126.2750809,1.765068422,0.01908579887,0.5440551069}, /*cmy*/
          {2.757512004,2.250148527,11.71057453,6.054405373}, /*cfy*/
          {7.765707135,0.0196436262,1881.583535,4.154689637,-0.04572682689,6.626421694}, /*cmz*/
          {0.5486595274,2.14184285,8.418535289,3.883582232} /*cfz*/
     },
     {
          2463089.5,
          {-18.30625429,-0.003787095642,1876.884723,-0.3523017049,-0.04682796782,6.732460381}, /*cmx*/
          {1.518382851,6.111782319,3.080105144,1.00457919}, /*cfx*/
          {1.190789488,-0.009006180604,162.5794008,0.2152911762,0.01997289263,0.5190307658}, /*cmy*/
          {5.125457839,4.09757789,1.627023971,4.681378768}, /*cfy*/
          {8.864606827,-0.02311994445,1880.881343,0.3280675737,-0.04704289667,6.706382453}, /*cmz*/
          {3.09230264,4.453041766,4.617951881,2.579249704} /*cfz*/
     },
     {
          2463129.5,
          {-18.56661961,-0.02344844753,1878.434772,3.577675981,-0.03218371005,6.725451811}, /*cmx*/
          {3.980024664,-3.811959369,5.262372631,5.936308908}, /*cfx*/
          {0.8616018207,-0.0175927689,137.3487572,-1.526228099,0.01559632545,0.4084205634}, /*cmy*/
          {1.365155505,-5.158782371,3.623403434,3.548714592}, /*cfy*/
          {8.175679509,-0.05421584561,1881.035712,3.584536802,-0.03343303034,6.69625331}, /*cmz*/
          {5.552806845,-2.270330559,0.5722562572,1.227788338} /*cfz*/
     },
     {
          2463169.5,
          {-19.45307328,-0.01019132051,1882.159732,6.281987342,-0.02061240886,6.808102384}, /*cmx*/
          {0.08876039437,4.82198115,0.7099036817,4.482467693}, /*cfx*/
          {0.2969138926,-0.03477295916,71.01517461,-2.752569178,0.01234537842,0.2651638504}, /*cmy*/
          {4.346499655,3.328482242,5.21461767,10.00264773}, /*cfy*/
          {6.570637514,-0.08378427986,1881.743589,6.386631166,-0.01825445552,6.793368211}, /*cmz*/
          {1.66033906,0.09457716565,2.403832442,6.057612675} /*cfz*/
     },
     {
          2463209.5,
          {-19.87792404,-0.005520122717,1880.19302,7.523218385,-0.01805013991,6.654573156}, /*cmx*/
          {2.438206998,0.8443491079,2.298260039,3.049073117}, /*cfx*/
          {-1.068710755,-0.03725184905,111.5067898,-3.314008389,0.01332231998,0.6459970602}, /*cmy*/
          {1.891251324,5.515265035,0.5613339711,2.670155296}, /*cfy*/
          {3.227945211,-0.08029300514,1881.472155,7.63251131,-0.0160642271,6.679547149}, /*cmz*/
          {4.00748376,2.441350512,3.886764648,4.622765511} /*cfz*/
     },
     {
          2463249.5,
          {-20.12290779,0.005621483451,1869.518029,7.633892667,-0.02045669212,6.73103388}, /*cmx*/
          {4.772708475,3.122843587,3.724779358,1.584507844}, /*cfx*/
          {-2.68966785,-0.02547059273,237.4958699,-3.282253732,0.01231289365,1.139550581}, /*cmy*/
          {4.560453118,1.369179412,2.188330227,1.476788169}, /*cfy*/
          {-0.523714748,-0.05725901568,1883.022081,7.708574877,-0.01922347126,6.830616664}, /*cmz*/
          {0.05679999388,4.750766262,-0.9566501475,3.156858355} /*cfz*/
     },
     {
          2463289.5,
          {-19.93367927,0.025656029,1849.961862,6.528076027,-0.0331099293,6.484913409}, /*cmx*/
          {0.8337876677,5.445516154,5.618159388,0.1664453868}, /*cfx*/
          {-3.787367287,-0.01437012258,354.8729963,-2.761219903,0.01483015603,1.433764165}, /*cmy*/
          {0.7154474539,3.548785353,3.794482067,0.04576334978}, /*cfy*/
          {-3.129446217,-0.05040402346,1882.740835,6.621469516,-0.03298928173,6.683222869}, /*cmz*/
          {2.400206622,0.808644004,0.9570143965,1.72977718} /*cfz*/
     },
     {
          2463329.5,
          {-18.95235445,0.007419155216,1831.803331,4.02643388,-0.04665876136,6.571911366}, /*cmx*/
          {3.21417812,1.529556196,1.53869651,5.090651968}, /*cfx*/
          {-4.47116116,-0.007157484634,437.5191433,-1.673811316,0.01985390095,1.639654247}, /*cmy*/
          {3.135977247,5.838050831,-0.4880656735,5.037457107}, /*cfy*/
          {-5.327867983,-0.02596599341,1882.687792,4.128992078,-0.04802703644,6.782516005}, /*cmz*/
          {4.780952721,3.190288565,3.196074925,0.3741510594} /*cfz*/
     },
     {
          2463369.5,
          {-18.4079076,-0.01436714024,1822.708748,0.0950511067,-0.04348654488,6.539959779}, /*cmx*/
          {5.660204872,4.897468594,4.052062755,3.807218057}, /*cfx*/
          {-4.66827254,0.001073611016,470.4298663,-0.1416777126,0.01849824008,1.591359828}, /*cmy*/
          {5.599407774,-21.46483349,2.050101475,3.754143653}, /*cfy*/
          {-6.095025741,0.00725698863,1882.065225,-0.07629350309,-0.04387350439,6.759298404}, /*cmz*/
          {0.9438265551,22.92924337,5.716251572,5.376721743} /*cfz*/
     },
     {
          2463409.5,
          {-19.15330406,-0.01822831036,1828.629714,4.014577661,-0.005696244967,6.818786576}, /*cmx*/
          {1.905892664,34.78794103,-4.23109252,2.549575207}, /*cfx*/
          {-4.764589724,0.02085884308,446.5005769,1.752443257,-0.004018633742,1.575795378}, /*cmy*/
          {1.847750501,23.32614578,-3.186206051,2.563666151}, /*cfy*/
          {-5.936212834,0.06444101677,1883.060808,-4.15802774,0.004319072224,7.046754148}, /*cmz*/
          {3.473342405,64.74717496,0.9815699473,4.110591172} /*cfz*/
     },
     {
          2463449.5,
          {-19.44635796,-0.004871974268,1843.332529,4.110613743,0.04661455796,6.54903545}, /*cmx*/
          {4.48490475,5.988037659,9.116775221,1.326979602}, /*cfx*/
          {-3.784281389,0.002359783182,384.6410483,1.79566606,-0.01986050858,1.321481404}, /*cmy*/
          {4.415082238,0.9227458482,0.9019847849,1.213348813}, /*cfy*/
          {-3.442814905,0.01754536134,1882.758476,-4.15057733,0.04687383179,6.640117272}, /*cmz*/
          {6.053094969,4.504962916,10.78495553,2.888861131} /*cfz*/
     },
     {
          2463489.5,
          {-19.95533683,0.01339484757,1850.541421,0.1876999009,0.04779914907,6.61901063}, /*cmx*/
          {0.7443825532,1.895740332,5.3324423,0.02386825479}, /*cfx*/
          {-3.51861229,-0.009574768116,346.5652752,0.125671593,-0.02086651342,1.336211315}, /*cmy*/
          {0.6628747932,3.103067024,3.402422441,6.22791237}, /*cfy*/
          {-2.471798685,-0.02433564359,1882.06907,-0.2141243761,0.04903749587,6.745064508}, /*cmz*/
          {2.312350835,0.3887131431,0.689572972,1.587023231} /*cfz*/
     },
     {
          2463529.5,
          {-19.64083198,0.01470921053,1844.690568,-3.836797782,0.03266396342,6.54752963}, /*cmx*/
          {3.20084615,-1.553088494,1.203535877,4.952759238}, /*cfx*/
          {-3.953568672,-0.01833201291,373.0169122,-1.661294746,-0.0141887341,1.457590417}, /*cmy*/
          {3.130322435,-0.3202040131,5.333091616,4.866945595}, /*cfy*/
          {-3.258415596,-0.06337784205,1882.319256,3.88558173,0.033429456,6.703490933}, /*cmz*/
          {4.768865453,-3.062727854,2.920078835,0.2286039586} /*cfz*/
     },
     {
          2463569.5,
          {-19.3379397,0.04143069278,1828.364274,-6.515664546,0.01850935292,6.589722338}, /*cmx*/
          {5.584824122,0.7830225781,2.992250045,3.488197341}, /*cfx*/
          {-4.714965189,-0.01333076537,450.7693866,-2.796667365,-0.01241211318,1.895175471}, /*cmy*/
          {5.539035717,1.919639018,0.506058099,3.471180434}, /*cfy*/
          {-5.366614999,-0.07461799405,1882.315946,6.7038884,0.01861297365,6.82476286}, /*cmz*/
          {0.8700903404,5.590296606,4.667942204,5.055664366} /*cfz*/
     },
     {
          2463609.5,
          {-17.59542592,0.04238552199,1800.981025,-7.660456446,0.01609525511,6.368781913}, /*cmx*/
          {1.642340787,3.114016288,4.435344185,2.045215355}, /*cfx*/
          {-5.308492255,-0.01018079306,548.3353405,-3.209397755,-0.0130852681,2.145031574}, /*cmy*/
          {1.621303081,4.081819874,2.238276373,2.019162595}, /*cfy*/
          {-8.460247485,-0.07183208949,1882.252829,7.878017457,0.01717901784,6.678432636}, /*cmz*/
          {3.211222081,1.64530895,-0.07272712854,3.610957754} /*cfz*/
     },
     {
          2463649.5,
          {-15.54560152,0.03758071293,1772.251168,-7.57176761,0.01912670423,6.411431582}, /*cmx*/
          {3.968095707,5.424461142,-0.3129641559,0.5727695461}, /*cfx*/
          {-5.674201786,-0.003342834275,638.0426977,-3.156391043,-0.01185200242,2.505837383}, /*cmy*/
          {3.969584344,-0.07346325245,3.880818645,0.590056529}, /*cfy*/
          {-11.80281836,-0.05053561201,1883.939901,7.906636421,0.01949276609,6.84654403}, /*cmz*/
          {5.539079111,3.946519633,1.390389116,2.145976056} /*cfz*/
     },
     {
          2463689.5,
          {-13.96148936,0.04837676992,1746.591108,-6.459723876,0.03091057839,6.188031672}, /*cmx*/
          {0.02181659177,1.489958585,1.645032769,5.420154761}, /*cfx*/
          {-5.804961735,0.01049178291,704.2970765,-2.660156238,-0.01405965245,2.591159657}, /*cmy*/
          {0.04183599657,2.112127146,-0.7594211184,5.441500194}, /*cfy*/
          {-14.04953935,-0.03200076725,1883.37937,6.837030447,0.0332217468,6.707175851}, /*cmz*/
          {1.595482964,0.0009758603651,3.302502205,0.7159432101} /*cfz*/
     },
     {
          2463729.5,
          {-12.01107394,0.02277064067,1730.268378,-4.127104129,0.04453857899,6.238728437}, /*cmx*/
          {2.395233987,3.875267711,3.885305145,4.059123775}, /*cfx*/
          {-5.384933669,0.004273702228,743.8165379,-1.633099114,-0.01929481868,2.721963937}, /*cmy*/
          {2.431511966,4.39220422,1.22187435,4.104937029}, /*cfy*/
          {-15.42388048,-0.02259346845,1882.654507,4.356167995,0.04780594819,6.810604892}, /*cmz*/
          {3.971691926,2.38079616,5.53123022,5.638918362} /*cfz*/
     },
     {
          2463769.5,
          {-11.09579791,-0.01309493071,1723.056318,-0.3494450478,0.04383491232,6.225908341}, /*cmx*/
          {4.834121119,0.2517027563,0.1057780118,2.766016064}, /*cfx*/
          {-5.197923437,-0.005003527626,758.1513891,0.1331610012,-0.01848555931,2.711627644}, /*cmy*/
          {4.88280972,-70.03841062,3.771160886,2.821243795}, /*cfy*/
          {-15.91487557,-0.002317229354,1882.02565,0.3011720045,0.04654822602,6.766177063}, /*cmz*/
          {0.1296709834,5.038546941,1.744759299,4.349074611} /*cfz*/
     },
     {
          2463809.5,
          {-11.53019623,-0.05318702976,1726.848314,-3.830451394,-0.00422444186,6.514364437}, /*cmx*/
          {1.075366085,5.716325912,7.214655804,1.506713541}, /*cfx*/
          {-5.496630889,-0.0113910919,750.7708072,1.770058622,-0.004959844411,2.768803462}, /*cmy*/
          {1.130218776,15.59639916,-23.33976121,1.585838953}, /*cfy*/
          {-16.31213303,0.04537314751,1882.296192,4.042301656,-0.004289104365,7.132034098}, /*cmz*/
          {2.655471343,4.228534322,-129.5763105,3.099849658} /*cfz*/
     },
     {
          2463849.5,
          {-13.39601093,-0.01021227814,1738.517432,-4.121098933,-0.04570664299,6.195423985}, /*cmx*/
          {3.65716829,2.029051204,11.44783342,0.2852924415}, /*cfx*/
          {-5.709100008,-0.002822020791,724.8424912,1.768111515,0.02060172625,2.573483612}, /*cmy*/
          {3.709332435,5.784130755,8.869005841,0.32629091}, /*cfy*/
          {-14.24458908,0.01473609446,1882.236447,4.329044914,0.04799881344,6.742969269}, /*cmz*/
          {5.235773243,0.5368365107,9.950166877,1.85807115} /*cfz*/
     },
     {
          2463889.5,
          {-14.32911591,0.02569842853,1745.581816,-0.2614621364,-0.0476934172,6.292116948}, /*cmx*/
          {6.203968,4.311093736,1.365131074,5.268349134}, /*cfx*/
          {-5.934456787,0.006261915812,705.2257637,0.03072736938,0.02018522428,2.595719575}, /*cmy*/
          {6.249140468,2.664709858,5.103367667,5.310361796}, /*cfy*/
          {-13.60690843,-0.01430223518,1882.231988,0.2556573595,0.05094628594,6.830069896}, /*cmz*/
          {1.497866349,2.846436318,6.16725556,0.5622552329} /*cfz*/
     },
     {
          2463929.5,
          {-13.61729629,0.04778600951,1740.249356,-3.724907691,-0.03192653623,6.190394126}, /*cmx*/
          {2.376662927,-2.387254686,3.595770909,3.906992524}, /*cfx*/
          {-5.823250766,0.008899624126,717.4297029,1.69110479,0.01439480188,2.601948186}, /*cmy*/
          {2.419153598,39.05411468,0.7219172099,3.946766704}, /*cfy*/
          {-14.101329,-0.04902108273,1881.95561,4.037994965,0.03348074577,6.772596053}, /*cmz*/
          {3.953978763,2.411757058,2.074417104,5.483972546} /*cfz*/
     },
     {
          2463969.5,
          {-12.10783874,0.06623240439,1726.785968,-6.3771088,-0.01560085262,6.291310591}, /*cmx*/
          {4.756866196,-0.02173209945,5.430832426,2.445772111}, /*cfx*/
          {-5.65277907,0.02298348534,751.9269587,2.806773946,0.0114008798,2.851396728}, /*cmy*/
          {4.804404501,3.592378373,2.281559828,2.506183853}, /*cfy*/
          {-15.94922377,-0.03918760038,1882.153146,6.822506528,0.0195083824,6.928270615}, /*cmz*/
          {0.05176786667,4.772654746,3.832043123,4.023719738} /*cfz*/
     },
     {
          2464009.5,
          {-9.231604841,0.06657358021,1711.312295,-7.428910426,-0.01421720531,6.118683233}, /*cmx*/
          {0.8092705087,2.343892893,0.5643920138,0.9909516754}, /*cfx*/
          {-4.683527845,0.02570631625,784.891025,3.267342139,0.01255339156,2.848519327}, /*cmy*/
          {0.867542784,5.794934273,3.932732446,1.057850352}, /*cfy*/
          {-17.59826809,-0.0377188175,1881.962409,8.015507988,0.01730908809,6.760010142}, /*cmz*/
          {2.390070304,0.8208796957,-0.9078822364,2.567883532} /*cfz*/
     },
     {
          2464049.5,
          {-6.068307795,0.05697567727,1704.716544,-7.370444458,-0.0163436565,6.255201675}, /*cmx*/
          {3.131003804,4.673500824,2.111933741,5.806219852}, /*cfx*/
          {-3.435073129,0.02280761947,803.3520514,3.183035955,0.01150732996,2.963746663}, /*cmy*/
          {3.203374952,1.669299303,-0.6350396022,5.887222033}, /*cfy*/
          {-19.24822615,-0.02376123439,1882.840339,8.043588467,0.01974209617,6.928047955}, /*cmz*/
          {4.715178335,3.12515078,0.6166559293,1.102804697} /*cfz*/
     },
     {
          2464089.5,
          {-3.716076349,0.05773800439,1705.123717,-6.461745802,-0.02856104547,6.164696603}, /*cmx*/
          {5.46454789,0.7488981087,4.047179013,4.358683484}, /*cfx*/
          {-2.484982654,0.02269964259,802.786853,2.711972976,0.01399899403,2.850826947}, /*cmy*/
          {5.552952957,3.860031323,1.011137469,4.464258548}, /*cfy*/
          {-20.37459325,0.00242879991,1882.185025,7.03152475,0.03222094101,6.75535694}, /*cmz*/
          {0.7682822656,5.458915806,2.513096424,5.945544568} /*cfz*/
     },
     {
          2464129.5,
          {-1.413947585,0.03430726714,1710.77185,-4.350669285,-0.04319979934,6.232503288}, /*cmx*/
          {1.55017358,3.141052001,0.01095737262,2.992431433}, /*cfx*/
          {-1.593805915,0.01408950961,790.5213511,1.713380807,0.01886525294,2.87296791}, /*cmy*/
          {1.654949389,-0.1585860575,3.019239845,3.105114006}, /*cfy*/
          {-20.33798672,-0.004838116868,1881.467702,4.658194271,0.04701766031,6.833919068}, /*cmz*/
          {3.139163908,1.54487544,4.703046724,4.584182242} /*cfz*/
     },
     {
          2464169.5,
          {-0.260353966,-0.007883076354,1714.942477,-0.7095524141,-0.04558417103,6.21393651}, /*cmx*/
          {3.982163963,5.668110678,2.491378944,1.689169085}, /*cfx*/
          {-1.156448348,-0.004353479539,780.7594019,0.1120911395,0.01849823479,2.853275239}, /*cmy*/
          {4.100814655,2.328433335,5.483014546,1.817213573}, /*cfy*/
          {-20.27010522,-0.007220210041,1880.30467,0.7087370167,0.04962064739,6.80860669}, /*cmz*/
          {5.573263787,4.08802871,0.8986511651,3.278499068} /*cfz*/
     },
     {
          2464209.5,
          {-0.2054975371,-0.06722738571,1713.619348,3.595350518,-0.005482122371,6.551750268}, /*cmx*/
          {0.2170692208,1.839697283,5.579853177,0.4427081192}, /*cfx*/
          {-1.140441498,-0.03023741987,785.8120654,-1.654089476,0.002882445057,3.031106329}, /*cmy*/
          {0.3412552858,4.844901088,3.349155113,0.5553985369}, /*cfy*/
          {-20.76528819,0.00246279569,1879.881726,-3.944586092,0.00761935825,7.114036344}, /*cmz*/
          {1.809318727,0.2198533653,4.274579752,2.037880003} /*cfz*/
     },
     {
          2464249.5,
          {-2.876170868,-0.01763257217,1707.75414,4.209533666,-0.04363983167,6.13468475}, /*cmx*/
          {2.798830615,4.418908537,4.411205844,5.479520727}, /*cfx*/
          {-2.324473586,-0.00645434581,797.9113627,-1.740132496,-0.02008700419,2.888694671}, /*cmy*/
          {2.916743155,1.244689922,4.377852362,5.592587297}, /*cfy*/
          {-20.27818881,0.01101733159,1880.887539,-4.604609943,-0.04883387236,6.783869872}, /*cmz*/
          {4.390294038,2.833412324,5.956454486,0.7941855945} /*cfz*/
     },
     {
          2464289.5,
          {-4.010072901,0.02476686229,1704.88283,0.4945919182,-0.04808551682,6.216328797}, /*cmx*/
          {5.350798629,0.5788593677,0.6261146116,4.194467642}, /*cfx*/
          {-2.817319419,0.01427964981,802.0595637,-0.05430105711,-0.02045676746,2.926538497}, /*cmy*/
          {5.457545923,2.717257088,0.572954265,4.293367897}, /*cfy*/
          {-20.21949513,0.00593231337,1880.897409,-0.4527105967,-0.0520510776,6.856275773}, /*cmz*/
          {0.6577182746,5.252628178,2.193340413,5.785955778} /*cfz*/
     },
     {
          2464329.5,
          {-3.329793752,0.06145356847,1706.028081,-3.526905341,-0.03167880868,6.146246645}, /*cmx*/
          {1.527954828,3.144502367,2.891775429,2.828423476}, /*cfx*/
          {-2.373863776,0.02723995965,799.0150747,-1.708074779,-0.01366804752,2.830500572}, /*cmy*/
          {1.629009775,-22.00098716,2.516907665,2.932334869}, /*cfy*/
          {-20.11371401,-0.01230242879,1880.370904,3.934908184,-0.03444872577,6.741519306}, /*cmz*/
          {3.116944923,1.586002586,4.368085921,4.425841644} /*cfz*/
     },
     {
          2464369.5,
          {-1.178173938,0.06886959582,1712.576781,-6.186339798,-0.01637963687,6.343919344}, /*cmx*/
          {3.910813085,5.530018321,4.746536734,1.379617017}, /*cfx*/
          {-1.374687398,0.02726409307,785.2773716,-2.788517853,-0.01138317164,2.834409188}, /*cmy*/
          {4.014858021,-0.8972454508,3.967766836,1.484236492}, /*cfy*/
          {-20.74665018,0.005354054393,1881.558726,6.737498588,-0.01944398294,6.951397737}, /*cmz*/
          {5.499294763,3.93116478,-0.08358451536,2.972447794} /*cfz*/
     },
     {
          2464409.5,
          {1.841572762,0.07367259206,1726.906825,-7.33037451,-0.01480442115,6.249688807}, /*cmx*/
          {-0.0334406768,1.612651039,-0.02559756191,-0.08263690721}, /*cfx*/
          {-0.1423786078,0.02665726359,752.7247933,-3.155144036,-0.01324619997,2.577334798}, /*cmy*/
          {0.08101062666,1.291638646,-0.5592350682,0.04933868197}, /*cfy*/
          {-20.34704898,0.008412498713,1880.767293,7.998873822,-0.01729372003,6.776299669}, /*cmz*/
          {1.555700973,-0.01333822192,1.379789099,1.510761311} /*cfz*/
     },
     {
          2464449.5,
          {5.204874325,0.06437003432,1751.014556,-7.443385925,-0.01587746266,6.473587389}, /*cmx*/
          {2.292468688,3.933756114,1.500823507,4.744653347}, /*cfx*/
          {1.051511762,0.01979845544,699.8929108,-3.093951734,-0.01235517253,2.427517339}, /*cmy*/
          {2.423233025,3.418007462,1.194190257,4.874791185}, /*cfy*/
          {-19.76294433,0.0168390752,1881.358698,7.991348209,-0.01899462334,6.939243843}, /*cmz*/
          {3.881011568,2.295934062,3.016577011,0.05086772357} /*cfz*/
     },
     {
          2464489.5,
          {7.854998457,0.05161826176,1776.767646,-6.71927678,-0.02861766647,6.442877121}, /*cmx*/
          {4.629128883,-0.008983414536,3.331633675,3.296302465}, /*cfx*/
          {1.896206656,0.005733201768,632.1435145,-2.692256299,-0.01368485381,2.083002905}, /*cmy*/
          {4.781787753,5.564892828,2.857568984,3.483219425}, /*cfy*/
          {-19.28551241,0.04026804805,1881.201668,7.092257706,-0.03039842455,6.787524697}, /*cmz*/
          {-0.06646778165,4.623298298,4.837648568,4.882391891} /*cfz*/
     },
     {
          2464529.5,
          {9.882066694,0.03640232581,1798.389915,-4.665038996,-0.04393012105,6.537599496}, /*cmx*/
          {0.7148796878,2.365991909,5.527305167,1.933245192}, /*cfx*/
          {2.048672627,0.004768978897,566.3002524,-1.809647432,-0.01769747057,1.996325221}, /*cmy*/
          {0.8935961461,1.472884561,4.696251956,2.121053192}, /*cfy*/
          {-17.76902425,0.02109445391,1880.679971,4.886147378,-0.04624426583,6.807989106}, /*cmz*/
          {2.301531066,0.704938001,0.7240567541,3.516996583} /*cfz*/
     },
     {
          2464569.5,
          {11.02214951,-0.00310849814,1809.6095,-1.00405992,-0.0491027629,6.51920466}, /*cmx*/
          {3.14399324,4.863893286,1.699361746,0.6197352042}, /*cfx*/
          {2.174666994,-0.00100991761,528.1165789,-0.3334053171,-0.0191522537,1.950471713}, /*cmy*/
          {3.345309627,3.763170397,0.8030949495,0.82822589}, /*cfy*/
          {-16.92591481,-0.008178760317,1879.579618,1.01044443,-0.05126246873,6.803421548}, /*cmz*/
          {4.730134174,3.210685952,3.190648924,2.206420438} /*cfz*/
     },
     {
          2464609.5,
          {11.39894313,-0.05910891331,1806.270979,3.558344241,-0.00978429727,6.81299877}, /*cmx*/
          {5.657485489,1.037763967,4.69003684,5.678248064}, /*cfx*/
          {2.330557383,-0.007676414602,540.1867535,1.47972524,-0.003468192242,2.150115914}, /*cmy*/
          {5.859778844,6.462550783,4.367546254,5.8172784}, /*cfy*/
          {-17.0586517,-0.04365588222,1879.627563,-3.865351023,-0.008748597653,7.135950428}, /*cmz*/
          {0.960806745,5.663443628,6.348181845,0.9641073499} /*cfz*/
     },
     {
          2464649.5,
          {8.786230779,-0.02443435707,1790.799975,4.493197005,-0.04404366956,6.456322254}, /*cmx*/
          {1.953904221,3.639341573,-2.66758139,4.41219979}, /*cfx*/
          {1.88444453,-0.005647609306,589.6158457,1.736947183,-0.01842431479,2.175043081}, /*cmy*/
          {2.135755975,2.852851188,9.176754843,4.590693651}, /*cfy*/
          {-18.59158284,0.001719802894,1880.50579,-4.765285138,-0.04786344344,6.747403917}, /*cmz*/
          {3.542165995,1.993931871,5.120754941,6.000729202} /*cfz*/
     },
     {
          2464689.5,
          {7.680361361,0.0159386552,1779.658471,0.7180113005,-0.04964706485,6.477483703}, /*cmx*/
          {4.508958788,6.146329273,6.154175294,3.135031458}, /*cfx*/
          {1.684755869,0.004092415921,621.2810917,0.2186180441,-0.01963996031,2.22007003}, /*cmy*/
          {4.671105879,4.634002422,5.399010671,3.287152332}, /*cfy*/
          {-19.20234077,0.0220667826,1880.162626,-0.6940486329,-0.05221256725,6.821287561}, /*cmz*/
          {6.097143423,4.452958898,1.353737331,4.720675188} /*cfz*/
     },
     {
          2464729.5,
          {8.134532242,0.05764361462,1783.898213,-3.466450953,-0.03247012544,6.410561048}, /*cmx*/
          {0.6915149747,2.391207218,2.090177173,1.774580954}, /*cfx*/
          {1.823371051,0.01290109911,606.8612847,-1.541938574,-0.01431649763,2.052443798}, /*cmy*/
          {0.8475455391,-4.515484516,0.9920323821,1.958527491}, /*cfy*/
          {-18.61681529,0.02867934696,1879.923881,3.677862997,-0.03467583154,6.667308429}, /*cmz*/
          {2.278000155,0.7433992266,3.567363556,3.358145303} /*cfz*/
     },
     {
          2464769.5,
          {10.31602912,0.0557790426,1802.536878,-6.161288047,-0.01919742787,6.678823005}, /*cmx*/
          {3.080622992,4.760576841,3.915423275,0.3398492081}, /*cfx*/
          {2.405348692,-0.0008905983305,549.7075934,-2.580940126,-0.01286721877,1.831474022}, /*cmy*/
          {3.245769942,3.936550695,2.62157349,0.5044113645}, /*cfy*/
          {-17.686639,0.04145889153,1881.079801,6.524068475,-0.0183833879,6.870184375}, /*cmz*/
          {4.665509647,3.095000426,5.420826303,1.921463897} /*cfz*/
     },
     {
          2464809.5,
          {12.64540962,0.06097875242,1828.17992,-7.433410529,-0.01730270184,6.593748563}, /*cmx*/
          {5.427534959,0.8125883328,-0.8113347211,5.158595986}, /*cfx*/
          {2.404244666,-0.00908747913,457.1568921,-3.1157178,-0.01376347103,1.379392568}, /*cmy*/
          {5.62177339,-0.2017822644,4.33874528,5.421648128}, /*cfy*/
          {-15.64634131,0.05059399554,1880.157232,7.784029506,-0.01706451327,6.699783823}, /*cmz*/
          {0.7265143139,5.445826842,0.5892742534,0.4603808646} /*cfz*/
     },
     {
          2464849.5,
          {15.2507065,0.04842785821,1854.068249,-7.615624288,-0.01861004567,6.805250327}, /*cmx*/
          {1.477272394,3.109471479,0.7815383148,3.713983026}, /*cfx*/
          {2.000691373,-0.01469500627,340.983301,-3.184995709,-0.01239560744,1.002020058}, /*cmy*/
          {1.73084629,1.916847311,-0.1410163362,3.994924721}, /*cfy*/
          {-13.24124821,0.05494499021,1881.584323,7.804383399,-0.01744546516,6.839528959}, /*cmz*/
          {3.055766286,1.470971186,2.239706122,5.29480163} /*cfz*/
     },
     {
          2464889.5,
          {17.42427342,0.01901261867,1872.237063,-6.887382178,-0.02956677009,6.70347175}, /*cmx*/
          {3.818646131,5.415110282,2.530681928,2.262943889}, /*cfx*/
          {1.468819952,-0.0206569928,222.0001301,-2.925234906,-0.01317953628,0.5596813356}, /*cmy*/
          {4.20051116,4.056522953,1.346450855,2.896846793}, /*cfy*/
          {-11.248127,0.06245371133,1881.917597,7.033813582,-0.02954671861,6.724940025}, /*cmz*/
          {5.394188318,3.79743677,3.997686396,3.843570443} /*cfz*/
     },
     {
          2464929.5,
          {18.19371559,0.01785285725,1880.535731,-4.796129499,-0.04483285811,6.726594157}, /*cmx*/
          {-0.09345314153,1.475269314,4.640815456,0.9061065477}, /*cfx*/
          {0.5670151633,-0.01352646167,128.6168777,-2.087539918,-0.01953171178,0.4005476313}, /*cmy*/
          {0.586451446,0.006561124337,3.189836954,1.712410369}, /*cfy*/
          {-8.862480531,0.03869919489,1881.290067,4.920372046,-0.04619914126,6.74016003}, /*cmz*/
          {1.479777876,-0.113671129,-0.09507813659,2.478128309} /*cfz*/
     },
     {
          2464969.5,
          {18.70274654,0.0004671144776,1881.715345,-1.057024357,-0.05084957783,6.72707272}, /*cmx*/
          {2.335944404,3.985364668,0.8125968066,5.876204266}, /*cfx*/
          {0.07091042703,0.002789239004,90.61359458,-0.4668868688,-0.02182933092,0.3748467323}, /*cmy*/
          {3.418634984,2.459115313,5.578774661,0.5638647359}, /*cfy*/
          {-7.471439559,-0.008760472809,1880.779995,1.066184733,-0.05149401103,6.715523668}, /*cmz*/
          {3.907691793,2.373906069,2.361131221,1.16777103} /*cfz*/
     },
     {
          2465009.5,
          {19.03446153,-0.02134454385,1881.076825,3.726401043,-0.01083805232,6.995285043}, /*cmx*/
          {4.848617346,0.1271012834,4.020095154,4.650122715}, /*cfx*/
          {0.02782456553,0.02547922185,99.18983567,1.593585908,-0.004576753035,0.468478178}, /*cmy*/
          {5.782511728,4.928982445,2.562444656,4.947278466}, /*cfy*/
          {-7.221437193,-0.06999935625,1881.165717,-3.790684286,-0.009323512848,7.103177916}, /*cmz*/
          {0.1377109998,4.851911569,5.344916883,6.226940192} /*cfz*/
     },
     {
          2465049.5,
          {17.84614366,-0.02414003094,1878.204318,4.689825394,-0.04560949163,6.725319049}, /*cmx*/
          {1.144684446,2.769747576,2.73866804,3.391612352}, /*cfx*/
          {1.115405265,0.002550675836,155.8830457,1.994495687,-0.01914554786,0.594660532}, /*cmy*/
          {1.674890382,1.331437526,7.641909693,3.863819297}, /*cfy*/
          {-10.07822967,-0.01331014525,1881.279697,-4.737640707,0.04590252644,6.753614323}, /*cmz*/
          {2.718851239,1.168858703,-30.26264176,4.960661529} /*cfz*/
     },
     {
          2465089.5,
          {17.18745462,0.001028108662,1873.08424,0.7923547007,-0.04987790283,6.750172375}, /*cmx*/
          {3.699970183,5.274004241,5.290386735,2.113813425}, /*cfx*/
          {1.446237348,-0.0076331265,203.1394847,0.3906297012,-0.02157370038,0.6612977344}, /*cmy*/
          {4.083975014,3.541156944,3.883675171,2.476655777}, /*cfy*/
          {-11.19795509,0.02575785434,1881.122202,-0.80296734,0.05103110517,6.776529924}, /*cmz*/
          {5.274843931,3.661519079,-2.603173768,3.68812643} /*cfz*/
     },
     {
          2465129.5,
          {17.19641709,0.0332936164,1874.300397,-3.421461652,-0.03307409105,6.606090578}, /*cmx*/
          {6.168285167,1.543016192,1.17116058,0.757589958}, /*cfx*/
          {1.139643742,-0.01591258199,183.0592771,1.469723285,-0.01540764158,0.505392074}, /*cmy*/
          {0.2884304746,3.380456071,-0.3902799915,1.389450157}, /*cfy*/
          {-10.47838687,0.05428941422,1881.03904,3.484938549,0.03300498244,6.653936662}, /*cmz*/
          {1.459254993,6.198918155,5.920061104,2.326608289} /*cfz*/
     },
     {
          2465169.5,
          {18.51366775,0.02370573672,1881.109211,-6.089879905,-0.02013976002,6.827780284}, /*cmx*/
          {2.279289982,3.876233137,3.010684403,5.620148102}, /*cfx*/
          {0.5298961972,-0.02531677806,107.2198884,2.681876202,-0.01205697164,0.1906229191}, /*cmy*/
          {2.95198344,5.586965238,1.205129675,0.6758572641}, /*cfy*/
          {-8.423435973,0.05882014007,1881.426856,6.230713354,0.01795924352,6.828393476}, /*cmz*/
          {3.851924909,2.286608697,1.494796784,0.9010575182} /*cfz*/
     },
     {
          2465209.5,
          {19.27440931,0.01715357244,1882.234631,-7.412670426,-0.01776163651,6.658979716}, /*cmx*/
          {4.632270907,-0.08900497004,4.497288991,4.1589303}, /*cfx*/
          {-0.5296469625,-0.0360304153,-72.91471987,3.243216427,-0.01295067933,-0.5340204465}, /*cmy*/
          {9.920328548,1.493319494,2.864124155,9.950164994}, /*cfy*/
          {-5.719840788,0.07324639692,1881.098579,7.473843318,0.01595939684,6.668364349}, /*cmz*/
          {-0.08102590976,4.639644358,2.990258951,5.723717637} /*cfz*/
     },
     {
          2465249.5,
          {19.88710441,0.003262529738,1874.811146,-7.485540018,-0.01878927565,6.757214536}, /*cmx*/
          {0.6859163485,2.203145343,-0.1125742065,2.721494282}, /*cfx*/
          {-1.981904389,-0.03359361252,-183.9769356,3.261298691,-0.01178784029,-0.912284382}, /*cmy*/
          {6.672478281,3.640819954,4.579244157,2.550755377}, /*cfy*/
          {-2.518585486,0.0737353931,1882.624239,7.590805289,0.01656781622,6.781614224}, /*cmz*/
          {2.254170951,0.6696753517,4.556871495,4.285661142} /*cfz*/
     },
     {
          2465289.5,
          {20.3895601,-0.02262888212,1859.66028,-6.724587948,-0.02914221331,6.586094409}, /*cmx*/
          {3.030084999,4.504164003,1.583456462,1.269552845}, /*cfx*/
          {-3.379177473,-0.01717859564,-303.8293456,2.880100264,-0.01388962495,-1.342548484}, /*cmy*/
          {2.877843234,5.81634504,-0.1236794779,1.126273178}, /*cfy*/
          {0.3248924424,0.06002876203,1883.086767,6.877180039,0.03008691856,6.675384801}, /*cmz*/
          {4.597187694,3.001670694,0.04434531327,2.835145588} /*cfz*/
     },
     {
          2465329.5,
          {19.52450878,-0.008647192524,1841.695878,-4.632533729,-0.04539576541,6.528862123}, /*cmx*/
          {5.403354946,0.5767179882,3.733079489,6.194649196}, /*cfx*/
          {-4.119377506,-0.0109491586,-395.6195623,1.923736706,-0.01904861821,-1.479111631}, /*cmy*/
          {5.30516936,1.79193257,1.780920384,6.09951757}, /*cfy*/
          {2.628696707,0.03955498278,1882.508089,4.721278943,0.04646998968,6.680724233}, /*cmz*/
          {0.6866422655,5.379572797,2.254377574,1.47916609} /*cfz*/
     },
     {
          2465369.5,
          {19.13661078,0.004676259638,1830.567628,-0.8134770705,-0.04894555667,6.504817078}, /*cmx*/
          {1.55219065,3.110217582,6.213218305,4.890365964}, /*cfx*/
          {-4.546170324,0.003644533098,-439.3685551,0.358002957,-0.02131563588,-1.514422488}, /*cmy*/
          {1.476892089,4.557716656,4.236594019,4.800169507}, /*cfy*/
          {3.97212236,-0.008865622475,1882.036905,0.8388516738,0.0505224934,6.651464363}, /*cmz*/
          {3.119096756,1.61166678,4.719927275,0.1711710206} /*cfz*/
     },
     {
          2465409.5,
          {19.18616579,0.02686186698,1834.718918,3.868148355,-0.006960241969,6.895776799}, /*cmx*/
          {4.068780714,5.545849228,3.293938912,3.665404808}, /*cfx*/
          {-4.631695139,0.0189658045,-423.2962092,-1.664652044,-0.005908251729,-1.344902349}, /*cmy*/
          {3.996811488,0.3523238268,1.536668041,3.656433085}, /*cfy*/
          {4.319546674,-0.06782534608,1881.970703,-3.88346174,0.008073377744,6.970277557}, /*cmz*/
          {5.63644119,4.05476525,1.638211876,5.248469347} /*cfz*/
     },
     {
          2465449.5,
          {20.14904365,-0.01208850573,1849.021101,4.527922338,0.04503267979,6.641448604}, /*cmx*/
          {0.3665951819,1.882611226,11.28939538,2.403493298}, /*cfx*/
          {-3.620259522,0.008880362958,-359.1364705,-1.999808524,-0.01941902244,-1.235640757}, /*cmy*/
          {0.2804031395,3.120432341,6.218631961,2.335532036}, /*cfy*/
          {1.386960761,-0.02535640963,1882.388139,-4.595861543,-0.04537723324,6.775188346}, /*cmz*/
          {1.934320996,0.3787629698,9.782599621,3.975937691} /*cfz*/
     },
     {
          2465489.5,
          {20.27149579,-0.01437998084,1856.905115,0.6885017064,0.04779327559,6.680959194}, /*cmx*/
          {2.919577549,4.355906546,1.24790667,1.125874782}, /*cfx*/
          {-3.249813308,-0.004572010866,-311.8019008,-0.3394750265,-0.02082630443,-1.17320696}, /*cmy*/
          {2.816303507,5.630446573,2.530019528,1.054350057}, /*cfy*/
          {0.1242675198,0.02066984386,1882.276023,-0.6966406765,-0.04855090016,6.769584455}, /*cmz*/
          {4.487657809,2.873835342,6.035871015,2.695357027} /*cfz*/
     },
     {
          2465529.5,
          {19.7779423,-0.005080502036,1853.16621,-3.325977575,0.03134785416,6.495173142}, /*cmx*/
          {5.387114186,0.6363773787,3.454161206,6.048641877}, /*cfx*/
          {-3.470926554,-0.02085781849,-330.3064845,1.446872948,-0.0136340006,-1.311958476}, /*cmy*/
          {5.293627965,1.947123148,4.484347293,5.929521239}, /*cfy*/
          {0.6934838784,0.06053720267,1881.985559,3.411422189,-0.03118913883,6.650748352}, /*cmz*/
          {0.6720954404,5.416052786,1.978064067,1.337396788} /*cfz*/
     },
     {
          2465569.5,
          {19.51127679,-0.01172522166,1839.663432,-5.882718731,0.01715682895,6.589629361}, /*cmx*/
          {1.499939947,2.984428995,5.345247136,4.632117497}, /*cfx*/
          {-4.346587158,-0.01834913007,-402.8435153,2.505564442,-0.0108374786,-1.63717205}, /*cmy*/
          {1.43615549,4.188650557,-0.1987731188,4.612477438}, /*cfy*/
          {3.07321601,0.0601431976,1882.40929,5.976844607,-0.01803159991,6.830369566}, /*cmz*/
          {3.067692863,1.503995954,3.892484814,-0.08008039441} /*cfz*/
     },
     {
          2465609.5,
          {18.68137765,-0.02968983217,1815.570553,-7.095799878,0.01464757592,6.370260362}, /*cmx*/
          {3.854918046,5.333042352,0.4500438263,3.173177212}, /*cfx*/
          {-5.033202946,-0.01715488192,-497.1699721,2.992921987,-0.01137764152,-1.98165774}, /*cmy*/
          {3.819282694,0.09885444431,1.410200245,3.140091167}, /*cfy*/
          {5.623858904,0.07034031952,1882.426175,7.237826459,-0.01442056225,6.705207619}, /*cmz*/
          {5.422924702,3.855335372,-0.9117501648,4.74040315} /*cfz*/
     },
     {
          2465649.5,
          {17.37795421,-0.04001463685,1788.756519,-7.089032356,0.01595443437,6.389757747}, /*cmx*/
          {-0.09001506253,1.369693548,2.069018182,1.741307873}, /*cfx*/
          {-5.664462079,-0.008948814174,-589.1536973,2.955685606,-0.01088336242,-2.277159445}, /*cmy*/
          {-0.1022622465,2.264211562,3.185799853,1.751483567}, /*cfy*/
          {8.585244264,0.06570295317,1882.93076,7.399385449,-0.01693970694,6.803436733}, /*cmz*/
          {1.479859384,-0.1012673928,0.5948057993,3.309954521} /*cfz*/
     },
     {
          2465689.5,
          {16.15258658,-0.04505021851,1763.740422,-6.31983542,0.02907085518,6.253227385}, /*cmx*/
          {2.255830328,3.705666163,3.843190494,0.2919187667}, /*cfx*/
          {-6.186813345,0.006071163012,-662.2697486,2.584098104,-0.01282179816,-2.496617211}, /*cmy*/
          {2.263057046,4.437065414,4.702990881,0.3025905409}, /*cfy*/
          {11.36515964,0.03743712679,1883.420453,6.626688062,-0.03087813659,6.739955555}, /*cmz*/
          {3.827518378,2.234364695,2.404281608,1.857007469} /*cfz*/
     },
     {
          2465729.5,
          {14.356126,-0.02066415155,1744.601744,-4.190181697,0.04498228766,6.196592725}, /*cmx*/
          {4.632282728,6.099530057,-0.1748049429,5.219229714}, /*cfx*/
          {-5.967692431,0.002820977091,-708.9942365,1.667456108,-0.01924683321,-2.565778454}, /*cmy*/
          {4.65547448,0.4396372288,0.4042565311,5.24813807}, /*cfy*/
          {12.8130396,0.02704937338,1882.963946,4.367797473,-0.04728808823,6.698196336}, /*cmz*/
          {-0.0770178512,4.612187869,4.620300613,0.5078099561} /*cfz*/
     },
     {
          2465769.5,
          {13.56832047,0.01022028316,1736.386705,-0.3772032542,0.04455899836,6.134174119}, /*cmx*/
          {0.7873589564,2.38636555,2.316909587,3.920677917}, /*cfx*/
          {-5.910027898,-0.000770541192,-727.6302655,0.1370394806,-0.01865202282,-2.538683534}, /*cmy*/
          {0.8223114786,10.59988892,2.955897913,3.956178451}, /*cfy*/
          {13.66571918,-0.00956133721,1881.798122,0.3734964669,-0.04783383847,6.662257565}, /*cmz*/
          {2.363493512,1.036263544,0.8463183242,5.491811631} /*cfz*/
     },
     {
          2465809.5,
          {13.48823524,0.05423312871,1740.847526,3.85698089,-0.003381707296,6.531180206}, /*cmx*/
          {3.311777594,4.808603942,9.300528109,2.719876651}, /*cfx*/
          {-5.896368168,-0.01102895763,-718.2438501,1.783934739,-0.004757276501,-2.556749884}, /*cmy*/
          {3.352257771,8.509507103,139.2677276,2.774646443}, /*cfy*/
          {13.82899344,-0.04417093911,1881.775674,4.163933006,-0.005860338439,6.934378893}, /*cmz*/
          {4.888219648,6.443402876,-7.599835286,4.288960865} /*cfz*/
     },
     {
          2465849.5,
          {15.73984792,0.003486286926,1754.052961,4.105772135,-0.04297314979,6.378570788}, /*cmx*/
          {5.89405888,1.109057569,13.66525445,1.441777139}, /*cfx*/
          {-6.200297432,0.004250144761,-685.3727292,1.76191187,-0.01918555841,-2.458949562}, /*cmy*/
          {5.932122014,4.981115935,4.923494644,1.484508652}, /*cfy*/
          {11.79886695,-0.0263450496,1882.727306,4.337180188,0.04585039298,6.804081473}, /*cmz*/
          {1.186479531,2.774801284,5.901392807,3.020101914} /*cfz*/
     },
     {
          2465889.5,
          {16.43093148,-0.0212907087,1762.914334,0.4322394361,-0.04383155806,6.382917883}, /*cmx*/
          {2.159224851,3.562169143,3.610861681,0.1560796193}, /*cfx*/
          {-6.251187692,0.005840400126,-661.1765801,0.1390016682,-0.01851377712,-2.438876735}, /*cmy*/
          {2.190489766,1.471795124,1.184193213,0.1942078061}, /*cfy*/
          {10.80823713,0.01235158068,1882.312966,0.4289826717,0.04590874159,6.823647569}, /*cmz*/
          {3.733853241,5.201974909,2.130528351,1.729277116} /*cfz*/
     },
     {
          2465929.5,
          {15.71126765,-0.03315933331,1758.156318,-3.267065258,-0.02781503855,6.228828552}, /*cmx*/
          {4.623350783,6.127485681,5.85936358,5.0749543}, /*cfx*/
          {-6.067250761,-3.03556746e-05,-672.8582838,1.432024387,-0.0125148483,-2.479373924}, /*cmy*/
          {4.652372027,6.836677875,3.169489286,5.086903465}, /*cfy*/
          {11.09752867,0.0508727466,1881.918192,-3.454168703,0.03007690576,6.673684853}, /*cmz*/
          {6.197919556,1.521698416,4.339941989,0.3659107474} /*cfz*/
     },
     {
          2465969.5,
          {14.25919177,-0.03553611138,1743.67068,-5.569292002,-0.01488779992,6.305207958}, /*cmx*/
          {0.7349480129,2.225734201,1.537503139,3.656117783}, /*cfx*/
          {-6.056545092,0.004724245371,-710.7296394,2.421269009,-0.009490155905,-2.666665483}, /*cmy*/
          {0.7692584615,2.830858468,4.80299077,3.702046866}, /*cfy*/
          {13.05399708,0.04946843752,1882.76596,-5.880706443,0.01766152169,6.829927479}, /*cmz*/
          {2.310426199,3.883419961,0.02989325016,5.239752487} /*cfz*/
     },
     {
          2466009.5,
          {12.53937293,-0.05632479312,1725.446301,-6.675517125,-0.01156661348,6.151409917}, /*cmx*/
          {3.089953789,4.60081368,2.877049045,2.193240776}, /*cfx*/
          {-5.747243206,0.01603608243,-752.7711315,2.899469103,-0.010246158,-2.772510628}, /*cmy*/
          {3.133979808,5.063644618,0.1113106406,2.239239021}, /*cfy*/
          {14.92568887,0.04668726929,1882.523548,-7.164515609,0.01348708784,6.746932061}, /*cmz*/
          {4.667876941,-0.04607661299,1.398908531,3.776650083} /*cfz*/
     },
     {
          2466049.5,
          {10.22823486,-0.06232221546,1712.159765,-6.707785899,-0.01466160709,6.174099843}, /*cmx*/
          {5.429596233,0.6647139752,4.373071497,0.7663416871}, /*cfx*/
          {-5.07904244,0.02243663036,-785.4586282,2.87708301,-0.009680089773,-2.88200141}, /*cmy*/
          {5.486476635,0.9680340188,1.796727494,0.8339553014}, /*cfy*/
          {16.86471155,0.03713717566,1882.239006,-7.246928668,0.01772269158,6.82342031}, /*cmz*/
          {0.727033843,2.290525989,2.948243649,2.352451413} /*cfz*/
     },
     {
          2466089.5,
          {7.986088786,-0.04873041186,1705.35138,-5.929985827,-0.02997705995,6.142820157}, /*cmx*/
          {1.495146327,3.025526303,-0.01815354399,5.600603393}, /*cfx*/
          {-4.295773821,0.018470621,-801.7754661,2.493772059,-0.01410536412,-2.886029736}, /*cmy*/
          {1.566501517,3.18050455,3.373528007,5.677145305}, /*cfy*/
          {18.74258167,0.008667982489,1882.963291,-6.363643354,0.03205919529,6.830421788}, /*cmz*/
          {3.078552852,4.622555109,4.756192467,0.9032429447} /*cfz*/
     },
     {
          2466129.5,
          {6.015625586,-0.02225281171,1703.455731,-3.69222417,-0.04465484661,6.096763734}, /*cmx*/
          {3.877666118,5.437881379,2.300479339,4.25193447}, /*cfx*/
          {-3.553686682,0.008110906657,-804.578643,1.450793078,-0.01959032772,-2.882970441}, /*cmy*/
          {3.963403698,5.490474875,5.491888205,4.347022306}, /*cfy*/
          {19.04125723,0.01141208769,1882.087713,-3.957483541,0.04877736052,6.759395818}, /*cmz*/
          {5.464029023,0.7246557913,0.7267745728,5.839604827} /*cfz*/
     }

};

static unsigned idn_list[] = {2,246,490,673};
static double freq_list[] = {3.5516,1.7693,0.8782,0.3765};
static double delt_list[] = {30.0,30.0,40.0,40.0};

BDL_Dataset jupiter_2040 = {
     4, /*nsat*/
     2458849.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
