# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AlertRuleResource(Resource):
    """The alert rule resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param alert_rule_resource_name: Required. the name of the alert rule.
    :type alert_rule_resource_name: str
    :param description: the description of the alert rule that will be
     included in the alert email.
    :type description: str
    :param is_enabled: Required. the flag that indicates whether the alert
     rule is enabled.
    :type is_enabled: bool
    :param condition: Required. the condition that results in the alert rule
     being activated.
    :type condition: ~azure.mgmt.monitor.v2016_03_01.models.RuleCondition
    :param actions: the array of actions that are performed when the alert
     rule becomes active, and when an alert condition is resolved.
    :type actions: list[~azure.mgmt.monitor.v2016_03_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'alert_rule_resource_name': {'required': True},
        'is_enabled': {'required': True},
        'condition': {'required': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'alert_rule_resource_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'condition': {'key': 'properties.condition', 'type': 'RuleCondition'},
        'actions': {'key': 'properties.actions', 'type': '[RuleAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, location: str, alert_rule_resource_name: str, is_enabled: bool, condition, tags=None, description: str=None, actions=None, **kwargs) -> None:
        super(AlertRuleResource, self).__init__(location=location, tags=tags, **kwargs)
        self.alert_rule_resource_name = alert_rule_resource_name
        self.description = description
        self.is_enabled = is_enabled
        self.condition = condition
        self.actions = actions
        self.last_updated_time = None


class AlertRuleResourcePatch(Model):
    """The alert rule object for patch operations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param name: Required. the name of the alert rule.
    :type name: str
    :param description: the description of the alert rule that will be
     included in the alert email.
    :type description: str
    :param is_enabled: Required. the flag that indicates whether the alert
     rule is enabled.
    :type is_enabled: bool
    :param condition: Required. the condition that results in the alert rule
     being activated.
    :type condition: ~azure.mgmt.monitor.v2016_03_01.models.RuleCondition
    :param actions: the array of actions that are performed when the alert
     rule becomes active, and when an alert condition is resolved.
    :type actions: list[~azure.mgmt.monitor.v2016_03_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: datetime
    """

    _validation = {
        'name': {'required': True},
        'is_enabled': {'required': True},
        'condition': {'required': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'condition': {'key': 'properties.condition', 'type': 'RuleCondition'},
        'actions': {'key': 'properties.actions', 'type': '[RuleAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, name: str, is_enabled: bool, condition, tags=None, description: str=None, actions=None, **kwargs) -> None:
        super(AlertRuleResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.name = name
        self.description = description
        self.is_enabled = is_enabled
        self.condition = condition
        self.actions = actions
        self.last_updated_time = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorResponse(Model):
    """Describes the format of Error response.

    :param code: Error code
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class Incident(Model):
    """An alert incident indicates the activation status of an alert rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Incident name.
    :vartype name: str
    :ivar rule_name: Rule name that is associated with the incident.
    :vartype rule_name: str
    :ivar is_active: A boolean to indicate whether the incident is active or
     resolved.
    :vartype is_active: bool
    :ivar activated_time: The time at which the incident was activated in
     ISO8601 format.
    :vartype activated_time: datetime
    :ivar resolved_time: The time at which the incident was resolved in
     ISO8601 format. If null, it means the incident is still active.
    :vartype resolved_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'rule_name': {'readonly': True},
        'is_active': {'readonly': True},
        'activated_time': {'readonly': True},
        'resolved_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'rule_name': {'key': 'ruleName', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'activated_time': {'key': 'activatedTime', 'type': 'iso-8601'},
        'resolved_time': {'key': 'resolvedTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(Incident, self).__init__(**kwargs)
        self.name = None
        self.rule_name = None
        self.is_active = None
        self.activated_time = None
        self.resolved_time = None


class LocalizableString(Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str, localized_value: str=None, **kwargs) -> None:
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class RuleCondition(Model):
    """The condition that results in the alert rule being activated.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ThresholdRuleCondition, LocationThresholdRuleCondition,
    ManagementEventRuleCondition

    All required parameters must be populated in order to send to Azure.

    :param data_source: the resource from which the rule collects its data.
     For this type dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~azure.mgmt.monitor.v2016_03_01.models.RuleDataSource
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition': 'ThresholdRuleCondition', 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition': 'LocationThresholdRuleCondition', 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition': 'ManagementEventRuleCondition'}
    }

    def __init__(self, *, data_source=None, **kwargs) -> None:
        super(RuleCondition, self).__init__(**kwargs)
        self.data_source = data_source
        self.odatatype = None


class LocationThresholdRuleCondition(RuleCondition):
    """A rule condition based on a certain number of locations failing.

    All required parameters must be populated in order to send to Azure.

    :param data_source: the resource from which the rule collects its data.
     For this type dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~azure.mgmt.monitor.v2016_03_01.models.RuleDataSource
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param window_size: the period of time (in ISO 8601 duration format) that
     is used to monitor alert activity based on the threshold. If specified
     then it must be between 5 minutes and 1 day.
    :type window_size: timedelta
    :param failed_location_count: Required. the number of locations that must
     fail to activate the alert.
    :type failed_location_count: int
    """

    _validation = {
        'odatatype': {'required': True},
        'failed_location_count': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
        'failed_location_count': {'key': 'failedLocationCount', 'type': 'int'},
    }

    def __init__(self, *, failed_location_count: int, data_source=None, window_size=None, **kwargs) -> None:
        super(LocationThresholdRuleCondition, self).__init__(data_source=data_source, **kwargs)
        self.window_size = window_size
        self.failed_location_count = failed_location_count
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'


class LogProfileResource(Resource):
    """The log profile resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param storage_account_id: the resource id of the storage account to which
     you would like to send the Activity Log.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule ID of the service bus
     namespace in which you would like to have Event Hubs created for streaming
     the Activity Log. The rule ID is of the format: '{service bus resource
     ID}/authorizationrules/{key name}'.
    :type service_bus_rule_id: str
    :param locations: Required. List of regions for which Activity Log events
     should be stored or streamed. It is a comma separated list of valid ARM
     locations including the 'global' location.
    :type locations: list[str]
    :param categories: Required. the categories of the logs. These categories
     are created as is convenient to the user. Some values are: 'Write',
     'Delete', and/or 'Action.'
    :type categories: list[str]
    :param retention_policy: Required. the retention policy for the events in
     the log.
    :type retention_policy:
     ~azure.mgmt.monitor.v2016_03_01.models.RetentionPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'locations': {'required': True},
        'categories': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'locations': {'key': 'properties.locations', 'type': '[str]'},
        'categories': {'key': 'properties.categories', 'type': '[str]'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, *, location: str, locations, categories, retention_policy, tags=None, storage_account_id: str=None, service_bus_rule_id: str=None, **kwargs) -> None:
        super(LogProfileResource, self).__init__(location=location, tags=tags, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.locations = locations
        self.categories = categories
        self.retention_policy = retention_policy


class LogProfileResourcePatch(Model):
    """The log profile resource for patch operations.

    All required parameters must be populated in order to send to Azure.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param storage_account_id: the resource id of the storage account to which
     you would like to send the Activity Log.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule ID of the service bus
     namespace in which you would like to have Event Hubs created for streaming
     the Activity Log. The rule ID is of the format: '{service bus resource
     ID}/authorizationrules/{key name}'.
    :type service_bus_rule_id: str
    :param locations: Required. List of regions for which Activity Log events
     should be stored or streamed. It is a comma separated list of valid ARM
     locations including the 'global' location.
    :type locations: list[str]
    :param categories: Required. the categories of the logs. These categories
     are created as is convenient to the user. Some values are: 'Write',
     'Delete', and/or 'Action.'
    :type categories: list[str]
    :param retention_policy: Required. the retention policy for the events in
     the log.
    :type retention_policy:
     ~azure.mgmt.monitor.v2016_03_01.models.RetentionPolicy
    """

    _validation = {
        'locations': {'required': True},
        'categories': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'locations': {'key': 'properties.locations', 'type': '[str]'},
        'categories': {'key': 'properties.categories', 'type': '[str]'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, *, locations, categories, retention_policy, tags=None, storage_account_id: str=None, service_bus_rule_id: str=None, **kwargs) -> None:
        super(LogProfileResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.locations = locations
        self.categories = categories
        self.retention_policy = retention_policy


class ManagementEventAggregationCondition(Model):
    """How the data that is collected should be combined over time.

    :param operator: the condition operator. Possible values include:
     'GreaterThan', 'GreaterThanOrEqual', 'LessThan', 'LessThanOrEqual'
    :type operator: str or
     ~azure.mgmt.monitor.v2016_03_01.models.ConditionOperator
    :param threshold: The threshold value that activates the alert.
    :type threshold: float
    :param window_size: the period of time (in ISO 8601 duration format) that
     is used to monitor alert activity based on the threshold. If specified
     then it must be between 5 minutes and 1 day.
    :type window_size: timedelta
    """

    _attribute_map = {
        'operator': {'key': 'operator', 'type': 'ConditionOperator'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
    }

    def __init__(self, *, operator=None, threshold: float=None, window_size=None, **kwargs) -> None:
        super(ManagementEventAggregationCondition, self).__init__(**kwargs)
        self.operator = operator
        self.threshold = threshold
        self.window_size = window_size


class ManagementEventRuleCondition(RuleCondition):
    """A management event rule condition.

    All required parameters must be populated in order to send to Azure.

    :param data_source: the resource from which the rule collects its data.
     For this type dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~azure.mgmt.monitor.v2016_03_01.models.RuleDataSource
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param aggregation: How the data that is collected should be combined over
     time and when the alert is activated. Note that for management event
     alerts aggregation is optional – if it is not provided then any event will
     cause the alert to activate.
    :type aggregation:
     ~azure.mgmt.monitor.v2016_03_01.models.ManagementEventAggregationCondition
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'aggregation': {'key': 'aggregation', 'type': 'ManagementEventAggregationCondition'},
    }

    def __init__(self, *, data_source=None, aggregation=None, **kwargs) -> None:
        super(ManagementEventRuleCondition, self).__init__(data_source=data_source, **kwargs)
        self.aggregation = aggregation
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'


class MetricAvailability(Model):
    """Metric availability specifies the time grain (aggregation interval or
    frequency) and the retention period for that time grain.

    :param time_grain: the time grain specifies the aggregation interval for
     the metric. Expressed as a duration 'PT1M', 'P1D', etc.
    :type time_grain: timedelta
    :param retention: the retention period for the metric at the specified
     timegrain.  Expressed as a duration 'PT1M', 'P1D', etc.
    :type retention: timedelta
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'retention': {'key': 'retention', 'type': 'duration'},
    }

    def __init__(self, *, time_grain=None, retention=None, **kwargs) -> None:
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricDefinition(Model):
    """Metric definition class specifies the metadata for a metric.

    :param resource_id: the resource identifier of the resource that emitted
     the metric.
    :type resource_id: str
    :param name: the name and the display name of the metric, i.e. it is a
     localizable string.
    :type name: ~azure.mgmt.monitor.v2016_03_01.models.LocalizableString
    :param unit: the unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'CountPerSecond', 'BytesPerSecond', 'Percent',
     'MilliSeconds'
    :type unit: str or ~azure.mgmt.monitor.v2016_03_01.models.Unit
    :param primary_aggregation_type: the primary aggregation type value
     defining how to use the values for display. Possible values include:
     'None', 'Average', 'Count', 'Minimum', 'Maximum', 'Total'
    :type primary_aggregation_type: str or
     ~azure.mgmt.monitor.v2016_03_01.models.AggregationType
    :param metric_availabilities: the collection of what aggregation intervals
     are available to be queried.
    :type metric_availabilities:
     list[~azure.mgmt.monitor.v2016_03_01.models.MetricAvailability]
    :param id: the resource identifier of the metric definition.
    :type id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'unit': {'key': 'unit', 'type': 'Unit'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'AggregationType'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, resource_id: str=None, name=None, unit=None, primary_aggregation_type=None, metric_availabilities=None, id: str=None, **kwargs) -> None:
        super(MetricDefinition, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.name = name
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.metric_availabilities = metric_availabilities
        self.id = id


class RetentionPolicy(Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. a value indicating whether the retention policy
     is enabled.
    :type enabled: bool
    :param days: Required. the number of days for the retention in days. A
     value of 0 will retain the events indefinitely.
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(self, *, enabled: bool, days: int, **kwargs) -> None:
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class RuleAction(Model):
    """The action that is performed when the alert rule becomes active, and when
    an alert condition is resolved.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RuleEmailAction, RuleWebhookAction

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'Microsoft.Azure.Management.Insights.Models.RuleEmailAction': 'RuleEmailAction', 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction': 'RuleWebhookAction'}
    }

    def __init__(self, **kwargs) -> None:
        super(RuleAction, self).__init__(**kwargs)
        self.odatatype = None


class RuleDataSource(Model):
    """The resource from which the rule collects its data.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RuleMetricDataSource, RuleManagementEventDataSource

    All required parameters must be populated in order to send to Azure.

    :param resource_uri: the resource identifier of the resource the rule
     monitors. **NOTE**: this property cannot be updated for an existing rule.
    :type resource_uri: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource': 'RuleMetricDataSource', 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource': 'RuleManagementEventDataSource'}
    }

    def __init__(self, *, resource_uri: str=None, **kwargs) -> None:
        super(RuleDataSource, self).__init__(**kwargs)
        self.resource_uri = resource_uri
        self.odatatype = None


class RuleEmailAction(RuleAction):
    """Specifies the action to send email when the rule condition is evaluated.
    The discriminator is always RuleEmailAction in this case.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param send_to_service_owners: Whether the administrators (service and
     co-administrators) of the service should be notified when the alert is
     activated.
    :type send_to_service_owners: bool
    :param custom_emails: the list of administrator's custom email addresses
     to notify of the activation of the alert.
    :type custom_emails: list[str]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'send_to_service_owners': {'key': 'sendToServiceOwners', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(self, *, send_to_service_owners: bool=None, custom_emails=None, **kwargs) -> None:
        super(RuleEmailAction, self).__init__(**kwargs)
        self.send_to_service_owners = send_to_service_owners
        self.custom_emails = custom_emails
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'


class RuleManagementEventClaimsDataSource(Model):
    """The claims for a rule management event data source.

    :param email_address: the email address.
    :type email_address: str
    """

    _attribute_map = {
        'email_address': {'key': 'emailAddress', 'type': 'str'},
    }

    def __init__(self, *, email_address: str=None, **kwargs) -> None:
        super(RuleManagementEventClaimsDataSource, self).__init__(**kwargs)
        self.email_address = email_address


class RuleManagementEventDataSource(RuleDataSource):
    """A rule management event data source. The discriminator fields is always
    RuleManagementEventDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :param resource_uri: the resource identifier of the resource the rule
     monitors. **NOTE**: this property cannot be updated for an existing rule.
    :type resource_uri: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param event_name: the event name.
    :type event_name: str
    :param event_source: the event source.
    :type event_source: str
    :param level: the level.
    :type level: str
    :param operation_name: The name of the operation that should be checked
     for. If no name is provided, any operation will match.
    :type operation_name: str
    :param resource_group_name: the resource group name.
    :type resource_group_name: str
    :param resource_provider_name: the resource provider name.
    :type resource_provider_name: str
    :param status: The status of the operation that should be checked for. If
     no status is provided, any status will match.
    :type status: str
    :param sub_status: the substatus.
    :type sub_status: str
    :param claims: the claims.
    :type claims:
     ~azure.mgmt.monitor.v2016_03_01.models.RuleManagementEventClaimsDataSource
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'str'},
        'event_source': {'key': 'eventSource', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'sub_status': {'key': 'subStatus', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'RuleManagementEventClaimsDataSource'},
    }

    def __init__(self, *, resource_uri: str=None, event_name: str=None, event_source: str=None, level: str=None, operation_name: str=None, resource_group_name: str=None, resource_provider_name: str=None, status: str=None, sub_status: str=None, claims=None, **kwargs) -> None:
        super(RuleManagementEventDataSource, self).__init__(resource_uri=resource_uri, **kwargs)
        self.event_name = event_name
        self.event_source = event_source
        self.level = level
        self.operation_name = operation_name
        self.resource_group_name = resource_group_name
        self.resource_provider_name = resource_provider_name
        self.status = status
        self.sub_status = sub_status
        self.claims = claims
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'


class RuleMetricDataSource(RuleDataSource):
    """A rule metric data source. The discriminator value is always
    RuleMetricDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :param resource_uri: the resource identifier of the resource the rule
     monitors. **NOTE**: this property cannot be updated for an existing rule.
    :type resource_uri: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param metric_name: the name of the metric that defines what the rule
     monitors.
    :type metric_name: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
    }

    def __init__(self, *, resource_uri: str=None, metric_name: str=None, **kwargs) -> None:
        super(RuleMetricDataSource, self).__init__(resource_uri=resource_uri, **kwargs)
        self.metric_name = metric_name
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'


class RuleWebhookAction(RuleAction):
    """Specifies the action to post to service when the rule condition is
    evaluated. The discriminator is always RuleWebhookAction in this case.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param service_uri: the service uri to Post the notification when the
     alert activates or resolves.
    :type service_uri: str
    :param properties: the dictionary of custom properties to include with the
     post operation. These data are appended to the webhook payload.
    :type properties: dict[str, str]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(self, *, service_uri: str=None, properties=None, **kwargs) -> None:
        super(RuleWebhookAction, self).__init__(**kwargs)
        self.service_uri = service_uri
        self.properties = properties
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'


class ThresholdRuleCondition(RuleCondition):
    """A rule condition based on a metric crossing a threshold.

    All required parameters must be populated in order to send to Azure.

    :param data_source: the resource from which the rule collects its data.
     For this type dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~azure.mgmt.monitor.v2016_03_01.models.RuleDataSource
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param operator: Required. the operator used to compare the data and the
     threshold. Possible values include: 'GreaterThan', 'GreaterThanOrEqual',
     'LessThan', 'LessThanOrEqual'
    :type operator: str or
     ~azure.mgmt.monitor.v2016_03_01.models.ConditionOperator
    :param threshold: Required. the threshold value that activates the alert.
    :type threshold: float
    :param window_size: the period of time (in ISO 8601 duration format) that
     is used to monitor alert activity based on the threshold. If specified
     then it must be between 5 minutes and 1 day.
    :type window_size: timedelta
    :param time_aggregation: the time aggregation operator. How the data that
     are collected should be combined over time. The default value is the
     PrimaryAggregationType of the Metric. Possible values include: 'Average',
     'Minimum', 'Maximum', 'Total', 'Last'
    :type time_aggregation: str or
     ~azure.mgmt.monitor.v2016_03_01.models.TimeAggregationOperator
    """

    _validation = {
        'odatatype': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'ConditionOperator'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'TimeAggregationOperator'},
    }

    def __init__(self, *, operator, threshold: float, data_source=None, window_size=None, time_aggregation=None, **kwargs) -> None:
        super(ThresholdRuleCondition, self).__init__(data_source=data_source, **kwargs)
        self.operator = operator
        self.threshold = threshold
        self.window_size = window_size
        self.time_aggregation = time_aggregation
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'
