# Copyright (C) 2007-2012  CEA/DEN, EDF R&D, OPEN CASCADE
#
# Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
# CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#

# ------

MESSAGE(STATUS "Check for omniorb ...")

# ------

IF(OMNIORB_IS_MANDATORY STREQUAL 0)
  SET(OMNIORB_IS_MANDATORY 0)
  SET(OMNIORB_IS_OPTIONAL 1)
ENDIF(OMNIORB_IS_MANDATORY STREQUAL 0)
IF(OMNIORB_IS_OPTIONAL STREQUAL 0)
  SET(OMNIORB_IS_MANDATORY 1)
  SET(OMNIORB_IS_OPTIONAL 0)
ENDIF(OMNIORB_IS_OPTIONAL STREQUAL 0)
IF(NOT OMNIORB_IS_MANDATORY AND NOT OMNIORB_IS_OPTIONAL)
  SET(OMNIORB_IS_MANDATORY 1)
  SET(OMNIORB_IS_OPTIONAL 0)
ENDIF(NOT OMNIORB_IS_MANDATORY AND NOT OMNIORB_IS_OPTIONAL)

# ------

SET(OMNIORB_STATUS 1)
IF(WITHOUT_OMNIORB OR WITH_OMNIORB STREQUAL 0)
  SET(OMNIORB_STATUS 0)
  MESSAGE(STATUS "omniorb disabled from command line.")
ENDIF(WITHOUT_OMNIORB OR WITH_OMNIORB STREQUAL 0)

# ------

IF(OMNIORB_STATUS)
  IF(WITH_OMNIORB)
    SET(OMNIORB_ROOT_USER ${WITH_OMNIORB})
  ENDIF(WITH_OMNIORB)
  IF(NOT OMNIORB_ROOT_USER)
    SET(OMNIORB_ROOT_USER $ENV{OMNIORB_ROOT})
  ENDIF(NOT OMNIORB_ROOT_USER)
  IF(NOT OMNIORB_ROOT_USER)
    SET(OMNIORB_ROOT_USER $ENV{OMNIORBHOME})
  ENDIF(NOT OMNIORB_ROOT_USER)
ENDIF(OMNIORB_STATUS)

# ------

IF(OMNIORB_STATUS)
  SET(OMNIIDL_EXECUTABLE_TO_FIND omniidl)
  IF(OMNIORB_ROOT_USER)
    FIND_PROGRAM(OMNIIDL_EXECUTABLE ${OMNIIDL_EXECUTABLE_TO_FIND} PATHS ${OMNIORB_ROOT_USER}/bin)
  ELSE(OMNIORB_ROOT_USER)
    FIND_PROGRAM(OMNIIDL_EXECUTABLE ${OMNIIDL_EXECUTABLE_TO_FIND})
  ENDIF(OMNIORB_ROOT_USER)
  IF(OMNIIDL_EXECUTABLE)
    MESSAGE(STATUS "${OMNIIDL_EXECUTABLE_TO_FIND} found: ${OMNIIDL_EXECUTABLE}")
    IF(OMNIORB_EXECUTABLE STREQUAL /usr/bin/${OMNIIDL_EXECUTABLE_TO_FIND})
    ELSE(OMNIORB_EXECUTABLE STREQUAL /usr/bin/${OMNIIDL_EXECUTABLE_TO_FIND})
      SET(OMNIORB_ROOT_USER ${OMNIIDL_EXECUTABLE})
      GET_FILENAME_COMPONENT(OMNIORB_ROOT_USER ${OMNIORB_ROOT_USER} PATH)
      IF(WINDOWS)
	GET_FILENAME_COMPONENT(OMNIORB_ROOT_USER ${OMNIORB_ROOT_USER} PATH)
      ENDIF(WINDOWS)
      GET_FILENAME_COMPONENT(OMNIORB_ROOT_USER ${OMNIORB_ROOT_USER} PATH)
    ENDIF(OMNIORB_EXECUTABLE STREQUAL /usr/bin/${OMNIIDL_EXECUTABLE_TO_FIND})
  ELSE(OMNIIDL_EXECUTABLE)
    MESSAGE(STATUS "${OMNIIDL_EXECUTABLE_TO_FIND} not found, try to use WITH_OMNIORB option or OMNIORBHOME environment variable")
    SET(OMNIORB_STATUS 0)
  ENDIF(OMNIIDL_EXECUTABLE)
ENDIF(OMNIORB_STATUS)

# ------

IF(OMNIORB_STATUS)
  IF(OMNIORB_ROOT_USER)
    SET(OMNIORB_FIND_PATHS_OPTION NO_DEFAULT_PATH)
  ELSE(OMNIORB_ROOT_USER)
    SET(OMNIORB_FIND_PATHS_OPTION)
  ENDIF(OMNIORB_ROOT_USER)
ENDIF(OMNIORB_STATUS)

# ------

IF(OMNIORB_STATUS)
  SET(OMNIORB_INCLUDES) # to be removed
  SET(OMNIORB_INCLUDES_DIR)
ENDIF(OMNIORB_STATUS)
IF(OMNIORB_STATUS)
  IF(OMNIORB_ROOT_USER)
    SET(OMNIORB_INCLUDE_PATHS ${OMNIORB_ROOT_USER}/include)
  ELSE(OMNIORB_ROOT_USER)
    SET(OMNIORB_INCLUDE_PATHS)
  ENDIF(OMNIORB_ROOT_USER)
  SET(OMNIORB_INCLUDE_TO_FIND omniORB4/CORBA.h)
  FIND_PATH(OMNIORB_INCLUDE_DIR1 ${OMNIORB_INCLUDE_TO_FIND} PATHS ${OMNIORB_INCLUDE_PATHS} ${OMNIORB_FIND_PATHS_OPTION})
  IF(OMNIORB_INCLUDE_DIR1)
    SET(OMNIORB_INCLUDES ${OMNIORB_INCLUDES} -I${OMNIORB_INCLUDE_DIR1}) # to be removed
    SET(OMNIORB_INCLUDES_DIR ${OMNIORB_INCLUDE_DIR1})
    MESSAGE(STATUS "${OMNIORB_INCLUDE_TO_FIND} found in ${OMNIORB_INCLUDE_DIR1}")
  ELSE(OMNIORB_INCLUDE_DIR1)
    SET(OMNIORB_STATUS 0)
    IF(OMNIORB_ROOT_USER)
      MESSAGE(STATUS "${OMNIORB_INCLUDE_TO_FIND} not found in ${OMNIORB_INCLUDE_PATHS}, check your OMNIORB installation.")
    ELSE(OMNIORB_ROOT_USER)
      MESSAGE(STATUS "${OMNIORB_INCLUDE_TO_FIND} not found on system, try to use WITH_OMNIORB option or OMNIORB_ROOT environment variable.")
    ENDIF(OMNIORB_ROOT_USER)
  ENDIF(OMNIORB_INCLUDE_DIR1)
ENDIF(OMNIORB_STATUS)
IF(OMNIORB_STATUS)
  IF(OMNIORB_ROOT_USER)
    SET(OMNIORB_INCLUDE_PATHS ${OMNIORB_ROOT_USER}/include/omniORB4)
  ELSE(OMNIORB_ROOT_USER)
    SET(OMNIORB_INCLUDE_PATHS /usr/include/omniORB4)
  ENDIF(OMNIORB_ROOT_USER)
  SET(OMNIORB_INCLUDE_TO_FIND CORBA.h)
  FIND_PATH(OMNIORB_INCLUDE_DIR2 ${OMNIORB_INCLUDE_TO_FIND} PATHS ${OMNIORB_INCLUDE_PATHS} ${OMNIORB_FIND_PATHS_OPTION})
  IF(OMNIORB_INCLUDE_DIR2)
    SET(OMNIORB_INCLUDES ${OMNIORB_INCLUDES} -I${OMNIORB_INCLUDE_DIR2}) # to be removed
    SET(OMNIORB_INCLUDES_DIR ${OMNIORB_INCLUDES_DIR} ${OMNIORB_INCLUDE_DIR2})
    MESSAGE(STATUS "${OMNIORB_INCLUDE_TO_FIND} found in ${OMNIORB_INCLUDE_DIR2}")
  ELSE(OMNIORB_INCLUDE_DIR2)
    SET(OMNIORB_STATUS 0)
    MESSAGE(STATUS "${OMNIORB_INCLUDE_TO_FIND} not found in ${OMNIORB_INCLUDE_PATHS}, check your OMNIORB installation.")
  ENDIF(OMNIORB_INCLUDE_DIR2)
ENDIF(OMNIORB_STATUS)

# ------

IF(OMNIORB_STATUS)
  SET(OMNIORB_CXXFLAGS) # to be removed
  # SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -DOMNIORB_VERSION=4)
  SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -D__x86__) # to be removed
  SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -DCOMP_CORBA_DOUBLE) # to be removed
  SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -DCOMP_CORBA_LONG) # to be removed
  SET(OMNIORB_FLAGS "-D__x86__ -DCOMP_CORBA_DOUBLE -DCOMP_CORBA_LONG")
  IF(WINDOWS)
    SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -D__WIN32__)
    #    #  #  # SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -D_WIN32_WINNT=0x0400)
    #    SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -D__NT__)
    #    SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -D__OSVERSION__=4)
    #  ELSE(WINDOWS)
    #    SET(OMNIORB_CXXFLAGS ${OMNIORB_CXXFLAGS} -D__linux__)
  ENDIF(WINDOWS)
  #  IF(WINDOWS)
  #    SET(OMNIORB_LIBS ws2_32.lib mswsock.lib advapi32.lib ${OMNIORB_LIBS})
  #  ENDIF(WINDOWS)
ENDIF(OMNIORB_STATUS)

# ----

IF(OMNIORB_STATUS)
  IF(OMNIORB_ROOT_USER)
    IF(WINDOWS)
      SET(OMNIORB_LIB_PATHS ${OMNIORB_ROOT_USER}/lib/x86_win32)
    ELSE(WINDOWS)
      SET(OMNIORB_LIB_PATHS ${OMNIORB_ROOT_USER}/lib)
    ENDIF(WINDOWS)
  ELSE(OMNIORB_ROOT_USER)
    SET(OMNIORB_LIB_PATHS)
  ENDIF(OMNIORB_ROOT_USER)
ENDIF(OMNIORB_STATUS)

IF(OMNIORB_STATUS)
  IF(WINDOWS)
    IF(CMAKE_BUILD_TYPE STREQUAL Release)
      SET(OMNIORB_LIB_SUFFIX _rt)
    ELSE(CMAKE_BUILD_TYPE STREQUAL Release)
      SET(OMNIORB_LIB_SUFFIX _rtd)
    ENDIF(CMAKE_BUILD_TYPE STREQUAL Release)
  ELSE(WINDOWS)
    SET(OMNIORB_LIB_SUFFIX)
  ENDIF(WINDOWS)
ENDIF(OMNIORB_STATUS)

SET(OMNIORB_LIBS)
FOREACH(lib omniORB4 omniDynamic4 COS4 COSDynamic4 omnithread)
  IF(OMNIORB_STATUS)
    FIND_LIBRARY(${lib}${OMNIORB_LIB_SUFFIX} ${lib}${OMNIORB_LIB_SUFFIX} PATHS ${OMNIORB_LIB_PATHS} ${OMNIORB_FIND_PATHS_OPTION})
    IF(${lib}${OMNIORB_LIB_SUFFIX})
      SET(OMNIORB_LIBS ${OMNIORB_LIBS} ${${lib}${OMNIORB_LIB_SUFFIX}})
      MESSAGE(STATUS "${lib}${OMNIORB_LIB_SUFFIX} lib found: ${${lib}${OMNIORB_LIB_SUFFIX}}")
    ELSE(${lib}${OMNIORB_LIB_SUFFIX})
      SET(OMNIORB_STATUS 0)
      IF(OMNIORB_ROOT_USER)
	MESSAGE(STATUS "${lib}${OMNIORB_LIB_SUFFIX} lib not found in ${OMNIORB_LIB_PATHS}, check your OMNIORB installation.")
      ELSE(OMNIORB_ROOT_USER)
	MESSAGE(STATUS "${lib}${OMNIORB_LIB_SUFFIX} lib not found on system, try to use WITH_OMNIORB option or OMNIORB_ROOT environment variable.")
      ENDIF(OMNIORB_ROOT_USER)
    ENDIF(${lib}${OMNIORB_LIB_SUFFIX})
  ENDIF(OMNIORB_STATUS)
ENDFOREACH(lib omniORB4 omniDynamic4 COS4 COSDynamic4 omnithread)

# ----------------

IF(OMNIORB_STATUS)
  SET(OMNIORB_IDL_PYTHON $ENV{OMNIIDL_PYTHON})
  IF(NOT OMNIORB_IDL_PYTHON)
    SET(OMNIORB_IDL_PYTHON ${OMNIIDL_EXECUTABLE})
  ENDIF(NOT OMNIORB_IDL_PYTHON)
ENDIF(OMNIORB_STATUS)

# ----

IF(OMNIORB_STATUS)
  SET(CORBA_GEN 1)
  SET(OMNIORB_IDL ${OMNIIDL_EXECUTABLE})
  SET(CORBA_INCLUDES ${OMNIORB_INCLUDES})
  SET(CORBA_CXXFLAGS ${OMNIORB_CXXFLAGS})
  SET(CORBA_FLAGS ${OMNIORB_CXXFLAGS})
  SET(CORBA_LIBS ${OMNIORB_LIBS})
  SET(OMNIORB_IDLCXXFLAGS -Wba -nf)
  SET(OMNIORB_IDLPYFLAGS -bpython)
  SET(IDLCXXFLAGS ${OMNIORB_IDLCXXFLAGS})
  SET(IDLPYFLAGS ${OMNIORB_IDLPYFLAGS})
  SET(IDL_CLN_H .hh)
  SET(IDL_SRV_H .hh)
ELSE(OMNIORB_STATUS)
  SET(CORBA_GEN 0)
  IF(OMNIORB_IS_MANDATORY)
    MESSAGE(FATAL_ERROR "omniorb not found ... mandatory ... abort")
  ELSE(OMNIORB_IS_MANDATORY)
    MESSAGE(STATUS "omniorb not found ... optional ... disabled")
  ENDIF(OMNIORB_IS_MANDATORY)
ENDIF(OMNIORB_STATUS)

# ----
