/* sockd_dumpcf */

#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <syslog.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "socks.h"


void sockd_dumpcf(cfAddr, Ncf, useSyslog)
struct config *cfAddr;
int Ncf;
int useSyslog;
{
	char buf[1024], *bp;
	struct config *cp;
	char buf2[1024];
	int i, t;
	struct in_addr addr;
	
	if (useSyslog)
		syslog(LOG_HIGH,"Effective configuration entries: %d\n",Ncf);
	else
		printf("Effective configuration entries: %d\n",Ncf);

	for (i = 0, cp = cfAddr; i++ < Ncf; cp++) {
		switch (cp->action) {
		case NO_IDENTD:
			strcpy(buf, NO_IDENTD_STR);
			strcat(buf, " ");
			strcat(buf, cp->cmdp);
			buf2[0] = '\0';
			goto dump_it;
		case BAD_ID:
			strcpy(buf, BAD_ID_STR);
			strcat(buf, " ");
			strcat(buf, cp->cmdp);
			buf2[0] = '\0';
			goto dump_it;
		case SOCKD_PERMIT:
			strcpy(buf, "permit ");
			break;
		case SOCKD_DENY:
			strcpy(buf, "deny ");
			break;
		default:
			strcpy(buf, "*badaction* ");
			continue;
		}

		if ((t = cp->use_identd) != 0) {
			strcat(buf, t == 3 ? "?=n " :
				t == 1 ? "?=i " :
				t == 2 ? "?=I " :
				"?=*badvalue* ");
		}
		if (cp->userlist != NULL) {
			strcat(buf, "*=");
			strcat(buf, cp->userlist);
			strcat(buf, " ");
		}
		if (cp->sdomain != NULL)
			strcat(buf, cp->sdomain);
		else
			strcat(buf, inet_ntoa(cp->saddr));
		strcat(buf, " ");
		strcat(buf, inet_ntoa(cp->smask));
		strcat(buf, " ");
		if (cp->ddomain != NULL)
			strcat(buf, cp->ddomain);
		else
			strcat(buf, inet_ntoa(cp->daddr));
		strcat(buf, " ");
		strcat(buf, inet_ntoa(cp->dmask));
	
		switch (cp->tst) {
		case e_lt:
			sprintf(buf2,"lt %d ", cp->dport);
			break;
		case e_gt:
			sprintf(buf2,"gt %d ", cp->dport);
			break;
		case e_eq:
			sprintf(buf2,"eq %d ", cp->dport);
			break;
		case e_neq:
			sprintf(buf2,"neq %d ", cp->dport);
			break;
		case e_le:
			sprintf(buf2,"le %d ", cp->dport);
			break;
		case e_ge:
			sprintf(buf2,"ge %d ", cp->dport);
			break;
		case e_nil:
			buf2[0] = '\0';
			break;
		default:
			sprintf(buf2, "*badcmp* %d ", cp->dport);
		}
	
		if (cp->cmdp) {
			strcat(buf2, ": ");
			strcat(buf2, cp->cmdp);
		}
dump_it:
		if (useSyslog)
			syslog(LOG_HIGH, "CF%3d>>%s %s<<\n",i,buf, buf2);
		else
			printf("CF%3d>>%s %s<<\n",i,buf, buf2);
	}
}
