-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure WriteOperatorRenamingDeclaration (The_Operator : in RawDict.Operator_Info_Ref;
                                            Scope        : in Scopes) is

   procedure Write_Operator_Name (File : in SPARK_IO.File_Type;
                                  Name : in SP_Symbols.SP_Symbol)
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Name;
   is
   begin
      case Name is
         when SP_Symbols.RWand =>
            Write_String (File, "and");
         when SP_Symbols.RWor =>
            Write_String (File, "or");
         when SP_Symbols.RWxor =>
            Write_String (File, "xor");
         when SP_Symbols.plus =>
            Write_String (File, "+");
         when SP_Symbols.minus =>
            Write_String (File, "-");
         when SP_Symbols.RWmod =>
            Write_String (File, "mod");
         when SP_Symbols.equals =>
            Write_String (File, "=");
         when SP_Symbols.less_than =>
            Write_String (File, "<");
         when SP_Symbols.less_or_equal =>
            Write_String (File, "<=");
         when SP_Symbols.greater_than =>
            Write_String (File, ">");
         when SP_Symbols.greater_or_equal =>
            Write_String (File, ">=");
         when SP_Symbols.multiply =>
            Write_String (File, "*");
         when SP_Symbols.divide =>
            Write_String (File, "/");
         when SP_Symbols.double_star =>
            Write_String (File, "**");
         when SP_Symbols.RWabs =>
            Write_String (File, "abs");
         when others =>
            Write_String (File, "not");
      end case;
   end Write_Operator_Name;

   --------------------------------------------------------------------------------

   procedure Write_Unary_Operator_Renaming_Declaration
     (Name    : in SP_Symbols.SP_Symbol;
      Operand : in RawDict.Type_Info_Ref;
      Scope   : in Scopes)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dict,
   --#                                LexTokenManager.State,
   --#                                Name,
   --#                                Operand,
   --#                                Scope;
   is
   begin
      Write_String (Dict.TemporaryFile, "unary operator ");
      Write_Operator_Name (File => Dict.TemporaryFile,
                           Name => Name);
      Write_String (Dict.TemporaryFile, " ");
      Write_Name (File => Dict.TemporaryFile,
                  Item => RawDict.Get_Type_Symbol (Operand));
      Write_String (Dict.TemporaryFile, " is renamed in ");
      Write_Scope (Dict.TemporaryFile, Scope);
      Write_Line (Dict.TemporaryFile, " ;");
   end Write_Unary_Operator_Renaming_Declaration;

   --------------------------------------------------------------------------------

   procedure Write_Binary_Operator_Renaming_Declaration
     (Name  : in SP_Symbols.SP_Symbol;
      Left  : in RawDict.Type_Info_Ref;
      Right : in RawDict.Type_Info_Ref;
      Scope : in Scopes)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dict,
   --#                                Left,
   --#                                LexTokenManager.State,
   --#                                Name,
   --#                                Right,
   --#                                Scope;
   is
   begin
      Write_String (Dict.TemporaryFile, "binary operator ");
      Write_Name (File => Dict.TemporaryFile,
                  Item => RawDict.Get_Type_Symbol (Left));
      Write_String (Dict.TemporaryFile, " ");
      Write_Operator_Name (File => Dict.TemporaryFile,
                           Name => Name);
      Write_String (Dict.TemporaryFile, " ");
      Write_Name (File => Dict.TemporaryFile,
                  Item => RawDict.Get_Type_Symbol (Right));
      Write_String (Dict.TemporaryFile, " is renamed in ");
      Write_Scope (Dict.TemporaryFile, Scope);
      Write_Line (Dict.TemporaryFile, " ;");
   end Write_Binary_Operator_Renaming_Declaration;

begin -- WriteOperatorRenamingDeclaration
   case RawDict.Get_Operator_Is_Binary (The_Operator => The_Operator) is
      when False =>
         Write_Unary_Operator_Renaming_Declaration
           (Name    => RawDict.Get_Operator_Name (The_Operator => The_Operator),
            Operand => RawDict.Get_Operator_Operand (The_Operator => The_Operator),
            Scope   => Scope);
      when True =>
         Write_Binary_Operator_Renaming_Declaration
           (Name  => RawDict.Get_Operator_Name (The_Operator => The_Operator),
            Left  => RawDict.Get_Operator_Left_Operand (The_Operator => The_Operator),
            Right => RawDict.Get_Operator_Right_Operand (The_Operator => The_Operator),
            Scope => Scope);
   end case;
end WriteOperatorRenamingDeclaration;
