-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

---------------------------------------------------------------------------
--
-- - CFR  825 - PNA - Modify to produce GNAT style-compliant source code
-- - CFR 1023 - RCC - Modify to produce Unreferenced pragmas where needed
-- - CFR 1350 - RCC - Hide SPRelations body for SPARKMake Tool
-- - CFR 1480 - JMA - Modifications to compile under GNU Pascal 3.2.3
-- -                  ("COMP" now a reserved word; no $ allowed in identifiers;
-- -                  functions implemented in C declared as "external", not "C")
-- - CFR 1613 - RCC - Modifications for GPC 3.4.5 and first port to Mac OS X
-- - CFR 1929 - GA  - Creating of a SPARK implementation of SPARKLALR, based on
--                    existing Pascal implementation.
---------------------------------------------------------------------------

with Command_Line_Options;
with Ees_Sym;
with Fatal;
with SPARK_Ada_Integer_Text_IO;
with SPARK.Ada.Command_Line;
with SPARK.Ada.Strings.Unbounded;
with SPARK.Ada.Text_IO;
with SPARK.Ada.Text_IO.Unbounded_String;
with Sparklalr_Common;
with Sparklalr_Conflict;
with Sparklalr_Error;
with Sparklalr_Goto;
with Sparklalr_Input;
with Sparklalr_Memory;
with Sparklalr_Memory.Dump;
with Sparklalr_Memory.Left_Corner;
with Sparklalr_Parser;
with Sparklalr_Patab;
with Sparklalr_Symbol;
with Symbols_Dump;

use type SPARK.Ada.Text_IO.Exception_T;
use type Sparklalr_Symbol.Symbol;

--# inherit Command_Line_Options,
--#         Ees_Sym,
--#         Fatal,
--#         SPARK.Ada.Command_Line,
--#         SPARK.Ada.Strings.Unbounded,
--#         SPARK.Ada.Text_IO,
--#         SPARK.Ada.Text_IO.Unbounded_String,
--#         Sparklalr_Char_Class,
--#         Sparklalr_Common,
--#         Sparklalr_Conflict,
--#         Sparklalr_Error,
--#         Sparklalr_Goto,
--#         Sparklalr_Input,
--#         Sparklalr_Level,
--#         Sparklalr_Memory,
--#         Sparklalr_Memory.Dump,
--#         Sparklalr_Memory.Left_Corner,
--#         Sparklalr_Parser,
--#         Sparklalr_Patab,
--#         Sparklalr_Symbol,
--#         SPARK_Ada_Integer_Text_IO,
--#         Symbols_Dump;

--# main_program;
procedure Sparklalr
--# global in out SPARK.Ada.Command_Line.State;
--#        in out SPARK.Ada.Text_IO.The_Standard_Error;
--#        in out SPARK.Ada.Text_IO.The_Standard_Output;
--#           out Command_Line_Options.State;
--#           out Ees_Sym.State;
--#           out Sparklalr_Char_Class.Charmap;
--#           out Sparklalr_Conflict.State;
--#           out Sparklalr_Error.State;
--#           out Sparklalr_Goto.State;
--#           out Sparklalr_Input.State;
--#           out Sparklalr_Level.State;
--#           out Sparklalr_Memory.Dump.State;
--#           out Sparklalr_Memory.Left_Corner.State;
--#           out Sparklalr_Memory.Max_Right;
--#           out Sparklalr_Memory.Prod_No;
--#           out Sparklalr_Memory.Prod_Sum;
--#           out Sparklalr_Memory.Stat_No;
--#           out Sparklalr_Parser.State;
--#           out Sparklalr_Patab.State;
--#           out Symbols_Dump.State;
--# derives Command_Line_Options.State,
--#         Ees_Sym.State,
--#         SPARK.Ada.Command_Line.State,
--#         Sparklalr_Conflict.State,
--#         Sparklalr_Error.State,
--#         Sparklalr_Goto.State,
--#         Sparklalr_Input.State,
--#         Sparklalr_Level.State,
--#         Sparklalr_Memory.Dump.State,
--#         Sparklalr_Memory.Left_Corner.State,
--#         Sparklalr_Memory.Max_Right,
--#         Sparklalr_Memory.Prod_No,
--#         Sparklalr_Memory.Prod_Sum,
--#         Sparklalr_Memory.Stat_No,
--#         Sparklalr_Parser.State,
--#         Sparklalr_Patab.State,
--#         Symbols_Dump.State                    from SPARK.Ada.Command_Line.State &
--#         SPARK.Ada.Text_IO.The_Standard_Error,
--#         SPARK.Ada.Text_IO.The_Standard_Output from *,
--#                                                    SPARK.Ada.Command_Line.State &
--#         Sparklalr_Char_Class.Charmap          from ;
is

   subtype Ampterm_Ampgram_Range is Sparklalr_Symbol.Symbol range Sparklalr_Symbol.Ampterm .. Sparklalr_Symbol.Ampgram;
   subtype Ampprog_Ampmain is Sparklalr_Symbol.Symbol range Sparklalr_Symbol.Ampprog .. Sparklalr_Symbol.Ampmain;

   Echo         : SPARK.Ada.Text_IO.File_Type;
   Spark_Output : SPARK.Ada.Text_IO.File_Type;

   Col        : Sparklalr_Error.Err_Col_T;
   Symb       : Sparklalr_Symbol.Symbol;
   Gram_Rules : Boolean;

   Signpost : Sparklalr_Input.Symbol_Set_Type;

   User_Code : Boolean;
   Symb_Set  : Sparklalr_Input.Symbol_Set_Type;

   I : Sparklalr_Symbol.Symbol;

   procedure Initialise
   --# global in     Command_Line_Options.State;
   --#        in out SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#           out Col;
   --#           out Echo;
   --#           out Gram_Rules;
   --#           out Signpost;
   --#           out Sparklalr_Char_Class.Charmap;
   --#           out Sparklalr_Conflict.State;
   --#           out Sparklalr_Error.State;
   --#           out Sparklalr_Goto.State;
   --#           out Sparklalr_Input.State;
   --#           out Sparklalr_Level.State;
   --#           out Sparklalr_Memory.Dump.State;
   --#           out Sparklalr_Memory.Max_Right;
   --#           out Sparklalr_Memory.Prod_No;
   --#           out Sparklalr_Memory.Prod_Sum;
   --#           out Sparklalr_Memory.Stat_No;
   --#           out Sparklalr_Parser.State;
   --#           out Sparklalr_Patab.State;
   --#           out Spark_Output;
   --#           out Symb;
   --#           out Symbols_Dump.State;
   --# derives Col,
   --#         Gram_Rules,
   --#         Signpost,
   --#         Sparklalr_Char_Class.Charmap,
   --#         Sparklalr_Conflict.State,
   --#         Sparklalr_Goto.State,
   --#         Sparklalr_Level.State,
   --#         Sparklalr_Memory.Max_Right,
   --#         Sparklalr_Memory.Prod_No,
   --#         Sparklalr_Memory.Prod_Sum,
   --#         Sparklalr_Memory.Stat_No,
   --#         Sparklalr_Parser.State,
   --#         Sparklalr_Patab.State,
   --#         Symb,
   --#         Symbols_Dump.State                    from  &
   --#         Echo,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_Input.State,
   --#         Sparklalr_Memory.Dump.State,
   --#         Spark_Output                          from Command_Line_Options.State &
   --#         SPARK.Ada.Command_Line.State,
   --#         SPARK.Ada.Text_IO.The_Standard_Error,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Command_Line_Options.State;
   is
   begin
      Symbols_Dump.Initialise;
      Sparklalr_Memory.Dump.Initialise;
      Sparklalr_Goto.Initialise;
      Col := 0;
      SPARK.Ada.Text_IO.Unbounded_String.Create
        (File => Echo,
         Mode => SPARK.Ada.Text_IO.Out_File,
         Name => SPARK.Ada.Strings.Unbounded.Concat_Unbounded_String_String
           (Left  => Command_Line_Options.Get_File_Name,
            Right => ".EKO"),
         Form => SPARK.Ada.Strings.Unbounded.Null_Unbounded_String);
      if SPARK.Ada.Text_IO.Get_Last_Exception_File (File => Echo) /= SPARK.Ada.Text_IO.No_Exception then
         SPARK.Ada.Text_IO.Put_Error (Item => "Unable to open output EKO file");
         SPARK.Ada.Command_Line.Set_Exit_Status (SPARK.Ada.Command_Line.Failure);
      end if;
      if Command_Line_Options.Get_Parser then
         SPARK.Ada.Text_IO.Unbounded_String.Create
           (File => Spark_Output,
            Mode => SPARK.Ada.Text_IO.Out_File,
            Name => SPARK.Ada.Strings.Unbounded.Concat_Unbounded_String_String
              (Left  => Command_Line_Options.Get_File_Name,
               Right => ".PAR"),
            Form => SPARK.Ada.Strings.Unbounded.Null_Unbounded_String);
         if SPARK.Ada.Text_IO.Get_Last_Exception_File (File => Spark_Output) /= SPARK.Ada.Text_IO.No_Exception then
            SPARK.Ada.Text_IO.Put_Error (Item => "Unable to open output PAR file");
            SPARK.Ada.Command_Line.Set_Exit_Status (SPARK.Ada.Command_Line.Failure);
         end if;
      end if;
      Sparklalr_Parser.Initialise;
      Sparklalr_Patab.Initialise;
      Sparklalr_Conflict.Initialise;
      Gram_Rules := True;
      Sparklalr_Input.Initialise (Signpost);
      Symb := Sparklalr_Symbol.Nullsymb;
      --# accept F, 602, Spark_Output, Spark_Output, "Always defined before used";
   end Initialise;

   procedure Grammar
   --# global in     Command_Line_Options.State;
   --#        in     Gram_Rules;
   --#        in     Signpost;
   --#        in     Sparklalr_Char_Class.Charmap;
   --#        in out Col;
   --#        in out Echo;
   --#        in out SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Conflict.State;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Goto.State;
   --#        in out Sparklalr_Input.State;
   --#        in out Sparklalr_Level.State;
   --#        in out Sparklalr_Memory.Dump.State;
   --#        in out Sparklalr_Memory.Max_Right;
   --#        in out Sparklalr_Memory.Prod_No;
   --#        in out Sparklalr_Memory.Prod_Sum;
   --#        in out Sparklalr_Memory.Stat_No;
   --#        in out Sparklalr_Parser.State;
   --#        in out Sparklalr_Patab.State;
   --#        in out Symbols_Dump.State;
   --#           out Symb;
   --# derives Col,
   --#         Sparklalr_Input.State,
   --#         Sparklalr_Memory.Prod_No,
   --#         Symb,
   --#         Symbols_Dump.State                    from Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Memory.Dump.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Symbols_Dump.State &
   --#         Echo,
   --#         SPARK.Ada.Command_Line.State,
   --#         SPARK.Ada.Text_IO.The_Standard_Error,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Gram_Rules,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Conflict.State,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Goto.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Level.State,
   --#                                                    Sparklalr_Memory.Dump.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    Sparklalr_Patab.State,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Conflict.State,
   --#         Sparklalr_Memory.Dump.State,
   --#         Sparklalr_Memory.Prod_Sum,
   --#         Sparklalr_Parser.State,
   --#         Sparklalr_Patab.State                 from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Gram_Rules,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Goto.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Level.State,
   --#                                                    Sparklalr_Memory.Dump.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Error.State,
   --#         Sparklalr_Goto.State,
   --#         Sparklalr_Memory.Stat_No              from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Goto.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Memory.Dump.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Level.State                 from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Gram_Rules,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Memory.Dump.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Memory.Max_Right            from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Gram_Rules,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Goto.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Level.State,
   --#                                                    Sparklalr_Memory.Dump.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Memory.Prod_Sum,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    Symbols_Dump.State;
   is

      Symbolset_Skipto : Sparklalr_Input.Symbol_Set_Type;
      Grammar_Token    : Sparklalr_Common.Id_Name;

      procedure Out_Pt
      --# global in     Command_Line_Options.State;
      --#        in     Sparklalr_Conflict.State;
      --#        in     Sparklalr_Goto.State;
      --#        in     Sparklalr_Memory.Dump.State;
      --#        in     Sparklalr_Memory.Prod_No;
      --#        in     Sparklalr_Memory.Stat_No;
      --#        in     Sparklalr_Parser.State;
      --#        in     Sparklalr_Patab.State;
      --#        in     Symbols_Dump.State;
      --#        in out Echo;
      --#        in out SPARK.Ada.Command_Line.State;
      --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
      --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
      --#        in out Sparklalr_Memory.Prod_Sum;
      --#           out Sparklalr_Memory.Max_Right;
      --# derives Echo,
      --#         SPARK.Ada.Command_Line.State,
      --#         SPARK.Ada.Text_IO.The_Standard_Error,
      --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
      --#                                                    Command_Line_Options.State,
      --#                                                    Sparklalr_Conflict.State,
      --#                                                    Sparklalr_Goto.State,
      --#                                                    Sparklalr_Memory.Dump.State,
      --#                                                    Sparklalr_Memory.Prod_No,
      --#                                                    Sparklalr_Memory.Stat_No,
      --#                                                    Sparklalr_Parser.State,
      --#                                                    Sparklalr_Patab.State,
      --#                                                    Symbols_Dump.State &
      --#         Sparklalr_Memory.Max_Right,
      --#         Sparklalr_Memory.Prod_Sum             from Sparklalr_Memory.Dump.State,
      --#                                                    Sparklalr_Memory.Prod_No,
      --#                                                    Sparklalr_Memory.Prod_Sum;
      is

         -- - This procedure highlights any redundant productions in an input grammar -
         procedure Check_Consistency (Std_Out : in     Boolean;
                                      F       : in out SPARK.Ada.Text_IO.File_Type)
         --# global in     Sparklalr_Goto.State;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Symbols_Dump.State;
         --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
         --# derives F,
         --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
         --#                                                    Sparklalr_Goto.State,
         --#                                                    Sparklalr_Memory.Stat_No,
         --#                                                    Std_Out,
         --#                                                    Symbols_Dump.State;
         is
            J       : Integer;
            Nt_Used : Boolean;
            Posn    : Integer;
         begin
            for I in Integer range 2 .. Symbols_Dump.Get_Nnon_Terms loop
               Nt_Used := False;
               J       := 1;
               while (not Nt_Used) and then (J <= Sparklalr_Memory.Get_Stat_No) loop
                  Nt_Used := Sparklalr_Goto.Goto_Search (J, I + Sparklalr_Common.Nt_Base) /= 0;
                  J       := J + 1;
               end loop;
               if not Nt_Used then
                  Sparklalr_Common.Put_File_Output (Std_Out => Std_Out,
                                                    File    => F,
                                                    Item    => "**** WARNING NON-TERMINAL ");
                  Posn := 27;
                  --# accept F, 41, "Stable expression here expected and OK";
                  if Std_Out then
                     --# end accept;
                     --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
                     Sparklalr_Common.Print
                       (Std_Out => True,
                        F       => F,
                        String1 => Symbols_Dump.Get_Nterm_Set (I),
                        Posn    => Posn,
                        Tab     => 27,
                        Comm    => False);
                     --# end accept;
                  else
                     --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
                     Sparklalr_Common.Print
                       (Std_Out => False,
                        F       => F,
                        String1 => Symbols_Dump.Get_Nterm_Set (I),
                        Posn    => Posn,
                        Tab     => 27,
                        Comm    => False);
                     --# end accept;
                  end if;
                  Sparklalr_Common.Put_Line_File_Output (Std_Out => Std_Out,
                                                         File    => F,
                                                         Item    => " IS DEFINED BUT NEVER USED.");
                  Sparklalr_Common.Put_Line_File_Output
                    (Std_Out => Std_Out,
                     File    => F,
                     Item    => "     This may produce an inconsistent parser!!!");
               end if;
            end loop;
         end Check_Consistency;

         procedure Statistics (Std_Out : in     Boolean;
                               F       : in out SPARK.Ada.Text_IO.File_Type)
         --# global in     Sparklalr_Conflict.State;
         --#        in     Sparklalr_Goto.State;
         --#        in     Sparklalr_Memory.Dump.State;
         --#        in     Sparklalr_Memory.Prod_No;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Sparklalr_Parser.State;
         --#        in     Sparklalr_Patab.State;
         --#        in     Symbols_Dump.State;
         --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
         --# derives F,
         --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
         --#                                                    Sparklalr_Conflict.State,
         --#                                                    Sparklalr_Goto.State,
         --#                                                    Sparklalr_Memory.Dump.State,
         --#                                                    Sparklalr_Memory.Prod_No,
         --#                                                    Sparklalr_Memory.Stat_No,
         --#                                                    Sparklalr_Parser.State,
         --#                                                    Sparklalr_Patab.State,
         --#                                                    Std_Out,
         --#                                                    Symbols_Dump.State;
         is
         begin
            Sparklalr_Common.New_Line_File_Output (Std_Out => Std_Out,
                                                   File    => F);
            Sparklalr_Conflict.Conflict_Stats (Std_Out => Std_Out,
                                               F       => F);
            Sparklalr_Common.Put_Integer_File_Output (Std_Out => Std_Out,
                                                      File    => F,
                                                      Item    => Symbols_Dump.Get_Nterms,
                                                      Width   => 6);
            Sparklalr_Common.Put_File_Output (Std_Out => Std_Out,
                                              File    => F,
                                              Item    => " TERMINALS (");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Sparklalr_Common.Term_Lim,
               Width   => 1);
            Sparklalr_Common.Put_Line_File_Output (Std_Out => Std_Out,
                                                   File    => F,
                                                   Item    => " MAX)");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Symbols_Dump.Get_Nnon_Terms,
               Width   => 6);
            Sparklalr_Common.Put_File_Output (Std_Out => Std_Out,
                                              File    => F,
                                              Item    => " NONTERMINALS (");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Sparklalr_Common.Non_Term_Lim,
               Width   => 1);
            Sparklalr_Common.Put_Line_File_Output (Std_Out => Std_Out,
                                                   File    => F,
                                                   Item    => " MAX)");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Sparklalr_Memory.Get_Prod_No - 1,
               Width   => 6);
            Sparklalr_Common.Put_File_Output (Std_Out => Std_Out,
                                              File    => F,
                                              Item    => " PRODUCTIONS (");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Sparklalr_Common.Prod_Lim,
               Width   => 1);
            Sparklalr_Common.Put_Line_File_Output (Std_Out => Std_Out,
                                                   File    => F,
                                                   Item    => " MAX)");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Sparklalr_Memory.Get_Stat_No,
               Width   => 6);
            Sparklalr_Common.Put_File_Output (Std_Out => Std_Out,
                                              File    => F,
                                              Item    => " STATES (");
            Sparklalr_Common.Put_Integer_File_Output
              (Std_Out => Std_Out,
               File    => F,
               Item    => Sparklalr_Common.State_Max,
               Width   => 1);
            Sparklalr_Common.Put_Line_File_Output (Std_Out => Std_Out,
                                                   File    => F,
                                                   Item    => " MAX)");
            Sparklalr_Parser.Pa_Stats (Std_Out => Std_Out,
                                       F       => F);
            Sparklalr_Goto.Goto_Stats (Std_Out => Std_Out,
                                       F       => F);
            Sparklalr_Patab.Opt_Stats (Std_Out => Std_Out,
                                       F       => F);
            Sparklalr_Memory.Dump.Mem_Stats (Std_Out => Std_Out,
                                             F       => F);
         end Statistics;

         procedure Dump_Verb
         --# global in     Command_Line_Options.State;
         --#        in     Sparklalr_Conflict.State;
         --#        in     Sparklalr_Goto.State;
         --#        in     Sparklalr_Memory.Dump.State;
         --#        in     Sparklalr_Memory.Prod_No;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Sparklalr_Parser.State;
         --#        in     Sparklalr_Patab.State;
         --#        in     Symbols_Dump.State;
         --#        in out Echo;
         --#        in out SPARK.Ada.Command_Line.State;
         --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
         --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
         --# derives Echo,
         --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
         --#                                                    Sparklalr_Conflict.State,
         --#                                                    Sparklalr_Goto.State,
         --#                                                    Sparklalr_Memory.Dump.State,
         --#                                                    Sparklalr_Memory.Prod_No,
         --#                                                    Sparklalr_Memory.Stat_No,
         --#                                                    Sparklalr_Parser.State,
         --#                                                    Sparklalr_Patab.State,
         --#                                                    Symbols_Dump.State &
         --#         SPARK.Ada.Command_Line.State,
         --#         SPARK.Ada.Text_IO.The_Standard_Error  from *,
         --#                                                    Command_Line_Options.State,
         --#                                                    Sparklalr_Conflict.State,
         --#                                                    Sparklalr_Goto.State,
         --#                                                    Sparklalr_Memory.Dump.State,
         --#                                                    Sparklalr_Memory.Prod_No,
         --#                                                    Sparklalr_Memory.Stat_No,
         --#                                                    Sparklalr_Parser.State,
         --#                                                    Sparklalr_Patab.State,
         --#                                                    Symbols_Dump.State;
         is

            Descript : SPARK.Ada.Text_IO.File_Type;

            procedure Dump_States (F : in out SPARK.Ada.Text_IO.File_Type)
            --# global in     Sparklalr_Conflict.State;
            --#        in     Sparklalr_Memory.Dump.State;
            --#        in     Sparklalr_Memory.Stat_No;
            --#        in     Sparklalr_Parser.State;
            --#        in     Symbols_Dump.State;
            --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
            --# derives F,
            --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
            --#                                                    Sparklalr_Conflict.State,
            --#                                                    Sparklalr_Memory.Dump.State,
            --#                                                    Sparklalr_Memory.Stat_No,
            --#                                                    Sparklalr_Parser.State,
            --#                                                    Symbols_Dump.State;
            is
               S, T : Sparklalr_Memory.Dump.Pt_Memory;
            begin
               for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
                  SPARK.Ada.Text_IO.New_Line_File (File    => F,
                                                   Spacing => 1);
                  SPARK.Ada.Text_IO.Put_File (File => F,
                                              Item => " STATE ");
                  SPARK_Ada_Integer_Text_IO.Put_File (File  => F,
                                                      Item  => I,
                                                      Width => 4,
                                                      Base  => 10);
                  SPARK.Ada.Text_IO.New_Line_File (File    => F,
                                                   Spacing => 1);
                  S := Sparklalr_Memory.Dump.Get_State (I);
                  T := Sparklalr_Memory.Dump.Get_State (I + 1);
                  Sparklalr_Memory.Dump.Dump_Items (F, S, T);
                  SPARK.Ada.Text_IO.New_Line_File (File    => F,
                                                   Spacing => 1);
                  Sparklalr_Parser.Dump_Actions (F, I);
                  SPARK.Ada.Text_IO.New_Line_File (File    => F,
                                                   Spacing => 1);
                  Sparklalr_Conflict.Dump_Conflicts (F, I);
               end loop;
            end Dump_States;

         begin -- Dump_Verb
            SPARK.Ada.Text_IO.Unbounded_String.Create
              (File => Descript,
               Mode => SPARK.Ada.Text_IO.Out_File,
               Name => SPARK.Ada.Strings.Unbounded.Concat_Unbounded_String_String
                 (Left  => Command_Line_Options.Get_File_Name,
                  Right => ".DSC"),
               Form => SPARK.Ada.Strings.Unbounded.Null_Unbounded_String);
            if SPARK.Ada.Text_IO.Get_Last_Exception_File (File => Descript) /= SPARK.Ada.Text_IO.No_Exception then
               SPARK.Ada.Text_IO.Put_Error (Item => "Unable to open output DSC file");
               SPARK.Ada.Command_Line.Set_Exit_Status (SPARK.Ada.Command_Line.Failure);
            end if;
            Sparklalr_Memory.Dump.Dump_Prdns (Descript);
            Check_Consistency (Std_Out => False,
                               F       => Descript);
            Dump_States (Descript);
            Sparklalr_Goto.Dump_Goto (Descript);
            Statistics (Std_Out => False,
                        F       => Echo);
            Statistics (Std_Out => False,
                        F       => Descript);
            Statistics (Std_Out => True,
                        F       => Descript);
            SPARK.Ada.Text_IO.Close (File => Descript);
            if SPARK.Ada.Text_IO.Get_Last_Exception_File (File => Descript) /= SPARK.Ada.Text_IO.No_Exception then
               SPARK.Ada.Text_IO.Put_Error (Item => "Unable to close output DSC file");
               SPARK.Ada.Command_Line.Set_Exit_Status (SPARK.Ada.Command_Line.Failure);
            end if;
         end Dump_Verb;

      begin -- Out_Pt
         if Command_Line_Options.Get_Verbose then
            Dump_Verb;
         else
            Sparklalr_Memory.Dump.Dump_Prdns (Echo);
            Check_Consistency (Std_Out => True,
                               F       => Echo);
            Statistics (Std_Out => True,
                        F       => Echo);
            Check_Consistency (Std_Out => False,
                               F       => Echo);
            Sparklalr_Conflict.Print_Conflicts (Echo);
            Statistics (Std_Out => False,
                        F       => Echo);
         end if;
         if Command_Line_Options.Get_Dump_Mem then
            Sparklalr_Memory.Dump.Mem_Dump;
         end if;
         Sparklalr_Memory.Dump.Summary;
      end Out_Pt;

   begin -- Grammar
      Sparklalr_Input.Scan (Echo, Col, Symb, Grammar_Token);
      while not Sparklalr_Input.Get_Symbol_Set (Signpost, Symb) loop
         if Symb = Sparklalr_Symbol.Ident then
            Sparklalr_Memory.Dump.Lhs_Process (Echo, Gram_Rules, Grammar_Token, Col);
            --# accept F, 10, Grammar_Token, "Ineffective assignment here expected and OK";
            Sparklalr_Input.Scan (Echo, Col, Symb, Grammar_Token);
            --# end accept;
            if Symb = Sparklalr_Symbol.Colon then
               loop
                  Sparklalr_Memory.Dump.Rhs_Process (Echo, Symb, Gram_Rules, Col, Signpost);
                  exit when Symb /= Sparklalr_Symbol.Uparrow;
               end loop;
            else
               Sparklalr_Error.Syn_Error (6, Col);
            end if;
         else
            Sparklalr_Error.Syn_Error (7, Col);
            Symbolset_Skipto := Sparklalr_Input.Signpost_To_Symbol_Set_Type (Signpost);
            Sparklalr_Input.Set_Symbol_Set (Symbolset_Skipto, Sparklalr_Symbol.Scolon, True);
            --# accept F, 10, Symb, "Ineffective assignment here expected and OK";
            Sparklalr_Input.Skipto (Echo, Symbolset_Skipto, Col, Symb);
            --# end accept;
         end if;
         Sparklalr_Input.Scan (Echo, Col, Symb, Grammar_Token);
      end loop;
      if not Sparklalr_Error.Get_Prod_Err then
         Sparklalr_Memory.Dump.Findntredns (Echo);
      end if;
      if not Sparklalr_Error.Get_Prod_Err then
         Sparklalr_Memory.Dump.State_Generation (Echo);
         Sparklalr_Conflict.Parse_Action_Generation (Echo);
         Out_Pt;
      end if;
   end Grammar;

begin
   Command_Line_Options.Get_Options;
   Initialise;
   for K in Ampterm_Ampgram_Range loop
      if Symb < K then
         Symb_Set := Sparklalr_Input.Symbol_Set_False_Const;
         I        := K;
         while I < Sparklalr_Symbol.Endfile loop
            Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
            I := Sparklalr_Symbol.Symbol'Succ (I);
         end loop;
         Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
         Sparklalr_Input.Skipto (Echo, Symb_Set, Col, Symb);
      end if;
      User_Code := K = Symb;
      case K is
         when Sparklalr_Symbol.Ampterm =>
            if User_Code then
               Sparklalr_Input.Proc_Term (Echo, Gram_Rules, Col, Signpost, Symb);
            end if;
         when Sparklalr_Symbol.Ampgram =>
            if User_Code then
               Grammar;
            else
               Sparklalr_Error.Error (Echo, 1);
            end if;
      end case;
      Sparklalr_Error.List_Line_Errors (Echo, Col);
   end loop;
   if Command_Line_Options.Get_Parser and then (not Sparklalr_Error.Get_Prod_Err) then
      for K in Ampprog_Ampmain loop
         if Symb < K then
            Symb_Set := Sparklalr_Input.Symbol_Set_False_Const;
            I        := K;
            while I < Sparklalr_Symbol.Endfile loop
               Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
               I := Sparklalr_Symbol.Symbol'Succ (I);
            end loop;
            Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
            Sparklalr_Input.Skipto (Echo, Symb_Set, Col, Symb);
         end if;
         case K is
            when Sparklalr_Symbol.Ampprog =>
               -- The following relations must be generated before output generation
               SPARK.Ada.Text_IO.New_Line_Output (Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_Output (Item => "Determing Shift States, Reduce States, and Unique Reduce States...");
               Sparklalr_Parser.Gen_State_Info;
               SPARK.Ada.Text_IO.Put_Line_Output (Item => "Generating relation Left Corner...");
               Sparklalr_Memory.Left_Corner.Gen_Left_Corner;
               SPARK.Ada.Text_IO.Put_Line_Output (Item => "Generating Essential Expected Symbols...");
               Ees_Sym.Gen_Essentials;
               SPARK.Ada.Text_IO.Put_Line_Output (Item => "Calculating Table Sizes...");
               Sparklalr_Patab.Calc_Table_Sizes;
               Sparklalr_Memory.Left_Corner.Count_Left_Corners;
               Ees_Sym.Out_Essentials;
               -- --------------------------------------------------------------------
               -- -------- Main section of SPARK parser table generartion ------------
               SPARK.Ada.Text_IO.Put_Line_Output (Item => "Generating SPARK Parser Tables...");
               Sparklalr_Memory.Dump.Productions_Package_Out (Spark_Output);
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               Symbols_Dump.Symbols_Package_Out (Spark_Output);
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               Symbols_Dump.Symbol_Strings_Out;
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "with SP_Productions;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "with SP_Symbols;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "--# inherit SP_Productions,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "--#         SP_Symbols;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "package SP_Parser_Actions is");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   type SP_Action_Kind is (Error, Shift, Reduce, Accpt);");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   type SP_Parse_Act is record");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Act     : SP_Action_Kind;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      State   : SP_Productions.SP_State;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Symbol  : SP_Symbols.SP_Symbol;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Red_By  : SP_Productions.SP_Right;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Prod_No : SP_Productions.SP_Prod_No;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   end record;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   type Action_Index is private;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   First_Action_Index : constant Action_Index;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   No_Sym  : constant SP_Symbols.SP_Symbol      := SP_Symbols.SPDEFAULT;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   No_Red  : constant SP_Productions.SP_Right   := 0;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   No_Prod : constant SP_Productions.SP_Prod_No := 0;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   Accept_Action : constant SP_Parse_Act :=");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "     SP_Parse_Act'(Act     => Accpt,");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "                   State   => SP_Productions.No_State,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "                   Symbol  => No_Sym,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "                   Red_By  => No_Red,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "                   Prod_No => No_Prod);");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   Error_Action  : constant SP_Parse_Act :=");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "     SP_Parse_Act'(Act     => Error,");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "                   State   => SP_Productions.No_State,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "                   Symbol  => No_Sym,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "                   Red_By  => No_Red,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "                   Prod_No => No_Prod);");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   function SPA (CST : SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "                 CSY : SP_Symbols.SP_Terminal) return SP_Parse_Act;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   procedure Scan_Action_Table");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "     (State_No      : in     SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Index         : in out Action_Index;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Parse_Act     : out    SP_Parse_Act;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "      Action_Symbol : out    SP_Symbols.SP_Terminal);");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --# derives Action_Symbol,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --#         Index,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --#         Parse_Act     from Index,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --#                            State_No;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "private");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_File (File => Spark_Output,
                                           Item => "   Max_PAT_Segment : constant Natural := ");
               SPARK_Ada_Integer_Text_IO.Put_File
                 (File  => Spark_Output,
                  Item  => Sparklalr_Patab.Get_Pat_Seg_Count,
                  Width => 1,
                  Base  => 10);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => ";");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   type Action_Index is range 0 .. Max_PAT_Segment;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   First_Action_Index : constant Action_Index := 0;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "end SP_Parser_Actions;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "with SP_Productions;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "with SP_Symbols;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "use type SP_Productions.SP_State;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "--# inherit SP_Productions,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "--#         SP_Symbols;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "package SP_Parser_Goto is");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   type Goto_Index is private;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   First_Goto_Index : constant Goto_Index;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   function SP_Goto (CST : SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_File (File => Spark_Output,
                                           Item => "                     CSY : SP_Symbols.SP_Non_Terminal)");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => " return SP_Productions.SP_State;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   procedure Scan_Goto_Table");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "     (State_No       : in     SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Index          : in out Goto_Index;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "      Goal_State     : out    SP_Productions.SP_State;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "      Reduction_Goal : out    SP_Symbols.SP_Non_Terminal);");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --# derives Goal_State,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --#         Index,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --#         Reduction_Goal from Index,");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   --#                             State_No;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "private");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_File (File => Spark_Output,
                                           Item => "   No_Of_Goto_Entries : constant Positive := ");
               SPARK_Ada_Integer_Text_IO.Put_File
                 (File  => Spark_Output,
                  Item  => Sparklalr_Goto.Get_Goto_List_Count,
                  Width => 1,
                  Base  => 10);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => ";");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   type Goto_Index is range 1 .. No_Of_Goto_Entries + 1;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   First_Goto_Index : constant Goto_Index := 1;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "end SP_Parser_Goto;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "package body SP_Parser_Actions is");
               --# accept F, 41, "Stable expression here expected and OK";
               if Command_Line_Options.Get_Self_Pack then
                  Sparklalr_Patab.Pa_Out_Sp (Spark_Output);
               else
                  Sparklalr_Patab.Pa_Out (Spark_Output);
               end if;
               --# end accept;
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   function SPA (CST : SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "                 CSY : SP_Symbols.SP_Terminal) return SP_Parse_Act");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      is separate;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   procedure Scan_Action_Table");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "     (State_No      : in     SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Index         : in out Action_Index;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Parse_Act     : out    SP_Parse_Act;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "      Action_Symbol : out    SP_Symbols.SP_Terminal)");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      is separate;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "end SP_Parser_Actions;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "package body SP_Parser_Goto is");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   subtype GOT_Index is Goto_Index range 1 .. Goto_Index'Last - 1;");
               --# accept F, 41, "Stable expression here expected and OK";
               if Command_Line_Options.Get_Self_Pack then
                  Sparklalr_Goto.Goto_Out_Sp (Spark_Output);
               else
                  Sparklalr_Goto.Goto_Out (Spark_Output);
               end if;
               --# end accept;
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "   function SP_Goto (CST : SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_File (File => Spark_Output,
                                           Item => "                     CSY : SP_Symbols.SP_Non_Terminal)");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => " return SP_Productions.SP_State");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      is separate;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "   procedure Scan_Goto_Table");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "     (State_No       : in     SP_Productions.Valid_States;");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      Index          : in out Goto_Index;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "      Goal_State     : out    SP_Productions.SP_State;");
               SPARK.Ada.Text_IO.Put_Line_File
                 (File => Spark_Output,
                  Item => "      Reduction_Goal : out    SP_Symbols.SP_Non_Terminal)");
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "      is separate;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               SPARK.Ada.Text_IO.Put_Line_File (File => Spark_Output,
                                                Item => "end SP_Parser_Goto;");
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               Ees_Sym.Sp_Exp_Out (Spark_Output);
               SPARK.Ada.Text_IO.New_Line_File (File    => Spark_Output,
                                                Spacing => 1);
               Sparklalr_Memory.Left_Corner.Out_Left_Corner (Spark_Output);
               -- ---------------------------------------------------------------------------
               -- ---- Program fragments must not be included in a SPARKLALR grammar file ---
            when Sparklalr_Symbol.Amplabel =>
               null;
            when Sparklalr_Symbol.Ampconst =>
               null;
            when Sparklalr_Symbol.Amptype =>
               null;
            when Sparklalr_Symbol.Ampvar =>
               null;
            when Sparklalr_Symbol.Ampfunc =>
               null;
            when Sparklalr_Symbol.Ampmain =>
               null;
         end case;
         -- ----------------------------------------------------------------------------
         Sparklalr_Error.List_Line_Errors (Echo, Col);
      end loop;
   end if;
   Sparklalr_Input.Finalize (Echo);
   SPARK.Ada.Text_IO.Close (File => Spark_Output);
   if SPARK.Ada.Text_IO.Get_Last_Exception_File (File => Spark_Output) /= SPARK.Ada.Text_IO.No_Exception then
      SPARK.Ada.Text_IO.Put_Error (Item => "Unable to close output PAR file");
      SPARK.Ada.Command_Line.Set_Exit_Status (SPARK.Ada.Command_Line.Failure);
   end if;
   SPARK.Ada.Text_IO.Close (File => Echo);
   if SPARK.Ada.Text_IO.Get_Last_Exception_File (File => Echo) /= SPARK.Ada.Text_IO.No_Exception then
      SPARK.Ada.Text_IO.Put_Error (Item => "Unable to close output EKO file");
      SPARK.Ada.Command_Line.Set_Exit_Status (SPARK.Ada.Command_Line.Failure);
   end if;
   --# accept F, 602, Ees_Sym.State, Ees_Sym.State, "Always defined before used" &
   --#        F, 602, Sparklalr_Memory.Left_Corner.State, Sparklalr_Memory.Left_Corner.State, "Always defined before used";
exception
   --# hide Sparklalr;
   when Fatal.Command_Line_Error =>
      null;
   when others =>
      SPARK.Ada.Text_IO.Put_Error (Item => "An unexpected internal error has occurred");
      raise;
end Sparklalr;
