'\"
'\" Generated from file 'multiop\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "fileutil::multi::op" n 0\&.5\&.3 tcllib "file utilities"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
fileutil::multi::op \- Multi-file operation, scatter/gather
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBfileutil::multi::op  ?0\&.5\&.3?\fR
.sp
package require \fBwip  ?1\&.0?\fR
.sp
\fB::fileutil::multi::op\fR ?\fIopName\fR? ?\fIword\fR\&.\&.\&.?
.sp
\fBopName\fR \fIoption\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fB$opName\fR \fBdo\fR ?\fIword\fR\&.\&.\&.?
.sp
\fBinto\fR \fIdirectory\fR
.sp
\fBin\fR \fIdirectory\fR
.sp
\fBto\fR \fIdirectory\fR
.sp
\fBfrom\fR \fIdirectory\fR
.sp
\fBnot\fR \fIpattern\fR
.sp
\fBfor\fR \fIpattern\fR
.sp
\fBexclude\fR \fIpattern\fR
.sp
\fBbut\fR
.sp
\fBexcept\fR
.sp
\fBas\fR \fIname\fR
.sp
\fBrecursive\fR
.sp
\fBrecursively\fR
.sp
\fBcopy\fR
.sp
\fBmove\fR
.sp
\fBremove\fR
.sp
\fBexpand\fR
.sp
\fBinvoke\fR \fIcmdprefix\fR
.sp
\fBreset\fR
.sp
\fB(\fR
.sp
\fB)\fR
.sp
\fBcd\fR \fIdirectory\fR
.sp
\fBup\fR
.sp
\fBfor-windows\fR
.sp
\fBfor-win\fR
.sp
\fBfor-unix\fR
.sp
\fBthe\fR \fIpattern\fR
.sp
\fBthe-set\fR \fIvarname\fR
.sp
\fB->\fR \fIvarname\fR
.sp
\fBstrict\fR
.sp
\fB!strict\fR
.sp
\fBfiles\fR
.sp
\fBlinks\fR
.sp
\fBdirectories\fR
.sp
\fBdirs\fR
.sp
\fBall\fR
.sp
\fBstate?\fR
.sp
\fBas?\fR
.sp
\fBexcluded?\fR
.sp
\fBfrom?\fR
.sp
\fBinto?\fR
.sp
\fBoperation?\fR
.sp
\fBrecursive?\fR
.sp
\fBstrict?\fR
.sp
\fBtype?\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides objects which are able to perform actions on
multiple files selected by glob patterns\&.
.PP
At the core is a domain specific language allowing the easy
specification of multi-file copy and/or move and/or deletion
operations\&. Alternate names would be scatter/gather processor, or
maybe even assembler\&.
.SH "CLASS API"
The main command of the package is:
.TP
\fB::fileutil::multi::op\fR ?\fIopName\fR? ?\fIword\fR\&.\&.\&.?
The command creates a new multi-file operation object with an
associated global Tcl command whose name is \fIopName\fR\&.  This
command can be used to invoke the various possible file operations\&.
It has the following general form:
.RS
.TP
\fBopName\fR \fIoption\fR ?\fIarg arg \&.\&.\&.\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command\&.
.RE
.sp
If the string \fB%AUTO%\fR is used as the \fIopName\fR then the
package will generate a unique name on its own\&.
.sp
If one or more \fIword\fRs are specified they are interpreted as an
initial set of file commands to execute\&. I\&.e\&. the method \fBdo\fR
of the newly constructed object is implicitly invoked using the words
as its arguments\&.
.PP
.PP
.SH "OBJECT API"
The following methods are possible for multi-file operation objects:
.TP
\fB$opName\fR \fBdo\fR ?\fIword\fR\&.\&.\&.?
This method interprets the specified words as file commands to
execute\&. See the section \fBFILE API\fR for the set of
acceptable commands, their syntax, and semantics\&.
.sp
The result of the method is the result generated by the last file
command it executed\&.
.PP
.SH "FILE API"
Both object constructor and method \fBdo\fR take a list of words
and interpret them as file commands to execute\&. The names were chosen
to allow the construction of operations as sentences in near-natural
language\&. Most of the commands influence just the state of the object,
i\&.e\&. are simply providing the configuration used by the command
triggering the actual action\&.
.TP
\fBinto\fR \fIdirectory\fR
Specifies the destination directory for operations\&.
.TP
\fBin\fR \fIdirectory\fR
Alias for \fBinto\fR\&.
.TP
\fBto\fR \fIdirectory\fR
Alias for \fBinto\fR\&.
.TP
\fBfrom\fR \fIdirectory\fR
Specifies the source directory for operations\&.
.TP
\fBnot\fR \fIpattern\fR
Specifies a glob pattern for paths to be excluded from the operation\&.
.TP
\fBfor\fR \fIpattern\fR
Alias for \fBnot\fR\&.
.TP
\fBexclude\fR \fIpattern\fR
Alias for \fBnot\fR\&.
.TP
\fBbut\fR
Has no arguments of its own, but looks ahead in the list of words and
executes all \fBnot\fR commands immediately following it\&. This allows the
construction of "but not" and "but exclude" clauses for a more natural
sounding specification of excluded paths\&.
.TP
\fBexcept\fR
A semi-alias for \fBbut\fR\&. Has no arguments of its own, but looks
ahead in the list of words and executes all \fBfor\fR commands
immediately following it\&. This allows the construction of "except for"
clauses for a more natural sounding specification of excluded paths\&.
.TP
\fBas\fR \fIname\fR
Specifies a new name for the first file handled by the current
operation\&. I\&.e\&. for the renaming of a single file during the
operation\&.
.TP
\fBrecursive\fR
Signals that file expansion should happen in the whole directory
hierarchy and not just the directory itself\&.
.TP
\fBrecursively\fR
An alias for \fBrecursive\fR\&.
.TP
\fBcopy\fR
Signals that the operation is the copying of files from source to
destination directory per the specified inclusion and exclusion
patterns\&.
.TP
\fBmove\fR
Signals that the operation is the moving of files from source to
destination directory per the specified inclusion and exclusion
patterns\&.
.TP
\fBremove\fR
Signals that the operation is the removal of files in the destination
directory per the specified inclusion and exclusion patterns\&.
.TP
\fBexpand\fR
Signals that there is no operation but the calculation of the set of
files from the include and exclude patterns\&. This operation is not
available if \fBthe-set\fR is used\&.
.TP
\fBinvoke\fR \fIcmdprefix\fR
Signals that the user-specified command prefix \fIcmdprefix\fR is the
operation to perform\&. The command prefix is executed at the global
level and given the source directory, destination directory, and set
of files (as dictionary mapping from source to destination files), in
this order\&.
.TP
\fBreset\fR
Forces the object into the ground state where all parts of the
configuration have default values\&.
.TP
\fB(\fR
Saves a copy of the current object state on a stack\&.
.TP
\fB)\fR
Takes the state at the top of the state stack and restores it,
i\&.e\&. makes it the new current object state\&.
.TP
\fBcd\fR \fIdirectory\fR
Changes the destination directory to the sub-directory \fIdirectory\fR
of the current destination\&.
.TP
\fBup\fR
Changes the destination directory to the parent directory of the
current destination\&.
.TP
\fBfor-windows\fR
Checks that Windows is the current platform\&. Aborts processing if not\&.
.TP
\fBfor-win\fR
An alias for \fBfor-windows\fR\&.
.TP
\fBfor-unix\fR
Checks that Unix is the current platform\&. Aborts processing if not\&.
.TP
\fBthe\fR \fIpattern\fR
This command specifies the files to operate on per a glob pattern, and
is also the active element, i\&.e\&. the command which actually performs
the specified operation\&. All the other commands only modified the
object state to set the operation up, but di nothing else\&.
.sp
To allow for a more natural sounding syntax this command also looks
ahead in the list of words looks and executes several commands
immediately following it before performing its own actions\&.
These commands are \fBas\fR, \fBbut\fR, \fBexclude\fR, \fBexcept\fR,
\fBfrom\fR, and \fBinto\fR (and aliases)\&. That way these commands act
like qualifiers, and still take effect as if they had been written
before this command\&.
.sp
After the operation has been performed the object state the exclude
patterns and the alias name, if specified, are reset to their default
values (i\&.e\&. empty), but nothing else\&.
.TP
\fBthe-set\fR \fIvarname\fR
Like \fBthe\fR, however the set of files to use is not specified
implicitly per a glob pattern, but contained and loaded from the
specified variable\&. The operation \fBexpand\fR is not available
if this command is used\&.
.TP
\fB->\fR \fIvarname\fR
Saves the set of files from the last expansion into the specified
variable\&.
.TP
\fBstrict\fR
Make file expansion and definition of destination directory (\fBin\fR
and aliases) strict, i\&.e\&. report errors for missing directories, and
empty expansion\&.
.TP
\fB!strict\fR
Complement of \fBstrict\fR\&. A missing destination directory or empty
expansion are not reported as errors\&.
.TP
\fBfiles\fR
Limit the search to files\&. Default is to accept every type of path\&.
.TP
\fBlinks\fR
Limit the search to symbolic links\&. Default is to accept every type of path\&.
.TP
\fBdirectories\fR
Limit the search to directories\&. Default is to accept every type of path\&.
.TP
\fBdirs\fR
An alias for \fBdirectories\fR\&.
.TP
\fBall\fR
Accept all types of paths (default)\&.
.TP
\fBstate?\fR
Returns the current state of the object as dictionary\&. The dictionary keys and their meanings are:
.RS
.TP
\fBas\fR
Last setting made by \fBas\fR\&.
.TP
\fBexcluded\fR
List of currently known exclusion patterns\&.
.TP
\fBfrom\fR
Current source directory, set by \fBfrom\fR\&.
.TP
\fBinto\fR
Current destination directory, set by \fBinto\fR (and aliases)\&.
.TP
\fBoperation\fR
Current operation to perform, set by \fBcopy\fR, \fBmove\fR, \fBremove\fR, \fBexpand\fR, or \fBinvoke\fR\&.
.TP
\fBrecursive\fR
Current recursion status\&. Set/unset by \fBrecursive\fR and \fB!recursive\fR\&.
.TP
\fBstrict\fR
Current strictness\&. Set/unset by \fBstrict\fR and \fB!strict\fR\&.
.TP
\fBtype\fR
Current path type limiter\&. Set by either \fBfiles\fR, \fBdirectories\fR, \fBlinks\fR, or \fBall\fR\&.
.RE
.TP
\fBas?\fR
Returns the current alias name\&.
.TP
\fBexcluded?\fR
Returns the current set of exclusion patterns\&.
.TP
\fBfrom?\fR
Returns the current source directory\&.
.TP
\fBinto?\fR
Returns the current destination directory\&.
.TP
\fBoperation?\fR
Returns the current operation to perform\&.
.TP
\fBrecursive?\fR
Returns the current recursion status\&.
.TP
\fBstrict?\fR
Returns the current strictness\&.
.TP
\fBtype?\fR
Returns the current path type limiter\&.
.PP
.SH EXAMPLES
The following examples assume that the variable \fBF\fR contains a
reference to a multi-file operation object\&.
.CS


    $F do copy                       \\\\
	the  *\&.dll                    \\\\
	from c:/TDK/PrivateOpenSSL/bin \\\\
	to   [installdir_of tls]

.CE
.CS


    $F do move      \\\\
	the  *       \\\\
	from /sources \\\\
	into /scratch  \\\\
	but not *\&.html

    # Alternatively use 'except for *\&.html'\&.

.CE
.CS


    $F do           \\\\
	move         \\\\
	the  index    \\\\
	from /sources  \\\\
	into /scratch   \\\\
	as   pkgIndex\&.tcl

.CE
.CS


    $F do         \\\\
	remove     \\\\
	the *\&.txt  \\\\
	in /scratch

.CE
Note that the fact that most commands just modify the object state
allows us to use more off forms as specifications instead of just
nearly-natural language sentences\&.
For example the second example in this section can re-arranged into:
.CS


    $F do            \\\\
	from /sources \\\\
	into /scratch  \\\\
	but not *\&.html \\\\
	move           \\\\
	the  *

.CE
and the result is not only still a valid specification, but even stays
relatively readable\&.
.PP
Further note that the information collected by the commands \fBbut\fR,
\fBexcept\fR, and \fBas\fR is automatically reset after the associated
\fBthe\fR was executed\&. However no other state is reset in that
manner, allowing the user to avoid repetitions of unchanging
information\&. For example the second and third examples of this section
can be merged and rewritten into the equivalent:
.CS


$F do                   \\\\
    move                 \\\\
    the  *                \\\\
    from /sources          \\\\
    into /scratch           \\\\
    but not *\&.html not index \\\\
    the  index               \\\\
    as   pkgIndex\&.tcl

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIfileutil\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
copy, file utilities, move, multi-file, remove
.SH CATEGORY
Programming tools