package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIpv4GatewayAttribute invokes the vpc.UpdateIpv4GatewayAttribute API synchronously
func (client *Client) UpdateIpv4GatewayAttribute(request *UpdateIpv4GatewayAttributeRequest) (response *UpdateIpv4GatewayAttributeResponse, err error) {
	response = CreateUpdateIpv4GatewayAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIpv4GatewayAttributeWithChan invokes the vpc.UpdateIpv4GatewayAttribute API asynchronously
func (client *Client) UpdateIpv4GatewayAttributeWithChan(request *UpdateIpv4GatewayAttributeRequest) (<-chan *UpdateIpv4GatewayAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateIpv4GatewayAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIpv4GatewayAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIpv4GatewayAttributeWithCallback invokes the vpc.UpdateIpv4GatewayAttribute API asynchronously
func (client *Client) UpdateIpv4GatewayAttributeWithCallback(request *UpdateIpv4GatewayAttributeRequest, callback func(response *UpdateIpv4GatewayAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIpv4GatewayAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateIpv4GatewayAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIpv4GatewayAttributeRequest is the request struct for api UpdateIpv4GatewayAttribute
type UpdateIpv4GatewayAttributeRequest struct {
	*requests.RpcRequest
	Ipv4GatewayDescription string           `position:"Query" name:"Ipv4GatewayDescription"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	Ipv4GatewayName        string           `position:"Query" name:"Ipv4GatewayName"`
	Ipv4GatewayId          string           `position:"Query" name:"Ipv4GatewayId"`
	DryRun                 requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateIpv4GatewayAttributeResponse is the response struct for api UpdateIpv4GatewayAttribute
type UpdateIpv4GatewayAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateIpv4GatewayAttributeRequest creates a request to invoke UpdateIpv4GatewayAttribute API
func CreateUpdateIpv4GatewayAttributeRequest() (request *UpdateIpv4GatewayAttributeRequest) {
	request = &UpdateIpv4GatewayAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateIpv4GatewayAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateIpv4GatewayAttributeResponse creates a response to parse from UpdateIpv4GatewayAttribute response
func CreateUpdateIpv4GatewayAttributeResponse() (response *UpdateIpv4GatewayAttributeResponse) {
	response = &UpdateIpv4GatewayAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
