/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"
#ifdef HAVE_SDL


struct cor *cor = NULL;
static struct cor *cor2 = NULL;

struct kmarray *kmarray_new(void){
    struct kmarray *kma;

    kma = g_new0(struct kmarray, 1);
    kma->size=100;
    kma->data=g_new0(struct kmpoint, kma->size);
    return kma;
}

void kmarray_add(GHashTable *hash, gpointer key, struct kmpoint *km){
	struct kmarray *kma;
	gpointer orig_key, value;
	
	if (g_hash_table_lookup_extended(hash, key, &orig_key, &value)){
		kma=(struct kmarray *)value;
	}else{
		kma=kmarray_new();
	 /*   dbg("new kma for %p: %p\n",key,  kma);*/
		g_hash_table_insert(hash, key, kma);
	}
		
    if (kma->len == kma->size){
        kma->size+=100; 
        kma->data = g_renew(struct kmpoint, kma->data, kma->size);
    }
    memcpy(&kma->data[kma->len], km, sizeof(struct kmpoint));    
    kma->len++;
}


#define TO_READ 1000


struct cor *init_cor(){
	struct cor *cor;

    cor = g_new0(struct cor, 1);
	cor->km = g_hash_table_new(g_direct_hash, g_direct_equal);
	cor->wwl4 = g_hash_table_new(g_direct_hash, g_direct_equal);
	cor->wwl2 = g_hash_table_new(g_direct_hash, g_direct_equal);
    cor->thread_break = 0;
	cor->file=cor_tucnakcor;
	cor->items=COR_ITEMS;
    return cor;
}

void free_cor(struct cor *cor){

	if (!cor) return;

    if (cor2 && cor2->thread){
        cor2->thread_break = 1;
        //dbg("join cor...\n");
        g_thread_join(cor2->thread);
        //dbg("done\n");
        cor2->thread = NULL;
    }
	g_hash_table_foreach_remove(cor->km, free_km_item, NULL); 
	g_hash_table_foreach_remove(cor->wwl4, free_km_item, NULL); 
	g_hash_table_foreach_remove(cor->wwl2, free_km_item, NULL); 
	
    g_free(cor);
}

int cor_recalc(struct subwin *sw, gchar *locator){ 
   // dbg("cor_recalc('%s', '%s') %d %d\n", sw->title, locator, sw->myh, sw->myw);
    if (cor2) {
        free_cor(cor2);
    }
    cor2 = init_cor();
    cor2->sw_myw = sw->myw;
    cor2->sw_myh = sw->myh;
    cor2->thread = g_thread_create(cor_thread_func, (gpointer)cor2, TRUE, NULL);
    if (!cor2->thread) internal_("Can't run cor thread");
    return 0;
}


gpointer cor_thread_func(gpointer arg){ 
    int i,j, ret;
	const struct cpoint *cp;
    struct kmpoint km, kmfirst, kmlast;
	double h2, w2;
    gpointer hash, oldhash;
	int kx, ky, color;
    struct cor *cor = (struct cor *)arg;
    char s[16];
	
   /* dbg("recalc_cor(%s)\n", locator);*/
   /* return 0; */
//    ST_START;

    kmfirst.c=0;
    //dbg("cor_thread_func: items=%d %f %f\n", cor->items, cor->sw_myh, cor->sw_myw);
	g_hash_table_foreach_remove(cor->km, free_km_item, NULL); 
    oldhash=(gpointer)-1;
	for (i=0, cp=cor->file; i<cor->items; i++, cp++){
        if (cor->thread_break) return NULL;
        w2=(MY_PI*(double)cp->w)/18000;
		h2=(MY_PI*(double)cp->h)/18000;
		hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
		hash=k2key(kx, ky);
		km.c=cp->c;
		km.kx=kx;
		km.ky=ky;
		if (km.c<0) {
			memcpy(&kmfirst, &km, sizeof(kmfirst));
		}
		if (oldhash!=(gpointer)-1 && hash!=oldhash) {
			kmarray_add(cor->km, oldhash, &km);
			kmlast.c=kmfirst.c;
            kmarray_add(cor->km, hash, &kmlast);
		}    
			
		kmarray_add(cor->km, hash, &km);
		memcpy(&kmlast, &km, sizeof(kmlast));
		oldhash=hash;
	}
    
    /* big wwls (JN69) */
	g_hash_table_foreach_remove(cor->wwl4, free_km_item, NULL); 
    for (i=-89;i<90;i++){
        if (cor->thread_break) return NULL;
        if (i%10==0) color=-128;
        else color=-127;
        oldhash=(gpointer)-1;
        km.c=color;
        for (j=0;j<=360;j++){
            w2=(MY_PI*i)/180;
            h2=(MY_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl4, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl4, hash, &kmlast);
                km.c=0;
            }
            
            kmarray_add(cor->wwl4, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            
            oldhash=hash;
            km.c=0;
        }
    }
    for (j=0;j<360;j+=2){
        if (cor->thread_break) return NULL;
        oldhash=(gpointer)-1;
        if (j%20==0) color=-128;
        else color=-127;
        km.c=color;
        for (i=-89;i<=89;i++){
            w2=(MY_PI*i)/180;
            h2=(MY_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl4, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl4, hash, &kmlast);
                km.c=0;
            }
            kmarray_add(cor->wwl4, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            oldhash=hash;
            km.c=0;
        }
    } 
    /* very big wwls (JN) */
	g_hash_table_foreach_remove(cor->wwl2, free_km_item, NULL); 
    for (i=-80;i<90;i+=10){
        if (cor->thread_break) return NULL;
        if (i%10==0) color=-128;
        else color=-127;
        oldhash=(gpointer)-1;
        km.c=color;
        for (j=0;j<=360;j++){
            w2=(MY_PI*i)/180;
            h2=(MY_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl2, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl2, hash, &kmlast);
                km.c=0;
            }
            
            kmarray_add(cor->wwl2, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            
            oldhash=hash;
            km.c=0;
        }
    }
    for (j=0;j<360;j+=20){
        if (cor->thread_break) return NULL;
        oldhash=(gpointer)-1;
        if (j%10==0) color=-128;
        else color=-127;
        km.c=color;
        for (i=-89;i<=89;i++){
            w2=(MY_PI*i)/180;
            h2=(MY_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl2, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl2, hash, &kmlast);
                km.c=0;
            }
            kmarray_add(cor->wwl2, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            oldhash=hash;
            km.c=0;
        }
    } 
//    ST_STOP;
   // sleep(5); 

    sprintf(s, "COR\n");
    ret = write(tpipe->threadpipe_write, s, strlen(s));
	return NULL;
}

void cor_read_handler(char *line){
//    dbg("cor_read_handler\n");
    if (!cor2 || !cor2->thread) return;

    free_cor(cor);
    cor = cor2;
    cor2 = NULL;
    if (gses->ontop->type!=SWT_MAP) return;
    gses->ontop->gdirty = 1;
    sw_map_redraw(gses->ontop, 0);
}



gboolean free_km_item(gpointer key, gpointer value, gpointer user_data){
	struct kmarray *kma;

	/* key is int, not freeed */
	kma=(struct kmarray *) value;
   	if (!kma) return 0;
	g_free(kma->data);
	g_free(kma);
    return 1;
}


gpointer k2key(int kx, int ky){
	return (gpointer)(vint)( (kx & COR_KM_MASK) | ( (ky & COR_KM_MASK) << 16)) ; 
}


#endif
