/*
    player - WAV player
    Copyright (C) 2010 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#if defined(HAVE_SNDFILE)

int sw_player_kbd_func(struct subwin *sw, struct event *ev, int fw){
    switch(kbd_action(KM_MAIN,ev)){
        case ACT_LEFT:
            if (!ssbd) break;
            MUTEX_LOCK(ssbd->seek);
            ssbd->seek -= 2000;
            MUTEX_UNLOCK(ssbd->seek);
            return 1;
        case ACT_RIGHT:
            if (!ssbd) break;
            MUTEX_LOCK(ssbd->seek);
            ssbd->seek += 1000;
            MUTEX_UNLOCK(ssbd->seek);
            return 1;
        case ACT_DOWN:
            if (!ssbd) break;
            MUTEX_LOCK(ssbd->seek);
            ssbd->seek -= 10000;
            MUTEX_UNLOCK(ssbd->seek);
            return 1;
        case ACT_UP:
            if (!ssbd) break;
            MUTEX_LOCK(ssbd->seek);
            ssbd->seek += 10000;
            MUTEX_UNLOCK(ssbd->seek);
            return 1;
    }

    return 0;
}

int sw_player_mouse_func(struct subwin *sw, struct event *ev, int fw){
//    if (!sdl) return 0;
    return 0;
}


void sw_player_redraw(struct subwin *sw, int flags){
    int i, j, x, y0, y, c;
    int prev_y, prev_h, play_y, play_h;

    //dbg("sw_player_redraw(%d)\n", sw->gdirty);
    if (sw->pl_rate == 0) return;
    if (sw->pl_channels == 0) return;
#ifdef HAVE_SDL    
    SDL_Rect area;
    if (sdl) {
        if (sw->h - PLAYER_H <= 0) return;

        prev_y = 0;
        prev_h = PREVIEW_H * FONT_H; 
        play_y = PREVIEW_H * FONT_H;
        play_h = sw->screen->h - (PREVIEW_H) * FONT_H; // PLAYER_H is included in sw->screen->h

        fill_area(sw->x, sw->y, sw->w, sw->h - PLAYER_H , 0);
/*	area.x = 0;
	area.y = prev_y;
	area.w = sw->screen->w;
	area.h = prev_h;
    SDL_FillRect(sw->screen, &area, makecol(20, 20, 20));*/
        if (sw->pl_preview_screen){
            SDL_BlitSurface(sw->pl_preview_screen, NULL, sw->screen, NULL);
            x = ((long long)sw->pl_preview_w * ssbd->played) / sw->pl_len;
            line(sw->screen, x, prev_y, x, prev_y + prev_h, sdl->gr[8]);
        }


        area.x = 0;
        area.y = play_y;
        area.w = sw->screen->w;
        area.h = play_h;
        SDL_FillRect(sw->screen, &area, makecol(40, 40, 40));
 
        //dbg("shapelen=%d channels=%d\n", sw->pl_shapelen, sw->pl_channels);
        if (sw->pl_pxlen == 0) return;
        c = sdl->green;
        sw_player_check_bounds(sw);
        int cursor = ssbd->played / sw->pl_pxlen;
        for (x = 0; x < sw->screen->w; x++){
            i = x + sw->pl_ofs;
            if (i >= sw->pl_shapelen) continue;
            if (i < 0) continue;
        
            for (j = 0; j < sw->pl_channels; j++){
                y0 = play_y + play_h / (2 * sw->pl_channels);
                y = (sw->pl_shapebuf[i * sw->pl_channels + j] * play_h / 2) / (sw->pl_channels * 256);
                if (cursor == i){
                    y = play_h / (sw->pl_channels * 2);
                    line(sw->screen, x, y0+y, x, y0-y, sdl->gr[15]);
                }else{
                    line(sw->screen, x, y0+y, x, y0-y, c);
                }
            }
        }
    
    }
#endif
    int dsec1 = (10 * ssbd->played) / (sw->pl_rate * sw->pl_channels);
    int dsec2 = (10 * sw->pl_len) / (sw->pl_rate * sw->pl_channels);
    clip_printf(sw, 1, sw->h - PLAYER_H, COL_NORM, "%d:%02d.%d / %d:%02d.%d", dsec1 / 600, (dsec1 % 600)/10, dsec1 % 10, dsec2 / 600, (dsec2 % 600)/10, dsec2 % 10);
}

void sw_player_check_bounds(struct subwin *sw){
#ifdef HAVE_SDL
    if (!sdl) return;
    if (sw->pl_pxlen == 0) return;

    int cursor = ssbd->played / sw->pl_pxlen;

    if (cursor - sw->pl_ofs < 0){
        sw->pl_ofs = cursor - sw->screen->w / 5;
    }

    if (cursor - sw->pl_ofs > (sw->screen->w * 4) / 5){
        sw->pl_ofs = cursor - (sw->screen->w * 4) / 5;
    }
#endif
}

void sw_player_raise(struct subwin *sw){
#ifdef HAVE_SDL
    sw->gdirty=1;      
#endif
}

void sw_player_free(struct subwin *sw){
#ifdef HAVE_SDL
    CONDGFREE(sw->pl_shapebuf);
    if (sw->pl_preview_screen) SDL_FreeSurface(sw->pl_preview_screen);
#endif
}

#define MS2PX 20

void player_play(char *filename){
    struct subwin *sw;
    int i, j;
    SF_INFO sfinfo;
    SNDFILE *sf;
    short *pxbuf, *sh;
    double *sum;
    short *avg;
    short *max;
    int shapei = 0;

    for (i=0; i<gses->subwins->len; i++){
        sw = (struct subwin *)g_ptr_array_index(gses->subwins, i);
        if (sw->type != SWT_PLAYER) continue;
        sw_set_ontop(i, 0);
        goto found;
    }
    sw = new_subwin(SWT_PLAYER, VTEXT(T_SW_PLAYER), NULL);
    sw_set_ontop(gses->subwins->len-1, 0);

found:;    
    redraw_later();
#ifdef HAVE_SDL
    sw->gdirty=1;
#endif

    sw->pl_len = 0;
    sw->pl_channels = 1;
    memset (&sfinfo, 0, sizeof (sfinfo));
    sf = sf_open(filename, SFM_READ, &sfinfo);
    if (!sf) {
        log_addf("Can't play %s - %s", filename, sf_strerror (NULL));
        return;
    }

    sw->pl_len = sf_seek(sf, 0L, SEEK_END);
    if (sw->pl_len < 0) {
        log_addf("Can't seek to end %s - %s", filename, sf_strerror(sf));
        sf_close(sf);
        return;
    }

    if (sf_seek(sf, 0L, SEEK_SET) < 0) {
        log_addf("Can't seek to start %s - %s", filename, sf_strerror(sf));
        sf_close(sf);
        return;
    }

    sw->pl_channels = sfinfo.channels;
    sw->pl_rate = sfinfo.samplerate;
    sw->pl_pxlen = sw->pl_channels * sw->pl_rate * MS2PX / 1000;

    dbg("pl_len=%d pxlen=%d\n", sw->pl_len, sw->pl_pxlen);
    CONDGFREE(sw->pl_shapebuf);
    sw->pl_shapebuf = (unsigned char *)g_new0(char, sw->pl_channels * (sw->pl_len / sw->pl_pxlen)+1);
    sw->pl_shapelen = 0;

#ifdef HAVE_SDL
    if (sw->pl_preview_screen) SDL_FreeSurface(sw->pl_preview_screen);
    sw->pl_preview_screen = SDL_CreateRGBSurface(SDL_SWSURFACE, sw->screen->w, PREVIEW_H * FONT_H, sdl->bpp, 
                    sdl->screen->format->Rmask, sdl->screen->format->Gmask, sdl->screen->format->Gmask, 0);
    sw->pl_preview_w = sw->pl_preview_screen->w;
    SDL_FillRect(sw->pl_preview_screen, NULL, makecol(20, 20, 20));

    pxbuf = g_new0(short, sw->pl_pxlen);
    sum = g_new0(double, sw->pl_channels);
    avg = g_new0(short, sw->pl_channels);
    max = g_new0(short, sw->pl_channels);
    shapei = 0;
    int readed = 0;
    while(1){
        int readlen = sf_read_short(sf, pxbuf, sw->pl_pxlen);

        if (readlen <= 0) break;

        readed += readlen;
        for (j = 0; j < sw->pl_channels; j++) {
            sum[j] = 0.0;
            max[j] = 0;
        }

        sh = pxbuf;
        for (i = 0; i < readlen; i++){
            for (j = 0; j < sw->pl_channels; j++){
                sum[j] += *sh;
                sh++;
            }
        }

        for (j = 0; j < sw->pl_channels; j++) avg[j] = (short)(sum[j] / readlen);

        sh = pxbuf;
        for (i = 0; i < readlen; i++){
            for (j = 0; j < sw->pl_channels; j++){
                int d = *sh - avg[j];
                if (d < 0) d = -d;
                if (d > max[j]) max[j] = d;
                sh++;
            }
        }

        int prev_sh = 0;
        for (j = 0; j < sw->pl_channels; j++) {
            int shape = 0;
          //  dbg("max[%d]=%5d ", j, max[j]);
            if (max[j] == 0) {
                shape = 0;
            }else{
                //shape = log(max[j]) * 256.0 / log(32768);
                shape = max[j] * 256.0 / 32768;
                if (shape > 255) shape = 255;
            }
           // dbg("shape=%3d ", shape);
            sw->pl_shapebuf[shapei] = shape;
            shapei++;
            prev_sh += shape;
        }
        //dbg("\n");
        int x = ((long long)sw->pl_preview_screen->w * readed) / sw->pl_len;
        int y0 = sw->pl_preview_screen->h / 2;
        int y = sw->pl_preview_screen->h * prev_sh / (2 * 256 * sw->pl_channels);
        line(sw->pl_preview_screen, x, y0+y, x, y0-y, makecol(0, 128, 0));

        sw->pl_shapelen++;

    }
    g_free(pxbuf);
    g_free(sum);
    g_free(avg);
    g_free(max);
#endif
    sf_close(sf);
    
    ssbd_play_file(ssbd, filename);
    gses->icon=ssbd->playicon;
}

#else
int sw_player_kbd_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

int sw_player_mouse_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

void sw_player_redraw(struct subwin *sw, int flags){
}

void sw_player_check_bounds(struct subwin *sw){
}

void sw_player_raise(struct subwin *sw){
}

#endif
