/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or 
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

28.Oct 2008:
Modification by dl5ybz  for fast fix .. this file needs review by Lada (or anyone else who codes in C) ..!
Winkey2 works for me  so far now  73 de Olaf / DL5YBZ

    Documentation: http://k1el.tripod.com/files/WinkeyInterfaceGuide.pdf
*/

#include "header.h"

int winkey_init(struct cwdaemon *cwda){
    cwda->fd = -1;
    winkey_open(cwda, 1);
    return 0;
}

int winkey_open(struct cwdaemon *cwda, int verbose){
    struct termios tio;
    char errbuf[1024];
    char s[16];
    int i, ret;
    
    dbg("winkey_open(verbose=%d)\n", verbose);
    if (cwda->fd >= 0) return 0;
    ST_START;
    
    ret = fhs_lock(cfg->cwda_device, 1);
    if (ret){
        fhs_error(errbuf, sizeof(errbuf), ret, cfg->cwda_device);
        log_addf("CW keying winkey error: %s", errbuf);
        return -2;
    }
    cwda->ttys_locked = 1;
    
    cwda->fd = open(cfg->cwda_device, O_RDWR | O_NOCTTY);
    if (cwda->fd < 0){
        if (verbose) log_addf("Can't open %s %s", cfg->cwda_device, strerror_r(errno, errbuf, sizeof(errbuf)));
        winkey_reset(cwda);
        winkey_free(cwda);
        return -1;
    }
    
    if (fcntl(cwda->fd,F_SETFL,O_NONBLOCK)) {
        if (verbose) log_addf("Can't set O_NONBLOCK on %s: %s",cfg->cwda_device, strerror_r(errno, errbuf, sizeof(errbuf)) );
        winkey_free(cwda);
        return -4;
    }
    
    // set 1200 baud, 8bit, no parity, two stop bits
    tcgetattr(cwda->fd,&tio);
    tio.c_cflag=B1200|CS8|CLOCAL|CREAD|CSTOPB;
    tio.c_iflag=INPCK;
    tio.c_lflag=0;
    tio.c_oflag=0;
    tio.c_cc[VMIN]=1;
    tio.c_cc[VTIME]=5;
    tcsetattr(cwda->fd,TCSANOW,&tio);
    
    // to power up enable DTR and disable RTS
    i = TIOCM_DTR; 
    ioctl (cwda->fd, TIOCMBIS, &i); /* set DTR */
    i = TIOCM_RTS; 
    ioctl (cwda->fd, TIOCMBIC, &i); /* clear RTS */
    
    if (!cfg->wk_wk2){
        // delay 500ms for winkey init
        usleep(500000); 

        // calibration command
        ret = write(cwda->fd, "\x00\x00", 2); 
        usleep(100000); 
        ret = write(cwda->fd, "\xff", 1); 
    }

    // is winkey attached? echo command
	ret = write(cwda->fd, "\x00\x04\x55", 3);
    i = winkey_read(cwda, 1000000);
//    dbg("winkey_read: %d\n", i);
    if (i < 0){
        if (verbose) log_addf(CTEXT(T_CANT_INIT_WINKEY_S), cfg->cwda_device);
        winkey_free(cwda);
        return -1;
    }
    
    // open winkey hostmode
    ret = write(cwda->fd, "\x00\x02", 2);
    i = winkey_read(cwda, 500000);
//    dbg("winkey_read: %d\n", i);
    if (i < 0){
        if (verbose) log_addf("Can't open winkey hostmode");
        winkey_free(cwda);
        return -1;
    }
    cwda->winkey_version = (unsigned char)i;

    if (cwda->winkey_version >= 20){ // >= 2.0
        // set WK2 mode
        ret = write(cwda->fd, "\x00\x0b", 2);
        
    }

    
#if 0
    // load default settings
    write(cwda->fd, "\x0f"); // command
    write(cwda->fd, "\x"); // mode register
    write(cwda->fd, "\x"); // speed
    write(cwda->fd, "\x"); // stconst
    write(cwda->fd, "\x"); // weight
    write(cwda->fd, "\x"); // leadin
    write(cwda->fd, "\x"); // tail
    write(cwda->fd, "\x"); // minwpm
    write(cwda->fd, "\x"); // wpmrange
    write(cwda->fd, "\x"); // xtnd
    write(cwda->fd, "\x"); // kcomp
    write(cwda->fd, "\x"); // farns
    write(cwda->fd, "\x"); // sampadj
    write(cwda->fd, "\x"); // ditdatratio
    write(cwda->fd, "\x"); // pincfg
    write(cwda->fd, "\x"); // potrange
#endif    

    // setup speed pot
    sprintf(s, "\x05%c\x1f\xff", cfg->cwda_minwpm);
    ret = write(cwda->fd, s, 4);

    // winkey2 mode
    if (cwda->winkey_version >= 20){
        s[0] = '\x0e';
        s[1] = ((cfg->wk_keymode-1)&0x03) << 4;
        if (cfg->wk_swap) s[1] |= 0x08;
        //dbg("wk_keymode=%d winkey2 mode=0x%02x\n", cfg->wk_keymode, s[1]);
        ret = write(cwda->fd, s, 2);
    }
    
    
    // force to send speed pot value
    ret = write(cwda->fd, "\x07", 1); 

    // force to send status
    ret = write(cwda->fd, "\x15", 1); 
    
    // set PTT lead in 
    s[0] = '\04';
    s[1] = cfg->cwda_leadin / 10;
    s[2] = '\x01';                  // \x00 means something strange, see winkeyusbman.pdf 
    ret = write(cwda->fd, s, 3);
    
    set_handlers(cwda->fd, winkey_read_handler, NULL, NULL, (cba_t)cwda);
    ST_STOP;
    return 0;
}

int winkey_free(struct cwdaemon *cwda){
    int i, ret;

    if (!cwda) return 0;

//	dbg("Winkey_CW_host leaving sequence\n");
	ret = write(cwda->fd, "\x0a", 1); /*clear Buffer*/
	ret = write(cwda->fd, "\x00\x03", 2); /*leave hostmode*/
    
    // clear DR
    i = TIOCM_DTR; 
    ioctl (cwda->fd, TIOCMBIC, &i); /* clear DTR */

    if (cwda->fd>=0){
        set_handlers(cwda->fd, NULL, NULL, NULL, (cba_t)cwda);
        close(cwda->fd);
        cwda->fd=-1;
    }
    if (cwda->ttys_locked) fhs_unlock(cfg->cwda_device);
    return 0;
}

int winkey_read(struct cwdaemon *cwda, int timeout_us){
    fd_set fds;
    struct timeval tv;
    unsigned char c;

    tv.tv_sec = 0;
    tv.tv_usec = timeout_us;

    FD_ZERO(&fds);
    FD_SET(cwda->fd, &fds);

    if (select(cwda->fd+1, &fds, NULL, NULL, &tv)==0) return -2;
    if (!FD_ISSET(cwda->fd, &fds)) return -3;
    if (read(cwda->fd, &c, 1) !=1) return -4;

    return (int)c;
}

int winkey_reset(struct cwdaemon *cwda){
    int ret;

    if (!cwda || cwda->fd<0) return 0;
    dbg("winkey_reset\n");
    ret = write(cwda->fd, "\x0a", 1);
    return 0;
}

int winkey_cw(struct cwdaemon *cwda, int onoff){
    return 0;
}

int winkey_ptt(struct cwdaemon *cwda, int onoff){
    char s[16];
    int ret;
    
    dbg("winkey_ptt(%d)\n", onoff);
    if (!cwda || cwda->fd<0) return 0;
    sprintf(s,"\x18%c", onoff ? '\x01' : '\x00');
    ret = write(cwda->fd, s, 2);
    return 0;
}

int winkey_ssbway(struct cwdaemon *cwda, int onoff){
    return 0;
}

int winkey_text(struct cwdaemon *cwda, char *text){
    char *c, *s, *d;
    int ret;
    
    dbg("winkey_text fd=%d\n", cwda->fd); 
    if (!cwda || cwda->fd<0) return 0;

    s = g_strdup(text);
    for (c=text, d=s; *c!='\0'; c++, d++) *d=toupper(*c); 
    
//    dbg("winkey_text('%s')\n", s);
    ret = write(cwda->fd, s, strlen(s)); 
    g_free(s);
    return 0;
}

int winkey_speed(struct cwdaemon *cwda, int wpm){
    char s[16];
    int ret;
    
    if (!cwda || cwda->fd<0) return 0;

    dbg("winkey_speed=%d\n", wpm);
    sprintf(s,"\x02%c", wpm);
    ret = write(cwda->fd, s, 2);
    return 0;
}

int winkey_weight(struct cwdaemon *cwda, int weight){
    char s[16];
    int ret;

    if (!cwda || cwda->fd<0) return 0;
    
    dbg("winkey_weight=%d\n", weight);
    sprintf(s,"\x03%c", weight );
    ret = write(cwda->fd, s, 2);
    return 0;
}

int winkey_tune(struct cwdaemon *cwda, int tune){
    char s[16];
    int ret;

    if (!cwda || cwda->fd<0) return 0;
    sprintf(s, "\x0b%c", tune ? '\x01' : '\x00');
    ret = write(cwda->fd, s, 2);
    return 0;
}

int winkey_back(struct cwdaemon *cwda){
    char s[16];
    int ret;
    
    if (!cwda || cwda->fd<0) return 0;

    strcpy(s, "\x08");
    ret = write(cwda->fd, s, 1);
    return 0;
}

void winkey_read_handler(cba_t cba){
    char s[1024], status;
    int ret, ret2, i, speed;
    struct cwdaemon *cwda;

    cwda = (struct cwdaemon*)GETCBA(cba, cwda);

    ret = read(cwda->fd, s, 1000);
    if (ret<=0) return;
//    dbg("winkey_read_handler(");
    for (i=0; i<ret; i++){
        if ((s[i] & 0xc0) == 0xc0){
            status = s[i];
//            dbg("status=%02x ", (unsigned char)status);
            if (status != cwda->winkey_oldstatus){
                if (cwda->winkey_version >= 20 && status & 0x08 && cfg->wk_usebut){     
                    // pushbutton status
//                    dbg("keys=%02x ", status & 0x17);
                    if      ((status&0x01) && (cwda->winkey_oldstatus&0x01)==0) cq_run_by_number(0);
                    else if ((status&0x02) && (cwda->winkey_oldstatus&0x02)==0) cq_run_by_number(1);
                    else if ((status&0x04) && (cwda->winkey_oldstatus&0x04)==0) cq_run_by_number(2);
                    else if ((status&0x10) && (cwda->winkey_oldstatus&0x10)==0) cq_run_by_number(3);
                    
                }else{
                    // status
                    if (status & 0x02){
//                        dbg("break in ");
                        ret2 = write(tpipe->threadpipe_write, "CW;b\n", 5);
                    }else if ((cwda->winkey_oldstatus & 0x04) != 0 && 
                             (status & 0x04) == 0){
//                        dbg("text played cq=%p ", gses->last_cq);
                        ret2 = write(tpipe->threadpipe_write, "CW;e\n", 5);
                    }
                }
                cwda->winkey_oldstatus = status;
            }
            
        }else if ((s[i] & 0xc0) == 0x80){
            speed = (s[i] & 0x1f) + cfg->cwda_minwpm;
            if (cfg->wk_usepot && speed != cwda->speed){
                cwda->speed = speed;
                dbg("pot=%d WPM  (s[i]=0x%x)\n`", cwda->speed, (unsigned char)s[i]);
                if (cwda->sspeed) cwda->sspeed(cwda, cwda->speed);
                redraw_later();
            }
            
        }else{
//            dbg("char=%c ", s[i]);
        }
    }
//    dbg(")\r\n");
}



int winkey4_init(struct cwdaemon *cwda){
    winkey_init(cwda);
#ifdef HAVE_LIBFTDI
    davac4_init(cwda);
#endif
    return 0;
}
                        
int winkey4_free(struct cwdaemon *cwda){
    winkey_free(cwda);
#ifdef HAVE_LIBFTDI
    davac4_free(cwda);
#endif
    return 0;
}

int winkey4_reset(struct cwdaemon *cwda){
    winkey_reset(cwda);
#ifdef HAVE_LIBFTDI
    davac4_reset(cwda);
#endif
    return 0;
}
