/******************************************************************************
 * Copyright (c) 2002 - 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *****************************************************************************/
package com.ibm.wala.cast.js.translator;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.classLoader.SourceModule;

/**
 * Factory interface for creating translators that generate the CAst for some
 * JavaScript source file. Used to abstract which JavaScript parser is being
 * used.
 */
public interface JavaScriptTranslatorFactory {

  TranslatorToCAst make(CAst ast, SourceModule M);

}
