.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
tessellimage - Converts an image to triangles using Delaunay tessellation.
.SH SYNOPSIS
.B tessellimage
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-duration \fInumber\fP]
[\-duration2 \fInumber\fP]
[\-max-depth \fInumber\fP]
[\-max-resolution \fIpixels\fP]
[\-no-outline]
[\-no-fill-screen]
[\-fps]
.SH DESCRIPTION
Converts an image to triangles using Delaunay tessellation, and animates
the result at various depths. More triangles are allocated to visually
complex parts of the image. This is accomplished by first computing the
first derivative of the image: the distance between each pixel and its
neighbors. Then the Delaunay control points are chosen by selecting those
pixels whose distance value is above a certain threshold: those are the
pixels that have the largest change in color/brightness. 
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds).
.TP 8
.B \-duration \fInumber\fP
Length of time until loading a new image. Default: 2 minutes.
.TP 8
.B \-duration2 \fInumber\fP
Length of time until increasing or decreasing the triangulation depth.
Default: 0.4 seconds.
.TP 8
.B \-max-depth \fInumber\fP
The maximum number of triangles to render.  Default: 40000.
.TP 8
.B \-max-resolution \fIpixels\fP
The size of the loaded image will be constrained to this width or
height, to reduce the number of pixels examined.  Think of it as
an initial low-pass filter.  Default 1024.
.TP 8
.B \-outline | \-no-outline
Whether to outline the triangles.
.TP 8
.B \-fill-screen | \-no-fill-screen
Whether to zoom in on the image to completely fill the screen,
or to center it.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2014-2018 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski.
